Summary: Utility for setting up encrypted disks
Name: cryptsetup
Version: 2.4.3
Release: 5%{?dist}.1
License: GPLv2+ and LGPLv2+
URL: https://gitlab.com/cryptsetup/cryptsetup
BuildRequires: openssl-devel, popt-devel, device-mapper-devel
BuildRequires: libuuid-devel, gcc, json-c-devel
BuildRequires: libpwquality-devel, libblkid-devel
BuildRequires: make
Requires: cryptsetup-libs = %{version}-%{release}
Requires: libpwquality >= 1.2.0

%global upstream_version %{version}
Source0: https://www.kernel.org/pub/linux/utils/cryptsetup/v2.4/cryptsetup-%{upstream_version}.tar.xz
# binary archive with updated compatimage.img.xz for testing (can not be patched via rpmbuild)
Source1: tests.tar.xz
Source2: tests_fips.tar.xz

# Following patch has to applied last
Patch0000: %{name}-2.5.0-Fix-typo-in-repair-prompt.patch
Patch0001: %{name}-2.5.0-Fix-PBKDF-benchmark-in-OpenSSL3-FIPS-mode.patch
Patch0002: %{name}-2.5.0-Get-rid-of-SHA1-in-tests.patch
Patch0003: %{name}-2.5.0-Do-not-use-too-small-key-in-tests.patch
Patch0004: %{name}-2.5.0-Fix-test-passphrase-when-device-in-reencryption.patch
Patch0005: %{name}-2.5.0-Add-more-tests-for-test-passphrase-parameter.patch
Patch0006: %{name}-2.5.1-Delegate-FIPS-mode-detection-to-configured-crypto-ba.patch
Patch0007: %{name}-2.6.1-Run-PBKDF-benchmark-with-8-bytes-long-well-known-pas.patch
Patch0008: %{name}-2.6.1-Change-tests-to-use-passphrases-with-minimal-8-chars.patch
Patch9998: %{name}-Add-FIPS-related-error-message-in-keyslot-add-code.patch
Patch9999: %{name}-add-system-library-paths.patch

%description
The cryptsetup package contains a utility for setting up
disk encryption using dm-crypt kernel module.

%package devel
Requires: %{name}-libs%{?_isa} = %{version}-%{release}
Requires: pkgconfig
Summary: Headers and libraries for using encrypted file systems

%description devel
The cryptsetup-devel package contains libraries and header files
used for writing code that makes use of disk encryption.

%package libs
Summary: Cryptsetup shared library

%description libs
This package contains the cryptsetup shared library, libcryptsetup.

%package -n veritysetup
Summary: A utility for setting up dm-verity volumes
Requires: cryptsetup-libs = %{version}-%{release}

%description -n veritysetup
The veritysetup package contains a utility for setting up
disk verification using dm-verity kernel module.

%package -n integritysetup
Summary: A utility for setting up dm-integrity volumes
Requires: cryptsetup-libs = %{version}-%{release}

%description -n integritysetup
The integritysetup package contains a utility for setting up
disk integrity protection using dm-integrity kernel module.

%package reencrypt
Summary: A utility for offline reencryption of LUKS encrypted disks
Requires: cryptsetup-libs = %{version}-%{release}

%description reencrypt
This package contains cryptsetup-reencrypt utility which
can be used for offline reencryption of disk in situ.

%prep
%autosetup -n cryptsetup-%{upstream_version} -p 1 -a 1

# workaround, since autosetup doesn't support multiple -a options (last one wins)
# https://github.com/rpm-software-management/rpm/issues/462
%autosetup -D -T -a 2 -N
chmod -x misc/dracut_90reencrypt/*

%build
%configure --enable-fips --enable-pwquality --enable-internal-sse-argon2 --disable-ssh-token
%make_build

%install
%make_install
rm -rf %{buildroot}%{_libdir}/*.la

%find_lang cryptsetup

%ldconfig_scriptlets -n cryptsetup-libs

%files
%license COPYING
%doc AUTHORS FAQ docs/*ReleaseNotes
%{_mandir}/man8/cryptsetup.8.gz
%{_sbindir}/cryptsetup

%files -n veritysetup
%license COPYING
%{_mandir}/man8/veritysetup.8.gz
%{_sbindir}/veritysetup

%files -n integritysetup
%license COPYING
%{_mandir}/man8/integritysetup.8.gz
%{_sbindir}/integritysetup

%files reencrypt
%license COPYING
%doc misc/dracut_90reencrypt
%{_mandir}/man8/cryptsetup-reencrypt.8.gz
%{_sbindir}/cryptsetup-reencrypt

%files devel
%doc docs/examples/*
%{_includedir}/libcryptsetup.h
%{_libdir}/libcryptsetup.so
%{_libdir}/pkgconfig/libcryptsetup.pc

%files libs -f cryptsetup.lang
%license COPYING COPYING.LGPL
%{_libdir}/libcryptsetup.so.*
%dir %{_libdir}/%{name}/
%{_tmpfilesdir}/cryptsetup.conf
%ghost %attr(700, -, -) %dir /run/cryptsetup

%changelog
* Wed Dec 21 2022 Daniel Zatovic <dzatovic@redhat.com> - 2.4.3-5.1
- patch: Run PBKDF benchmark with 8 bytes long well-known passphrase.
- patch: Change tests to use passphrases with minimal 8 chars length.
- patch: Add FIPS related error message in keyslot add code.
- Resolves: #2151576

* Wed Aug 10 2022 Ondrej Kozina <okozina@redhat.com> - 2.4.3-5
- patch: Delegate FIPS mode detection to crypto backend.
- Resolves: #2080516

* Thu Feb 24 2022 Ondrej Kozina <okozina@redhat.com> - 2.4.3-4
- patch: Fix broken upstream test.
- Resolves: #2056439

* Wed Feb 23 2022 Ondrej Kozina <okozina@redhat.com> - 2.4.3-3
- patch: Fix cryptsetup --test-passphrase when device in
  reencryption
- Resolves: #2056439

* Thu Feb 17 2022 Ondrej Kozina <okozina@redhat.com> - 2.4.3-2
- Various FIPS related fixes.
- Resolves: #2051630

* Fri Jan 21 2022 Ondrej Kozina <okozina@redhat.com> - 2.4.3-1
- Update to cryptsetup 2.4.3.
- patch: Fix typo in repair command prompt.
  Resolves: #2022309 #2023316 #2032782

* Wed Sep 29 2021 Ondrej Kozina <okozina@redhat.com> - 2.4.1-1
- Update to cryptsetup 2.4.1.
  Resolves: #2005035 #2005877

* Thu Aug 19 2021 Ondrej Kozina <okozina@redhat.com> - 2.4.0-1
- Update to cryptsetup 2.4.0.
  Resolves: #1869553 #1972722 #1974271 #1975799

* Mon Aug 09 2021 Mohan Boddu <mboddu@redhat.com> - 2.3.6-3
- Rebuilt for IMA sigs, glibc 2.34, aarch64 flags
  Related: rhbz#1991688

* Thu Jun 17 2021 Mohan Boddu <mboddu@redhat.com> - 2.3.6-2
- Specbump for openssl 3.0
  Related: rhbz#1971065

* Wed Jun 16 2021 Ondrej Kozina <okozina@redhat.com> - 2.3.6-1
- Update to cryptsetup 2.3.6.
- Resolves: #1961291 #1970932

* Tue Jun 15 2021 Mohan Boddu <mboddu@redhat.com> - 2.3.5-5
- Rebuilt for RHEL 9 BETA for openssl 3.0

Related: rhbz#1971065

* Tue Apr 27 2021 Ondrej Kozina <okozina@redhat.com> - 2.3.5-4
- Drop dependency on libargon2
- Resolves: #1936959

* Thu Apr 15 2021 Mohan Boddu <mboddu@redhat.com> - 2.3.5-3
- Rebuilt for RHEL 9 BETA on Apr 15th 2021. Related: rhbz#1947937

* Thu Mar 11 2021 Milan Broz <gmazyland@gmail.com> - 2.3.5-1
- Update to cryptsetup 2.3.5.

* Tue Jan 26 2021 Fedora Release Engineering <releng@fedoraproject.org> - 2.3.4-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_34_Mass_Rebuild

* Thu Sep 03 2020 Milan Broz <gmazyland@gmail.com> - 2.3.4-1
- Update to cryptsetup 2.3.4.
- Fix for CVE-2020-14382 (#1874712)
