/**
 * Namespace for dom-related utilities.
 * @namespace dom
 * @memberof axe.commons
 */
export { default as findElmsInContext } from './find-elms-in-context';
export { default as findUpVirtual } from './find-up-virtual';
export { default as findUp } from './find-up';
export { default as findNearbyElms } from './find-nearby-elms';
export { default as focusDisabled } from './focus-disabled';
export { default as getComposedParent } from './get-composed-parent';
export { default as getElementByReference } from './get-element-by-reference';
export { default as getElementCoordinates } from './get-element-coordinates';
export { default as getElementStack } from './get-element-stack';
export { default as getModalDialog } from './get-modal-dialog';
export { default as getOverflowHiddenAncestors } from './get-overflow-hidden-ancestors';
export { default as getRootNode } from './get-root-node';
export { default as getScrollOffset } from './get-scroll-offset';
export { default as getTabbableElements } from './get-tabbable-elements';
export { default as getTargetRects } from './get-target-rects';
export { default as getTargetSize } from './get-target-size';
export { default as getTextElementStack } from './get-text-element-stack';
export { default as getViewportSize } from './get-viewport-size';
export { default as getVisibleChildTextRects } from './get-visible-child-text-rects';
export { default as hasContentVirtual } from './has-content-virtual';
export { default as hasContent } from './has-content';
export { default as hasLangText } from './has-lang-text';
export { default as idrefs } from './idrefs';
export { default as insertedIntoFocusOrder } from './inserted-into-focus-order';
export { default as isCurrentPageLink } from './is-current-page-link';
export { default as isFocusable } from './is-focusable';
export { default as isHiddenWithCSS } from './is-hidden-with-css';
export { default as isHiddenForEveryone } from './is-hidden-for-everyone';
export { default as isHTML5 } from './is-html5';
export { default as isInTabOrder } from './is-in-tab-order';
export { default as isInTextBlock } from './is-in-text-block';
export { default as isInert } from './is-inert';
export { default as isModalOpen } from './is-modal-open';
export { default as isMultiline } from './is-multiline';
export { default as isNativelyFocusable } from './is-natively-focusable';
export { default as isNode } from './is-node';
export { default as isOffscreen } from './is-offscreen';
export { default as isOpaque } from './is-opaque';
export { default as isSkipLink } from './is-skip-link';
export { default as isVisibleToScreenReaders } from './is-visible-to-screenreader';
export { default as isVisibleOnScreen } from './is-visible-on-screen';
export { default as isVisible } from './is-visible';
export { default as isVisualContent } from './is-visual-content';
export { default as reduceToElementsBelowFloating } from './reduce-to-elements-below-floating';
export { default as shadowElementsFromPoint } from './shadow-elements-from-point';
export { default as urlPropsFromAttribute } from './url-props-from-attribute';
export { default as visuallyContains } from './visually-contains';
export { default as visuallyOverlaps } from './visually-overlaps';
export { default as visuallySort } from './visually-sort';
export { default as createGrid } from './create-grid';
