%define debug_package %{nil}
%define product_family Red Hat Enterprise Linux
%define release_name Ootpa
%define base_release_version 8
%define full_release_version 8.4
%define dist_release_version 8
# When moving from Beta to GA, the beta definition needs to be removed,
# not just commented out.
%define beta_part %{?beta:-%{beta}}
%define swid_regid redhat.com
%define dist .el%{dist_release_version}

Name:           redhat-release
Version:        %{full_release_version}
Release:        0.6%{?dist}
Summary:        %{product_family} release file
Group:          System Environment/Base
License:        GPLv2
Provides:       redhat-release = %{version}-%{release}
Provides:       system-release = %{version}-%{release}
Provides:       system-release(releasever) = %{base_release_version}
Provides:       base-module(platform:el%{base_release_version})
Provides:       redhat-release-server
Provides:       redhat-release-client
Provides:       redhat-release-computenode
Provides:       redhat-release-workstation
Obsoletes:      redhat-release-server
Obsoletes:      redhat-release-client
Obsoletes:      redhat-release-computenode
Obsoletes:      redhat-release-workstation
Recommends:     redhat-release-eula
Source0:        redhat-release-%{base_release_version}.0.tar.gz
Source1:        85-display-manager.preset
Source2:        90-default.preset
Source3:        99-default-disable.preset
Source4:        redhat-release-productids-%{full_release_version}-dist-20210331071101.tar.gz
Source5:        RHEL-%{full_release_version}%{beta_part}-swidtag.tar.gz


%description
%{product_family} release files

%package eula
Summary:        %{product_family} EULA file
Group:          System Environment/Base
License:        Not applicable
%description eula
%{product_family} EULA file

%prep
%setup -q -n redhat-release-%{base_release_version}
%setup -q -n redhat-release-%{base_release_version} -T -D -a 4
%setup -q -n redhat-release-%{base_release_version} -T -D -a 5

%build
echo OK

%install
rm -rf %{buildroot}

# create /etc
mkdir -p %{buildroot}/etc
mkdir -p %{buildroot}/%{_prefix}/lib

# create /etc/system-release and /etc/redhat-release
echo "%{product_family} release %{full_release_version}%{?beta: %{beta}} (%{release_name})" > %{buildroot}/etc/redhat-release
ln -s redhat-release %{buildroot}/etc/system-release

# create /usr/lib/os-release
cat << EOF >>%{buildroot}/%{_prefix}/lib/os-release
NAME="%{product_family}"
VERSION="%{full_release_version} (%{release_name})"
ID="rhel"
ID_LIKE="fedora"
VERSION_ID="%{full_release_version}"
PLATFORM_ID="platform:el%{base_release_version}"
PRETTY_NAME="%{product_family} %{full_release_version}%{?beta: %{beta}} (%{release_name})"
ANSI_COLOR="0;31"
CPE_NAME="cpe:/o:redhat:enterprise_linux:%{full_release_version}:%{?beta:beta}%{!?beta:GA}"
HOME_URL="https://www.redhat.com/"
DOCUMENTATION_URL="https://access.redhat.com/documentation/red_hat_enterprise_linux/8/"
BUG_REPORT_URL="https://bugzilla.redhat.com/"

REDHAT_BUGZILLA_PRODUCT="%{product_family} %{base_release_version}"
REDHAT_BUGZILLA_PRODUCT_VERSION=%{full_release_version}
REDHAT_SUPPORT_PRODUCT="%{product_family}"
REDHAT_SUPPORT_PRODUCT_VERSION="%{full_release_version}%{?beta: %{beta}}"
EOF
# create /etc/os-release symlink
ln -s ../%{_prefix}/lib/os-release %{buildroot}/%{_sysconfdir}/os-release

# write cpe to /etc/system/release-cpe
echo "cpe:/o:redhat:enterprise_linux:%{full_release_version}:%{?beta:beta}%{!?beta:GA}" | tr [A-Z] [a-z] > %{buildroot}/etc/system-release-cpe

# create /etc/issue and /etc/issue.net
echo '\S' > %{buildroot}/etc/issue
echo 'Kernel \r on an \m' >> %{buildroot}/etc/issue
cp %{buildroot}/etc/issue %{buildroot}/etc/issue.net
echo >> %{buildroot}/etc/issue

mkdir -p -m 755 %{buildroot}/etc/pki/rpm-gpg
# Correct GPG keys were fixed in via rhbz#1672230
cp RPM-GPG-KEY-redhat-release %{buildroot}/etc/pki/rpm-gpg/
cp RPM-GPG-KEY-redhat-beta %{buildroot}/etc/pki/rpm-gpg/
chmod 0644 %{buildroot}/etc/pki/rpm-gpg/RPM-GPG-KEY-*

# Copy Productids
mkdir -p -m 755 %{buildroot}/etc/pki/product-default
if [ -d redhat-release-productids-%{full_release_version}-*/%{_arch} ]; then
    for pem in redhat-release-productids-%{full_release_version}-*/%{_arch}/*.pem; do
        install -m 644 $pem %{buildroot}/etc/pki/product-default
    done
fi

### TJD Need to have trimmed down macros file
## set up the dist tag macros
install -d -m 755 %{buildroot}/etc/rpm
cat >> %{buildroot}/etc/rpm/macros.dist << EOF
# dist macros.

%%rhel %{base_release_version}
%%dist %{dist}
%%el%{base_release_version} 1
EOF
### TJD end

# make redhat-release a protected package
install -p -d -m 755 %{buildroot}/etc/dnf/protected.d/
touch redhat-release.conf
echo redhat-release > redhat-release.conf
install -p -c -m 0644 redhat-release.conf %{buildroot}/etc/dnf/protected.d/
rm -f redhat-release.conf

# use unbranded datadir
mkdir -p -m 755 %{buildroot}/%{_datadir}/redhat-release
install -m 644 EULA %{buildroot}/%{_datadir}/redhat-release

# use unbranded docdir
mkdir -p -m 755 %{buildroot}/%{_docdir}/redhat-release
install -m 644 GPL %{buildroot}/%{_docdir}/redhat-release
sed  -i 's:@@VERSION@@:%{full_release_version}:' GPL-source-offer
install -m 644 GPL-source-offer %{buildroot}/%{_docdir}/redhat-release

# copy systemd presets
mkdir -p %{buildroot}/%{_prefix}/lib/systemd/system-preset/
install -m 0644 %{SOURCE1} %{buildroot}/%{_prefix}/lib/systemd/system-preset/
install -m 0644 %{SOURCE2} %{buildroot}/%{_prefix}/lib/systemd/system-preset/
install -m 0644 %{SOURCE3} %{buildroot}/%{_prefix}/lib/systemd/system-preset/


### TJD Still debating where this really goes
mkdir -p -m 755 %{buildroot}/etc/yum.repos.d
### TJD end

# Copy SWID tags
mkdir -p -m 755 %{buildroot}%{_prefix}/lib/swidtag/%{swid_regid}
if ! [ %{_arch} = "i386" ] ; then
    install -p -m 644 RHEL-%{full_release_version}%{beta_part}-swidtag/com.redhat.RHEL-%{base_release_version}-%{_arch}.swidtag %{buildroot}%{_prefix}/lib/swidtag/%{swid_regid}/
    install -p -m 644 RHEL-%{full_release_version}%{beta_part}-swidtag/com.redhat.RHEL-%{full_release_version}%{beta_part}-%{_arch}.swidtag %{buildroot}%{_prefix}/lib/swidtag/%{swid_regid}/
fi
mkdir -p -m 755 %{buildroot}/etc/pki/swid/CA/%{swid_regid}
mkdir -p -m 755 %{buildroot}/etc/swid/swidtags.d
ln -s %{_prefix}/lib/swidtag/%{swid_regid} %{buildroot}/etc/swid/swidtags.d/%{swid_regid}
install -p -m 644 RHEL-%{full_release_version}%{beta_part}-swidtag/redhatcodesignca.cert %{buildroot}/etc/pki/swid/CA/%{swid_regid}/

%clean
rm -rf %{buildroot}

%files
%defattr(0644,root,root,0755)
/etc/redhat-release
/etc/system-release
%config /etc/os-release
%config /etc/system-release-cpe
%config(noreplace) /etc/issue
%config(noreplace) /etc/issue.net
/etc/dnf/protected.d/redhat-release.conf
/etc/pki/rpm-gpg/
/etc/rpm/macros.dist
%{_docdir}/redhat-release/*
%{_prefix}/lib/systemd/system-preset/*
%{_prefix}/lib/os-release
/etc/pki/product-default
%dir /etc/yum.repos.d
/etc/swid/swidtags.d
%{_prefix}/lib/swidtag/%{swid_regid}
/etc/pki/swid/CA/%{swid_regid}

%files eula
%defattr(0644,root,root,0755)
%{_datadir}/redhat-release/EULA

%changelog
* Wed Mar 31 2021 Aviv Sabadra <asabadra@redhat.com> - 8.4.0-0.6.el8
- Add RHEL-8.4 GA product ID certs
- Resolves: RHELPLAN-73274

* Thu Oct 08 2020 Josh Boyer <jwboyer@redhat.com> - 8.4.0-0.5.el8
- Adjust EULA
- Resolves: rhbz#1713462

* Thu Oct 08 2020 Djordje Todorovic <dtodorov@redhat.com>
- Add DOCUMENTATION_URL
- Resolves: RHELBLD-1916

* Thu Sep 10 2020 Josh Boyer <jwboyer@redhat.com> - 8.4.0-0.1.el8
- Add base module platform Provides.  Based on a fix from Neal Gompa
- Resolves: rhbz#1789122

* Wed Sep 09 2020 Josh Boyer <jwboyer@redhat.com>
- Enable mlocate-updatedb
- Resolves: rhbz#1817591

* Mon Aug 24 2020 Lisa Smith <lisas@redhat.com> - 8.4-0.0.el8
- Initial build for RHEL 8.4 beta
- Resolves: SPRHEL-5088

* Tue Aug  4 2020 Christian Kellner <ckellner@redhat.com> - 8.3-0.4.el8
- Enable ostree-remount.service for OSTree based systems
- Resolves: rhbz#1848453

* Tue Jul 28 2020 Djordje Todorovic <dtodorov@redhat.com> - 8.3-0.3.el8
- Rebuild for 8.3.0 HTB

* Tue Jun 16 2020 Djordje Todorovic <dtodorov@redhat.com> - 8.3-0.2.el8
- Make nfs-convert enabled by adding it to systemd presets
- Resolves: RHELBLD-830

* Tue Jun 16 2020 Djordje Todorovic <dtodorov@redhat.com> - 8.3-0.1.el8
- Fix the {dist} tag to produce the correct n-v-r
- Resolves: RHELBLD-1713

* Tue Jun 16 2020 Djordje Todorovic <dtodorov@redhat.com> - 8.3-0.1.el8
- Fix the {dist} tag to produce the correct n-v-r
- Resolves: RHELBLD-1713

* Tue Jun 16 2020 Djordje Todorovic <dtodorov@redhat.com> - 8.3-0.1.el8
- Replace abrt-cppp.service with abrt-journal-core.service
- Resolves: RHELBLD-1713

* Tue Jun 16 2020 Djordje Todorovic <dtodorov@redhat.com>
- Do not auto enable polkit (a static service)
- Resolves: RHELBLD-1712

* Tue Mar 17 2020 Lisa Smith <lismith@redhat.com> - 8.3-0.0.el8
- Initial RHEL 8.3.0 build

* Mon Mar 09 2020 Leon Kang <lekang@redhat.com> - 8.2-0.9.el8
- enable nvmefc-boot-connections.service in
  /usr/lib/systemd/system-preset/90-default.preset
- Resolves: RCM-77224

* Thu Feb 27 2020 Josh Boyer <jwboyer@redhat.com> - 8.2-0.8.el8
- Allow stateless system usage of os-release (RhBug: 1766754)
- Based on a contribution from Neal Gompa

* Wed Jan 22 2020 Caleigh Runge-Hottman <crungeho@redhat.com> - 8.2-0.7.el8
- Rebuild redhat-release with amended gating test case

* Tue Jan 21 2020 Caleigh Runge-Hottman <crungeho@redhat.com> - 8.2-0.6.el8
- Rebuild redhat-release with RHEL-8.2 HTB product ID certs

* Fri Sep 13 2019 Caleigh Runge-Hottman <crungeho@redhat.com> - 8.2-0.5.el8
- Rebuild redhat-release against updated buildroot

* Tue Sep 03 2019 Caleigh Runge-Hottman <crungeho@redhat.com> - 8.2-0.4.el8
- Fix bogus dates in the changelog 

* Tue Sep 03 2019 Caleigh Runge-Hottman <crungeho@redhat.com> - 8.2-0.3.el8
- Correct the timestamps on the RHEL-8 SWID tags

* Fri Aug 30 2019 Caleigh Runge-Hottman <crungeho@redhat.com> - 8.2-0.2.el8
- Add RHEL-8.2 Beta SWID tags

* Fri Aug 30 2019 Caleigh Runge-Hottman <crungeho@redhat.com> - 8.2-0.1.el8
- Add RHEL-8.2 Beta product ID certs

* Tue Aug 06 2019 Josh Boyer <jwboyer@redhat.com> - 8.1-3.2.el8
- Make redhat-release a protected package (RhBug: 1737773)

* Fri Aug 02 2019 Caleigh Runge-Hottman <crungeho@redhat.com> - 8.1-3.1.el8
- Add RHEL-8.1 HTB product ID certs

* Mon Apr 15 2019 Pavel Niahodkin - 8.1-3.0.el8
- Sign SWID tags (RhBug: 1694038)

* Mon Apr 15 2019 Pavel Niahodkin <pniahodk@redhat.com> - 8.1-2.0.el8
- Add RHEL-8.1.0 Beta SWID to the source file (RhBug: 1694038)

* Fri Apr 12 2019 Jan Pazdziora <jpazdziora@redhat.com> - 8.1-1.0
- Update to handle RHEL 8.1 Beta SWID tags.

* Fri Apr 05 2019 Pavel Niahodkin
- Rebuild for 8.1.0 (RhBug: 1694038)

* Thu Feb 21 2019 Caleigh Runge-Hottman <crungeho@redhat.com> - 8.0-0.43
- Rebuild for 8.0 GA 

* Wed Feb 20 2019 Andrew Hills
- Fix keys again (rhbz#1672230)

* Tue Feb 19 2019 Caleigh Runge-Hottman <crungeho@redhat.com> - 8.0-0.41
- Split EULA into the subpackage redhat-release-eula (rhbz#1676949) 

* Tue Feb 19 2019 Andrew Hills - 8.0-0.40.el8
- Fix keys (rhbz#1672230) and dist tag macros

* Wed Dec 12 2018 Jan Pazdziora <jpazdziora@redhat.com> - 8.0-0.39
- Ship the primary RHEL-8 SWID tag as well, update location to /usr/lib/swidtag.

* Tue Dec 11 2018 Andrew Hills - 8.0-0.38
- add GA SWID tags

* Thu Dec 06 2018 Pavel Niahodkin <pniahodk@redhat.com> - 8.0-0.37
- Enable stratisd.service (RhBug: 1632510)

* Fri Nov 16 2018 Pavel Niahodkin - 8.0-0.36
- Update appropriate Source directive to point to the new productids tarball
  (RhBug: 1647759)

* Fri Nov 16 2018 Pavel Niahodkin - 8.0-0.35
- Re-build of redhat-release with HTB Product IDs (RhBug: 1647759)

* Tue Oct 16 2018 Tomas Mlcoch <tmlcoch@redhat.com> - 8.0-0.34
- Beta Product ID certs now provides also HTB tags (RhBug: 1638841)

* Wed Oct 03 2018 Pavel Niahodkin <pniahodk@redhat.com> - 8.0-0.33
- Disable systemd-resolved (RhBug: 1613306)

* Thu Sep 27 2018 Pavel Niahodkin - 8.0-0.32
- Add new line to the end of RPM-GPG-KEY-redhat-AUX-2018 key (RhBug: 1618742)

* Wed Sep 26 2018 Pavel Niahodkin <pniahodk@redhat.com> - 8.0-0.31
- Enable s390x specific services (RhBug: 1630200)

* Mon Sep 24 2018 Pavel Niahodkin <pniahodk@redhat.com> - 8.0-0.30
- Remove sssd-secrets.socket from the presets (RhBug: 1615583)

* Mon Sep 24 2018 Pavel Niahodkin <pniahodk@redhat.com> - 8.0-0.29
- Set Provides and Obsoletes (RhBug: 1603142)

* Tue Aug 28 2018 Pavel Niahodkin <pniahodk@redhat.com> - 8.0-0.28
- Remove redundant Fedora reference (RhBug: 1609198)

* Tue Aug 14 2018 Jan Pazdziora <jpazdziora@redhat.com> - 8.0-0.27
- Add RHEL-8 Beta SWID tags.

* Sun Aug 12 2018 Troy Dawson <tdawson@redhat.com> - 8.0-0.26
- Set .dist to final GA setting (.el8)
- Related: bug#1614611

* Fri Aug 10 2018 Troy Dawson <tdawson@redhat.com> - 8.0-0.25.8
- Set .dist to Set to pre-GA setting (.el8+8)

* Thu Aug 09 2018 Tomas Mlcoch <tmlcoch@redhat.com> - 8.0-0.25
- Add Beta Product ID certificates

* Wed Aug 01 2018 Troy Dawson <tdawson@redhat.com> - 8.0-0.24
- Set .dist to final GA setting (.el8)

* Wed Aug 01 2018 Troy Dawson <tdawson@redhat.com> - 8.0-0.23
- Re-enable .dist - Set to pre-GA setting (.el8+N)

* Wed Jul 25 2018 Andrew Hills <ahills@redhat.com> - 8.0-0.22
- Patch 90-default.preset with attachment 1470501 from RhBug: 1599664

* Mon Jul 23 2018 Pavel Niahodkin <pniahodk@redhat.com> - 8.0-0.21
- Add two GPG keys from RHEL 7 and one new aux signing key (RhBug: 1584634)

* Fri Jul 13 2018 Troy Dawson <tdawson@redhat.com> - 8.0-0.20
- Set type of release to Beta instead of Alpha

* Thu Jul 12 2018 Pavel Niahodkin <pniahodk@redhat.com> - 8.0-0.19
- Change RHEL-8 systemd defaults in order to address differences between fedora-release and redhat-release (RhBug: 1572550)

* Wed Jun 27 2018 Pavel Niahodkin <pniahodk@redhat.com> - 8.0-0.18
- Drop rhel-autorelabel.service (RhBug: 1590902)

* Tue Jun 26 2018 Pavel Niahodkin <pniahodk@redhat.com> - 8.0-0.17
- Rename rhel-autorelable-mark.service to selinux-autorelable-mark.service (RhBug: 1590902)

* Tue May 29 2018 Tomas Mlcoch <tmlcoch@redhat.com> - 8.0-0.16
- Update Product IDs to RHEL-8.0 GA ones (RhBug: 1575510)

* Thu May 17 2018 Tomas Mlcoch <tmlcoch@redhat.com> - 8.0-0.14
- Update systemd preset. Add sssd.service and initscripts services (RhBug: 1578870 & 1578833)

* Mon Apr 30 2018 Rashmi Nargundkar <rnargund@redhat.com> - 8.0-0.12
- Enable timedatex service (BZ : 1572550)

* Thu Apr 05 2018 Tomas Mlcoch <tmlcoch@redhat.com> - 8.0-0.11
- Enable SSSD Kerberos Credential Cache Server (RhBug: 1558927)

* Thu Apr 05 2018 Rafael Santos <rdossant@redhat.com> - 8.0-0.10
- Add PLATFORM_ID to /etc/os-release

* Tue Feb 13 2018 Rashmi Nargundkar <rnargund@redhat.com> - 8.0-0.9
- Set RHEL-8 code name to "Ootpa" and set type of release to Alpha instead of Bootstrap

* Fri Jan 12 2018 Troy Dawson <tdawson@redhat.com> - 8.0-0.8.1
- Do not set %dist

* Wed Jan 10 2018 Tomas Mlcoch <tmlcoch@redhat.com> - 8.0-0.8
- Add 99-default-disable.preset file for systemd

* Thu Nov 09 2017 Troy Dawson <tdawson@redhat.com> - 8.0-0.7
- dist is now .el8

* Thu Oct 26 2017 Troy Dawson <tdawson@redhat.com> - 8.0-0.6
- Use the module macros for dist

* Fri Sep 29 2017 Troy Dawson <tdawson@redhat.com> - 8.0-0.5
- Added /etc/yum.repos.d

* Wed Sep 6 2017 Rashmi Nargundkar <rnargund@redhat.com> - 8.0-0.4
- Added the new GPL-source-offer file

* Mon Jul 17 2017 Troy Dawson <tdawson@redhat.com> - 8.0-0.3
- Trim dist macros instead of remove

* Mon Jul 10 2017 Troy Dawson <tdawson@redhat.com> - 8.0-0.2
- Remove dist macros for initial bootstrapping

* Thu Jun 29 2017 Russell Laliberte <rlaliber@redhat.com> - 8.0-0.1
- Rebuild for RHEL 8.0 Bootstrapping
