// Code generated by go generate; DO NOT EDIT.
// This file was generated by robots.

package database

import (
	"encoding/json"
	"fmt"
	"reflect"
	"strings"
	"testing"

	"github.com/mitchellh/mapstructure"
	"github.com/stretchr/testify/assert"
)

var dereferencableKindsDbConfig = map[reflect.Kind]struct{}{
	reflect.Array: {}, reflect.Chan: {}, reflect.Map: {}, reflect.Ptr: {}, reflect.Slice: {},
}

// Checks if t is a kind that can be dereferenced to get its underlying type.
func canGetElementDbConfig(t reflect.Kind) bool {
	_, exists := dereferencableKindsDbConfig[t]
	return exists
}

// This decoder hook tests types for json unmarshaling capability. If implemented, it uses json unmarshal to build the
// object. Otherwise, it'll just pass on the original data.
func jsonUnmarshalerHookDbConfig(_, to reflect.Type, data interface{}) (interface{}, error) {
	unmarshalerType := reflect.TypeOf((*json.Unmarshaler)(nil)).Elem()
	if to.Implements(unmarshalerType) || reflect.PtrTo(to).Implements(unmarshalerType) ||
		(canGetElementDbConfig(to.Kind()) && to.Elem().Implements(unmarshalerType)) {

		raw, err := json.Marshal(data)
		if err != nil {
			fmt.Printf("Failed to marshal Data: %v. Error: %v. Skipping jsonUnmarshalHook", data, err)
			return data, nil
		}

		res := reflect.New(to).Interface()
		err = json.Unmarshal(raw, &res)
		if err != nil {
			fmt.Printf("Failed to umarshal Data: %v. Error: %v. Skipping jsonUnmarshalHook", data, err)
			return data, nil
		}

		return res, nil
	}

	return data, nil
}

func decode_DbConfig(input, result interface{}) error {
	config := &mapstructure.DecoderConfig{
		TagName:          "json",
		WeaklyTypedInput: true,
		Result:           result,
		DecodeHook: mapstructure.ComposeDecodeHookFunc(
			mapstructure.StringToTimeDurationHookFunc(),
			mapstructure.StringToSliceHookFunc(","),
			jsonUnmarshalerHookDbConfig,
		),
	}

	decoder, err := mapstructure.NewDecoder(config)
	if err != nil {
		return err
	}

	return decoder.Decode(input)
}

func join_DbConfig(arr interface{}, sep string) string {
	listValue := reflect.ValueOf(arr)
	strs := make([]string, 0, listValue.Len())
	for i := 0; i < listValue.Len(); i++ {
		strs = append(strs, fmt.Sprintf("%v", listValue.Index(i)))
	}

	return strings.Join(strs, sep)
}

func testDecodeJson_DbConfig(t *testing.T, val, result interface{}) {
	assert.NoError(t, decode_DbConfig(val, result))
}

func testDecodeRaw_DbConfig(t *testing.T, vStringSlice, result interface{}) {
	assert.NoError(t, decode_DbConfig(vStringSlice, result))
}

func TestDbConfig_GetPFlagSet(t *testing.T) {
	val := DbConfig{}
	cmdFlags := val.GetPFlagSet("")
	assert.True(t, cmdFlags.HasFlags())
}

func TestDbConfig_SetFlags(t *testing.T) {
	actual := DbConfig{}
	cmdFlags := actual.GetPFlagSet("")
	assert.True(t, cmdFlags.HasFlags())

	t.Run("Test_enableForeignKeyConstraintWhenMigrating", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("enableForeignKeyConstraintWhenMigrating", testValue)
			if vBool, err := cmdFlags.GetBool("enableForeignKeyConstraintWhenMigrating"); err == nil {
				testDecodeJson_DbConfig(t, fmt.Sprintf("%v", vBool), &actual.EnableForeignKeyConstraintWhenMigrating)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_maxIdleConnections", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("maxIdleConnections", testValue)
			if vInt, err := cmdFlags.GetInt("maxIdleConnections"); err == nil {
				testDecodeJson_DbConfig(t, fmt.Sprintf("%v", vInt), &actual.MaxIdleConnections)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_maxOpenConnections", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("maxOpenConnections", testValue)
			if vInt, err := cmdFlags.GetInt("maxOpenConnections"); err == nil {
				testDecodeJson_DbConfig(t, fmt.Sprintf("%v", vInt), &actual.MaxOpenConnections)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_connMaxLifeTime", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := defaultConfig.ConnMaxLifeTime.String()

			cmdFlags.Set("connMaxLifeTime", testValue)
			if vString, err := cmdFlags.GetString("connMaxLifeTime"); err == nil {
				testDecodeJson_DbConfig(t, fmt.Sprintf("%v", vString), &actual.ConnMaxLifeTime)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_postgres.host", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("postgres.host", testValue)
			if vString, err := cmdFlags.GetString("postgres.host"); err == nil {
				testDecodeJson_DbConfig(t, fmt.Sprintf("%v", vString), &actual.Postgres.Host)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_postgres.readReplicaHost", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("postgres.readReplicaHost", testValue)
			if vString, err := cmdFlags.GetString("postgres.readReplicaHost"); err == nil {
				testDecodeJson_DbConfig(t, fmt.Sprintf("%v", vString), &actual.Postgres.ReadReplicaHost)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_postgres.port", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("postgres.port", testValue)
			if vInt, err := cmdFlags.GetInt("postgres.port"); err == nil {
				testDecodeJson_DbConfig(t, fmt.Sprintf("%v", vInt), &actual.Postgres.Port)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_postgres.dbname", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("postgres.dbname", testValue)
			if vString, err := cmdFlags.GetString("postgres.dbname"); err == nil {
				testDecodeJson_DbConfig(t, fmt.Sprintf("%v", vString), &actual.Postgres.DbName)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_postgres.username", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("postgres.username", testValue)
			if vString, err := cmdFlags.GetString("postgres.username"); err == nil {
				testDecodeJson_DbConfig(t, fmt.Sprintf("%v", vString), &actual.Postgres.User)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_postgres.password", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("postgres.password", testValue)
			if vString, err := cmdFlags.GetString("postgres.password"); err == nil {
				testDecodeJson_DbConfig(t, fmt.Sprintf("%v", vString), &actual.Postgres.Password)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_postgres.passwordPath", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("postgres.passwordPath", testValue)
			if vString, err := cmdFlags.GetString("postgres.passwordPath"); err == nil {
				testDecodeJson_DbConfig(t, fmt.Sprintf("%v", vString), &actual.Postgres.PasswordPath)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_postgres.options", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("postgres.options", testValue)
			if vString, err := cmdFlags.GetString("postgres.options"); err == nil {
				testDecodeJson_DbConfig(t, fmt.Sprintf("%v", vString), &actual.Postgres.ExtraOptions)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_postgres.debug", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("postgres.debug", testValue)
			if vBool, err := cmdFlags.GetBool("postgres.debug"); err == nil {
				testDecodeJson_DbConfig(t, fmt.Sprintf("%v", vBool), &actual.Postgres.Debug)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_sqlite.file", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("sqlite.file", testValue)
			if vString, err := cmdFlags.GetString("sqlite.file"); err == nil {
				testDecodeJson_DbConfig(t, fmt.Sprintf("%v", vString), &actual.SQLite.File)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
}
