package nodes

import (
	"context"

	"github.com/flyteorg/flyte/flytepropeller/pkg/apis/flyteworkflow/v1alpha1"
	"github.com/flyteorg/flyte/flytepropeller/pkg/controller/nodes/interfaces"
	"github.com/flyteorg/flyte/flytestdlib/promutils"
)

type setupContext struct {
	enq   func(string)
	scope promutils.Scope
}

func (s *setupContext) EnqueueOwner() func(string) {
	return s.enq
}

func (s *setupContext) OwnerKind() string {
	return v1alpha1.FlyteWorkflowKind
}

func (s *setupContext) MetricsScope() promutils.Scope {
	return s.scope
}

func (c *recursiveNodeExecutor) newSetupContext(_ context.Context) interfaces.SetupContext {
	return &setupContext{
		enq:   c.enqueueWorkflow,
		scope: c.metrics.Scope,
	}
}
