// @generated by protoc-gen-es v1.7.2 with parameter "target=ts"
// @generated from file flyteidl/core/tasks.proto (package flyteidl.core, syntax proto3)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { Duration, Message, proto3, Struct } from "@bufbuild/protobuf";
import { KeyValuePair, RetryStrategy } from "./literals_pb.js";
import { Identifier } from "./identifier_pb.js";
import { TypedInterface } from "./interface_pb.js";
import { SecurityContext } from "./security_pb.js";

/**
 * A customizable interface to convey resources requested for a container. This can be interpreted differently for different
 * container engines.
 *
 * @generated from message flyteidl.core.Resources
 */
export class Resources extends Message<Resources> {
  /**
   * The desired set of resources requested. ResourceNames must be unique within the list.
   *
   * @generated from field: repeated flyteidl.core.Resources.ResourceEntry requests = 1;
   */
  requests: Resources_ResourceEntry[] = [];

  /**
   * Defines a set of bounds (e.g. min/max) within which the task can reliably run. ResourceNames must be unique
   * within the list.
   *
   * @generated from field: repeated flyteidl.core.Resources.ResourceEntry limits = 2;
   */
  limits: Resources_ResourceEntry[] = [];

  constructor(data?: PartialMessage<Resources>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.Resources";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "requests", kind: "message", T: Resources_ResourceEntry, repeated: true },
    { no: 2, name: "limits", kind: "message", T: Resources_ResourceEntry, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Resources {
    return new Resources().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Resources {
    return new Resources().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Resources {
    return new Resources().fromJsonString(jsonString, options);
  }

  static equals(a: Resources | PlainMessage<Resources> | undefined, b: Resources | PlainMessage<Resources> | undefined): boolean {
    return proto3.util.equals(Resources, a, b);
  }
}

/**
 * Known resource names.
 *
 * @generated from enum flyteidl.core.Resources.ResourceName
 */
export enum Resources_ResourceName {
  /**
   * @generated from enum value: UNKNOWN = 0;
   */
  UNKNOWN = 0,

  /**
   * @generated from enum value: CPU = 1;
   */
  CPU = 1,

  /**
   * @generated from enum value: GPU = 2;
   */
  GPU = 2,

  /**
   * @generated from enum value: MEMORY = 3;
   */
  MEMORY = 3,

  /**
   * @generated from enum value: STORAGE = 4;
   */
  STORAGE = 4,

  /**
   * For Kubernetes-based deployments, pods use ephemeral local storage for scratch space, caching, and for logs.
   *
   * @generated from enum value: EPHEMERAL_STORAGE = 5;
   */
  EPHEMERAL_STORAGE = 5,
}
// Retrieve enum metadata with: proto3.getEnumType(Resources_ResourceName)
proto3.util.setEnumType(Resources_ResourceName, "flyteidl.core.Resources.ResourceName", [
  { no: 0, name: "UNKNOWN" },
  { no: 1, name: "CPU" },
  { no: 2, name: "GPU" },
  { no: 3, name: "MEMORY" },
  { no: 4, name: "STORAGE" },
  { no: 5, name: "EPHEMERAL_STORAGE" },
]);

/**
 * Encapsulates a resource name and value.
 *
 * @generated from message flyteidl.core.Resources.ResourceEntry
 */
export class Resources_ResourceEntry extends Message<Resources_ResourceEntry> {
  /**
   * Resource name.
   *
   * @generated from field: flyteidl.core.Resources.ResourceName name = 1;
   */
  name = Resources_ResourceName.UNKNOWN;

  /**
   * Value must be a valid k8s quantity. See
   * https://github.com/kubernetes/apimachinery/blob/master/pkg/api/resource/quantity.go#L30-L80
   *
   * @generated from field: string value = 2;
   */
  value = "";

  constructor(data?: PartialMessage<Resources_ResourceEntry>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.Resources.ResourceEntry";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "name", kind: "enum", T: proto3.getEnumType(Resources_ResourceName) },
    { no: 2, name: "value", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Resources_ResourceEntry {
    return new Resources_ResourceEntry().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Resources_ResourceEntry {
    return new Resources_ResourceEntry().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Resources_ResourceEntry {
    return new Resources_ResourceEntry().fromJsonString(jsonString, options);
  }

  static equals(a: Resources_ResourceEntry | PlainMessage<Resources_ResourceEntry> | undefined, b: Resources_ResourceEntry | PlainMessage<Resources_ResourceEntry> | undefined): boolean {
    return proto3.util.equals(Resources_ResourceEntry, a, b);
  }
}

/**
 * Metadata associated with the GPU accelerator to allocate to a task. Contains
 * information about device type, and for multi-instance GPUs, the partition size to
 * use.
 *
 * @generated from message flyteidl.core.GPUAccelerator
 */
export class GPUAccelerator extends Message<GPUAccelerator> {
  /**
   * This can be any arbitrary string, and should be informed by the labels or taints
   * associated with the nodes in question. Default cloud provider labels typically
   * use the following values: `nvidia-tesla-t4`, `nvidia-tesla-a100`, etc.
   *
   * @generated from field: string device = 1;
   */
  device = "";

  /**
   * @generated from oneof flyteidl.core.GPUAccelerator.partition_size_value
   */
  partitionSizeValue: {
    /**
     * @generated from field: bool unpartitioned = 2;
     */
    value: boolean;
    case: "unpartitioned";
  } | {
    /**
     * Like `device`, this can be any arbitrary string, and should be informed by
     * the labels or taints associated with the nodes in question. Default cloud
     * provider labels typically use the following values: `1g.5gb`, `2g.10gb`, etc.
     *
     * @generated from field: string partition_size = 3;
     */
    value: string;
    case: "partitionSize";
  } | { case: undefined; value?: undefined } = { case: undefined };

  constructor(data?: PartialMessage<GPUAccelerator>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.GPUAccelerator";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "device", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "unpartitioned", kind: "scalar", T: 8 /* ScalarType.BOOL */, oneof: "partition_size_value" },
    { no: 3, name: "partition_size", kind: "scalar", T: 9 /* ScalarType.STRING */, oneof: "partition_size_value" },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GPUAccelerator {
    return new GPUAccelerator().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GPUAccelerator {
    return new GPUAccelerator().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GPUAccelerator {
    return new GPUAccelerator().fromJsonString(jsonString, options);
  }

  static equals(a: GPUAccelerator | PlainMessage<GPUAccelerator> | undefined, b: GPUAccelerator | PlainMessage<GPUAccelerator> | undefined): boolean {
    return proto3.util.equals(GPUAccelerator, a, b);
  }
}

/**
 * Encapsulates all non-standard resources, not captured by v1.ResourceRequirements, to
 * allocate to a task.
 *
 * @generated from message flyteidl.core.ExtendedResources
 */
export class ExtendedResources extends Message<ExtendedResources> {
  /**
   * GPU accelerator to select for task. Contains information about device type, and
   * for multi-instance GPUs, the partition size to use.
   *
   * @generated from field: flyteidl.core.GPUAccelerator gpu_accelerator = 1;
   */
  gpuAccelerator?: GPUAccelerator;

  constructor(data?: PartialMessage<ExtendedResources>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.ExtendedResources";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "gpu_accelerator", kind: "message", T: GPUAccelerator },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExtendedResources {
    return new ExtendedResources().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExtendedResources {
    return new ExtendedResources().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExtendedResources {
    return new ExtendedResources().fromJsonString(jsonString, options);
  }

  static equals(a: ExtendedResources | PlainMessage<ExtendedResources> | undefined, b: ExtendedResources | PlainMessage<ExtendedResources> | undefined): boolean {
    return proto3.util.equals(ExtendedResources, a, b);
  }
}

/**
 * Runtime information. This is loosely defined to allow for extensibility.
 *
 * @generated from message flyteidl.core.RuntimeMetadata
 */
export class RuntimeMetadata extends Message<RuntimeMetadata> {
  /**
   * Type of runtime.
   *
   * @generated from field: flyteidl.core.RuntimeMetadata.RuntimeType type = 1;
   */
  type = RuntimeMetadata_RuntimeType.OTHER;

  /**
   * Version of the runtime. All versions should be backward compatible. However, certain cases call for version
   * checks to ensure tighter validation or setting expectations.
   *
   * @generated from field: string version = 2;
   */
  version = "";

  /**
   * +optional It can be used to provide extra information about the runtime (e.g. python, golang... etc.).
   *
   * @generated from field: string flavor = 3;
   */
  flavor = "";

  constructor(data?: PartialMessage<RuntimeMetadata>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.RuntimeMetadata";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "type", kind: "enum", T: proto3.getEnumType(RuntimeMetadata_RuntimeType) },
    { no: 2, name: "version", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "flavor", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): RuntimeMetadata {
    return new RuntimeMetadata().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): RuntimeMetadata {
    return new RuntimeMetadata().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): RuntimeMetadata {
    return new RuntimeMetadata().fromJsonString(jsonString, options);
  }

  static equals(a: RuntimeMetadata | PlainMessage<RuntimeMetadata> | undefined, b: RuntimeMetadata | PlainMessage<RuntimeMetadata> | undefined): boolean {
    return proto3.util.equals(RuntimeMetadata, a, b);
  }
}

/**
 * @generated from enum flyteidl.core.RuntimeMetadata.RuntimeType
 */
export enum RuntimeMetadata_RuntimeType {
  /**
   * @generated from enum value: OTHER = 0;
   */
  OTHER = 0,

  /**
   * @generated from enum value: FLYTE_SDK = 1;
   */
  FLYTE_SDK = 1,
}
// Retrieve enum metadata with: proto3.getEnumType(RuntimeMetadata_RuntimeType)
proto3.util.setEnumType(RuntimeMetadata_RuntimeType, "flyteidl.core.RuntimeMetadata.RuntimeType", [
  { no: 0, name: "OTHER" },
  { no: 1, name: "FLYTE_SDK" },
]);

/**
 * Task Metadata
 *
 * @generated from message flyteidl.core.TaskMetadata
 */
export class TaskMetadata extends Message<TaskMetadata> {
  /**
   * Indicates whether the system should attempt to lookup this task's output to avoid duplication of work.
   *
   * @generated from field: bool discoverable = 1;
   */
  discoverable = false;

  /**
   * Runtime information about the task.
   *
   * @generated from field: flyteidl.core.RuntimeMetadata runtime = 2;
   */
  runtime?: RuntimeMetadata;

  /**
   * The overall timeout of a task including user-triggered retries.
   *
   * @generated from field: google.protobuf.Duration timeout = 4;
   */
  timeout?: Duration;

  /**
   * Number of retries per task.
   *
   * @generated from field: flyteidl.core.RetryStrategy retries = 5;
   */
  retries?: RetryStrategy;

  /**
   * Indicates a logical version to apply to this task for the purpose of discovery.
   *
   * @generated from field: string discovery_version = 6;
   */
  discoveryVersion = "";

  /**
   * If set, this indicates that this task is deprecated.  This will enable owners of tasks to notify consumers
   * of the ending of support for a given task.
   *
   * @generated from field: string deprecated_error_message = 7;
   */
  deprecatedErrorMessage = "";

  /**
   * Identify whether task is interruptible
   *
   * @generated from oneof flyteidl.core.TaskMetadata.interruptible_value
   */
  interruptibleValue: {
    /**
     * @generated from field: bool interruptible = 8;
     */
    value: boolean;
    case: "interruptible";
  } | { case: undefined; value?: undefined } = { case: undefined };

  /**
   * Indicates whether the system should attempt to execute discoverable instances in serial to avoid duplicate work
   *
   * @generated from field: bool cache_serializable = 9;
   */
  cacheSerializable = false;

  /**
   * Indicates whether the task will generate a Deck URI when it finishes executing.
   *
   * @generated from field: bool generates_deck = 10;
   */
  generatesDeck = false;

  /**
   * Arbitrary tags that allow users and the platform to store small but arbitrary labels
   *
   * @generated from field: map<string, string> tags = 11;
   */
  tags: { [key: string]: string } = {};

  /**
   * pod_template_name is the unique name of a PodTemplate k8s resource to be used as the base configuration if this
   * task creates a k8s Pod. If this value is set, the specified PodTemplate will be used instead of, but applied
   * identically as, the default PodTemplate configured in FlytePropeller.
   *
   * @generated from field: string pod_template_name = 12;
   */
  podTemplateName = "";

  /**
   * cache_ignore_input_vars is the input variables that should not be included when calculating hash for cache.
   *
   * @generated from field: repeated string cache_ignore_input_vars = 13;
   */
  cacheIgnoreInputVars: string[] = [];

  /**
   * is_eager indicates whether the task is eager or not.
   * This would be used by CreateTask endpoint.
   *
   * @generated from field: bool is_eager = 14;
   */
  isEager = false;

  constructor(data?: PartialMessage<TaskMetadata>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.TaskMetadata";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "discoverable", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
    { no: 2, name: "runtime", kind: "message", T: RuntimeMetadata },
    { no: 4, name: "timeout", kind: "message", T: Duration },
    { no: 5, name: "retries", kind: "message", T: RetryStrategy },
    { no: 6, name: "discovery_version", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 7, name: "deprecated_error_message", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 8, name: "interruptible", kind: "scalar", T: 8 /* ScalarType.BOOL */, oneof: "interruptible_value" },
    { no: 9, name: "cache_serializable", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
    { no: 10, name: "generates_deck", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
    { no: 11, name: "tags", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
    { no: 12, name: "pod_template_name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 13, name: "cache_ignore_input_vars", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 14, name: "is_eager", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TaskMetadata {
    return new TaskMetadata().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TaskMetadata {
    return new TaskMetadata().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TaskMetadata {
    return new TaskMetadata().fromJsonString(jsonString, options);
  }

  static equals(a: TaskMetadata | PlainMessage<TaskMetadata> | undefined, b: TaskMetadata | PlainMessage<TaskMetadata> | undefined): boolean {
    return proto3.util.equals(TaskMetadata, a, b);
  }
}

/**
 * A Task structure that uniquely identifies a task in the system
 * Tasks are registered as a first step in the system.
 *
 * @generated from message flyteidl.core.TaskTemplate
 */
export class TaskTemplate extends Message<TaskTemplate> {
  /**
   * Auto generated taskId by the system. Task Id uniquely identifies this task globally.
   *
   * @generated from field: flyteidl.core.Identifier id = 1;
   */
  id?: Identifier;

  /**
   * A predefined yet extensible Task type identifier. This can be used to customize any of the components. If no
   * extensions are provided in the system, Flyte will resolve the this task to its TaskCategory and default the
   * implementation registered for the TaskCategory.
   *
   * @generated from field: string type = 2;
   */
  type = "";

  /**
   * Extra metadata about the task.
   *
   * @generated from field: flyteidl.core.TaskMetadata metadata = 3;
   */
  metadata?: TaskMetadata;

  /**
   * A strongly typed interface for the task. This enables others to use this task within a workflow and guarantees
   * compile-time validation of the workflow to avoid costly runtime failures.
   *
   * @generated from field: flyteidl.core.TypedInterface interface = 4;
   */
  interface?: TypedInterface;

  /**
   * Custom data about the task. This is extensible to allow various plugins in the system.
   *
   * @generated from field: google.protobuf.Struct custom = 5;
   */
  custom?: Struct;

  /**
   * Known target types that the system will guarantee plugins for. Custom SDK plugins are allowed to set these if needed.
   * If no corresponding execution-layer plugins are found, the system will default to handling these using built-in
   * handlers.
   *
   * @generated from oneof flyteidl.core.TaskTemplate.target
   */
  target: {
    /**
     * @generated from field: flyteidl.core.Container container = 6;
     */
    value: Container;
    case: "container";
  } | {
    /**
     * @generated from field: flyteidl.core.K8sPod k8s_pod = 17;
     */
    value: K8sPod;
    case: "k8sPod";
  } | {
    /**
     * @generated from field: flyteidl.core.Sql sql = 18;
     */
    value: Sql;
    case: "sql";
  } | { case: undefined; value?: undefined } = { case: undefined };

  /**
   * This can be used to customize task handling at execution time for the same task type.
   *
   * @generated from field: int32 task_type_version = 7;
   */
  taskTypeVersion = 0;

  /**
   * security_context encapsulates security attributes requested to run this task.
   *
   * @generated from field: flyteidl.core.SecurityContext security_context = 8;
   */
  securityContext?: SecurityContext;

  /**
   * Encapsulates all non-standard resources, not captured by
   * v1.ResourceRequirements, to allocate to a task.
   *
   * @generated from field: flyteidl.core.ExtendedResources extended_resources = 9;
   */
  extendedResources?: ExtendedResources;

  /**
   * Metadata about the custom defined for this task. This is extensible to allow various plugins in the system
   * to use as required.
   * reserve the field numbers 1 through 15 for very frequently occurring message elements
   *
   * @generated from field: map<string, string> config = 16;
   */
  config: { [key: string]: string } = {};

  constructor(data?: PartialMessage<TaskTemplate>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.TaskTemplate";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "message", T: Identifier },
    { no: 2, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "metadata", kind: "message", T: TaskMetadata },
    { no: 4, name: "interface", kind: "message", T: TypedInterface },
    { no: 5, name: "custom", kind: "message", T: Struct },
    { no: 6, name: "container", kind: "message", T: Container, oneof: "target" },
    { no: 17, name: "k8s_pod", kind: "message", T: K8sPod, oneof: "target" },
    { no: 18, name: "sql", kind: "message", T: Sql, oneof: "target" },
    { no: 7, name: "task_type_version", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
    { no: 8, name: "security_context", kind: "message", T: SecurityContext },
    { no: 9, name: "extended_resources", kind: "message", T: ExtendedResources },
    { no: 16, name: "config", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TaskTemplate {
    return new TaskTemplate().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TaskTemplate {
    return new TaskTemplate().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TaskTemplate {
    return new TaskTemplate().fromJsonString(jsonString, options);
  }

  static equals(a: TaskTemplate | PlainMessage<TaskTemplate> | undefined, b: TaskTemplate | PlainMessage<TaskTemplate> | undefined): boolean {
    return proto3.util.equals(TaskTemplate, a, b);
  }
}

/**
 * Defines port properties for a container.
 *
 * @generated from message flyteidl.core.ContainerPort
 */
export class ContainerPort extends Message<ContainerPort> {
  /**
   * Number of port to expose on the pod's IP address.
   * This must be a valid port number, 0 < x < 65536.
   *
   * @generated from field: uint32 container_port = 1;
   */
  containerPort = 0;

  constructor(data?: PartialMessage<ContainerPort>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.ContainerPort";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "container_port", kind: "scalar", T: 13 /* ScalarType.UINT32 */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ContainerPort {
    return new ContainerPort().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ContainerPort {
    return new ContainerPort().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ContainerPort {
    return new ContainerPort().fromJsonString(jsonString, options);
  }

  static equals(a: ContainerPort | PlainMessage<ContainerPort> | undefined, b: ContainerPort | PlainMessage<ContainerPort> | undefined): boolean {
    return proto3.util.equals(ContainerPort, a, b);
  }
}

/**
 * @generated from message flyteidl.core.Container
 */
export class Container extends Message<Container> {
  /**
   * Container image url. Eg: docker/redis:latest
   *
   * @generated from field: string image = 1;
   */
  image = "";

  /**
   * Command to be executed, if not provided, the default entrypoint in the container image will be used.
   *
   * @generated from field: repeated string command = 2;
   */
  command: string[] = [];

  /**
   * These will default to Flyte given paths. If provided, the system will not append known paths. If the task still
   * needs flyte's inputs and outputs path, add $(FLYTE_INPUT_FILE), $(FLYTE_OUTPUT_FILE) wherever makes sense and the
   * system will populate these before executing the container.
   *
   * @generated from field: repeated string args = 3;
   */
  args: string[] = [];

  /**
   * Container resources requirement as specified by the container engine.
   *
   * @generated from field: flyteidl.core.Resources resources = 4;
   */
  resources?: Resources;

  /**
   * Environment variables will be set as the container is starting up.
   *
   * @generated from field: repeated flyteidl.core.KeyValuePair env = 5;
   */
  env: KeyValuePair[] = [];

  /**
   * Allows extra configs to be available for the container.
   * TODO: elaborate on how configs will become available.
   * Deprecated, please use TaskTemplate.config instead.
   *
   * @generated from field: repeated flyteidl.core.KeyValuePair config = 6 [deprecated = true];
   * @deprecated
   */
  config: KeyValuePair[] = [];

  /**
   * Ports to open in the container. This feature is not supported by all execution engines. (e.g. supported on K8s but
   * not supported on AWS Batch)
   * Only K8s
   *
   * @generated from field: repeated flyteidl.core.ContainerPort ports = 7;
   */
  ports: ContainerPort[] = [];

  /**
   * BETA: Optional configuration for DataLoading. If not specified, then default values are used.
   * This makes it possible to to run a completely portable container, that uses inputs and outputs
   * only from the local file-system and without having any reference to flyteidl. This is supported only on K8s at the moment.
   * If data loading is enabled, then data will be mounted in accompanying directories specified in the DataLoadingConfig. If the directories
   * are not specified, inputs will be mounted onto and outputs will be uploaded from a pre-determined file-system path. Refer to the documentation
   * to understand the default paths.
   * Only K8s
   *
   * @generated from field: flyteidl.core.DataLoadingConfig data_config = 9;
   */
  dataConfig?: DataLoadingConfig;

  /**
   * @generated from field: flyteidl.core.Container.Architecture architecture = 10;
   */
  architecture = Container_Architecture.UNKNOWN;

  constructor(data?: PartialMessage<Container>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.Container";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "image", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "command", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 3, name: "args", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 4, name: "resources", kind: "message", T: Resources },
    { no: 5, name: "env", kind: "message", T: KeyValuePair, repeated: true },
    { no: 6, name: "config", kind: "message", T: KeyValuePair, repeated: true },
    { no: 7, name: "ports", kind: "message", T: ContainerPort, repeated: true },
    { no: 9, name: "data_config", kind: "message", T: DataLoadingConfig },
    { no: 10, name: "architecture", kind: "enum", T: proto3.getEnumType(Container_Architecture) },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Container {
    return new Container().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Container {
    return new Container().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Container {
    return new Container().fromJsonString(jsonString, options);
  }

  static equals(a: Container | PlainMessage<Container> | undefined, b: Container | PlainMessage<Container> | undefined): boolean {
    return proto3.util.equals(Container, a, b);
  }
}

/**
 * Architecture-type the container image supports.
 *
 * @generated from enum flyteidl.core.Container.Architecture
 */
export enum Container_Architecture {
  /**
   * @generated from enum value: UNKNOWN = 0;
   */
  UNKNOWN = 0,

  /**
   * @generated from enum value: AMD64 = 1;
   */
  AMD64 = 1,

  /**
   * @generated from enum value: ARM64 = 2;
   */
  ARM64 = 2,

  /**
   * @generated from enum value: ARM_V6 = 3;
   */
  ARM_V6 = 3,

  /**
   * @generated from enum value: ARM_V7 = 4;
   */
  ARM_V7 = 4,
}
// Retrieve enum metadata with: proto3.getEnumType(Container_Architecture)
proto3.util.setEnumType(Container_Architecture, "flyteidl.core.Container.Architecture", [
  { no: 0, name: "UNKNOWN" },
  { no: 1, name: "AMD64" },
  { no: 2, name: "ARM64" },
  { no: 3, name: "ARM_V6" },
  { no: 4, name: "ARM_V7" },
]);

/**
 * Strategy to use when dealing with Blob, Schema, or multipart blob data (large datasets)
 *
 * @generated from message flyteidl.core.IOStrategy
 */
export class IOStrategy extends Message<IOStrategy> {
  /**
   * Mode to use to manage downloads
   *
   * @generated from field: flyteidl.core.IOStrategy.DownloadMode download_mode = 1;
   */
  downloadMode = IOStrategy_DownloadMode.DOWNLOAD_EAGER;

  /**
   * Mode to use to manage uploads
   *
   * @generated from field: flyteidl.core.IOStrategy.UploadMode upload_mode = 2;
   */
  uploadMode = IOStrategy_UploadMode.UPLOAD_ON_EXIT;

  constructor(data?: PartialMessage<IOStrategy>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.IOStrategy";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "download_mode", kind: "enum", T: proto3.getEnumType(IOStrategy_DownloadMode) },
    { no: 2, name: "upload_mode", kind: "enum", T: proto3.getEnumType(IOStrategy_UploadMode) },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): IOStrategy {
    return new IOStrategy().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): IOStrategy {
    return new IOStrategy().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): IOStrategy {
    return new IOStrategy().fromJsonString(jsonString, options);
  }

  static equals(a: IOStrategy | PlainMessage<IOStrategy> | undefined, b: IOStrategy | PlainMessage<IOStrategy> | undefined): boolean {
    return proto3.util.equals(IOStrategy, a, b);
  }
}

/**
 * Mode to use for downloading
 *
 * @generated from enum flyteidl.core.IOStrategy.DownloadMode
 */
export enum IOStrategy_DownloadMode {
  /**
   * All data will be downloaded before the main container is executed
   *
   * @generated from enum value: DOWNLOAD_EAGER = 0;
   */
  DOWNLOAD_EAGER = 0,

  /**
   * Data will be downloaded as a stream and an End-Of-Stream marker will be written to indicate all data has been downloaded. Refer to protocol for details
   *
   * @generated from enum value: DOWNLOAD_STREAM = 1;
   */
  DOWNLOAD_STREAM = 1,

  /**
   * Large objects (offloaded) will not be downloaded
   *
   * @generated from enum value: DO_NOT_DOWNLOAD = 2;
   */
  DO_NOT_DOWNLOAD = 2,
}
// Retrieve enum metadata with: proto3.getEnumType(IOStrategy_DownloadMode)
proto3.util.setEnumType(IOStrategy_DownloadMode, "flyteidl.core.IOStrategy.DownloadMode", [
  { no: 0, name: "DOWNLOAD_EAGER" },
  { no: 1, name: "DOWNLOAD_STREAM" },
  { no: 2, name: "DO_NOT_DOWNLOAD" },
]);

/**
 * Mode to use for uploading
 *
 * @generated from enum flyteidl.core.IOStrategy.UploadMode
 */
export enum IOStrategy_UploadMode {
  /**
   * All data will be uploaded after the main container exits
   *
   * @generated from enum value: UPLOAD_ON_EXIT = 0;
   */
  UPLOAD_ON_EXIT = 0,

  /**
   * Data will be uploaded as it appears. Refer to protocol specification for details
   *
   * @generated from enum value: UPLOAD_EAGER = 1;
   */
  UPLOAD_EAGER = 1,

  /**
   * Data will not be uploaded, only references will be written
   *
   * @generated from enum value: DO_NOT_UPLOAD = 2;
   */
  DO_NOT_UPLOAD = 2,
}
// Retrieve enum metadata with: proto3.getEnumType(IOStrategy_UploadMode)
proto3.util.setEnumType(IOStrategy_UploadMode, "flyteidl.core.IOStrategy.UploadMode", [
  { no: 0, name: "UPLOAD_ON_EXIT" },
  { no: 1, name: "UPLOAD_EAGER" },
  { no: 2, name: "DO_NOT_UPLOAD" },
]);

/**
 * This configuration allows executing raw containers in Flyte using the Flyte CoPilot system.
 * Flyte CoPilot, eliminates the needs of flytekit or sdk inside the container. Any inputs required by the users container are side-loaded in the input_path
 * Any outputs generated by the user container - within output_path are automatically uploaded.
 *
 * @generated from message flyteidl.core.DataLoadingConfig
 */
export class DataLoadingConfig extends Message<DataLoadingConfig> {
  /**
   * Flag enables DataLoading Config. If this is not set, data loading will not be used!
   *
   * @generated from field: bool enabled = 1;
   */
  enabled = false;

  /**
   * File system path (start at root). This folder will contain all the inputs exploded to a separate file.
   * Example, if the input interface needs (x: int, y: blob, z: multipart_blob) and the input path is '/var/flyte/inputs', then the file system will look like
   * /var/flyte/inputs/inputs.<metadata format dependent -> .pb .json .yaml> -> Format as defined previously. The Blob and Multipart blob will reference local filesystem instead of remote locations
   * /var/flyte/inputs/x -> X is a file that contains the value of x (integer) in string format
   * /var/flyte/inputs/y -> Y is a file in Binary format
   * /var/flyte/inputs/z/... -> Note Z itself is a directory
   * More information about the protocol - refer to docs #TODO reference docs here
   *
   * @generated from field: string input_path = 2;
   */
  inputPath = "";

  /**
   * File system path (start at root). This folder should contain all the outputs for the task as individual files and/or an error text file
   *
   * @generated from field: string output_path = 3;
   */
  outputPath = "";

  /**
   * In the inputs folder, there will be an additional summary/metadata file that contains references to all files or inlined primitive values.
   * This format decides the actual encoding for the data. Refer to the encoding to understand the specifics of the contents and the encoding
   *
   * @generated from field: flyteidl.core.DataLoadingConfig.LiteralMapFormat format = 4;
   */
  format = DataLoadingConfig_LiteralMapFormat.JSON;

  /**
   * @generated from field: flyteidl.core.IOStrategy io_strategy = 5;
   */
  ioStrategy?: IOStrategy;

  constructor(data?: PartialMessage<DataLoadingConfig>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.DataLoadingConfig";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "enabled", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
    { no: 2, name: "input_path", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "output_path", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 4, name: "format", kind: "enum", T: proto3.getEnumType(DataLoadingConfig_LiteralMapFormat) },
    { no: 5, name: "io_strategy", kind: "message", T: IOStrategy },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): DataLoadingConfig {
    return new DataLoadingConfig().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): DataLoadingConfig {
    return new DataLoadingConfig().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): DataLoadingConfig {
    return new DataLoadingConfig().fromJsonString(jsonString, options);
  }

  static equals(a: DataLoadingConfig | PlainMessage<DataLoadingConfig> | undefined, b: DataLoadingConfig | PlainMessage<DataLoadingConfig> | undefined): boolean {
    return proto3.util.equals(DataLoadingConfig, a, b);
  }
}

/**
 * LiteralMapFormat decides the encoding format in which the input metadata should be made available to the containers.
 * If the user has access to the protocol buffer definitions, it is recommended to use the PROTO format.
 * JSON and YAML do not need any protobuf definitions to read it
 * All remote references in core.LiteralMap are replaced with local filesystem references (the data is downloaded to local filesystem)
 *
 * @generated from enum flyteidl.core.DataLoadingConfig.LiteralMapFormat
 */
export enum DataLoadingConfig_LiteralMapFormat {
  /**
   * JSON / YAML for the metadata (which contains inlined primitive values). The representation is inline with the standard json specification as specified - https://www.json.org/json-en.html
   *
   * @generated from enum value: JSON = 0;
   */
  JSON = 0,

  /**
   * @generated from enum value: YAML = 1;
   */
  YAML = 1,

  /**
   * Proto is a serialized binary of `core.LiteralMap` defined in flyteidl/core
   *
   * @generated from enum value: PROTO = 2;
   */
  PROTO = 2,
}
// Retrieve enum metadata with: proto3.getEnumType(DataLoadingConfig_LiteralMapFormat)
proto3.util.setEnumType(DataLoadingConfig_LiteralMapFormat, "flyteidl.core.DataLoadingConfig.LiteralMapFormat", [
  { no: 0, name: "JSON" },
  { no: 1, name: "YAML" },
  { no: 2, name: "PROTO" },
]);

/**
 * Defines a pod spec and additional pod metadata that is created when a task is executed.
 *
 * @generated from message flyteidl.core.K8sPod
 */
export class K8sPod extends Message<K8sPod> {
  /**
   * Contains additional metadata for building a kubernetes pod.
   *
   * @generated from field: flyteidl.core.K8sObjectMetadata metadata = 1;
   */
  metadata?: K8sObjectMetadata;

  /**
   * Defines the primary pod spec created when a task is executed.
   * This should be a JSON-marshalled pod spec, which can be defined in
   * - go, using: https://github.com/kubernetes/api/blob/release-1.21/core/v1/types.go#L2936
   * - python: using https://github.com/kubernetes-client/python/blob/release-19.0/kubernetes/client/models/v1_pod_spec.py
   *
   * @generated from field: google.protobuf.Struct pod_spec = 2;
   */
  podSpec?: Struct;

  /**
   * BETA: Optional configuration for DataLoading. If not specified, then default values are used.
   * This makes it possible to to run a completely portable container, that uses inputs and outputs
   * only from the local file-system and without having any reference to flytekit. This is supported only on K8s at the moment.
   * If data loading is enabled, then data will be mounted in accompanying directories specified in the DataLoadingConfig. If the directories
   * are not specified, inputs will be mounted onto and outputs will be uploaded from a pre-determined file-system path. Refer to the documentation
   * to understand the default paths.
   * Only K8s
   *
   * @generated from field: flyteidl.core.DataLoadingConfig data_config = 3;
   */
  dataConfig?: DataLoadingConfig;

  constructor(data?: PartialMessage<K8sPod>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.K8sPod";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: K8sObjectMetadata },
    { no: 2, name: "pod_spec", kind: "message", T: Struct },
    { no: 3, name: "data_config", kind: "message", T: DataLoadingConfig },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): K8sPod {
    return new K8sPod().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): K8sPod {
    return new K8sPod().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): K8sPod {
    return new K8sPod().fromJsonString(jsonString, options);
  }

  static equals(a: K8sPod | PlainMessage<K8sPod> | undefined, b: K8sPod | PlainMessage<K8sPod> | undefined): boolean {
    return proto3.util.equals(K8sPod, a, b);
  }
}

/**
 * Metadata for building a kubernetes object when a task is executed.
 *
 * @generated from message flyteidl.core.K8sObjectMetadata
 */
export class K8sObjectMetadata extends Message<K8sObjectMetadata> {
  /**
   * Optional labels to add to the pod definition.
   *
   * @generated from field: map<string, string> labels = 1;
   */
  labels: { [key: string]: string } = {};

  /**
   * Optional annotations to add to the pod definition.
   *
   * @generated from field: map<string, string> annotations = 2;
   */
  annotations: { [key: string]: string } = {};

  constructor(data?: PartialMessage<K8sObjectMetadata>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.K8sObjectMetadata";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "labels", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
    { no: 2, name: "annotations", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): K8sObjectMetadata {
    return new K8sObjectMetadata().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): K8sObjectMetadata {
    return new K8sObjectMetadata().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): K8sObjectMetadata {
    return new K8sObjectMetadata().fromJsonString(jsonString, options);
  }

  static equals(a: K8sObjectMetadata | PlainMessage<K8sObjectMetadata> | undefined, b: K8sObjectMetadata | PlainMessage<K8sObjectMetadata> | undefined): boolean {
    return proto3.util.equals(K8sObjectMetadata, a, b);
  }
}

/**
 * Sql represents a generic sql workload with a statement and dialect.
 *
 * @generated from message flyteidl.core.Sql
 */
export class Sql extends Message<Sql> {
  /**
   * The actual query to run, the query can have templated parameters.
   * We use Flyte's Golang templating format for Query templating.
   * For example,
   * insert overwrite directory '{{ .rawOutputDataPrefix }}' stored as parquet
   * select *
   * from my_table
   * where ds = '{{ .Inputs.ds }}'
   *
   * @generated from field: string statement = 1;
   */
  statement = "";

  /**
   * @generated from field: flyteidl.core.Sql.Dialect dialect = 2;
   */
  dialect = Sql_Dialect.UNDEFINED;

  constructor(data?: PartialMessage<Sql>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.Sql";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "statement", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "dialect", kind: "enum", T: proto3.getEnumType(Sql_Dialect) },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Sql {
    return new Sql().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Sql {
    return new Sql().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Sql {
    return new Sql().fromJsonString(jsonString, options);
  }

  static equals(a: Sql | PlainMessage<Sql> | undefined, b: Sql | PlainMessage<Sql> | undefined): boolean {
    return proto3.util.equals(Sql, a, b);
  }
}

/**
 * The dialect of the SQL statement. This is used to validate and parse SQL statements at compilation time to avoid
 * expensive runtime operations. If set to an unsupported dialect, no validation will be done on the statement.
 * We support the following dialect: ansi, hive.
 *
 * @generated from enum flyteidl.core.Sql.Dialect
 */
export enum Sql_Dialect {
  /**
   * @generated from enum value: UNDEFINED = 0;
   */
  UNDEFINED = 0,

  /**
   * @generated from enum value: ANSI = 1;
   */
  ANSI = 1,

  /**
   * @generated from enum value: HIVE = 2;
   */
  HIVE = 2,

  /**
   * @generated from enum value: OTHER = 3;
   */
  OTHER = 3,
}
// Retrieve enum metadata with: proto3.getEnumType(Sql_Dialect)
proto3.util.setEnumType(Sql_Dialect, "flyteidl.core.Sql.Dialect", [
  { no: 0, name: "UNDEFINED" },
  { no: 1, name: "ANSI" },
  { no: 2, name: "HIVE" },
  { no: 3, name: "OTHER" },
]);

