// @generated by protoc-gen-es v1.7.2 with parameter "target=ts"
// @generated from file flyteidl/admin/agent.proto (package flyteidl.admin, syntax proto3)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { Duration, Message, proto3, protoInt64, Struct, Timestamp } from "@bufbuild/protobuf";
import { TaskExecutionIdentifier } from "../core/identifier_pb.js";
import { TaskNodeOverrides } from "../core/workflow_pb.js";
import { Identity } from "../core/security_pb.js";
import { LiteralMap } from "../core/literals_pb.js";
import { TaskTemplate } from "../core/tasks_pb.js";
import { ExecutionError_ErrorKind, TaskExecution_Phase, TaskLog } from "../core/execution_pb.js";
import { ExecutionMetricResult } from "../core/metrics_pb.js";

/**
 * The state of the execution is used to control its visibility in the UI/CLI.
 *
 * @generated from enum flyteidl.admin.State
 * @deprecated
 */
export enum State {
  /**
   * @generated from enum value: RETRYABLE_FAILURE = 0;
   */
  RETRYABLE_FAILURE = 0,

  /**
   * @generated from enum value: PERMANENT_FAILURE = 1;
   */
  PERMANENT_FAILURE = 1,

  /**
   * @generated from enum value: PENDING = 2;
   */
  PENDING = 2,

  /**
   * @generated from enum value: RUNNING = 3;
   */
  RUNNING = 3,

  /**
   * @generated from enum value: SUCCEEDED = 4;
   */
  SUCCEEDED = 4,
}
// Retrieve enum metadata with: proto3.getEnumType(State)
proto3.util.setEnumType(State, "flyteidl.admin.State", [
  { no: 0, name: "RETRYABLE_FAILURE" },
  { no: 1, name: "PERMANENT_FAILURE" },
  { no: 2, name: "PENDING" },
  { no: 3, name: "RUNNING" },
  { no: 4, name: "SUCCEEDED" },
]);

/**
 * Represents a subset of runtime task execution metadata that are relevant to external plugins.
 *
 * ID of the task execution
 *
 * @generated from message flyteidl.admin.TaskExecutionMetadata
 */
export class TaskExecutionMetadata extends Message<TaskExecutionMetadata> {
  /**
   * @generated from field: flyteidl.core.TaskExecutionIdentifier task_execution_id = 1;
   */
  taskExecutionId?: TaskExecutionIdentifier;

  /**
   * k8s namespace where the task is executed in
   *
   * @generated from field: string namespace = 2;
   */
  namespace = "";

  /**
   * Labels attached to the task execution
   *
   * @generated from field: map<string, string> labels = 3;
   */
  labels: { [key: string]: string } = {};

  /**
   * Annotations attached to the task execution
   *
   * @generated from field: map<string, string> annotations = 4;
   */
  annotations: { [key: string]: string } = {};

  /**
   * k8s service account associated with the task execution
   *
   * @generated from field: string k8s_service_account = 5;
   */
  k8sServiceAccount = "";

  /**
   * Environment variables attached to the task execution
   *
   * @generated from field: map<string, string> environment_variables = 6;
   */
  environmentVariables: { [key: string]: string } = {};

  /**
   * Represents the maximum number of attempts allowed for a task.
   * If a task fails, it can be retried up to this maximum number of attempts.
   *
   * @generated from field: int32 max_attempts = 7;
   */
  maxAttempts = 0;

  /**
   * Indicates whether the task execution can be interrupted.
   * If set to true, the task can be stopped before completion.
   *
   * @generated from field: bool interruptible = 8;
   */
  interruptible = false;

  /**
   * Specifies the threshold for failure count at which the interruptible property
   * will take effect. If the number of consecutive task failures exceeds this threshold,
   * interruptible behavior will be activated.
   *
   * @generated from field: int32 interruptible_failure_threshold = 9;
   */
  interruptibleFailureThreshold = 0;

  /**
   * Overrides for specific properties of the task node.
   * These overrides can be used to customize the behavior of the task node.
   *
   * @generated from field: flyteidl.core.TaskNodeOverrides overrides = 10;
   */
  overrides?: TaskNodeOverrides;

  /**
   * Identity of user running this task execution
   *
   * @generated from field: flyteidl.core.Identity identity = 11;
   */
  identity?: Identity;

  constructor(data?: PartialMessage<TaskExecutionMetadata>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.TaskExecutionMetadata";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "task_execution_id", kind: "message", T: TaskExecutionIdentifier },
    { no: 2, name: "namespace", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "labels", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
    { no: 4, name: "annotations", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
    { no: 5, name: "k8s_service_account", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 6, name: "environment_variables", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
    { no: 7, name: "max_attempts", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
    { no: 8, name: "interruptible", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
    { no: 9, name: "interruptible_failure_threshold", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
    { no: 10, name: "overrides", kind: "message", T: TaskNodeOverrides },
    { no: 11, name: "identity", kind: "message", T: Identity },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TaskExecutionMetadata {
    return new TaskExecutionMetadata().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TaskExecutionMetadata {
    return new TaskExecutionMetadata().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TaskExecutionMetadata {
    return new TaskExecutionMetadata().fromJsonString(jsonString, options);
  }

  static equals(a: TaskExecutionMetadata | PlainMessage<TaskExecutionMetadata> | undefined, b: TaskExecutionMetadata | PlainMessage<TaskExecutionMetadata> | undefined): boolean {
    return proto3.util.equals(TaskExecutionMetadata, a, b);
  }
}

/**
 * Represents a request structure to create task.
 *
 * @generated from message flyteidl.admin.CreateTaskRequest
 */
export class CreateTaskRequest extends Message<CreateTaskRequest> {
  /**
   * The inputs required to start the execution. All required inputs must be
   * included in this map. If not required and not provided, defaults apply.
   * +optional
   *
   * @generated from field: flyteidl.core.LiteralMap inputs = 1;
   */
  inputs?: LiteralMap;

  /**
   * Template of the task that encapsulates all the metadata of the task.
   *
   * @generated from field: flyteidl.core.TaskTemplate template = 2;
   */
  template?: TaskTemplate;

  /**
   * Prefix for where task output data will be written. (e.g. s3://my-bucket/randomstring)
   *
   * @generated from field: string output_prefix = 3;
   */
  outputPrefix = "";

  /**
   * subset of runtime task execution metadata.
   *
   * @generated from field: flyteidl.admin.TaskExecutionMetadata task_execution_metadata = 4;
   */
  taskExecutionMetadata?: TaskExecutionMetadata;

  constructor(data?: PartialMessage<CreateTaskRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.CreateTaskRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "inputs", kind: "message", T: LiteralMap },
    { no: 2, name: "template", kind: "message", T: TaskTemplate },
    { no: 3, name: "output_prefix", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 4, name: "task_execution_metadata", kind: "message", T: TaskExecutionMetadata },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CreateTaskRequest {
    return new CreateTaskRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CreateTaskRequest {
    return new CreateTaskRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CreateTaskRequest {
    return new CreateTaskRequest().fromJsonString(jsonString, options);
  }

  static equals(a: CreateTaskRequest | PlainMessage<CreateTaskRequest> | undefined, b: CreateTaskRequest | PlainMessage<CreateTaskRequest> | undefined): boolean {
    return proto3.util.equals(CreateTaskRequest, a, b);
  }
}

/**
 * Represents a create response structure.
 *
 * @generated from message flyteidl.admin.CreateTaskResponse
 */
export class CreateTaskResponse extends Message<CreateTaskResponse> {
  /**
   * ResourceMeta is created by the agent. It could be a string (jobId) or a dict (more complex metadata).
   *
   * @generated from field: bytes resource_meta = 1;
   */
  resourceMeta = new Uint8Array(0);

  constructor(data?: PartialMessage<CreateTaskResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.CreateTaskResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "resource_meta", kind: "scalar", T: 12 /* ScalarType.BYTES */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CreateTaskResponse {
    return new CreateTaskResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CreateTaskResponse {
    return new CreateTaskResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CreateTaskResponse {
    return new CreateTaskResponse().fromJsonString(jsonString, options);
  }

  static equals(a: CreateTaskResponse | PlainMessage<CreateTaskResponse> | undefined, b: CreateTaskResponse | PlainMessage<CreateTaskResponse> | undefined): boolean {
    return proto3.util.equals(CreateTaskResponse, a, b);
  }
}

/**
 * @generated from message flyteidl.admin.CreateRequestHeader
 */
export class CreateRequestHeader extends Message<CreateRequestHeader> {
  /**
   * Template of the task that encapsulates all the metadata of the task.
   *
   * @generated from field: flyteidl.core.TaskTemplate template = 1;
   */
  template?: TaskTemplate;

  /**
   * Prefix for where task output data will be written. (e.g. s3://my-bucket/randomstring)
   *
   * @generated from field: string output_prefix = 2;
   */
  outputPrefix = "";

  /**
   * subset of runtime task execution metadata.
   *
   * @generated from field: flyteidl.admin.TaskExecutionMetadata task_execution_metadata = 3;
   */
  taskExecutionMetadata?: TaskExecutionMetadata;

  /**
   * MaxDatasetSizeBytes is the maximum size of the dataset that can be generated by the task.
   *
   * @generated from field: int64 max_dataset_size_bytes = 4;
   */
  maxDatasetSizeBytes = protoInt64.zero;

  constructor(data?: PartialMessage<CreateRequestHeader>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.CreateRequestHeader";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "template", kind: "message", T: TaskTemplate },
    { no: 2, name: "output_prefix", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "task_execution_metadata", kind: "message", T: TaskExecutionMetadata },
    { no: 4, name: "max_dataset_size_bytes", kind: "scalar", T: 3 /* ScalarType.INT64 */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CreateRequestHeader {
    return new CreateRequestHeader().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CreateRequestHeader {
    return new CreateRequestHeader().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CreateRequestHeader {
    return new CreateRequestHeader().fromJsonString(jsonString, options);
  }

  static equals(a: CreateRequestHeader | PlainMessage<CreateRequestHeader> | undefined, b: CreateRequestHeader | PlainMessage<CreateRequestHeader> | undefined): boolean {
    return proto3.util.equals(CreateRequestHeader, a, b);
  }
}

/**
 * @generated from message flyteidl.admin.ExecuteTaskSyncRequest
 */
export class ExecuteTaskSyncRequest extends Message<ExecuteTaskSyncRequest> {
  /**
   * @generated from oneof flyteidl.admin.ExecuteTaskSyncRequest.part
   */
  part: {
    /**
     * @generated from field: flyteidl.admin.CreateRequestHeader header = 1;
     */
    value: CreateRequestHeader;
    case: "header";
  } | {
    /**
     * @generated from field: flyteidl.core.LiteralMap inputs = 2;
     */
    value: LiteralMap;
    case: "inputs";
  } | { case: undefined; value?: undefined } = { case: undefined };

  constructor(data?: PartialMessage<ExecuteTaskSyncRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ExecuteTaskSyncRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "header", kind: "message", T: CreateRequestHeader, oneof: "part" },
    { no: 2, name: "inputs", kind: "message", T: LiteralMap, oneof: "part" },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExecuteTaskSyncRequest {
    return new ExecuteTaskSyncRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExecuteTaskSyncRequest {
    return new ExecuteTaskSyncRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExecuteTaskSyncRequest {
    return new ExecuteTaskSyncRequest().fromJsonString(jsonString, options);
  }

  static equals(a: ExecuteTaskSyncRequest | PlainMessage<ExecuteTaskSyncRequest> | undefined, b: ExecuteTaskSyncRequest | PlainMessage<ExecuteTaskSyncRequest> | undefined): boolean {
    return proto3.util.equals(ExecuteTaskSyncRequest, a, b);
  }
}

/**
 * @generated from message flyteidl.admin.ExecuteTaskSyncResponseHeader
 */
export class ExecuteTaskSyncResponseHeader extends Message<ExecuteTaskSyncResponseHeader> {
  /**
   * @generated from field: flyteidl.admin.Resource resource = 1;
   */
  resource?: Resource;

  constructor(data?: PartialMessage<ExecuteTaskSyncResponseHeader>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ExecuteTaskSyncResponseHeader";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "resource", kind: "message", T: Resource },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExecuteTaskSyncResponseHeader {
    return new ExecuteTaskSyncResponseHeader().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExecuteTaskSyncResponseHeader {
    return new ExecuteTaskSyncResponseHeader().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExecuteTaskSyncResponseHeader {
    return new ExecuteTaskSyncResponseHeader().fromJsonString(jsonString, options);
  }

  static equals(a: ExecuteTaskSyncResponseHeader | PlainMessage<ExecuteTaskSyncResponseHeader> | undefined, b: ExecuteTaskSyncResponseHeader | PlainMessage<ExecuteTaskSyncResponseHeader> | undefined): boolean {
    return proto3.util.equals(ExecuteTaskSyncResponseHeader, a, b);
  }
}

/**
 * @generated from message flyteidl.admin.ExecuteTaskSyncResponse
 */
export class ExecuteTaskSyncResponse extends Message<ExecuteTaskSyncResponse> {
  /**
   * Metadata is created by the agent. It could be a string (jobId) or a dict (more complex metadata).
   * Resource is for synchronous task execution.
   *
   * @generated from oneof flyteidl.admin.ExecuteTaskSyncResponse.res
   */
  res: {
    /**
     * @generated from field: flyteidl.admin.ExecuteTaskSyncResponseHeader header = 1;
     */
    value: ExecuteTaskSyncResponseHeader;
    case: "header";
  } | {
    /**
     * @generated from field: flyteidl.core.LiteralMap outputs = 2;
     */
    value: LiteralMap;
    case: "outputs";
  } | { case: undefined; value?: undefined } = { case: undefined };

  constructor(data?: PartialMessage<ExecuteTaskSyncResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ExecuteTaskSyncResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "header", kind: "message", T: ExecuteTaskSyncResponseHeader, oneof: "res" },
    { no: 2, name: "outputs", kind: "message", T: LiteralMap, oneof: "res" },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExecuteTaskSyncResponse {
    return new ExecuteTaskSyncResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExecuteTaskSyncResponse {
    return new ExecuteTaskSyncResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExecuteTaskSyncResponse {
    return new ExecuteTaskSyncResponse().fromJsonString(jsonString, options);
  }

  static equals(a: ExecuteTaskSyncResponse | PlainMessage<ExecuteTaskSyncResponse> | undefined, b: ExecuteTaskSyncResponse | PlainMessage<ExecuteTaskSyncResponse> | undefined): boolean {
    return proto3.util.equals(ExecuteTaskSyncResponse, a, b);
  }
}

/**
 * A message used to fetch a job resource from flyte agent server.
 *
 * @generated from message flyteidl.admin.GetTaskRequest
 */
export class GetTaskRequest extends Message<GetTaskRequest> {
  /**
   * A predefined yet extensible Task type identifier.
   *
   * @generated from field: string task_type = 1 [deprecated = true];
   * @deprecated
   */
  taskType = "";

  /**
   * Metadata about the resource to be pass to the agent.
   *
   * @generated from field: bytes resource_meta = 2;
   */
  resourceMeta = new Uint8Array(0);

  /**
   * A predefined yet extensible Task type identifier.
   *
   * @generated from field: flyteidl.admin.TaskCategory task_category = 3;
   */
  taskCategory?: TaskCategory;

  constructor(data?: PartialMessage<GetTaskRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.GetTaskRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "task_type", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "resource_meta", kind: "scalar", T: 12 /* ScalarType.BYTES */ },
    { no: 3, name: "task_category", kind: "message", T: TaskCategory },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GetTaskRequest {
    return new GetTaskRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GetTaskRequest {
    return new GetTaskRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GetTaskRequest {
    return new GetTaskRequest().fromJsonString(jsonString, options);
  }

  static equals(a: GetTaskRequest | PlainMessage<GetTaskRequest> | undefined, b: GetTaskRequest | PlainMessage<GetTaskRequest> | undefined): boolean {
    return proto3.util.equals(GetTaskRequest, a, b);
  }
}

/**
 * Response to get an individual task resource.
 *
 * @generated from message flyteidl.admin.GetTaskResponse
 */
export class GetTaskResponse extends Message<GetTaskResponse> {
  /**
   * @generated from field: flyteidl.admin.Resource resource = 1;
   */
  resource?: Resource;

  constructor(data?: PartialMessage<GetTaskResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.GetTaskResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "resource", kind: "message", T: Resource },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GetTaskResponse {
    return new GetTaskResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GetTaskResponse {
    return new GetTaskResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GetTaskResponse {
    return new GetTaskResponse().fromJsonString(jsonString, options);
  }

  static equals(a: GetTaskResponse | PlainMessage<GetTaskResponse> | undefined, b: GetTaskResponse | PlainMessage<GetTaskResponse> | undefined): boolean {
    return proto3.util.equals(GetTaskResponse, a, b);
  }
}

/**
 * @generated from message flyteidl.admin.Resource
 */
export class Resource extends Message<Resource> {
  /**
   * DEPRECATED. The state of the execution is used to control its visibility in the UI/CLI.
   *
   * @generated from field: flyteidl.admin.State state = 1 [deprecated = true];
   * @deprecated
   */
  state = State.RETRYABLE_FAILURE;

  /**
   * The outputs of the execution. It's typically used by sql task. Agent service will create a
   * Structured dataset pointing to the query result table.
   * +optional
   *
   * @generated from field: flyteidl.core.LiteralMap outputs = 2;
   */
  outputs?: LiteralMap;

  /**
   * A descriptive message for the current state. e.g. waiting for cluster.
   *
   * @generated from field: string message = 3;
   */
  message = "";

  /**
   * log information for the task execution.
   *
   * @generated from field: repeated flyteidl.core.TaskLog log_links = 4;
   */
  logLinks: TaskLog[] = [];

  /**
   * The phase of the execution is used to determine the phase of the plugin's execution.
   *
   * @generated from field: flyteidl.core.TaskExecution.Phase phase = 5;
   */
  phase = TaskExecution_Phase.UNDEFINED;

  /**
   * Custom data specific to the agent.
   *
   * @generated from field: google.protobuf.Struct custom_info = 6;
   */
  customInfo?: Struct;

  /**
   * The error raised during execution
   *
   * @generated from field: flyteidl.admin.AgentError agent_error = 7;
   */
  agentError?: AgentError;

  constructor(data?: PartialMessage<Resource>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.Resource";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "state", kind: "enum", T: proto3.getEnumType(State) },
    { no: 2, name: "outputs", kind: "message", T: LiteralMap },
    { no: 3, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 4, name: "log_links", kind: "message", T: TaskLog, repeated: true },
    { no: 5, name: "phase", kind: "enum", T: proto3.getEnumType(TaskExecution_Phase) },
    { no: 6, name: "custom_info", kind: "message", T: Struct },
    { no: 7, name: "agent_error", kind: "message", T: AgentError },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Resource {
    return new Resource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Resource {
    return new Resource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Resource {
    return new Resource().fromJsonString(jsonString, options);
  }

  static equals(a: Resource | PlainMessage<Resource> | undefined, b: Resource | PlainMessage<Resource> | undefined): boolean {
    return proto3.util.equals(Resource, a, b);
  }
}

/**
 * A message used to delete a task.
 *
 * @generated from message flyteidl.admin.DeleteTaskRequest
 */
export class DeleteTaskRequest extends Message<DeleteTaskRequest> {
  /**
   * A predefined yet extensible Task type identifier.
   *
   * @generated from field: string task_type = 1 [deprecated = true];
   * @deprecated
   */
  taskType = "";

  /**
   * Metadata about the resource to be pass to the agent.
   *
   * @generated from field: bytes resource_meta = 2;
   */
  resourceMeta = new Uint8Array(0);

  /**
   * A predefined yet extensible Task type identifier.
   *
   * @generated from field: flyteidl.admin.TaskCategory task_category = 3;
   */
  taskCategory?: TaskCategory;

  constructor(data?: PartialMessage<DeleteTaskRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.DeleteTaskRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "task_type", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "resource_meta", kind: "scalar", T: 12 /* ScalarType.BYTES */ },
    { no: 3, name: "task_category", kind: "message", T: TaskCategory },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): DeleteTaskRequest {
    return new DeleteTaskRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): DeleteTaskRequest {
    return new DeleteTaskRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): DeleteTaskRequest {
    return new DeleteTaskRequest().fromJsonString(jsonString, options);
  }

  static equals(a: DeleteTaskRequest | PlainMessage<DeleteTaskRequest> | undefined, b: DeleteTaskRequest | PlainMessage<DeleteTaskRequest> | undefined): boolean {
    return proto3.util.equals(DeleteTaskRequest, a, b);
  }
}

/**
 * Response to delete a task.
 *
 * @generated from message flyteidl.admin.DeleteTaskResponse
 */
export class DeleteTaskResponse extends Message<DeleteTaskResponse> {
  constructor(data?: PartialMessage<DeleteTaskResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.DeleteTaskResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): DeleteTaskResponse {
    return new DeleteTaskResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): DeleteTaskResponse {
    return new DeleteTaskResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): DeleteTaskResponse {
    return new DeleteTaskResponse().fromJsonString(jsonString, options);
  }

  static equals(a: DeleteTaskResponse | PlainMessage<DeleteTaskResponse> | undefined, b: DeleteTaskResponse | PlainMessage<DeleteTaskResponse> | undefined): boolean {
    return proto3.util.equals(DeleteTaskResponse, a, b);
  }
}

/**
 * A message containing the agent metadata.
 *
 * @generated from message flyteidl.admin.Agent
 */
export class Agent extends Message<Agent> {
  /**
   * Name is the developer-assigned name of the agent.
   *
   * @generated from field: string name = 1;
   */
  name = "";

  /**
   * SupportedTaskTypes are the types of the tasks that the agent can handle.
   *
   * @generated from field: repeated string supported_task_types = 2 [deprecated = true];
   * @deprecated
   */
  supportedTaskTypes: string[] = [];

  /**
   * IsSync indicates whether this agent is a sync agent. Sync agents are expected to return their
   * results synchronously when called by propeller. Given that sync agents can affect the performance
   * of the system, it's important to enforce strict timeout policies.
   * An Async agent, on the other hand, is required to be able to identify jobs by an
   * identifier and query for job statuses as jobs progress.
   *
   * @generated from field: bool is_sync = 3;
   */
  isSync = false;

  /**
   * Supported_task_categories are the categories of the tasks that the agent can handle.
   *
   * @generated from field: repeated flyteidl.admin.TaskCategory supported_task_categories = 4;
   */
  supportedTaskCategories: TaskCategory[] = [];

  constructor(data?: PartialMessage<Agent>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.Agent";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "supported_task_types", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 3, name: "is_sync", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
    { no: 4, name: "supported_task_categories", kind: "message", T: TaskCategory, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Agent {
    return new Agent().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Agent {
    return new Agent().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Agent {
    return new Agent().fromJsonString(jsonString, options);
  }

  static equals(a: Agent | PlainMessage<Agent> | undefined, b: Agent | PlainMessage<Agent> | undefined): boolean {
    return proto3.util.equals(Agent, a, b);
  }
}

/**
 * @generated from message flyteidl.admin.TaskCategory
 */
export class TaskCategory extends Message<TaskCategory> {
  /**
   * The name of the task type.
   *
   * @generated from field: string name = 1;
   */
  name = "";

  /**
   * The version of the task type.
   *
   * @generated from field: int32 version = 2;
   */
  version = 0;

  constructor(data?: PartialMessage<TaskCategory>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.TaskCategory";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "version", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TaskCategory {
    return new TaskCategory().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TaskCategory {
    return new TaskCategory().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TaskCategory {
    return new TaskCategory().fromJsonString(jsonString, options);
  }

  static equals(a: TaskCategory | PlainMessage<TaskCategory> | undefined, b: TaskCategory | PlainMessage<TaskCategory> | undefined): boolean {
    return proto3.util.equals(TaskCategory, a, b);
  }
}

/**
 * A request to get an agent.
 *
 * @generated from message flyteidl.admin.GetAgentRequest
 */
export class GetAgentRequest extends Message<GetAgentRequest> {
  /**
   * The name of the agent.
   *
   * @generated from field: string name = 1;
   */
  name = "";

  constructor(data?: PartialMessage<GetAgentRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.GetAgentRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GetAgentRequest {
    return new GetAgentRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GetAgentRequest {
    return new GetAgentRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GetAgentRequest {
    return new GetAgentRequest().fromJsonString(jsonString, options);
  }

  static equals(a: GetAgentRequest | PlainMessage<GetAgentRequest> | undefined, b: GetAgentRequest | PlainMessage<GetAgentRequest> | undefined): boolean {
    return proto3.util.equals(GetAgentRequest, a, b);
  }
}

/**
 * A response containing an agent.
 *
 * @generated from message flyteidl.admin.GetAgentResponse
 */
export class GetAgentResponse extends Message<GetAgentResponse> {
  /**
   * @generated from field: flyteidl.admin.Agent agent = 1;
   */
  agent?: Agent;

  constructor(data?: PartialMessage<GetAgentResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.GetAgentResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "agent", kind: "message", T: Agent },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GetAgentResponse {
    return new GetAgentResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GetAgentResponse {
    return new GetAgentResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GetAgentResponse {
    return new GetAgentResponse().fromJsonString(jsonString, options);
  }

  static equals(a: GetAgentResponse | PlainMessage<GetAgentResponse> | undefined, b: GetAgentResponse | PlainMessage<GetAgentResponse> | undefined): boolean {
    return proto3.util.equals(GetAgentResponse, a, b);
  }
}

/**
 * A request to list all agents.
 *
 * @generated from message flyteidl.admin.ListAgentsRequest
 */
export class ListAgentsRequest extends Message<ListAgentsRequest> {
  constructor(data?: PartialMessage<ListAgentsRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ListAgentsRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ListAgentsRequest {
    return new ListAgentsRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ListAgentsRequest {
    return new ListAgentsRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ListAgentsRequest {
    return new ListAgentsRequest().fromJsonString(jsonString, options);
  }

  static equals(a: ListAgentsRequest | PlainMessage<ListAgentsRequest> | undefined, b: ListAgentsRequest | PlainMessage<ListAgentsRequest> | undefined): boolean {
    return proto3.util.equals(ListAgentsRequest, a, b);
  }
}

/**
 * A response containing a list of agents.
 *
 * @generated from message flyteidl.admin.ListAgentsResponse
 */
export class ListAgentsResponse extends Message<ListAgentsResponse> {
  /**
   * @generated from field: repeated flyteidl.admin.Agent agents = 1;
   */
  agents: Agent[] = [];

  constructor(data?: PartialMessage<ListAgentsResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ListAgentsResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "agents", kind: "message", T: Agent, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ListAgentsResponse {
    return new ListAgentsResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ListAgentsResponse {
    return new ListAgentsResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ListAgentsResponse {
    return new ListAgentsResponse().fromJsonString(jsonString, options);
  }

  static equals(a: ListAgentsResponse | PlainMessage<ListAgentsResponse> | undefined, b: ListAgentsResponse | PlainMessage<ListAgentsResponse> | undefined): boolean {
    return proto3.util.equals(ListAgentsResponse, a, b);
  }
}

/**
 * A request to get the metrics from a task execution.
 *
 * @generated from message flyteidl.admin.GetTaskMetricsRequest
 */
export class GetTaskMetricsRequest extends Message<GetTaskMetricsRequest> {
  /**
   * A predefined yet extensible Task type identifier.
   *
   * @generated from field: string task_type = 1 [deprecated = true];
   * @deprecated
   */
  taskType = "";

  /**
   * Metadata is created by the agent. It could be a string (jobId) or a dict (more complex metadata).
   *
   * @generated from field: bytes resource_meta = 2;
   */
  resourceMeta = new Uint8Array(0);

  /**
   * The metrics to query. If empty, will return a default set of metrics.
   * e.g. EXECUTION_METRIC_USED_CPU_AVG or EXECUTION_METRIC_USED_MEMORY_BYTES_AVG
   *
   * @generated from field: repeated string queries = 3;
   */
  queries: string[] = [];

  /**
   * Start timestamp, inclusive.
   *
   * @generated from field: google.protobuf.Timestamp start_time = 4;
   */
  startTime?: Timestamp;

  /**
   * End timestamp, inclusive..
   *
   * @generated from field: google.protobuf.Timestamp end_time = 5;
   */
  endTime?: Timestamp;

  /**
   * Query resolution step width in duration format or float number of seconds.
   *
   * @generated from field: google.protobuf.Duration step = 6;
   */
  step?: Duration;

  /**
   * A predefined yet extensible Task type identifier.
   *
   * @generated from field: flyteidl.admin.TaskCategory task_category = 7;
   */
  taskCategory?: TaskCategory;

  constructor(data?: PartialMessage<GetTaskMetricsRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.GetTaskMetricsRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "task_type", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "resource_meta", kind: "scalar", T: 12 /* ScalarType.BYTES */ },
    { no: 3, name: "queries", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 4, name: "start_time", kind: "message", T: Timestamp },
    { no: 5, name: "end_time", kind: "message", T: Timestamp },
    { no: 6, name: "step", kind: "message", T: Duration },
    { no: 7, name: "task_category", kind: "message", T: TaskCategory },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GetTaskMetricsRequest {
    return new GetTaskMetricsRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GetTaskMetricsRequest {
    return new GetTaskMetricsRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GetTaskMetricsRequest {
    return new GetTaskMetricsRequest().fromJsonString(jsonString, options);
  }

  static equals(a: GetTaskMetricsRequest | PlainMessage<GetTaskMetricsRequest> | undefined, b: GetTaskMetricsRequest | PlainMessage<GetTaskMetricsRequest> | undefined): boolean {
    return proto3.util.equals(GetTaskMetricsRequest, a, b);
  }
}

/**
 * A response containing a list of metrics for a task execution.
 *
 * @generated from message flyteidl.admin.GetTaskMetricsResponse
 */
export class GetTaskMetricsResponse extends Message<GetTaskMetricsResponse> {
  /**
   * The execution metric results.
   *
   * @generated from field: repeated flyteidl.core.ExecutionMetricResult results = 1;
   */
  results: ExecutionMetricResult[] = [];

  constructor(data?: PartialMessage<GetTaskMetricsResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.GetTaskMetricsResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "results", kind: "message", T: ExecutionMetricResult, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GetTaskMetricsResponse {
    return new GetTaskMetricsResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GetTaskMetricsResponse {
    return new GetTaskMetricsResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GetTaskMetricsResponse {
    return new GetTaskMetricsResponse().fromJsonString(jsonString, options);
  }

  static equals(a: GetTaskMetricsResponse | PlainMessage<GetTaskMetricsResponse> | undefined, b: GetTaskMetricsResponse | PlainMessage<GetTaskMetricsResponse> | undefined): boolean {
    return proto3.util.equals(GetTaskMetricsResponse, a, b);
  }
}

/**
 * A request to get the log from a task execution.
 *
 * @generated from message flyteidl.admin.GetTaskLogsRequest
 */
export class GetTaskLogsRequest extends Message<GetTaskLogsRequest> {
  /**
   * A predefined yet extensible Task type identifier.
   *
   * @generated from field: string task_type = 1 [deprecated = true];
   * @deprecated
   */
  taskType = "";

  /**
   * Metadata is created by the agent. It could be a string (jobId) or a dict (more complex metadata).
   *
   * @generated from field: bytes resource_meta = 2;
   */
  resourceMeta = new Uint8Array(0);

  /**
   * Number of lines to return.
   *
   * @generated from field: uint64 lines = 3;
   */
  lines = protoInt64.zero;

  /**
   * In the case of multiple pages of results, the server-provided token can be used to fetch the next page
   * in a query. If there are no more results, this value will be empty.
   *
   * @generated from field: string token = 4;
   */
  token = "";

  /**
   * A predefined yet extensible Task type identifier.
   *
   * @generated from field: flyteidl.admin.TaskCategory task_category = 5;
   */
  taskCategory?: TaskCategory;

  constructor(data?: PartialMessage<GetTaskLogsRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.GetTaskLogsRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "task_type", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "resource_meta", kind: "scalar", T: 12 /* ScalarType.BYTES */ },
    { no: 3, name: "lines", kind: "scalar", T: 4 /* ScalarType.UINT64 */ },
    { no: 4, name: "token", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 5, name: "task_category", kind: "message", T: TaskCategory },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GetTaskLogsRequest {
    return new GetTaskLogsRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GetTaskLogsRequest {
    return new GetTaskLogsRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GetTaskLogsRequest {
    return new GetTaskLogsRequest().fromJsonString(jsonString, options);
  }

  static equals(a: GetTaskLogsRequest | PlainMessage<GetTaskLogsRequest> | undefined, b: GetTaskLogsRequest | PlainMessage<GetTaskLogsRequest> | undefined): boolean {
    return proto3.util.equals(GetTaskLogsRequest, a, b);
  }
}

/**
 * @generated from message flyteidl.admin.GetTaskLogsResponseHeader
 */
export class GetTaskLogsResponseHeader extends Message<GetTaskLogsResponseHeader> {
  /**
   * In the case of multiple pages of results, the server-provided token can be used to fetch the next page
   * in a query. If there are no more results, this value will be empty.
   *
   * @generated from field: string token = 1;
   */
  token = "";

  constructor(data?: PartialMessage<GetTaskLogsResponseHeader>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.GetTaskLogsResponseHeader";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "token", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GetTaskLogsResponseHeader {
    return new GetTaskLogsResponseHeader().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GetTaskLogsResponseHeader {
    return new GetTaskLogsResponseHeader().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GetTaskLogsResponseHeader {
    return new GetTaskLogsResponseHeader().fromJsonString(jsonString, options);
  }

  static equals(a: GetTaskLogsResponseHeader | PlainMessage<GetTaskLogsResponseHeader> | undefined, b: GetTaskLogsResponseHeader | PlainMessage<GetTaskLogsResponseHeader> | undefined): boolean {
    return proto3.util.equals(GetTaskLogsResponseHeader, a, b);
  }
}

/**
 * @generated from message flyteidl.admin.GetTaskLogsResponseBody
 */
export class GetTaskLogsResponseBody extends Message<GetTaskLogsResponseBody> {
  /**
   * The execution log results.
   *
   * @generated from field: repeated string results = 1;
   */
  results: string[] = [];

  constructor(data?: PartialMessage<GetTaskLogsResponseBody>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.GetTaskLogsResponseBody";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "results", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GetTaskLogsResponseBody {
    return new GetTaskLogsResponseBody().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GetTaskLogsResponseBody {
    return new GetTaskLogsResponseBody().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GetTaskLogsResponseBody {
    return new GetTaskLogsResponseBody().fromJsonString(jsonString, options);
  }

  static equals(a: GetTaskLogsResponseBody | PlainMessage<GetTaskLogsResponseBody> | undefined, b: GetTaskLogsResponseBody | PlainMessage<GetTaskLogsResponseBody> | undefined): boolean {
    return proto3.util.equals(GetTaskLogsResponseBody, a, b);
  }
}

/**
 * A response containing the logs for a task execution.
 *
 * @generated from message flyteidl.admin.GetTaskLogsResponse
 */
export class GetTaskLogsResponse extends Message<GetTaskLogsResponse> {
  /**
   * @generated from oneof flyteidl.admin.GetTaskLogsResponse.part
   */
  part: {
    /**
     * @generated from field: flyteidl.admin.GetTaskLogsResponseHeader header = 1;
     */
    value: GetTaskLogsResponseHeader;
    case: "header";
  } | {
    /**
     * @generated from field: flyteidl.admin.GetTaskLogsResponseBody body = 2;
     */
    value: GetTaskLogsResponseBody;
    case: "body";
  } | { case: undefined; value?: undefined } = { case: undefined };

  constructor(data?: PartialMessage<GetTaskLogsResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.GetTaskLogsResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "header", kind: "message", T: GetTaskLogsResponseHeader, oneof: "part" },
    { no: 2, name: "body", kind: "message", T: GetTaskLogsResponseBody, oneof: "part" },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GetTaskLogsResponse {
    return new GetTaskLogsResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GetTaskLogsResponse {
    return new GetTaskLogsResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GetTaskLogsResponse {
    return new GetTaskLogsResponse().fromJsonString(jsonString, options);
  }

  static equals(a: GetTaskLogsResponse | PlainMessage<GetTaskLogsResponse> | undefined, b: GetTaskLogsResponse | PlainMessage<GetTaskLogsResponse> | undefined): boolean {
    return proto3.util.equals(GetTaskLogsResponse, a, b);
  }
}

/**
 * Error message to propagate detailed errors from agent executions to the execution
 * engine.
 *
 * @generated from message flyteidl.admin.AgentError
 */
export class AgentError extends Message<AgentError> {
  /**
   * A simplified code for errors, so that we can provide a glossary of all possible errors.
   *
   * @generated from field: string code = 1;
   */
  code = "";

  /**
   * An abstract error kind for this error. Defaults to Non_Recoverable if not specified.
   *
   * @generated from field: flyteidl.admin.AgentError.Kind kind = 3;
   */
  kind = AgentError_Kind.NON_RECOVERABLE;

  /**
   * Defines the origin of the error (system, user, unknown).
   *
   * @generated from field: flyteidl.core.ExecutionError.ErrorKind origin = 4;
   */
  origin = ExecutionError_ErrorKind.UNKNOWN;

  constructor(data?: PartialMessage<AgentError>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.AgentError";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "code", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "kind", kind: "enum", T: proto3.getEnumType(AgentError_Kind) },
    { no: 4, name: "origin", kind: "enum", T: proto3.getEnumType(ExecutionError_ErrorKind) },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): AgentError {
    return new AgentError().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): AgentError {
    return new AgentError().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): AgentError {
    return new AgentError().fromJsonString(jsonString, options);
  }

  static equals(a: AgentError | PlainMessage<AgentError> | undefined, b: AgentError | PlainMessage<AgentError> | undefined): boolean {
    return proto3.util.equals(AgentError, a, b);
  }
}

/**
 * Defines a generic error type that dictates the behavior of the retry strategy.
 *
 * @generated from enum flyteidl.admin.AgentError.Kind
 */
export enum AgentError_Kind {
  /**
   * @generated from enum value: NON_RECOVERABLE = 0;
   */
  NON_RECOVERABLE = 0,

  /**
   * @generated from enum value: RECOVERABLE = 1;
   */
  RECOVERABLE = 1,
}
// Retrieve enum metadata with: proto3.getEnumType(AgentError_Kind)
proto3.util.setEnumType(AgentError_Kind, "flyteidl.admin.AgentError.Kind", [
  { no: 0, name: "NON_RECOVERABLE" },
  { no: 1, name: "RECOVERABLE" },
]);

