(deployment)=

# Deployment guide

These *Deployment guides* are primarily for platform and devops engineers to learn how to deploy and administer Flyte.

The sections below walk through how to create a Flyte cluster and cover topics related to enabling and configuring
plugins, authentication, performance tuning, and maintaining Flyte as a production-grade service.

```{list-table}
:header-rows: 0
:widths: 20 30

* - {ref}`🛣 Deployment Paths <deployment-deployment>`
  - Walkthroughs for deploying Flyte, from the most basic to a fully-featured, multi-cluster production system.
* - {ref}`🔌 Plugin Setup <deployment-plugin-setup>`
  - Enable backend plugins to extend Flyte's capabilities, such as hooks for K8s, AWS, GCP, and Web API services.
* - {ref}`🤖 Agent Setup <deployment-agent-setup>`
  - Enable backend plugins to extend Flyte's capabilities, such as hooks for K8s, AWS, GCP, and Web API services.
* - {ref}`🎛 Cluster Configuration <deployment-configuration>`
  - How to configure the various components of your cluster.
* - {ref}`📖 Configuration Reference <deployment-configuration-generated>`
  - Reference docs for configuration settings for Flyte's backend services.
* - {ref}`🔒 Security Overview <deployment-security-overview>`
  - Read for comments on security in Flyte.
```

```{toctree}
:maxdepth: -1
:hidden:

deployment/index
plugins/index
agents/index
configuration/index
configuration/generated/index
security/index
swagger
```
