#
# spec file for package libcap-ng
#
# Copyright (c) 2018 SUSE LINUX GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#


%define sover  0
Name:           libcap-ng
Version:        0.7.9
Release:        4.37
Summary:        An alternate Linux/POSIX capabilities library
License:        LGPL-2.1-or-later
Group:          Development/Libraries/C and C++
Url:            https://people.redhat.com/sgrubb/libcap-ng
Source0:        https://people.redhat.com/sgrubb/%{name}/%{name}-%{version}.tar.gz
Source1:        baselibs.conf
Source99:       libcap-ng.rpmlintrc
BuildRequires:  kernel-headers >= 2.6.11
BuildRequires:  pkgconfig

%description
libcap-ng is a library providing an alternate mechanism to libcap to
make use of Linux process and file capabilities.

%package -n %{name}%{sover}
Summary:        An alternate Linux/POSIX capabilities library
License:        LGPL-2.1-or-later
Group:          System/Libraries

%description -n %{name}%{sover}
libcap-ng is a library providing an alternate mechanism to libcap to
inspect and set Linux process and file capabilities (modeled upon a
withdrawn POSIX.1e draft).

%package devel
Summary:        Header files for the libcap-ng library
License:        LGPL-2.1-or-later
Group:          Development/Libraries/C and C++
Requires:       %{name}%{sover} = %{version}
Requires:       kernel-headers >= 2.6.11
Requires:       pkgconfig

%description devel
The libcap-ng-devel package contains the files needed for developing
applications that need to use the libcap-ng library.

%package utils
Summary:        Utilities for analysing and setting file capabilities
License:        GPL-2.0-or-later
Group:          System/Base

%description utils
The libcap-ng-utils package contains applications to analyse the
Linux process capabilities of programs running on a system. It also
lets you set the filesystem-based capabilities.

%prep
%setup -q

%build
%configure \
	--disable-static \
	--without-python
make %{?_smp_mflags}

%install
%make_install
find %{buildroot} -type f -name "*.la" -delete -print

%post -n %{name}%{sover} -p /sbin/ldconfig
%postun -n %{name}%{sover} -p /sbin/ldconfig

%files -n %{name}%{sover}
%license COPYING.LIB
%{_libdir}/%{name}.so.%{sover}
%{_libdir}/%{name}.so.%{sover}.*

%files devel
%{_mandir}/man3/*.3%{ext_man}
%{_includedir}/cap-ng.h
%{_libdir}/%{name}.so
%{_datadir}/aclocal/cap-ng.m4
%{_libdir}/pkgconfig/%{name}.pc

%files utils
%license COPYING
%{_bindir}/captest
%{_bindir}/filecap
%{_bindir}/netcap
%{_bindir}/pscap
%{_mandir}/man8/*.8%{ext_man}

%changelog
* Wed May 16 2018 mcepl@suse.com
- Just fixing the License field
* Tue Feb 20 2018 tchvatal@suse.com
- Move %%doc to %%license for licenses
* Sun Feb 18 2018 jengelh@inai.de
- Remove ineffective --with-pic. Fix SRPM group. Redo descriptions.
- Rename %%soname to %%sover to better reflect its use.
* Sun Feb 18 2018 avindra@opensuse.org
- Update to version 0.7.9:
  * Detect and output a couple errors in filecap
  * Use pthread_atfork to optionally reset the pid and related info
    on fork
- cleanup with spec-cleaner
- use https urls
* Wed May 17 2017 alexander_naumov@opensuse.org
- Update to version 0.7.8:
  * Improve Python3 support
  * Fix the thread separation test
  * Correct typo in cap_pacct text
  * Update man page for captest
  * Fix sscanf string lengths in netcap
  * Correct linking of python3 module
* Wed Dec  2 2015 p.drouand@gmail.com
- Update to version 0.7.7
  * Make sure all types used in _lnode are defined in proc-llist.h
  * Fix python binding test for old kernels
  * Fix leaked FD in library init
- Changes from version 0.7.6
  * Fix python3 support
- Changes from version 0.7.5
  * Make python3 supported
  * In python bindings test, clamp CAP_LAST_CAP with /proc/.../cap_last_cap
  * Update table for 3.16 kernel
* Thu Jun 19 2014 crrodriguez@opensuse.org
- Remove unused BuildRequires on libattr-devel
* Thu May 15 2014 tchvatal@suse.com
- Version bupm to 0.7.4
- Cleanup with spec-cleaner
- Remove useless specification of attributes
- Really split the two spec files instead of copying them to avoid
  the huge ifdefing.
  + more readable
  - version must be edited in two places when bumping
* Thu Mar 14 2013 meissner@suse.com
- use source url
* Wed Mar 13 2013 crrodriguez@opensuse.org
- version 0.7.3
- Make file opens use the cloexec flag (Cristian Rodríguez)
- Add CAP_BLOCK_SUSPEND
- Fix possible segfaults when CAP_LAST_CAP is larger than the lookup table
- In pscap, don't drop capabilities when running with capabilities
- Add CAP_COMPROMISE_KERNEL
- Define FTW_CONTINUE in case its not defined in libc
- Use glibc for xattr.h if available
- Make sure stderr is used consistently in utils
- Fix logic causing file based capabilities to not be supported when it should
* Sun Feb 12 2012 crrodriguez@opensuse.org
- Move libraries back to %%{_libdir}, /usr merge project
* Wed Oct  5 2011 uli@suse.com
- cross-build workaround: make sure no attempt is made to build
  python stuff even if it's installed on the host system
* Wed Aug 31 2011 crrodriguez@opensuse.org
-  Update to version 0.6.6
- Add CAP_SYSLOG and CAP_WAKE_ALARM (needed for newish kernels)
* Mon Nov  8 2010 coolo@novell.com
- fix requires
* Wed Nov  3 2010 pascal.bleser@opensuse.org
- update to 0.6.5:
  * works around a problem in the Linux 2.6.36 kernel headers
  * fixes a segfault when using filecap on a specific file
* Thu Oct 14 2010 coolo@novell.com
- split out python packages now that libcap-ng is used in many
  low level tools it creates cycles
* Thu May  6 2010 pascal.bleser@opensuse.org
- update to 0.6.4:
  * the library now uses kernel thread ID for capget/set calls
  * a display problem of filesystem based capabilities was fixed
  * netcap now prints device name for packet socket apps
- add baselibs.conf to build libcap-ng0-32bit
* Fri Mar 12 2010 pascal.bleser@opensuse.org
- update to 0.6.3:
  * in netcap and pscap use the effective uid
  * in capng_change_id, only retain setpcap if clearing the bounding set
- add rpmlintrc to disable false positive warnings
- symlink license files on openSUSE
* Wed Mar 10 2010 prusnak@suse.cz
- fixed Requires of python subpackage
* Fri Feb 26 2010 prusnak@suse.cz
- imported package from Fedora (version 0.6.2)
