// Code generated by go generate; DO NOT EDIT.
// This file was generated by robots.

package database

import (
	"encoding/json"
	"reflect"

	"fmt"

	"github.com/spf13/pflag"
)

// If v is a pointer, it will get its element value or the zero value of the element type.
// If v is not a pointer, it will return it as is.
func (DbConfig) elemValueOrNil(v interface{}) interface{} {
	if t := reflect.TypeOf(v); t.Kind() == reflect.Ptr {
		if reflect.ValueOf(v).IsNil() {
			return reflect.Zero(t.Elem()).Interface()
		} else {
			return reflect.ValueOf(v).Interface()
		}
	} else if v == nil {
		return reflect.Zero(t).Interface()
	}

	return v
}

func (DbConfig) mustJsonMarshal(v interface{}) string {
	raw, err := json.Marshal(v)
	if err != nil {
		panic(err)
	}

	return string(raw)
}

func (DbConfig) mustMarshalJSON(v json.Marshaler) string {
	raw, err := v.MarshalJSON()
	if err != nil {
		panic(err)
	}

	return string(raw)
}

// GetPFlagSet will return strongly types pflags for all fields in DbConfig and its nested types. The format of the
// flags is json-name.json-sub-name... etc.
func (cfg DbConfig) GetPFlagSet(prefix string) *pflag.FlagSet {
	cmdFlags := pflag.NewFlagSet("DbConfig", pflag.ExitOnError)
	cmdFlags.Bool(fmt.Sprintf("%v%v", prefix, "enableForeignKeyConstraintWhenMigrating"), defaultConfig.EnableForeignKeyConstraintWhenMigrating, "Whether to enable gorm foreign keys when migrating the db")
	cmdFlags.Int(fmt.Sprintf("%v%v", prefix, "maxIdleConnections"), defaultConfig.MaxIdleConnections, "maxIdleConnections sets the maximum number of connections in the idle connection pool.")
	cmdFlags.Int(fmt.Sprintf("%v%v", prefix, "maxOpenConnections"), defaultConfig.MaxOpenConnections, "maxOpenConnections sets the maximum number of open connections to the database.")
	cmdFlags.String(fmt.Sprintf("%v%v", prefix, "connMaxLifeTime"), defaultConfig.ConnMaxLifeTime.String(), "sets the maximum amount of time a connection may be reused")
	cmdFlags.String(fmt.Sprintf("%v%v", prefix, "postgres.host"), defaultConfig.Postgres.Host, "The host name of the database server")
	cmdFlags.String(fmt.Sprintf("%v%v", prefix, "postgres.readReplicaHost"), defaultConfig.Postgres.ReadReplicaHost, "The host name of the read replica database server")
	cmdFlags.Int(fmt.Sprintf("%v%v", prefix, "postgres.port"), defaultConfig.Postgres.Port, "The port name of the database server")
	cmdFlags.String(fmt.Sprintf("%v%v", prefix, "postgres.dbname"), defaultConfig.Postgres.DbName, "The database name")
	cmdFlags.String(fmt.Sprintf("%v%v", prefix, "postgres.username"), defaultConfig.Postgres.User, "The database user who is connecting to the server.")
	cmdFlags.String(fmt.Sprintf("%v%v", prefix, "postgres.password"), defaultConfig.Postgres.Password, "The database password.")
	cmdFlags.String(fmt.Sprintf("%v%v", prefix, "postgres.passwordPath"), defaultConfig.Postgres.PasswordPath, "Points to the file containing the database password.")
	cmdFlags.String(fmt.Sprintf("%v%v", prefix, "postgres.options"), defaultConfig.Postgres.ExtraOptions, "See http://gorm.io/docs/connecting_to_the_database.html for available options passed,  in addition to the above.")
	cmdFlags.Bool(fmt.Sprintf("%v%v", prefix, "postgres.debug"), defaultConfig.Postgres.Debug, "")
	cmdFlags.String(fmt.Sprintf("%v%v", prefix, "sqlite.file"), defaultConfig.SQLite.File, "The path to the file (existing or new) where the DB should be created / stored. If existing,  then this will be re-used,  else a new will be created")
	return cmdFlags
}
