// Code generated by go generate; DO NOT EDIT.
// This file was generated by robots.

package config

import (
	"encoding/json"
	"fmt"
	"reflect"
	"strings"
	"testing"

	"github.com/mitchellh/mapstructure"
	"github.com/stretchr/testify/assert"
)

var dereferencableKindsConfig = map[reflect.Kind]struct{}{
	reflect.Array: {}, reflect.Chan: {}, reflect.Map: {}, reflect.Ptr: {}, reflect.Slice: {},
}

// Checks if t is a kind that can be dereferenced to get its underlying type.
func canGetElementConfig(t reflect.Kind) bool {
	_, exists := dereferencableKindsConfig[t]
	return exists
}

// This decoder hook tests types for json unmarshaling capability. If implemented, it uses json unmarshal to build the
// object. Otherwise, it'll just pass on the original data.
func jsonUnmarshalerHookConfig(_, to reflect.Type, data interface{}) (interface{}, error) {
	unmarshalerType := reflect.TypeOf((*json.Unmarshaler)(nil)).Elem()
	if to.Implements(unmarshalerType) || reflect.PtrTo(to).Implements(unmarshalerType) ||
		(canGetElementConfig(to.Kind()) && to.Elem().Implements(unmarshalerType)) {

		raw, err := json.Marshal(data)
		if err != nil {
			fmt.Printf("Failed to marshal Data: %v. Error: %v. Skipping jsonUnmarshalHook", data, err)
			return data, nil
		}

		res := reflect.New(to).Interface()
		err = json.Unmarshal(raw, &res)
		if err != nil {
			fmt.Printf("Failed to umarshal Data: %v. Error: %v. Skipping jsonUnmarshalHook", data, err)
			return data, nil
		}

		return res, nil
	}

	return data, nil
}

func decode_Config(input, result interface{}) error {
	config := &mapstructure.DecoderConfig{
		TagName:          "json",
		WeaklyTypedInput: true,
		Result:           result,
		DecodeHook: mapstructure.ComposeDecodeHookFunc(
			mapstructure.StringToTimeDurationHookFunc(),
			mapstructure.StringToSliceHookFunc(","),
			jsonUnmarshalerHookConfig,
		),
	}

	decoder, err := mapstructure.NewDecoder(config)
	if err != nil {
		return err
	}

	return decoder.Decode(input)
}

func join_Config(arr interface{}, sep string) string {
	listValue := reflect.ValueOf(arr)
	strs := make([]string, 0, listValue.Len())
	for i := 0; i < listValue.Len(); i++ {
		strs = append(strs, fmt.Sprintf("%v", listValue.Index(i)))
	}

	return strings.Join(strs, sep)
}

func testDecodeJson_Config(t *testing.T, val, result interface{}) {
	assert.NoError(t, decode_Config(val, result))
}

func testDecodeRaw_Config(t *testing.T, vStringSlice, result interface{}) {
	assert.NoError(t, decode_Config(vStringSlice, result))
}

func TestConfig_GetPFlagSet(t *testing.T) {
	val := Config{}
	cmdFlags := val.GetPFlagSet("")
	assert.True(t, cmdFlags.HasFlags())
}

func TestConfig_SetFlags(t *testing.T) {
	actual := Config{}
	cmdFlags := actual.GetPFlagSet("")
	assert.True(t, cmdFlags.HasFlags())

	t.Run("Test_type", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("type", testValue)
			if vString, err := cmdFlags.GetString("type"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.Type)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_resourceMaxQuota", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("resourceMaxQuota", testValue)
			if vInt, err := cmdFlags.GetInt("resourceMaxQuota"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vInt), &actual.ResourceMaxQuota)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_redis.hostPaths", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := join_Config(defaultConfig.RedisConfig.HostPaths, ",")

			cmdFlags.Set("redis.hostPaths", testValue)
			if vStringSlice, err := cmdFlags.GetStringSlice("redis.hostPaths"); err == nil {
				testDecodeRaw_Config(t, join_Config(vStringSlice, ","), &actual.RedisConfig.HostPaths)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_redis.primaryName", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("redis.primaryName", testValue)
			if vString, err := cmdFlags.GetString("redis.primaryName"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.RedisConfig.PrimaryName)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_redis.hostPath", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("redis.hostPath", testValue)
			if vString, err := cmdFlags.GetString("redis.hostPath"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.RedisConfig.HostPath)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_redis.hostKey", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("redis.hostKey", testValue)
			if vString, err := cmdFlags.GetString("redis.hostKey"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.RedisConfig.HostKey)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_redis.maxRetries", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("redis.maxRetries", testValue)
			if vInt, err := cmdFlags.GetInt("redis.maxRetries"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vInt), &actual.RedisConfig.MaxRetries)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
}
