// Code generated by go generate; DO NOT EDIT.
// This file was generated by robots.

package launchplan

import (
	"encoding/json"
	"fmt"
	"reflect"
	"strings"
	"testing"

	"github.com/mitchellh/mapstructure"
	"github.com/stretchr/testify/assert"
)

var dereferencableKindsAdminConfig = map[reflect.Kind]struct{}{
	reflect.Array: {}, reflect.Chan: {}, reflect.Map: {}, reflect.Ptr: {}, reflect.Slice: {},
}

// Checks if t is a kind that can be dereferenced to get its underlying type.
func canGetElementAdminConfig(t reflect.Kind) bool {
	_, exists := dereferencableKindsAdminConfig[t]
	return exists
}

// This decoder hook tests types for json unmarshaling capability. If implemented, it uses json unmarshal to build the
// object. Otherwise, it'll just pass on the original data.
func jsonUnmarshalerHookAdminConfig(_, to reflect.Type, data interface{}) (interface{}, error) {
	unmarshalerType := reflect.TypeOf((*json.Unmarshaler)(nil)).Elem()
	if to.Implements(unmarshalerType) || reflect.PtrTo(to).Implements(unmarshalerType) ||
		(canGetElementAdminConfig(to.Kind()) && to.Elem().Implements(unmarshalerType)) {

		raw, err := json.Marshal(data)
		if err != nil {
			fmt.Printf("Failed to marshal Data: %v. Error: %v. Skipping jsonUnmarshalHook", data, err)
			return data, nil
		}

		res := reflect.New(to).Interface()
		err = json.Unmarshal(raw, &res)
		if err != nil {
			fmt.Printf("Failed to umarshal Data: %v. Error: %v. Skipping jsonUnmarshalHook", data, err)
			return data, nil
		}

		return res, nil
	}

	return data, nil
}

func decode_AdminConfig(input, result interface{}) error {
	config := &mapstructure.DecoderConfig{
		TagName:          "json",
		WeaklyTypedInput: true,
		Result:           result,
		DecodeHook: mapstructure.ComposeDecodeHookFunc(
			mapstructure.StringToTimeDurationHookFunc(),
			mapstructure.StringToSliceHookFunc(","),
			jsonUnmarshalerHookAdminConfig,
		),
	}

	decoder, err := mapstructure.NewDecoder(config)
	if err != nil {
		return err
	}

	return decoder.Decode(input)
}

func join_AdminConfig(arr interface{}, sep string) string {
	listValue := reflect.ValueOf(arr)
	strs := make([]string, 0, listValue.Len())
	for i := 0; i < listValue.Len(); i++ {
		strs = append(strs, fmt.Sprintf("%v", listValue.Index(i)))
	}

	return strings.Join(strs, sep)
}

func testDecodeJson_AdminConfig(t *testing.T, val, result interface{}) {
	assert.NoError(t, decode_AdminConfig(val, result))
}

func testDecodeRaw_AdminConfig(t *testing.T, vStringSlice, result interface{}) {
	assert.NoError(t, decode_AdminConfig(vStringSlice, result))
}

func TestAdminConfig_GetPFlagSet(t *testing.T) {
	val := AdminConfig{}
	cmdFlags := val.GetPFlagSet("")
	assert.True(t, cmdFlags.HasFlags())
}

func TestAdminConfig_SetFlags(t *testing.T) {
	actual := AdminConfig{}
	cmdFlags := actual.GetPFlagSet("")
	assert.True(t, cmdFlags.HasFlags())

	t.Run("Test_tps", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("tps", testValue)
			if vInt64, err := cmdFlags.GetInt64("tps"); err == nil {
				testDecodeJson_AdminConfig(t, fmt.Sprintf("%v", vInt64), &actual.TPS)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_burst", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("burst", testValue)
			if vInt, err := cmdFlags.GetInt("burst"); err == nil {
				testDecodeJson_AdminConfig(t, fmt.Sprintf("%v", vInt), &actual.Burst)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_cacheSize", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("cacheSize", testValue)
			if vInt, err := cmdFlags.GetInt("cacheSize"); err == nil {
				testDecodeJson_AdminConfig(t, fmt.Sprintf("%v", vInt), &actual.MaxCacheSize)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_workers", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("workers", testValue)
			if vInt, err := cmdFlags.GetInt("workers"); err == nil {
				testDecodeJson_AdminConfig(t, fmt.Sprintf("%v", vInt), &actual.Workers)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_cache-resync-duration", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := defaultAdminConfig.CacheResyncDuration.String()

			cmdFlags.Set("cache-resync-duration", testValue)
			if vString, err := cmdFlags.GetString("cache-resync-duration"); err == nil {
				testDecodeJson_AdminConfig(t, fmt.Sprintf("%v", vString), &actual.CacheResyncDuration)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
}
