// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/flyteorg/flyte/flytepropeller/pkg/apis/flyteworkflow/v1alpha1"
	scheme "github.com/flyteorg/flyte/flytepropeller/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// FlyteWorkflowsGetter has a method to return a FlyteWorkflowInterface.
// A group's client should implement this interface.
type FlyteWorkflowsGetter interface {
	FlyteWorkflows(namespace string) FlyteWorkflowInterface
}

// FlyteWorkflowInterface has methods to work with FlyteWorkflow resources.
type FlyteWorkflowInterface interface {
	Create(ctx context.Context, flyteWorkflow *v1alpha1.FlyteWorkflow, opts v1.CreateOptions) (*v1alpha1.FlyteWorkflow, error)
	Update(ctx context.Context, flyteWorkflow *v1alpha1.FlyteWorkflow, opts v1.UpdateOptions) (*v1alpha1.FlyteWorkflow, error)
	UpdateStatus(ctx context.Context, flyteWorkflow *v1alpha1.FlyteWorkflow, opts v1.UpdateOptions) (*v1alpha1.FlyteWorkflow, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.FlyteWorkflow, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.FlyteWorkflowList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.FlyteWorkflow, err error)
	FlyteWorkflowExpansion
}

// flyteWorkflows implements FlyteWorkflowInterface
type flyteWorkflows struct {
	client rest.Interface
	ns     string
}

// newFlyteWorkflows returns a FlyteWorkflows
func newFlyteWorkflows(c *FlyteworkflowV1alpha1Client, namespace string) *flyteWorkflows {
	return &flyteWorkflows{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the flyteWorkflow, and returns the corresponding flyteWorkflow object, and an error if there is any.
func (c *flyteWorkflows) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.FlyteWorkflow, err error) {
	result = &v1alpha1.FlyteWorkflow{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("flyteworkflows").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of FlyteWorkflows that match those selectors.
func (c *flyteWorkflows) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.FlyteWorkflowList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.FlyteWorkflowList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("flyteworkflows").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested flyteWorkflows.
func (c *flyteWorkflows) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("flyteworkflows").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a flyteWorkflow and creates it.  Returns the server's representation of the flyteWorkflow, and an error, if there is any.
func (c *flyteWorkflows) Create(ctx context.Context, flyteWorkflow *v1alpha1.FlyteWorkflow, opts v1.CreateOptions) (result *v1alpha1.FlyteWorkflow, err error) {
	result = &v1alpha1.FlyteWorkflow{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("flyteworkflows").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(flyteWorkflow).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a flyteWorkflow and updates it. Returns the server's representation of the flyteWorkflow, and an error, if there is any.
func (c *flyteWorkflows) Update(ctx context.Context, flyteWorkflow *v1alpha1.FlyteWorkflow, opts v1.UpdateOptions) (result *v1alpha1.FlyteWorkflow, err error) {
	result = &v1alpha1.FlyteWorkflow{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("flyteworkflows").
		Name(flyteWorkflow.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(flyteWorkflow).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *flyteWorkflows) UpdateStatus(ctx context.Context, flyteWorkflow *v1alpha1.FlyteWorkflow, opts v1.UpdateOptions) (result *v1alpha1.FlyteWorkflow, err error) {
	result = &v1alpha1.FlyteWorkflow{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("flyteworkflows").
		Name(flyteWorkflow.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(flyteWorkflow).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the flyteWorkflow and deletes it. Returns an error if one occurs.
func (c *flyteWorkflows) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("flyteworkflows").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *flyteWorkflows) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("flyteworkflows").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched flyteWorkflow.
func (c *flyteWorkflows) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.FlyteWorkflow, err error) {
	result = &v1alpha1.FlyteWorkflow{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("flyteworkflows").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
