package v1alpha1

import (
	"github.com/flyteorg/flyte/flyteidl/gen/pb-go/flyteidl/core"
	"github.com/flyteorg/flyte/flytestdlib/utils"
)

type BooleanExpression struct {
	*core.BooleanExpression
}

func (in BooleanExpression) MarshalJSON() ([]byte, error) {
	return utils.MarshalPbToBytes(in.BooleanExpression)
}

func (in *BooleanExpression) UnmarshalJSON(b []byte) error {
	in.BooleanExpression = &core.BooleanExpression{}
	return utils.UnmarshalBytesToPb(b, in.BooleanExpression)
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BooleanExpression) DeepCopyInto(out *BooleanExpression) {
	*out = *in
	// We do not manipulate the object, so its ok
	// Once we figure out the autogenerate story we can replace this
}

type IfBlock struct {
	Condition BooleanExpression `json:"condition"`
	ThenNode  *NodeID           `json:"then"`
}

func (in IfBlock) GetCondition() *core.BooleanExpression {
	return in.Condition.BooleanExpression
}

func (in *IfBlock) GetThenNode() *NodeID {
	return in.ThenNode
}

type BranchNodeSpec struct {
	If       IfBlock     `json:"if"`
	ElseIf   []*IfBlock  `json:"elseIf,omitempty"`
	Else     *NodeID     `json:"else,omitempty"`
	ElseFail *core.Error `json:"elseFail,omitempty"`
}

func (in *BranchNodeSpec) GetIf() ExecutableIfBlock {
	return &in.If
}

func (in *BranchNodeSpec) GetElse() *NodeID {
	return in.Else
}

func (in *BranchNodeSpec) GetElseIf() []ExecutableIfBlock {
	elifs := make([]ExecutableIfBlock, 0, len(in.ElseIf))
	for _, b := range in.ElseIf {
		elifs = append(elifs, b)
	}
	return elifs
}

func (in *BranchNodeSpec) GetElseFail() *core.Error {
	return in.ElseFail
}
