// Code generated by go generate; DO NOT EDIT.
// This file was generated by robots.

package config

import (
	"encoding/json"
	"reflect"

	"fmt"

	"github.com/spf13/pflag"
)

// If v is a pointer, it will get its element value or the zero value of the element type.
// If v is not a pointer, it will return it as is.
func (Config) elemValueOrNil(v interface{}) interface{} {
	if t := reflect.TypeOf(v); t.Kind() == reflect.Ptr {
		if reflect.ValueOf(v).IsNil() {
			return reflect.Zero(t.Elem()).Interface()
		} else {
			return reflect.ValueOf(v).Interface()
		}
	} else if v == nil {
		return reflect.Zero(t).Interface()
	}

	return v
}

func (Config) mustJsonMarshal(v interface{}) string {
	raw, err := json.Marshal(v)
	if err != nil {
		panic(err)
	}

	return string(raw)
}

func (Config) mustMarshalJSON(v json.Marshaler) string {
	raw, err := v.MarshalJSON()
	if err != nil {
		panic(err)
	}

	return string(raw)
}

// GetPFlagSet will return strongly types pflags for all fields in Config and its nested types. The format of the
// flags is json-name.json-sub-name... etc.
func (cfg Config) GetPFlagSet(prefix string) *pflag.FlagSet {
	cmdFlags := pflag.NewFlagSet("Config", pflag.ExitOnError)
	cmdFlags.String(fmt.Sprintf("%v%v", prefix, "environment"), defaultConfig.Environment.String(), "Environment endpoint for Presto to use")
	cmdFlags.String(fmt.Sprintf("%v%v", prefix, "defaultRoutingGroup"), defaultConfig.DefaultRoutingGroup, "Default Presto routing group")
	cmdFlags.String(fmt.Sprintf("%v%v", prefix, "defaultUser"), defaultConfig.DefaultUser, "Default Presto user")
	cmdFlags.Bool(fmt.Sprintf("%v%v", prefix, "useNamespaceAsUser"), defaultConfig.UseNamespaceAsUser, "Use the K8s namespace as the user")
	cmdFlags.String(fmt.Sprintf("%v%v", prefix, "refreshCacheConfig.name"), defaultConfig.RefreshCacheConfig.Name, "The name of the rate limiter")
	cmdFlags.String(fmt.Sprintf("%v%v", prefix, "refreshCacheConfig.syncPeriod"), defaultConfig.RefreshCacheConfig.SyncPeriod.String(), "The duration to wait before the cache is refreshed again")
	cmdFlags.Int(fmt.Sprintf("%v%v", prefix, "refreshCacheConfig.workers"), defaultConfig.RefreshCacheConfig.Workers, "Number of parallel workers to refresh the cache")
	cmdFlags.Int(fmt.Sprintf("%v%v", prefix, "refreshCacheConfig.lruCacheSize"), defaultConfig.RefreshCacheConfig.LruCacheSize, "Size of the cache")
	cmdFlags.Int64(fmt.Sprintf("%v%v", prefix, "readRateLimiterConfig.rate"), defaultConfig.ReadRateLimiterConfig.Rate, "Allowed rate of calls per second.")
	cmdFlags.Int(fmt.Sprintf("%v%v", prefix, "readRateLimiterConfig.burst"), defaultConfig.ReadRateLimiterConfig.Burst, "Allowed burst rate of calls per second.")
	cmdFlags.Int64(fmt.Sprintf("%v%v", prefix, "writeRateLimiterConfig.rate"), defaultConfig.WriteRateLimiterConfig.Rate, "Allowed rate of calls per second.")
	cmdFlags.Int(fmt.Sprintf("%v%v", prefix, "writeRateLimiterConfig.burst"), defaultConfig.WriteRateLimiterConfig.Burst, "Allowed burst rate of calls per second.")
	return cmdFlags
}
