// Code generated by go generate; DO NOT EDIT.
// This file was generated by robots.

package spark

import (
	"encoding/json"
	"fmt"
	"reflect"
	"strings"
	"testing"

	"github.com/mitchellh/mapstructure"
	"github.com/stretchr/testify/assert"
)

var dereferencableKindsConfig = map[reflect.Kind]struct{}{
	reflect.Array: {}, reflect.Chan: {}, reflect.Map: {}, reflect.Ptr: {}, reflect.Slice: {},
}

// Checks if t is a kind that can be dereferenced to get its underlying type.
func canGetElementConfig(t reflect.Kind) bool {
	_, exists := dereferencableKindsConfig[t]
	return exists
}

// This decoder hook tests types for json unmarshaling capability. If implemented, it uses json unmarshal to build the
// object. Otherwise, it'll just pass on the original data.
func jsonUnmarshalerHookConfig(_, to reflect.Type, data interface{}) (interface{}, error) {
	unmarshalerType := reflect.TypeOf((*json.Unmarshaler)(nil)).Elem()
	if to.Implements(unmarshalerType) || reflect.PtrTo(to).Implements(unmarshalerType) ||
		(canGetElementConfig(to.Kind()) && to.Elem().Implements(unmarshalerType)) {

		raw, err := json.Marshal(data)
		if err != nil {
			fmt.Printf("Failed to marshal Data: %v. Error: %v. Skipping jsonUnmarshalHook", data, err)
			return data, nil
		}

		res := reflect.New(to).Interface()
		err = json.Unmarshal(raw, &res)
		if err != nil {
			fmt.Printf("Failed to umarshal Data: %v. Error: %v. Skipping jsonUnmarshalHook", data, err)
			return data, nil
		}

		return res, nil
	}

	return data, nil
}

func decode_Config(input, result interface{}) error {
	config := &mapstructure.DecoderConfig{
		TagName:          "json",
		WeaklyTypedInput: true,
		Result:           result,
		DecodeHook: mapstructure.ComposeDecodeHookFunc(
			mapstructure.StringToTimeDurationHookFunc(),
			mapstructure.StringToSliceHookFunc(","),
			jsonUnmarshalerHookConfig,
		),
	}

	decoder, err := mapstructure.NewDecoder(config)
	if err != nil {
		return err
	}

	return decoder.Decode(input)
}

func join_Config(arr interface{}, sep string) string {
	listValue := reflect.ValueOf(arr)
	strs := make([]string, 0, listValue.Len())
	for i := 0; i < listValue.Len(); i++ {
		strs = append(strs, fmt.Sprintf("%v", listValue.Index(i)))
	}

	return strings.Join(strs, sep)
}

func testDecodeJson_Config(t *testing.T, val, result interface{}) {
	assert.NoError(t, decode_Config(val, result))
}

func testDecodeRaw_Config(t *testing.T, vStringSlice, result interface{}) {
	assert.NoError(t, decode_Config(vStringSlice, result))
}

func TestConfig_GetPFlagSet(t *testing.T) {
	val := Config{}
	cmdFlags := val.GetPFlagSet("")
	assert.True(t, cmdFlags.HasFlags())
}

func TestConfig_SetFlags(t *testing.T) {
	actual := Config{}
	cmdFlags := actual.GetPFlagSet("")
	assert.True(t, cmdFlags.HasFlags())

	t.Run("Test_spark-history-server-url", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("spark-history-server-url", testValue)
			if vString, err := cmdFlags.GetString("spark-history-server-url"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.SparkHistoryServerURL)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.mixed.cloudwatch-enabled", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.mixed.cloudwatch-enabled", testValue)
			if vBool, err := cmdFlags.GetBool("logs.mixed.cloudwatch-enabled"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vBool), &actual.LogConfig.Mixed.IsCloudwatchEnabled)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.mixed.cloudwatch-region", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.mixed.cloudwatch-region", testValue)
			if vString, err := cmdFlags.GetString("logs.mixed.cloudwatch-region"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.Mixed.CloudwatchRegion)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.mixed.cloudwatch-log-group", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.mixed.cloudwatch-log-group", testValue)
			if vString, err := cmdFlags.GetString("logs.mixed.cloudwatch-log-group"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.Mixed.CloudwatchLogGroup)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.mixed.cloudwatch-template-uri", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.mixed.cloudwatch-template-uri", testValue)
			if vString, err := cmdFlags.GetString("logs.mixed.cloudwatch-template-uri"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.Mixed.CloudwatchTemplateURI)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.mixed.kubernetes-enabled", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.mixed.kubernetes-enabled", testValue)
			if vBool, err := cmdFlags.GetBool("logs.mixed.kubernetes-enabled"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vBool), &actual.LogConfig.Mixed.IsKubernetesEnabled)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.mixed.kubernetes-url", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.mixed.kubernetes-url", testValue)
			if vString, err := cmdFlags.GetString("logs.mixed.kubernetes-url"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.Mixed.KubernetesURL)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.mixed.kubernetes-template-uri", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.mixed.kubernetes-template-uri", testValue)
			if vString, err := cmdFlags.GetString("logs.mixed.kubernetes-template-uri"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.Mixed.KubernetesTemplateURI)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.mixed.stackdriver-enabled", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.mixed.stackdriver-enabled", testValue)
			if vBool, err := cmdFlags.GetBool("logs.mixed.stackdriver-enabled"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vBool), &actual.LogConfig.Mixed.IsStackDriverEnabled)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.mixed.gcp-project", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.mixed.gcp-project", testValue)
			if vString, err := cmdFlags.GetString("logs.mixed.gcp-project"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.Mixed.GCPProjectName)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.mixed.stackdriver-logresourcename", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.mixed.stackdriver-logresourcename", testValue)
			if vString, err := cmdFlags.GetString("logs.mixed.stackdriver-logresourcename"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.Mixed.StackdriverLogResourceName)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.mixed.stackdriver-template-uri", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.mixed.stackdriver-template-uri", testValue)
			if vString, err := cmdFlags.GetString("logs.mixed.stackdriver-template-uri"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.Mixed.StackDriverTemplateURI)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.user.cloudwatch-enabled", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.user.cloudwatch-enabled", testValue)
			if vBool, err := cmdFlags.GetBool("logs.user.cloudwatch-enabled"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vBool), &actual.LogConfig.User.IsCloudwatchEnabled)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.user.cloudwatch-region", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.user.cloudwatch-region", testValue)
			if vString, err := cmdFlags.GetString("logs.user.cloudwatch-region"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.User.CloudwatchRegion)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.user.cloudwatch-log-group", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.user.cloudwatch-log-group", testValue)
			if vString, err := cmdFlags.GetString("logs.user.cloudwatch-log-group"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.User.CloudwatchLogGroup)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.user.cloudwatch-template-uri", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.user.cloudwatch-template-uri", testValue)
			if vString, err := cmdFlags.GetString("logs.user.cloudwatch-template-uri"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.User.CloudwatchTemplateURI)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.user.kubernetes-enabled", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.user.kubernetes-enabled", testValue)
			if vBool, err := cmdFlags.GetBool("logs.user.kubernetes-enabled"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vBool), &actual.LogConfig.User.IsKubernetesEnabled)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.user.kubernetes-url", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.user.kubernetes-url", testValue)
			if vString, err := cmdFlags.GetString("logs.user.kubernetes-url"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.User.KubernetesURL)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.user.kubernetes-template-uri", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.user.kubernetes-template-uri", testValue)
			if vString, err := cmdFlags.GetString("logs.user.kubernetes-template-uri"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.User.KubernetesTemplateURI)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.user.stackdriver-enabled", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.user.stackdriver-enabled", testValue)
			if vBool, err := cmdFlags.GetBool("logs.user.stackdriver-enabled"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vBool), &actual.LogConfig.User.IsStackDriverEnabled)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.user.gcp-project", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.user.gcp-project", testValue)
			if vString, err := cmdFlags.GetString("logs.user.gcp-project"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.User.GCPProjectName)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.user.stackdriver-logresourcename", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.user.stackdriver-logresourcename", testValue)
			if vString, err := cmdFlags.GetString("logs.user.stackdriver-logresourcename"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.User.StackdriverLogResourceName)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.user.stackdriver-template-uri", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.user.stackdriver-template-uri", testValue)
			if vString, err := cmdFlags.GetString("logs.user.stackdriver-template-uri"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.User.StackDriverTemplateURI)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.system.cloudwatch-enabled", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.system.cloudwatch-enabled", testValue)
			if vBool, err := cmdFlags.GetBool("logs.system.cloudwatch-enabled"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vBool), &actual.LogConfig.System.IsCloudwatchEnabled)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.system.cloudwatch-region", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.system.cloudwatch-region", testValue)
			if vString, err := cmdFlags.GetString("logs.system.cloudwatch-region"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.System.CloudwatchRegion)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.system.cloudwatch-log-group", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.system.cloudwatch-log-group", testValue)
			if vString, err := cmdFlags.GetString("logs.system.cloudwatch-log-group"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.System.CloudwatchLogGroup)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.system.cloudwatch-template-uri", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.system.cloudwatch-template-uri", testValue)
			if vString, err := cmdFlags.GetString("logs.system.cloudwatch-template-uri"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.System.CloudwatchTemplateURI)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.system.kubernetes-enabled", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.system.kubernetes-enabled", testValue)
			if vBool, err := cmdFlags.GetBool("logs.system.kubernetes-enabled"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vBool), &actual.LogConfig.System.IsKubernetesEnabled)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.system.kubernetes-url", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.system.kubernetes-url", testValue)
			if vString, err := cmdFlags.GetString("logs.system.kubernetes-url"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.System.KubernetesURL)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.system.kubernetes-template-uri", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.system.kubernetes-template-uri", testValue)
			if vString, err := cmdFlags.GetString("logs.system.kubernetes-template-uri"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.System.KubernetesTemplateURI)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.system.stackdriver-enabled", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.system.stackdriver-enabled", testValue)
			if vBool, err := cmdFlags.GetBool("logs.system.stackdriver-enabled"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vBool), &actual.LogConfig.System.IsStackDriverEnabled)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.system.gcp-project", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.system.gcp-project", testValue)
			if vString, err := cmdFlags.GetString("logs.system.gcp-project"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.System.GCPProjectName)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.system.stackdriver-logresourcename", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.system.stackdriver-logresourcename", testValue)
			if vString, err := cmdFlags.GetString("logs.system.stackdriver-logresourcename"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.System.StackdriverLogResourceName)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.system.stackdriver-template-uri", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.system.stackdriver-template-uri", testValue)
			if vString, err := cmdFlags.GetString("logs.system.stackdriver-template-uri"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.System.StackDriverTemplateURI)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.all-user.cloudwatch-enabled", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.all-user.cloudwatch-enabled", testValue)
			if vBool, err := cmdFlags.GetBool("logs.all-user.cloudwatch-enabled"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vBool), &actual.LogConfig.AllUser.IsCloudwatchEnabled)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.all-user.cloudwatch-region", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.all-user.cloudwatch-region", testValue)
			if vString, err := cmdFlags.GetString("logs.all-user.cloudwatch-region"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.AllUser.CloudwatchRegion)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.all-user.cloudwatch-log-group", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.all-user.cloudwatch-log-group", testValue)
			if vString, err := cmdFlags.GetString("logs.all-user.cloudwatch-log-group"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.AllUser.CloudwatchLogGroup)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.all-user.cloudwatch-template-uri", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.all-user.cloudwatch-template-uri", testValue)
			if vString, err := cmdFlags.GetString("logs.all-user.cloudwatch-template-uri"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.AllUser.CloudwatchTemplateURI)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.all-user.kubernetes-enabled", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.all-user.kubernetes-enabled", testValue)
			if vBool, err := cmdFlags.GetBool("logs.all-user.kubernetes-enabled"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vBool), &actual.LogConfig.AllUser.IsKubernetesEnabled)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.all-user.kubernetes-url", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.all-user.kubernetes-url", testValue)
			if vString, err := cmdFlags.GetString("logs.all-user.kubernetes-url"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.AllUser.KubernetesURL)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.all-user.kubernetes-template-uri", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.all-user.kubernetes-template-uri", testValue)
			if vString, err := cmdFlags.GetString("logs.all-user.kubernetes-template-uri"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.AllUser.KubernetesTemplateURI)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.all-user.stackdriver-enabled", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.all-user.stackdriver-enabled", testValue)
			if vBool, err := cmdFlags.GetBool("logs.all-user.stackdriver-enabled"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vBool), &actual.LogConfig.AllUser.IsStackDriverEnabled)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.all-user.gcp-project", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.all-user.gcp-project", testValue)
			if vString, err := cmdFlags.GetString("logs.all-user.gcp-project"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.AllUser.GCPProjectName)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.all-user.stackdriver-logresourcename", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.all-user.stackdriver-logresourcename", testValue)
			if vString, err := cmdFlags.GetString("logs.all-user.stackdriver-logresourcename"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.AllUser.StackdriverLogResourceName)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.all-user.stackdriver-template-uri", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.all-user.stackdriver-template-uri", testValue)
			if vString, err := cmdFlags.GetString("logs.all-user.stackdriver-template-uri"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.LogConfig.AllUser.StackDriverTemplateURI)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
}
