/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
(function(global, factory) { /* global define, require, module */

    /* AMD */ if (typeof define === 'function' && define.amd)
        define(["protobufjs/minimal"], factory);

    /* CommonJS */ else if (typeof require === 'function' && typeof module === 'object' && module && module.exports)
        module.exports = factory(require("protobufjs/minimal"));

})(this, function($protobuf) {
    "use strict";

    // Common aliases
    var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;
    
    // Exported root namespace
    var $root = $protobuf.roots.flyteidl || ($protobuf.roots.flyteidl = {});
    
    $root.flyteidl = (function() {
    
        /**
         * Namespace flyteidl.
         * @exports flyteidl
         * @namespace
         */
        var flyteidl = {};
    
        flyteidl.core = (function() {
    
            /**
             * Namespace core.
             * @memberof flyteidl
             * @namespace
             */
            var core = {};
    
            core.ArtifactKey = (function() {
    
                /**
                 * Properties of an ArtifactKey.
                 * @memberof flyteidl.core
                 * @interface IArtifactKey
                 * @property {string|null} [project] ArtifactKey project
                 * @property {string|null} [domain] ArtifactKey domain
                 * @property {string|null} [name] ArtifactKey name
                 * @property {string|null} [org] ArtifactKey org
                 */
    
                /**
                 * Constructs a new ArtifactKey.
                 * @memberof flyteidl.core
                 * @classdesc Represents an ArtifactKey.
                 * @implements IArtifactKey
                 * @constructor
                 * @param {flyteidl.core.IArtifactKey=} [properties] Properties to set
                 */
                function ArtifactKey(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * ArtifactKey project.
                 * @member {string} project
                 * @memberof flyteidl.core.ArtifactKey
                 * @instance
                 */
                ArtifactKey.prototype.project = "";
    
                /**
                 * ArtifactKey domain.
                 * @member {string} domain
                 * @memberof flyteidl.core.ArtifactKey
                 * @instance
                 */
                ArtifactKey.prototype.domain = "";
    
                /**
                 * ArtifactKey name.
                 * @member {string} name
                 * @memberof flyteidl.core.ArtifactKey
                 * @instance
                 */
                ArtifactKey.prototype.name = "";
    
                /**
                 * ArtifactKey org.
                 * @member {string} org
                 * @memberof flyteidl.core.ArtifactKey
                 * @instance
                 */
                ArtifactKey.prototype.org = "";
    
                /**
                 * Creates a new ArtifactKey instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.ArtifactKey
                 * @static
                 * @param {flyteidl.core.IArtifactKey=} [properties] Properties to set
                 * @returns {flyteidl.core.ArtifactKey} ArtifactKey instance
                 */
                ArtifactKey.create = function create(properties) {
                    return new ArtifactKey(properties);
                };
    
                /**
                 * Encodes the specified ArtifactKey message. Does not implicitly {@link flyteidl.core.ArtifactKey.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.ArtifactKey
                 * @static
                 * @param {flyteidl.core.IArtifactKey} message ArtifactKey message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ArtifactKey.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.project != null && message.hasOwnProperty("project"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.project);
                    if (message.domain != null && message.hasOwnProperty("domain"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.domain);
                    if (message.name != null && message.hasOwnProperty("name"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.name);
                    if (message.org != null && message.hasOwnProperty("org"))
                        writer.uint32(/* id 4, wireType 2 =*/34).string(message.org);
                    return writer;
                };
    
                /**
                 * Decodes an ArtifactKey message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.ArtifactKey
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.ArtifactKey} ArtifactKey
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ArtifactKey.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.ArtifactKey();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.project = reader.string();
                            break;
                        case 2:
                            message.domain = reader.string();
                            break;
                        case 3:
                            message.name = reader.string();
                            break;
                        case 4:
                            message.org = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an ArtifactKey message.
                 * @function verify
                 * @memberof flyteidl.core.ArtifactKey
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ArtifactKey.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.project != null && message.hasOwnProperty("project"))
                        if (!$util.isString(message.project))
                            return "project: string expected";
                    if (message.domain != null && message.hasOwnProperty("domain"))
                        if (!$util.isString(message.domain))
                            return "domain: string expected";
                    if (message.name != null && message.hasOwnProperty("name"))
                        if (!$util.isString(message.name))
                            return "name: string expected";
                    if (message.org != null && message.hasOwnProperty("org"))
                        if (!$util.isString(message.org))
                            return "org: string expected";
                    return null;
                };
    
                return ArtifactKey;
            })();
    
            core.ArtifactBindingData = (function() {
    
                /**
                 * Properties of an ArtifactBindingData.
                 * @memberof flyteidl.core
                 * @interface IArtifactBindingData
                 * @property {string|null} [partitionKey] ArtifactBindingData partitionKey
                 * @property {boolean|null} [bindToTimePartition] ArtifactBindingData bindToTimePartition
                 * @property {flyteidl.core.ITimeTransform|null} [timeTransform] ArtifactBindingData timeTransform
                 */
    
                /**
                 * Constructs a new ArtifactBindingData.
                 * @memberof flyteidl.core
                 * @classdesc Represents an ArtifactBindingData.
                 * @implements IArtifactBindingData
                 * @constructor
                 * @param {flyteidl.core.IArtifactBindingData=} [properties] Properties to set
                 */
                function ArtifactBindingData(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * ArtifactBindingData partitionKey.
                 * @member {string} partitionKey
                 * @memberof flyteidl.core.ArtifactBindingData
                 * @instance
                 */
                ArtifactBindingData.prototype.partitionKey = "";
    
                /**
                 * ArtifactBindingData bindToTimePartition.
                 * @member {boolean} bindToTimePartition
                 * @memberof flyteidl.core.ArtifactBindingData
                 * @instance
                 */
                ArtifactBindingData.prototype.bindToTimePartition = false;
    
                /**
                 * ArtifactBindingData timeTransform.
                 * @member {flyteidl.core.ITimeTransform|null|undefined} timeTransform
                 * @memberof flyteidl.core.ArtifactBindingData
                 * @instance
                 */
                ArtifactBindingData.prototype.timeTransform = null;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * ArtifactBindingData partitionData.
                 * @member {"partitionKey"|"bindToTimePartition"|undefined} partitionData
                 * @memberof flyteidl.core.ArtifactBindingData
                 * @instance
                 */
                Object.defineProperty(ArtifactBindingData.prototype, "partitionData", {
                    get: $util.oneOfGetter($oneOfFields = ["partitionKey", "bindToTimePartition"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new ArtifactBindingData instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.ArtifactBindingData
                 * @static
                 * @param {flyteidl.core.IArtifactBindingData=} [properties] Properties to set
                 * @returns {flyteidl.core.ArtifactBindingData} ArtifactBindingData instance
                 */
                ArtifactBindingData.create = function create(properties) {
                    return new ArtifactBindingData(properties);
                };
    
                /**
                 * Encodes the specified ArtifactBindingData message. Does not implicitly {@link flyteidl.core.ArtifactBindingData.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.ArtifactBindingData
                 * @static
                 * @param {flyteidl.core.IArtifactBindingData} message ArtifactBindingData message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ArtifactBindingData.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.partitionKey != null && message.hasOwnProperty("partitionKey"))
                        writer.uint32(/* id 5, wireType 2 =*/42).string(message.partitionKey);
                    if (message.bindToTimePartition != null && message.hasOwnProperty("bindToTimePartition"))
                        writer.uint32(/* id 6, wireType 0 =*/48).bool(message.bindToTimePartition);
                    if (message.timeTransform != null && message.hasOwnProperty("timeTransform"))
                        $root.flyteidl.core.TimeTransform.encode(message.timeTransform, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes an ArtifactBindingData message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.ArtifactBindingData
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.ArtifactBindingData} ArtifactBindingData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ArtifactBindingData.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.ArtifactBindingData();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 5:
                            message.partitionKey = reader.string();
                            break;
                        case 6:
                            message.bindToTimePartition = reader.bool();
                            break;
                        case 7:
                            message.timeTransform = $root.flyteidl.core.TimeTransform.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an ArtifactBindingData message.
                 * @function verify
                 * @memberof flyteidl.core.ArtifactBindingData
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ArtifactBindingData.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.partitionKey != null && message.hasOwnProperty("partitionKey")) {
                        properties.partitionData = 1;
                        if (!$util.isString(message.partitionKey))
                            return "partitionKey: string expected";
                    }
                    if (message.bindToTimePartition != null && message.hasOwnProperty("bindToTimePartition")) {
                        if (properties.partitionData === 1)
                            return "partitionData: multiple values";
                        properties.partitionData = 1;
                        if (typeof message.bindToTimePartition !== "boolean")
                            return "bindToTimePartition: boolean expected";
                    }
                    if (message.timeTransform != null && message.hasOwnProperty("timeTransform")) {
                        var error = $root.flyteidl.core.TimeTransform.verify(message.timeTransform);
                        if (error)
                            return "timeTransform." + error;
                    }
                    return null;
                };
    
                return ArtifactBindingData;
            })();
    
            /**
             * Granularity enum.
             * @name flyteidl.core.Granularity
             * @enum {string}
             * @property {number} UNSET=0 UNSET value
             * @property {number} MINUTE=1 MINUTE value
             * @property {number} HOUR=2 HOUR value
             * @property {number} DAY=3 DAY value
             * @property {number} MONTH=4 MONTH value
             */
            core.Granularity = (function() {
                var valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNSET"] = 0;
                values[valuesById[1] = "MINUTE"] = 1;
                values[valuesById[2] = "HOUR"] = 2;
                values[valuesById[3] = "DAY"] = 3;
                values[valuesById[4] = "MONTH"] = 4;
                return values;
            })();
    
            /**
             * Operator enum.
             * @name flyteidl.core.Operator
             * @enum {string}
             * @property {number} MINUS=0 MINUS value
             * @property {number} PLUS=1 PLUS value
             */
            core.Operator = (function() {
                var valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "MINUS"] = 0;
                values[valuesById[1] = "PLUS"] = 1;
                return values;
            })();
    
            core.TimeTransform = (function() {
    
                /**
                 * Properties of a TimeTransform.
                 * @memberof flyteidl.core
                 * @interface ITimeTransform
                 * @property {string|null} [transform] TimeTransform transform
                 * @property {flyteidl.core.Operator|null} [op] TimeTransform op
                 */
    
                /**
                 * Constructs a new TimeTransform.
                 * @memberof flyteidl.core
                 * @classdesc Represents a TimeTransform.
                 * @implements ITimeTransform
                 * @constructor
                 * @param {flyteidl.core.ITimeTransform=} [properties] Properties to set
                 */
                function TimeTransform(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * TimeTransform transform.
                 * @member {string} transform
                 * @memberof flyteidl.core.TimeTransform
                 * @instance
                 */
                TimeTransform.prototype.transform = "";
    
                /**
                 * TimeTransform op.
                 * @member {flyteidl.core.Operator} op
                 * @memberof flyteidl.core.TimeTransform
                 * @instance
                 */
                TimeTransform.prototype.op = 0;
    
                /**
                 * Creates a new TimeTransform instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.TimeTransform
                 * @static
                 * @param {flyteidl.core.ITimeTransform=} [properties] Properties to set
                 * @returns {flyteidl.core.TimeTransform} TimeTransform instance
                 */
                TimeTransform.create = function create(properties) {
                    return new TimeTransform(properties);
                };
    
                /**
                 * Encodes the specified TimeTransform message. Does not implicitly {@link flyteidl.core.TimeTransform.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.TimeTransform
                 * @static
                 * @param {flyteidl.core.ITimeTransform} message TimeTransform message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TimeTransform.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.transform != null && message.hasOwnProperty("transform"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.transform);
                    if (message.op != null && message.hasOwnProperty("op"))
                        writer.uint32(/* id 2, wireType 0 =*/16).int32(message.op);
                    return writer;
                };
    
                /**
                 * Decodes a TimeTransform message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.TimeTransform
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.TimeTransform} TimeTransform
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TimeTransform.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.TimeTransform();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.transform = reader.string();
                            break;
                        case 2:
                            message.op = reader.int32();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a TimeTransform message.
                 * @function verify
                 * @memberof flyteidl.core.TimeTransform
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TimeTransform.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.transform != null && message.hasOwnProperty("transform"))
                        if (!$util.isString(message.transform))
                            return "transform: string expected";
                    if (message.op != null && message.hasOwnProperty("op"))
                        switch (message.op) {
                        default:
                            return "op: enum value expected";
                        case 0:
                        case 1:
                            break;
                        }
                    return null;
                };
    
                return TimeTransform;
            })();
    
            core.InputBindingData = (function() {
    
                /**
                 * Properties of an InputBindingData.
                 * @memberof flyteidl.core
                 * @interface IInputBindingData
                 * @property {string|null} ["var"] InputBindingData var
                 */
    
                /**
                 * Constructs a new InputBindingData.
                 * @memberof flyteidl.core
                 * @classdesc Represents an InputBindingData.
                 * @implements IInputBindingData
                 * @constructor
                 * @param {flyteidl.core.IInputBindingData=} [properties] Properties to set
                 */
                function InputBindingData(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * InputBindingData var.
                 * @member {string} var
                 * @memberof flyteidl.core.InputBindingData
                 * @instance
                 */
                InputBindingData.prototype["var"] = "";
    
                /**
                 * Creates a new InputBindingData instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.InputBindingData
                 * @static
                 * @param {flyteidl.core.IInputBindingData=} [properties] Properties to set
                 * @returns {flyteidl.core.InputBindingData} InputBindingData instance
                 */
                InputBindingData.create = function create(properties) {
                    return new InputBindingData(properties);
                };
    
                /**
                 * Encodes the specified InputBindingData message. Does not implicitly {@link flyteidl.core.InputBindingData.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.InputBindingData
                 * @static
                 * @param {flyteidl.core.IInputBindingData} message InputBindingData message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                InputBindingData.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message["var"] != null && message.hasOwnProperty("var"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message["var"]);
                    return writer;
                };
    
                /**
                 * Decodes an InputBindingData message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.InputBindingData
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.InputBindingData} InputBindingData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                InputBindingData.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.InputBindingData();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message["var"] = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an InputBindingData message.
                 * @function verify
                 * @memberof flyteidl.core.InputBindingData
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                InputBindingData.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message["var"] != null && message.hasOwnProperty("var"))
                        if (!$util.isString(message["var"]))
                            return "var: string expected";
                    return null;
                };
    
                return InputBindingData;
            })();
    
            core.RuntimeBinding = (function() {
    
                /**
                 * Properties of a RuntimeBinding.
                 * @memberof flyteidl.core
                 * @interface IRuntimeBinding
                 */
    
                /**
                 * Constructs a new RuntimeBinding.
                 * @memberof flyteidl.core
                 * @classdesc Represents a RuntimeBinding.
                 * @implements IRuntimeBinding
                 * @constructor
                 * @param {flyteidl.core.IRuntimeBinding=} [properties] Properties to set
                 */
                function RuntimeBinding(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Creates a new RuntimeBinding instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.RuntimeBinding
                 * @static
                 * @param {flyteidl.core.IRuntimeBinding=} [properties] Properties to set
                 * @returns {flyteidl.core.RuntimeBinding} RuntimeBinding instance
                 */
                RuntimeBinding.create = function create(properties) {
                    return new RuntimeBinding(properties);
                };
    
                /**
                 * Encodes the specified RuntimeBinding message. Does not implicitly {@link flyteidl.core.RuntimeBinding.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.RuntimeBinding
                 * @static
                 * @param {flyteidl.core.IRuntimeBinding} message RuntimeBinding message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                RuntimeBinding.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    return writer;
                };
    
                /**
                 * Decodes a RuntimeBinding message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.RuntimeBinding
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.RuntimeBinding} RuntimeBinding
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                RuntimeBinding.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.RuntimeBinding();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a RuntimeBinding message.
                 * @function verify
                 * @memberof flyteidl.core.RuntimeBinding
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                RuntimeBinding.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    return null;
                };
    
                return RuntimeBinding;
            })();
    
            core.LabelValue = (function() {
    
                /**
                 * Properties of a LabelValue.
                 * @memberof flyteidl.core
                 * @interface ILabelValue
                 * @property {string|null} [staticValue] LabelValue staticValue
                 * @property {google.protobuf.ITimestamp|null} [timeValue] LabelValue timeValue
                 * @property {flyteidl.core.IArtifactBindingData|null} [triggeredBinding] LabelValue triggeredBinding
                 * @property {flyteidl.core.IInputBindingData|null} [inputBinding] LabelValue inputBinding
                 * @property {flyteidl.core.IRuntimeBinding|null} [runtimeBinding] LabelValue runtimeBinding
                 */
    
                /**
                 * Constructs a new LabelValue.
                 * @memberof flyteidl.core
                 * @classdesc Represents a LabelValue.
                 * @implements ILabelValue
                 * @constructor
                 * @param {flyteidl.core.ILabelValue=} [properties] Properties to set
                 */
                function LabelValue(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * LabelValue staticValue.
                 * @member {string} staticValue
                 * @memberof flyteidl.core.LabelValue
                 * @instance
                 */
                LabelValue.prototype.staticValue = "";
    
                /**
                 * LabelValue timeValue.
                 * @member {google.protobuf.ITimestamp|null|undefined} timeValue
                 * @memberof flyteidl.core.LabelValue
                 * @instance
                 */
                LabelValue.prototype.timeValue = null;
    
                /**
                 * LabelValue triggeredBinding.
                 * @member {flyteidl.core.IArtifactBindingData|null|undefined} triggeredBinding
                 * @memberof flyteidl.core.LabelValue
                 * @instance
                 */
                LabelValue.prototype.triggeredBinding = null;
    
                /**
                 * LabelValue inputBinding.
                 * @member {flyteidl.core.IInputBindingData|null|undefined} inputBinding
                 * @memberof flyteidl.core.LabelValue
                 * @instance
                 */
                LabelValue.prototype.inputBinding = null;
    
                /**
                 * LabelValue runtimeBinding.
                 * @member {flyteidl.core.IRuntimeBinding|null|undefined} runtimeBinding
                 * @memberof flyteidl.core.LabelValue
                 * @instance
                 */
                LabelValue.prototype.runtimeBinding = null;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * LabelValue value.
                 * @member {"staticValue"|"timeValue"|"triggeredBinding"|"inputBinding"|"runtimeBinding"|undefined} value
                 * @memberof flyteidl.core.LabelValue
                 * @instance
                 */
                Object.defineProperty(LabelValue.prototype, "value", {
                    get: $util.oneOfGetter($oneOfFields = ["staticValue", "timeValue", "triggeredBinding", "inputBinding", "runtimeBinding"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new LabelValue instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.LabelValue
                 * @static
                 * @param {flyteidl.core.ILabelValue=} [properties] Properties to set
                 * @returns {flyteidl.core.LabelValue} LabelValue instance
                 */
                LabelValue.create = function create(properties) {
                    return new LabelValue(properties);
                };
    
                /**
                 * Encodes the specified LabelValue message. Does not implicitly {@link flyteidl.core.LabelValue.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.LabelValue
                 * @static
                 * @param {flyteidl.core.ILabelValue} message LabelValue message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                LabelValue.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.staticValue != null && message.hasOwnProperty("staticValue"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.staticValue);
                    if (message.timeValue != null && message.hasOwnProperty("timeValue"))
                        $root.google.protobuf.Timestamp.encode(message.timeValue, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.triggeredBinding != null && message.hasOwnProperty("triggeredBinding"))
                        $root.flyteidl.core.ArtifactBindingData.encode(message.triggeredBinding, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message.inputBinding != null && message.hasOwnProperty("inputBinding"))
                        $root.flyteidl.core.InputBindingData.encode(message.inputBinding, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.runtimeBinding != null && message.hasOwnProperty("runtimeBinding"))
                        $root.flyteidl.core.RuntimeBinding.encode(message.runtimeBinding, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a LabelValue message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.LabelValue
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.LabelValue} LabelValue
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                LabelValue.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.LabelValue();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.staticValue = reader.string();
                            break;
                        case 2:
                            message.timeValue = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                            break;
                        case 3:
                            message.triggeredBinding = $root.flyteidl.core.ArtifactBindingData.decode(reader, reader.uint32());
                            break;
                        case 4:
                            message.inputBinding = $root.flyteidl.core.InputBindingData.decode(reader, reader.uint32());
                            break;
                        case 5:
                            message.runtimeBinding = $root.flyteidl.core.RuntimeBinding.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a LabelValue message.
                 * @function verify
                 * @memberof flyteidl.core.LabelValue
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                LabelValue.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.staticValue != null && message.hasOwnProperty("staticValue")) {
                        properties.value = 1;
                        if (!$util.isString(message.staticValue))
                            return "staticValue: string expected";
                    }
                    if (message.timeValue != null && message.hasOwnProperty("timeValue")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        {
                            var error = $root.google.protobuf.Timestamp.verify(message.timeValue);
                            if (error)
                                return "timeValue." + error;
                        }
                    }
                    if (message.triggeredBinding != null && message.hasOwnProperty("triggeredBinding")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        {
                            var error = $root.flyteidl.core.ArtifactBindingData.verify(message.triggeredBinding);
                            if (error)
                                return "triggeredBinding." + error;
                        }
                    }
                    if (message.inputBinding != null && message.hasOwnProperty("inputBinding")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        {
                            var error = $root.flyteidl.core.InputBindingData.verify(message.inputBinding);
                            if (error)
                                return "inputBinding." + error;
                        }
                    }
                    if (message.runtimeBinding != null && message.hasOwnProperty("runtimeBinding")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        {
                            var error = $root.flyteidl.core.RuntimeBinding.verify(message.runtimeBinding);
                            if (error)
                                return "runtimeBinding." + error;
                        }
                    }
                    return null;
                };
    
                return LabelValue;
            })();
    
            core.Partitions = (function() {
    
                /**
                 * Properties of a Partitions.
                 * @memberof flyteidl.core
                 * @interface IPartitions
                 * @property {Object.<string,flyteidl.core.ILabelValue>|null} [value] Partitions value
                 */
    
                /**
                 * Constructs a new Partitions.
                 * @memberof flyteidl.core
                 * @classdesc Represents a Partitions.
                 * @implements IPartitions
                 * @constructor
                 * @param {flyteidl.core.IPartitions=} [properties] Properties to set
                 */
                function Partitions(properties) {
                    this.value = {};
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Partitions value.
                 * @member {Object.<string,flyteidl.core.ILabelValue>} value
                 * @memberof flyteidl.core.Partitions
                 * @instance
                 */
                Partitions.prototype.value = $util.emptyObject;
    
                /**
                 * Creates a new Partitions instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Partitions
                 * @static
                 * @param {flyteidl.core.IPartitions=} [properties] Properties to set
                 * @returns {flyteidl.core.Partitions} Partitions instance
                 */
                Partitions.create = function create(properties) {
                    return new Partitions(properties);
                };
    
                /**
                 * Encodes the specified Partitions message. Does not implicitly {@link flyteidl.core.Partitions.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Partitions
                 * @static
                 * @param {flyteidl.core.IPartitions} message Partitions message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Partitions.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.value != null && message.hasOwnProperty("value"))
                        for (var keys = Object.keys(message.value), i = 0; i < keys.length; ++i) {
                            writer.uint32(/* id 1, wireType 2 =*/10).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]);
                            $root.flyteidl.core.LabelValue.encode(message.value[keys[i]], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim().ldelim();
                        }
                    return writer;
                };
    
                /**
                 * Decodes a Partitions message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Partitions
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Partitions} Partitions
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Partitions.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Partitions(), key;
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            reader.skip().pos++;
                            if (message.value === $util.emptyObject)
                                message.value = {};
                            key = reader.string();
                            reader.pos++;
                            message.value[key] = $root.flyteidl.core.LabelValue.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a Partitions message.
                 * @function verify
                 * @memberof flyteidl.core.Partitions
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Partitions.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.value != null && message.hasOwnProperty("value")) {
                        if (!$util.isObject(message.value))
                            return "value: object expected";
                        var key = Object.keys(message.value);
                        for (var i = 0; i < key.length; ++i) {
                            var error = $root.flyteidl.core.LabelValue.verify(message.value[key[i]]);
                            if (error)
                                return "value." + error;
                        }
                    }
                    return null;
                };
    
                return Partitions;
            })();
    
            core.TimePartition = (function() {
    
                /**
                 * Properties of a TimePartition.
                 * @memberof flyteidl.core
                 * @interface ITimePartition
                 * @property {flyteidl.core.ILabelValue|null} [value] TimePartition value
                 * @property {flyteidl.core.Granularity|null} [granularity] TimePartition granularity
                 */
    
                /**
                 * Constructs a new TimePartition.
                 * @memberof flyteidl.core
                 * @classdesc Represents a TimePartition.
                 * @implements ITimePartition
                 * @constructor
                 * @param {flyteidl.core.ITimePartition=} [properties] Properties to set
                 */
                function TimePartition(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * TimePartition value.
                 * @member {flyteidl.core.ILabelValue|null|undefined} value
                 * @memberof flyteidl.core.TimePartition
                 * @instance
                 */
                TimePartition.prototype.value = null;
    
                /**
                 * TimePartition granularity.
                 * @member {flyteidl.core.Granularity} granularity
                 * @memberof flyteidl.core.TimePartition
                 * @instance
                 */
                TimePartition.prototype.granularity = 0;
    
                /**
                 * Creates a new TimePartition instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.TimePartition
                 * @static
                 * @param {flyteidl.core.ITimePartition=} [properties] Properties to set
                 * @returns {flyteidl.core.TimePartition} TimePartition instance
                 */
                TimePartition.create = function create(properties) {
                    return new TimePartition(properties);
                };
    
                /**
                 * Encodes the specified TimePartition message. Does not implicitly {@link flyteidl.core.TimePartition.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.TimePartition
                 * @static
                 * @param {flyteidl.core.ITimePartition} message TimePartition message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TimePartition.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.value != null && message.hasOwnProperty("value"))
                        $root.flyteidl.core.LabelValue.encode(message.value, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.granularity != null && message.hasOwnProperty("granularity"))
                        writer.uint32(/* id 2, wireType 0 =*/16).int32(message.granularity);
                    return writer;
                };
    
                /**
                 * Decodes a TimePartition message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.TimePartition
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.TimePartition} TimePartition
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TimePartition.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.TimePartition();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.value = $root.flyteidl.core.LabelValue.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.granularity = reader.int32();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a TimePartition message.
                 * @function verify
                 * @memberof flyteidl.core.TimePartition
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TimePartition.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.value != null && message.hasOwnProperty("value")) {
                        var error = $root.flyteidl.core.LabelValue.verify(message.value);
                        if (error)
                            return "value." + error;
                    }
                    if (message.granularity != null && message.hasOwnProperty("granularity"))
                        switch (message.granularity) {
                        default:
                            return "granularity: enum value expected";
                        case 0:
                        case 1:
                        case 2:
                        case 3:
                        case 4:
                            break;
                        }
                    return null;
                };
    
                return TimePartition;
            })();
    
            core.ArtifactID = (function() {
    
                /**
                 * Properties of an ArtifactID.
                 * @memberof flyteidl.core
                 * @interface IArtifactID
                 * @property {flyteidl.core.IArtifactKey|null} [artifactKey] ArtifactID artifactKey
                 * @property {string|null} [version] ArtifactID version
                 * @property {flyteidl.core.IPartitions|null} [partitions] ArtifactID partitions
                 * @property {flyteidl.core.ITimePartition|null} [timePartition] ArtifactID timePartition
                 */
    
                /**
                 * Constructs a new ArtifactID.
                 * @memberof flyteidl.core
                 * @classdesc Represents an ArtifactID.
                 * @implements IArtifactID
                 * @constructor
                 * @param {flyteidl.core.IArtifactID=} [properties] Properties to set
                 */
                function ArtifactID(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * ArtifactID artifactKey.
                 * @member {flyteidl.core.IArtifactKey|null|undefined} artifactKey
                 * @memberof flyteidl.core.ArtifactID
                 * @instance
                 */
                ArtifactID.prototype.artifactKey = null;
    
                /**
                 * ArtifactID version.
                 * @member {string} version
                 * @memberof flyteidl.core.ArtifactID
                 * @instance
                 */
                ArtifactID.prototype.version = "";
    
                /**
                 * ArtifactID partitions.
                 * @member {flyteidl.core.IPartitions|null|undefined} partitions
                 * @memberof flyteidl.core.ArtifactID
                 * @instance
                 */
                ArtifactID.prototype.partitions = null;
    
                /**
                 * ArtifactID timePartition.
                 * @member {flyteidl.core.ITimePartition|null|undefined} timePartition
                 * @memberof flyteidl.core.ArtifactID
                 * @instance
                 */
                ArtifactID.prototype.timePartition = null;
    
                /**
                 * Creates a new ArtifactID instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.ArtifactID
                 * @static
                 * @param {flyteidl.core.IArtifactID=} [properties] Properties to set
                 * @returns {flyteidl.core.ArtifactID} ArtifactID instance
                 */
                ArtifactID.create = function create(properties) {
                    return new ArtifactID(properties);
                };
    
                /**
                 * Encodes the specified ArtifactID message. Does not implicitly {@link flyteidl.core.ArtifactID.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.ArtifactID
                 * @static
                 * @param {flyteidl.core.IArtifactID} message ArtifactID message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ArtifactID.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.artifactKey != null && message.hasOwnProperty("artifactKey"))
                        $root.flyteidl.core.ArtifactKey.encode(message.artifactKey, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.version != null && message.hasOwnProperty("version"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.version);
                    if (message.partitions != null && message.hasOwnProperty("partitions"))
                        $root.flyteidl.core.Partitions.encode(message.partitions, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message.timePartition != null && message.hasOwnProperty("timePartition"))
                        $root.flyteidl.core.TimePartition.encode(message.timePartition, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes an ArtifactID message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.ArtifactID
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.ArtifactID} ArtifactID
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ArtifactID.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.ArtifactID();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.artifactKey = $root.flyteidl.core.ArtifactKey.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.version = reader.string();
                            break;
                        case 3:
                            message.partitions = $root.flyteidl.core.Partitions.decode(reader, reader.uint32());
                            break;
                        case 4:
                            message.timePartition = $root.flyteidl.core.TimePartition.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an ArtifactID message.
                 * @function verify
                 * @memberof flyteidl.core.ArtifactID
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ArtifactID.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.artifactKey != null && message.hasOwnProperty("artifactKey")) {
                        var error = $root.flyteidl.core.ArtifactKey.verify(message.artifactKey);
                        if (error)
                            return "artifactKey." + error;
                    }
                    if (message.version != null && message.hasOwnProperty("version"))
                        if (!$util.isString(message.version))
                            return "version: string expected";
                    if (message.partitions != null && message.hasOwnProperty("partitions")) {
                        var error = $root.flyteidl.core.Partitions.verify(message.partitions);
                        if (error)
                            return "partitions." + error;
                    }
                    if (message.timePartition != null && message.hasOwnProperty("timePartition")) {
                        var error = $root.flyteidl.core.TimePartition.verify(message.timePartition);
                        if (error)
                            return "timePartition." + error;
                    }
                    return null;
                };
    
                return ArtifactID;
            })();
    
            core.ArtifactTag = (function() {
    
                /**
                 * Properties of an ArtifactTag.
                 * @memberof flyteidl.core
                 * @interface IArtifactTag
                 * @property {flyteidl.core.IArtifactKey|null} [artifactKey] ArtifactTag artifactKey
                 * @property {flyteidl.core.ILabelValue|null} [value] ArtifactTag value
                 */
    
                /**
                 * Constructs a new ArtifactTag.
                 * @memberof flyteidl.core
                 * @classdesc Represents an ArtifactTag.
                 * @implements IArtifactTag
                 * @constructor
                 * @param {flyteidl.core.IArtifactTag=} [properties] Properties to set
                 */
                function ArtifactTag(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * ArtifactTag artifactKey.
                 * @member {flyteidl.core.IArtifactKey|null|undefined} artifactKey
                 * @memberof flyteidl.core.ArtifactTag
                 * @instance
                 */
                ArtifactTag.prototype.artifactKey = null;
    
                /**
                 * ArtifactTag value.
                 * @member {flyteidl.core.ILabelValue|null|undefined} value
                 * @memberof flyteidl.core.ArtifactTag
                 * @instance
                 */
                ArtifactTag.prototype.value = null;
    
                /**
                 * Creates a new ArtifactTag instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.ArtifactTag
                 * @static
                 * @param {flyteidl.core.IArtifactTag=} [properties] Properties to set
                 * @returns {flyteidl.core.ArtifactTag} ArtifactTag instance
                 */
                ArtifactTag.create = function create(properties) {
                    return new ArtifactTag(properties);
                };
    
                /**
                 * Encodes the specified ArtifactTag message. Does not implicitly {@link flyteidl.core.ArtifactTag.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.ArtifactTag
                 * @static
                 * @param {flyteidl.core.IArtifactTag} message ArtifactTag message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ArtifactTag.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.artifactKey != null && message.hasOwnProperty("artifactKey"))
                        $root.flyteidl.core.ArtifactKey.encode(message.artifactKey, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.value != null && message.hasOwnProperty("value"))
                        $root.flyteidl.core.LabelValue.encode(message.value, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes an ArtifactTag message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.ArtifactTag
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.ArtifactTag} ArtifactTag
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ArtifactTag.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.ArtifactTag();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.artifactKey = $root.flyteidl.core.ArtifactKey.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.value = $root.flyteidl.core.LabelValue.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an ArtifactTag message.
                 * @function verify
                 * @memberof flyteidl.core.ArtifactTag
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ArtifactTag.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.artifactKey != null && message.hasOwnProperty("artifactKey")) {
                        var error = $root.flyteidl.core.ArtifactKey.verify(message.artifactKey);
                        if (error)
                            return "artifactKey." + error;
                    }
                    if (message.value != null && message.hasOwnProperty("value")) {
                        var error = $root.flyteidl.core.LabelValue.verify(message.value);
                        if (error)
                            return "value." + error;
                    }
                    return null;
                };
    
                return ArtifactTag;
            })();
    
            core.ArtifactQuery = (function() {
    
                /**
                 * Properties of an ArtifactQuery.
                 * @memberof flyteidl.core
                 * @interface IArtifactQuery
                 * @property {flyteidl.core.IArtifactID|null} [artifactId] ArtifactQuery artifactId
                 * @property {flyteidl.core.IArtifactTag|null} [artifactTag] ArtifactQuery artifactTag
                 * @property {string|null} [uri] ArtifactQuery uri
                 * @property {flyteidl.core.IArtifactBindingData|null} [binding] ArtifactQuery binding
                 */
    
                /**
                 * Constructs a new ArtifactQuery.
                 * @memberof flyteidl.core
                 * @classdesc Represents an ArtifactQuery.
                 * @implements IArtifactQuery
                 * @constructor
                 * @param {flyteidl.core.IArtifactQuery=} [properties] Properties to set
                 */
                function ArtifactQuery(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * ArtifactQuery artifactId.
                 * @member {flyteidl.core.IArtifactID|null|undefined} artifactId
                 * @memberof flyteidl.core.ArtifactQuery
                 * @instance
                 */
                ArtifactQuery.prototype.artifactId = null;
    
                /**
                 * ArtifactQuery artifactTag.
                 * @member {flyteidl.core.IArtifactTag|null|undefined} artifactTag
                 * @memberof flyteidl.core.ArtifactQuery
                 * @instance
                 */
                ArtifactQuery.prototype.artifactTag = null;
    
                /**
                 * ArtifactQuery uri.
                 * @member {string} uri
                 * @memberof flyteidl.core.ArtifactQuery
                 * @instance
                 */
                ArtifactQuery.prototype.uri = "";
    
                /**
                 * ArtifactQuery binding.
                 * @member {flyteidl.core.IArtifactBindingData|null|undefined} binding
                 * @memberof flyteidl.core.ArtifactQuery
                 * @instance
                 */
                ArtifactQuery.prototype.binding = null;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * ArtifactQuery identifier.
                 * @member {"artifactId"|"artifactTag"|"uri"|"binding"|undefined} identifier
                 * @memberof flyteidl.core.ArtifactQuery
                 * @instance
                 */
                Object.defineProperty(ArtifactQuery.prototype, "identifier", {
                    get: $util.oneOfGetter($oneOfFields = ["artifactId", "artifactTag", "uri", "binding"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new ArtifactQuery instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.ArtifactQuery
                 * @static
                 * @param {flyteidl.core.IArtifactQuery=} [properties] Properties to set
                 * @returns {flyteidl.core.ArtifactQuery} ArtifactQuery instance
                 */
                ArtifactQuery.create = function create(properties) {
                    return new ArtifactQuery(properties);
                };
    
                /**
                 * Encodes the specified ArtifactQuery message. Does not implicitly {@link flyteidl.core.ArtifactQuery.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.ArtifactQuery
                 * @static
                 * @param {flyteidl.core.IArtifactQuery} message ArtifactQuery message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ArtifactQuery.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.artifactId != null && message.hasOwnProperty("artifactId"))
                        $root.flyteidl.core.ArtifactID.encode(message.artifactId, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.artifactTag != null && message.hasOwnProperty("artifactTag"))
                        $root.flyteidl.core.ArtifactTag.encode(message.artifactTag, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.uri != null && message.hasOwnProperty("uri"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.uri);
                    if (message.binding != null && message.hasOwnProperty("binding"))
                        $root.flyteidl.core.ArtifactBindingData.encode(message.binding, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes an ArtifactQuery message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.ArtifactQuery
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.ArtifactQuery} ArtifactQuery
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ArtifactQuery.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.ArtifactQuery();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.artifactId = $root.flyteidl.core.ArtifactID.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.artifactTag = $root.flyteidl.core.ArtifactTag.decode(reader, reader.uint32());
                            break;
                        case 3:
                            message.uri = reader.string();
                            break;
                        case 4:
                            message.binding = $root.flyteidl.core.ArtifactBindingData.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an ArtifactQuery message.
                 * @function verify
                 * @memberof flyteidl.core.ArtifactQuery
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ArtifactQuery.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.artifactId != null && message.hasOwnProperty("artifactId")) {
                        properties.identifier = 1;
                        {
                            var error = $root.flyteidl.core.ArtifactID.verify(message.artifactId);
                            if (error)
                                return "artifactId." + error;
                        }
                    }
                    if (message.artifactTag != null && message.hasOwnProperty("artifactTag")) {
                        if (properties.identifier === 1)
                            return "identifier: multiple values";
                        properties.identifier = 1;
                        {
                            var error = $root.flyteidl.core.ArtifactTag.verify(message.artifactTag);
                            if (error)
                                return "artifactTag." + error;
                        }
                    }
                    if (message.uri != null && message.hasOwnProperty("uri")) {
                        if (properties.identifier === 1)
                            return "identifier: multiple values";
                        properties.identifier = 1;
                        if (!$util.isString(message.uri))
                            return "uri: string expected";
                    }
                    if (message.binding != null && message.hasOwnProperty("binding")) {
                        if (properties.identifier === 1)
                            return "identifier: multiple values";
                        properties.identifier = 1;
                        {
                            var error = $root.flyteidl.core.ArtifactBindingData.verify(message.binding);
                            if (error)
                                return "binding." + error;
                        }
                    }
                    return null;
                };
    
                return ArtifactQuery;
            })();
    
            /**
             * ResourceType enum.
             * @name flyteidl.core.ResourceType
             * @enum {string}
             * @property {number} UNSPECIFIED=0 UNSPECIFIED value
             * @property {number} TASK=1 TASK value
             * @property {number} WORKFLOW=2 WORKFLOW value
             * @property {number} LAUNCH_PLAN=3 LAUNCH_PLAN value
             * @property {number} DATASET=4 DATASET value
             */
            core.ResourceType = (function() {
                var valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "UNSPECIFIED"] = 0;
                values[valuesById[1] = "TASK"] = 1;
                values[valuesById[2] = "WORKFLOW"] = 2;
                values[valuesById[3] = "LAUNCH_PLAN"] = 3;
                values[valuesById[4] = "DATASET"] = 4;
                return values;
            })();
    
            core.Identifier = (function() {
    
                /**
                 * Properties of an Identifier.
                 * @memberof flyteidl.core
                 * @interface IIdentifier
                 * @property {flyteidl.core.ResourceType|null} [resourceType] Identifier resourceType
                 * @property {string|null} [project] Identifier project
                 * @property {string|null} [domain] Identifier domain
                 * @property {string|null} [name] Identifier name
                 * @property {string|null} [version] Identifier version
                 * @property {string|null} [org] Identifier org
                 */
    
                /**
                 * Constructs a new Identifier.
                 * @memberof flyteidl.core
                 * @classdesc Represents an Identifier.
                 * @implements IIdentifier
                 * @constructor
                 * @param {flyteidl.core.IIdentifier=} [properties] Properties to set
                 */
                function Identifier(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Identifier resourceType.
                 * @member {flyteidl.core.ResourceType} resourceType
                 * @memberof flyteidl.core.Identifier
                 * @instance
                 */
                Identifier.prototype.resourceType = 0;
    
                /**
                 * Identifier project.
                 * @member {string} project
                 * @memberof flyteidl.core.Identifier
                 * @instance
                 */
                Identifier.prototype.project = "";
    
                /**
                 * Identifier domain.
                 * @member {string} domain
                 * @memberof flyteidl.core.Identifier
                 * @instance
                 */
                Identifier.prototype.domain = "";
    
                /**
                 * Identifier name.
                 * @member {string} name
                 * @memberof flyteidl.core.Identifier
                 * @instance
                 */
                Identifier.prototype.name = "";
    
                /**
                 * Identifier version.
                 * @member {string} version
                 * @memberof flyteidl.core.Identifier
                 * @instance
                 */
                Identifier.prototype.version = "";
    
                /**
                 * Identifier org.
                 * @member {string} org
                 * @memberof flyteidl.core.Identifier
                 * @instance
                 */
                Identifier.prototype.org = "";
    
                /**
                 * Creates a new Identifier instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Identifier
                 * @static
                 * @param {flyteidl.core.IIdentifier=} [properties] Properties to set
                 * @returns {flyteidl.core.Identifier} Identifier instance
                 */
                Identifier.create = function create(properties) {
                    return new Identifier(properties);
                };
    
                /**
                 * Encodes the specified Identifier message. Does not implicitly {@link flyteidl.core.Identifier.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Identifier
                 * @static
                 * @param {flyteidl.core.IIdentifier} message Identifier message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Identifier.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.resourceType != null && message.hasOwnProperty("resourceType"))
                        writer.uint32(/* id 1, wireType 0 =*/8).int32(message.resourceType);
                    if (message.project != null && message.hasOwnProperty("project"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.project);
                    if (message.domain != null && message.hasOwnProperty("domain"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.domain);
                    if (message.name != null && message.hasOwnProperty("name"))
                        writer.uint32(/* id 4, wireType 2 =*/34).string(message.name);
                    if (message.version != null && message.hasOwnProperty("version"))
                        writer.uint32(/* id 5, wireType 2 =*/42).string(message.version);
                    if (message.org != null && message.hasOwnProperty("org"))
                        writer.uint32(/* id 6, wireType 2 =*/50).string(message.org);
                    return writer;
                };
    
                /**
                 * Decodes an Identifier message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Identifier
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Identifier} Identifier
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Identifier.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Identifier();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.resourceType = reader.int32();
                            break;
                        case 2:
                            message.project = reader.string();
                            break;
                        case 3:
                            message.domain = reader.string();
                            break;
                        case 4:
                            message.name = reader.string();
                            break;
                        case 5:
                            message.version = reader.string();
                            break;
                        case 6:
                            message.org = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an Identifier message.
                 * @function verify
                 * @memberof flyteidl.core.Identifier
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Identifier.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.resourceType != null && message.hasOwnProperty("resourceType"))
                        switch (message.resourceType) {
                        default:
                            return "resourceType: enum value expected";
                        case 0:
                        case 1:
                        case 2:
                        case 3:
                        case 4:
                            break;
                        }
                    if (message.project != null && message.hasOwnProperty("project"))
                        if (!$util.isString(message.project))
                            return "project: string expected";
                    if (message.domain != null && message.hasOwnProperty("domain"))
                        if (!$util.isString(message.domain))
                            return "domain: string expected";
                    if (message.name != null && message.hasOwnProperty("name"))
                        if (!$util.isString(message.name))
                            return "name: string expected";
                    if (message.version != null && message.hasOwnProperty("version"))
                        if (!$util.isString(message.version))
                            return "version: string expected";
                    if (message.org != null && message.hasOwnProperty("org"))
                        if (!$util.isString(message.org))
                            return "org: string expected";
                    return null;
                };
    
                return Identifier;
            })();
    
            core.WorkflowExecutionIdentifier = (function() {
    
                /**
                 * Properties of a WorkflowExecutionIdentifier.
                 * @memberof flyteidl.core
                 * @interface IWorkflowExecutionIdentifier
                 * @property {string|null} [project] WorkflowExecutionIdentifier project
                 * @property {string|null} [domain] WorkflowExecutionIdentifier domain
                 * @property {string|null} [name] WorkflowExecutionIdentifier name
                 * @property {string|null} [org] WorkflowExecutionIdentifier org
                 */
    
                /**
                 * Constructs a new WorkflowExecutionIdentifier.
                 * @memberof flyteidl.core
                 * @classdesc Represents a WorkflowExecutionIdentifier.
                 * @implements IWorkflowExecutionIdentifier
                 * @constructor
                 * @param {flyteidl.core.IWorkflowExecutionIdentifier=} [properties] Properties to set
                 */
                function WorkflowExecutionIdentifier(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * WorkflowExecutionIdentifier project.
                 * @member {string} project
                 * @memberof flyteidl.core.WorkflowExecutionIdentifier
                 * @instance
                 */
                WorkflowExecutionIdentifier.prototype.project = "";
    
                /**
                 * WorkflowExecutionIdentifier domain.
                 * @member {string} domain
                 * @memberof flyteidl.core.WorkflowExecutionIdentifier
                 * @instance
                 */
                WorkflowExecutionIdentifier.prototype.domain = "";
    
                /**
                 * WorkflowExecutionIdentifier name.
                 * @member {string} name
                 * @memberof flyteidl.core.WorkflowExecutionIdentifier
                 * @instance
                 */
                WorkflowExecutionIdentifier.prototype.name = "";
    
                /**
                 * WorkflowExecutionIdentifier org.
                 * @member {string} org
                 * @memberof flyteidl.core.WorkflowExecutionIdentifier
                 * @instance
                 */
                WorkflowExecutionIdentifier.prototype.org = "";
    
                /**
                 * Creates a new WorkflowExecutionIdentifier instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.WorkflowExecutionIdentifier
                 * @static
                 * @param {flyteidl.core.IWorkflowExecutionIdentifier=} [properties] Properties to set
                 * @returns {flyteidl.core.WorkflowExecutionIdentifier} WorkflowExecutionIdentifier instance
                 */
                WorkflowExecutionIdentifier.create = function create(properties) {
                    return new WorkflowExecutionIdentifier(properties);
                };
    
                /**
                 * Encodes the specified WorkflowExecutionIdentifier message. Does not implicitly {@link flyteidl.core.WorkflowExecutionIdentifier.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.WorkflowExecutionIdentifier
                 * @static
                 * @param {flyteidl.core.IWorkflowExecutionIdentifier} message WorkflowExecutionIdentifier message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                WorkflowExecutionIdentifier.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.project != null && message.hasOwnProperty("project"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.project);
                    if (message.domain != null && message.hasOwnProperty("domain"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.domain);
                    if (message.name != null && message.hasOwnProperty("name"))
                        writer.uint32(/* id 4, wireType 2 =*/34).string(message.name);
                    if (message.org != null && message.hasOwnProperty("org"))
                        writer.uint32(/* id 5, wireType 2 =*/42).string(message.org);
                    return writer;
                };
    
                /**
                 * Decodes a WorkflowExecutionIdentifier message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.WorkflowExecutionIdentifier
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.WorkflowExecutionIdentifier} WorkflowExecutionIdentifier
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                WorkflowExecutionIdentifier.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.WorkflowExecutionIdentifier();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.project = reader.string();
                            break;
                        case 2:
                            message.domain = reader.string();
                            break;
                        case 4:
                            message.name = reader.string();
                            break;
                        case 5:
                            message.org = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a WorkflowExecutionIdentifier message.
                 * @function verify
                 * @memberof flyteidl.core.WorkflowExecutionIdentifier
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                WorkflowExecutionIdentifier.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.project != null && message.hasOwnProperty("project"))
                        if (!$util.isString(message.project))
                            return "project: string expected";
                    if (message.domain != null && message.hasOwnProperty("domain"))
                        if (!$util.isString(message.domain))
                            return "domain: string expected";
                    if (message.name != null && message.hasOwnProperty("name"))
                        if (!$util.isString(message.name))
                            return "name: string expected";
                    if (message.org != null && message.hasOwnProperty("org"))
                        if (!$util.isString(message.org))
                            return "org: string expected";
                    return null;
                };
    
                return WorkflowExecutionIdentifier;
            })();
    
            core.NodeExecutionIdentifier = (function() {
    
                /**
                 * Properties of a NodeExecutionIdentifier.
                 * @memberof flyteidl.core
                 * @interface INodeExecutionIdentifier
                 * @property {string|null} [nodeId] NodeExecutionIdentifier nodeId
                 * @property {flyteidl.core.IWorkflowExecutionIdentifier|null} [executionId] NodeExecutionIdentifier executionId
                 */
    
                /**
                 * Constructs a new NodeExecutionIdentifier.
                 * @memberof flyteidl.core
                 * @classdesc Represents a NodeExecutionIdentifier.
                 * @implements INodeExecutionIdentifier
                 * @constructor
                 * @param {flyteidl.core.INodeExecutionIdentifier=} [properties] Properties to set
                 */
                function NodeExecutionIdentifier(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * NodeExecutionIdentifier nodeId.
                 * @member {string} nodeId
                 * @memberof flyteidl.core.NodeExecutionIdentifier
                 * @instance
                 */
                NodeExecutionIdentifier.prototype.nodeId = "";
    
                /**
                 * NodeExecutionIdentifier executionId.
                 * @member {flyteidl.core.IWorkflowExecutionIdentifier|null|undefined} executionId
                 * @memberof flyteidl.core.NodeExecutionIdentifier
                 * @instance
                 */
                NodeExecutionIdentifier.prototype.executionId = null;
    
                /**
                 * Creates a new NodeExecutionIdentifier instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.NodeExecutionIdentifier
                 * @static
                 * @param {flyteidl.core.INodeExecutionIdentifier=} [properties] Properties to set
                 * @returns {flyteidl.core.NodeExecutionIdentifier} NodeExecutionIdentifier instance
                 */
                NodeExecutionIdentifier.create = function create(properties) {
                    return new NodeExecutionIdentifier(properties);
                };
    
                /**
                 * Encodes the specified NodeExecutionIdentifier message. Does not implicitly {@link flyteidl.core.NodeExecutionIdentifier.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.NodeExecutionIdentifier
                 * @static
                 * @param {flyteidl.core.INodeExecutionIdentifier} message NodeExecutionIdentifier message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                NodeExecutionIdentifier.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.nodeId != null && message.hasOwnProperty("nodeId"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.nodeId);
                    if (message.executionId != null && message.hasOwnProperty("executionId"))
                        $root.flyteidl.core.WorkflowExecutionIdentifier.encode(message.executionId, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a NodeExecutionIdentifier message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.NodeExecutionIdentifier
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.NodeExecutionIdentifier} NodeExecutionIdentifier
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                NodeExecutionIdentifier.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.NodeExecutionIdentifier();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.nodeId = reader.string();
                            break;
                        case 2:
                            message.executionId = $root.flyteidl.core.WorkflowExecutionIdentifier.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a NodeExecutionIdentifier message.
                 * @function verify
                 * @memberof flyteidl.core.NodeExecutionIdentifier
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                NodeExecutionIdentifier.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.nodeId != null && message.hasOwnProperty("nodeId"))
                        if (!$util.isString(message.nodeId))
                            return "nodeId: string expected";
                    if (message.executionId != null && message.hasOwnProperty("executionId")) {
                        var error = $root.flyteidl.core.WorkflowExecutionIdentifier.verify(message.executionId);
                        if (error)
                            return "executionId." + error;
                    }
                    return null;
                };
    
                return NodeExecutionIdentifier;
            })();
    
            core.TaskExecutionIdentifier = (function() {
    
                /**
                 * Properties of a TaskExecutionIdentifier.
                 * @memberof flyteidl.core
                 * @interface ITaskExecutionIdentifier
                 * @property {flyteidl.core.IIdentifier|null} [taskId] TaskExecutionIdentifier taskId
                 * @property {flyteidl.core.INodeExecutionIdentifier|null} [nodeExecutionId] TaskExecutionIdentifier nodeExecutionId
                 * @property {number|null} [retryAttempt] TaskExecutionIdentifier retryAttempt
                 */
    
                /**
                 * Constructs a new TaskExecutionIdentifier.
                 * @memberof flyteidl.core
                 * @classdesc Represents a TaskExecutionIdentifier.
                 * @implements ITaskExecutionIdentifier
                 * @constructor
                 * @param {flyteidl.core.ITaskExecutionIdentifier=} [properties] Properties to set
                 */
                function TaskExecutionIdentifier(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * TaskExecutionIdentifier taskId.
                 * @member {flyteidl.core.IIdentifier|null|undefined} taskId
                 * @memberof flyteidl.core.TaskExecutionIdentifier
                 * @instance
                 */
                TaskExecutionIdentifier.prototype.taskId = null;
    
                /**
                 * TaskExecutionIdentifier nodeExecutionId.
                 * @member {flyteidl.core.INodeExecutionIdentifier|null|undefined} nodeExecutionId
                 * @memberof flyteidl.core.TaskExecutionIdentifier
                 * @instance
                 */
                TaskExecutionIdentifier.prototype.nodeExecutionId = null;
    
                /**
                 * TaskExecutionIdentifier retryAttempt.
                 * @member {number} retryAttempt
                 * @memberof flyteidl.core.TaskExecutionIdentifier
                 * @instance
                 */
                TaskExecutionIdentifier.prototype.retryAttempt = 0;
    
                /**
                 * Creates a new TaskExecutionIdentifier instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.TaskExecutionIdentifier
                 * @static
                 * @param {flyteidl.core.ITaskExecutionIdentifier=} [properties] Properties to set
                 * @returns {flyteidl.core.TaskExecutionIdentifier} TaskExecutionIdentifier instance
                 */
                TaskExecutionIdentifier.create = function create(properties) {
                    return new TaskExecutionIdentifier(properties);
                };
    
                /**
                 * Encodes the specified TaskExecutionIdentifier message. Does not implicitly {@link flyteidl.core.TaskExecutionIdentifier.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.TaskExecutionIdentifier
                 * @static
                 * @param {flyteidl.core.ITaskExecutionIdentifier} message TaskExecutionIdentifier message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TaskExecutionIdentifier.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.taskId != null && message.hasOwnProperty("taskId"))
                        $root.flyteidl.core.Identifier.encode(message.taskId, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.nodeExecutionId != null && message.hasOwnProperty("nodeExecutionId"))
                        $root.flyteidl.core.NodeExecutionIdentifier.encode(message.nodeExecutionId, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.retryAttempt != null && message.hasOwnProperty("retryAttempt"))
                        writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.retryAttempt);
                    return writer;
                };
    
                /**
                 * Decodes a TaskExecutionIdentifier message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.TaskExecutionIdentifier
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.TaskExecutionIdentifier} TaskExecutionIdentifier
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TaskExecutionIdentifier.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.TaskExecutionIdentifier();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.taskId = $root.flyteidl.core.Identifier.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.nodeExecutionId = $root.flyteidl.core.NodeExecutionIdentifier.decode(reader, reader.uint32());
                            break;
                        case 3:
                            message.retryAttempt = reader.uint32();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a TaskExecutionIdentifier message.
                 * @function verify
                 * @memberof flyteidl.core.TaskExecutionIdentifier
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TaskExecutionIdentifier.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.taskId != null && message.hasOwnProperty("taskId")) {
                        var error = $root.flyteidl.core.Identifier.verify(message.taskId);
                        if (error)
                            return "taskId." + error;
                    }
                    if (message.nodeExecutionId != null && message.hasOwnProperty("nodeExecutionId")) {
                        var error = $root.flyteidl.core.NodeExecutionIdentifier.verify(message.nodeExecutionId);
                        if (error)
                            return "nodeExecutionId." + error;
                    }
                    if (message.retryAttempt != null && message.hasOwnProperty("retryAttempt"))
                        if (!$util.isInteger(message.retryAttempt))
                            return "retryAttempt: integer expected";
                    return null;
                };
    
                return TaskExecutionIdentifier;
            })();
    
            core.SignalIdentifier = (function() {
    
                /**
                 * Properties of a SignalIdentifier.
                 * @memberof flyteidl.core
                 * @interface ISignalIdentifier
                 * @property {string|null} [signalId] SignalIdentifier signalId
                 * @property {flyteidl.core.IWorkflowExecutionIdentifier|null} [executionId] SignalIdentifier executionId
                 */
    
                /**
                 * Constructs a new SignalIdentifier.
                 * @memberof flyteidl.core
                 * @classdesc Represents a SignalIdentifier.
                 * @implements ISignalIdentifier
                 * @constructor
                 * @param {flyteidl.core.ISignalIdentifier=} [properties] Properties to set
                 */
                function SignalIdentifier(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * SignalIdentifier signalId.
                 * @member {string} signalId
                 * @memberof flyteidl.core.SignalIdentifier
                 * @instance
                 */
                SignalIdentifier.prototype.signalId = "";
    
                /**
                 * SignalIdentifier executionId.
                 * @member {flyteidl.core.IWorkflowExecutionIdentifier|null|undefined} executionId
                 * @memberof flyteidl.core.SignalIdentifier
                 * @instance
                 */
                SignalIdentifier.prototype.executionId = null;
    
                /**
                 * Creates a new SignalIdentifier instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.SignalIdentifier
                 * @static
                 * @param {flyteidl.core.ISignalIdentifier=} [properties] Properties to set
                 * @returns {flyteidl.core.SignalIdentifier} SignalIdentifier instance
                 */
                SignalIdentifier.create = function create(properties) {
                    return new SignalIdentifier(properties);
                };
    
                /**
                 * Encodes the specified SignalIdentifier message. Does not implicitly {@link flyteidl.core.SignalIdentifier.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.SignalIdentifier
                 * @static
                 * @param {flyteidl.core.ISignalIdentifier} message SignalIdentifier message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                SignalIdentifier.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.signalId != null && message.hasOwnProperty("signalId"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.signalId);
                    if (message.executionId != null && message.hasOwnProperty("executionId"))
                        $root.flyteidl.core.WorkflowExecutionIdentifier.encode(message.executionId, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a SignalIdentifier message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.SignalIdentifier
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.SignalIdentifier} SignalIdentifier
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                SignalIdentifier.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.SignalIdentifier();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.signalId = reader.string();
                            break;
                        case 2:
                            message.executionId = $root.flyteidl.core.WorkflowExecutionIdentifier.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a SignalIdentifier message.
                 * @function verify
                 * @memberof flyteidl.core.SignalIdentifier
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                SignalIdentifier.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.signalId != null && message.hasOwnProperty("signalId"))
                        if (!$util.isString(message.signalId))
                            return "signalId: string expected";
                    if (message.executionId != null && message.hasOwnProperty("executionId")) {
                        var error = $root.flyteidl.core.WorkflowExecutionIdentifier.verify(message.executionId);
                        if (error)
                            return "executionId." + error;
                    }
                    return null;
                };
    
                return SignalIdentifier;
            })();
    
            /**
             * CatalogCacheStatus enum.
             * @name flyteidl.core.CatalogCacheStatus
             * @enum {string}
             * @property {number} CACHE_DISABLED=0 CACHE_DISABLED value
             * @property {number} CACHE_MISS=1 CACHE_MISS value
             * @property {number} CACHE_HIT=2 CACHE_HIT value
             * @property {number} CACHE_POPULATED=3 CACHE_POPULATED value
             * @property {number} CACHE_LOOKUP_FAILURE=4 CACHE_LOOKUP_FAILURE value
             * @property {number} CACHE_PUT_FAILURE=5 CACHE_PUT_FAILURE value
             * @property {number} CACHE_SKIPPED=6 CACHE_SKIPPED value
             * @property {number} CACHE_EVICTED=7 CACHE_EVICTED value
             */
            core.CatalogCacheStatus = (function() {
                var valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "CACHE_DISABLED"] = 0;
                values[valuesById[1] = "CACHE_MISS"] = 1;
                values[valuesById[2] = "CACHE_HIT"] = 2;
                values[valuesById[3] = "CACHE_POPULATED"] = 3;
                values[valuesById[4] = "CACHE_LOOKUP_FAILURE"] = 4;
                values[valuesById[5] = "CACHE_PUT_FAILURE"] = 5;
                values[valuesById[6] = "CACHE_SKIPPED"] = 6;
                values[valuesById[7] = "CACHE_EVICTED"] = 7;
                return values;
            })();
    
            core.CatalogArtifactTag = (function() {
    
                /**
                 * Properties of a CatalogArtifactTag.
                 * @memberof flyteidl.core
                 * @interface ICatalogArtifactTag
                 * @property {string|null} [artifactId] CatalogArtifactTag artifactId
                 * @property {string|null} [name] CatalogArtifactTag name
                 */
    
                /**
                 * Constructs a new CatalogArtifactTag.
                 * @memberof flyteidl.core
                 * @classdesc Represents a CatalogArtifactTag.
                 * @implements ICatalogArtifactTag
                 * @constructor
                 * @param {flyteidl.core.ICatalogArtifactTag=} [properties] Properties to set
                 */
                function CatalogArtifactTag(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * CatalogArtifactTag artifactId.
                 * @member {string} artifactId
                 * @memberof flyteidl.core.CatalogArtifactTag
                 * @instance
                 */
                CatalogArtifactTag.prototype.artifactId = "";
    
                /**
                 * CatalogArtifactTag name.
                 * @member {string} name
                 * @memberof flyteidl.core.CatalogArtifactTag
                 * @instance
                 */
                CatalogArtifactTag.prototype.name = "";
    
                /**
                 * Creates a new CatalogArtifactTag instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.CatalogArtifactTag
                 * @static
                 * @param {flyteidl.core.ICatalogArtifactTag=} [properties] Properties to set
                 * @returns {flyteidl.core.CatalogArtifactTag} CatalogArtifactTag instance
                 */
                CatalogArtifactTag.create = function create(properties) {
                    return new CatalogArtifactTag(properties);
                };
    
                /**
                 * Encodes the specified CatalogArtifactTag message. Does not implicitly {@link flyteidl.core.CatalogArtifactTag.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.CatalogArtifactTag
                 * @static
                 * @param {flyteidl.core.ICatalogArtifactTag} message CatalogArtifactTag message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                CatalogArtifactTag.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.artifactId != null && message.hasOwnProperty("artifactId"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.artifactId);
                    if (message.name != null && message.hasOwnProperty("name"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.name);
                    return writer;
                };
    
                /**
                 * Decodes a CatalogArtifactTag message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.CatalogArtifactTag
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.CatalogArtifactTag} CatalogArtifactTag
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                CatalogArtifactTag.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.CatalogArtifactTag();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.artifactId = reader.string();
                            break;
                        case 2:
                            message.name = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a CatalogArtifactTag message.
                 * @function verify
                 * @memberof flyteidl.core.CatalogArtifactTag
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                CatalogArtifactTag.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.artifactId != null && message.hasOwnProperty("artifactId"))
                        if (!$util.isString(message.artifactId))
                            return "artifactId: string expected";
                    if (message.name != null && message.hasOwnProperty("name"))
                        if (!$util.isString(message.name))
                            return "name: string expected";
                    return null;
                };
    
                return CatalogArtifactTag;
            })();
    
            core.CatalogMetadata = (function() {
    
                /**
                 * Properties of a CatalogMetadata.
                 * @memberof flyteidl.core
                 * @interface ICatalogMetadata
                 * @property {flyteidl.core.IIdentifier|null} [datasetId] CatalogMetadata datasetId
                 * @property {flyteidl.core.ICatalogArtifactTag|null} [artifactTag] CatalogMetadata artifactTag
                 * @property {flyteidl.core.ITaskExecutionIdentifier|null} [sourceTaskExecution] CatalogMetadata sourceTaskExecution
                 */
    
                /**
                 * Constructs a new CatalogMetadata.
                 * @memberof flyteidl.core
                 * @classdesc Represents a CatalogMetadata.
                 * @implements ICatalogMetadata
                 * @constructor
                 * @param {flyteidl.core.ICatalogMetadata=} [properties] Properties to set
                 */
                function CatalogMetadata(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * CatalogMetadata datasetId.
                 * @member {flyteidl.core.IIdentifier|null|undefined} datasetId
                 * @memberof flyteidl.core.CatalogMetadata
                 * @instance
                 */
                CatalogMetadata.prototype.datasetId = null;
    
                /**
                 * CatalogMetadata artifactTag.
                 * @member {flyteidl.core.ICatalogArtifactTag|null|undefined} artifactTag
                 * @memberof flyteidl.core.CatalogMetadata
                 * @instance
                 */
                CatalogMetadata.prototype.artifactTag = null;
    
                /**
                 * CatalogMetadata sourceTaskExecution.
                 * @member {flyteidl.core.ITaskExecutionIdentifier|null|undefined} sourceTaskExecution
                 * @memberof flyteidl.core.CatalogMetadata
                 * @instance
                 */
                CatalogMetadata.prototype.sourceTaskExecution = null;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * CatalogMetadata sourceExecution.
                 * @member {"sourceTaskExecution"|undefined} sourceExecution
                 * @memberof flyteidl.core.CatalogMetadata
                 * @instance
                 */
                Object.defineProperty(CatalogMetadata.prototype, "sourceExecution", {
                    get: $util.oneOfGetter($oneOfFields = ["sourceTaskExecution"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new CatalogMetadata instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.CatalogMetadata
                 * @static
                 * @param {flyteidl.core.ICatalogMetadata=} [properties] Properties to set
                 * @returns {flyteidl.core.CatalogMetadata} CatalogMetadata instance
                 */
                CatalogMetadata.create = function create(properties) {
                    return new CatalogMetadata(properties);
                };
    
                /**
                 * Encodes the specified CatalogMetadata message. Does not implicitly {@link flyteidl.core.CatalogMetadata.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.CatalogMetadata
                 * @static
                 * @param {flyteidl.core.ICatalogMetadata} message CatalogMetadata message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                CatalogMetadata.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.datasetId != null && message.hasOwnProperty("datasetId"))
                        $root.flyteidl.core.Identifier.encode(message.datasetId, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.artifactTag != null && message.hasOwnProperty("artifactTag"))
                        $root.flyteidl.core.CatalogArtifactTag.encode(message.artifactTag, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.sourceTaskExecution != null && message.hasOwnProperty("sourceTaskExecution"))
                        $root.flyteidl.core.TaskExecutionIdentifier.encode(message.sourceTaskExecution, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a CatalogMetadata message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.CatalogMetadata
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.CatalogMetadata} CatalogMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                CatalogMetadata.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.CatalogMetadata();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.datasetId = $root.flyteidl.core.Identifier.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.artifactTag = $root.flyteidl.core.CatalogArtifactTag.decode(reader, reader.uint32());
                            break;
                        case 3:
                            message.sourceTaskExecution = $root.flyteidl.core.TaskExecutionIdentifier.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a CatalogMetadata message.
                 * @function verify
                 * @memberof flyteidl.core.CatalogMetadata
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                CatalogMetadata.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.datasetId != null && message.hasOwnProperty("datasetId")) {
                        var error = $root.flyteidl.core.Identifier.verify(message.datasetId);
                        if (error)
                            return "datasetId." + error;
                    }
                    if (message.artifactTag != null && message.hasOwnProperty("artifactTag")) {
                        var error = $root.flyteidl.core.CatalogArtifactTag.verify(message.artifactTag);
                        if (error)
                            return "artifactTag." + error;
                    }
                    if (message.sourceTaskExecution != null && message.hasOwnProperty("sourceTaskExecution")) {
                        properties.sourceExecution = 1;
                        {
                            var error = $root.flyteidl.core.TaskExecutionIdentifier.verify(message.sourceTaskExecution);
                            if (error)
                                return "sourceTaskExecution." + error;
                        }
                    }
                    return null;
                };
    
                return CatalogMetadata;
            })();
    
            core.CatalogReservation = (function() {
    
                /**
                 * Properties of a CatalogReservation.
                 * @memberof flyteidl.core
                 * @interface ICatalogReservation
                 */
    
                /**
                 * Constructs a new CatalogReservation.
                 * @memberof flyteidl.core
                 * @classdesc Represents a CatalogReservation.
                 * @implements ICatalogReservation
                 * @constructor
                 * @param {flyteidl.core.ICatalogReservation=} [properties] Properties to set
                 */
                function CatalogReservation(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Creates a new CatalogReservation instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.CatalogReservation
                 * @static
                 * @param {flyteidl.core.ICatalogReservation=} [properties] Properties to set
                 * @returns {flyteidl.core.CatalogReservation} CatalogReservation instance
                 */
                CatalogReservation.create = function create(properties) {
                    return new CatalogReservation(properties);
                };
    
                /**
                 * Encodes the specified CatalogReservation message. Does not implicitly {@link flyteidl.core.CatalogReservation.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.CatalogReservation
                 * @static
                 * @param {flyteidl.core.ICatalogReservation} message CatalogReservation message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                CatalogReservation.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    return writer;
                };
    
                /**
                 * Decodes a CatalogReservation message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.CatalogReservation
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.CatalogReservation} CatalogReservation
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                CatalogReservation.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.CatalogReservation();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a CatalogReservation message.
                 * @function verify
                 * @memberof flyteidl.core.CatalogReservation
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                CatalogReservation.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    return null;
                };
    
                /**
                 * Status enum.
                 * @name flyteidl.core.CatalogReservation.Status
                 * @enum {string}
                 * @property {number} RESERVATION_DISABLED=0 RESERVATION_DISABLED value
                 * @property {number} RESERVATION_ACQUIRED=1 RESERVATION_ACQUIRED value
                 * @property {number} RESERVATION_EXISTS=2 RESERVATION_EXISTS value
                 * @property {number} RESERVATION_RELEASED=3 RESERVATION_RELEASED value
                 * @property {number} RESERVATION_FAILURE=4 RESERVATION_FAILURE value
                 */
                CatalogReservation.Status = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "RESERVATION_DISABLED"] = 0;
                    values[valuesById[1] = "RESERVATION_ACQUIRED"] = 1;
                    values[valuesById[2] = "RESERVATION_EXISTS"] = 2;
                    values[valuesById[3] = "RESERVATION_RELEASED"] = 3;
                    values[valuesById[4] = "RESERVATION_FAILURE"] = 4;
                    return values;
                })();
    
                return CatalogReservation;
            })();
    
            core.ConnectionSet = (function() {
    
                /**
                 * Properties of a ConnectionSet.
                 * @memberof flyteidl.core
                 * @interface IConnectionSet
                 * @property {Object.<string,flyteidl.core.ConnectionSet.IIdList>|null} [downstream] ConnectionSet downstream
                 * @property {Object.<string,flyteidl.core.ConnectionSet.IIdList>|null} [upstream] ConnectionSet upstream
                 */
    
                /**
                 * Constructs a new ConnectionSet.
                 * @memberof flyteidl.core
                 * @classdesc Represents a ConnectionSet.
                 * @implements IConnectionSet
                 * @constructor
                 * @param {flyteidl.core.IConnectionSet=} [properties] Properties to set
                 */
                function ConnectionSet(properties) {
                    this.downstream = {};
                    this.upstream = {};
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * ConnectionSet downstream.
                 * @member {Object.<string,flyteidl.core.ConnectionSet.IIdList>} downstream
                 * @memberof flyteidl.core.ConnectionSet
                 * @instance
                 */
                ConnectionSet.prototype.downstream = $util.emptyObject;
    
                /**
                 * ConnectionSet upstream.
                 * @member {Object.<string,flyteidl.core.ConnectionSet.IIdList>} upstream
                 * @memberof flyteidl.core.ConnectionSet
                 * @instance
                 */
                ConnectionSet.prototype.upstream = $util.emptyObject;
    
                /**
                 * Creates a new ConnectionSet instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.ConnectionSet
                 * @static
                 * @param {flyteidl.core.IConnectionSet=} [properties] Properties to set
                 * @returns {flyteidl.core.ConnectionSet} ConnectionSet instance
                 */
                ConnectionSet.create = function create(properties) {
                    return new ConnectionSet(properties);
                };
    
                /**
                 * Encodes the specified ConnectionSet message. Does not implicitly {@link flyteidl.core.ConnectionSet.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.ConnectionSet
                 * @static
                 * @param {flyteidl.core.IConnectionSet} message ConnectionSet message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ConnectionSet.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.downstream != null && message.hasOwnProperty("downstream"))
                        for (var keys = Object.keys(message.downstream), i = 0; i < keys.length; ++i) {
                            writer.uint32(/* id 7, wireType 2 =*/58).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]);
                            $root.flyteidl.core.ConnectionSet.IdList.encode(message.downstream[keys[i]], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim().ldelim();
                        }
                    if (message.upstream != null && message.hasOwnProperty("upstream"))
                        for (var keys = Object.keys(message.upstream), i = 0; i < keys.length; ++i) {
                            writer.uint32(/* id 8, wireType 2 =*/66).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]);
                            $root.flyteidl.core.ConnectionSet.IdList.encode(message.upstream[keys[i]], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim().ldelim();
                        }
                    return writer;
                };
    
                /**
                 * Decodes a ConnectionSet message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.ConnectionSet
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.ConnectionSet} ConnectionSet
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ConnectionSet.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.ConnectionSet(), key;
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 7:
                            reader.skip().pos++;
                            if (message.downstream === $util.emptyObject)
                                message.downstream = {};
                            key = reader.string();
                            reader.pos++;
                            message.downstream[key] = $root.flyteidl.core.ConnectionSet.IdList.decode(reader, reader.uint32());
                            break;
                        case 8:
                            reader.skip().pos++;
                            if (message.upstream === $util.emptyObject)
                                message.upstream = {};
                            key = reader.string();
                            reader.pos++;
                            message.upstream[key] = $root.flyteidl.core.ConnectionSet.IdList.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a ConnectionSet message.
                 * @function verify
                 * @memberof flyteidl.core.ConnectionSet
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ConnectionSet.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.downstream != null && message.hasOwnProperty("downstream")) {
                        if (!$util.isObject(message.downstream))
                            return "downstream: object expected";
                        var key = Object.keys(message.downstream);
                        for (var i = 0; i < key.length; ++i) {
                            var error = $root.flyteidl.core.ConnectionSet.IdList.verify(message.downstream[key[i]]);
                            if (error)
                                return "downstream." + error;
                        }
                    }
                    if (message.upstream != null && message.hasOwnProperty("upstream")) {
                        if (!$util.isObject(message.upstream))
                            return "upstream: object expected";
                        var key = Object.keys(message.upstream);
                        for (var i = 0; i < key.length; ++i) {
                            var error = $root.flyteidl.core.ConnectionSet.IdList.verify(message.upstream[key[i]]);
                            if (error)
                                return "upstream." + error;
                        }
                    }
                    return null;
                };
    
                ConnectionSet.IdList = (function() {
    
                    /**
                     * Properties of an IdList.
                     * @memberof flyteidl.core.ConnectionSet
                     * @interface IIdList
                     * @property {Array.<string>|null} [ids] IdList ids
                     */
    
                    /**
                     * Constructs a new IdList.
                     * @memberof flyteidl.core.ConnectionSet
                     * @classdesc Represents an IdList.
                     * @implements IIdList
                     * @constructor
                     * @param {flyteidl.core.ConnectionSet.IIdList=} [properties] Properties to set
                     */
                    function IdList(properties) {
                        this.ids = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * IdList ids.
                     * @member {Array.<string>} ids
                     * @memberof flyteidl.core.ConnectionSet.IdList
                     * @instance
                     */
                    IdList.prototype.ids = $util.emptyArray;
    
                    /**
                     * Creates a new IdList instance using the specified properties.
                     * @function create
                     * @memberof flyteidl.core.ConnectionSet.IdList
                     * @static
                     * @param {flyteidl.core.ConnectionSet.IIdList=} [properties] Properties to set
                     * @returns {flyteidl.core.ConnectionSet.IdList} IdList instance
                     */
                    IdList.create = function create(properties) {
                        return new IdList(properties);
                    };
    
                    /**
                     * Encodes the specified IdList message. Does not implicitly {@link flyteidl.core.ConnectionSet.IdList.verify|verify} messages.
                     * @function encode
                     * @memberof flyteidl.core.ConnectionSet.IdList
                     * @static
                     * @param {flyteidl.core.ConnectionSet.IIdList} message IdList message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    IdList.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.ids != null && message.ids.length)
                            for (var i = 0; i < message.ids.length; ++i)
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.ids[i]);
                        return writer;
                    };
    
                    /**
                     * Decodes an IdList message from the specified reader or buffer.
                     * @function decode
                     * @memberof flyteidl.core.ConnectionSet.IdList
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {flyteidl.core.ConnectionSet.IdList} IdList
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    IdList.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.ConnectionSet.IdList();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                if (!(message.ids && message.ids.length))
                                    message.ids = [];
                                message.ids.push(reader.string());
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Verifies an IdList message.
                     * @function verify
                     * @memberof flyteidl.core.ConnectionSet.IdList
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    IdList.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.ids != null && message.hasOwnProperty("ids")) {
                            if (!Array.isArray(message.ids))
                                return "ids: array expected";
                            for (var i = 0; i < message.ids.length; ++i)
                                if (!$util.isString(message.ids[i]))
                                    return "ids: string[] expected";
                        }
                        return null;
                    };
    
                    return IdList;
                })();
    
                return ConnectionSet;
            })();
    
            core.CompiledWorkflow = (function() {
    
                /**
                 * Properties of a CompiledWorkflow.
                 * @memberof flyteidl.core
                 * @interface ICompiledWorkflow
                 * @property {flyteidl.core.IWorkflowTemplate|null} [template] CompiledWorkflow template
                 * @property {flyteidl.core.IConnectionSet|null} [connections] CompiledWorkflow connections
                 */
    
                /**
                 * Constructs a new CompiledWorkflow.
                 * @memberof flyteidl.core
                 * @classdesc Represents a CompiledWorkflow.
                 * @implements ICompiledWorkflow
                 * @constructor
                 * @param {flyteidl.core.ICompiledWorkflow=} [properties] Properties to set
                 */
                function CompiledWorkflow(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * CompiledWorkflow template.
                 * @member {flyteidl.core.IWorkflowTemplate|null|undefined} template
                 * @memberof flyteidl.core.CompiledWorkflow
                 * @instance
                 */
                CompiledWorkflow.prototype.template = null;
    
                /**
                 * CompiledWorkflow connections.
                 * @member {flyteidl.core.IConnectionSet|null|undefined} connections
                 * @memberof flyteidl.core.CompiledWorkflow
                 * @instance
                 */
                CompiledWorkflow.prototype.connections = null;
    
                /**
                 * Creates a new CompiledWorkflow instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.CompiledWorkflow
                 * @static
                 * @param {flyteidl.core.ICompiledWorkflow=} [properties] Properties to set
                 * @returns {flyteidl.core.CompiledWorkflow} CompiledWorkflow instance
                 */
                CompiledWorkflow.create = function create(properties) {
                    return new CompiledWorkflow(properties);
                };
    
                /**
                 * Encodes the specified CompiledWorkflow message. Does not implicitly {@link flyteidl.core.CompiledWorkflow.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.CompiledWorkflow
                 * @static
                 * @param {flyteidl.core.ICompiledWorkflow} message CompiledWorkflow message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                CompiledWorkflow.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.template != null && message.hasOwnProperty("template"))
                        $root.flyteidl.core.WorkflowTemplate.encode(message.template, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.connections != null && message.hasOwnProperty("connections"))
                        $root.flyteidl.core.ConnectionSet.encode(message.connections, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a CompiledWorkflow message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.CompiledWorkflow
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.CompiledWorkflow} CompiledWorkflow
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                CompiledWorkflow.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.CompiledWorkflow();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.template = $root.flyteidl.core.WorkflowTemplate.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.connections = $root.flyteidl.core.ConnectionSet.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a CompiledWorkflow message.
                 * @function verify
                 * @memberof flyteidl.core.CompiledWorkflow
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                CompiledWorkflow.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.template != null && message.hasOwnProperty("template")) {
                        var error = $root.flyteidl.core.WorkflowTemplate.verify(message.template);
                        if (error)
                            return "template." + error;
                    }
                    if (message.connections != null && message.hasOwnProperty("connections")) {
                        var error = $root.flyteidl.core.ConnectionSet.verify(message.connections);
                        if (error)
                            return "connections." + error;
                    }
                    return null;
                };
    
                return CompiledWorkflow;
            })();
    
            core.CompiledLaunchPlan = (function() {
    
                /**
                 * Properties of a CompiledLaunchPlan.
                 * @memberof flyteidl.core
                 * @interface ICompiledLaunchPlan
                 * @property {flyteidl.core.ILaunchPlanTemplate|null} [template] CompiledLaunchPlan template
                 */
    
                /**
                 * Constructs a new CompiledLaunchPlan.
                 * @memberof flyteidl.core
                 * @classdesc Represents a CompiledLaunchPlan.
                 * @implements ICompiledLaunchPlan
                 * @constructor
                 * @param {flyteidl.core.ICompiledLaunchPlan=} [properties] Properties to set
                 */
                function CompiledLaunchPlan(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * CompiledLaunchPlan template.
                 * @member {flyteidl.core.ILaunchPlanTemplate|null|undefined} template
                 * @memberof flyteidl.core.CompiledLaunchPlan
                 * @instance
                 */
                CompiledLaunchPlan.prototype.template = null;
    
                /**
                 * Creates a new CompiledLaunchPlan instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.CompiledLaunchPlan
                 * @static
                 * @param {flyteidl.core.ICompiledLaunchPlan=} [properties] Properties to set
                 * @returns {flyteidl.core.CompiledLaunchPlan} CompiledLaunchPlan instance
                 */
                CompiledLaunchPlan.create = function create(properties) {
                    return new CompiledLaunchPlan(properties);
                };
    
                /**
                 * Encodes the specified CompiledLaunchPlan message. Does not implicitly {@link flyteidl.core.CompiledLaunchPlan.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.CompiledLaunchPlan
                 * @static
                 * @param {flyteidl.core.ICompiledLaunchPlan} message CompiledLaunchPlan message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                CompiledLaunchPlan.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.template != null && message.hasOwnProperty("template"))
                        $root.flyteidl.core.LaunchPlanTemplate.encode(message.template, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a CompiledLaunchPlan message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.CompiledLaunchPlan
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.CompiledLaunchPlan} CompiledLaunchPlan
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                CompiledLaunchPlan.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.CompiledLaunchPlan();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.template = $root.flyteidl.core.LaunchPlanTemplate.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a CompiledLaunchPlan message.
                 * @function verify
                 * @memberof flyteidl.core.CompiledLaunchPlan
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                CompiledLaunchPlan.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.template != null && message.hasOwnProperty("template")) {
                        var error = $root.flyteidl.core.LaunchPlanTemplate.verify(message.template);
                        if (error)
                            return "template." + error;
                    }
                    return null;
                };
    
                return CompiledLaunchPlan;
            })();
    
            core.CompiledTask = (function() {
    
                /**
                 * Properties of a CompiledTask.
                 * @memberof flyteidl.core
                 * @interface ICompiledTask
                 * @property {flyteidl.core.ITaskTemplate|null} [template] CompiledTask template
                 */
    
                /**
                 * Constructs a new CompiledTask.
                 * @memberof flyteidl.core
                 * @classdesc Represents a CompiledTask.
                 * @implements ICompiledTask
                 * @constructor
                 * @param {flyteidl.core.ICompiledTask=} [properties] Properties to set
                 */
                function CompiledTask(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * CompiledTask template.
                 * @member {flyteidl.core.ITaskTemplate|null|undefined} template
                 * @memberof flyteidl.core.CompiledTask
                 * @instance
                 */
                CompiledTask.prototype.template = null;
    
                /**
                 * Creates a new CompiledTask instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.CompiledTask
                 * @static
                 * @param {flyteidl.core.ICompiledTask=} [properties] Properties to set
                 * @returns {flyteidl.core.CompiledTask} CompiledTask instance
                 */
                CompiledTask.create = function create(properties) {
                    return new CompiledTask(properties);
                };
    
                /**
                 * Encodes the specified CompiledTask message. Does not implicitly {@link flyteidl.core.CompiledTask.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.CompiledTask
                 * @static
                 * @param {flyteidl.core.ICompiledTask} message CompiledTask message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                CompiledTask.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.template != null && message.hasOwnProperty("template"))
                        $root.flyteidl.core.TaskTemplate.encode(message.template, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a CompiledTask message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.CompiledTask
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.CompiledTask} CompiledTask
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                CompiledTask.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.CompiledTask();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.template = $root.flyteidl.core.TaskTemplate.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a CompiledTask message.
                 * @function verify
                 * @memberof flyteidl.core.CompiledTask
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                CompiledTask.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.template != null && message.hasOwnProperty("template")) {
                        var error = $root.flyteidl.core.TaskTemplate.verify(message.template);
                        if (error)
                            return "template." + error;
                    }
                    return null;
                };
    
                return CompiledTask;
            })();
    
            core.CompiledWorkflowClosure = (function() {
    
                /**
                 * Properties of a CompiledWorkflowClosure.
                 * @memberof flyteidl.core
                 * @interface ICompiledWorkflowClosure
                 * @property {flyteidl.core.ICompiledWorkflow|null} [primary] CompiledWorkflowClosure primary
                 * @property {Array.<flyteidl.core.ICompiledWorkflow>|null} [subWorkflows] CompiledWorkflowClosure subWorkflows
                 * @property {Array.<flyteidl.core.ICompiledTask>|null} [tasks] CompiledWorkflowClosure tasks
                 * @property {Array.<flyteidl.core.ICompiledLaunchPlan>|null} [launchPlans] CompiledWorkflowClosure launchPlans
                 */
    
                /**
                 * Constructs a new CompiledWorkflowClosure.
                 * @memberof flyteidl.core
                 * @classdesc Represents a CompiledWorkflowClosure.
                 * @implements ICompiledWorkflowClosure
                 * @constructor
                 * @param {flyteidl.core.ICompiledWorkflowClosure=} [properties] Properties to set
                 */
                function CompiledWorkflowClosure(properties) {
                    this.subWorkflows = [];
                    this.tasks = [];
                    this.launchPlans = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * CompiledWorkflowClosure primary.
                 * @member {flyteidl.core.ICompiledWorkflow|null|undefined} primary
                 * @memberof flyteidl.core.CompiledWorkflowClosure
                 * @instance
                 */
                CompiledWorkflowClosure.prototype.primary = null;
    
                /**
                 * CompiledWorkflowClosure subWorkflows.
                 * @member {Array.<flyteidl.core.ICompiledWorkflow>} subWorkflows
                 * @memberof flyteidl.core.CompiledWorkflowClosure
                 * @instance
                 */
                CompiledWorkflowClosure.prototype.subWorkflows = $util.emptyArray;
    
                /**
                 * CompiledWorkflowClosure tasks.
                 * @member {Array.<flyteidl.core.ICompiledTask>} tasks
                 * @memberof flyteidl.core.CompiledWorkflowClosure
                 * @instance
                 */
                CompiledWorkflowClosure.prototype.tasks = $util.emptyArray;
    
                /**
                 * CompiledWorkflowClosure launchPlans.
                 * @member {Array.<flyteidl.core.ICompiledLaunchPlan>} launchPlans
                 * @memberof flyteidl.core.CompiledWorkflowClosure
                 * @instance
                 */
                CompiledWorkflowClosure.prototype.launchPlans = $util.emptyArray;
    
                /**
                 * Creates a new CompiledWorkflowClosure instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.CompiledWorkflowClosure
                 * @static
                 * @param {flyteidl.core.ICompiledWorkflowClosure=} [properties] Properties to set
                 * @returns {flyteidl.core.CompiledWorkflowClosure} CompiledWorkflowClosure instance
                 */
                CompiledWorkflowClosure.create = function create(properties) {
                    return new CompiledWorkflowClosure(properties);
                };
    
                /**
                 * Encodes the specified CompiledWorkflowClosure message. Does not implicitly {@link flyteidl.core.CompiledWorkflowClosure.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.CompiledWorkflowClosure
                 * @static
                 * @param {flyteidl.core.ICompiledWorkflowClosure} message CompiledWorkflowClosure message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                CompiledWorkflowClosure.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.primary != null && message.hasOwnProperty("primary"))
                        $root.flyteidl.core.CompiledWorkflow.encode(message.primary, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.subWorkflows != null && message.subWorkflows.length)
                        for (var i = 0; i < message.subWorkflows.length; ++i)
                            $root.flyteidl.core.CompiledWorkflow.encode(message.subWorkflows[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.tasks != null && message.tasks.length)
                        for (var i = 0; i < message.tasks.length; ++i)
                            $root.flyteidl.core.CompiledTask.encode(message.tasks[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message.launchPlans != null && message.launchPlans.length)
                        for (var i = 0; i < message.launchPlans.length; ++i)
                            $root.flyteidl.core.CompiledLaunchPlan.encode(message.launchPlans[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a CompiledWorkflowClosure message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.CompiledWorkflowClosure
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.CompiledWorkflowClosure} CompiledWorkflowClosure
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                CompiledWorkflowClosure.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.CompiledWorkflowClosure();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.primary = $root.flyteidl.core.CompiledWorkflow.decode(reader, reader.uint32());
                            break;
                        case 2:
                            if (!(message.subWorkflows && message.subWorkflows.length))
                                message.subWorkflows = [];
                            message.subWorkflows.push($root.flyteidl.core.CompiledWorkflow.decode(reader, reader.uint32()));
                            break;
                        case 3:
                            if (!(message.tasks && message.tasks.length))
                                message.tasks = [];
                            message.tasks.push($root.flyteidl.core.CompiledTask.decode(reader, reader.uint32()));
                            break;
                        case 4:
                            if (!(message.launchPlans && message.launchPlans.length))
                                message.launchPlans = [];
                            message.launchPlans.push($root.flyteidl.core.CompiledLaunchPlan.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a CompiledWorkflowClosure message.
                 * @function verify
                 * @memberof flyteidl.core.CompiledWorkflowClosure
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                CompiledWorkflowClosure.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.primary != null && message.hasOwnProperty("primary")) {
                        var error = $root.flyteidl.core.CompiledWorkflow.verify(message.primary);
                        if (error)
                            return "primary." + error;
                    }
                    if (message.subWorkflows != null && message.hasOwnProperty("subWorkflows")) {
                        if (!Array.isArray(message.subWorkflows))
                            return "subWorkflows: array expected";
                        for (var i = 0; i < message.subWorkflows.length; ++i) {
                            var error = $root.flyteidl.core.CompiledWorkflow.verify(message.subWorkflows[i]);
                            if (error)
                                return "subWorkflows." + error;
                        }
                    }
                    if (message.tasks != null && message.hasOwnProperty("tasks")) {
                        if (!Array.isArray(message.tasks))
                            return "tasks: array expected";
                        for (var i = 0; i < message.tasks.length; ++i) {
                            var error = $root.flyteidl.core.CompiledTask.verify(message.tasks[i]);
                            if (error)
                                return "tasks." + error;
                        }
                    }
                    if (message.launchPlans != null && message.hasOwnProperty("launchPlans")) {
                        if (!Array.isArray(message.launchPlans))
                            return "launchPlans: array expected";
                        for (var i = 0; i < message.launchPlans.length; ++i) {
                            var error = $root.flyteidl.core.CompiledLaunchPlan.verify(message.launchPlans[i]);
                            if (error)
                                return "launchPlans." + error;
                        }
                    }
                    return null;
                };
    
                return CompiledWorkflowClosure;
            })();
    
            core.Variable = (function() {
    
                /**
                 * Properties of a Variable.
                 * @memberof flyteidl.core
                 * @interface IVariable
                 * @property {flyteidl.core.ILiteralType|null} [type] Variable type
                 * @property {string|null} [description] Variable description
                 * @property {flyteidl.core.IArtifactID|null} [artifactPartialId] Variable artifactPartialId
                 * @property {flyteidl.core.IArtifactTag|null} [artifactTag] Variable artifactTag
                 */
    
                /**
                 * Constructs a new Variable.
                 * @memberof flyteidl.core
                 * @classdesc Represents a Variable.
                 * @implements IVariable
                 * @constructor
                 * @param {flyteidl.core.IVariable=} [properties] Properties to set
                 */
                function Variable(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Variable type.
                 * @member {flyteidl.core.ILiteralType|null|undefined} type
                 * @memberof flyteidl.core.Variable
                 * @instance
                 */
                Variable.prototype.type = null;
    
                /**
                 * Variable description.
                 * @member {string} description
                 * @memberof flyteidl.core.Variable
                 * @instance
                 */
                Variable.prototype.description = "";
    
                /**
                 * Variable artifactPartialId.
                 * @member {flyteidl.core.IArtifactID|null|undefined} artifactPartialId
                 * @memberof flyteidl.core.Variable
                 * @instance
                 */
                Variable.prototype.artifactPartialId = null;
    
                /**
                 * Variable artifactTag.
                 * @member {flyteidl.core.IArtifactTag|null|undefined} artifactTag
                 * @memberof flyteidl.core.Variable
                 * @instance
                 */
                Variable.prototype.artifactTag = null;
    
                /**
                 * Creates a new Variable instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Variable
                 * @static
                 * @param {flyteidl.core.IVariable=} [properties] Properties to set
                 * @returns {flyteidl.core.Variable} Variable instance
                 */
                Variable.create = function create(properties) {
                    return new Variable(properties);
                };
    
                /**
                 * Encodes the specified Variable message. Does not implicitly {@link flyteidl.core.Variable.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Variable
                 * @static
                 * @param {flyteidl.core.IVariable} message Variable message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Variable.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.type != null && message.hasOwnProperty("type"))
                        $root.flyteidl.core.LiteralType.encode(message.type, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.description != null && message.hasOwnProperty("description"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.description);
                    if (message.artifactPartialId != null && message.hasOwnProperty("artifactPartialId"))
                        $root.flyteidl.core.ArtifactID.encode(message.artifactPartialId, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message.artifactTag != null && message.hasOwnProperty("artifactTag"))
                        $root.flyteidl.core.ArtifactTag.encode(message.artifactTag, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a Variable message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Variable
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Variable} Variable
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Variable.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Variable();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.type = $root.flyteidl.core.LiteralType.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.description = reader.string();
                            break;
                        case 3:
                            message.artifactPartialId = $root.flyteidl.core.ArtifactID.decode(reader, reader.uint32());
                            break;
                        case 4:
                            message.artifactTag = $root.flyteidl.core.ArtifactTag.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a Variable message.
                 * @function verify
                 * @memberof flyteidl.core.Variable
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Variable.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.type != null && message.hasOwnProperty("type")) {
                        var error = $root.flyteidl.core.LiteralType.verify(message.type);
                        if (error)
                            return "type." + error;
                    }
                    if (message.description != null && message.hasOwnProperty("description"))
                        if (!$util.isString(message.description))
                            return "description: string expected";
                    if (message.artifactPartialId != null && message.hasOwnProperty("artifactPartialId")) {
                        var error = $root.flyteidl.core.ArtifactID.verify(message.artifactPartialId);
                        if (error)
                            return "artifactPartialId." + error;
                    }
                    if (message.artifactTag != null && message.hasOwnProperty("artifactTag")) {
                        var error = $root.flyteidl.core.ArtifactTag.verify(message.artifactTag);
                        if (error)
                            return "artifactTag." + error;
                    }
                    return null;
                };
    
                return Variable;
            })();
    
            core.VariableMap = (function() {
    
                /**
                 * Properties of a VariableMap.
                 * @memberof flyteidl.core
                 * @interface IVariableMap
                 * @property {Object.<string,flyteidl.core.IVariable>|null} [variables] VariableMap variables
                 */
    
                /**
                 * Constructs a new VariableMap.
                 * @memberof flyteidl.core
                 * @classdesc Represents a VariableMap.
                 * @implements IVariableMap
                 * @constructor
                 * @param {flyteidl.core.IVariableMap=} [properties] Properties to set
                 */
                function VariableMap(properties) {
                    this.variables = {};
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * VariableMap variables.
                 * @member {Object.<string,flyteidl.core.IVariable>} variables
                 * @memberof flyteidl.core.VariableMap
                 * @instance
                 */
                VariableMap.prototype.variables = $util.emptyObject;
    
                /**
                 * Creates a new VariableMap instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.VariableMap
                 * @static
                 * @param {flyteidl.core.IVariableMap=} [properties] Properties to set
                 * @returns {flyteidl.core.VariableMap} VariableMap instance
                 */
                VariableMap.create = function create(properties) {
                    return new VariableMap(properties);
                };
    
                /**
                 * Encodes the specified VariableMap message. Does not implicitly {@link flyteidl.core.VariableMap.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.VariableMap
                 * @static
                 * @param {flyteidl.core.IVariableMap} message VariableMap message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                VariableMap.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.variables != null && message.hasOwnProperty("variables"))
                        for (var keys = Object.keys(message.variables), i = 0; i < keys.length; ++i) {
                            writer.uint32(/* id 1, wireType 2 =*/10).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]);
                            $root.flyteidl.core.Variable.encode(message.variables[keys[i]], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim().ldelim();
                        }
                    return writer;
                };
    
                /**
                 * Decodes a VariableMap message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.VariableMap
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.VariableMap} VariableMap
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                VariableMap.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.VariableMap(), key;
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            reader.skip().pos++;
                            if (message.variables === $util.emptyObject)
                                message.variables = {};
                            key = reader.string();
                            reader.pos++;
                            message.variables[key] = $root.flyteidl.core.Variable.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a VariableMap message.
                 * @function verify
                 * @memberof flyteidl.core.VariableMap
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                VariableMap.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.variables != null && message.hasOwnProperty("variables")) {
                        if (!$util.isObject(message.variables))
                            return "variables: object expected";
                        var key = Object.keys(message.variables);
                        for (var i = 0; i < key.length; ++i) {
                            var error = $root.flyteidl.core.Variable.verify(message.variables[key[i]]);
                            if (error)
                                return "variables." + error;
                        }
                    }
                    return null;
                };
    
                return VariableMap;
            })();
    
            core.TypedInterface = (function() {
    
                /**
                 * Properties of a TypedInterface.
                 * @memberof flyteidl.core
                 * @interface ITypedInterface
                 * @property {flyteidl.core.IVariableMap|null} [inputs] TypedInterface inputs
                 * @property {flyteidl.core.IVariableMap|null} [outputs] TypedInterface outputs
                 */
    
                /**
                 * Constructs a new TypedInterface.
                 * @memberof flyteidl.core
                 * @classdesc Represents a TypedInterface.
                 * @implements ITypedInterface
                 * @constructor
                 * @param {flyteidl.core.ITypedInterface=} [properties] Properties to set
                 */
                function TypedInterface(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * TypedInterface inputs.
                 * @member {flyteidl.core.IVariableMap|null|undefined} inputs
                 * @memberof flyteidl.core.TypedInterface
                 * @instance
                 */
                TypedInterface.prototype.inputs = null;
    
                /**
                 * TypedInterface outputs.
                 * @member {flyteidl.core.IVariableMap|null|undefined} outputs
                 * @memberof flyteidl.core.TypedInterface
                 * @instance
                 */
                TypedInterface.prototype.outputs = null;
    
                /**
                 * Creates a new TypedInterface instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.TypedInterface
                 * @static
                 * @param {flyteidl.core.ITypedInterface=} [properties] Properties to set
                 * @returns {flyteidl.core.TypedInterface} TypedInterface instance
                 */
                TypedInterface.create = function create(properties) {
                    return new TypedInterface(properties);
                };
    
                /**
                 * Encodes the specified TypedInterface message. Does not implicitly {@link flyteidl.core.TypedInterface.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.TypedInterface
                 * @static
                 * @param {flyteidl.core.ITypedInterface} message TypedInterface message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TypedInterface.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.inputs != null && message.hasOwnProperty("inputs"))
                        $root.flyteidl.core.VariableMap.encode(message.inputs, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.outputs != null && message.hasOwnProperty("outputs"))
                        $root.flyteidl.core.VariableMap.encode(message.outputs, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a TypedInterface message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.TypedInterface
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.TypedInterface} TypedInterface
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TypedInterface.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.TypedInterface();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.inputs = $root.flyteidl.core.VariableMap.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.outputs = $root.flyteidl.core.VariableMap.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a TypedInterface message.
                 * @function verify
                 * @memberof flyteidl.core.TypedInterface
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TypedInterface.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.inputs != null && message.hasOwnProperty("inputs")) {
                        var error = $root.flyteidl.core.VariableMap.verify(message.inputs);
                        if (error)
                            return "inputs." + error;
                    }
                    if (message.outputs != null && message.hasOwnProperty("outputs")) {
                        var error = $root.flyteidl.core.VariableMap.verify(message.outputs);
                        if (error)
                            return "outputs." + error;
                    }
                    return null;
                };
    
                return TypedInterface;
            })();
    
            core.Parameter = (function() {
    
                /**
                 * Properties of a Parameter.
                 * @memberof flyteidl.core
                 * @interface IParameter
                 * @property {flyteidl.core.IVariable|null} ["var"] Parameter var
                 * @property {flyteidl.core.ILiteral|null} ["default"] Parameter default
                 * @property {boolean|null} [required] Parameter required
                 * @property {flyteidl.core.IArtifactQuery|null} [artifactQuery] Parameter artifactQuery
                 * @property {flyteidl.core.IArtifactID|null} [artifactId] Parameter artifactId
                 */
    
                /**
                 * Constructs a new Parameter.
                 * @memberof flyteidl.core
                 * @classdesc Represents a Parameter.
                 * @implements IParameter
                 * @constructor
                 * @param {flyteidl.core.IParameter=} [properties] Properties to set
                 */
                function Parameter(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Parameter var.
                 * @member {flyteidl.core.IVariable|null|undefined} var
                 * @memberof flyteidl.core.Parameter
                 * @instance
                 */
                Parameter.prototype["var"] = null;
    
                /**
                 * Parameter default.
                 * @member {flyteidl.core.ILiteral|null|undefined} default
                 * @memberof flyteidl.core.Parameter
                 * @instance
                 */
                Parameter.prototype["default"] = null;
    
                /**
                 * Parameter required.
                 * @member {boolean} required
                 * @memberof flyteidl.core.Parameter
                 * @instance
                 */
                Parameter.prototype.required = false;
    
                /**
                 * Parameter artifactQuery.
                 * @member {flyteidl.core.IArtifactQuery|null|undefined} artifactQuery
                 * @memberof flyteidl.core.Parameter
                 * @instance
                 */
                Parameter.prototype.artifactQuery = null;
    
                /**
                 * Parameter artifactId.
                 * @member {flyteidl.core.IArtifactID|null|undefined} artifactId
                 * @memberof flyteidl.core.Parameter
                 * @instance
                 */
                Parameter.prototype.artifactId = null;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * Parameter behavior.
                 * @member {"default"|"required"|"artifactQuery"|"artifactId"|undefined} behavior
                 * @memberof flyteidl.core.Parameter
                 * @instance
                 */
                Object.defineProperty(Parameter.prototype, "behavior", {
                    get: $util.oneOfGetter($oneOfFields = ["default", "required", "artifactQuery", "artifactId"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new Parameter instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Parameter
                 * @static
                 * @param {flyteidl.core.IParameter=} [properties] Properties to set
                 * @returns {flyteidl.core.Parameter} Parameter instance
                 */
                Parameter.create = function create(properties) {
                    return new Parameter(properties);
                };
    
                /**
                 * Encodes the specified Parameter message. Does not implicitly {@link flyteidl.core.Parameter.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Parameter
                 * @static
                 * @param {flyteidl.core.IParameter} message Parameter message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Parameter.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message["var"] != null && message.hasOwnProperty("var"))
                        $root.flyteidl.core.Variable.encode(message["var"], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message["default"] != null && message.hasOwnProperty("default"))
                        $root.flyteidl.core.Literal.encode(message["default"], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.required != null && message.hasOwnProperty("required"))
                        writer.uint32(/* id 3, wireType 0 =*/24).bool(message.required);
                    if (message.artifactQuery != null && message.hasOwnProperty("artifactQuery"))
                        $root.flyteidl.core.ArtifactQuery.encode(message.artifactQuery, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.artifactId != null && message.hasOwnProperty("artifactId"))
                        $root.flyteidl.core.ArtifactID.encode(message.artifactId, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a Parameter message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Parameter
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Parameter} Parameter
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Parameter.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Parameter();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message["var"] = $root.flyteidl.core.Variable.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message["default"] = $root.flyteidl.core.Literal.decode(reader, reader.uint32());
                            break;
                        case 3:
                            message.required = reader.bool();
                            break;
                        case 4:
                            message.artifactQuery = $root.flyteidl.core.ArtifactQuery.decode(reader, reader.uint32());
                            break;
                        case 5:
                            message.artifactId = $root.flyteidl.core.ArtifactID.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a Parameter message.
                 * @function verify
                 * @memberof flyteidl.core.Parameter
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Parameter.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message["var"] != null && message.hasOwnProperty("var")) {
                        var error = $root.flyteidl.core.Variable.verify(message["var"]);
                        if (error)
                            return "var." + error;
                    }
                    if (message["default"] != null && message.hasOwnProperty("default")) {
                        properties.behavior = 1;
                        {
                            var error = $root.flyteidl.core.Literal.verify(message["default"]);
                            if (error)
                                return "default." + error;
                        }
                    }
                    if (message.required != null && message.hasOwnProperty("required")) {
                        if (properties.behavior === 1)
                            return "behavior: multiple values";
                        properties.behavior = 1;
                        if (typeof message.required !== "boolean")
                            return "required: boolean expected";
                    }
                    if (message.artifactQuery != null && message.hasOwnProperty("artifactQuery")) {
                        if (properties.behavior === 1)
                            return "behavior: multiple values";
                        properties.behavior = 1;
                        {
                            var error = $root.flyteidl.core.ArtifactQuery.verify(message.artifactQuery);
                            if (error)
                                return "artifactQuery." + error;
                        }
                    }
                    if (message.artifactId != null && message.hasOwnProperty("artifactId")) {
                        if (properties.behavior === 1)
                            return "behavior: multiple values";
                        properties.behavior = 1;
                        {
                            var error = $root.flyteidl.core.ArtifactID.verify(message.artifactId);
                            if (error)
                                return "artifactId." + error;
                        }
                    }
                    return null;
                };
    
                return Parameter;
            })();
    
            core.ParameterMap = (function() {
    
                /**
                 * Properties of a ParameterMap.
                 * @memberof flyteidl.core
                 * @interface IParameterMap
                 * @property {Object.<string,flyteidl.core.IParameter>|null} [parameters] ParameterMap parameters
                 */
    
                /**
                 * Constructs a new ParameterMap.
                 * @memberof flyteidl.core
                 * @classdesc Represents a ParameterMap.
                 * @implements IParameterMap
                 * @constructor
                 * @param {flyteidl.core.IParameterMap=} [properties] Properties to set
                 */
                function ParameterMap(properties) {
                    this.parameters = {};
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * ParameterMap parameters.
                 * @member {Object.<string,flyteidl.core.IParameter>} parameters
                 * @memberof flyteidl.core.ParameterMap
                 * @instance
                 */
                ParameterMap.prototype.parameters = $util.emptyObject;
    
                /**
                 * Creates a new ParameterMap instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.ParameterMap
                 * @static
                 * @param {flyteidl.core.IParameterMap=} [properties] Properties to set
                 * @returns {flyteidl.core.ParameterMap} ParameterMap instance
                 */
                ParameterMap.create = function create(properties) {
                    return new ParameterMap(properties);
                };
    
                /**
                 * Encodes the specified ParameterMap message. Does not implicitly {@link flyteidl.core.ParameterMap.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.ParameterMap
                 * @static
                 * @param {flyteidl.core.IParameterMap} message ParameterMap message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ParameterMap.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.parameters != null && message.hasOwnProperty("parameters"))
                        for (var keys = Object.keys(message.parameters), i = 0; i < keys.length; ++i) {
                            writer.uint32(/* id 1, wireType 2 =*/10).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]);
                            $root.flyteidl.core.Parameter.encode(message.parameters[keys[i]], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim().ldelim();
                        }
                    return writer;
                };
    
                /**
                 * Decodes a ParameterMap message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.ParameterMap
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.ParameterMap} ParameterMap
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ParameterMap.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.ParameterMap(), key;
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            reader.skip().pos++;
                            if (message.parameters === $util.emptyObject)
                                message.parameters = {};
                            key = reader.string();
                            reader.pos++;
                            message.parameters[key] = $root.flyteidl.core.Parameter.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a ParameterMap message.
                 * @function verify
                 * @memberof flyteidl.core.ParameterMap
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ParameterMap.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.parameters != null && message.hasOwnProperty("parameters")) {
                        if (!$util.isObject(message.parameters))
                            return "parameters: object expected";
                        var key = Object.keys(message.parameters);
                        for (var i = 0; i < key.length; ++i) {
                            var error = $root.flyteidl.core.Parameter.verify(message.parameters[key[i]]);
                            if (error)
                                return "parameters." + error;
                        }
                    }
                    return null;
                };
    
                return ParameterMap;
            })();
    
            /**
             * SimpleType enum.
             * @name flyteidl.core.SimpleType
             * @enum {string}
             * @property {number} NONE=0 NONE value
             * @property {number} INTEGER=1 INTEGER value
             * @property {number} FLOAT=2 FLOAT value
             * @property {number} STRING=3 STRING value
             * @property {number} BOOLEAN=4 BOOLEAN value
             * @property {number} DATETIME=5 DATETIME value
             * @property {number} DURATION=6 DURATION value
             * @property {number} BINARY=7 BINARY value
             * @property {number} ERROR=8 ERROR value
             * @property {number} STRUCT=9 STRUCT value
             */
            core.SimpleType = (function() {
                var valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "NONE"] = 0;
                values[valuesById[1] = "INTEGER"] = 1;
                values[valuesById[2] = "FLOAT"] = 2;
                values[valuesById[3] = "STRING"] = 3;
                values[valuesById[4] = "BOOLEAN"] = 4;
                values[valuesById[5] = "DATETIME"] = 5;
                values[valuesById[6] = "DURATION"] = 6;
                values[valuesById[7] = "BINARY"] = 7;
                values[valuesById[8] = "ERROR"] = 8;
                values[valuesById[9] = "STRUCT"] = 9;
                return values;
            })();
    
            core.SchemaType = (function() {
    
                /**
                 * Properties of a SchemaType.
                 * @memberof flyteidl.core
                 * @interface ISchemaType
                 * @property {Array.<flyteidl.core.SchemaType.ISchemaColumn>|null} [columns] SchemaType columns
                 */
    
                /**
                 * Constructs a new SchemaType.
                 * @memberof flyteidl.core
                 * @classdesc Represents a SchemaType.
                 * @implements ISchemaType
                 * @constructor
                 * @param {flyteidl.core.ISchemaType=} [properties] Properties to set
                 */
                function SchemaType(properties) {
                    this.columns = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * SchemaType columns.
                 * @member {Array.<flyteidl.core.SchemaType.ISchemaColumn>} columns
                 * @memberof flyteidl.core.SchemaType
                 * @instance
                 */
                SchemaType.prototype.columns = $util.emptyArray;
    
                /**
                 * Creates a new SchemaType instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.SchemaType
                 * @static
                 * @param {flyteidl.core.ISchemaType=} [properties] Properties to set
                 * @returns {flyteidl.core.SchemaType} SchemaType instance
                 */
                SchemaType.create = function create(properties) {
                    return new SchemaType(properties);
                };
    
                /**
                 * Encodes the specified SchemaType message. Does not implicitly {@link flyteidl.core.SchemaType.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.SchemaType
                 * @static
                 * @param {flyteidl.core.ISchemaType} message SchemaType message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                SchemaType.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.columns != null && message.columns.length)
                        for (var i = 0; i < message.columns.length; ++i)
                            $root.flyteidl.core.SchemaType.SchemaColumn.encode(message.columns[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a SchemaType message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.SchemaType
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.SchemaType} SchemaType
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                SchemaType.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.SchemaType();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 3:
                            if (!(message.columns && message.columns.length))
                                message.columns = [];
                            message.columns.push($root.flyteidl.core.SchemaType.SchemaColumn.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a SchemaType message.
                 * @function verify
                 * @memberof flyteidl.core.SchemaType
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                SchemaType.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.columns != null && message.hasOwnProperty("columns")) {
                        if (!Array.isArray(message.columns))
                            return "columns: array expected";
                        for (var i = 0; i < message.columns.length; ++i) {
                            var error = $root.flyteidl.core.SchemaType.SchemaColumn.verify(message.columns[i]);
                            if (error)
                                return "columns." + error;
                        }
                    }
                    return null;
                };
    
                SchemaType.SchemaColumn = (function() {
    
                    /**
                     * Properties of a SchemaColumn.
                     * @memberof flyteidl.core.SchemaType
                     * @interface ISchemaColumn
                     * @property {string|null} [name] SchemaColumn name
                     * @property {flyteidl.core.SchemaType.SchemaColumn.SchemaColumnType|null} [type] SchemaColumn type
                     */
    
                    /**
                     * Constructs a new SchemaColumn.
                     * @memberof flyteidl.core.SchemaType
                     * @classdesc Represents a SchemaColumn.
                     * @implements ISchemaColumn
                     * @constructor
                     * @param {flyteidl.core.SchemaType.ISchemaColumn=} [properties] Properties to set
                     */
                    function SchemaColumn(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * SchemaColumn name.
                     * @member {string} name
                     * @memberof flyteidl.core.SchemaType.SchemaColumn
                     * @instance
                     */
                    SchemaColumn.prototype.name = "";
    
                    /**
                     * SchemaColumn type.
                     * @member {flyteidl.core.SchemaType.SchemaColumn.SchemaColumnType} type
                     * @memberof flyteidl.core.SchemaType.SchemaColumn
                     * @instance
                     */
                    SchemaColumn.prototype.type = 0;
    
                    /**
                     * Creates a new SchemaColumn instance using the specified properties.
                     * @function create
                     * @memberof flyteidl.core.SchemaType.SchemaColumn
                     * @static
                     * @param {flyteidl.core.SchemaType.ISchemaColumn=} [properties] Properties to set
                     * @returns {flyteidl.core.SchemaType.SchemaColumn} SchemaColumn instance
                     */
                    SchemaColumn.create = function create(properties) {
                        return new SchemaColumn(properties);
                    };
    
                    /**
                     * Encodes the specified SchemaColumn message. Does not implicitly {@link flyteidl.core.SchemaType.SchemaColumn.verify|verify} messages.
                     * @function encode
                     * @memberof flyteidl.core.SchemaType.SchemaColumn
                     * @static
                     * @param {flyteidl.core.SchemaType.ISchemaColumn} message SchemaColumn message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    SchemaColumn.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.name != null && message.hasOwnProperty("name"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                        if (message.type != null && message.hasOwnProperty("type"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.type);
                        return writer;
                    };
    
                    /**
                     * Decodes a SchemaColumn message from the specified reader or buffer.
                     * @function decode
                     * @memberof flyteidl.core.SchemaType.SchemaColumn
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {flyteidl.core.SchemaType.SchemaColumn} SchemaColumn
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    SchemaColumn.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.SchemaType.SchemaColumn();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.name = reader.string();
                                break;
                            case 2:
                                message.type = reader.int32();
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Verifies a SchemaColumn message.
                     * @function verify
                     * @memberof flyteidl.core.SchemaType.SchemaColumn
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    SchemaColumn.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.name != null && message.hasOwnProperty("name"))
                            if (!$util.isString(message.name))
                                return "name: string expected";
                        if (message.type != null && message.hasOwnProperty("type"))
                            switch (message.type) {
                            default:
                                return "type: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                            case 3:
                            case 4:
                            case 5:
                                break;
                            }
                        return null;
                    };
    
                    /**
                     * SchemaColumnType enum.
                     * @name flyteidl.core.SchemaType.SchemaColumn.SchemaColumnType
                     * @enum {string}
                     * @property {number} INTEGER=0 INTEGER value
                     * @property {number} FLOAT=1 FLOAT value
                     * @property {number} STRING=2 STRING value
                     * @property {number} BOOLEAN=3 BOOLEAN value
                     * @property {number} DATETIME=4 DATETIME value
                     * @property {number} DURATION=5 DURATION value
                     */
                    SchemaColumn.SchemaColumnType = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "INTEGER"] = 0;
                        values[valuesById[1] = "FLOAT"] = 1;
                        values[valuesById[2] = "STRING"] = 2;
                        values[valuesById[3] = "BOOLEAN"] = 3;
                        values[valuesById[4] = "DATETIME"] = 4;
                        values[valuesById[5] = "DURATION"] = 5;
                        return values;
                    })();
    
                    return SchemaColumn;
                })();
    
                return SchemaType;
            })();
    
            core.StructuredDatasetType = (function() {
    
                /**
                 * Properties of a StructuredDatasetType.
                 * @memberof flyteidl.core
                 * @interface IStructuredDatasetType
                 * @property {Array.<flyteidl.core.StructuredDatasetType.IDatasetColumn>|null} [columns] StructuredDatasetType columns
                 * @property {string|null} [format] StructuredDatasetType format
                 * @property {string|null} [externalSchemaType] StructuredDatasetType externalSchemaType
                 * @property {Uint8Array|null} [externalSchemaBytes] StructuredDatasetType externalSchemaBytes
                 */
    
                /**
                 * Constructs a new StructuredDatasetType.
                 * @memberof flyteidl.core
                 * @classdesc Represents a StructuredDatasetType.
                 * @implements IStructuredDatasetType
                 * @constructor
                 * @param {flyteidl.core.IStructuredDatasetType=} [properties] Properties to set
                 */
                function StructuredDatasetType(properties) {
                    this.columns = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * StructuredDatasetType columns.
                 * @member {Array.<flyteidl.core.StructuredDatasetType.IDatasetColumn>} columns
                 * @memberof flyteidl.core.StructuredDatasetType
                 * @instance
                 */
                StructuredDatasetType.prototype.columns = $util.emptyArray;
    
                /**
                 * StructuredDatasetType format.
                 * @member {string} format
                 * @memberof flyteidl.core.StructuredDatasetType
                 * @instance
                 */
                StructuredDatasetType.prototype.format = "";
    
                /**
                 * StructuredDatasetType externalSchemaType.
                 * @member {string} externalSchemaType
                 * @memberof flyteidl.core.StructuredDatasetType
                 * @instance
                 */
                StructuredDatasetType.prototype.externalSchemaType = "";
    
                /**
                 * StructuredDatasetType externalSchemaBytes.
                 * @member {Uint8Array} externalSchemaBytes
                 * @memberof flyteidl.core.StructuredDatasetType
                 * @instance
                 */
                StructuredDatasetType.prototype.externalSchemaBytes = $util.newBuffer([]);
    
                /**
                 * Creates a new StructuredDatasetType instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.StructuredDatasetType
                 * @static
                 * @param {flyteidl.core.IStructuredDatasetType=} [properties] Properties to set
                 * @returns {flyteidl.core.StructuredDatasetType} StructuredDatasetType instance
                 */
                StructuredDatasetType.create = function create(properties) {
                    return new StructuredDatasetType(properties);
                };
    
                /**
                 * Encodes the specified StructuredDatasetType message. Does not implicitly {@link flyteidl.core.StructuredDatasetType.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.StructuredDatasetType
                 * @static
                 * @param {flyteidl.core.IStructuredDatasetType} message StructuredDatasetType message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                StructuredDatasetType.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.columns != null && message.columns.length)
                        for (var i = 0; i < message.columns.length; ++i)
                            $root.flyteidl.core.StructuredDatasetType.DatasetColumn.encode(message.columns[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.format != null && message.hasOwnProperty("format"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.format);
                    if (message.externalSchemaType != null && message.hasOwnProperty("externalSchemaType"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.externalSchemaType);
                    if (message.externalSchemaBytes != null && message.hasOwnProperty("externalSchemaBytes"))
                        writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.externalSchemaBytes);
                    return writer;
                };
    
                /**
                 * Decodes a StructuredDatasetType message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.StructuredDatasetType
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.StructuredDatasetType} StructuredDatasetType
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                StructuredDatasetType.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.StructuredDatasetType();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            if (!(message.columns && message.columns.length))
                                message.columns = [];
                            message.columns.push($root.flyteidl.core.StructuredDatasetType.DatasetColumn.decode(reader, reader.uint32()));
                            break;
                        case 2:
                            message.format = reader.string();
                            break;
                        case 3:
                            message.externalSchemaType = reader.string();
                            break;
                        case 4:
                            message.externalSchemaBytes = reader.bytes();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a StructuredDatasetType message.
                 * @function verify
                 * @memberof flyteidl.core.StructuredDatasetType
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                StructuredDatasetType.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.columns != null && message.hasOwnProperty("columns")) {
                        if (!Array.isArray(message.columns))
                            return "columns: array expected";
                        for (var i = 0; i < message.columns.length; ++i) {
                            var error = $root.flyteidl.core.StructuredDatasetType.DatasetColumn.verify(message.columns[i]);
                            if (error)
                                return "columns." + error;
                        }
                    }
                    if (message.format != null && message.hasOwnProperty("format"))
                        if (!$util.isString(message.format))
                            return "format: string expected";
                    if (message.externalSchemaType != null && message.hasOwnProperty("externalSchemaType"))
                        if (!$util.isString(message.externalSchemaType))
                            return "externalSchemaType: string expected";
                    if (message.externalSchemaBytes != null && message.hasOwnProperty("externalSchemaBytes"))
                        if (!(message.externalSchemaBytes && typeof message.externalSchemaBytes.length === "number" || $util.isString(message.externalSchemaBytes)))
                            return "externalSchemaBytes: buffer expected";
                    return null;
                };
    
                StructuredDatasetType.DatasetColumn = (function() {
    
                    /**
                     * Properties of a DatasetColumn.
                     * @memberof flyteidl.core.StructuredDatasetType
                     * @interface IDatasetColumn
                     * @property {string|null} [name] DatasetColumn name
                     * @property {flyteidl.core.ILiteralType|null} [literalType] DatasetColumn literalType
                     */
    
                    /**
                     * Constructs a new DatasetColumn.
                     * @memberof flyteidl.core.StructuredDatasetType
                     * @classdesc Represents a DatasetColumn.
                     * @implements IDatasetColumn
                     * @constructor
                     * @param {flyteidl.core.StructuredDatasetType.IDatasetColumn=} [properties] Properties to set
                     */
                    function DatasetColumn(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * DatasetColumn name.
                     * @member {string} name
                     * @memberof flyteidl.core.StructuredDatasetType.DatasetColumn
                     * @instance
                     */
                    DatasetColumn.prototype.name = "";
    
                    /**
                     * DatasetColumn literalType.
                     * @member {flyteidl.core.ILiteralType|null|undefined} literalType
                     * @memberof flyteidl.core.StructuredDatasetType.DatasetColumn
                     * @instance
                     */
                    DatasetColumn.prototype.literalType = null;
    
                    /**
                     * Creates a new DatasetColumn instance using the specified properties.
                     * @function create
                     * @memberof flyteidl.core.StructuredDatasetType.DatasetColumn
                     * @static
                     * @param {flyteidl.core.StructuredDatasetType.IDatasetColumn=} [properties] Properties to set
                     * @returns {flyteidl.core.StructuredDatasetType.DatasetColumn} DatasetColumn instance
                     */
                    DatasetColumn.create = function create(properties) {
                        return new DatasetColumn(properties);
                    };
    
                    /**
                     * Encodes the specified DatasetColumn message. Does not implicitly {@link flyteidl.core.StructuredDatasetType.DatasetColumn.verify|verify} messages.
                     * @function encode
                     * @memberof flyteidl.core.StructuredDatasetType.DatasetColumn
                     * @static
                     * @param {flyteidl.core.StructuredDatasetType.IDatasetColumn} message DatasetColumn message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    DatasetColumn.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.name != null && message.hasOwnProperty("name"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                        if (message.literalType != null && message.hasOwnProperty("literalType"))
                            $root.flyteidl.core.LiteralType.encode(message.literalType, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Decodes a DatasetColumn message from the specified reader or buffer.
                     * @function decode
                     * @memberof flyteidl.core.StructuredDatasetType.DatasetColumn
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {flyteidl.core.StructuredDatasetType.DatasetColumn} DatasetColumn
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    DatasetColumn.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.StructuredDatasetType.DatasetColumn();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.name = reader.string();
                                break;
                            case 2:
                                message.literalType = $root.flyteidl.core.LiteralType.decode(reader, reader.uint32());
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Verifies a DatasetColumn message.
                     * @function verify
                     * @memberof flyteidl.core.StructuredDatasetType.DatasetColumn
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    DatasetColumn.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.name != null && message.hasOwnProperty("name"))
                            if (!$util.isString(message.name))
                                return "name: string expected";
                        if (message.literalType != null && message.hasOwnProperty("literalType")) {
                            var error = $root.flyteidl.core.LiteralType.verify(message.literalType);
                            if (error)
                                return "literalType." + error;
                        }
                        return null;
                    };
    
                    return DatasetColumn;
                })();
    
                return StructuredDatasetType;
            })();
    
            core.BlobType = (function() {
    
                /**
                 * Properties of a BlobType.
                 * @memberof flyteidl.core
                 * @interface IBlobType
                 * @property {string|null} [format] BlobType format
                 * @property {flyteidl.core.BlobType.BlobDimensionality|null} [dimensionality] BlobType dimensionality
                 */
    
                /**
                 * Constructs a new BlobType.
                 * @memberof flyteidl.core
                 * @classdesc Represents a BlobType.
                 * @implements IBlobType
                 * @constructor
                 * @param {flyteidl.core.IBlobType=} [properties] Properties to set
                 */
                function BlobType(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * BlobType format.
                 * @member {string} format
                 * @memberof flyteidl.core.BlobType
                 * @instance
                 */
                BlobType.prototype.format = "";
    
                /**
                 * BlobType dimensionality.
                 * @member {flyteidl.core.BlobType.BlobDimensionality} dimensionality
                 * @memberof flyteidl.core.BlobType
                 * @instance
                 */
                BlobType.prototype.dimensionality = 0;
    
                /**
                 * Creates a new BlobType instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.BlobType
                 * @static
                 * @param {flyteidl.core.IBlobType=} [properties] Properties to set
                 * @returns {flyteidl.core.BlobType} BlobType instance
                 */
                BlobType.create = function create(properties) {
                    return new BlobType(properties);
                };
    
                /**
                 * Encodes the specified BlobType message. Does not implicitly {@link flyteidl.core.BlobType.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.BlobType
                 * @static
                 * @param {flyteidl.core.IBlobType} message BlobType message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                BlobType.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.format != null && message.hasOwnProperty("format"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.format);
                    if (message.dimensionality != null && message.hasOwnProperty("dimensionality"))
                        writer.uint32(/* id 2, wireType 0 =*/16).int32(message.dimensionality);
                    return writer;
                };
    
                /**
                 * Decodes a BlobType message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.BlobType
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.BlobType} BlobType
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                BlobType.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.BlobType();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.format = reader.string();
                            break;
                        case 2:
                            message.dimensionality = reader.int32();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a BlobType message.
                 * @function verify
                 * @memberof flyteidl.core.BlobType
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                BlobType.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.format != null && message.hasOwnProperty("format"))
                        if (!$util.isString(message.format))
                            return "format: string expected";
                    if (message.dimensionality != null && message.hasOwnProperty("dimensionality"))
                        switch (message.dimensionality) {
                        default:
                            return "dimensionality: enum value expected";
                        case 0:
                        case 1:
                            break;
                        }
                    return null;
                };
    
                /**
                 * BlobDimensionality enum.
                 * @name flyteidl.core.BlobType.BlobDimensionality
                 * @enum {string}
                 * @property {number} SINGLE=0 SINGLE value
                 * @property {number} MULTIPART=1 MULTIPART value
                 */
                BlobType.BlobDimensionality = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "SINGLE"] = 0;
                    values[valuesById[1] = "MULTIPART"] = 1;
                    return values;
                })();
    
                return BlobType;
            })();
    
            core.EnumType = (function() {
    
                /**
                 * Properties of an EnumType.
                 * @memberof flyteidl.core
                 * @interface IEnumType
                 * @property {Array.<string>|null} [values] EnumType values
                 */
    
                /**
                 * Constructs a new EnumType.
                 * @memberof flyteidl.core
                 * @classdesc Represents an EnumType.
                 * @implements IEnumType
                 * @constructor
                 * @param {flyteidl.core.IEnumType=} [properties] Properties to set
                 */
                function EnumType(properties) {
                    this.values = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * EnumType values.
                 * @member {Array.<string>} values
                 * @memberof flyteidl.core.EnumType
                 * @instance
                 */
                EnumType.prototype.values = $util.emptyArray;
    
                /**
                 * Creates a new EnumType instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.EnumType
                 * @static
                 * @param {flyteidl.core.IEnumType=} [properties] Properties to set
                 * @returns {flyteidl.core.EnumType} EnumType instance
                 */
                EnumType.create = function create(properties) {
                    return new EnumType(properties);
                };
    
                /**
                 * Encodes the specified EnumType message. Does not implicitly {@link flyteidl.core.EnumType.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.EnumType
                 * @static
                 * @param {flyteidl.core.IEnumType} message EnumType message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                EnumType.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.values != null && message.values.length)
                        for (var i = 0; i < message.values.length; ++i)
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.values[i]);
                    return writer;
                };
    
                /**
                 * Decodes an EnumType message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.EnumType
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.EnumType} EnumType
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                EnumType.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.EnumType();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            if (!(message.values && message.values.length))
                                message.values = [];
                            message.values.push(reader.string());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an EnumType message.
                 * @function verify
                 * @memberof flyteidl.core.EnumType
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                EnumType.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.values != null && message.hasOwnProperty("values")) {
                        if (!Array.isArray(message.values))
                            return "values: array expected";
                        for (var i = 0; i < message.values.length; ++i)
                            if (!$util.isString(message.values[i]))
                                return "values: string[] expected";
                    }
                    return null;
                };
    
                return EnumType;
            })();
    
            core.UnionType = (function() {
    
                /**
                 * Properties of an UnionType.
                 * @memberof flyteidl.core
                 * @interface IUnionType
                 * @property {Array.<flyteidl.core.ILiteralType>|null} [variants] UnionType variants
                 */
    
                /**
                 * Constructs a new UnionType.
                 * @memberof flyteidl.core
                 * @classdesc Represents an UnionType.
                 * @implements IUnionType
                 * @constructor
                 * @param {flyteidl.core.IUnionType=} [properties] Properties to set
                 */
                function UnionType(properties) {
                    this.variants = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * UnionType variants.
                 * @member {Array.<flyteidl.core.ILiteralType>} variants
                 * @memberof flyteidl.core.UnionType
                 * @instance
                 */
                UnionType.prototype.variants = $util.emptyArray;
    
                /**
                 * Creates a new UnionType instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.UnionType
                 * @static
                 * @param {flyteidl.core.IUnionType=} [properties] Properties to set
                 * @returns {flyteidl.core.UnionType} UnionType instance
                 */
                UnionType.create = function create(properties) {
                    return new UnionType(properties);
                };
    
                /**
                 * Encodes the specified UnionType message. Does not implicitly {@link flyteidl.core.UnionType.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.UnionType
                 * @static
                 * @param {flyteidl.core.IUnionType} message UnionType message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                UnionType.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.variants != null && message.variants.length)
                        for (var i = 0; i < message.variants.length; ++i)
                            $root.flyteidl.core.LiteralType.encode(message.variants[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes an UnionType message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.UnionType
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.UnionType} UnionType
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                UnionType.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.UnionType();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            if (!(message.variants && message.variants.length))
                                message.variants = [];
                            message.variants.push($root.flyteidl.core.LiteralType.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an UnionType message.
                 * @function verify
                 * @memberof flyteidl.core.UnionType
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                UnionType.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.variants != null && message.hasOwnProperty("variants")) {
                        if (!Array.isArray(message.variants))
                            return "variants: array expected";
                        for (var i = 0; i < message.variants.length; ++i) {
                            var error = $root.flyteidl.core.LiteralType.verify(message.variants[i]);
                            if (error)
                                return "variants." + error;
                        }
                    }
                    return null;
                };
    
                return UnionType;
            })();
    
            core.TypeStructure = (function() {
    
                /**
                 * Properties of a TypeStructure.
                 * @memberof flyteidl.core
                 * @interface ITypeStructure
                 * @property {string|null} [tag] TypeStructure tag
                 * @property {Object.<string,flyteidl.core.ILiteralType>|null} [dataclassType] TypeStructure dataclassType
                 */
    
                /**
                 * Constructs a new TypeStructure.
                 * @memberof flyteidl.core
                 * @classdesc Represents a TypeStructure.
                 * @implements ITypeStructure
                 * @constructor
                 * @param {flyteidl.core.ITypeStructure=} [properties] Properties to set
                 */
                function TypeStructure(properties) {
                    this.dataclassType = {};
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * TypeStructure tag.
                 * @member {string} tag
                 * @memberof flyteidl.core.TypeStructure
                 * @instance
                 */
                TypeStructure.prototype.tag = "";
    
                /**
                 * TypeStructure dataclassType.
                 * @member {Object.<string,flyteidl.core.ILiteralType>} dataclassType
                 * @memberof flyteidl.core.TypeStructure
                 * @instance
                 */
                TypeStructure.prototype.dataclassType = $util.emptyObject;
    
                /**
                 * Creates a new TypeStructure instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.TypeStructure
                 * @static
                 * @param {flyteidl.core.ITypeStructure=} [properties] Properties to set
                 * @returns {flyteidl.core.TypeStructure} TypeStructure instance
                 */
                TypeStructure.create = function create(properties) {
                    return new TypeStructure(properties);
                };
    
                /**
                 * Encodes the specified TypeStructure message. Does not implicitly {@link flyteidl.core.TypeStructure.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.TypeStructure
                 * @static
                 * @param {flyteidl.core.ITypeStructure} message TypeStructure message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TypeStructure.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.tag != null && message.hasOwnProperty("tag"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.tag);
                    if (message.dataclassType != null && message.hasOwnProperty("dataclassType"))
                        for (var keys = Object.keys(message.dataclassType), i = 0; i < keys.length; ++i) {
                            writer.uint32(/* id 2, wireType 2 =*/18).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]);
                            $root.flyteidl.core.LiteralType.encode(message.dataclassType[keys[i]], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim().ldelim();
                        }
                    return writer;
                };
    
                /**
                 * Decodes a TypeStructure message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.TypeStructure
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.TypeStructure} TypeStructure
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TypeStructure.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.TypeStructure(), key;
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.tag = reader.string();
                            break;
                        case 2:
                            reader.skip().pos++;
                            if (message.dataclassType === $util.emptyObject)
                                message.dataclassType = {};
                            key = reader.string();
                            reader.pos++;
                            message.dataclassType[key] = $root.flyteidl.core.LiteralType.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a TypeStructure message.
                 * @function verify
                 * @memberof flyteidl.core.TypeStructure
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TypeStructure.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.tag != null && message.hasOwnProperty("tag"))
                        if (!$util.isString(message.tag))
                            return "tag: string expected";
                    if (message.dataclassType != null && message.hasOwnProperty("dataclassType")) {
                        if (!$util.isObject(message.dataclassType))
                            return "dataclassType: object expected";
                        var key = Object.keys(message.dataclassType);
                        for (var i = 0; i < key.length; ++i) {
                            var error = $root.flyteidl.core.LiteralType.verify(message.dataclassType[key[i]]);
                            if (error)
                                return "dataclassType." + error;
                        }
                    }
                    return null;
                };
    
                return TypeStructure;
            })();
    
            core.TypeAnnotation = (function() {
    
                /**
                 * Properties of a TypeAnnotation.
                 * @memberof flyteidl.core
                 * @interface ITypeAnnotation
                 * @property {google.protobuf.IStruct|null} [annotations] TypeAnnotation annotations
                 */
    
                /**
                 * Constructs a new TypeAnnotation.
                 * @memberof flyteidl.core
                 * @classdesc Represents a TypeAnnotation.
                 * @implements ITypeAnnotation
                 * @constructor
                 * @param {flyteidl.core.ITypeAnnotation=} [properties] Properties to set
                 */
                function TypeAnnotation(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * TypeAnnotation annotations.
                 * @member {google.protobuf.IStruct|null|undefined} annotations
                 * @memberof flyteidl.core.TypeAnnotation
                 * @instance
                 */
                TypeAnnotation.prototype.annotations = null;
    
                /**
                 * Creates a new TypeAnnotation instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.TypeAnnotation
                 * @static
                 * @param {flyteidl.core.ITypeAnnotation=} [properties] Properties to set
                 * @returns {flyteidl.core.TypeAnnotation} TypeAnnotation instance
                 */
                TypeAnnotation.create = function create(properties) {
                    return new TypeAnnotation(properties);
                };
    
                /**
                 * Encodes the specified TypeAnnotation message. Does not implicitly {@link flyteidl.core.TypeAnnotation.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.TypeAnnotation
                 * @static
                 * @param {flyteidl.core.ITypeAnnotation} message TypeAnnotation message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TypeAnnotation.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.annotations != null && message.hasOwnProperty("annotations"))
                        $root.google.protobuf.Struct.encode(message.annotations, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a TypeAnnotation message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.TypeAnnotation
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.TypeAnnotation} TypeAnnotation
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TypeAnnotation.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.TypeAnnotation();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.annotations = $root.google.protobuf.Struct.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a TypeAnnotation message.
                 * @function verify
                 * @memberof flyteidl.core.TypeAnnotation
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TypeAnnotation.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.annotations != null && message.hasOwnProperty("annotations")) {
                        var error = $root.google.protobuf.Struct.verify(message.annotations);
                        if (error)
                            return "annotations." + error;
                    }
                    return null;
                };
    
                return TypeAnnotation;
            })();
    
            core.LiteralType = (function() {
    
                /**
                 * Properties of a LiteralType.
                 * @memberof flyteidl.core
                 * @interface ILiteralType
                 * @property {flyteidl.core.SimpleType|null} [simple] LiteralType simple
                 * @property {flyteidl.core.ISchemaType|null} [schema] LiteralType schema
                 * @property {flyteidl.core.ILiteralType|null} [collectionType] LiteralType collectionType
                 * @property {flyteidl.core.ILiteralType|null} [mapValueType] LiteralType mapValueType
                 * @property {flyteidl.core.IBlobType|null} [blob] LiteralType blob
                 * @property {flyteidl.core.IEnumType|null} [enumType] LiteralType enumType
                 * @property {flyteidl.core.IStructuredDatasetType|null} [structuredDatasetType] LiteralType structuredDatasetType
                 * @property {flyteidl.core.IUnionType|null} [unionType] LiteralType unionType
                 * @property {google.protobuf.IStruct|null} [metadata] LiteralType metadata
                 * @property {flyteidl.core.ITypeAnnotation|null} [annotation] LiteralType annotation
                 * @property {flyteidl.core.ITypeStructure|null} [structure] LiteralType structure
                 */
    
                /**
                 * Constructs a new LiteralType.
                 * @memberof flyteidl.core
                 * @classdesc Represents a LiteralType.
                 * @implements ILiteralType
                 * @constructor
                 * @param {flyteidl.core.ILiteralType=} [properties] Properties to set
                 */
                function LiteralType(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * LiteralType simple.
                 * @member {flyteidl.core.SimpleType} simple
                 * @memberof flyteidl.core.LiteralType
                 * @instance
                 */
                LiteralType.prototype.simple = 0;
    
                /**
                 * LiteralType schema.
                 * @member {flyteidl.core.ISchemaType|null|undefined} schema
                 * @memberof flyteidl.core.LiteralType
                 * @instance
                 */
                LiteralType.prototype.schema = null;
    
                /**
                 * LiteralType collectionType.
                 * @member {flyteidl.core.ILiteralType|null|undefined} collectionType
                 * @memberof flyteidl.core.LiteralType
                 * @instance
                 */
                LiteralType.prototype.collectionType = null;
    
                /**
                 * LiteralType mapValueType.
                 * @member {flyteidl.core.ILiteralType|null|undefined} mapValueType
                 * @memberof flyteidl.core.LiteralType
                 * @instance
                 */
                LiteralType.prototype.mapValueType = null;
    
                /**
                 * LiteralType blob.
                 * @member {flyteidl.core.IBlobType|null|undefined} blob
                 * @memberof flyteidl.core.LiteralType
                 * @instance
                 */
                LiteralType.prototype.blob = null;
    
                /**
                 * LiteralType enumType.
                 * @member {flyteidl.core.IEnumType|null|undefined} enumType
                 * @memberof flyteidl.core.LiteralType
                 * @instance
                 */
                LiteralType.prototype.enumType = null;
    
                /**
                 * LiteralType structuredDatasetType.
                 * @member {flyteidl.core.IStructuredDatasetType|null|undefined} structuredDatasetType
                 * @memberof flyteidl.core.LiteralType
                 * @instance
                 */
                LiteralType.prototype.structuredDatasetType = null;
    
                /**
                 * LiteralType unionType.
                 * @member {flyteidl.core.IUnionType|null|undefined} unionType
                 * @memberof flyteidl.core.LiteralType
                 * @instance
                 */
                LiteralType.prototype.unionType = null;
    
                /**
                 * LiteralType metadata.
                 * @member {google.protobuf.IStruct|null|undefined} metadata
                 * @memberof flyteidl.core.LiteralType
                 * @instance
                 */
                LiteralType.prototype.metadata = null;
    
                /**
                 * LiteralType annotation.
                 * @member {flyteidl.core.ITypeAnnotation|null|undefined} annotation
                 * @memberof flyteidl.core.LiteralType
                 * @instance
                 */
                LiteralType.prototype.annotation = null;
    
                /**
                 * LiteralType structure.
                 * @member {flyteidl.core.ITypeStructure|null|undefined} structure
                 * @memberof flyteidl.core.LiteralType
                 * @instance
                 */
                LiteralType.prototype.structure = null;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * LiteralType type.
                 * @member {"simple"|"schema"|"collectionType"|"mapValueType"|"blob"|"enumType"|"structuredDatasetType"|"unionType"|undefined} type
                 * @memberof flyteidl.core.LiteralType
                 * @instance
                 */
                Object.defineProperty(LiteralType.prototype, "type", {
                    get: $util.oneOfGetter($oneOfFields = ["simple", "schema", "collectionType", "mapValueType", "blob", "enumType", "structuredDatasetType", "unionType"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new LiteralType instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.LiteralType
                 * @static
                 * @param {flyteidl.core.ILiteralType=} [properties] Properties to set
                 * @returns {flyteidl.core.LiteralType} LiteralType instance
                 */
                LiteralType.create = function create(properties) {
                    return new LiteralType(properties);
                };
    
                /**
                 * Encodes the specified LiteralType message. Does not implicitly {@link flyteidl.core.LiteralType.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.LiteralType
                 * @static
                 * @param {flyteidl.core.ILiteralType} message LiteralType message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                LiteralType.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.simple != null && message.hasOwnProperty("simple"))
                        writer.uint32(/* id 1, wireType 0 =*/8).int32(message.simple);
                    if (message.schema != null && message.hasOwnProperty("schema"))
                        $root.flyteidl.core.SchemaType.encode(message.schema, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.collectionType != null && message.hasOwnProperty("collectionType"))
                        $root.flyteidl.core.LiteralType.encode(message.collectionType, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message.mapValueType != null && message.hasOwnProperty("mapValueType"))
                        $root.flyteidl.core.LiteralType.encode(message.mapValueType, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.blob != null && message.hasOwnProperty("blob"))
                        $root.flyteidl.core.BlobType.encode(message.blob, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                    if (message.metadata != null && message.hasOwnProperty("metadata"))
                        $root.google.protobuf.Struct.encode(message.metadata, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                    if (message.enumType != null && message.hasOwnProperty("enumType"))
                        $root.flyteidl.core.EnumType.encode(message.enumType, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                    if (message.structuredDatasetType != null && message.hasOwnProperty("structuredDatasetType"))
                        $root.flyteidl.core.StructuredDatasetType.encode(message.structuredDatasetType, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                    if (message.annotation != null && message.hasOwnProperty("annotation"))
                        $root.flyteidl.core.TypeAnnotation.encode(message.annotation, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                    if (message.unionType != null && message.hasOwnProperty("unionType"))
                        $root.flyteidl.core.UnionType.encode(message.unionType, writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
                    if (message.structure != null && message.hasOwnProperty("structure"))
                        $root.flyteidl.core.TypeStructure.encode(message.structure, writer.uint32(/* id 11, wireType 2 =*/90).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a LiteralType message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.LiteralType
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.LiteralType} LiteralType
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                LiteralType.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.LiteralType();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.simple = reader.int32();
                            break;
                        case 2:
                            message.schema = $root.flyteidl.core.SchemaType.decode(reader, reader.uint32());
                            break;
                        case 3:
                            message.collectionType = $root.flyteidl.core.LiteralType.decode(reader, reader.uint32());
                            break;
                        case 4:
                            message.mapValueType = $root.flyteidl.core.LiteralType.decode(reader, reader.uint32());
                            break;
                        case 5:
                            message.blob = $root.flyteidl.core.BlobType.decode(reader, reader.uint32());
                            break;
                        case 7:
                            message.enumType = $root.flyteidl.core.EnumType.decode(reader, reader.uint32());
                            break;
                        case 8:
                            message.structuredDatasetType = $root.flyteidl.core.StructuredDatasetType.decode(reader, reader.uint32());
                            break;
                        case 10:
                            message.unionType = $root.flyteidl.core.UnionType.decode(reader, reader.uint32());
                            break;
                        case 6:
                            message.metadata = $root.google.protobuf.Struct.decode(reader, reader.uint32());
                            break;
                        case 9:
                            message.annotation = $root.flyteidl.core.TypeAnnotation.decode(reader, reader.uint32());
                            break;
                        case 11:
                            message.structure = $root.flyteidl.core.TypeStructure.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a LiteralType message.
                 * @function verify
                 * @memberof flyteidl.core.LiteralType
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                LiteralType.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.simple != null && message.hasOwnProperty("simple")) {
                        properties.type = 1;
                        switch (message.simple) {
                        default:
                            return "simple: enum value expected";
                        case 0:
                        case 1:
                        case 2:
                        case 3:
                        case 4:
                        case 5:
                        case 6:
                        case 7:
                        case 8:
                        case 9:
                            break;
                        }
                    }
                    if (message.schema != null && message.hasOwnProperty("schema")) {
                        if (properties.type === 1)
                            return "type: multiple values";
                        properties.type = 1;
                        {
                            var error = $root.flyteidl.core.SchemaType.verify(message.schema);
                            if (error)
                                return "schema." + error;
                        }
                    }
                    if (message.collectionType != null && message.hasOwnProperty("collectionType")) {
                        if (properties.type === 1)
                            return "type: multiple values";
                        properties.type = 1;
                        {
                            var error = $root.flyteidl.core.LiteralType.verify(message.collectionType);
                            if (error)
                                return "collectionType." + error;
                        }
                    }
                    if (message.mapValueType != null && message.hasOwnProperty("mapValueType")) {
                        if (properties.type === 1)
                            return "type: multiple values";
                        properties.type = 1;
                        {
                            var error = $root.flyteidl.core.LiteralType.verify(message.mapValueType);
                            if (error)
                                return "mapValueType." + error;
                        }
                    }
                    if (message.blob != null && message.hasOwnProperty("blob")) {
                        if (properties.type === 1)
                            return "type: multiple values";
                        properties.type = 1;
                        {
                            var error = $root.flyteidl.core.BlobType.verify(message.blob);
                            if (error)
                                return "blob." + error;
                        }
                    }
                    if (message.enumType != null && message.hasOwnProperty("enumType")) {
                        if (properties.type === 1)
                            return "type: multiple values";
                        properties.type = 1;
                        {
                            var error = $root.flyteidl.core.EnumType.verify(message.enumType);
                            if (error)
                                return "enumType." + error;
                        }
                    }
                    if (message.structuredDatasetType != null && message.hasOwnProperty("structuredDatasetType")) {
                        if (properties.type === 1)
                            return "type: multiple values";
                        properties.type = 1;
                        {
                            var error = $root.flyteidl.core.StructuredDatasetType.verify(message.structuredDatasetType);
                            if (error)
                                return "structuredDatasetType." + error;
                        }
                    }
                    if (message.unionType != null && message.hasOwnProperty("unionType")) {
                        if (properties.type === 1)
                            return "type: multiple values";
                        properties.type = 1;
                        {
                            var error = $root.flyteidl.core.UnionType.verify(message.unionType);
                            if (error)
                                return "unionType." + error;
                        }
                    }
                    if (message.metadata != null && message.hasOwnProperty("metadata")) {
                        var error = $root.google.protobuf.Struct.verify(message.metadata);
                        if (error)
                            return "metadata." + error;
                    }
                    if (message.annotation != null && message.hasOwnProperty("annotation")) {
                        var error = $root.flyteidl.core.TypeAnnotation.verify(message.annotation);
                        if (error)
                            return "annotation." + error;
                    }
                    if (message.structure != null && message.hasOwnProperty("structure")) {
                        var error = $root.flyteidl.core.TypeStructure.verify(message.structure);
                        if (error)
                            return "structure." + error;
                    }
                    return null;
                };
    
                return LiteralType;
            })();
    
            core.OutputReference = (function() {
    
                /**
                 * Properties of an OutputReference.
                 * @memberof flyteidl.core
                 * @interface IOutputReference
                 * @property {string|null} [nodeId] OutputReference nodeId
                 * @property {string|null} ["var"] OutputReference var
                 * @property {Array.<flyteidl.core.IPromiseAttribute>|null} [attrPath] OutputReference attrPath
                 */
    
                /**
                 * Constructs a new OutputReference.
                 * @memberof flyteidl.core
                 * @classdesc Represents an OutputReference.
                 * @implements IOutputReference
                 * @constructor
                 * @param {flyteidl.core.IOutputReference=} [properties] Properties to set
                 */
                function OutputReference(properties) {
                    this.attrPath = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * OutputReference nodeId.
                 * @member {string} nodeId
                 * @memberof flyteidl.core.OutputReference
                 * @instance
                 */
                OutputReference.prototype.nodeId = "";
    
                /**
                 * OutputReference var.
                 * @member {string} var
                 * @memberof flyteidl.core.OutputReference
                 * @instance
                 */
                OutputReference.prototype["var"] = "";
    
                /**
                 * OutputReference attrPath.
                 * @member {Array.<flyteidl.core.IPromiseAttribute>} attrPath
                 * @memberof flyteidl.core.OutputReference
                 * @instance
                 */
                OutputReference.prototype.attrPath = $util.emptyArray;
    
                /**
                 * Creates a new OutputReference instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.OutputReference
                 * @static
                 * @param {flyteidl.core.IOutputReference=} [properties] Properties to set
                 * @returns {flyteidl.core.OutputReference} OutputReference instance
                 */
                OutputReference.create = function create(properties) {
                    return new OutputReference(properties);
                };
    
                /**
                 * Encodes the specified OutputReference message. Does not implicitly {@link flyteidl.core.OutputReference.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.OutputReference
                 * @static
                 * @param {flyteidl.core.IOutputReference} message OutputReference message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                OutputReference.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.nodeId != null && message.hasOwnProperty("nodeId"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.nodeId);
                    if (message["var"] != null && message.hasOwnProperty("var"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message["var"]);
                    if (message.attrPath != null && message.attrPath.length)
                        for (var i = 0; i < message.attrPath.length; ++i)
                            $root.flyteidl.core.PromiseAttribute.encode(message.attrPath[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes an OutputReference message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.OutputReference
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.OutputReference} OutputReference
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                OutputReference.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.OutputReference();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.nodeId = reader.string();
                            break;
                        case 2:
                            message["var"] = reader.string();
                            break;
                        case 3:
                            if (!(message.attrPath && message.attrPath.length))
                                message.attrPath = [];
                            message.attrPath.push($root.flyteidl.core.PromiseAttribute.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an OutputReference message.
                 * @function verify
                 * @memberof flyteidl.core.OutputReference
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                OutputReference.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.nodeId != null && message.hasOwnProperty("nodeId"))
                        if (!$util.isString(message.nodeId))
                            return "nodeId: string expected";
                    if (message["var"] != null && message.hasOwnProperty("var"))
                        if (!$util.isString(message["var"]))
                            return "var: string expected";
                    if (message.attrPath != null && message.hasOwnProperty("attrPath")) {
                        if (!Array.isArray(message.attrPath))
                            return "attrPath: array expected";
                        for (var i = 0; i < message.attrPath.length; ++i) {
                            var error = $root.flyteidl.core.PromiseAttribute.verify(message.attrPath[i]);
                            if (error)
                                return "attrPath." + error;
                        }
                    }
                    return null;
                };
    
                return OutputReference;
            })();
    
            core.PromiseAttribute = (function() {
    
                /**
                 * Properties of a PromiseAttribute.
                 * @memberof flyteidl.core
                 * @interface IPromiseAttribute
                 * @property {string|null} [stringValue] PromiseAttribute stringValue
                 * @property {number|null} [intValue] PromiseAttribute intValue
                 */
    
                /**
                 * Constructs a new PromiseAttribute.
                 * @memberof flyteidl.core
                 * @classdesc Represents a PromiseAttribute.
                 * @implements IPromiseAttribute
                 * @constructor
                 * @param {flyteidl.core.IPromiseAttribute=} [properties] Properties to set
                 */
                function PromiseAttribute(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * PromiseAttribute stringValue.
                 * @member {string} stringValue
                 * @memberof flyteidl.core.PromiseAttribute
                 * @instance
                 */
                PromiseAttribute.prototype.stringValue = "";
    
                /**
                 * PromiseAttribute intValue.
                 * @member {number} intValue
                 * @memberof flyteidl.core.PromiseAttribute
                 * @instance
                 */
                PromiseAttribute.prototype.intValue = 0;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * PromiseAttribute value.
                 * @member {"stringValue"|"intValue"|undefined} value
                 * @memberof flyteidl.core.PromiseAttribute
                 * @instance
                 */
                Object.defineProperty(PromiseAttribute.prototype, "value", {
                    get: $util.oneOfGetter($oneOfFields = ["stringValue", "intValue"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new PromiseAttribute instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.PromiseAttribute
                 * @static
                 * @param {flyteidl.core.IPromiseAttribute=} [properties] Properties to set
                 * @returns {flyteidl.core.PromiseAttribute} PromiseAttribute instance
                 */
                PromiseAttribute.create = function create(properties) {
                    return new PromiseAttribute(properties);
                };
    
                /**
                 * Encodes the specified PromiseAttribute message. Does not implicitly {@link flyteidl.core.PromiseAttribute.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.PromiseAttribute
                 * @static
                 * @param {flyteidl.core.IPromiseAttribute} message PromiseAttribute message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                PromiseAttribute.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.stringValue != null && message.hasOwnProperty("stringValue"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.stringValue);
                    if (message.intValue != null && message.hasOwnProperty("intValue"))
                        writer.uint32(/* id 2, wireType 0 =*/16).int32(message.intValue);
                    return writer;
                };
    
                /**
                 * Decodes a PromiseAttribute message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.PromiseAttribute
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.PromiseAttribute} PromiseAttribute
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                PromiseAttribute.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.PromiseAttribute();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.stringValue = reader.string();
                            break;
                        case 2:
                            message.intValue = reader.int32();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a PromiseAttribute message.
                 * @function verify
                 * @memberof flyteidl.core.PromiseAttribute
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                PromiseAttribute.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.stringValue != null && message.hasOwnProperty("stringValue")) {
                        properties.value = 1;
                        if (!$util.isString(message.stringValue))
                            return "stringValue: string expected";
                    }
                    if (message.intValue != null && message.hasOwnProperty("intValue")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        if (!$util.isInteger(message.intValue))
                            return "intValue: integer expected";
                    }
                    return null;
                };
    
                return PromiseAttribute;
            })();
    
            core.Error = (function() {
    
                /**
                 * Properties of an Error.
                 * @memberof flyteidl.core
                 * @interface IError
                 * @property {string|null} [failedNodeId] Error failedNodeId
                 * @property {string|null} [message] Error message
                 */
    
                /**
                 * Constructs a new Error.
                 * @memberof flyteidl.core
                 * @classdesc Represents an Error.
                 * @implements IError
                 * @constructor
                 * @param {flyteidl.core.IError=} [properties] Properties to set
                 */
                function Error(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Error failedNodeId.
                 * @member {string} failedNodeId
                 * @memberof flyteidl.core.Error
                 * @instance
                 */
                Error.prototype.failedNodeId = "";
    
                /**
                 * Error message.
                 * @member {string} message
                 * @memberof flyteidl.core.Error
                 * @instance
                 */
                Error.prototype.message = "";
    
                /**
                 * Creates a new Error instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Error
                 * @static
                 * @param {flyteidl.core.IError=} [properties] Properties to set
                 * @returns {flyteidl.core.Error} Error instance
                 */
                Error.create = function create(properties) {
                    return new Error(properties);
                };
    
                /**
                 * Encodes the specified Error message. Does not implicitly {@link flyteidl.core.Error.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Error
                 * @static
                 * @param {flyteidl.core.IError} message Error message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Error.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.failedNodeId != null && message.hasOwnProperty("failedNodeId"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.failedNodeId);
                    if (message.message != null && message.hasOwnProperty("message"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.message);
                    return writer;
                };
    
                /**
                 * Decodes an Error message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Error
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Error} Error
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Error.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Error();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.failedNodeId = reader.string();
                            break;
                        case 2:
                            message.message = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an Error message.
                 * @function verify
                 * @memberof flyteidl.core.Error
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Error.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.failedNodeId != null && message.hasOwnProperty("failedNodeId"))
                        if (!$util.isString(message.failedNodeId))
                            return "failedNodeId: string expected";
                    if (message.message != null && message.hasOwnProperty("message"))
                        if (!$util.isString(message.message))
                            return "message: string expected";
                    return null;
                };
    
                return Error;
            })();
    
            core.Primitive = (function() {
    
                /**
                 * Properties of a Primitive.
                 * @memberof flyteidl.core
                 * @interface IPrimitive
                 * @property {Long|null} [integer] Primitive integer
                 * @property {number|null} [floatValue] Primitive floatValue
                 * @property {string|null} [stringValue] Primitive stringValue
                 * @property {boolean|null} [boolean] Primitive boolean
                 * @property {google.protobuf.ITimestamp|null} [datetime] Primitive datetime
                 * @property {google.protobuf.IDuration|null} [duration] Primitive duration
                 */
    
                /**
                 * Constructs a new Primitive.
                 * @memberof flyteidl.core
                 * @classdesc Represents a Primitive.
                 * @implements IPrimitive
                 * @constructor
                 * @param {flyteidl.core.IPrimitive=} [properties] Properties to set
                 */
                function Primitive(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Primitive integer.
                 * @member {Long} integer
                 * @memberof flyteidl.core.Primitive
                 * @instance
                 */
                Primitive.prototype.integer = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                /**
                 * Primitive floatValue.
                 * @member {number} floatValue
                 * @memberof flyteidl.core.Primitive
                 * @instance
                 */
                Primitive.prototype.floatValue = 0;
    
                /**
                 * Primitive stringValue.
                 * @member {string} stringValue
                 * @memberof flyteidl.core.Primitive
                 * @instance
                 */
                Primitive.prototype.stringValue = "";
    
                /**
                 * Primitive boolean.
                 * @member {boolean} boolean
                 * @memberof flyteidl.core.Primitive
                 * @instance
                 */
                Primitive.prototype.boolean = false;
    
                /**
                 * Primitive datetime.
                 * @member {google.protobuf.ITimestamp|null|undefined} datetime
                 * @memberof flyteidl.core.Primitive
                 * @instance
                 */
                Primitive.prototype.datetime = null;
    
                /**
                 * Primitive duration.
                 * @member {google.protobuf.IDuration|null|undefined} duration
                 * @memberof flyteidl.core.Primitive
                 * @instance
                 */
                Primitive.prototype.duration = null;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * Primitive value.
                 * @member {"integer"|"floatValue"|"stringValue"|"boolean"|"datetime"|"duration"|undefined} value
                 * @memberof flyteidl.core.Primitive
                 * @instance
                 */
                Object.defineProperty(Primitive.prototype, "value", {
                    get: $util.oneOfGetter($oneOfFields = ["integer", "floatValue", "stringValue", "boolean", "datetime", "duration"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new Primitive instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Primitive
                 * @static
                 * @param {flyteidl.core.IPrimitive=} [properties] Properties to set
                 * @returns {flyteidl.core.Primitive} Primitive instance
                 */
                Primitive.create = function create(properties) {
                    return new Primitive(properties);
                };
    
                /**
                 * Encodes the specified Primitive message. Does not implicitly {@link flyteidl.core.Primitive.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Primitive
                 * @static
                 * @param {flyteidl.core.IPrimitive} message Primitive message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Primitive.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.integer != null && message.hasOwnProperty("integer"))
                        writer.uint32(/* id 1, wireType 0 =*/8).int64(message.integer);
                    if (message.floatValue != null && message.hasOwnProperty("floatValue"))
                        writer.uint32(/* id 2, wireType 1 =*/17).double(message.floatValue);
                    if (message.stringValue != null && message.hasOwnProperty("stringValue"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.stringValue);
                    if (message.boolean != null && message.hasOwnProperty("boolean"))
                        writer.uint32(/* id 4, wireType 0 =*/32).bool(message.boolean);
                    if (message.datetime != null && message.hasOwnProperty("datetime"))
                        $root.google.protobuf.Timestamp.encode(message.datetime, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                    if (message.duration != null && message.hasOwnProperty("duration"))
                        $root.google.protobuf.Duration.encode(message.duration, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a Primitive message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Primitive
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Primitive} Primitive
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Primitive.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Primitive();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.integer = reader.int64();
                            break;
                        case 2:
                            message.floatValue = reader.double();
                            break;
                        case 3:
                            message.stringValue = reader.string();
                            break;
                        case 4:
                            message.boolean = reader.bool();
                            break;
                        case 5:
                            message.datetime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                            break;
                        case 6:
                            message.duration = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a Primitive message.
                 * @function verify
                 * @memberof flyteidl.core.Primitive
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Primitive.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.integer != null && message.hasOwnProperty("integer")) {
                        properties.value = 1;
                        if (!$util.isInteger(message.integer) && !(message.integer && $util.isInteger(message.integer.low) && $util.isInteger(message.integer.high)))
                            return "integer: integer|Long expected";
                    }
                    if (message.floatValue != null && message.hasOwnProperty("floatValue")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        if (typeof message.floatValue !== "number")
                            return "floatValue: number expected";
                    }
                    if (message.stringValue != null && message.hasOwnProperty("stringValue")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        if (!$util.isString(message.stringValue))
                            return "stringValue: string expected";
                    }
                    if (message.boolean != null && message.hasOwnProperty("boolean")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        if (typeof message.boolean !== "boolean")
                            return "boolean: boolean expected";
                    }
                    if (message.datetime != null && message.hasOwnProperty("datetime")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        {
                            var error = $root.google.protobuf.Timestamp.verify(message.datetime);
                            if (error)
                                return "datetime." + error;
                        }
                    }
                    if (message.duration != null && message.hasOwnProperty("duration")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        {
                            var error = $root.google.protobuf.Duration.verify(message.duration);
                            if (error)
                                return "duration." + error;
                        }
                    }
                    return null;
                };
    
                return Primitive;
            })();
    
            core.Void = (function() {
    
                /**
                 * Properties of a Void.
                 * @memberof flyteidl.core
                 * @interface IVoid
                 */
    
                /**
                 * Constructs a new Void.
                 * @memberof flyteidl.core
                 * @classdesc Represents a Void.
                 * @implements IVoid
                 * @constructor
                 * @param {flyteidl.core.IVoid=} [properties] Properties to set
                 */
                function Void(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Creates a new Void instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Void
                 * @static
                 * @param {flyteidl.core.IVoid=} [properties] Properties to set
                 * @returns {flyteidl.core.Void} Void instance
                 */
                Void.create = function create(properties) {
                    return new Void(properties);
                };
    
                /**
                 * Encodes the specified Void message. Does not implicitly {@link flyteidl.core.Void.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Void
                 * @static
                 * @param {flyteidl.core.IVoid} message Void message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Void.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    return writer;
                };
    
                /**
                 * Decodes a Void message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Void
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Void} Void
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Void.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Void();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a Void message.
                 * @function verify
                 * @memberof flyteidl.core.Void
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Void.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    return null;
                };
    
                return Void;
            })();
    
            core.Blob = (function() {
    
                /**
                 * Properties of a Blob.
                 * @memberof flyteidl.core
                 * @interface IBlob
                 * @property {flyteidl.core.IBlobMetadata|null} [metadata] Blob metadata
                 * @property {string|null} [uri] Blob uri
                 */
    
                /**
                 * Constructs a new Blob.
                 * @memberof flyteidl.core
                 * @classdesc Represents a Blob.
                 * @implements IBlob
                 * @constructor
                 * @param {flyteidl.core.IBlob=} [properties] Properties to set
                 */
                function Blob(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Blob metadata.
                 * @member {flyteidl.core.IBlobMetadata|null|undefined} metadata
                 * @memberof flyteidl.core.Blob
                 * @instance
                 */
                Blob.prototype.metadata = null;
    
                /**
                 * Blob uri.
                 * @member {string} uri
                 * @memberof flyteidl.core.Blob
                 * @instance
                 */
                Blob.prototype.uri = "";
    
                /**
                 * Creates a new Blob instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Blob
                 * @static
                 * @param {flyteidl.core.IBlob=} [properties] Properties to set
                 * @returns {flyteidl.core.Blob} Blob instance
                 */
                Blob.create = function create(properties) {
                    return new Blob(properties);
                };
    
                /**
                 * Encodes the specified Blob message. Does not implicitly {@link flyteidl.core.Blob.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Blob
                 * @static
                 * @param {flyteidl.core.IBlob} message Blob message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Blob.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.metadata != null && message.hasOwnProperty("metadata"))
                        $root.flyteidl.core.BlobMetadata.encode(message.metadata, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.uri != null && message.hasOwnProperty("uri"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.uri);
                    return writer;
                };
    
                /**
                 * Decodes a Blob message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Blob
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Blob} Blob
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Blob.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Blob();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.metadata = $root.flyteidl.core.BlobMetadata.decode(reader, reader.uint32());
                            break;
                        case 3:
                            message.uri = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a Blob message.
                 * @function verify
                 * @memberof flyteidl.core.Blob
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Blob.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.metadata != null && message.hasOwnProperty("metadata")) {
                        var error = $root.flyteidl.core.BlobMetadata.verify(message.metadata);
                        if (error)
                            return "metadata." + error;
                    }
                    if (message.uri != null && message.hasOwnProperty("uri"))
                        if (!$util.isString(message.uri))
                            return "uri: string expected";
                    return null;
                };
    
                return Blob;
            })();
    
            core.BlobMetadata = (function() {
    
                /**
                 * Properties of a BlobMetadata.
                 * @memberof flyteidl.core
                 * @interface IBlobMetadata
                 * @property {flyteidl.core.IBlobType|null} [type] BlobMetadata type
                 */
    
                /**
                 * Constructs a new BlobMetadata.
                 * @memberof flyteidl.core
                 * @classdesc Represents a BlobMetadata.
                 * @implements IBlobMetadata
                 * @constructor
                 * @param {flyteidl.core.IBlobMetadata=} [properties] Properties to set
                 */
                function BlobMetadata(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * BlobMetadata type.
                 * @member {flyteidl.core.IBlobType|null|undefined} type
                 * @memberof flyteidl.core.BlobMetadata
                 * @instance
                 */
                BlobMetadata.prototype.type = null;
    
                /**
                 * Creates a new BlobMetadata instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.BlobMetadata
                 * @static
                 * @param {flyteidl.core.IBlobMetadata=} [properties] Properties to set
                 * @returns {flyteidl.core.BlobMetadata} BlobMetadata instance
                 */
                BlobMetadata.create = function create(properties) {
                    return new BlobMetadata(properties);
                };
    
                /**
                 * Encodes the specified BlobMetadata message. Does not implicitly {@link flyteidl.core.BlobMetadata.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.BlobMetadata
                 * @static
                 * @param {flyteidl.core.IBlobMetadata} message BlobMetadata message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                BlobMetadata.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.type != null && message.hasOwnProperty("type"))
                        $root.flyteidl.core.BlobType.encode(message.type, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a BlobMetadata message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.BlobMetadata
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.BlobMetadata} BlobMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                BlobMetadata.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.BlobMetadata();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.type = $root.flyteidl.core.BlobType.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a BlobMetadata message.
                 * @function verify
                 * @memberof flyteidl.core.BlobMetadata
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                BlobMetadata.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.type != null && message.hasOwnProperty("type")) {
                        var error = $root.flyteidl.core.BlobType.verify(message.type);
                        if (error)
                            return "type." + error;
                    }
                    return null;
                };
    
                return BlobMetadata;
            })();
    
            core.Binary = (function() {
    
                /**
                 * Properties of a Binary.
                 * @memberof flyteidl.core
                 * @interface IBinary
                 * @property {Uint8Array|null} [value] Binary value
                 * @property {string|null} [tag] Binary tag
                 */
    
                /**
                 * Constructs a new Binary.
                 * @memberof flyteidl.core
                 * @classdesc Represents a Binary.
                 * @implements IBinary
                 * @constructor
                 * @param {flyteidl.core.IBinary=} [properties] Properties to set
                 */
                function Binary(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Binary value.
                 * @member {Uint8Array} value
                 * @memberof flyteidl.core.Binary
                 * @instance
                 */
                Binary.prototype.value = $util.newBuffer([]);
    
                /**
                 * Binary tag.
                 * @member {string} tag
                 * @memberof flyteidl.core.Binary
                 * @instance
                 */
                Binary.prototype.tag = "";
    
                /**
                 * Creates a new Binary instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Binary
                 * @static
                 * @param {flyteidl.core.IBinary=} [properties] Properties to set
                 * @returns {flyteidl.core.Binary} Binary instance
                 */
                Binary.create = function create(properties) {
                    return new Binary(properties);
                };
    
                /**
                 * Encodes the specified Binary message. Does not implicitly {@link flyteidl.core.Binary.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Binary
                 * @static
                 * @param {flyteidl.core.IBinary} message Binary message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Binary.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.value != null && message.hasOwnProperty("value"))
                        writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.value);
                    if (message.tag != null && message.hasOwnProperty("tag"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.tag);
                    return writer;
                };
    
                /**
                 * Decodes a Binary message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Binary
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Binary} Binary
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Binary.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Binary();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.value = reader.bytes();
                            break;
                        case 2:
                            message.tag = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a Binary message.
                 * @function verify
                 * @memberof flyteidl.core.Binary
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Binary.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.value != null && message.hasOwnProperty("value"))
                        if (!(message.value && typeof message.value.length === "number" || $util.isString(message.value)))
                            return "value: buffer expected";
                    if (message.tag != null && message.hasOwnProperty("tag"))
                        if (!$util.isString(message.tag))
                            return "tag: string expected";
                    return null;
                };
    
                return Binary;
            })();
    
            core.Schema = (function() {
    
                /**
                 * Properties of a Schema.
                 * @memberof flyteidl.core
                 * @interface ISchema
                 * @property {string|null} [uri] Schema uri
                 * @property {flyteidl.core.ISchemaType|null} [type] Schema type
                 */
    
                /**
                 * Constructs a new Schema.
                 * @memberof flyteidl.core
                 * @classdesc Represents a Schema.
                 * @implements ISchema
                 * @constructor
                 * @param {flyteidl.core.ISchema=} [properties] Properties to set
                 */
                function Schema(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Schema uri.
                 * @member {string} uri
                 * @memberof flyteidl.core.Schema
                 * @instance
                 */
                Schema.prototype.uri = "";
    
                /**
                 * Schema type.
                 * @member {flyteidl.core.ISchemaType|null|undefined} type
                 * @memberof flyteidl.core.Schema
                 * @instance
                 */
                Schema.prototype.type = null;
    
                /**
                 * Creates a new Schema instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Schema
                 * @static
                 * @param {flyteidl.core.ISchema=} [properties] Properties to set
                 * @returns {flyteidl.core.Schema} Schema instance
                 */
                Schema.create = function create(properties) {
                    return new Schema(properties);
                };
    
                /**
                 * Encodes the specified Schema message. Does not implicitly {@link flyteidl.core.Schema.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Schema
                 * @static
                 * @param {flyteidl.core.ISchema} message Schema message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Schema.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.uri != null && message.hasOwnProperty("uri"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.uri);
                    if (message.type != null && message.hasOwnProperty("type"))
                        $root.flyteidl.core.SchemaType.encode(message.type, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a Schema message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Schema
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Schema} Schema
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Schema.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Schema();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.uri = reader.string();
                            break;
                        case 3:
                            message.type = $root.flyteidl.core.SchemaType.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a Schema message.
                 * @function verify
                 * @memberof flyteidl.core.Schema
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Schema.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.uri != null && message.hasOwnProperty("uri"))
                        if (!$util.isString(message.uri))
                            return "uri: string expected";
                    if (message.type != null && message.hasOwnProperty("type")) {
                        var error = $root.flyteidl.core.SchemaType.verify(message.type);
                        if (error)
                            return "type." + error;
                    }
                    return null;
                };
    
                return Schema;
            })();
    
            core.Union = (function() {
    
                /**
                 * Properties of an Union.
                 * @memberof flyteidl.core
                 * @interface IUnion
                 * @property {flyteidl.core.ILiteral|null} [value] Union value
                 * @property {flyteidl.core.ILiteralType|null} [type] Union type
                 */
    
                /**
                 * Constructs a new Union.
                 * @memberof flyteidl.core
                 * @classdesc Represents an Union.
                 * @implements IUnion
                 * @constructor
                 * @param {flyteidl.core.IUnion=} [properties] Properties to set
                 */
                function Union(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Union value.
                 * @member {flyteidl.core.ILiteral|null|undefined} value
                 * @memberof flyteidl.core.Union
                 * @instance
                 */
                Union.prototype.value = null;
    
                /**
                 * Union type.
                 * @member {flyteidl.core.ILiteralType|null|undefined} type
                 * @memberof flyteidl.core.Union
                 * @instance
                 */
                Union.prototype.type = null;
    
                /**
                 * Creates a new Union instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Union
                 * @static
                 * @param {flyteidl.core.IUnion=} [properties] Properties to set
                 * @returns {flyteidl.core.Union} Union instance
                 */
                Union.create = function create(properties) {
                    return new Union(properties);
                };
    
                /**
                 * Encodes the specified Union message. Does not implicitly {@link flyteidl.core.Union.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Union
                 * @static
                 * @param {flyteidl.core.IUnion} message Union message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Union.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.value != null && message.hasOwnProperty("value"))
                        $root.flyteidl.core.Literal.encode(message.value, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.type != null && message.hasOwnProperty("type"))
                        $root.flyteidl.core.LiteralType.encode(message.type, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes an Union message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Union
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Union} Union
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Union.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Union();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.value = $root.flyteidl.core.Literal.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.type = $root.flyteidl.core.LiteralType.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an Union message.
                 * @function verify
                 * @memberof flyteidl.core.Union
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Union.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.value != null && message.hasOwnProperty("value")) {
                        var error = $root.flyteidl.core.Literal.verify(message.value);
                        if (error)
                            return "value." + error;
                    }
                    if (message.type != null && message.hasOwnProperty("type")) {
                        var error = $root.flyteidl.core.LiteralType.verify(message.type);
                        if (error)
                            return "type." + error;
                    }
                    return null;
                };
    
                return Union;
            })();
    
            core.StructuredDatasetMetadata = (function() {
    
                /**
                 * Properties of a StructuredDatasetMetadata.
                 * @memberof flyteidl.core
                 * @interface IStructuredDatasetMetadata
                 * @property {flyteidl.core.IStructuredDatasetType|null} [structuredDatasetType] StructuredDatasetMetadata structuredDatasetType
                 */
    
                /**
                 * Constructs a new StructuredDatasetMetadata.
                 * @memberof flyteidl.core
                 * @classdesc Represents a StructuredDatasetMetadata.
                 * @implements IStructuredDatasetMetadata
                 * @constructor
                 * @param {flyteidl.core.IStructuredDatasetMetadata=} [properties] Properties to set
                 */
                function StructuredDatasetMetadata(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * StructuredDatasetMetadata structuredDatasetType.
                 * @member {flyteidl.core.IStructuredDatasetType|null|undefined} structuredDatasetType
                 * @memberof flyteidl.core.StructuredDatasetMetadata
                 * @instance
                 */
                StructuredDatasetMetadata.prototype.structuredDatasetType = null;
    
                /**
                 * Creates a new StructuredDatasetMetadata instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.StructuredDatasetMetadata
                 * @static
                 * @param {flyteidl.core.IStructuredDatasetMetadata=} [properties] Properties to set
                 * @returns {flyteidl.core.StructuredDatasetMetadata} StructuredDatasetMetadata instance
                 */
                StructuredDatasetMetadata.create = function create(properties) {
                    return new StructuredDatasetMetadata(properties);
                };
    
                /**
                 * Encodes the specified StructuredDatasetMetadata message. Does not implicitly {@link flyteidl.core.StructuredDatasetMetadata.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.StructuredDatasetMetadata
                 * @static
                 * @param {flyteidl.core.IStructuredDatasetMetadata} message StructuredDatasetMetadata message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                StructuredDatasetMetadata.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.structuredDatasetType != null && message.hasOwnProperty("structuredDatasetType"))
                        $root.flyteidl.core.StructuredDatasetType.encode(message.structuredDatasetType, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a StructuredDatasetMetadata message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.StructuredDatasetMetadata
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.StructuredDatasetMetadata} StructuredDatasetMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                StructuredDatasetMetadata.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.StructuredDatasetMetadata();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.structuredDatasetType = $root.flyteidl.core.StructuredDatasetType.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a StructuredDatasetMetadata message.
                 * @function verify
                 * @memberof flyteidl.core.StructuredDatasetMetadata
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                StructuredDatasetMetadata.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.structuredDatasetType != null && message.hasOwnProperty("structuredDatasetType")) {
                        var error = $root.flyteidl.core.StructuredDatasetType.verify(message.structuredDatasetType);
                        if (error)
                            return "structuredDatasetType." + error;
                    }
                    return null;
                };
    
                return StructuredDatasetMetadata;
            })();
    
            core.StructuredDataset = (function() {
    
                /**
                 * Properties of a StructuredDataset.
                 * @memberof flyteidl.core
                 * @interface IStructuredDataset
                 * @property {string|null} [uri] StructuredDataset uri
                 * @property {flyteidl.core.IStructuredDatasetMetadata|null} [metadata] StructuredDataset metadata
                 */
    
                /**
                 * Constructs a new StructuredDataset.
                 * @memberof flyteidl.core
                 * @classdesc Represents a StructuredDataset.
                 * @implements IStructuredDataset
                 * @constructor
                 * @param {flyteidl.core.IStructuredDataset=} [properties] Properties to set
                 */
                function StructuredDataset(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * StructuredDataset uri.
                 * @member {string} uri
                 * @memberof flyteidl.core.StructuredDataset
                 * @instance
                 */
                StructuredDataset.prototype.uri = "";
    
                /**
                 * StructuredDataset metadata.
                 * @member {flyteidl.core.IStructuredDatasetMetadata|null|undefined} metadata
                 * @memberof flyteidl.core.StructuredDataset
                 * @instance
                 */
                StructuredDataset.prototype.metadata = null;
    
                /**
                 * Creates a new StructuredDataset instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.StructuredDataset
                 * @static
                 * @param {flyteidl.core.IStructuredDataset=} [properties] Properties to set
                 * @returns {flyteidl.core.StructuredDataset} StructuredDataset instance
                 */
                StructuredDataset.create = function create(properties) {
                    return new StructuredDataset(properties);
                };
    
                /**
                 * Encodes the specified StructuredDataset message. Does not implicitly {@link flyteidl.core.StructuredDataset.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.StructuredDataset
                 * @static
                 * @param {flyteidl.core.IStructuredDataset} message StructuredDataset message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                StructuredDataset.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.uri != null && message.hasOwnProperty("uri"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.uri);
                    if (message.metadata != null && message.hasOwnProperty("metadata"))
                        $root.flyteidl.core.StructuredDatasetMetadata.encode(message.metadata, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a StructuredDataset message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.StructuredDataset
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.StructuredDataset} StructuredDataset
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                StructuredDataset.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.StructuredDataset();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.uri = reader.string();
                            break;
                        case 2:
                            message.metadata = $root.flyteidl.core.StructuredDatasetMetadata.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a StructuredDataset message.
                 * @function verify
                 * @memberof flyteidl.core.StructuredDataset
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                StructuredDataset.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.uri != null && message.hasOwnProperty("uri"))
                        if (!$util.isString(message.uri))
                            return "uri: string expected";
                    if (message.metadata != null && message.hasOwnProperty("metadata")) {
                        var error = $root.flyteidl.core.StructuredDatasetMetadata.verify(message.metadata);
                        if (error)
                            return "metadata." + error;
                    }
                    return null;
                };
    
                return StructuredDataset;
            })();
    
            core.Scalar = (function() {
    
                /**
                 * Properties of a Scalar.
                 * @memberof flyteidl.core
                 * @interface IScalar
                 * @property {flyteidl.core.IPrimitive|null} [primitive] Scalar primitive
                 * @property {flyteidl.core.IBlob|null} [blob] Scalar blob
                 * @property {flyteidl.core.IBinary|null} [binary] Scalar binary
                 * @property {flyteidl.core.ISchema|null} [schema] Scalar schema
                 * @property {flyteidl.core.IVoid|null} [noneType] Scalar noneType
                 * @property {flyteidl.core.IError|null} [error] Scalar error
                 * @property {google.protobuf.IStruct|null} [generic] Scalar generic
                 * @property {flyteidl.core.IStructuredDataset|null} [structuredDataset] Scalar structuredDataset
                 * @property {flyteidl.core.IUnion|null} [union] Scalar union
                 */
    
                /**
                 * Constructs a new Scalar.
                 * @memberof flyteidl.core
                 * @classdesc Represents a Scalar.
                 * @implements IScalar
                 * @constructor
                 * @param {flyteidl.core.IScalar=} [properties] Properties to set
                 */
                function Scalar(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Scalar primitive.
                 * @member {flyteidl.core.IPrimitive|null|undefined} primitive
                 * @memberof flyteidl.core.Scalar
                 * @instance
                 */
                Scalar.prototype.primitive = null;
    
                /**
                 * Scalar blob.
                 * @member {flyteidl.core.IBlob|null|undefined} blob
                 * @memberof flyteidl.core.Scalar
                 * @instance
                 */
                Scalar.prototype.blob = null;
    
                /**
                 * Scalar binary.
                 * @member {flyteidl.core.IBinary|null|undefined} binary
                 * @memberof flyteidl.core.Scalar
                 * @instance
                 */
                Scalar.prototype.binary = null;
    
                /**
                 * Scalar schema.
                 * @member {flyteidl.core.ISchema|null|undefined} schema
                 * @memberof flyteidl.core.Scalar
                 * @instance
                 */
                Scalar.prototype.schema = null;
    
                /**
                 * Scalar noneType.
                 * @member {flyteidl.core.IVoid|null|undefined} noneType
                 * @memberof flyteidl.core.Scalar
                 * @instance
                 */
                Scalar.prototype.noneType = null;
    
                /**
                 * Scalar error.
                 * @member {flyteidl.core.IError|null|undefined} error
                 * @memberof flyteidl.core.Scalar
                 * @instance
                 */
                Scalar.prototype.error = null;
    
                /**
                 * Scalar generic.
                 * @member {google.protobuf.IStruct|null|undefined} generic
                 * @memberof flyteidl.core.Scalar
                 * @instance
                 */
                Scalar.prototype.generic = null;
    
                /**
                 * Scalar structuredDataset.
                 * @member {flyteidl.core.IStructuredDataset|null|undefined} structuredDataset
                 * @memberof flyteidl.core.Scalar
                 * @instance
                 */
                Scalar.prototype.structuredDataset = null;
    
                /**
                 * Scalar union.
                 * @member {flyteidl.core.IUnion|null|undefined} union
                 * @memberof flyteidl.core.Scalar
                 * @instance
                 */
                Scalar.prototype.union = null;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * Scalar value.
                 * @member {"primitive"|"blob"|"binary"|"schema"|"noneType"|"error"|"generic"|"structuredDataset"|"union"|undefined} value
                 * @memberof flyteidl.core.Scalar
                 * @instance
                 */
                Object.defineProperty(Scalar.prototype, "value", {
                    get: $util.oneOfGetter($oneOfFields = ["primitive", "blob", "binary", "schema", "noneType", "error", "generic", "structuredDataset", "union"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new Scalar instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Scalar
                 * @static
                 * @param {flyteidl.core.IScalar=} [properties] Properties to set
                 * @returns {flyteidl.core.Scalar} Scalar instance
                 */
                Scalar.create = function create(properties) {
                    return new Scalar(properties);
                };
    
                /**
                 * Encodes the specified Scalar message. Does not implicitly {@link flyteidl.core.Scalar.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Scalar
                 * @static
                 * @param {flyteidl.core.IScalar} message Scalar message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Scalar.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.primitive != null && message.hasOwnProperty("primitive"))
                        $root.flyteidl.core.Primitive.encode(message.primitive, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.blob != null && message.hasOwnProperty("blob"))
                        $root.flyteidl.core.Blob.encode(message.blob, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.binary != null && message.hasOwnProperty("binary"))
                        $root.flyteidl.core.Binary.encode(message.binary, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message.schema != null && message.hasOwnProperty("schema"))
                        $root.flyteidl.core.Schema.encode(message.schema, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.noneType != null && message.hasOwnProperty("noneType"))
                        $root.flyteidl.core.Void.encode(message.noneType, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                    if (message.error != null && message.hasOwnProperty("error"))
                        $root.flyteidl.core.Error.encode(message.error, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                    if (message.generic != null && message.hasOwnProperty("generic"))
                        $root.google.protobuf.Struct.encode(message.generic, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                    if (message.structuredDataset != null && message.hasOwnProperty("structuredDataset"))
                        $root.flyteidl.core.StructuredDataset.encode(message.structuredDataset, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                    if (message.union != null && message.hasOwnProperty("union"))
                        $root.flyteidl.core.Union.encode(message.union, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a Scalar message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Scalar
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Scalar} Scalar
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Scalar.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Scalar();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.primitive = $root.flyteidl.core.Primitive.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.blob = $root.flyteidl.core.Blob.decode(reader, reader.uint32());
                            break;
                        case 3:
                            message.binary = $root.flyteidl.core.Binary.decode(reader, reader.uint32());
                            break;
                        case 4:
                            message.schema = $root.flyteidl.core.Schema.decode(reader, reader.uint32());
                            break;
                        case 5:
                            message.noneType = $root.flyteidl.core.Void.decode(reader, reader.uint32());
                            break;
                        case 6:
                            message.error = $root.flyteidl.core.Error.decode(reader, reader.uint32());
                            break;
                        case 7:
                            message.generic = $root.google.protobuf.Struct.decode(reader, reader.uint32());
                            break;
                        case 8:
                            message.structuredDataset = $root.flyteidl.core.StructuredDataset.decode(reader, reader.uint32());
                            break;
                        case 9:
                            message.union = $root.flyteidl.core.Union.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a Scalar message.
                 * @function verify
                 * @memberof flyteidl.core.Scalar
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Scalar.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.primitive != null && message.hasOwnProperty("primitive")) {
                        properties.value = 1;
                        {
                            var error = $root.flyteidl.core.Primitive.verify(message.primitive);
                            if (error)
                                return "primitive." + error;
                        }
                    }
                    if (message.blob != null && message.hasOwnProperty("blob")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        {
                            var error = $root.flyteidl.core.Blob.verify(message.blob);
                            if (error)
                                return "blob." + error;
                        }
                    }
                    if (message.binary != null && message.hasOwnProperty("binary")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        {
                            var error = $root.flyteidl.core.Binary.verify(message.binary);
                            if (error)
                                return "binary." + error;
                        }
                    }
                    if (message.schema != null && message.hasOwnProperty("schema")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        {
                            var error = $root.flyteidl.core.Schema.verify(message.schema);
                            if (error)
                                return "schema." + error;
                        }
                    }
                    if (message.noneType != null && message.hasOwnProperty("noneType")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        {
                            var error = $root.flyteidl.core.Void.verify(message.noneType);
                            if (error)
                                return "noneType." + error;
                        }
                    }
                    if (message.error != null && message.hasOwnProperty("error")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        {
                            var error = $root.flyteidl.core.Error.verify(message.error);
                            if (error)
                                return "error." + error;
                        }
                    }
                    if (message.generic != null && message.hasOwnProperty("generic")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        {
                            var error = $root.google.protobuf.Struct.verify(message.generic);
                            if (error)
                                return "generic." + error;
                        }
                    }
                    if (message.structuredDataset != null && message.hasOwnProperty("structuredDataset")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        {
                            var error = $root.flyteidl.core.StructuredDataset.verify(message.structuredDataset);
                            if (error)
                                return "structuredDataset." + error;
                        }
                    }
                    if (message.union != null && message.hasOwnProperty("union")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        {
                            var error = $root.flyteidl.core.Union.verify(message.union);
                            if (error)
                                return "union." + error;
                        }
                    }
                    return null;
                };
    
                return Scalar;
            })();
    
            core.Literal = (function() {
    
                /**
                 * Properties of a Literal.
                 * @memberof flyteidl.core
                 * @interface ILiteral
                 * @property {flyteidl.core.IScalar|null} [scalar] Literal scalar
                 * @property {flyteidl.core.ILiteralCollection|null} [collection] Literal collection
                 * @property {flyteidl.core.ILiteralMap|null} [map] Literal map
                 * @property {flyteidl.core.ILiteralOffloadedMetadata|null} [offloadedMetadata] Literal offloadedMetadata
                 * @property {string|null} [hash] Literal hash
                 * @property {Object.<string,string>|null} [metadata] Literal metadata
                 */
    
                /**
                 * Constructs a new Literal.
                 * @memberof flyteidl.core
                 * @classdesc Represents a Literal.
                 * @implements ILiteral
                 * @constructor
                 * @param {flyteidl.core.ILiteral=} [properties] Properties to set
                 */
                function Literal(properties) {
                    this.metadata = {};
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Literal scalar.
                 * @member {flyteidl.core.IScalar|null|undefined} scalar
                 * @memberof flyteidl.core.Literal
                 * @instance
                 */
                Literal.prototype.scalar = null;
    
                /**
                 * Literal collection.
                 * @member {flyteidl.core.ILiteralCollection|null|undefined} collection
                 * @memberof flyteidl.core.Literal
                 * @instance
                 */
                Literal.prototype.collection = null;
    
                /**
                 * Literal map.
                 * @member {flyteidl.core.ILiteralMap|null|undefined} map
                 * @memberof flyteidl.core.Literal
                 * @instance
                 */
                Literal.prototype.map = null;
    
                /**
                 * Literal offloadedMetadata.
                 * @member {flyteidl.core.ILiteralOffloadedMetadata|null|undefined} offloadedMetadata
                 * @memberof flyteidl.core.Literal
                 * @instance
                 */
                Literal.prototype.offloadedMetadata = null;
    
                /**
                 * Literal hash.
                 * @member {string} hash
                 * @memberof flyteidl.core.Literal
                 * @instance
                 */
                Literal.prototype.hash = "";
    
                /**
                 * Literal metadata.
                 * @member {Object.<string,string>} metadata
                 * @memberof flyteidl.core.Literal
                 * @instance
                 */
                Literal.prototype.metadata = $util.emptyObject;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * Literal value.
                 * @member {"scalar"|"collection"|"map"|"offloadedMetadata"|undefined} value
                 * @memberof flyteidl.core.Literal
                 * @instance
                 */
                Object.defineProperty(Literal.prototype, "value", {
                    get: $util.oneOfGetter($oneOfFields = ["scalar", "collection", "map", "offloadedMetadata"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new Literal instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Literal
                 * @static
                 * @param {flyteidl.core.ILiteral=} [properties] Properties to set
                 * @returns {flyteidl.core.Literal} Literal instance
                 */
                Literal.create = function create(properties) {
                    return new Literal(properties);
                };
    
                /**
                 * Encodes the specified Literal message. Does not implicitly {@link flyteidl.core.Literal.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Literal
                 * @static
                 * @param {flyteidl.core.ILiteral} message Literal message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Literal.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.scalar != null && message.hasOwnProperty("scalar"))
                        $root.flyteidl.core.Scalar.encode(message.scalar, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.collection != null && message.hasOwnProperty("collection"))
                        $root.flyteidl.core.LiteralCollection.encode(message.collection, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.map != null && message.hasOwnProperty("map"))
                        $root.flyteidl.core.LiteralMap.encode(message.map, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message.hash != null && message.hasOwnProperty("hash"))
                        writer.uint32(/* id 4, wireType 2 =*/34).string(message.hash);
                    if (message.metadata != null && message.hasOwnProperty("metadata"))
                        for (var keys = Object.keys(message.metadata), i = 0; i < keys.length; ++i)
                            writer.uint32(/* id 5, wireType 2 =*/42).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.metadata[keys[i]]).ldelim();
                    if (message.offloadedMetadata != null && message.hasOwnProperty("offloadedMetadata"))
                        $root.flyteidl.core.LiteralOffloadedMetadata.encode(message.offloadedMetadata, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a Literal message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Literal
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Literal} Literal
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Literal.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Literal(), key;
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.scalar = $root.flyteidl.core.Scalar.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.collection = $root.flyteidl.core.LiteralCollection.decode(reader, reader.uint32());
                            break;
                        case 3:
                            message.map = $root.flyteidl.core.LiteralMap.decode(reader, reader.uint32());
                            break;
                        case 8:
                            message.offloadedMetadata = $root.flyteidl.core.LiteralOffloadedMetadata.decode(reader, reader.uint32());
                            break;
                        case 4:
                            message.hash = reader.string();
                            break;
                        case 5:
                            reader.skip().pos++;
                            if (message.metadata === $util.emptyObject)
                                message.metadata = {};
                            key = reader.string();
                            reader.pos++;
                            message.metadata[key] = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a Literal message.
                 * @function verify
                 * @memberof flyteidl.core.Literal
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Literal.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.scalar != null && message.hasOwnProperty("scalar")) {
                        properties.value = 1;
                        {
                            var error = $root.flyteidl.core.Scalar.verify(message.scalar);
                            if (error)
                                return "scalar." + error;
                        }
                    }
                    if (message.collection != null && message.hasOwnProperty("collection")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        {
                            var error = $root.flyteidl.core.LiteralCollection.verify(message.collection);
                            if (error)
                                return "collection." + error;
                        }
                    }
                    if (message.map != null && message.hasOwnProperty("map")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        {
                            var error = $root.flyteidl.core.LiteralMap.verify(message.map);
                            if (error)
                                return "map." + error;
                        }
                    }
                    if (message.offloadedMetadata != null && message.hasOwnProperty("offloadedMetadata")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        {
                            var error = $root.flyteidl.core.LiteralOffloadedMetadata.verify(message.offloadedMetadata);
                            if (error)
                                return "offloadedMetadata." + error;
                        }
                    }
                    if (message.hash != null && message.hasOwnProperty("hash"))
                        if (!$util.isString(message.hash))
                            return "hash: string expected";
                    if (message.metadata != null && message.hasOwnProperty("metadata")) {
                        if (!$util.isObject(message.metadata))
                            return "metadata: object expected";
                        var key = Object.keys(message.metadata);
                        for (var i = 0; i < key.length; ++i)
                            if (!$util.isString(message.metadata[key[i]]))
                                return "metadata: string{k:string} expected";
                    }
                    return null;
                };
    
                return Literal;
            })();
    
            core.LiteralOffloadedMetadata = (function() {
    
                /**
                 * Properties of a LiteralOffloadedMetadata.
                 * @memberof flyteidl.core
                 * @interface ILiteralOffloadedMetadata
                 * @property {string|null} [uri] LiteralOffloadedMetadata uri
                 * @property {Long|null} [sizeBytes] LiteralOffloadedMetadata sizeBytes
                 * @property {flyteidl.core.ILiteralType|null} [inferredType] LiteralOffloadedMetadata inferredType
                 */
    
                /**
                 * Constructs a new LiteralOffloadedMetadata.
                 * @memberof flyteidl.core
                 * @classdesc Represents a LiteralOffloadedMetadata.
                 * @implements ILiteralOffloadedMetadata
                 * @constructor
                 * @param {flyteidl.core.ILiteralOffloadedMetadata=} [properties] Properties to set
                 */
                function LiteralOffloadedMetadata(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * LiteralOffloadedMetadata uri.
                 * @member {string} uri
                 * @memberof flyteidl.core.LiteralOffloadedMetadata
                 * @instance
                 */
                LiteralOffloadedMetadata.prototype.uri = "";
    
                /**
                 * LiteralOffloadedMetadata sizeBytes.
                 * @member {Long} sizeBytes
                 * @memberof flyteidl.core.LiteralOffloadedMetadata
                 * @instance
                 */
                LiteralOffloadedMetadata.prototype.sizeBytes = $util.Long ? $util.Long.fromBits(0,0,true) : 0;
    
                /**
                 * LiteralOffloadedMetadata inferredType.
                 * @member {flyteidl.core.ILiteralType|null|undefined} inferredType
                 * @memberof flyteidl.core.LiteralOffloadedMetadata
                 * @instance
                 */
                LiteralOffloadedMetadata.prototype.inferredType = null;
    
                /**
                 * Creates a new LiteralOffloadedMetadata instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.LiteralOffloadedMetadata
                 * @static
                 * @param {flyteidl.core.ILiteralOffloadedMetadata=} [properties] Properties to set
                 * @returns {flyteidl.core.LiteralOffloadedMetadata} LiteralOffloadedMetadata instance
                 */
                LiteralOffloadedMetadata.create = function create(properties) {
                    return new LiteralOffloadedMetadata(properties);
                };
    
                /**
                 * Encodes the specified LiteralOffloadedMetadata message. Does not implicitly {@link flyteidl.core.LiteralOffloadedMetadata.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.LiteralOffloadedMetadata
                 * @static
                 * @param {flyteidl.core.ILiteralOffloadedMetadata} message LiteralOffloadedMetadata message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                LiteralOffloadedMetadata.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.uri != null && message.hasOwnProperty("uri"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.uri);
                    if (message.sizeBytes != null && message.hasOwnProperty("sizeBytes"))
                        writer.uint32(/* id 2, wireType 0 =*/16).uint64(message.sizeBytes);
                    if (message.inferredType != null && message.hasOwnProperty("inferredType"))
                        $root.flyteidl.core.LiteralType.encode(message.inferredType, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a LiteralOffloadedMetadata message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.LiteralOffloadedMetadata
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.LiteralOffloadedMetadata} LiteralOffloadedMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                LiteralOffloadedMetadata.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.LiteralOffloadedMetadata();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.uri = reader.string();
                            break;
                        case 2:
                            message.sizeBytes = reader.uint64();
                            break;
                        case 3:
                            message.inferredType = $root.flyteidl.core.LiteralType.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a LiteralOffloadedMetadata message.
                 * @function verify
                 * @memberof flyteidl.core.LiteralOffloadedMetadata
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                LiteralOffloadedMetadata.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.uri != null && message.hasOwnProperty("uri"))
                        if (!$util.isString(message.uri))
                            return "uri: string expected";
                    if (message.sizeBytes != null && message.hasOwnProperty("sizeBytes"))
                        if (!$util.isInteger(message.sizeBytes) && !(message.sizeBytes && $util.isInteger(message.sizeBytes.low) && $util.isInteger(message.sizeBytes.high)))
                            return "sizeBytes: integer|Long expected";
                    if (message.inferredType != null && message.hasOwnProperty("inferredType")) {
                        var error = $root.flyteidl.core.LiteralType.verify(message.inferredType);
                        if (error)
                            return "inferredType." + error;
                    }
                    return null;
                };
    
                return LiteralOffloadedMetadata;
            })();
    
            core.LiteralCollection = (function() {
    
                /**
                 * Properties of a LiteralCollection.
                 * @memberof flyteidl.core
                 * @interface ILiteralCollection
                 * @property {Array.<flyteidl.core.ILiteral>|null} [literals] LiteralCollection literals
                 */
    
                /**
                 * Constructs a new LiteralCollection.
                 * @memberof flyteidl.core
                 * @classdesc Represents a LiteralCollection.
                 * @implements ILiteralCollection
                 * @constructor
                 * @param {flyteidl.core.ILiteralCollection=} [properties] Properties to set
                 */
                function LiteralCollection(properties) {
                    this.literals = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * LiteralCollection literals.
                 * @member {Array.<flyteidl.core.ILiteral>} literals
                 * @memberof flyteidl.core.LiteralCollection
                 * @instance
                 */
                LiteralCollection.prototype.literals = $util.emptyArray;
    
                /**
                 * Creates a new LiteralCollection instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.LiteralCollection
                 * @static
                 * @param {flyteidl.core.ILiteralCollection=} [properties] Properties to set
                 * @returns {flyteidl.core.LiteralCollection} LiteralCollection instance
                 */
                LiteralCollection.create = function create(properties) {
                    return new LiteralCollection(properties);
                };
    
                /**
                 * Encodes the specified LiteralCollection message. Does not implicitly {@link flyteidl.core.LiteralCollection.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.LiteralCollection
                 * @static
                 * @param {flyteidl.core.ILiteralCollection} message LiteralCollection message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                LiteralCollection.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.literals != null && message.literals.length)
                        for (var i = 0; i < message.literals.length; ++i)
                            $root.flyteidl.core.Literal.encode(message.literals[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a LiteralCollection message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.LiteralCollection
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.LiteralCollection} LiteralCollection
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                LiteralCollection.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.LiteralCollection();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            if (!(message.literals && message.literals.length))
                                message.literals = [];
                            message.literals.push($root.flyteidl.core.Literal.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a LiteralCollection message.
                 * @function verify
                 * @memberof flyteidl.core.LiteralCollection
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                LiteralCollection.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.literals != null && message.hasOwnProperty("literals")) {
                        if (!Array.isArray(message.literals))
                            return "literals: array expected";
                        for (var i = 0; i < message.literals.length; ++i) {
                            var error = $root.flyteidl.core.Literal.verify(message.literals[i]);
                            if (error)
                                return "literals." + error;
                        }
                    }
                    return null;
                };
    
                return LiteralCollection;
            })();
    
            core.LiteralMap = (function() {
    
                /**
                 * Properties of a LiteralMap.
                 * @memberof flyteidl.core
                 * @interface ILiteralMap
                 * @property {Object.<string,flyteidl.core.ILiteral>|null} [literals] LiteralMap literals
                 */
    
                /**
                 * Constructs a new LiteralMap.
                 * @memberof flyteidl.core
                 * @classdesc Represents a LiteralMap.
                 * @implements ILiteralMap
                 * @constructor
                 * @param {flyteidl.core.ILiteralMap=} [properties] Properties to set
                 */
                function LiteralMap(properties) {
                    this.literals = {};
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * LiteralMap literals.
                 * @member {Object.<string,flyteidl.core.ILiteral>} literals
                 * @memberof flyteidl.core.LiteralMap
                 * @instance
                 */
                LiteralMap.prototype.literals = $util.emptyObject;
    
                /**
                 * Creates a new LiteralMap instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.LiteralMap
                 * @static
                 * @param {flyteidl.core.ILiteralMap=} [properties] Properties to set
                 * @returns {flyteidl.core.LiteralMap} LiteralMap instance
                 */
                LiteralMap.create = function create(properties) {
                    return new LiteralMap(properties);
                };
    
                /**
                 * Encodes the specified LiteralMap message. Does not implicitly {@link flyteidl.core.LiteralMap.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.LiteralMap
                 * @static
                 * @param {flyteidl.core.ILiteralMap} message LiteralMap message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                LiteralMap.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.literals != null && message.hasOwnProperty("literals"))
                        for (var keys = Object.keys(message.literals), i = 0; i < keys.length; ++i) {
                            writer.uint32(/* id 1, wireType 2 =*/10).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]);
                            $root.flyteidl.core.Literal.encode(message.literals[keys[i]], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim().ldelim();
                        }
                    return writer;
                };
    
                /**
                 * Decodes a LiteralMap message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.LiteralMap
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.LiteralMap} LiteralMap
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                LiteralMap.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.LiteralMap(), key;
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            reader.skip().pos++;
                            if (message.literals === $util.emptyObject)
                                message.literals = {};
                            key = reader.string();
                            reader.pos++;
                            message.literals[key] = $root.flyteidl.core.Literal.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a LiteralMap message.
                 * @function verify
                 * @memberof flyteidl.core.LiteralMap
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                LiteralMap.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.literals != null && message.hasOwnProperty("literals")) {
                        if (!$util.isObject(message.literals))
                            return "literals: object expected";
                        var key = Object.keys(message.literals);
                        for (var i = 0; i < key.length; ++i) {
                            var error = $root.flyteidl.core.Literal.verify(message.literals[key[i]]);
                            if (error)
                                return "literals." + error;
                        }
                    }
                    return null;
                };
    
                return LiteralMap;
            })();
    
            core.BindingDataCollection = (function() {
    
                /**
                 * Properties of a BindingDataCollection.
                 * @memberof flyteidl.core
                 * @interface IBindingDataCollection
                 * @property {Array.<flyteidl.core.IBindingData>|null} [bindings] BindingDataCollection bindings
                 */
    
                /**
                 * Constructs a new BindingDataCollection.
                 * @memberof flyteidl.core
                 * @classdesc Represents a BindingDataCollection.
                 * @implements IBindingDataCollection
                 * @constructor
                 * @param {flyteidl.core.IBindingDataCollection=} [properties] Properties to set
                 */
                function BindingDataCollection(properties) {
                    this.bindings = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * BindingDataCollection bindings.
                 * @member {Array.<flyteidl.core.IBindingData>} bindings
                 * @memberof flyteidl.core.BindingDataCollection
                 * @instance
                 */
                BindingDataCollection.prototype.bindings = $util.emptyArray;
    
                /**
                 * Creates a new BindingDataCollection instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.BindingDataCollection
                 * @static
                 * @param {flyteidl.core.IBindingDataCollection=} [properties] Properties to set
                 * @returns {flyteidl.core.BindingDataCollection} BindingDataCollection instance
                 */
                BindingDataCollection.create = function create(properties) {
                    return new BindingDataCollection(properties);
                };
    
                /**
                 * Encodes the specified BindingDataCollection message. Does not implicitly {@link flyteidl.core.BindingDataCollection.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.BindingDataCollection
                 * @static
                 * @param {flyteidl.core.IBindingDataCollection} message BindingDataCollection message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                BindingDataCollection.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.bindings != null && message.bindings.length)
                        for (var i = 0; i < message.bindings.length; ++i)
                            $root.flyteidl.core.BindingData.encode(message.bindings[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a BindingDataCollection message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.BindingDataCollection
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.BindingDataCollection} BindingDataCollection
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                BindingDataCollection.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.BindingDataCollection();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            if (!(message.bindings && message.bindings.length))
                                message.bindings = [];
                            message.bindings.push($root.flyteidl.core.BindingData.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a BindingDataCollection message.
                 * @function verify
                 * @memberof flyteidl.core.BindingDataCollection
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                BindingDataCollection.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.bindings != null && message.hasOwnProperty("bindings")) {
                        if (!Array.isArray(message.bindings))
                            return "bindings: array expected";
                        for (var i = 0; i < message.bindings.length; ++i) {
                            var error = $root.flyteidl.core.BindingData.verify(message.bindings[i]);
                            if (error)
                                return "bindings." + error;
                        }
                    }
                    return null;
                };
    
                return BindingDataCollection;
            })();
    
            core.BindingDataMap = (function() {
    
                /**
                 * Properties of a BindingDataMap.
                 * @memberof flyteidl.core
                 * @interface IBindingDataMap
                 * @property {Object.<string,flyteidl.core.IBindingData>|null} [bindings] BindingDataMap bindings
                 */
    
                /**
                 * Constructs a new BindingDataMap.
                 * @memberof flyteidl.core
                 * @classdesc Represents a BindingDataMap.
                 * @implements IBindingDataMap
                 * @constructor
                 * @param {flyteidl.core.IBindingDataMap=} [properties] Properties to set
                 */
                function BindingDataMap(properties) {
                    this.bindings = {};
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * BindingDataMap bindings.
                 * @member {Object.<string,flyteidl.core.IBindingData>} bindings
                 * @memberof flyteidl.core.BindingDataMap
                 * @instance
                 */
                BindingDataMap.prototype.bindings = $util.emptyObject;
    
                /**
                 * Creates a new BindingDataMap instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.BindingDataMap
                 * @static
                 * @param {flyteidl.core.IBindingDataMap=} [properties] Properties to set
                 * @returns {flyteidl.core.BindingDataMap} BindingDataMap instance
                 */
                BindingDataMap.create = function create(properties) {
                    return new BindingDataMap(properties);
                };
    
                /**
                 * Encodes the specified BindingDataMap message. Does not implicitly {@link flyteidl.core.BindingDataMap.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.BindingDataMap
                 * @static
                 * @param {flyteidl.core.IBindingDataMap} message BindingDataMap message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                BindingDataMap.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.bindings != null && message.hasOwnProperty("bindings"))
                        for (var keys = Object.keys(message.bindings), i = 0; i < keys.length; ++i) {
                            writer.uint32(/* id 1, wireType 2 =*/10).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]);
                            $root.flyteidl.core.BindingData.encode(message.bindings[keys[i]], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim().ldelim();
                        }
                    return writer;
                };
    
                /**
                 * Decodes a BindingDataMap message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.BindingDataMap
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.BindingDataMap} BindingDataMap
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                BindingDataMap.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.BindingDataMap(), key;
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            reader.skip().pos++;
                            if (message.bindings === $util.emptyObject)
                                message.bindings = {};
                            key = reader.string();
                            reader.pos++;
                            message.bindings[key] = $root.flyteidl.core.BindingData.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a BindingDataMap message.
                 * @function verify
                 * @memberof flyteidl.core.BindingDataMap
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                BindingDataMap.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.bindings != null && message.hasOwnProperty("bindings")) {
                        if (!$util.isObject(message.bindings))
                            return "bindings: object expected";
                        var key = Object.keys(message.bindings);
                        for (var i = 0; i < key.length; ++i) {
                            var error = $root.flyteidl.core.BindingData.verify(message.bindings[key[i]]);
                            if (error)
                                return "bindings." + error;
                        }
                    }
                    return null;
                };
    
                return BindingDataMap;
            })();
    
            core.UnionInfo = (function() {
    
                /**
                 * Properties of an UnionInfo.
                 * @memberof flyteidl.core
                 * @interface IUnionInfo
                 * @property {flyteidl.core.ILiteralType|null} [targetType] UnionInfo targetType
                 */
    
                /**
                 * Constructs a new UnionInfo.
                 * @memberof flyteidl.core
                 * @classdesc Represents an UnionInfo.
                 * @implements IUnionInfo
                 * @constructor
                 * @param {flyteidl.core.IUnionInfo=} [properties] Properties to set
                 */
                function UnionInfo(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * UnionInfo targetType.
                 * @member {flyteidl.core.ILiteralType|null|undefined} targetType
                 * @memberof flyteidl.core.UnionInfo
                 * @instance
                 */
                UnionInfo.prototype.targetType = null;
    
                /**
                 * Creates a new UnionInfo instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.UnionInfo
                 * @static
                 * @param {flyteidl.core.IUnionInfo=} [properties] Properties to set
                 * @returns {flyteidl.core.UnionInfo} UnionInfo instance
                 */
                UnionInfo.create = function create(properties) {
                    return new UnionInfo(properties);
                };
    
                /**
                 * Encodes the specified UnionInfo message. Does not implicitly {@link flyteidl.core.UnionInfo.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.UnionInfo
                 * @static
                 * @param {flyteidl.core.IUnionInfo} message UnionInfo message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                UnionInfo.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.targetType != null && message.hasOwnProperty("targetType"))
                        $root.flyteidl.core.LiteralType.encode(message.targetType, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes an UnionInfo message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.UnionInfo
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.UnionInfo} UnionInfo
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                UnionInfo.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.UnionInfo();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.targetType = $root.flyteidl.core.LiteralType.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an UnionInfo message.
                 * @function verify
                 * @memberof flyteidl.core.UnionInfo
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                UnionInfo.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.targetType != null && message.hasOwnProperty("targetType")) {
                        var error = $root.flyteidl.core.LiteralType.verify(message.targetType);
                        if (error)
                            return "targetType." + error;
                    }
                    return null;
                };
    
                return UnionInfo;
            })();
    
            core.BindingData = (function() {
    
                /**
                 * Properties of a BindingData.
                 * @memberof flyteidl.core
                 * @interface IBindingData
                 * @property {flyteidl.core.IScalar|null} [scalar] BindingData scalar
                 * @property {flyteidl.core.IBindingDataCollection|null} [collection] BindingData collection
                 * @property {flyteidl.core.IOutputReference|null} [promise] BindingData promise
                 * @property {flyteidl.core.IBindingDataMap|null} [map] BindingData map
                 * @property {flyteidl.core.IUnionInfo|null} [union] BindingData union
                 */
    
                /**
                 * Constructs a new BindingData.
                 * @memberof flyteidl.core
                 * @classdesc Represents a BindingData.
                 * @implements IBindingData
                 * @constructor
                 * @param {flyteidl.core.IBindingData=} [properties] Properties to set
                 */
                function BindingData(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * BindingData scalar.
                 * @member {flyteidl.core.IScalar|null|undefined} scalar
                 * @memberof flyteidl.core.BindingData
                 * @instance
                 */
                BindingData.prototype.scalar = null;
    
                /**
                 * BindingData collection.
                 * @member {flyteidl.core.IBindingDataCollection|null|undefined} collection
                 * @memberof flyteidl.core.BindingData
                 * @instance
                 */
                BindingData.prototype.collection = null;
    
                /**
                 * BindingData promise.
                 * @member {flyteidl.core.IOutputReference|null|undefined} promise
                 * @memberof flyteidl.core.BindingData
                 * @instance
                 */
                BindingData.prototype.promise = null;
    
                /**
                 * BindingData map.
                 * @member {flyteidl.core.IBindingDataMap|null|undefined} map
                 * @memberof flyteidl.core.BindingData
                 * @instance
                 */
                BindingData.prototype.map = null;
    
                /**
                 * BindingData union.
                 * @member {flyteidl.core.IUnionInfo|null|undefined} union
                 * @memberof flyteidl.core.BindingData
                 * @instance
                 */
                BindingData.prototype.union = null;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * BindingData value.
                 * @member {"scalar"|"collection"|"promise"|"map"|undefined} value
                 * @memberof flyteidl.core.BindingData
                 * @instance
                 */
                Object.defineProperty(BindingData.prototype, "value", {
                    get: $util.oneOfGetter($oneOfFields = ["scalar", "collection", "promise", "map"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new BindingData instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.BindingData
                 * @static
                 * @param {flyteidl.core.IBindingData=} [properties] Properties to set
                 * @returns {flyteidl.core.BindingData} BindingData instance
                 */
                BindingData.create = function create(properties) {
                    return new BindingData(properties);
                };
    
                /**
                 * Encodes the specified BindingData message. Does not implicitly {@link flyteidl.core.BindingData.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.BindingData
                 * @static
                 * @param {flyteidl.core.IBindingData} message BindingData message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                BindingData.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.scalar != null && message.hasOwnProperty("scalar"))
                        $root.flyteidl.core.Scalar.encode(message.scalar, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.collection != null && message.hasOwnProperty("collection"))
                        $root.flyteidl.core.BindingDataCollection.encode(message.collection, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.promise != null && message.hasOwnProperty("promise"))
                        $root.flyteidl.core.OutputReference.encode(message.promise, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message.map != null && message.hasOwnProperty("map"))
                        $root.flyteidl.core.BindingDataMap.encode(message.map, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.union != null && message.hasOwnProperty("union"))
                        $root.flyteidl.core.UnionInfo.encode(message.union, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a BindingData message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.BindingData
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.BindingData} BindingData
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                BindingData.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.BindingData();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.scalar = $root.flyteidl.core.Scalar.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.collection = $root.flyteidl.core.BindingDataCollection.decode(reader, reader.uint32());
                            break;
                        case 3:
                            message.promise = $root.flyteidl.core.OutputReference.decode(reader, reader.uint32());
                            break;
                        case 4:
                            message.map = $root.flyteidl.core.BindingDataMap.decode(reader, reader.uint32());
                            break;
                        case 5:
                            message.union = $root.flyteidl.core.UnionInfo.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a BindingData message.
                 * @function verify
                 * @memberof flyteidl.core.BindingData
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                BindingData.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.scalar != null && message.hasOwnProperty("scalar")) {
                        properties.value = 1;
                        {
                            var error = $root.flyteidl.core.Scalar.verify(message.scalar);
                            if (error)
                                return "scalar." + error;
                        }
                    }
                    if (message.collection != null && message.hasOwnProperty("collection")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        {
                            var error = $root.flyteidl.core.BindingDataCollection.verify(message.collection);
                            if (error)
                                return "collection." + error;
                        }
                    }
                    if (message.promise != null && message.hasOwnProperty("promise")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        {
                            var error = $root.flyteidl.core.OutputReference.verify(message.promise);
                            if (error)
                                return "promise." + error;
                        }
                    }
                    if (message.map != null && message.hasOwnProperty("map")) {
                        if (properties.value === 1)
                            return "value: multiple values";
                        properties.value = 1;
                        {
                            var error = $root.flyteidl.core.BindingDataMap.verify(message.map);
                            if (error)
                                return "map." + error;
                        }
                    }
                    if (message.union != null && message.hasOwnProperty("union")) {
                        var error = $root.flyteidl.core.UnionInfo.verify(message.union);
                        if (error)
                            return "union." + error;
                    }
                    return null;
                };
    
                return BindingData;
            })();
    
            core.Binding = (function() {
    
                /**
                 * Properties of a Binding.
                 * @memberof flyteidl.core
                 * @interface IBinding
                 * @property {string|null} ["var"] Binding var
                 * @property {flyteidl.core.IBindingData|null} [binding] Binding binding
                 */
    
                /**
                 * Constructs a new Binding.
                 * @memberof flyteidl.core
                 * @classdesc Represents a Binding.
                 * @implements IBinding
                 * @constructor
                 * @param {flyteidl.core.IBinding=} [properties] Properties to set
                 */
                function Binding(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Binding var.
                 * @member {string} var
                 * @memberof flyteidl.core.Binding
                 * @instance
                 */
                Binding.prototype["var"] = "";
    
                /**
                 * Binding binding.
                 * @member {flyteidl.core.IBindingData|null|undefined} binding
                 * @memberof flyteidl.core.Binding
                 * @instance
                 */
                Binding.prototype.binding = null;
    
                /**
                 * Creates a new Binding instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Binding
                 * @static
                 * @param {flyteidl.core.IBinding=} [properties] Properties to set
                 * @returns {flyteidl.core.Binding} Binding instance
                 */
                Binding.create = function create(properties) {
                    return new Binding(properties);
                };
    
                /**
                 * Encodes the specified Binding message. Does not implicitly {@link flyteidl.core.Binding.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Binding
                 * @static
                 * @param {flyteidl.core.IBinding} message Binding message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Binding.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message["var"] != null && message.hasOwnProperty("var"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message["var"]);
                    if (message.binding != null && message.hasOwnProperty("binding"))
                        $root.flyteidl.core.BindingData.encode(message.binding, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a Binding message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Binding
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Binding} Binding
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Binding.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Binding();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message["var"] = reader.string();
                            break;
                        case 2:
                            message.binding = $root.flyteidl.core.BindingData.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a Binding message.
                 * @function verify
                 * @memberof flyteidl.core.Binding
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Binding.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message["var"] != null && message.hasOwnProperty("var"))
                        if (!$util.isString(message["var"]))
                            return "var: string expected";
                    if (message.binding != null && message.hasOwnProperty("binding")) {
                        var error = $root.flyteidl.core.BindingData.verify(message.binding);
                        if (error)
                            return "binding." + error;
                    }
                    return null;
                };
    
                return Binding;
            })();
    
            core.KeyValuePair = (function() {
    
                /**
                 * Properties of a KeyValuePair.
                 * @memberof flyteidl.core
                 * @interface IKeyValuePair
                 * @property {string|null} [key] KeyValuePair key
                 * @property {string|null} [value] KeyValuePair value
                 */
    
                /**
                 * Constructs a new KeyValuePair.
                 * @memberof flyteidl.core
                 * @classdesc Represents a KeyValuePair.
                 * @implements IKeyValuePair
                 * @constructor
                 * @param {flyteidl.core.IKeyValuePair=} [properties] Properties to set
                 */
                function KeyValuePair(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * KeyValuePair key.
                 * @member {string} key
                 * @memberof flyteidl.core.KeyValuePair
                 * @instance
                 */
                KeyValuePair.prototype.key = "";
    
                /**
                 * KeyValuePair value.
                 * @member {string} value
                 * @memberof flyteidl.core.KeyValuePair
                 * @instance
                 */
                KeyValuePair.prototype.value = "";
    
                /**
                 * Creates a new KeyValuePair instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.KeyValuePair
                 * @static
                 * @param {flyteidl.core.IKeyValuePair=} [properties] Properties to set
                 * @returns {flyteidl.core.KeyValuePair} KeyValuePair instance
                 */
                KeyValuePair.create = function create(properties) {
                    return new KeyValuePair(properties);
                };
    
                /**
                 * Encodes the specified KeyValuePair message. Does not implicitly {@link flyteidl.core.KeyValuePair.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.KeyValuePair
                 * @static
                 * @param {flyteidl.core.IKeyValuePair} message KeyValuePair message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                KeyValuePair.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.key != null && message.hasOwnProperty("key"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.key);
                    if (message.value != null && message.hasOwnProperty("value"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.value);
                    return writer;
                };
    
                /**
                 * Decodes a KeyValuePair message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.KeyValuePair
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.KeyValuePair} KeyValuePair
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                KeyValuePair.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.KeyValuePair();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.key = reader.string();
                            break;
                        case 2:
                            message.value = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a KeyValuePair message.
                 * @function verify
                 * @memberof flyteidl.core.KeyValuePair
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                KeyValuePair.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.key != null && message.hasOwnProperty("key"))
                        if (!$util.isString(message.key))
                            return "key: string expected";
                    if (message.value != null && message.hasOwnProperty("value"))
                        if (!$util.isString(message.value))
                            return "value: string expected";
                    return null;
                };
    
                return KeyValuePair;
            })();
    
            core.RetryStrategy = (function() {
    
                /**
                 * Properties of a RetryStrategy.
                 * @memberof flyteidl.core
                 * @interface IRetryStrategy
                 * @property {number|null} [retries] RetryStrategy retries
                 */
    
                /**
                 * Constructs a new RetryStrategy.
                 * @memberof flyteidl.core
                 * @classdesc Represents a RetryStrategy.
                 * @implements IRetryStrategy
                 * @constructor
                 * @param {flyteidl.core.IRetryStrategy=} [properties] Properties to set
                 */
                function RetryStrategy(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * RetryStrategy retries.
                 * @member {number} retries
                 * @memberof flyteidl.core.RetryStrategy
                 * @instance
                 */
                RetryStrategy.prototype.retries = 0;
    
                /**
                 * Creates a new RetryStrategy instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.RetryStrategy
                 * @static
                 * @param {flyteidl.core.IRetryStrategy=} [properties] Properties to set
                 * @returns {flyteidl.core.RetryStrategy} RetryStrategy instance
                 */
                RetryStrategy.create = function create(properties) {
                    return new RetryStrategy(properties);
                };
    
                /**
                 * Encodes the specified RetryStrategy message. Does not implicitly {@link flyteidl.core.RetryStrategy.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.RetryStrategy
                 * @static
                 * @param {flyteidl.core.IRetryStrategy} message RetryStrategy message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                RetryStrategy.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.retries != null && message.hasOwnProperty("retries"))
                        writer.uint32(/* id 5, wireType 0 =*/40).uint32(message.retries);
                    return writer;
                };
    
                /**
                 * Decodes a RetryStrategy message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.RetryStrategy
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.RetryStrategy} RetryStrategy
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                RetryStrategy.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.RetryStrategy();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 5:
                            message.retries = reader.uint32();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a RetryStrategy message.
                 * @function verify
                 * @memberof flyteidl.core.RetryStrategy
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                RetryStrategy.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.retries != null && message.hasOwnProperty("retries"))
                        if (!$util.isInteger(message.retries))
                            return "retries: integer expected";
                    return null;
                };
    
                return RetryStrategy;
            })();
    
            core.IfBlock = (function() {
    
                /**
                 * Properties of an IfBlock.
                 * @memberof flyteidl.core
                 * @interface IIfBlock
                 * @property {flyteidl.core.IBooleanExpression|null} [condition] IfBlock condition
                 * @property {flyteidl.core.INode|null} [thenNode] IfBlock thenNode
                 */
    
                /**
                 * Constructs a new IfBlock.
                 * @memberof flyteidl.core
                 * @classdesc Represents an IfBlock.
                 * @implements IIfBlock
                 * @constructor
                 * @param {flyteidl.core.IIfBlock=} [properties] Properties to set
                 */
                function IfBlock(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * IfBlock condition.
                 * @member {flyteidl.core.IBooleanExpression|null|undefined} condition
                 * @memberof flyteidl.core.IfBlock
                 * @instance
                 */
                IfBlock.prototype.condition = null;
    
                /**
                 * IfBlock thenNode.
                 * @member {flyteidl.core.INode|null|undefined} thenNode
                 * @memberof flyteidl.core.IfBlock
                 * @instance
                 */
                IfBlock.prototype.thenNode = null;
    
                /**
                 * Creates a new IfBlock instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.IfBlock
                 * @static
                 * @param {flyteidl.core.IIfBlock=} [properties] Properties to set
                 * @returns {flyteidl.core.IfBlock} IfBlock instance
                 */
                IfBlock.create = function create(properties) {
                    return new IfBlock(properties);
                };
    
                /**
                 * Encodes the specified IfBlock message. Does not implicitly {@link flyteidl.core.IfBlock.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.IfBlock
                 * @static
                 * @param {flyteidl.core.IIfBlock} message IfBlock message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                IfBlock.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.condition != null && message.hasOwnProperty("condition"))
                        $root.flyteidl.core.BooleanExpression.encode(message.condition, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.thenNode != null && message.hasOwnProperty("thenNode"))
                        $root.flyteidl.core.Node.encode(message.thenNode, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes an IfBlock message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.IfBlock
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.IfBlock} IfBlock
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                IfBlock.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.IfBlock();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.condition = $root.flyteidl.core.BooleanExpression.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.thenNode = $root.flyteidl.core.Node.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an IfBlock message.
                 * @function verify
                 * @memberof flyteidl.core.IfBlock
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                IfBlock.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.condition != null && message.hasOwnProperty("condition")) {
                        var error = $root.flyteidl.core.BooleanExpression.verify(message.condition);
                        if (error)
                            return "condition." + error;
                    }
                    if (message.thenNode != null && message.hasOwnProperty("thenNode")) {
                        var error = $root.flyteidl.core.Node.verify(message.thenNode);
                        if (error)
                            return "thenNode." + error;
                    }
                    return null;
                };
    
                return IfBlock;
            })();
    
            core.IfElseBlock = (function() {
    
                /**
                 * Properties of an IfElseBlock.
                 * @memberof flyteidl.core
                 * @interface IIfElseBlock
                 * @property {flyteidl.core.IIfBlock|null} ["case"] IfElseBlock case
                 * @property {Array.<flyteidl.core.IIfBlock>|null} [other] IfElseBlock other
                 * @property {flyteidl.core.INode|null} [elseNode] IfElseBlock elseNode
                 * @property {flyteidl.core.IError|null} [error] IfElseBlock error
                 */
    
                /**
                 * Constructs a new IfElseBlock.
                 * @memberof flyteidl.core
                 * @classdesc Represents an IfElseBlock.
                 * @implements IIfElseBlock
                 * @constructor
                 * @param {flyteidl.core.IIfElseBlock=} [properties] Properties to set
                 */
                function IfElseBlock(properties) {
                    this.other = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * IfElseBlock case.
                 * @member {flyteidl.core.IIfBlock|null|undefined} case
                 * @memberof flyteidl.core.IfElseBlock
                 * @instance
                 */
                IfElseBlock.prototype["case"] = null;
    
                /**
                 * IfElseBlock other.
                 * @member {Array.<flyteidl.core.IIfBlock>} other
                 * @memberof flyteidl.core.IfElseBlock
                 * @instance
                 */
                IfElseBlock.prototype.other = $util.emptyArray;
    
                /**
                 * IfElseBlock elseNode.
                 * @member {flyteidl.core.INode|null|undefined} elseNode
                 * @memberof flyteidl.core.IfElseBlock
                 * @instance
                 */
                IfElseBlock.prototype.elseNode = null;
    
                /**
                 * IfElseBlock error.
                 * @member {flyteidl.core.IError|null|undefined} error
                 * @memberof flyteidl.core.IfElseBlock
                 * @instance
                 */
                IfElseBlock.prototype.error = null;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * IfElseBlock default.
                 * @member {"elseNode"|"error"|undefined} default_
                 * @memberof flyteidl.core.IfElseBlock
                 * @instance
                 */
                Object.defineProperty(IfElseBlock.prototype, "default", {
                    get: $util.oneOfGetter($oneOfFields = ["elseNode", "error"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new IfElseBlock instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.IfElseBlock
                 * @static
                 * @param {flyteidl.core.IIfElseBlock=} [properties] Properties to set
                 * @returns {flyteidl.core.IfElseBlock} IfElseBlock instance
                 */
                IfElseBlock.create = function create(properties) {
                    return new IfElseBlock(properties);
                };
    
                /**
                 * Encodes the specified IfElseBlock message. Does not implicitly {@link flyteidl.core.IfElseBlock.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.IfElseBlock
                 * @static
                 * @param {flyteidl.core.IIfElseBlock} message IfElseBlock message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                IfElseBlock.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message["case"] != null && message.hasOwnProperty("case"))
                        $root.flyteidl.core.IfBlock.encode(message["case"], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.other != null && message.other.length)
                        for (var i = 0; i < message.other.length; ++i)
                            $root.flyteidl.core.IfBlock.encode(message.other[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.elseNode != null && message.hasOwnProperty("elseNode"))
                        $root.flyteidl.core.Node.encode(message.elseNode, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message.error != null && message.hasOwnProperty("error"))
                        $root.flyteidl.core.Error.encode(message.error, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes an IfElseBlock message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.IfElseBlock
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.IfElseBlock} IfElseBlock
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                IfElseBlock.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.IfElseBlock();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message["case"] = $root.flyteidl.core.IfBlock.decode(reader, reader.uint32());
                            break;
                        case 2:
                            if (!(message.other && message.other.length))
                                message.other = [];
                            message.other.push($root.flyteidl.core.IfBlock.decode(reader, reader.uint32()));
                            break;
                        case 3:
                            message.elseNode = $root.flyteidl.core.Node.decode(reader, reader.uint32());
                            break;
                        case 4:
                            message.error = $root.flyteidl.core.Error.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an IfElseBlock message.
                 * @function verify
                 * @memberof flyteidl.core.IfElseBlock
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                IfElseBlock.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message["case"] != null && message.hasOwnProperty("case")) {
                        var error = $root.flyteidl.core.IfBlock.verify(message["case"]);
                        if (error)
                            return "case." + error;
                    }
                    if (message.other != null && message.hasOwnProperty("other")) {
                        if (!Array.isArray(message.other))
                            return "other: array expected";
                        for (var i = 0; i < message.other.length; ++i) {
                            var error = $root.flyteidl.core.IfBlock.verify(message.other[i]);
                            if (error)
                                return "other." + error;
                        }
                    }
                    if (message.elseNode != null && message.hasOwnProperty("elseNode")) {
                        properties["default"] = 1;
                        {
                            var error = $root.flyteidl.core.Node.verify(message.elseNode);
                            if (error)
                                return "elseNode." + error;
                        }
                    }
                    if (message.error != null && message.hasOwnProperty("error")) {
                        if (properties["default"] === 1)
                            return "default: multiple values";
                        properties["default"] = 1;
                        {
                            var error = $root.flyteidl.core.Error.verify(message.error);
                            if (error)
                                return "error." + error;
                        }
                    }
                    return null;
                };
    
                return IfElseBlock;
            })();
    
            core.BranchNode = (function() {
    
                /**
                 * Properties of a BranchNode.
                 * @memberof flyteidl.core
                 * @interface IBranchNode
                 * @property {flyteidl.core.IIfElseBlock|null} [ifElse] BranchNode ifElse
                 */
    
                /**
                 * Constructs a new BranchNode.
                 * @memberof flyteidl.core
                 * @classdesc Represents a BranchNode.
                 * @implements IBranchNode
                 * @constructor
                 * @param {flyteidl.core.IBranchNode=} [properties] Properties to set
                 */
                function BranchNode(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * BranchNode ifElse.
                 * @member {flyteidl.core.IIfElseBlock|null|undefined} ifElse
                 * @memberof flyteidl.core.BranchNode
                 * @instance
                 */
                BranchNode.prototype.ifElse = null;
    
                /**
                 * Creates a new BranchNode instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.BranchNode
                 * @static
                 * @param {flyteidl.core.IBranchNode=} [properties] Properties to set
                 * @returns {flyteidl.core.BranchNode} BranchNode instance
                 */
                BranchNode.create = function create(properties) {
                    return new BranchNode(properties);
                };
    
                /**
                 * Encodes the specified BranchNode message. Does not implicitly {@link flyteidl.core.BranchNode.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.BranchNode
                 * @static
                 * @param {flyteidl.core.IBranchNode} message BranchNode message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                BranchNode.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.ifElse != null && message.hasOwnProperty("ifElse"))
                        $root.flyteidl.core.IfElseBlock.encode(message.ifElse, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a BranchNode message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.BranchNode
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.BranchNode} BranchNode
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                BranchNode.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.BranchNode();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.ifElse = $root.flyteidl.core.IfElseBlock.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a BranchNode message.
                 * @function verify
                 * @memberof flyteidl.core.BranchNode
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                BranchNode.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.ifElse != null && message.hasOwnProperty("ifElse")) {
                        var error = $root.flyteidl.core.IfElseBlock.verify(message.ifElse);
                        if (error)
                            return "ifElse." + error;
                    }
                    return null;
                };
    
                return BranchNode;
            })();
    
            core.TaskNode = (function() {
    
                /**
                 * Properties of a TaskNode.
                 * @memberof flyteidl.core
                 * @interface ITaskNode
                 * @property {flyteidl.core.IIdentifier|null} [referenceId] TaskNode referenceId
                 * @property {flyteidl.core.ITaskNodeOverrides|null} [overrides] TaskNode overrides
                 */
    
                /**
                 * Constructs a new TaskNode.
                 * @memberof flyteidl.core
                 * @classdesc Represents a TaskNode.
                 * @implements ITaskNode
                 * @constructor
                 * @param {flyteidl.core.ITaskNode=} [properties] Properties to set
                 */
                function TaskNode(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * TaskNode referenceId.
                 * @member {flyteidl.core.IIdentifier|null|undefined} referenceId
                 * @memberof flyteidl.core.TaskNode
                 * @instance
                 */
                TaskNode.prototype.referenceId = null;
    
                /**
                 * TaskNode overrides.
                 * @member {flyteidl.core.ITaskNodeOverrides|null|undefined} overrides
                 * @memberof flyteidl.core.TaskNode
                 * @instance
                 */
                TaskNode.prototype.overrides = null;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * TaskNode reference.
                 * @member {"referenceId"|undefined} reference
                 * @memberof flyteidl.core.TaskNode
                 * @instance
                 */
                Object.defineProperty(TaskNode.prototype, "reference", {
                    get: $util.oneOfGetter($oneOfFields = ["referenceId"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new TaskNode instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.TaskNode
                 * @static
                 * @param {flyteidl.core.ITaskNode=} [properties] Properties to set
                 * @returns {flyteidl.core.TaskNode} TaskNode instance
                 */
                TaskNode.create = function create(properties) {
                    return new TaskNode(properties);
                };
    
                /**
                 * Encodes the specified TaskNode message. Does not implicitly {@link flyteidl.core.TaskNode.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.TaskNode
                 * @static
                 * @param {flyteidl.core.ITaskNode} message TaskNode message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TaskNode.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.referenceId != null && message.hasOwnProperty("referenceId"))
                        $root.flyteidl.core.Identifier.encode(message.referenceId, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.overrides != null && message.hasOwnProperty("overrides"))
                        $root.flyteidl.core.TaskNodeOverrides.encode(message.overrides, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a TaskNode message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.TaskNode
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.TaskNode} TaskNode
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TaskNode.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.TaskNode();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.referenceId = $root.flyteidl.core.Identifier.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.overrides = $root.flyteidl.core.TaskNodeOverrides.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a TaskNode message.
                 * @function verify
                 * @memberof flyteidl.core.TaskNode
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TaskNode.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.referenceId != null && message.hasOwnProperty("referenceId")) {
                        properties.reference = 1;
                        {
                            var error = $root.flyteidl.core.Identifier.verify(message.referenceId);
                            if (error)
                                return "referenceId." + error;
                        }
                    }
                    if (message.overrides != null && message.hasOwnProperty("overrides")) {
                        var error = $root.flyteidl.core.TaskNodeOverrides.verify(message.overrides);
                        if (error)
                            return "overrides." + error;
                    }
                    return null;
                };
    
                return TaskNode;
            })();
    
            core.WorkflowNode = (function() {
    
                /**
                 * Properties of a WorkflowNode.
                 * @memberof flyteidl.core
                 * @interface IWorkflowNode
                 * @property {flyteidl.core.IIdentifier|null} [launchplanRef] WorkflowNode launchplanRef
                 * @property {flyteidl.core.IIdentifier|null} [subWorkflowRef] WorkflowNode subWorkflowRef
                 */
    
                /**
                 * Constructs a new WorkflowNode.
                 * @memberof flyteidl.core
                 * @classdesc Represents a WorkflowNode.
                 * @implements IWorkflowNode
                 * @constructor
                 * @param {flyteidl.core.IWorkflowNode=} [properties] Properties to set
                 */
                function WorkflowNode(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * WorkflowNode launchplanRef.
                 * @member {flyteidl.core.IIdentifier|null|undefined} launchplanRef
                 * @memberof flyteidl.core.WorkflowNode
                 * @instance
                 */
                WorkflowNode.prototype.launchplanRef = null;
    
                /**
                 * WorkflowNode subWorkflowRef.
                 * @member {flyteidl.core.IIdentifier|null|undefined} subWorkflowRef
                 * @memberof flyteidl.core.WorkflowNode
                 * @instance
                 */
                WorkflowNode.prototype.subWorkflowRef = null;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * WorkflowNode reference.
                 * @member {"launchplanRef"|"subWorkflowRef"|undefined} reference
                 * @memberof flyteidl.core.WorkflowNode
                 * @instance
                 */
                Object.defineProperty(WorkflowNode.prototype, "reference", {
                    get: $util.oneOfGetter($oneOfFields = ["launchplanRef", "subWorkflowRef"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new WorkflowNode instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.WorkflowNode
                 * @static
                 * @param {flyteidl.core.IWorkflowNode=} [properties] Properties to set
                 * @returns {flyteidl.core.WorkflowNode} WorkflowNode instance
                 */
                WorkflowNode.create = function create(properties) {
                    return new WorkflowNode(properties);
                };
    
                /**
                 * Encodes the specified WorkflowNode message. Does not implicitly {@link flyteidl.core.WorkflowNode.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.WorkflowNode
                 * @static
                 * @param {flyteidl.core.IWorkflowNode} message WorkflowNode message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                WorkflowNode.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.launchplanRef != null && message.hasOwnProperty("launchplanRef"))
                        $root.flyteidl.core.Identifier.encode(message.launchplanRef, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.subWorkflowRef != null && message.hasOwnProperty("subWorkflowRef"))
                        $root.flyteidl.core.Identifier.encode(message.subWorkflowRef, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a WorkflowNode message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.WorkflowNode
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.WorkflowNode} WorkflowNode
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                WorkflowNode.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.WorkflowNode();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.launchplanRef = $root.flyteidl.core.Identifier.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.subWorkflowRef = $root.flyteidl.core.Identifier.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a WorkflowNode message.
                 * @function verify
                 * @memberof flyteidl.core.WorkflowNode
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                WorkflowNode.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.launchplanRef != null && message.hasOwnProperty("launchplanRef")) {
                        properties.reference = 1;
                        {
                            var error = $root.flyteidl.core.Identifier.verify(message.launchplanRef);
                            if (error)
                                return "launchplanRef." + error;
                        }
                    }
                    if (message.subWorkflowRef != null && message.hasOwnProperty("subWorkflowRef")) {
                        if (properties.reference === 1)
                            return "reference: multiple values";
                        properties.reference = 1;
                        {
                            var error = $root.flyteidl.core.Identifier.verify(message.subWorkflowRef);
                            if (error)
                                return "subWorkflowRef." + error;
                        }
                    }
                    return null;
                };
    
                return WorkflowNode;
            })();
    
            core.ApproveCondition = (function() {
    
                /**
                 * Properties of an ApproveCondition.
                 * @memberof flyteidl.core
                 * @interface IApproveCondition
                 * @property {string|null} [signalId] ApproveCondition signalId
                 */
    
                /**
                 * Constructs a new ApproveCondition.
                 * @memberof flyteidl.core
                 * @classdesc Represents an ApproveCondition.
                 * @implements IApproveCondition
                 * @constructor
                 * @param {flyteidl.core.IApproveCondition=} [properties] Properties to set
                 */
                function ApproveCondition(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * ApproveCondition signalId.
                 * @member {string} signalId
                 * @memberof flyteidl.core.ApproveCondition
                 * @instance
                 */
                ApproveCondition.prototype.signalId = "";
    
                /**
                 * Creates a new ApproveCondition instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.ApproveCondition
                 * @static
                 * @param {flyteidl.core.IApproveCondition=} [properties] Properties to set
                 * @returns {flyteidl.core.ApproveCondition} ApproveCondition instance
                 */
                ApproveCondition.create = function create(properties) {
                    return new ApproveCondition(properties);
                };
    
                /**
                 * Encodes the specified ApproveCondition message. Does not implicitly {@link flyteidl.core.ApproveCondition.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.ApproveCondition
                 * @static
                 * @param {flyteidl.core.IApproveCondition} message ApproveCondition message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ApproveCondition.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.signalId != null && message.hasOwnProperty("signalId"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.signalId);
                    return writer;
                };
    
                /**
                 * Decodes an ApproveCondition message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.ApproveCondition
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.ApproveCondition} ApproveCondition
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ApproveCondition.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.ApproveCondition();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.signalId = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an ApproveCondition message.
                 * @function verify
                 * @memberof flyteidl.core.ApproveCondition
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ApproveCondition.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.signalId != null && message.hasOwnProperty("signalId"))
                        if (!$util.isString(message.signalId))
                            return "signalId: string expected";
                    return null;
                };
    
                return ApproveCondition;
            })();
    
            core.SignalCondition = (function() {
    
                /**
                 * Properties of a SignalCondition.
                 * @memberof flyteidl.core
                 * @interface ISignalCondition
                 * @property {string|null} [signalId] SignalCondition signalId
                 * @property {flyteidl.core.ILiteralType|null} [type] SignalCondition type
                 * @property {string|null} [outputVariableName] SignalCondition outputVariableName
                 */
    
                /**
                 * Constructs a new SignalCondition.
                 * @memberof flyteidl.core
                 * @classdesc Represents a SignalCondition.
                 * @implements ISignalCondition
                 * @constructor
                 * @param {flyteidl.core.ISignalCondition=} [properties] Properties to set
                 */
                function SignalCondition(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * SignalCondition signalId.
                 * @member {string} signalId
                 * @memberof flyteidl.core.SignalCondition
                 * @instance
                 */
                SignalCondition.prototype.signalId = "";
    
                /**
                 * SignalCondition type.
                 * @member {flyteidl.core.ILiteralType|null|undefined} type
                 * @memberof flyteidl.core.SignalCondition
                 * @instance
                 */
                SignalCondition.prototype.type = null;
    
                /**
                 * SignalCondition outputVariableName.
                 * @member {string} outputVariableName
                 * @memberof flyteidl.core.SignalCondition
                 * @instance
                 */
                SignalCondition.prototype.outputVariableName = "";
    
                /**
                 * Creates a new SignalCondition instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.SignalCondition
                 * @static
                 * @param {flyteidl.core.ISignalCondition=} [properties] Properties to set
                 * @returns {flyteidl.core.SignalCondition} SignalCondition instance
                 */
                SignalCondition.create = function create(properties) {
                    return new SignalCondition(properties);
                };
    
                /**
                 * Encodes the specified SignalCondition message. Does not implicitly {@link flyteidl.core.SignalCondition.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.SignalCondition
                 * @static
                 * @param {flyteidl.core.ISignalCondition} message SignalCondition message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                SignalCondition.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.signalId != null && message.hasOwnProperty("signalId"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.signalId);
                    if (message.type != null && message.hasOwnProperty("type"))
                        $root.flyteidl.core.LiteralType.encode(message.type, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.outputVariableName != null && message.hasOwnProperty("outputVariableName"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.outputVariableName);
                    return writer;
                };
    
                /**
                 * Decodes a SignalCondition message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.SignalCondition
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.SignalCondition} SignalCondition
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                SignalCondition.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.SignalCondition();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.signalId = reader.string();
                            break;
                        case 2:
                            message.type = $root.flyteidl.core.LiteralType.decode(reader, reader.uint32());
                            break;
                        case 3:
                            message.outputVariableName = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a SignalCondition message.
                 * @function verify
                 * @memberof flyteidl.core.SignalCondition
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                SignalCondition.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.signalId != null && message.hasOwnProperty("signalId"))
                        if (!$util.isString(message.signalId))
                            return "signalId: string expected";
                    if (message.type != null && message.hasOwnProperty("type")) {
                        var error = $root.flyteidl.core.LiteralType.verify(message.type);
                        if (error)
                            return "type." + error;
                    }
                    if (message.outputVariableName != null && message.hasOwnProperty("outputVariableName"))
                        if (!$util.isString(message.outputVariableName))
                            return "outputVariableName: string expected";
                    return null;
                };
    
                return SignalCondition;
            })();
    
            core.SleepCondition = (function() {
    
                /**
                 * Properties of a SleepCondition.
                 * @memberof flyteidl.core
                 * @interface ISleepCondition
                 * @property {google.protobuf.IDuration|null} [duration] SleepCondition duration
                 */
    
                /**
                 * Constructs a new SleepCondition.
                 * @memberof flyteidl.core
                 * @classdesc Represents a SleepCondition.
                 * @implements ISleepCondition
                 * @constructor
                 * @param {flyteidl.core.ISleepCondition=} [properties] Properties to set
                 */
                function SleepCondition(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * SleepCondition duration.
                 * @member {google.protobuf.IDuration|null|undefined} duration
                 * @memberof flyteidl.core.SleepCondition
                 * @instance
                 */
                SleepCondition.prototype.duration = null;
    
                /**
                 * Creates a new SleepCondition instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.SleepCondition
                 * @static
                 * @param {flyteidl.core.ISleepCondition=} [properties] Properties to set
                 * @returns {flyteidl.core.SleepCondition} SleepCondition instance
                 */
                SleepCondition.create = function create(properties) {
                    return new SleepCondition(properties);
                };
    
                /**
                 * Encodes the specified SleepCondition message. Does not implicitly {@link flyteidl.core.SleepCondition.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.SleepCondition
                 * @static
                 * @param {flyteidl.core.ISleepCondition} message SleepCondition message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                SleepCondition.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.duration != null && message.hasOwnProperty("duration"))
                        $root.google.protobuf.Duration.encode(message.duration, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a SleepCondition message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.SleepCondition
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.SleepCondition} SleepCondition
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                SleepCondition.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.SleepCondition();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.duration = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a SleepCondition message.
                 * @function verify
                 * @memberof flyteidl.core.SleepCondition
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                SleepCondition.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.duration != null && message.hasOwnProperty("duration")) {
                        var error = $root.google.protobuf.Duration.verify(message.duration);
                        if (error)
                            return "duration." + error;
                    }
                    return null;
                };
    
                return SleepCondition;
            })();
    
            core.GateNode = (function() {
    
                /**
                 * Properties of a GateNode.
                 * @memberof flyteidl.core
                 * @interface IGateNode
                 * @property {flyteidl.core.IApproveCondition|null} [approve] GateNode approve
                 * @property {flyteidl.core.ISignalCondition|null} [signal] GateNode signal
                 * @property {flyteidl.core.ISleepCondition|null} [sleep] GateNode sleep
                 */
    
                /**
                 * Constructs a new GateNode.
                 * @memberof flyteidl.core
                 * @classdesc Represents a GateNode.
                 * @implements IGateNode
                 * @constructor
                 * @param {flyteidl.core.IGateNode=} [properties] Properties to set
                 */
                function GateNode(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * GateNode approve.
                 * @member {flyteidl.core.IApproveCondition|null|undefined} approve
                 * @memberof flyteidl.core.GateNode
                 * @instance
                 */
                GateNode.prototype.approve = null;
    
                /**
                 * GateNode signal.
                 * @member {flyteidl.core.ISignalCondition|null|undefined} signal
                 * @memberof flyteidl.core.GateNode
                 * @instance
                 */
                GateNode.prototype.signal = null;
    
                /**
                 * GateNode sleep.
                 * @member {flyteidl.core.ISleepCondition|null|undefined} sleep
                 * @memberof flyteidl.core.GateNode
                 * @instance
                 */
                GateNode.prototype.sleep = null;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * GateNode condition.
                 * @member {"approve"|"signal"|"sleep"|undefined} condition
                 * @memberof flyteidl.core.GateNode
                 * @instance
                 */
                Object.defineProperty(GateNode.prototype, "condition", {
                    get: $util.oneOfGetter($oneOfFields = ["approve", "signal", "sleep"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new GateNode instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.GateNode
                 * @static
                 * @param {flyteidl.core.IGateNode=} [properties] Properties to set
                 * @returns {flyteidl.core.GateNode} GateNode instance
                 */
                GateNode.create = function create(properties) {
                    return new GateNode(properties);
                };
    
                /**
                 * Encodes the specified GateNode message. Does not implicitly {@link flyteidl.core.GateNode.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.GateNode
                 * @static
                 * @param {flyteidl.core.IGateNode} message GateNode message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                GateNode.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.approve != null && message.hasOwnProperty("approve"))
                        $root.flyteidl.core.ApproveCondition.encode(message.approve, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.signal != null && message.hasOwnProperty("signal"))
                        $root.flyteidl.core.SignalCondition.encode(message.signal, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.sleep != null && message.hasOwnProperty("sleep"))
                        $root.flyteidl.core.SleepCondition.encode(message.sleep, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a GateNode message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.GateNode
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.GateNode} GateNode
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                GateNode.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.GateNode();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.approve = $root.flyteidl.core.ApproveCondition.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.signal = $root.flyteidl.core.SignalCondition.decode(reader, reader.uint32());
                            break;
                        case 3:
                            message.sleep = $root.flyteidl.core.SleepCondition.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a GateNode message.
                 * @function verify
                 * @memberof flyteidl.core.GateNode
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                GateNode.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.approve != null && message.hasOwnProperty("approve")) {
                        properties.condition = 1;
                        {
                            var error = $root.flyteidl.core.ApproveCondition.verify(message.approve);
                            if (error)
                                return "approve." + error;
                        }
                    }
                    if (message.signal != null && message.hasOwnProperty("signal")) {
                        if (properties.condition === 1)
                            return "condition: multiple values";
                        properties.condition = 1;
                        {
                            var error = $root.flyteidl.core.SignalCondition.verify(message.signal);
                            if (error)
                                return "signal." + error;
                        }
                    }
                    if (message.sleep != null && message.hasOwnProperty("sleep")) {
                        if (properties.condition === 1)
                            return "condition: multiple values";
                        properties.condition = 1;
                        {
                            var error = $root.flyteidl.core.SleepCondition.verify(message.sleep);
                            if (error)
                                return "sleep." + error;
                        }
                    }
                    return null;
                };
    
                return GateNode;
            })();
    
            core.ArrayNode = (function() {
    
                /**
                 * Properties of an ArrayNode.
                 * @memberof flyteidl.core
                 * @interface IArrayNode
                 * @property {flyteidl.core.INode|null} [node] ArrayNode node
                 * @property {number|null} [parallelism] ArrayNode parallelism
                 * @property {number|null} [minSuccesses] ArrayNode minSuccesses
                 * @property {number|null} [minSuccessRatio] ArrayNode minSuccessRatio
                 * @property {flyteidl.core.ArrayNode.ExecutionMode|null} [executionMode] ArrayNode executionMode
                 * @property {google.protobuf.IBoolValue|null} [isOriginalSubNodeInterface] ArrayNode isOriginalSubNodeInterface
                 */
    
                /**
                 * Constructs a new ArrayNode.
                 * @memberof flyteidl.core
                 * @classdesc Represents an ArrayNode.
                 * @implements IArrayNode
                 * @constructor
                 * @param {flyteidl.core.IArrayNode=} [properties] Properties to set
                 */
                function ArrayNode(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * ArrayNode node.
                 * @member {flyteidl.core.INode|null|undefined} node
                 * @memberof flyteidl.core.ArrayNode
                 * @instance
                 */
                ArrayNode.prototype.node = null;
    
                /**
                 * ArrayNode parallelism.
                 * @member {number} parallelism
                 * @memberof flyteidl.core.ArrayNode
                 * @instance
                 */
                ArrayNode.prototype.parallelism = 0;
    
                /**
                 * ArrayNode minSuccesses.
                 * @member {number} minSuccesses
                 * @memberof flyteidl.core.ArrayNode
                 * @instance
                 */
                ArrayNode.prototype.minSuccesses = 0;
    
                /**
                 * ArrayNode minSuccessRatio.
                 * @member {number} minSuccessRatio
                 * @memberof flyteidl.core.ArrayNode
                 * @instance
                 */
                ArrayNode.prototype.minSuccessRatio = 0;
    
                /**
                 * ArrayNode executionMode.
                 * @member {flyteidl.core.ArrayNode.ExecutionMode} executionMode
                 * @memberof flyteidl.core.ArrayNode
                 * @instance
                 */
                ArrayNode.prototype.executionMode = 0;
    
                /**
                 * ArrayNode isOriginalSubNodeInterface.
                 * @member {google.protobuf.IBoolValue|null|undefined} isOriginalSubNodeInterface
                 * @memberof flyteidl.core.ArrayNode
                 * @instance
                 */
                ArrayNode.prototype.isOriginalSubNodeInterface = null;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * ArrayNode parallelismOption.
                 * @member {"parallelism"|undefined} parallelismOption
                 * @memberof flyteidl.core.ArrayNode
                 * @instance
                 */
                Object.defineProperty(ArrayNode.prototype, "parallelismOption", {
                    get: $util.oneOfGetter($oneOfFields = ["parallelism"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * ArrayNode successCriteria.
                 * @member {"minSuccesses"|"minSuccessRatio"|undefined} successCriteria
                 * @memberof flyteidl.core.ArrayNode
                 * @instance
                 */
                Object.defineProperty(ArrayNode.prototype, "successCriteria", {
                    get: $util.oneOfGetter($oneOfFields = ["minSuccesses", "minSuccessRatio"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new ArrayNode instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.ArrayNode
                 * @static
                 * @param {flyteidl.core.IArrayNode=} [properties] Properties to set
                 * @returns {flyteidl.core.ArrayNode} ArrayNode instance
                 */
                ArrayNode.create = function create(properties) {
                    return new ArrayNode(properties);
                };
    
                /**
                 * Encodes the specified ArrayNode message. Does not implicitly {@link flyteidl.core.ArrayNode.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.ArrayNode
                 * @static
                 * @param {flyteidl.core.IArrayNode} message ArrayNode message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ArrayNode.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.node != null && message.hasOwnProperty("node"))
                        $root.flyteidl.core.Node.encode(message.node, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.parallelism != null && message.hasOwnProperty("parallelism"))
                        writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.parallelism);
                    if (message.minSuccesses != null && message.hasOwnProperty("minSuccesses"))
                        writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.minSuccesses);
                    if (message.minSuccessRatio != null && message.hasOwnProperty("minSuccessRatio"))
                        writer.uint32(/* id 4, wireType 5 =*/37).float(message.minSuccessRatio);
                    if (message.executionMode != null && message.hasOwnProperty("executionMode"))
                        writer.uint32(/* id 5, wireType 0 =*/40).int32(message.executionMode);
                    if (message.isOriginalSubNodeInterface != null && message.hasOwnProperty("isOriginalSubNodeInterface"))
                        $root.google.protobuf.BoolValue.encode(message.isOriginalSubNodeInterface, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes an ArrayNode message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.ArrayNode
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.ArrayNode} ArrayNode
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ArrayNode.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.ArrayNode();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.node = $root.flyteidl.core.Node.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.parallelism = reader.uint32();
                            break;
                        case 3:
                            message.minSuccesses = reader.uint32();
                            break;
                        case 4:
                            message.minSuccessRatio = reader.float();
                            break;
                        case 5:
                            message.executionMode = reader.int32();
                            break;
                        case 6:
                            message.isOriginalSubNodeInterface = $root.google.protobuf.BoolValue.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an ArrayNode message.
                 * @function verify
                 * @memberof flyteidl.core.ArrayNode
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ArrayNode.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.node != null && message.hasOwnProperty("node")) {
                        var error = $root.flyteidl.core.Node.verify(message.node);
                        if (error)
                            return "node." + error;
                    }
                    if (message.parallelism != null && message.hasOwnProperty("parallelism")) {
                        properties.parallelismOption = 1;
                        if (!$util.isInteger(message.parallelism))
                            return "parallelism: integer expected";
                    }
                    if (message.minSuccesses != null && message.hasOwnProperty("minSuccesses")) {
                        properties.successCriteria = 1;
                        if (!$util.isInteger(message.minSuccesses))
                            return "minSuccesses: integer expected";
                    }
                    if (message.minSuccessRatio != null && message.hasOwnProperty("minSuccessRatio")) {
                        if (properties.successCriteria === 1)
                            return "successCriteria: multiple values";
                        properties.successCriteria = 1;
                        if (typeof message.minSuccessRatio !== "number")
                            return "minSuccessRatio: number expected";
                    }
                    if (message.executionMode != null && message.hasOwnProperty("executionMode"))
                        switch (message.executionMode) {
                        default:
                            return "executionMode: enum value expected";
                        case 0:
                        case 1:
                            break;
                        }
                    if (message.isOriginalSubNodeInterface != null && message.hasOwnProperty("isOriginalSubNodeInterface")) {
                        var error = $root.google.protobuf.BoolValue.verify(message.isOriginalSubNodeInterface);
                        if (error)
                            return "isOriginalSubNodeInterface." + error;
                    }
                    return null;
                };
    
                /**
                 * ExecutionMode enum.
                 * @name flyteidl.core.ArrayNode.ExecutionMode
                 * @enum {string}
                 * @property {number} MINIMAL_STATE=0 MINIMAL_STATE value
                 * @property {number} FULL_STATE=1 FULL_STATE value
                 */
                ArrayNode.ExecutionMode = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "MINIMAL_STATE"] = 0;
                    values[valuesById[1] = "FULL_STATE"] = 1;
                    return values;
                })();
    
                return ArrayNode;
            })();
    
            core.NodeMetadata = (function() {
    
                /**
                 * Properties of a NodeMetadata.
                 * @memberof flyteidl.core
                 * @interface INodeMetadata
                 * @property {string|null} [name] NodeMetadata name
                 * @property {google.protobuf.IDuration|null} [timeout] NodeMetadata timeout
                 * @property {flyteidl.core.IRetryStrategy|null} [retries] NodeMetadata retries
                 * @property {boolean|null} [interruptible] NodeMetadata interruptible
                 * @property {boolean|null} [cacheable] NodeMetadata cacheable
                 * @property {string|null} [cacheVersion] NodeMetadata cacheVersion
                 * @property {boolean|null} [cacheSerializable] NodeMetadata cacheSerializable
                 */
    
                /**
                 * Constructs a new NodeMetadata.
                 * @memberof flyteidl.core
                 * @classdesc Represents a NodeMetadata.
                 * @implements INodeMetadata
                 * @constructor
                 * @param {flyteidl.core.INodeMetadata=} [properties] Properties to set
                 */
                function NodeMetadata(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * NodeMetadata name.
                 * @member {string} name
                 * @memberof flyteidl.core.NodeMetadata
                 * @instance
                 */
                NodeMetadata.prototype.name = "";
    
                /**
                 * NodeMetadata timeout.
                 * @member {google.protobuf.IDuration|null|undefined} timeout
                 * @memberof flyteidl.core.NodeMetadata
                 * @instance
                 */
                NodeMetadata.prototype.timeout = null;
    
                /**
                 * NodeMetadata retries.
                 * @member {flyteidl.core.IRetryStrategy|null|undefined} retries
                 * @memberof flyteidl.core.NodeMetadata
                 * @instance
                 */
                NodeMetadata.prototype.retries = null;
    
                /**
                 * NodeMetadata interruptible.
                 * @member {boolean} interruptible
                 * @memberof flyteidl.core.NodeMetadata
                 * @instance
                 */
                NodeMetadata.prototype.interruptible = false;
    
                /**
                 * NodeMetadata cacheable.
                 * @member {boolean} cacheable
                 * @memberof flyteidl.core.NodeMetadata
                 * @instance
                 */
                NodeMetadata.prototype.cacheable = false;
    
                /**
                 * NodeMetadata cacheVersion.
                 * @member {string} cacheVersion
                 * @memberof flyteidl.core.NodeMetadata
                 * @instance
                 */
                NodeMetadata.prototype.cacheVersion = "";
    
                /**
                 * NodeMetadata cacheSerializable.
                 * @member {boolean} cacheSerializable
                 * @memberof flyteidl.core.NodeMetadata
                 * @instance
                 */
                NodeMetadata.prototype.cacheSerializable = false;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * NodeMetadata interruptibleValue.
                 * @member {"interruptible"|undefined} interruptibleValue
                 * @memberof flyteidl.core.NodeMetadata
                 * @instance
                 */
                Object.defineProperty(NodeMetadata.prototype, "interruptibleValue", {
                    get: $util.oneOfGetter($oneOfFields = ["interruptible"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * NodeMetadata cacheableValue.
                 * @member {"cacheable"|undefined} cacheableValue
                 * @memberof flyteidl.core.NodeMetadata
                 * @instance
                 */
                Object.defineProperty(NodeMetadata.prototype, "cacheableValue", {
                    get: $util.oneOfGetter($oneOfFields = ["cacheable"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * NodeMetadata cacheVersionValue.
                 * @member {"cacheVersion"|undefined} cacheVersionValue
                 * @memberof flyteidl.core.NodeMetadata
                 * @instance
                 */
                Object.defineProperty(NodeMetadata.prototype, "cacheVersionValue", {
                    get: $util.oneOfGetter($oneOfFields = ["cacheVersion"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * NodeMetadata cacheSerializableValue.
                 * @member {"cacheSerializable"|undefined} cacheSerializableValue
                 * @memberof flyteidl.core.NodeMetadata
                 * @instance
                 */
                Object.defineProperty(NodeMetadata.prototype, "cacheSerializableValue", {
                    get: $util.oneOfGetter($oneOfFields = ["cacheSerializable"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new NodeMetadata instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.NodeMetadata
                 * @static
                 * @param {flyteidl.core.INodeMetadata=} [properties] Properties to set
                 * @returns {flyteidl.core.NodeMetadata} NodeMetadata instance
                 */
                NodeMetadata.create = function create(properties) {
                    return new NodeMetadata(properties);
                };
    
                /**
                 * Encodes the specified NodeMetadata message. Does not implicitly {@link flyteidl.core.NodeMetadata.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.NodeMetadata
                 * @static
                 * @param {flyteidl.core.INodeMetadata} message NodeMetadata message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                NodeMetadata.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.name != null && message.hasOwnProperty("name"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                    if (message.timeout != null && message.hasOwnProperty("timeout"))
                        $root.google.protobuf.Duration.encode(message.timeout, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.retries != null && message.hasOwnProperty("retries"))
                        $root.flyteidl.core.RetryStrategy.encode(message.retries, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                    if (message.interruptible != null && message.hasOwnProperty("interruptible"))
                        writer.uint32(/* id 6, wireType 0 =*/48).bool(message.interruptible);
                    if (message.cacheable != null && message.hasOwnProperty("cacheable"))
                        writer.uint32(/* id 7, wireType 0 =*/56).bool(message.cacheable);
                    if (message.cacheVersion != null && message.hasOwnProperty("cacheVersion"))
                        writer.uint32(/* id 8, wireType 2 =*/66).string(message.cacheVersion);
                    if (message.cacheSerializable != null && message.hasOwnProperty("cacheSerializable"))
                        writer.uint32(/* id 9, wireType 0 =*/72).bool(message.cacheSerializable);
                    return writer;
                };
    
                /**
                 * Decodes a NodeMetadata message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.NodeMetadata
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.NodeMetadata} NodeMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                NodeMetadata.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.NodeMetadata();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.name = reader.string();
                            break;
                        case 4:
                            message.timeout = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                            break;
                        case 5:
                            message.retries = $root.flyteidl.core.RetryStrategy.decode(reader, reader.uint32());
                            break;
                        case 6:
                            message.interruptible = reader.bool();
                            break;
                        case 7:
                            message.cacheable = reader.bool();
                            break;
                        case 8:
                            message.cacheVersion = reader.string();
                            break;
                        case 9:
                            message.cacheSerializable = reader.bool();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a NodeMetadata message.
                 * @function verify
                 * @memberof flyteidl.core.NodeMetadata
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                NodeMetadata.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.name != null && message.hasOwnProperty("name"))
                        if (!$util.isString(message.name))
                            return "name: string expected";
                    if (message.timeout != null && message.hasOwnProperty("timeout")) {
                        var error = $root.google.protobuf.Duration.verify(message.timeout);
                        if (error)
                            return "timeout." + error;
                    }
                    if (message.retries != null && message.hasOwnProperty("retries")) {
                        var error = $root.flyteidl.core.RetryStrategy.verify(message.retries);
                        if (error)
                            return "retries." + error;
                    }
                    if (message.interruptible != null && message.hasOwnProperty("interruptible")) {
                        properties.interruptibleValue = 1;
                        if (typeof message.interruptible !== "boolean")
                            return "interruptible: boolean expected";
                    }
                    if (message.cacheable != null && message.hasOwnProperty("cacheable")) {
                        properties.cacheableValue = 1;
                        if (typeof message.cacheable !== "boolean")
                            return "cacheable: boolean expected";
                    }
                    if (message.cacheVersion != null && message.hasOwnProperty("cacheVersion")) {
                        properties.cacheVersionValue = 1;
                        if (!$util.isString(message.cacheVersion))
                            return "cacheVersion: string expected";
                    }
                    if (message.cacheSerializable != null && message.hasOwnProperty("cacheSerializable")) {
                        properties.cacheSerializableValue = 1;
                        if (typeof message.cacheSerializable !== "boolean")
                            return "cacheSerializable: boolean expected";
                    }
                    return null;
                };
    
                return NodeMetadata;
            })();
    
            core.Alias = (function() {
    
                /**
                 * Properties of an Alias.
                 * @memberof flyteidl.core
                 * @interface IAlias
                 * @property {string|null} ["var"] Alias var
                 * @property {string|null} [alias] Alias alias
                 */
    
                /**
                 * Constructs a new Alias.
                 * @memberof flyteidl.core
                 * @classdesc Represents an Alias.
                 * @implements IAlias
                 * @constructor
                 * @param {flyteidl.core.IAlias=} [properties] Properties to set
                 */
                function Alias(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Alias var.
                 * @member {string} var
                 * @memberof flyteidl.core.Alias
                 * @instance
                 */
                Alias.prototype["var"] = "";
    
                /**
                 * Alias alias.
                 * @member {string} alias
                 * @memberof flyteidl.core.Alias
                 * @instance
                 */
                Alias.prototype.alias = "";
    
                /**
                 * Creates a new Alias instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Alias
                 * @static
                 * @param {flyteidl.core.IAlias=} [properties] Properties to set
                 * @returns {flyteidl.core.Alias} Alias instance
                 */
                Alias.create = function create(properties) {
                    return new Alias(properties);
                };
    
                /**
                 * Encodes the specified Alias message. Does not implicitly {@link flyteidl.core.Alias.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Alias
                 * @static
                 * @param {flyteidl.core.IAlias} message Alias message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Alias.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message["var"] != null && message.hasOwnProperty("var"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message["var"]);
                    if (message.alias != null && message.hasOwnProperty("alias"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.alias);
                    return writer;
                };
    
                /**
                 * Decodes an Alias message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Alias
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Alias} Alias
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Alias.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Alias();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message["var"] = reader.string();
                            break;
                        case 2:
                            message.alias = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an Alias message.
                 * @function verify
                 * @memberof flyteidl.core.Alias
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Alias.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message["var"] != null && message.hasOwnProperty("var"))
                        if (!$util.isString(message["var"]))
                            return "var: string expected";
                    if (message.alias != null && message.hasOwnProperty("alias"))
                        if (!$util.isString(message.alias))
                            return "alias: string expected";
                    return null;
                };
    
                return Alias;
            })();
    
            core.Node = (function() {
    
                /**
                 * Properties of a Node.
                 * @memberof flyteidl.core
                 * @interface INode
                 * @property {string|null} [id] Node id
                 * @property {flyteidl.core.INodeMetadata|null} [metadata] Node metadata
                 * @property {Array.<flyteidl.core.IBinding>|null} [inputs] Node inputs
                 * @property {Array.<string>|null} [upstreamNodeIds] Node upstreamNodeIds
                 * @property {Array.<flyteidl.core.IAlias>|null} [outputAliases] Node outputAliases
                 * @property {flyteidl.core.ITaskNode|null} [taskNode] Node taskNode
                 * @property {flyteidl.core.IWorkflowNode|null} [workflowNode] Node workflowNode
                 * @property {flyteidl.core.IBranchNode|null} [branchNode] Node branchNode
                 * @property {flyteidl.core.IGateNode|null} [gateNode] Node gateNode
                 * @property {flyteidl.core.IArrayNode|null} [arrayNode] Node arrayNode
                 */
    
                /**
                 * Constructs a new Node.
                 * @memberof flyteidl.core
                 * @classdesc Represents a Node.
                 * @implements INode
                 * @constructor
                 * @param {flyteidl.core.INode=} [properties] Properties to set
                 */
                function Node(properties) {
                    this.inputs = [];
                    this.upstreamNodeIds = [];
                    this.outputAliases = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Node id.
                 * @member {string} id
                 * @memberof flyteidl.core.Node
                 * @instance
                 */
                Node.prototype.id = "";
    
                /**
                 * Node metadata.
                 * @member {flyteidl.core.INodeMetadata|null|undefined} metadata
                 * @memberof flyteidl.core.Node
                 * @instance
                 */
                Node.prototype.metadata = null;
    
                /**
                 * Node inputs.
                 * @member {Array.<flyteidl.core.IBinding>} inputs
                 * @memberof flyteidl.core.Node
                 * @instance
                 */
                Node.prototype.inputs = $util.emptyArray;
    
                /**
                 * Node upstreamNodeIds.
                 * @member {Array.<string>} upstreamNodeIds
                 * @memberof flyteidl.core.Node
                 * @instance
                 */
                Node.prototype.upstreamNodeIds = $util.emptyArray;
    
                /**
                 * Node outputAliases.
                 * @member {Array.<flyteidl.core.IAlias>} outputAliases
                 * @memberof flyteidl.core.Node
                 * @instance
                 */
                Node.prototype.outputAliases = $util.emptyArray;
    
                /**
                 * Node taskNode.
                 * @member {flyteidl.core.ITaskNode|null|undefined} taskNode
                 * @memberof flyteidl.core.Node
                 * @instance
                 */
                Node.prototype.taskNode = null;
    
                /**
                 * Node workflowNode.
                 * @member {flyteidl.core.IWorkflowNode|null|undefined} workflowNode
                 * @memberof flyteidl.core.Node
                 * @instance
                 */
                Node.prototype.workflowNode = null;
    
                /**
                 * Node branchNode.
                 * @member {flyteidl.core.IBranchNode|null|undefined} branchNode
                 * @memberof flyteidl.core.Node
                 * @instance
                 */
                Node.prototype.branchNode = null;
    
                /**
                 * Node gateNode.
                 * @member {flyteidl.core.IGateNode|null|undefined} gateNode
                 * @memberof flyteidl.core.Node
                 * @instance
                 */
                Node.prototype.gateNode = null;
    
                /**
                 * Node arrayNode.
                 * @member {flyteidl.core.IArrayNode|null|undefined} arrayNode
                 * @memberof flyteidl.core.Node
                 * @instance
                 */
                Node.prototype.arrayNode = null;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * Node target.
                 * @member {"taskNode"|"workflowNode"|"branchNode"|"gateNode"|"arrayNode"|undefined} target
                 * @memberof flyteidl.core.Node
                 * @instance
                 */
                Object.defineProperty(Node.prototype, "target", {
                    get: $util.oneOfGetter($oneOfFields = ["taskNode", "workflowNode", "branchNode", "gateNode", "arrayNode"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new Node instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Node
                 * @static
                 * @param {flyteidl.core.INode=} [properties] Properties to set
                 * @returns {flyteidl.core.Node} Node instance
                 */
                Node.create = function create(properties) {
                    return new Node(properties);
                };
    
                /**
                 * Encodes the specified Node message. Does not implicitly {@link flyteidl.core.Node.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Node
                 * @static
                 * @param {flyteidl.core.INode} message Node message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Node.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.id != null && message.hasOwnProperty("id"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.id);
                    if (message.metadata != null && message.hasOwnProperty("metadata"))
                        $root.flyteidl.core.NodeMetadata.encode(message.metadata, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.inputs != null && message.inputs.length)
                        for (var i = 0; i < message.inputs.length; ++i)
                            $root.flyteidl.core.Binding.encode(message.inputs[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message.upstreamNodeIds != null && message.upstreamNodeIds.length)
                        for (var i = 0; i < message.upstreamNodeIds.length; ++i)
                            writer.uint32(/* id 4, wireType 2 =*/34).string(message.upstreamNodeIds[i]);
                    if (message.outputAliases != null && message.outputAliases.length)
                        for (var i = 0; i < message.outputAliases.length; ++i)
                            $root.flyteidl.core.Alias.encode(message.outputAliases[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                    if (message.taskNode != null && message.hasOwnProperty("taskNode"))
                        $root.flyteidl.core.TaskNode.encode(message.taskNode, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                    if (message.workflowNode != null && message.hasOwnProperty("workflowNode"))
                        $root.flyteidl.core.WorkflowNode.encode(message.workflowNode, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                    if (message.branchNode != null && message.hasOwnProperty("branchNode"))
                        $root.flyteidl.core.BranchNode.encode(message.branchNode, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                    if (message.gateNode != null && message.hasOwnProperty("gateNode"))
                        $root.flyteidl.core.GateNode.encode(message.gateNode, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                    if (message.arrayNode != null && message.hasOwnProperty("arrayNode"))
                        $root.flyteidl.core.ArrayNode.encode(message.arrayNode, writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a Node message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Node
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Node} Node
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Node.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Node();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.id = reader.string();
                            break;
                        case 2:
                            message.metadata = $root.flyteidl.core.NodeMetadata.decode(reader, reader.uint32());
                            break;
                        case 3:
                            if (!(message.inputs && message.inputs.length))
                                message.inputs = [];
                            message.inputs.push($root.flyteidl.core.Binding.decode(reader, reader.uint32()));
                            break;
                        case 4:
                            if (!(message.upstreamNodeIds && message.upstreamNodeIds.length))
                                message.upstreamNodeIds = [];
                            message.upstreamNodeIds.push(reader.string());
                            break;
                        case 5:
                            if (!(message.outputAliases && message.outputAliases.length))
                                message.outputAliases = [];
                            message.outputAliases.push($root.flyteidl.core.Alias.decode(reader, reader.uint32()));
                            break;
                        case 6:
                            message.taskNode = $root.flyteidl.core.TaskNode.decode(reader, reader.uint32());
                            break;
                        case 7:
                            message.workflowNode = $root.flyteidl.core.WorkflowNode.decode(reader, reader.uint32());
                            break;
                        case 8:
                            message.branchNode = $root.flyteidl.core.BranchNode.decode(reader, reader.uint32());
                            break;
                        case 9:
                            message.gateNode = $root.flyteidl.core.GateNode.decode(reader, reader.uint32());
                            break;
                        case 10:
                            message.arrayNode = $root.flyteidl.core.ArrayNode.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a Node message.
                 * @function verify
                 * @memberof flyteidl.core.Node
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Node.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.id != null && message.hasOwnProperty("id"))
                        if (!$util.isString(message.id))
                            return "id: string expected";
                    if (message.metadata != null && message.hasOwnProperty("metadata")) {
                        var error = $root.flyteidl.core.NodeMetadata.verify(message.metadata);
                        if (error)
                            return "metadata." + error;
                    }
                    if (message.inputs != null && message.hasOwnProperty("inputs")) {
                        if (!Array.isArray(message.inputs))
                            return "inputs: array expected";
                        for (var i = 0; i < message.inputs.length; ++i) {
                            var error = $root.flyteidl.core.Binding.verify(message.inputs[i]);
                            if (error)
                                return "inputs." + error;
                        }
                    }
                    if (message.upstreamNodeIds != null && message.hasOwnProperty("upstreamNodeIds")) {
                        if (!Array.isArray(message.upstreamNodeIds))
                            return "upstreamNodeIds: array expected";
                        for (var i = 0; i < message.upstreamNodeIds.length; ++i)
                            if (!$util.isString(message.upstreamNodeIds[i]))
                                return "upstreamNodeIds: string[] expected";
                    }
                    if (message.outputAliases != null && message.hasOwnProperty("outputAliases")) {
                        if (!Array.isArray(message.outputAliases))
                            return "outputAliases: array expected";
                        for (var i = 0; i < message.outputAliases.length; ++i) {
                            var error = $root.flyteidl.core.Alias.verify(message.outputAliases[i]);
                            if (error)
                                return "outputAliases." + error;
                        }
                    }
                    if (message.taskNode != null && message.hasOwnProperty("taskNode")) {
                        properties.target = 1;
                        {
                            var error = $root.flyteidl.core.TaskNode.verify(message.taskNode);
                            if (error)
                                return "taskNode." + error;
                        }
                    }
                    if (message.workflowNode != null && message.hasOwnProperty("workflowNode")) {
                        if (properties.target === 1)
                            return "target: multiple values";
                        properties.target = 1;
                        {
                            var error = $root.flyteidl.core.WorkflowNode.verify(message.workflowNode);
                            if (error)
                                return "workflowNode." + error;
                        }
                    }
                    if (message.branchNode != null && message.hasOwnProperty("branchNode")) {
                        if (properties.target === 1)
                            return "target: multiple values";
                        properties.target = 1;
                        {
                            var error = $root.flyteidl.core.BranchNode.verify(message.branchNode);
                            if (error)
                                return "branchNode." + error;
                        }
                    }
                    if (message.gateNode != null && message.hasOwnProperty("gateNode")) {
                        if (properties.target === 1)
                            return "target: multiple values";
                        properties.target = 1;
                        {
                            var error = $root.flyteidl.core.GateNode.verify(message.gateNode);
                            if (error)
                                return "gateNode." + error;
                        }
                    }
                    if (message.arrayNode != null && message.hasOwnProperty("arrayNode")) {
                        if (properties.target === 1)
                            return "target: multiple values";
                        properties.target = 1;
                        {
                            var error = $root.flyteidl.core.ArrayNode.verify(message.arrayNode);
                            if (error)
                                return "arrayNode." + error;
                        }
                    }
                    return null;
                };
    
                return Node;
            })();
    
            core.WorkflowMetadata = (function() {
    
                /**
                 * Properties of a WorkflowMetadata.
                 * @memberof flyteidl.core
                 * @interface IWorkflowMetadata
                 * @property {flyteidl.core.IQualityOfService|null} [qualityOfService] WorkflowMetadata qualityOfService
                 * @property {flyteidl.core.WorkflowMetadata.OnFailurePolicy|null} [onFailure] WorkflowMetadata onFailure
                 * @property {Object.<string,string>|null} [tags] WorkflowMetadata tags
                 */
    
                /**
                 * Constructs a new WorkflowMetadata.
                 * @memberof flyteidl.core
                 * @classdesc Represents a WorkflowMetadata.
                 * @implements IWorkflowMetadata
                 * @constructor
                 * @param {flyteidl.core.IWorkflowMetadata=} [properties] Properties to set
                 */
                function WorkflowMetadata(properties) {
                    this.tags = {};
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * WorkflowMetadata qualityOfService.
                 * @member {flyteidl.core.IQualityOfService|null|undefined} qualityOfService
                 * @memberof flyteidl.core.WorkflowMetadata
                 * @instance
                 */
                WorkflowMetadata.prototype.qualityOfService = null;
    
                /**
                 * WorkflowMetadata onFailure.
                 * @member {flyteidl.core.WorkflowMetadata.OnFailurePolicy} onFailure
                 * @memberof flyteidl.core.WorkflowMetadata
                 * @instance
                 */
                WorkflowMetadata.prototype.onFailure = 0;
    
                /**
                 * WorkflowMetadata tags.
                 * @member {Object.<string,string>} tags
                 * @memberof flyteidl.core.WorkflowMetadata
                 * @instance
                 */
                WorkflowMetadata.prototype.tags = $util.emptyObject;
    
                /**
                 * Creates a new WorkflowMetadata instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.WorkflowMetadata
                 * @static
                 * @param {flyteidl.core.IWorkflowMetadata=} [properties] Properties to set
                 * @returns {flyteidl.core.WorkflowMetadata} WorkflowMetadata instance
                 */
                WorkflowMetadata.create = function create(properties) {
                    return new WorkflowMetadata(properties);
                };
    
                /**
                 * Encodes the specified WorkflowMetadata message. Does not implicitly {@link flyteidl.core.WorkflowMetadata.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.WorkflowMetadata
                 * @static
                 * @param {flyteidl.core.IWorkflowMetadata} message WorkflowMetadata message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                WorkflowMetadata.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.qualityOfService != null && message.hasOwnProperty("qualityOfService"))
                        $root.flyteidl.core.QualityOfService.encode(message.qualityOfService, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.onFailure != null && message.hasOwnProperty("onFailure"))
                        writer.uint32(/* id 2, wireType 0 =*/16).int32(message.onFailure);
                    if (message.tags != null && message.hasOwnProperty("tags"))
                        for (var keys = Object.keys(message.tags), i = 0; i < keys.length; ++i)
                            writer.uint32(/* id 3, wireType 2 =*/26).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.tags[keys[i]]).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a WorkflowMetadata message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.WorkflowMetadata
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.WorkflowMetadata} WorkflowMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                WorkflowMetadata.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.WorkflowMetadata(), key;
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.qualityOfService = $root.flyteidl.core.QualityOfService.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.onFailure = reader.int32();
                            break;
                        case 3:
                            reader.skip().pos++;
                            if (message.tags === $util.emptyObject)
                                message.tags = {};
                            key = reader.string();
                            reader.pos++;
                            message.tags[key] = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a WorkflowMetadata message.
                 * @function verify
                 * @memberof flyteidl.core.WorkflowMetadata
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                WorkflowMetadata.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.qualityOfService != null && message.hasOwnProperty("qualityOfService")) {
                        var error = $root.flyteidl.core.QualityOfService.verify(message.qualityOfService);
                        if (error)
                            return "qualityOfService." + error;
                    }
                    if (message.onFailure != null && message.hasOwnProperty("onFailure"))
                        switch (message.onFailure) {
                        default:
                            return "onFailure: enum value expected";
                        case 0:
                        case 1:
                            break;
                        }
                    if (message.tags != null && message.hasOwnProperty("tags")) {
                        if (!$util.isObject(message.tags))
                            return "tags: object expected";
                        var key = Object.keys(message.tags);
                        for (var i = 0; i < key.length; ++i)
                            if (!$util.isString(message.tags[key[i]]))
                                return "tags: string{k:string} expected";
                    }
                    return null;
                };
    
                /**
                 * OnFailurePolicy enum.
                 * @name flyteidl.core.WorkflowMetadata.OnFailurePolicy
                 * @enum {string}
                 * @property {number} FAIL_IMMEDIATELY=0 FAIL_IMMEDIATELY value
                 * @property {number} FAIL_AFTER_EXECUTABLE_NODES_COMPLETE=1 FAIL_AFTER_EXECUTABLE_NODES_COMPLETE value
                 */
                WorkflowMetadata.OnFailurePolicy = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "FAIL_IMMEDIATELY"] = 0;
                    values[valuesById[1] = "FAIL_AFTER_EXECUTABLE_NODES_COMPLETE"] = 1;
                    return values;
                })();
    
                return WorkflowMetadata;
            })();
    
            core.WorkflowMetadataDefaults = (function() {
    
                /**
                 * Properties of a WorkflowMetadataDefaults.
                 * @memberof flyteidl.core
                 * @interface IWorkflowMetadataDefaults
                 * @property {boolean|null} [interruptible] WorkflowMetadataDefaults interruptible
                 */
    
                /**
                 * Constructs a new WorkflowMetadataDefaults.
                 * @memberof flyteidl.core
                 * @classdesc Represents a WorkflowMetadataDefaults.
                 * @implements IWorkflowMetadataDefaults
                 * @constructor
                 * @param {flyteidl.core.IWorkflowMetadataDefaults=} [properties] Properties to set
                 */
                function WorkflowMetadataDefaults(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * WorkflowMetadataDefaults interruptible.
                 * @member {boolean} interruptible
                 * @memberof flyteidl.core.WorkflowMetadataDefaults
                 * @instance
                 */
                WorkflowMetadataDefaults.prototype.interruptible = false;
    
                /**
                 * Creates a new WorkflowMetadataDefaults instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.WorkflowMetadataDefaults
                 * @static
                 * @param {flyteidl.core.IWorkflowMetadataDefaults=} [properties] Properties to set
                 * @returns {flyteidl.core.WorkflowMetadataDefaults} WorkflowMetadataDefaults instance
                 */
                WorkflowMetadataDefaults.create = function create(properties) {
                    return new WorkflowMetadataDefaults(properties);
                };
    
                /**
                 * Encodes the specified WorkflowMetadataDefaults message. Does not implicitly {@link flyteidl.core.WorkflowMetadataDefaults.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.WorkflowMetadataDefaults
                 * @static
                 * @param {flyteidl.core.IWorkflowMetadataDefaults} message WorkflowMetadataDefaults message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                WorkflowMetadataDefaults.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.interruptible != null && message.hasOwnProperty("interruptible"))
                        writer.uint32(/* id 1, wireType 0 =*/8).bool(message.interruptible);
                    return writer;
                };
    
                /**
                 * Decodes a WorkflowMetadataDefaults message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.WorkflowMetadataDefaults
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.WorkflowMetadataDefaults} WorkflowMetadataDefaults
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                WorkflowMetadataDefaults.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.WorkflowMetadataDefaults();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.interruptible = reader.bool();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a WorkflowMetadataDefaults message.
                 * @function verify
                 * @memberof flyteidl.core.WorkflowMetadataDefaults
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                WorkflowMetadataDefaults.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.interruptible != null && message.hasOwnProperty("interruptible"))
                        if (typeof message.interruptible !== "boolean")
                            return "interruptible: boolean expected";
                    return null;
                };
    
                return WorkflowMetadataDefaults;
            })();
    
            core.WorkflowTemplate = (function() {
    
                /**
                 * Properties of a WorkflowTemplate.
                 * @memberof flyteidl.core
                 * @interface IWorkflowTemplate
                 * @property {flyteidl.core.IIdentifier|null} [id] WorkflowTemplate id
                 * @property {flyteidl.core.IWorkflowMetadata|null} [metadata] WorkflowTemplate metadata
                 * @property {flyteidl.core.ITypedInterface|null} ["interface"] WorkflowTemplate interface
                 * @property {Array.<flyteidl.core.INode>|null} [nodes] WorkflowTemplate nodes
                 * @property {Array.<flyteidl.core.IBinding>|null} [outputs] WorkflowTemplate outputs
                 * @property {flyteidl.core.INode|null} [failureNode] WorkflowTemplate failureNode
                 * @property {flyteidl.core.IWorkflowMetadataDefaults|null} [metadataDefaults] WorkflowTemplate metadataDefaults
                 */
    
                /**
                 * Constructs a new WorkflowTemplate.
                 * @memberof flyteidl.core
                 * @classdesc Represents a WorkflowTemplate.
                 * @implements IWorkflowTemplate
                 * @constructor
                 * @param {flyteidl.core.IWorkflowTemplate=} [properties] Properties to set
                 */
                function WorkflowTemplate(properties) {
                    this.nodes = [];
                    this.outputs = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * WorkflowTemplate id.
                 * @member {flyteidl.core.IIdentifier|null|undefined} id
                 * @memberof flyteidl.core.WorkflowTemplate
                 * @instance
                 */
                WorkflowTemplate.prototype.id = null;
    
                /**
                 * WorkflowTemplate metadata.
                 * @member {flyteidl.core.IWorkflowMetadata|null|undefined} metadata
                 * @memberof flyteidl.core.WorkflowTemplate
                 * @instance
                 */
                WorkflowTemplate.prototype.metadata = null;
    
                /**
                 * WorkflowTemplate interface.
                 * @member {flyteidl.core.ITypedInterface|null|undefined} interface
                 * @memberof flyteidl.core.WorkflowTemplate
                 * @instance
                 */
                WorkflowTemplate.prototype["interface"] = null;
    
                /**
                 * WorkflowTemplate nodes.
                 * @member {Array.<flyteidl.core.INode>} nodes
                 * @memberof flyteidl.core.WorkflowTemplate
                 * @instance
                 */
                WorkflowTemplate.prototype.nodes = $util.emptyArray;
    
                /**
                 * WorkflowTemplate outputs.
                 * @member {Array.<flyteidl.core.IBinding>} outputs
                 * @memberof flyteidl.core.WorkflowTemplate
                 * @instance
                 */
                WorkflowTemplate.prototype.outputs = $util.emptyArray;
    
                /**
                 * WorkflowTemplate failureNode.
                 * @member {flyteidl.core.INode|null|undefined} failureNode
                 * @memberof flyteidl.core.WorkflowTemplate
                 * @instance
                 */
                WorkflowTemplate.prototype.failureNode = null;
    
                /**
                 * WorkflowTemplate metadataDefaults.
                 * @member {flyteidl.core.IWorkflowMetadataDefaults|null|undefined} metadataDefaults
                 * @memberof flyteidl.core.WorkflowTemplate
                 * @instance
                 */
                WorkflowTemplate.prototype.metadataDefaults = null;
    
                /**
                 * Creates a new WorkflowTemplate instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.WorkflowTemplate
                 * @static
                 * @param {flyteidl.core.IWorkflowTemplate=} [properties] Properties to set
                 * @returns {flyteidl.core.WorkflowTemplate} WorkflowTemplate instance
                 */
                WorkflowTemplate.create = function create(properties) {
                    return new WorkflowTemplate(properties);
                };
    
                /**
                 * Encodes the specified WorkflowTemplate message. Does not implicitly {@link flyteidl.core.WorkflowTemplate.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.WorkflowTemplate
                 * @static
                 * @param {flyteidl.core.IWorkflowTemplate} message WorkflowTemplate message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                WorkflowTemplate.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.id != null && message.hasOwnProperty("id"))
                        $root.flyteidl.core.Identifier.encode(message.id, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.metadata != null && message.hasOwnProperty("metadata"))
                        $root.flyteidl.core.WorkflowMetadata.encode(message.metadata, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message["interface"] != null && message.hasOwnProperty("interface"))
                        $root.flyteidl.core.TypedInterface.encode(message["interface"], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message.nodes != null && message.nodes.length)
                        for (var i = 0; i < message.nodes.length; ++i)
                            $root.flyteidl.core.Node.encode(message.nodes[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.outputs != null && message.outputs.length)
                        for (var i = 0; i < message.outputs.length; ++i)
                            $root.flyteidl.core.Binding.encode(message.outputs[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                    if (message.failureNode != null && message.hasOwnProperty("failureNode"))
                        $root.flyteidl.core.Node.encode(message.failureNode, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                    if (message.metadataDefaults != null && message.hasOwnProperty("metadataDefaults"))
                        $root.flyteidl.core.WorkflowMetadataDefaults.encode(message.metadataDefaults, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a WorkflowTemplate message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.WorkflowTemplate
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.WorkflowTemplate} WorkflowTemplate
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                WorkflowTemplate.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.WorkflowTemplate();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.id = $root.flyteidl.core.Identifier.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.metadata = $root.flyteidl.core.WorkflowMetadata.decode(reader, reader.uint32());
                            break;
                        case 3:
                            message["interface"] = $root.flyteidl.core.TypedInterface.decode(reader, reader.uint32());
                            break;
                        case 4:
                            if (!(message.nodes && message.nodes.length))
                                message.nodes = [];
                            message.nodes.push($root.flyteidl.core.Node.decode(reader, reader.uint32()));
                            break;
                        case 5:
                            if (!(message.outputs && message.outputs.length))
                                message.outputs = [];
                            message.outputs.push($root.flyteidl.core.Binding.decode(reader, reader.uint32()));
                            break;
                        case 6:
                            message.failureNode = $root.flyteidl.core.Node.decode(reader, reader.uint32());
                            break;
                        case 7:
                            message.metadataDefaults = $root.flyteidl.core.WorkflowMetadataDefaults.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a WorkflowTemplate message.
                 * @function verify
                 * @memberof flyteidl.core.WorkflowTemplate
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                WorkflowTemplate.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.id != null && message.hasOwnProperty("id")) {
                        var error = $root.flyteidl.core.Identifier.verify(message.id);
                        if (error)
                            return "id." + error;
                    }
                    if (message.metadata != null && message.hasOwnProperty("metadata")) {
                        var error = $root.flyteidl.core.WorkflowMetadata.verify(message.metadata);
                        if (error)
                            return "metadata." + error;
                    }
                    if (message["interface"] != null && message.hasOwnProperty("interface")) {
                        var error = $root.flyteidl.core.TypedInterface.verify(message["interface"]);
                        if (error)
                            return "interface." + error;
                    }
                    if (message.nodes != null && message.hasOwnProperty("nodes")) {
                        if (!Array.isArray(message.nodes))
                            return "nodes: array expected";
                        for (var i = 0; i < message.nodes.length; ++i) {
                            var error = $root.flyteidl.core.Node.verify(message.nodes[i]);
                            if (error)
                                return "nodes." + error;
                        }
                    }
                    if (message.outputs != null && message.hasOwnProperty("outputs")) {
                        if (!Array.isArray(message.outputs))
                            return "outputs: array expected";
                        for (var i = 0; i < message.outputs.length; ++i) {
                            var error = $root.flyteidl.core.Binding.verify(message.outputs[i]);
                            if (error)
                                return "outputs." + error;
                        }
                    }
                    if (message.failureNode != null && message.hasOwnProperty("failureNode")) {
                        var error = $root.flyteidl.core.Node.verify(message.failureNode);
                        if (error)
                            return "failureNode." + error;
                    }
                    if (message.metadataDefaults != null && message.hasOwnProperty("metadataDefaults")) {
                        var error = $root.flyteidl.core.WorkflowMetadataDefaults.verify(message.metadataDefaults);
                        if (error)
                            return "metadataDefaults." + error;
                    }
                    return null;
                };
    
                return WorkflowTemplate;
            })();
    
            core.TaskNodeOverrides = (function() {
    
                /**
                 * Properties of a TaskNodeOverrides.
                 * @memberof flyteidl.core
                 * @interface ITaskNodeOverrides
                 * @property {flyteidl.core.IResources|null} [resources] TaskNodeOverrides resources
                 * @property {flyteidl.core.IExtendedResources|null} [extendedResources] TaskNodeOverrides extendedResources
                 * @property {string|null} [containerImage] TaskNodeOverrides containerImage
                 */
    
                /**
                 * Constructs a new TaskNodeOverrides.
                 * @memberof flyteidl.core
                 * @classdesc Represents a TaskNodeOverrides.
                 * @implements ITaskNodeOverrides
                 * @constructor
                 * @param {flyteidl.core.ITaskNodeOverrides=} [properties] Properties to set
                 */
                function TaskNodeOverrides(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * TaskNodeOverrides resources.
                 * @member {flyteidl.core.IResources|null|undefined} resources
                 * @memberof flyteidl.core.TaskNodeOverrides
                 * @instance
                 */
                TaskNodeOverrides.prototype.resources = null;
    
                /**
                 * TaskNodeOverrides extendedResources.
                 * @member {flyteidl.core.IExtendedResources|null|undefined} extendedResources
                 * @memberof flyteidl.core.TaskNodeOverrides
                 * @instance
                 */
                TaskNodeOverrides.prototype.extendedResources = null;
    
                /**
                 * TaskNodeOverrides containerImage.
                 * @member {string} containerImage
                 * @memberof flyteidl.core.TaskNodeOverrides
                 * @instance
                 */
                TaskNodeOverrides.prototype.containerImage = "";
    
                /**
                 * Creates a new TaskNodeOverrides instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.TaskNodeOverrides
                 * @static
                 * @param {flyteidl.core.ITaskNodeOverrides=} [properties] Properties to set
                 * @returns {flyteidl.core.TaskNodeOverrides} TaskNodeOverrides instance
                 */
                TaskNodeOverrides.create = function create(properties) {
                    return new TaskNodeOverrides(properties);
                };
    
                /**
                 * Encodes the specified TaskNodeOverrides message. Does not implicitly {@link flyteidl.core.TaskNodeOverrides.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.TaskNodeOverrides
                 * @static
                 * @param {flyteidl.core.ITaskNodeOverrides} message TaskNodeOverrides message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TaskNodeOverrides.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.resources != null && message.hasOwnProperty("resources"))
                        $root.flyteidl.core.Resources.encode(message.resources, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.extendedResources != null && message.hasOwnProperty("extendedResources"))
                        $root.flyteidl.core.ExtendedResources.encode(message.extendedResources, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.containerImage != null && message.hasOwnProperty("containerImage"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.containerImage);
                    return writer;
                };
    
                /**
                 * Decodes a TaskNodeOverrides message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.TaskNodeOverrides
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.TaskNodeOverrides} TaskNodeOverrides
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TaskNodeOverrides.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.TaskNodeOverrides();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.resources = $root.flyteidl.core.Resources.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.extendedResources = $root.flyteidl.core.ExtendedResources.decode(reader, reader.uint32());
                            break;
                        case 3:
                            message.containerImage = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a TaskNodeOverrides message.
                 * @function verify
                 * @memberof flyteidl.core.TaskNodeOverrides
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TaskNodeOverrides.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.resources != null && message.hasOwnProperty("resources")) {
                        var error = $root.flyteidl.core.Resources.verify(message.resources);
                        if (error)
                            return "resources." + error;
                    }
                    if (message.extendedResources != null && message.hasOwnProperty("extendedResources")) {
                        var error = $root.flyteidl.core.ExtendedResources.verify(message.extendedResources);
                        if (error)
                            return "extendedResources." + error;
                    }
                    if (message.containerImage != null && message.hasOwnProperty("containerImage"))
                        if (!$util.isString(message.containerImage))
                            return "containerImage: string expected";
                    return null;
                };
    
                return TaskNodeOverrides;
            })();
    
            core.LaunchPlanTemplate = (function() {
    
                /**
                 * Properties of a LaunchPlanTemplate.
                 * @memberof flyteidl.core
                 * @interface ILaunchPlanTemplate
                 * @property {flyteidl.core.IIdentifier|null} [id] LaunchPlanTemplate id
                 * @property {flyteidl.core.ITypedInterface|null} ["interface"] LaunchPlanTemplate interface
                 * @property {flyteidl.core.ILiteralMap|null} [fixedInputs] LaunchPlanTemplate fixedInputs
                 */
    
                /**
                 * Constructs a new LaunchPlanTemplate.
                 * @memberof flyteidl.core
                 * @classdesc Represents a LaunchPlanTemplate.
                 * @implements ILaunchPlanTemplate
                 * @constructor
                 * @param {flyteidl.core.ILaunchPlanTemplate=} [properties] Properties to set
                 */
                function LaunchPlanTemplate(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * LaunchPlanTemplate id.
                 * @member {flyteidl.core.IIdentifier|null|undefined} id
                 * @memberof flyteidl.core.LaunchPlanTemplate
                 * @instance
                 */
                LaunchPlanTemplate.prototype.id = null;
    
                /**
                 * LaunchPlanTemplate interface.
                 * @member {flyteidl.core.ITypedInterface|null|undefined} interface
                 * @memberof flyteidl.core.LaunchPlanTemplate
                 * @instance
                 */
                LaunchPlanTemplate.prototype["interface"] = null;
    
                /**
                 * LaunchPlanTemplate fixedInputs.
                 * @member {flyteidl.core.ILiteralMap|null|undefined} fixedInputs
                 * @memberof flyteidl.core.LaunchPlanTemplate
                 * @instance
                 */
                LaunchPlanTemplate.prototype.fixedInputs = null;
    
                /**
                 * Creates a new LaunchPlanTemplate instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.LaunchPlanTemplate
                 * @static
                 * @param {flyteidl.core.ILaunchPlanTemplate=} [properties] Properties to set
                 * @returns {flyteidl.core.LaunchPlanTemplate} LaunchPlanTemplate instance
                 */
                LaunchPlanTemplate.create = function create(properties) {
                    return new LaunchPlanTemplate(properties);
                };
    
                /**
                 * Encodes the specified LaunchPlanTemplate message. Does not implicitly {@link flyteidl.core.LaunchPlanTemplate.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.LaunchPlanTemplate
                 * @static
                 * @param {flyteidl.core.ILaunchPlanTemplate} message LaunchPlanTemplate message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                LaunchPlanTemplate.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.id != null && message.hasOwnProperty("id"))
                        $root.flyteidl.core.Identifier.encode(message.id, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message["interface"] != null && message.hasOwnProperty("interface"))
                        $root.flyteidl.core.TypedInterface.encode(message["interface"], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.fixedInputs != null && message.hasOwnProperty("fixedInputs"))
                        $root.flyteidl.core.LiteralMap.encode(message.fixedInputs, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a LaunchPlanTemplate message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.LaunchPlanTemplate
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.LaunchPlanTemplate} LaunchPlanTemplate
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                LaunchPlanTemplate.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.LaunchPlanTemplate();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.id = $root.flyteidl.core.Identifier.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message["interface"] = $root.flyteidl.core.TypedInterface.decode(reader, reader.uint32());
                            break;
                        case 3:
                            message.fixedInputs = $root.flyteidl.core.LiteralMap.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a LaunchPlanTemplate message.
                 * @function verify
                 * @memberof flyteidl.core.LaunchPlanTemplate
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                LaunchPlanTemplate.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.id != null && message.hasOwnProperty("id")) {
                        var error = $root.flyteidl.core.Identifier.verify(message.id);
                        if (error)
                            return "id." + error;
                    }
                    if (message["interface"] != null && message.hasOwnProperty("interface")) {
                        var error = $root.flyteidl.core.TypedInterface.verify(message["interface"]);
                        if (error)
                            return "interface." + error;
                    }
                    if (message.fixedInputs != null && message.hasOwnProperty("fixedInputs")) {
                        var error = $root.flyteidl.core.LiteralMap.verify(message.fixedInputs);
                        if (error)
                            return "fixedInputs." + error;
                    }
                    return null;
                };
    
                return LaunchPlanTemplate;
            })();
    
            core.ComparisonExpression = (function() {
    
                /**
                 * Properties of a ComparisonExpression.
                 * @memberof flyteidl.core
                 * @interface IComparisonExpression
                 * @property {flyteidl.core.ComparisonExpression.Operator|null} [operator] ComparisonExpression operator
                 * @property {flyteidl.core.IOperand|null} [leftValue] ComparisonExpression leftValue
                 * @property {flyteidl.core.IOperand|null} [rightValue] ComparisonExpression rightValue
                 */
    
                /**
                 * Constructs a new ComparisonExpression.
                 * @memberof flyteidl.core
                 * @classdesc Represents a ComparisonExpression.
                 * @implements IComparisonExpression
                 * @constructor
                 * @param {flyteidl.core.IComparisonExpression=} [properties] Properties to set
                 */
                function ComparisonExpression(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * ComparisonExpression operator.
                 * @member {flyteidl.core.ComparisonExpression.Operator} operator
                 * @memberof flyteidl.core.ComparisonExpression
                 * @instance
                 */
                ComparisonExpression.prototype.operator = 0;
    
                /**
                 * ComparisonExpression leftValue.
                 * @member {flyteidl.core.IOperand|null|undefined} leftValue
                 * @memberof flyteidl.core.ComparisonExpression
                 * @instance
                 */
                ComparisonExpression.prototype.leftValue = null;
    
                /**
                 * ComparisonExpression rightValue.
                 * @member {flyteidl.core.IOperand|null|undefined} rightValue
                 * @memberof flyteidl.core.ComparisonExpression
                 * @instance
                 */
                ComparisonExpression.prototype.rightValue = null;
    
                /**
                 * Creates a new ComparisonExpression instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.ComparisonExpression
                 * @static
                 * @param {flyteidl.core.IComparisonExpression=} [properties] Properties to set
                 * @returns {flyteidl.core.ComparisonExpression} ComparisonExpression instance
                 */
                ComparisonExpression.create = function create(properties) {
                    return new ComparisonExpression(properties);
                };
    
                /**
                 * Encodes the specified ComparisonExpression message. Does not implicitly {@link flyteidl.core.ComparisonExpression.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.ComparisonExpression
                 * @static
                 * @param {flyteidl.core.IComparisonExpression} message ComparisonExpression message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ComparisonExpression.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.operator != null && message.hasOwnProperty("operator"))
                        writer.uint32(/* id 1, wireType 0 =*/8).int32(message.operator);
                    if (message.leftValue != null && message.hasOwnProperty("leftValue"))
                        $root.flyteidl.core.Operand.encode(message.leftValue, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.rightValue != null && message.hasOwnProperty("rightValue"))
                        $root.flyteidl.core.Operand.encode(message.rightValue, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a ComparisonExpression message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.ComparisonExpression
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.ComparisonExpression} ComparisonExpression
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ComparisonExpression.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.ComparisonExpression();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.operator = reader.int32();
                            break;
                        case 2:
                            message.leftValue = $root.flyteidl.core.Operand.decode(reader, reader.uint32());
                            break;
                        case 3:
                            message.rightValue = $root.flyteidl.core.Operand.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a ComparisonExpression message.
                 * @function verify
                 * @memberof flyteidl.core.ComparisonExpression
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ComparisonExpression.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.operator != null && message.hasOwnProperty("operator"))
                        switch (message.operator) {
                        default:
                            return "operator: enum value expected";
                        case 0:
                        case 1:
                        case 2:
                        case 3:
                        case 4:
                        case 5:
                            break;
                        }
                    if (message.leftValue != null && message.hasOwnProperty("leftValue")) {
                        var error = $root.flyteidl.core.Operand.verify(message.leftValue);
                        if (error)
                            return "leftValue." + error;
                    }
                    if (message.rightValue != null && message.hasOwnProperty("rightValue")) {
                        var error = $root.flyteidl.core.Operand.verify(message.rightValue);
                        if (error)
                            return "rightValue." + error;
                    }
                    return null;
                };
    
                /**
                 * Operator enum.
                 * @name flyteidl.core.ComparisonExpression.Operator
                 * @enum {string}
                 * @property {number} EQ=0 EQ value
                 * @property {number} NEQ=1 NEQ value
                 * @property {number} GT=2 GT value
                 * @property {number} GTE=3 GTE value
                 * @property {number} LT=4 LT value
                 * @property {number} LTE=5 LTE value
                 */
                ComparisonExpression.Operator = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "EQ"] = 0;
                    values[valuesById[1] = "NEQ"] = 1;
                    values[valuesById[2] = "GT"] = 2;
                    values[valuesById[3] = "GTE"] = 3;
                    values[valuesById[4] = "LT"] = 4;
                    values[valuesById[5] = "LTE"] = 5;
                    return values;
                })();
    
                return ComparisonExpression;
            })();
    
            core.Operand = (function() {
    
                /**
                 * Properties of an Operand.
                 * @memberof flyteidl.core
                 * @interface IOperand
                 * @property {flyteidl.core.IPrimitive|null} [primitive] Operand primitive
                 * @property {string|null} ["var"] Operand var
                 * @property {flyteidl.core.IScalar|null} [scalar] Operand scalar
                 */
    
                /**
                 * Constructs a new Operand.
                 * @memberof flyteidl.core
                 * @classdesc Represents an Operand.
                 * @implements IOperand
                 * @constructor
                 * @param {flyteidl.core.IOperand=} [properties] Properties to set
                 */
                function Operand(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Operand primitive.
                 * @member {flyteidl.core.IPrimitive|null|undefined} primitive
                 * @memberof flyteidl.core.Operand
                 * @instance
                 */
                Operand.prototype.primitive = null;
    
                /**
                 * Operand var.
                 * @member {string} var
                 * @memberof flyteidl.core.Operand
                 * @instance
                 */
                Operand.prototype["var"] = "";
    
                /**
                 * Operand scalar.
                 * @member {flyteidl.core.IScalar|null|undefined} scalar
                 * @memberof flyteidl.core.Operand
                 * @instance
                 */
                Operand.prototype.scalar = null;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * Operand val.
                 * @member {"primitive"|"var"|"scalar"|undefined} val
                 * @memberof flyteidl.core.Operand
                 * @instance
                 */
                Object.defineProperty(Operand.prototype, "val", {
                    get: $util.oneOfGetter($oneOfFields = ["primitive", "var", "scalar"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new Operand instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Operand
                 * @static
                 * @param {flyteidl.core.IOperand=} [properties] Properties to set
                 * @returns {flyteidl.core.Operand} Operand instance
                 */
                Operand.create = function create(properties) {
                    return new Operand(properties);
                };
    
                /**
                 * Encodes the specified Operand message. Does not implicitly {@link flyteidl.core.Operand.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Operand
                 * @static
                 * @param {flyteidl.core.IOperand} message Operand message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Operand.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.primitive != null && message.hasOwnProperty("primitive"))
                        $root.flyteidl.core.Primitive.encode(message.primitive, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message["var"] != null && message.hasOwnProperty("var"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message["var"]);
                    if (message.scalar != null && message.hasOwnProperty("scalar"))
                        $root.flyteidl.core.Scalar.encode(message.scalar, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes an Operand message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Operand
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Operand} Operand
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Operand.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Operand();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.primitive = $root.flyteidl.core.Primitive.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message["var"] = reader.string();
                            break;
                        case 3:
                            message.scalar = $root.flyteidl.core.Scalar.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an Operand message.
                 * @function verify
                 * @memberof flyteidl.core.Operand
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Operand.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.primitive != null && message.hasOwnProperty("primitive")) {
                        properties.val = 1;
                        {
                            var error = $root.flyteidl.core.Primitive.verify(message.primitive);
                            if (error)
                                return "primitive." + error;
                        }
                    }
                    if (message["var"] != null && message.hasOwnProperty("var")) {
                        if (properties.val === 1)
                            return "val: multiple values";
                        properties.val = 1;
                        if (!$util.isString(message["var"]))
                            return "var: string expected";
                    }
                    if (message.scalar != null && message.hasOwnProperty("scalar")) {
                        if (properties.val === 1)
                            return "val: multiple values";
                        properties.val = 1;
                        {
                            var error = $root.flyteidl.core.Scalar.verify(message.scalar);
                            if (error)
                                return "scalar." + error;
                        }
                    }
                    return null;
                };
    
                return Operand;
            })();
    
            core.BooleanExpression = (function() {
    
                /**
                 * Properties of a BooleanExpression.
                 * @memberof flyteidl.core
                 * @interface IBooleanExpression
                 * @property {flyteidl.core.IConjunctionExpression|null} [conjunction] BooleanExpression conjunction
                 * @property {flyteidl.core.IComparisonExpression|null} [comparison] BooleanExpression comparison
                 */
    
                /**
                 * Constructs a new BooleanExpression.
                 * @memberof flyteidl.core
                 * @classdesc Represents a BooleanExpression.
                 * @implements IBooleanExpression
                 * @constructor
                 * @param {flyteidl.core.IBooleanExpression=} [properties] Properties to set
                 */
                function BooleanExpression(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * BooleanExpression conjunction.
                 * @member {flyteidl.core.IConjunctionExpression|null|undefined} conjunction
                 * @memberof flyteidl.core.BooleanExpression
                 * @instance
                 */
                BooleanExpression.prototype.conjunction = null;
    
                /**
                 * BooleanExpression comparison.
                 * @member {flyteidl.core.IComparisonExpression|null|undefined} comparison
                 * @memberof flyteidl.core.BooleanExpression
                 * @instance
                 */
                BooleanExpression.prototype.comparison = null;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * BooleanExpression expr.
                 * @member {"conjunction"|"comparison"|undefined} expr
                 * @memberof flyteidl.core.BooleanExpression
                 * @instance
                 */
                Object.defineProperty(BooleanExpression.prototype, "expr", {
                    get: $util.oneOfGetter($oneOfFields = ["conjunction", "comparison"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new BooleanExpression instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.BooleanExpression
                 * @static
                 * @param {flyteidl.core.IBooleanExpression=} [properties] Properties to set
                 * @returns {flyteidl.core.BooleanExpression} BooleanExpression instance
                 */
                BooleanExpression.create = function create(properties) {
                    return new BooleanExpression(properties);
                };
    
                /**
                 * Encodes the specified BooleanExpression message. Does not implicitly {@link flyteidl.core.BooleanExpression.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.BooleanExpression
                 * @static
                 * @param {flyteidl.core.IBooleanExpression} message BooleanExpression message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                BooleanExpression.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.conjunction != null && message.hasOwnProperty("conjunction"))
                        $root.flyteidl.core.ConjunctionExpression.encode(message.conjunction, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.comparison != null && message.hasOwnProperty("comparison"))
                        $root.flyteidl.core.ComparisonExpression.encode(message.comparison, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a BooleanExpression message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.BooleanExpression
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.BooleanExpression} BooleanExpression
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                BooleanExpression.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.BooleanExpression();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.conjunction = $root.flyteidl.core.ConjunctionExpression.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.comparison = $root.flyteidl.core.ComparisonExpression.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a BooleanExpression message.
                 * @function verify
                 * @memberof flyteidl.core.BooleanExpression
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                BooleanExpression.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.conjunction != null && message.hasOwnProperty("conjunction")) {
                        properties.expr = 1;
                        {
                            var error = $root.flyteidl.core.ConjunctionExpression.verify(message.conjunction);
                            if (error)
                                return "conjunction." + error;
                        }
                    }
                    if (message.comparison != null && message.hasOwnProperty("comparison")) {
                        if (properties.expr === 1)
                            return "expr: multiple values";
                        properties.expr = 1;
                        {
                            var error = $root.flyteidl.core.ComparisonExpression.verify(message.comparison);
                            if (error)
                                return "comparison." + error;
                        }
                    }
                    return null;
                };
    
                return BooleanExpression;
            })();
    
            core.ConjunctionExpression = (function() {
    
                /**
                 * Properties of a ConjunctionExpression.
                 * @memberof flyteidl.core
                 * @interface IConjunctionExpression
                 * @property {flyteidl.core.ConjunctionExpression.LogicalOperator|null} [operator] ConjunctionExpression operator
                 * @property {flyteidl.core.IBooleanExpression|null} [leftExpression] ConjunctionExpression leftExpression
                 * @property {flyteidl.core.IBooleanExpression|null} [rightExpression] ConjunctionExpression rightExpression
                 */
    
                /**
                 * Constructs a new ConjunctionExpression.
                 * @memberof flyteidl.core
                 * @classdesc Represents a ConjunctionExpression.
                 * @implements IConjunctionExpression
                 * @constructor
                 * @param {flyteidl.core.IConjunctionExpression=} [properties] Properties to set
                 */
                function ConjunctionExpression(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * ConjunctionExpression operator.
                 * @member {flyteidl.core.ConjunctionExpression.LogicalOperator} operator
                 * @memberof flyteidl.core.ConjunctionExpression
                 * @instance
                 */
                ConjunctionExpression.prototype.operator = 0;
    
                /**
                 * ConjunctionExpression leftExpression.
                 * @member {flyteidl.core.IBooleanExpression|null|undefined} leftExpression
                 * @memberof flyteidl.core.ConjunctionExpression
                 * @instance
                 */
                ConjunctionExpression.prototype.leftExpression = null;
    
                /**
                 * ConjunctionExpression rightExpression.
                 * @member {flyteidl.core.IBooleanExpression|null|undefined} rightExpression
                 * @memberof flyteidl.core.ConjunctionExpression
                 * @instance
                 */
                ConjunctionExpression.prototype.rightExpression = null;
    
                /**
                 * Creates a new ConjunctionExpression instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.ConjunctionExpression
                 * @static
                 * @param {flyteidl.core.IConjunctionExpression=} [properties] Properties to set
                 * @returns {flyteidl.core.ConjunctionExpression} ConjunctionExpression instance
                 */
                ConjunctionExpression.create = function create(properties) {
                    return new ConjunctionExpression(properties);
                };
    
                /**
                 * Encodes the specified ConjunctionExpression message. Does not implicitly {@link flyteidl.core.ConjunctionExpression.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.ConjunctionExpression
                 * @static
                 * @param {flyteidl.core.IConjunctionExpression} message ConjunctionExpression message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ConjunctionExpression.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.operator != null && message.hasOwnProperty("operator"))
                        writer.uint32(/* id 1, wireType 0 =*/8).int32(message.operator);
                    if (message.leftExpression != null && message.hasOwnProperty("leftExpression"))
                        $root.flyteidl.core.BooleanExpression.encode(message.leftExpression, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.rightExpression != null && message.hasOwnProperty("rightExpression"))
                        $root.flyteidl.core.BooleanExpression.encode(message.rightExpression, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a ConjunctionExpression message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.ConjunctionExpression
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.ConjunctionExpression} ConjunctionExpression
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ConjunctionExpression.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.ConjunctionExpression();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.operator = reader.int32();
                            break;
                        case 2:
                            message.leftExpression = $root.flyteidl.core.BooleanExpression.decode(reader, reader.uint32());
                            break;
                        case 3:
                            message.rightExpression = $root.flyteidl.core.BooleanExpression.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a ConjunctionExpression message.
                 * @function verify
                 * @memberof flyteidl.core.ConjunctionExpression
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ConjunctionExpression.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.operator != null && message.hasOwnProperty("operator"))
                        switch (message.operator) {
                        default:
                            return "operator: enum value expected";
                        case 0:
                        case 1:
                            break;
                        }
                    if (message.leftExpression != null && message.hasOwnProperty("leftExpression")) {
                        var error = $root.flyteidl.core.BooleanExpression.verify(message.leftExpression);
                        if (error)
                            return "leftExpression." + error;
                    }
                    if (message.rightExpression != null && message.hasOwnProperty("rightExpression")) {
                        var error = $root.flyteidl.core.BooleanExpression.verify(message.rightExpression);
                        if (error)
                            return "rightExpression." + error;
                    }
                    return null;
                };
    
                /**
                 * LogicalOperator enum.
                 * @name flyteidl.core.ConjunctionExpression.LogicalOperator
                 * @enum {string}
                 * @property {number} AND=0 AND value
                 * @property {number} OR=1 OR value
                 */
                ConjunctionExpression.LogicalOperator = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "AND"] = 0;
                    values[valuesById[1] = "OR"] = 1;
                    return values;
                })();
    
                return ConjunctionExpression;
            })();
    
            core.WorkflowExecution = (function() {
    
                /**
                 * Properties of a WorkflowExecution.
                 * @memberof flyteidl.core
                 * @interface IWorkflowExecution
                 */
    
                /**
                 * Constructs a new WorkflowExecution.
                 * @memberof flyteidl.core
                 * @classdesc Represents a WorkflowExecution.
                 * @implements IWorkflowExecution
                 * @constructor
                 * @param {flyteidl.core.IWorkflowExecution=} [properties] Properties to set
                 */
                function WorkflowExecution(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Creates a new WorkflowExecution instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.WorkflowExecution
                 * @static
                 * @param {flyteidl.core.IWorkflowExecution=} [properties] Properties to set
                 * @returns {flyteidl.core.WorkflowExecution} WorkflowExecution instance
                 */
                WorkflowExecution.create = function create(properties) {
                    return new WorkflowExecution(properties);
                };
    
                /**
                 * Encodes the specified WorkflowExecution message. Does not implicitly {@link flyteidl.core.WorkflowExecution.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.WorkflowExecution
                 * @static
                 * @param {flyteidl.core.IWorkflowExecution} message WorkflowExecution message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                WorkflowExecution.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    return writer;
                };
    
                /**
                 * Decodes a WorkflowExecution message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.WorkflowExecution
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.WorkflowExecution} WorkflowExecution
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                WorkflowExecution.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.WorkflowExecution();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a WorkflowExecution message.
                 * @function verify
                 * @memberof flyteidl.core.WorkflowExecution
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                WorkflowExecution.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    return null;
                };
    
                /**
                 * Phase enum.
                 * @name flyteidl.core.WorkflowExecution.Phase
                 * @enum {string}
                 * @property {number} UNDEFINED=0 UNDEFINED value
                 * @property {number} QUEUED=1 QUEUED value
                 * @property {number} RUNNING=2 RUNNING value
                 * @property {number} SUCCEEDING=3 SUCCEEDING value
                 * @property {number} SUCCEEDED=4 SUCCEEDED value
                 * @property {number} FAILING=5 FAILING value
                 * @property {number} FAILED=6 FAILED value
                 * @property {number} ABORTED=7 ABORTED value
                 * @property {number} TIMED_OUT=8 TIMED_OUT value
                 * @property {number} ABORTING=9 ABORTING value
                 */
                WorkflowExecution.Phase = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "UNDEFINED"] = 0;
                    values[valuesById[1] = "QUEUED"] = 1;
                    values[valuesById[2] = "RUNNING"] = 2;
                    values[valuesById[3] = "SUCCEEDING"] = 3;
                    values[valuesById[4] = "SUCCEEDED"] = 4;
                    values[valuesById[5] = "FAILING"] = 5;
                    values[valuesById[6] = "FAILED"] = 6;
                    values[valuesById[7] = "ABORTED"] = 7;
                    values[valuesById[8] = "TIMED_OUT"] = 8;
                    values[valuesById[9] = "ABORTING"] = 9;
                    return values;
                })();
    
                return WorkflowExecution;
            })();
    
            core.NodeExecution = (function() {
    
                /**
                 * Properties of a NodeExecution.
                 * @memberof flyteidl.core
                 * @interface INodeExecution
                 */
    
                /**
                 * Constructs a new NodeExecution.
                 * @memberof flyteidl.core
                 * @classdesc Represents a NodeExecution.
                 * @implements INodeExecution
                 * @constructor
                 * @param {flyteidl.core.INodeExecution=} [properties] Properties to set
                 */
                function NodeExecution(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Creates a new NodeExecution instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.NodeExecution
                 * @static
                 * @param {flyteidl.core.INodeExecution=} [properties] Properties to set
                 * @returns {flyteidl.core.NodeExecution} NodeExecution instance
                 */
                NodeExecution.create = function create(properties) {
                    return new NodeExecution(properties);
                };
    
                /**
                 * Encodes the specified NodeExecution message. Does not implicitly {@link flyteidl.core.NodeExecution.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.NodeExecution
                 * @static
                 * @param {flyteidl.core.INodeExecution} message NodeExecution message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                NodeExecution.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    return writer;
                };
    
                /**
                 * Decodes a NodeExecution message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.NodeExecution
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.NodeExecution} NodeExecution
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                NodeExecution.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.NodeExecution();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a NodeExecution message.
                 * @function verify
                 * @memberof flyteidl.core.NodeExecution
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                NodeExecution.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    return null;
                };
    
                /**
                 * Phase enum.
                 * @name flyteidl.core.NodeExecution.Phase
                 * @enum {string}
                 * @property {number} UNDEFINED=0 UNDEFINED value
                 * @property {number} QUEUED=1 QUEUED value
                 * @property {number} RUNNING=2 RUNNING value
                 * @property {number} SUCCEEDED=3 SUCCEEDED value
                 * @property {number} FAILING=4 FAILING value
                 * @property {number} FAILED=5 FAILED value
                 * @property {number} ABORTED=6 ABORTED value
                 * @property {number} SKIPPED=7 SKIPPED value
                 * @property {number} TIMED_OUT=8 TIMED_OUT value
                 * @property {number} DYNAMIC_RUNNING=9 DYNAMIC_RUNNING value
                 * @property {number} RECOVERED=10 RECOVERED value
                 */
                NodeExecution.Phase = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "UNDEFINED"] = 0;
                    values[valuesById[1] = "QUEUED"] = 1;
                    values[valuesById[2] = "RUNNING"] = 2;
                    values[valuesById[3] = "SUCCEEDED"] = 3;
                    values[valuesById[4] = "FAILING"] = 4;
                    values[valuesById[5] = "FAILED"] = 5;
                    values[valuesById[6] = "ABORTED"] = 6;
                    values[valuesById[7] = "SKIPPED"] = 7;
                    values[valuesById[8] = "TIMED_OUT"] = 8;
                    values[valuesById[9] = "DYNAMIC_RUNNING"] = 9;
                    values[valuesById[10] = "RECOVERED"] = 10;
                    return values;
                })();
    
                return NodeExecution;
            })();
    
            core.TaskExecution = (function() {
    
                /**
                 * Properties of a TaskExecution.
                 * @memberof flyteidl.core
                 * @interface ITaskExecution
                 */
    
                /**
                 * Constructs a new TaskExecution.
                 * @memberof flyteidl.core
                 * @classdesc Represents a TaskExecution.
                 * @implements ITaskExecution
                 * @constructor
                 * @param {flyteidl.core.ITaskExecution=} [properties] Properties to set
                 */
                function TaskExecution(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Creates a new TaskExecution instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.TaskExecution
                 * @static
                 * @param {flyteidl.core.ITaskExecution=} [properties] Properties to set
                 * @returns {flyteidl.core.TaskExecution} TaskExecution instance
                 */
                TaskExecution.create = function create(properties) {
                    return new TaskExecution(properties);
                };
    
                /**
                 * Encodes the specified TaskExecution message. Does not implicitly {@link flyteidl.core.TaskExecution.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.TaskExecution
                 * @static
                 * @param {flyteidl.core.ITaskExecution} message TaskExecution message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TaskExecution.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    return writer;
                };
    
                /**
                 * Decodes a TaskExecution message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.TaskExecution
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.TaskExecution} TaskExecution
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TaskExecution.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.TaskExecution();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a TaskExecution message.
                 * @function verify
                 * @memberof flyteidl.core.TaskExecution
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TaskExecution.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    return null;
                };
    
                /**
                 * Phase enum.
                 * @name flyteidl.core.TaskExecution.Phase
                 * @enum {string}
                 * @property {number} UNDEFINED=0 UNDEFINED value
                 * @property {number} QUEUED=1 QUEUED value
                 * @property {number} RUNNING=2 RUNNING value
                 * @property {number} SUCCEEDED=3 SUCCEEDED value
                 * @property {number} ABORTED=4 ABORTED value
                 * @property {number} FAILED=5 FAILED value
                 * @property {number} INITIALIZING=6 INITIALIZING value
                 * @property {number} WAITING_FOR_RESOURCES=7 WAITING_FOR_RESOURCES value
                 */
                TaskExecution.Phase = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "UNDEFINED"] = 0;
                    values[valuesById[1] = "QUEUED"] = 1;
                    values[valuesById[2] = "RUNNING"] = 2;
                    values[valuesById[3] = "SUCCEEDED"] = 3;
                    values[valuesById[4] = "ABORTED"] = 4;
                    values[valuesById[5] = "FAILED"] = 5;
                    values[valuesById[6] = "INITIALIZING"] = 6;
                    values[valuesById[7] = "WAITING_FOR_RESOURCES"] = 7;
                    return values;
                })();
    
                return TaskExecution;
            })();
    
            core.ExecutionError = (function() {
    
                /**
                 * Properties of an ExecutionError.
                 * @memberof flyteidl.core
                 * @interface IExecutionError
                 * @property {string|null} [code] ExecutionError code
                 * @property {string|null} [message] ExecutionError message
                 * @property {string|null} [errorUri] ExecutionError errorUri
                 * @property {flyteidl.core.ExecutionError.ErrorKind|null} [kind] ExecutionError kind
                 * @property {google.protobuf.ITimestamp|null} [timestamp] ExecutionError timestamp
                 * @property {string|null} [worker] ExecutionError worker
                 */
    
                /**
                 * Constructs a new ExecutionError.
                 * @memberof flyteidl.core
                 * @classdesc Represents an ExecutionError.
                 * @implements IExecutionError
                 * @constructor
                 * @param {flyteidl.core.IExecutionError=} [properties] Properties to set
                 */
                function ExecutionError(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * ExecutionError code.
                 * @member {string} code
                 * @memberof flyteidl.core.ExecutionError
                 * @instance
                 */
                ExecutionError.prototype.code = "";
    
                /**
                 * ExecutionError message.
                 * @member {string} message
                 * @memberof flyteidl.core.ExecutionError
                 * @instance
                 */
                ExecutionError.prototype.message = "";
    
                /**
                 * ExecutionError errorUri.
                 * @member {string} errorUri
                 * @memberof flyteidl.core.ExecutionError
                 * @instance
                 */
                ExecutionError.prototype.errorUri = "";
    
                /**
                 * ExecutionError kind.
                 * @member {flyteidl.core.ExecutionError.ErrorKind} kind
                 * @memberof flyteidl.core.ExecutionError
                 * @instance
                 */
                ExecutionError.prototype.kind = 0;
    
                /**
                 * ExecutionError timestamp.
                 * @member {google.protobuf.ITimestamp|null|undefined} timestamp
                 * @memberof flyteidl.core.ExecutionError
                 * @instance
                 */
                ExecutionError.prototype.timestamp = null;
    
                /**
                 * ExecutionError worker.
                 * @member {string} worker
                 * @memberof flyteidl.core.ExecutionError
                 * @instance
                 */
                ExecutionError.prototype.worker = "";
    
                /**
                 * Creates a new ExecutionError instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.ExecutionError
                 * @static
                 * @param {flyteidl.core.IExecutionError=} [properties] Properties to set
                 * @returns {flyteidl.core.ExecutionError} ExecutionError instance
                 */
                ExecutionError.create = function create(properties) {
                    return new ExecutionError(properties);
                };
    
                /**
                 * Encodes the specified ExecutionError message. Does not implicitly {@link flyteidl.core.ExecutionError.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.ExecutionError
                 * @static
                 * @param {flyteidl.core.IExecutionError} message ExecutionError message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ExecutionError.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.code != null && message.hasOwnProperty("code"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.code);
                    if (message.message != null && message.hasOwnProperty("message"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.message);
                    if (message.errorUri != null && message.hasOwnProperty("errorUri"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.errorUri);
                    if (message.kind != null && message.hasOwnProperty("kind"))
                        writer.uint32(/* id 4, wireType 0 =*/32).int32(message.kind);
                    if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                        $root.google.protobuf.Timestamp.encode(message.timestamp, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                    if (message.worker != null && message.hasOwnProperty("worker"))
                        writer.uint32(/* id 6, wireType 2 =*/50).string(message.worker);
                    return writer;
                };
    
                /**
                 * Decodes an ExecutionError message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.ExecutionError
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.ExecutionError} ExecutionError
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ExecutionError.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.ExecutionError();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.code = reader.string();
                            break;
                        case 2:
                            message.message = reader.string();
                            break;
                        case 3:
                            message.errorUri = reader.string();
                            break;
                        case 4:
                            message.kind = reader.int32();
                            break;
                        case 5:
                            message.timestamp = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                            break;
                        case 6:
                            message.worker = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an ExecutionError message.
                 * @function verify
                 * @memberof flyteidl.core.ExecutionError
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ExecutionError.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.code != null && message.hasOwnProperty("code"))
                        if (!$util.isString(message.code))
                            return "code: string expected";
                    if (message.message != null && message.hasOwnProperty("message"))
                        if (!$util.isString(message.message))
                            return "message: string expected";
                    if (message.errorUri != null && message.hasOwnProperty("errorUri"))
                        if (!$util.isString(message.errorUri))
                            return "errorUri: string expected";
                    if (message.kind != null && message.hasOwnProperty("kind"))
                        switch (message.kind) {
                        default:
                            return "kind: enum value expected";
                        case 0:
                        case 1:
                        case 2:
                            break;
                        }
                    if (message.timestamp != null && message.hasOwnProperty("timestamp")) {
                        var error = $root.google.protobuf.Timestamp.verify(message.timestamp);
                        if (error)
                            return "timestamp." + error;
                    }
                    if (message.worker != null && message.hasOwnProperty("worker"))
                        if (!$util.isString(message.worker))
                            return "worker: string expected";
                    return null;
                };
    
                /**
                 * ErrorKind enum.
                 * @name flyteidl.core.ExecutionError.ErrorKind
                 * @enum {string}
                 * @property {number} UNKNOWN=0 UNKNOWN value
                 * @property {number} USER=1 USER value
                 * @property {number} SYSTEM=2 SYSTEM value
                 */
                ExecutionError.ErrorKind = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "UNKNOWN"] = 0;
                    values[valuesById[1] = "USER"] = 1;
                    values[valuesById[2] = "SYSTEM"] = 2;
                    return values;
                })();
    
                return ExecutionError;
            })();
    
            core.TaskLog = (function() {
    
                /**
                 * Properties of a TaskLog.
                 * @memberof flyteidl.core
                 * @interface ITaskLog
                 * @property {string|null} [uri] TaskLog uri
                 * @property {string|null} [name] TaskLog name
                 * @property {flyteidl.core.TaskLog.MessageFormat|null} [messageFormat] TaskLog messageFormat
                 * @property {google.protobuf.IDuration|null} [ttl] TaskLog ttl
                 * @property {boolean|null} [ShowWhilePending] TaskLog ShowWhilePending
                 * @property {boolean|null} [HideOnceFinished] TaskLog HideOnceFinished
                 */
    
                /**
                 * Constructs a new TaskLog.
                 * @memberof flyteidl.core
                 * @classdesc Represents a TaskLog.
                 * @implements ITaskLog
                 * @constructor
                 * @param {flyteidl.core.ITaskLog=} [properties] Properties to set
                 */
                function TaskLog(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * TaskLog uri.
                 * @member {string} uri
                 * @memberof flyteidl.core.TaskLog
                 * @instance
                 */
                TaskLog.prototype.uri = "";
    
                /**
                 * TaskLog name.
                 * @member {string} name
                 * @memberof flyteidl.core.TaskLog
                 * @instance
                 */
                TaskLog.prototype.name = "";
    
                /**
                 * TaskLog messageFormat.
                 * @member {flyteidl.core.TaskLog.MessageFormat} messageFormat
                 * @memberof flyteidl.core.TaskLog
                 * @instance
                 */
                TaskLog.prototype.messageFormat = 0;
    
                /**
                 * TaskLog ttl.
                 * @member {google.protobuf.IDuration|null|undefined} ttl
                 * @memberof flyteidl.core.TaskLog
                 * @instance
                 */
                TaskLog.prototype.ttl = null;
    
                /**
                 * TaskLog ShowWhilePending.
                 * @member {boolean} ShowWhilePending
                 * @memberof flyteidl.core.TaskLog
                 * @instance
                 */
                TaskLog.prototype.ShowWhilePending = false;
    
                /**
                 * TaskLog HideOnceFinished.
                 * @member {boolean} HideOnceFinished
                 * @memberof flyteidl.core.TaskLog
                 * @instance
                 */
                TaskLog.prototype.HideOnceFinished = false;
    
                /**
                 * Creates a new TaskLog instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.TaskLog
                 * @static
                 * @param {flyteidl.core.ITaskLog=} [properties] Properties to set
                 * @returns {flyteidl.core.TaskLog} TaskLog instance
                 */
                TaskLog.create = function create(properties) {
                    return new TaskLog(properties);
                };
    
                /**
                 * Encodes the specified TaskLog message. Does not implicitly {@link flyteidl.core.TaskLog.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.TaskLog
                 * @static
                 * @param {flyteidl.core.ITaskLog} message TaskLog message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TaskLog.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.uri != null && message.hasOwnProperty("uri"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.uri);
                    if (message.name != null && message.hasOwnProperty("name"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.name);
                    if (message.messageFormat != null && message.hasOwnProperty("messageFormat"))
                        writer.uint32(/* id 3, wireType 0 =*/24).int32(message.messageFormat);
                    if (message.ttl != null && message.hasOwnProperty("ttl"))
                        $root.google.protobuf.Duration.encode(message.ttl, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.ShowWhilePending != null && message.hasOwnProperty("ShowWhilePending"))
                        writer.uint32(/* id 5, wireType 0 =*/40).bool(message.ShowWhilePending);
                    if (message.HideOnceFinished != null && message.hasOwnProperty("HideOnceFinished"))
                        writer.uint32(/* id 6, wireType 0 =*/48).bool(message.HideOnceFinished);
                    return writer;
                };
    
                /**
                 * Decodes a TaskLog message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.TaskLog
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.TaskLog} TaskLog
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TaskLog.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.TaskLog();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.uri = reader.string();
                            break;
                        case 2:
                            message.name = reader.string();
                            break;
                        case 3:
                            message.messageFormat = reader.int32();
                            break;
                        case 4:
                            message.ttl = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                            break;
                        case 5:
                            message.ShowWhilePending = reader.bool();
                            break;
                        case 6:
                            message.HideOnceFinished = reader.bool();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a TaskLog message.
                 * @function verify
                 * @memberof flyteidl.core.TaskLog
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TaskLog.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.uri != null && message.hasOwnProperty("uri"))
                        if (!$util.isString(message.uri))
                            return "uri: string expected";
                    if (message.name != null && message.hasOwnProperty("name"))
                        if (!$util.isString(message.name))
                            return "name: string expected";
                    if (message.messageFormat != null && message.hasOwnProperty("messageFormat"))
                        switch (message.messageFormat) {
                        default:
                            return "messageFormat: enum value expected";
                        case 0:
                        case 1:
                        case 2:
                            break;
                        }
                    if (message.ttl != null && message.hasOwnProperty("ttl")) {
                        var error = $root.google.protobuf.Duration.verify(message.ttl);
                        if (error)
                            return "ttl." + error;
                    }
                    if (message.ShowWhilePending != null && message.hasOwnProperty("ShowWhilePending"))
                        if (typeof message.ShowWhilePending !== "boolean")
                            return "ShowWhilePending: boolean expected";
                    if (message.HideOnceFinished != null && message.hasOwnProperty("HideOnceFinished"))
                        if (typeof message.HideOnceFinished !== "boolean")
                            return "HideOnceFinished: boolean expected";
                    return null;
                };
    
                /**
                 * MessageFormat enum.
                 * @name flyteidl.core.TaskLog.MessageFormat
                 * @enum {string}
                 * @property {number} UNKNOWN=0 UNKNOWN value
                 * @property {number} CSV=1 CSV value
                 * @property {number} JSON=2 JSON value
                 */
                TaskLog.MessageFormat = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "UNKNOWN"] = 0;
                    values[valuesById[1] = "CSV"] = 1;
                    values[valuesById[2] = "JSON"] = 2;
                    return values;
                })();
    
                return TaskLog;
            })();
    
            core.QualityOfServiceSpec = (function() {
    
                /**
                 * Properties of a QualityOfServiceSpec.
                 * @memberof flyteidl.core
                 * @interface IQualityOfServiceSpec
                 * @property {google.protobuf.IDuration|null} [queueingBudget] QualityOfServiceSpec queueingBudget
                 */
    
                /**
                 * Constructs a new QualityOfServiceSpec.
                 * @memberof flyteidl.core
                 * @classdesc Represents a QualityOfServiceSpec.
                 * @implements IQualityOfServiceSpec
                 * @constructor
                 * @param {flyteidl.core.IQualityOfServiceSpec=} [properties] Properties to set
                 */
                function QualityOfServiceSpec(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * QualityOfServiceSpec queueingBudget.
                 * @member {google.protobuf.IDuration|null|undefined} queueingBudget
                 * @memberof flyteidl.core.QualityOfServiceSpec
                 * @instance
                 */
                QualityOfServiceSpec.prototype.queueingBudget = null;
    
                /**
                 * Creates a new QualityOfServiceSpec instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.QualityOfServiceSpec
                 * @static
                 * @param {flyteidl.core.IQualityOfServiceSpec=} [properties] Properties to set
                 * @returns {flyteidl.core.QualityOfServiceSpec} QualityOfServiceSpec instance
                 */
                QualityOfServiceSpec.create = function create(properties) {
                    return new QualityOfServiceSpec(properties);
                };
    
                /**
                 * Encodes the specified QualityOfServiceSpec message. Does not implicitly {@link flyteidl.core.QualityOfServiceSpec.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.QualityOfServiceSpec
                 * @static
                 * @param {flyteidl.core.IQualityOfServiceSpec} message QualityOfServiceSpec message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                QualityOfServiceSpec.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.queueingBudget != null && message.hasOwnProperty("queueingBudget"))
                        $root.google.protobuf.Duration.encode(message.queueingBudget, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a QualityOfServiceSpec message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.QualityOfServiceSpec
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.QualityOfServiceSpec} QualityOfServiceSpec
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                QualityOfServiceSpec.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.QualityOfServiceSpec();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.queueingBudget = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a QualityOfServiceSpec message.
                 * @function verify
                 * @memberof flyteidl.core.QualityOfServiceSpec
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                QualityOfServiceSpec.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.queueingBudget != null && message.hasOwnProperty("queueingBudget")) {
                        var error = $root.google.protobuf.Duration.verify(message.queueingBudget);
                        if (error)
                            return "queueingBudget." + error;
                    }
                    return null;
                };
    
                return QualityOfServiceSpec;
            })();
    
            core.QualityOfService = (function() {
    
                /**
                 * Properties of a QualityOfService.
                 * @memberof flyteidl.core
                 * @interface IQualityOfService
                 * @property {flyteidl.core.QualityOfService.Tier|null} [tier] QualityOfService tier
                 * @property {flyteidl.core.IQualityOfServiceSpec|null} [spec] QualityOfService spec
                 */
    
                /**
                 * Constructs a new QualityOfService.
                 * @memberof flyteidl.core
                 * @classdesc Represents a QualityOfService.
                 * @implements IQualityOfService
                 * @constructor
                 * @param {flyteidl.core.IQualityOfService=} [properties] Properties to set
                 */
                function QualityOfService(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * QualityOfService tier.
                 * @member {flyteidl.core.QualityOfService.Tier} tier
                 * @memberof flyteidl.core.QualityOfService
                 * @instance
                 */
                QualityOfService.prototype.tier = 0;
    
                /**
                 * QualityOfService spec.
                 * @member {flyteidl.core.IQualityOfServiceSpec|null|undefined} spec
                 * @memberof flyteidl.core.QualityOfService
                 * @instance
                 */
                QualityOfService.prototype.spec = null;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * QualityOfService designation.
                 * @member {"tier"|"spec"|undefined} designation
                 * @memberof flyteidl.core.QualityOfService
                 * @instance
                 */
                Object.defineProperty(QualityOfService.prototype, "designation", {
                    get: $util.oneOfGetter($oneOfFields = ["tier", "spec"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new QualityOfService instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.QualityOfService
                 * @static
                 * @param {flyteidl.core.IQualityOfService=} [properties] Properties to set
                 * @returns {flyteidl.core.QualityOfService} QualityOfService instance
                 */
                QualityOfService.create = function create(properties) {
                    return new QualityOfService(properties);
                };
    
                /**
                 * Encodes the specified QualityOfService message. Does not implicitly {@link flyteidl.core.QualityOfService.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.QualityOfService
                 * @static
                 * @param {flyteidl.core.IQualityOfService} message QualityOfService message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                QualityOfService.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.tier != null && message.hasOwnProperty("tier"))
                        writer.uint32(/* id 1, wireType 0 =*/8).int32(message.tier);
                    if (message.spec != null && message.hasOwnProperty("spec"))
                        $root.flyteidl.core.QualityOfServiceSpec.encode(message.spec, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a QualityOfService message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.QualityOfService
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.QualityOfService} QualityOfService
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                QualityOfService.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.QualityOfService();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.tier = reader.int32();
                            break;
                        case 2:
                            message.spec = $root.flyteidl.core.QualityOfServiceSpec.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a QualityOfService message.
                 * @function verify
                 * @memberof flyteidl.core.QualityOfService
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                QualityOfService.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.tier != null && message.hasOwnProperty("tier")) {
                        properties.designation = 1;
                        switch (message.tier) {
                        default:
                            return "tier: enum value expected";
                        case 0:
                        case 1:
                        case 2:
                        case 3:
                            break;
                        }
                    }
                    if (message.spec != null && message.hasOwnProperty("spec")) {
                        if (properties.designation === 1)
                            return "designation: multiple values";
                        properties.designation = 1;
                        {
                            var error = $root.flyteidl.core.QualityOfServiceSpec.verify(message.spec);
                            if (error)
                                return "spec." + error;
                        }
                    }
                    return null;
                };
    
                /**
                 * Tier enum.
                 * @name flyteidl.core.QualityOfService.Tier
                 * @enum {string}
                 * @property {number} UNDEFINED=0 UNDEFINED value
                 * @property {number} HIGH=1 HIGH value
                 * @property {number} MEDIUM=2 MEDIUM value
                 * @property {number} LOW=3 LOW value
                 */
                QualityOfService.Tier = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "UNDEFINED"] = 0;
                    values[valuesById[1] = "HIGH"] = 1;
                    values[valuesById[2] = "MEDIUM"] = 2;
                    values[valuesById[3] = "LOW"] = 3;
                    return values;
                })();
    
                return QualityOfService;
            })();
    
            core.Resources = (function() {
    
                /**
                 * Properties of a Resources.
                 * @memberof flyteidl.core
                 * @interface IResources
                 * @property {Array.<flyteidl.core.Resources.IResourceEntry>|null} [requests] Resources requests
                 * @property {Array.<flyteidl.core.Resources.IResourceEntry>|null} [limits] Resources limits
                 */
    
                /**
                 * Constructs a new Resources.
                 * @memberof flyteidl.core
                 * @classdesc Represents a Resources.
                 * @implements IResources
                 * @constructor
                 * @param {flyteidl.core.IResources=} [properties] Properties to set
                 */
                function Resources(properties) {
                    this.requests = [];
                    this.limits = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Resources requests.
                 * @member {Array.<flyteidl.core.Resources.IResourceEntry>} requests
                 * @memberof flyteidl.core.Resources
                 * @instance
                 */
                Resources.prototype.requests = $util.emptyArray;
    
                /**
                 * Resources limits.
                 * @member {Array.<flyteidl.core.Resources.IResourceEntry>} limits
                 * @memberof flyteidl.core.Resources
                 * @instance
                 */
                Resources.prototype.limits = $util.emptyArray;
    
                /**
                 * Creates a new Resources instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Resources
                 * @static
                 * @param {flyteidl.core.IResources=} [properties] Properties to set
                 * @returns {flyteidl.core.Resources} Resources instance
                 */
                Resources.create = function create(properties) {
                    return new Resources(properties);
                };
    
                /**
                 * Encodes the specified Resources message. Does not implicitly {@link flyteidl.core.Resources.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Resources
                 * @static
                 * @param {flyteidl.core.IResources} message Resources message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Resources.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.requests != null && message.requests.length)
                        for (var i = 0; i < message.requests.length; ++i)
                            $root.flyteidl.core.Resources.ResourceEntry.encode(message.requests[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.limits != null && message.limits.length)
                        for (var i = 0; i < message.limits.length; ++i)
                            $root.flyteidl.core.Resources.ResourceEntry.encode(message.limits[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a Resources message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Resources
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Resources} Resources
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Resources.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Resources();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            if (!(message.requests && message.requests.length))
                                message.requests = [];
                            message.requests.push($root.flyteidl.core.Resources.ResourceEntry.decode(reader, reader.uint32()));
                            break;
                        case 2:
                            if (!(message.limits && message.limits.length))
                                message.limits = [];
                            message.limits.push($root.flyteidl.core.Resources.ResourceEntry.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a Resources message.
                 * @function verify
                 * @memberof flyteidl.core.Resources
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Resources.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.requests != null && message.hasOwnProperty("requests")) {
                        if (!Array.isArray(message.requests))
                            return "requests: array expected";
                        for (var i = 0; i < message.requests.length; ++i) {
                            var error = $root.flyteidl.core.Resources.ResourceEntry.verify(message.requests[i]);
                            if (error)
                                return "requests." + error;
                        }
                    }
                    if (message.limits != null && message.hasOwnProperty("limits")) {
                        if (!Array.isArray(message.limits))
                            return "limits: array expected";
                        for (var i = 0; i < message.limits.length; ++i) {
                            var error = $root.flyteidl.core.Resources.ResourceEntry.verify(message.limits[i]);
                            if (error)
                                return "limits." + error;
                        }
                    }
                    return null;
                };
    
                /**
                 * ResourceName enum.
                 * @name flyteidl.core.Resources.ResourceName
                 * @enum {string}
                 * @property {number} UNKNOWN=0 UNKNOWN value
                 * @property {number} CPU=1 CPU value
                 * @property {number} GPU=2 GPU value
                 * @property {number} MEMORY=3 MEMORY value
                 * @property {number} STORAGE=4 STORAGE value
                 * @property {number} EPHEMERAL_STORAGE=5 EPHEMERAL_STORAGE value
                 */
                Resources.ResourceName = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "UNKNOWN"] = 0;
                    values[valuesById[1] = "CPU"] = 1;
                    values[valuesById[2] = "GPU"] = 2;
                    values[valuesById[3] = "MEMORY"] = 3;
                    values[valuesById[4] = "STORAGE"] = 4;
                    values[valuesById[5] = "EPHEMERAL_STORAGE"] = 5;
                    return values;
                })();
    
                Resources.ResourceEntry = (function() {
    
                    /**
                     * Properties of a ResourceEntry.
                     * @memberof flyteidl.core.Resources
                     * @interface IResourceEntry
                     * @property {flyteidl.core.Resources.ResourceName|null} [name] ResourceEntry name
                     * @property {string|null} [value] ResourceEntry value
                     */
    
                    /**
                     * Constructs a new ResourceEntry.
                     * @memberof flyteidl.core.Resources
                     * @classdesc Represents a ResourceEntry.
                     * @implements IResourceEntry
                     * @constructor
                     * @param {flyteidl.core.Resources.IResourceEntry=} [properties] Properties to set
                     */
                    function ResourceEntry(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ResourceEntry name.
                     * @member {flyteidl.core.Resources.ResourceName} name
                     * @memberof flyteidl.core.Resources.ResourceEntry
                     * @instance
                     */
                    ResourceEntry.prototype.name = 0;
    
                    /**
                     * ResourceEntry value.
                     * @member {string} value
                     * @memberof flyteidl.core.Resources.ResourceEntry
                     * @instance
                     */
                    ResourceEntry.prototype.value = "";
    
                    /**
                     * Creates a new ResourceEntry instance using the specified properties.
                     * @function create
                     * @memberof flyteidl.core.Resources.ResourceEntry
                     * @static
                     * @param {flyteidl.core.Resources.IResourceEntry=} [properties] Properties to set
                     * @returns {flyteidl.core.Resources.ResourceEntry} ResourceEntry instance
                     */
                    ResourceEntry.create = function create(properties) {
                        return new ResourceEntry(properties);
                    };
    
                    /**
                     * Encodes the specified ResourceEntry message. Does not implicitly {@link flyteidl.core.Resources.ResourceEntry.verify|verify} messages.
                     * @function encode
                     * @memberof flyteidl.core.Resources.ResourceEntry
                     * @static
                     * @param {flyteidl.core.Resources.IResourceEntry} message ResourceEntry message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ResourceEntry.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.name != null && message.hasOwnProperty("name"))
                            writer.uint32(/* id 1, wireType 0 =*/8).int32(message.name);
                        if (message.value != null && message.hasOwnProperty("value"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.value);
                        return writer;
                    };
    
                    /**
                     * Decodes a ResourceEntry message from the specified reader or buffer.
                     * @function decode
                     * @memberof flyteidl.core.Resources.ResourceEntry
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {flyteidl.core.Resources.ResourceEntry} ResourceEntry
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ResourceEntry.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Resources.ResourceEntry();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.name = reader.int32();
                                break;
                            case 2:
                                message.value = reader.string();
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Verifies a ResourceEntry message.
                     * @function verify
                     * @memberof flyteidl.core.Resources.ResourceEntry
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ResourceEntry.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.name != null && message.hasOwnProperty("name"))
                            switch (message.name) {
                            default:
                                return "name: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                            case 3:
                            case 4:
                            case 5:
                                break;
                            }
                        if (message.value != null && message.hasOwnProperty("value"))
                            if (!$util.isString(message.value))
                                return "value: string expected";
                        return null;
                    };
    
                    return ResourceEntry;
                })();
    
                return Resources;
            })();
    
            core.GPUAccelerator = (function() {
    
                /**
                 * Properties of a GPUAccelerator.
                 * @memberof flyteidl.core
                 * @interface IGPUAccelerator
                 * @property {string|null} [device] GPUAccelerator device
                 * @property {boolean|null} [unpartitioned] GPUAccelerator unpartitioned
                 * @property {string|null} [partitionSize] GPUAccelerator partitionSize
                 */
    
                /**
                 * Constructs a new GPUAccelerator.
                 * @memberof flyteidl.core
                 * @classdesc Represents a GPUAccelerator.
                 * @implements IGPUAccelerator
                 * @constructor
                 * @param {flyteidl.core.IGPUAccelerator=} [properties] Properties to set
                 */
                function GPUAccelerator(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * GPUAccelerator device.
                 * @member {string} device
                 * @memberof flyteidl.core.GPUAccelerator
                 * @instance
                 */
                GPUAccelerator.prototype.device = "";
    
                /**
                 * GPUAccelerator unpartitioned.
                 * @member {boolean} unpartitioned
                 * @memberof flyteidl.core.GPUAccelerator
                 * @instance
                 */
                GPUAccelerator.prototype.unpartitioned = false;
    
                /**
                 * GPUAccelerator partitionSize.
                 * @member {string} partitionSize
                 * @memberof flyteidl.core.GPUAccelerator
                 * @instance
                 */
                GPUAccelerator.prototype.partitionSize = "";
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * GPUAccelerator partitionSizeValue.
                 * @member {"unpartitioned"|"partitionSize"|undefined} partitionSizeValue
                 * @memberof flyteidl.core.GPUAccelerator
                 * @instance
                 */
                Object.defineProperty(GPUAccelerator.prototype, "partitionSizeValue", {
                    get: $util.oneOfGetter($oneOfFields = ["unpartitioned", "partitionSize"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new GPUAccelerator instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.GPUAccelerator
                 * @static
                 * @param {flyteidl.core.IGPUAccelerator=} [properties] Properties to set
                 * @returns {flyteidl.core.GPUAccelerator} GPUAccelerator instance
                 */
                GPUAccelerator.create = function create(properties) {
                    return new GPUAccelerator(properties);
                };
    
                /**
                 * Encodes the specified GPUAccelerator message. Does not implicitly {@link flyteidl.core.GPUAccelerator.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.GPUAccelerator
                 * @static
                 * @param {flyteidl.core.IGPUAccelerator} message GPUAccelerator message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                GPUAccelerator.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.device != null && message.hasOwnProperty("device"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.device);
                    if (message.unpartitioned != null && message.hasOwnProperty("unpartitioned"))
                        writer.uint32(/* id 2, wireType 0 =*/16).bool(message.unpartitioned);
                    if (message.partitionSize != null && message.hasOwnProperty("partitionSize"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.partitionSize);
                    return writer;
                };
    
                /**
                 * Decodes a GPUAccelerator message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.GPUAccelerator
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.GPUAccelerator} GPUAccelerator
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                GPUAccelerator.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.GPUAccelerator();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.device = reader.string();
                            break;
                        case 2:
                            message.unpartitioned = reader.bool();
                            break;
                        case 3:
                            message.partitionSize = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a GPUAccelerator message.
                 * @function verify
                 * @memberof flyteidl.core.GPUAccelerator
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                GPUAccelerator.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.device != null && message.hasOwnProperty("device"))
                        if (!$util.isString(message.device))
                            return "device: string expected";
                    if (message.unpartitioned != null && message.hasOwnProperty("unpartitioned")) {
                        properties.partitionSizeValue = 1;
                        if (typeof message.unpartitioned !== "boolean")
                            return "unpartitioned: boolean expected";
                    }
                    if (message.partitionSize != null && message.hasOwnProperty("partitionSize")) {
                        if (properties.partitionSizeValue === 1)
                            return "partitionSizeValue: multiple values";
                        properties.partitionSizeValue = 1;
                        if (!$util.isString(message.partitionSize))
                            return "partitionSize: string expected";
                    }
                    return null;
                };
    
                return GPUAccelerator;
            })();
    
            core.ExtendedResources = (function() {
    
                /**
                 * Properties of an ExtendedResources.
                 * @memberof flyteidl.core
                 * @interface IExtendedResources
                 * @property {flyteidl.core.IGPUAccelerator|null} [gpuAccelerator] ExtendedResources gpuAccelerator
                 */
    
                /**
                 * Constructs a new ExtendedResources.
                 * @memberof flyteidl.core
                 * @classdesc Represents an ExtendedResources.
                 * @implements IExtendedResources
                 * @constructor
                 * @param {flyteidl.core.IExtendedResources=} [properties] Properties to set
                 */
                function ExtendedResources(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * ExtendedResources gpuAccelerator.
                 * @member {flyteidl.core.IGPUAccelerator|null|undefined} gpuAccelerator
                 * @memberof flyteidl.core.ExtendedResources
                 * @instance
                 */
                ExtendedResources.prototype.gpuAccelerator = null;
    
                /**
                 * Creates a new ExtendedResources instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.ExtendedResources
                 * @static
                 * @param {flyteidl.core.IExtendedResources=} [properties] Properties to set
                 * @returns {flyteidl.core.ExtendedResources} ExtendedResources instance
                 */
                ExtendedResources.create = function create(properties) {
                    return new ExtendedResources(properties);
                };
    
                /**
                 * Encodes the specified ExtendedResources message. Does not implicitly {@link flyteidl.core.ExtendedResources.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.ExtendedResources
                 * @static
                 * @param {flyteidl.core.IExtendedResources} message ExtendedResources message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ExtendedResources.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.gpuAccelerator != null && message.hasOwnProperty("gpuAccelerator"))
                        $root.flyteidl.core.GPUAccelerator.encode(message.gpuAccelerator, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes an ExtendedResources message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.ExtendedResources
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.ExtendedResources} ExtendedResources
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ExtendedResources.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.ExtendedResources();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.gpuAccelerator = $root.flyteidl.core.GPUAccelerator.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an ExtendedResources message.
                 * @function verify
                 * @memberof flyteidl.core.ExtendedResources
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ExtendedResources.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.gpuAccelerator != null && message.hasOwnProperty("gpuAccelerator")) {
                        var error = $root.flyteidl.core.GPUAccelerator.verify(message.gpuAccelerator);
                        if (error)
                            return "gpuAccelerator." + error;
                    }
                    return null;
                };
    
                return ExtendedResources;
            })();
    
            core.RuntimeMetadata = (function() {
    
                /**
                 * Properties of a RuntimeMetadata.
                 * @memberof flyteidl.core
                 * @interface IRuntimeMetadata
                 * @property {flyteidl.core.RuntimeMetadata.RuntimeType|null} [type] RuntimeMetadata type
                 * @property {string|null} [version] RuntimeMetadata version
                 * @property {string|null} [flavor] RuntimeMetadata flavor
                 */
    
                /**
                 * Constructs a new RuntimeMetadata.
                 * @memberof flyteidl.core
                 * @classdesc Represents a RuntimeMetadata.
                 * @implements IRuntimeMetadata
                 * @constructor
                 * @param {flyteidl.core.IRuntimeMetadata=} [properties] Properties to set
                 */
                function RuntimeMetadata(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * RuntimeMetadata type.
                 * @member {flyteidl.core.RuntimeMetadata.RuntimeType} type
                 * @memberof flyteidl.core.RuntimeMetadata
                 * @instance
                 */
                RuntimeMetadata.prototype.type = 0;
    
                /**
                 * RuntimeMetadata version.
                 * @member {string} version
                 * @memberof flyteidl.core.RuntimeMetadata
                 * @instance
                 */
                RuntimeMetadata.prototype.version = "";
    
                /**
                 * RuntimeMetadata flavor.
                 * @member {string} flavor
                 * @memberof flyteidl.core.RuntimeMetadata
                 * @instance
                 */
                RuntimeMetadata.prototype.flavor = "";
    
                /**
                 * Creates a new RuntimeMetadata instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.RuntimeMetadata
                 * @static
                 * @param {flyteidl.core.IRuntimeMetadata=} [properties] Properties to set
                 * @returns {flyteidl.core.RuntimeMetadata} RuntimeMetadata instance
                 */
                RuntimeMetadata.create = function create(properties) {
                    return new RuntimeMetadata(properties);
                };
    
                /**
                 * Encodes the specified RuntimeMetadata message. Does not implicitly {@link flyteidl.core.RuntimeMetadata.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.RuntimeMetadata
                 * @static
                 * @param {flyteidl.core.IRuntimeMetadata} message RuntimeMetadata message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                RuntimeMetadata.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.type != null && message.hasOwnProperty("type"))
                        writer.uint32(/* id 1, wireType 0 =*/8).int32(message.type);
                    if (message.version != null && message.hasOwnProperty("version"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.version);
                    if (message.flavor != null && message.hasOwnProperty("flavor"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.flavor);
                    return writer;
                };
    
                /**
                 * Decodes a RuntimeMetadata message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.RuntimeMetadata
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.RuntimeMetadata} RuntimeMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                RuntimeMetadata.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.RuntimeMetadata();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.type = reader.int32();
                            break;
                        case 2:
                            message.version = reader.string();
                            break;
                        case 3:
                            message.flavor = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a RuntimeMetadata message.
                 * @function verify
                 * @memberof flyteidl.core.RuntimeMetadata
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                RuntimeMetadata.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.type != null && message.hasOwnProperty("type"))
                        switch (message.type) {
                        default:
                            return "type: enum value expected";
                        case 0:
                        case 1:
                            break;
                        }
                    if (message.version != null && message.hasOwnProperty("version"))
                        if (!$util.isString(message.version))
                            return "version: string expected";
                    if (message.flavor != null && message.hasOwnProperty("flavor"))
                        if (!$util.isString(message.flavor))
                            return "flavor: string expected";
                    return null;
                };
    
                /**
                 * RuntimeType enum.
                 * @name flyteidl.core.RuntimeMetadata.RuntimeType
                 * @enum {string}
                 * @property {number} OTHER=0 OTHER value
                 * @property {number} FLYTE_SDK=1 FLYTE_SDK value
                 */
                RuntimeMetadata.RuntimeType = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "OTHER"] = 0;
                    values[valuesById[1] = "FLYTE_SDK"] = 1;
                    return values;
                })();
    
                return RuntimeMetadata;
            })();
    
            core.TaskMetadata = (function() {
    
                /**
                 * Properties of a TaskMetadata.
                 * @memberof flyteidl.core
                 * @interface ITaskMetadata
                 * @property {boolean|null} [discoverable] TaskMetadata discoverable
                 * @property {flyteidl.core.IRuntimeMetadata|null} [runtime] TaskMetadata runtime
                 * @property {google.protobuf.IDuration|null} [timeout] TaskMetadata timeout
                 * @property {flyteidl.core.IRetryStrategy|null} [retries] TaskMetadata retries
                 * @property {string|null} [discoveryVersion] TaskMetadata discoveryVersion
                 * @property {string|null} [deprecatedErrorMessage] TaskMetadata deprecatedErrorMessage
                 * @property {boolean|null} [interruptible] TaskMetadata interruptible
                 * @property {boolean|null} [cacheSerializable] TaskMetadata cacheSerializable
                 * @property {boolean|null} [generatesDeck] TaskMetadata generatesDeck
                 * @property {Object.<string,string>|null} [tags] TaskMetadata tags
                 * @property {string|null} [podTemplateName] TaskMetadata podTemplateName
                 * @property {Array.<string>|null} [cacheIgnoreInputVars] TaskMetadata cacheIgnoreInputVars
                 * @property {boolean|null} [isEager] TaskMetadata isEager
                 */
    
                /**
                 * Constructs a new TaskMetadata.
                 * @memberof flyteidl.core
                 * @classdesc Represents a TaskMetadata.
                 * @implements ITaskMetadata
                 * @constructor
                 * @param {flyteidl.core.ITaskMetadata=} [properties] Properties to set
                 */
                function TaskMetadata(properties) {
                    this.tags = {};
                    this.cacheIgnoreInputVars = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * TaskMetadata discoverable.
                 * @member {boolean} discoverable
                 * @memberof flyteidl.core.TaskMetadata
                 * @instance
                 */
                TaskMetadata.prototype.discoverable = false;
    
                /**
                 * TaskMetadata runtime.
                 * @member {flyteidl.core.IRuntimeMetadata|null|undefined} runtime
                 * @memberof flyteidl.core.TaskMetadata
                 * @instance
                 */
                TaskMetadata.prototype.runtime = null;
    
                /**
                 * TaskMetadata timeout.
                 * @member {google.protobuf.IDuration|null|undefined} timeout
                 * @memberof flyteidl.core.TaskMetadata
                 * @instance
                 */
                TaskMetadata.prototype.timeout = null;
    
                /**
                 * TaskMetadata retries.
                 * @member {flyteidl.core.IRetryStrategy|null|undefined} retries
                 * @memberof flyteidl.core.TaskMetadata
                 * @instance
                 */
                TaskMetadata.prototype.retries = null;
    
                /**
                 * TaskMetadata discoveryVersion.
                 * @member {string} discoveryVersion
                 * @memberof flyteidl.core.TaskMetadata
                 * @instance
                 */
                TaskMetadata.prototype.discoveryVersion = "";
    
                /**
                 * TaskMetadata deprecatedErrorMessage.
                 * @member {string} deprecatedErrorMessage
                 * @memberof flyteidl.core.TaskMetadata
                 * @instance
                 */
                TaskMetadata.prototype.deprecatedErrorMessage = "";
    
                /**
                 * TaskMetadata interruptible.
                 * @member {boolean} interruptible
                 * @memberof flyteidl.core.TaskMetadata
                 * @instance
                 */
                TaskMetadata.prototype.interruptible = false;
    
                /**
                 * TaskMetadata cacheSerializable.
                 * @member {boolean} cacheSerializable
                 * @memberof flyteidl.core.TaskMetadata
                 * @instance
                 */
                TaskMetadata.prototype.cacheSerializable = false;
    
                /**
                 * TaskMetadata generatesDeck.
                 * @member {boolean} generatesDeck
                 * @memberof flyteidl.core.TaskMetadata
                 * @instance
                 */
                TaskMetadata.prototype.generatesDeck = false;
    
                /**
                 * TaskMetadata tags.
                 * @member {Object.<string,string>} tags
                 * @memberof flyteidl.core.TaskMetadata
                 * @instance
                 */
                TaskMetadata.prototype.tags = $util.emptyObject;
    
                /**
                 * TaskMetadata podTemplateName.
                 * @member {string} podTemplateName
                 * @memberof flyteidl.core.TaskMetadata
                 * @instance
                 */
                TaskMetadata.prototype.podTemplateName = "";
    
                /**
                 * TaskMetadata cacheIgnoreInputVars.
                 * @member {Array.<string>} cacheIgnoreInputVars
                 * @memberof flyteidl.core.TaskMetadata
                 * @instance
                 */
                TaskMetadata.prototype.cacheIgnoreInputVars = $util.emptyArray;
    
                /**
                 * TaskMetadata isEager.
                 * @member {boolean} isEager
                 * @memberof flyteidl.core.TaskMetadata
                 * @instance
                 */
                TaskMetadata.prototype.isEager = false;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * TaskMetadata interruptibleValue.
                 * @member {"interruptible"|undefined} interruptibleValue
                 * @memberof flyteidl.core.TaskMetadata
                 * @instance
                 */
                Object.defineProperty(TaskMetadata.prototype, "interruptibleValue", {
                    get: $util.oneOfGetter($oneOfFields = ["interruptible"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new TaskMetadata instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.TaskMetadata
                 * @static
                 * @param {flyteidl.core.ITaskMetadata=} [properties] Properties to set
                 * @returns {flyteidl.core.TaskMetadata} TaskMetadata instance
                 */
                TaskMetadata.create = function create(properties) {
                    return new TaskMetadata(properties);
                };
    
                /**
                 * Encodes the specified TaskMetadata message. Does not implicitly {@link flyteidl.core.TaskMetadata.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.TaskMetadata
                 * @static
                 * @param {flyteidl.core.ITaskMetadata} message TaskMetadata message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TaskMetadata.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.discoverable != null && message.hasOwnProperty("discoverable"))
                        writer.uint32(/* id 1, wireType 0 =*/8).bool(message.discoverable);
                    if (message.runtime != null && message.hasOwnProperty("runtime"))
                        $root.flyteidl.core.RuntimeMetadata.encode(message.runtime, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.timeout != null && message.hasOwnProperty("timeout"))
                        $root.google.protobuf.Duration.encode(message.timeout, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.retries != null && message.hasOwnProperty("retries"))
                        $root.flyteidl.core.RetryStrategy.encode(message.retries, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                    if (message.discoveryVersion != null && message.hasOwnProperty("discoveryVersion"))
                        writer.uint32(/* id 6, wireType 2 =*/50).string(message.discoveryVersion);
                    if (message.deprecatedErrorMessage != null && message.hasOwnProperty("deprecatedErrorMessage"))
                        writer.uint32(/* id 7, wireType 2 =*/58).string(message.deprecatedErrorMessage);
                    if (message.interruptible != null && message.hasOwnProperty("interruptible"))
                        writer.uint32(/* id 8, wireType 0 =*/64).bool(message.interruptible);
                    if (message.cacheSerializable != null && message.hasOwnProperty("cacheSerializable"))
                        writer.uint32(/* id 9, wireType 0 =*/72).bool(message.cacheSerializable);
                    if (message.generatesDeck != null && message.hasOwnProperty("generatesDeck"))
                        writer.uint32(/* id 10, wireType 0 =*/80).bool(message.generatesDeck);
                    if (message.tags != null && message.hasOwnProperty("tags"))
                        for (var keys = Object.keys(message.tags), i = 0; i < keys.length; ++i)
                            writer.uint32(/* id 11, wireType 2 =*/90).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.tags[keys[i]]).ldelim();
                    if (message.podTemplateName != null && message.hasOwnProperty("podTemplateName"))
                        writer.uint32(/* id 12, wireType 2 =*/98).string(message.podTemplateName);
                    if (message.cacheIgnoreInputVars != null && message.cacheIgnoreInputVars.length)
                        for (var i = 0; i < message.cacheIgnoreInputVars.length; ++i)
                            writer.uint32(/* id 13, wireType 2 =*/106).string(message.cacheIgnoreInputVars[i]);
                    if (message.isEager != null && message.hasOwnProperty("isEager"))
                        writer.uint32(/* id 14, wireType 0 =*/112).bool(message.isEager);
                    return writer;
                };
    
                /**
                 * Decodes a TaskMetadata message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.TaskMetadata
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.TaskMetadata} TaskMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TaskMetadata.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.TaskMetadata(), key;
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.discoverable = reader.bool();
                            break;
                        case 2:
                            message.runtime = $root.flyteidl.core.RuntimeMetadata.decode(reader, reader.uint32());
                            break;
                        case 4:
                            message.timeout = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                            break;
                        case 5:
                            message.retries = $root.flyteidl.core.RetryStrategy.decode(reader, reader.uint32());
                            break;
                        case 6:
                            message.discoveryVersion = reader.string();
                            break;
                        case 7:
                            message.deprecatedErrorMessage = reader.string();
                            break;
                        case 8:
                            message.interruptible = reader.bool();
                            break;
                        case 9:
                            message.cacheSerializable = reader.bool();
                            break;
                        case 10:
                            message.generatesDeck = reader.bool();
                            break;
                        case 11:
                            reader.skip().pos++;
                            if (message.tags === $util.emptyObject)
                                message.tags = {};
                            key = reader.string();
                            reader.pos++;
                            message.tags[key] = reader.string();
                            break;
                        case 12:
                            message.podTemplateName = reader.string();
                            break;
                        case 13:
                            if (!(message.cacheIgnoreInputVars && message.cacheIgnoreInputVars.length))
                                message.cacheIgnoreInputVars = [];
                            message.cacheIgnoreInputVars.push(reader.string());
                            break;
                        case 14:
                            message.isEager = reader.bool();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a TaskMetadata message.
                 * @function verify
                 * @memberof flyteidl.core.TaskMetadata
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TaskMetadata.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.discoverable != null && message.hasOwnProperty("discoverable"))
                        if (typeof message.discoverable !== "boolean")
                            return "discoverable: boolean expected";
                    if (message.runtime != null && message.hasOwnProperty("runtime")) {
                        var error = $root.flyteidl.core.RuntimeMetadata.verify(message.runtime);
                        if (error)
                            return "runtime." + error;
                    }
                    if (message.timeout != null && message.hasOwnProperty("timeout")) {
                        var error = $root.google.protobuf.Duration.verify(message.timeout);
                        if (error)
                            return "timeout." + error;
                    }
                    if (message.retries != null && message.hasOwnProperty("retries")) {
                        var error = $root.flyteidl.core.RetryStrategy.verify(message.retries);
                        if (error)
                            return "retries." + error;
                    }
                    if (message.discoveryVersion != null && message.hasOwnProperty("discoveryVersion"))
                        if (!$util.isString(message.discoveryVersion))
                            return "discoveryVersion: string expected";
                    if (message.deprecatedErrorMessage != null && message.hasOwnProperty("deprecatedErrorMessage"))
                        if (!$util.isString(message.deprecatedErrorMessage))
                            return "deprecatedErrorMessage: string expected";
                    if (message.interruptible != null && message.hasOwnProperty("interruptible")) {
                        properties.interruptibleValue = 1;
                        if (typeof message.interruptible !== "boolean")
                            return "interruptible: boolean expected";
                    }
                    if (message.cacheSerializable != null && message.hasOwnProperty("cacheSerializable"))
                        if (typeof message.cacheSerializable !== "boolean")
                            return "cacheSerializable: boolean expected";
                    if (message.generatesDeck != null && message.hasOwnProperty("generatesDeck"))
                        if (typeof message.generatesDeck !== "boolean")
                            return "generatesDeck: boolean expected";
                    if (message.tags != null && message.hasOwnProperty("tags")) {
                        if (!$util.isObject(message.tags))
                            return "tags: object expected";
                        var key = Object.keys(message.tags);
                        for (var i = 0; i < key.length; ++i)
                            if (!$util.isString(message.tags[key[i]]))
                                return "tags: string{k:string} expected";
                    }
                    if (message.podTemplateName != null && message.hasOwnProperty("podTemplateName"))
                        if (!$util.isString(message.podTemplateName))
                            return "podTemplateName: string expected";
                    if (message.cacheIgnoreInputVars != null && message.hasOwnProperty("cacheIgnoreInputVars")) {
                        if (!Array.isArray(message.cacheIgnoreInputVars))
                            return "cacheIgnoreInputVars: array expected";
                        for (var i = 0; i < message.cacheIgnoreInputVars.length; ++i)
                            if (!$util.isString(message.cacheIgnoreInputVars[i]))
                                return "cacheIgnoreInputVars: string[] expected";
                    }
                    if (message.isEager != null && message.hasOwnProperty("isEager"))
                        if (typeof message.isEager !== "boolean")
                            return "isEager: boolean expected";
                    return null;
                };
    
                return TaskMetadata;
            })();
    
            core.TaskTemplate = (function() {
    
                /**
                 * Properties of a TaskTemplate.
                 * @memberof flyteidl.core
                 * @interface ITaskTemplate
                 * @property {flyteidl.core.IIdentifier|null} [id] TaskTemplate id
                 * @property {string|null} [type] TaskTemplate type
                 * @property {flyteidl.core.ITaskMetadata|null} [metadata] TaskTemplate metadata
                 * @property {flyteidl.core.ITypedInterface|null} ["interface"] TaskTemplate interface
                 * @property {google.protobuf.IStruct|null} [custom] TaskTemplate custom
                 * @property {flyteidl.core.IContainer|null} [container] TaskTemplate container
                 * @property {flyteidl.core.IK8sPod|null} [k8sPod] TaskTemplate k8sPod
                 * @property {flyteidl.core.ISql|null} [sql] TaskTemplate sql
                 * @property {number|null} [taskTypeVersion] TaskTemplate taskTypeVersion
                 * @property {flyteidl.core.ISecurityContext|null} [securityContext] TaskTemplate securityContext
                 * @property {flyteidl.core.IExtendedResources|null} [extendedResources] TaskTemplate extendedResources
                 * @property {Object.<string,string>|null} [config] TaskTemplate config
                 */
    
                /**
                 * Constructs a new TaskTemplate.
                 * @memberof flyteidl.core
                 * @classdesc Represents a TaskTemplate.
                 * @implements ITaskTemplate
                 * @constructor
                 * @param {flyteidl.core.ITaskTemplate=} [properties] Properties to set
                 */
                function TaskTemplate(properties) {
                    this.config = {};
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * TaskTemplate id.
                 * @member {flyteidl.core.IIdentifier|null|undefined} id
                 * @memberof flyteidl.core.TaskTemplate
                 * @instance
                 */
                TaskTemplate.prototype.id = null;
    
                /**
                 * TaskTemplate type.
                 * @member {string} type
                 * @memberof flyteidl.core.TaskTemplate
                 * @instance
                 */
                TaskTemplate.prototype.type = "";
    
                /**
                 * TaskTemplate metadata.
                 * @member {flyteidl.core.ITaskMetadata|null|undefined} metadata
                 * @memberof flyteidl.core.TaskTemplate
                 * @instance
                 */
                TaskTemplate.prototype.metadata = null;
    
                /**
                 * TaskTemplate interface.
                 * @member {flyteidl.core.ITypedInterface|null|undefined} interface
                 * @memberof flyteidl.core.TaskTemplate
                 * @instance
                 */
                TaskTemplate.prototype["interface"] = null;
    
                /**
                 * TaskTemplate custom.
                 * @member {google.protobuf.IStruct|null|undefined} custom
                 * @memberof flyteidl.core.TaskTemplate
                 * @instance
                 */
                TaskTemplate.prototype.custom = null;
    
                /**
                 * TaskTemplate container.
                 * @member {flyteidl.core.IContainer|null|undefined} container
                 * @memberof flyteidl.core.TaskTemplate
                 * @instance
                 */
                TaskTemplate.prototype.container = null;
    
                /**
                 * TaskTemplate k8sPod.
                 * @member {flyteidl.core.IK8sPod|null|undefined} k8sPod
                 * @memberof flyteidl.core.TaskTemplate
                 * @instance
                 */
                TaskTemplate.prototype.k8sPod = null;
    
                /**
                 * TaskTemplate sql.
                 * @member {flyteidl.core.ISql|null|undefined} sql
                 * @memberof flyteidl.core.TaskTemplate
                 * @instance
                 */
                TaskTemplate.prototype.sql = null;
    
                /**
                 * TaskTemplate taskTypeVersion.
                 * @member {number} taskTypeVersion
                 * @memberof flyteidl.core.TaskTemplate
                 * @instance
                 */
                TaskTemplate.prototype.taskTypeVersion = 0;
    
                /**
                 * TaskTemplate securityContext.
                 * @member {flyteidl.core.ISecurityContext|null|undefined} securityContext
                 * @memberof flyteidl.core.TaskTemplate
                 * @instance
                 */
                TaskTemplate.prototype.securityContext = null;
    
                /**
                 * TaskTemplate extendedResources.
                 * @member {flyteidl.core.IExtendedResources|null|undefined} extendedResources
                 * @memberof flyteidl.core.TaskTemplate
                 * @instance
                 */
                TaskTemplate.prototype.extendedResources = null;
    
                /**
                 * TaskTemplate config.
                 * @member {Object.<string,string>} config
                 * @memberof flyteidl.core.TaskTemplate
                 * @instance
                 */
                TaskTemplate.prototype.config = $util.emptyObject;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * TaskTemplate target.
                 * @member {"container"|"k8sPod"|"sql"|undefined} target
                 * @memberof flyteidl.core.TaskTemplate
                 * @instance
                 */
                Object.defineProperty(TaskTemplate.prototype, "target", {
                    get: $util.oneOfGetter($oneOfFields = ["container", "k8sPod", "sql"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new TaskTemplate instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.TaskTemplate
                 * @static
                 * @param {flyteidl.core.ITaskTemplate=} [properties] Properties to set
                 * @returns {flyteidl.core.TaskTemplate} TaskTemplate instance
                 */
                TaskTemplate.create = function create(properties) {
                    return new TaskTemplate(properties);
                };
    
                /**
                 * Encodes the specified TaskTemplate message. Does not implicitly {@link flyteidl.core.TaskTemplate.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.TaskTemplate
                 * @static
                 * @param {flyteidl.core.ITaskTemplate} message TaskTemplate message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                TaskTemplate.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.id != null && message.hasOwnProperty("id"))
                        $root.flyteidl.core.Identifier.encode(message.id, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.type != null && message.hasOwnProperty("type"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.type);
                    if (message.metadata != null && message.hasOwnProperty("metadata"))
                        $root.flyteidl.core.TaskMetadata.encode(message.metadata, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message["interface"] != null && message.hasOwnProperty("interface"))
                        $root.flyteidl.core.TypedInterface.encode(message["interface"], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.custom != null && message.hasOwnProperty("custom"))
                        $root.google.protobuf.Struct.encode(message.custom, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                    if (message.container != null && message.hasOwnProperty("container"))
                        $root.flyteidl.core.Container.encode(message.container, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                    if (message.taskTypeVersion != null && message.hasOwnProperty("taskTypeVersion"))
                        writer.uint32(/* id 7, wireType 0 =*/56).int32(message.taskTypeVersion);
                    if (message.securityContext != null && message.hasOwnProperty("securityContext"))
                        $root.flyteidl.core.SecurityContext.encode(message.securityContext, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                    if (message.extendedResources != null && message.hasOwnProperty("extendedResources"))
                        $root.flyteidl.core.ExtendedResources.encode(message.extendedResources, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                    if (message.config != null && message.hasOwnProperty("config"))
                        for (var keys = Object.keys(message.config), i = 0; i < keys.length; ++i)
                            writer.uint32(/* id 16, wireType 2 =*/130).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.config[keys[i]]).ldelim();
                    if (message.k8sPod != null && message.hasOwnProperty("k8sPod"))
                        $root.flyteidl.core.K8sPod.encode(message.k8sPod, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
                    if (message.sql != null && message.hasOwnProperty("sql"))
                        $root.flyteidl.core.Sql.encode(message.sql, writer.uint32(/* id 18, wireType 2 =*/146).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a TaskTemplate message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.TaskTemplate
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.TaskTemplate} TaskTemplate
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                TaskTemplate.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.TaskTemplate(), key;
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.id = $root.flyteidl.core.Identifier.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.type = reader.string();
                            break;
                        case 3:
                            message.metadata = $root.flyteidl.core.TaskMetadata.decode(reader, reader.uint32());
                            break;
                        case 4:
                            message["interface"] = $root.flyteidl.core.TypedInterface.decode(reader, reader.uint32());
                            break;
                        case 5:
                            message.custom = $root.google.protobuf.Struct.decode(reader, reader.uint32());
                            break;
                        case 6:
                            message.container = $root.flyteidl.core.Container.decode(reader, reader.uint32());
                            break;
                        case 17:
                            message.k8sPod = $root.flyteidl.core.K8sPod.decode(reader, reader.uint32());
                            break;
                        case 18:
                            message.sql = $root.flyteidl.core.Sql.decode(reader, reader.uint32());
                            break;
                        case 7:
                            message.taskTypeVersion = reader.int32();
                            break;
                        case 8:
                            message.securityContext = $root.flyteidl.core.SecurityContext.decode(reader, reader.uint32());
                            break;
                        case 9:
                            message.extendedResources = $root.flyteidl.core.ExtendedResources.decode(reader, reader.uint32());
                            break;
                        case 16:
                            reader.skip().pos++;
                            if (message.config === $util.emptyObject)
                                message.config = {};
                            key = reader.string();
                            reader.pos++;
                            message.config[key] = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a TaskTemplate message.
                 * @function verify
                 * @memberof flyteidl.core.TaskTemplate
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                TaskTemplate.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.id != null && message.hasOwnProperty("id")) {
                        var error = $root.flyteidl.core.Identifier.verify(message.id);
                        if (error)
                            return "id." + error;
                    }
                    if (message.type != null && message.hasOwnProperty("type"))
                        if (!$util.isString(message.type))
                            return "type: string expected";
                    if (message.metadata != null && message.hasOwnProperty("metadata")) {
                        var error = $root.flyteidl.core.TaskMetadata.verify(message.metadata);
                        if (error)
                            return "metadata." + error;
                    }
                    if (message["interface"] != null && message.hasOwnProperty("interface")) {
                        var error = $root.flyteidl.core.TypedInterface.verify(message["interface"]);
                        if (error)
                            return "interface." + error;
                    }
                    if (message.custom != null && message.hasOwnProperty("custom")) {
                        var error = $root.google.protobuf.Struct.verify(message.custom);
                        if (error)
                            return "custom." + error;
                    }
                    if (message.container != null && message.hasOwnProperty("container")) {
                        properties.target = 1;
                        {
                            var error = $root.flyteidl.core.Container.verify(message.container);
                            if (error)
                                return "container." + error;
                        }
                    }
                    if (message.k8sPod != null && message.hasOwnProperty("k8sPod")) {
                        if (properties.target === 1)
                            return "target: multiple values";
                        properties.target = 1;
                        {
                            var error = $root.flyteidl.core.K8sPod.verify(message.k8sPod);
                            if (error)
                                return "k8sPod." + error;
                        }
                    }
                    if (message.sql != null && message.hasOwnProperty("sql")) {
                        if (properties.target === 1)
                            return "target: multiple values";
                        properties.target = 1;
                        {
                            var error = $root.flyteidl.core.Sql.verify(message.sql);
                            if (error)
                                return "sql." + error;
                        }
                    }
                    if (message.taskTypeVersion != null && message.hasOwnProperty("taskTypeVersion"))
                        if (!$util.isInteger(message.taskTypeVersion))
                            return "taskTypeVersion: integer expected";
                    if (message.securityContext != null && message.hasOwnProperty("securityContext")) {
                        var error = $root.flyteidl.core.SecurityContext.verify(message.securityContext);
                        if (error)
                            return "securityContext." + error;
                    }
                    if (message.extendedResources != null && message.hasOwnProperty("extendedResources")) {
                        var error = $root.flyteidl.core.ExtendedResources.verify(message.extendedResources);
                        if (error)
                            return "extendedResources." + error;
                    }
                    if (message.config != null && message.hasOwnProperty("config")) {
                        if (!$util.isObject(message.config))
                            return "config: object expected";
                        var key = Object.keys(message.config);
                        for (var i = 0; i < key.length; ++i)
                            if (!$util.isString(message.config[key[i]]))
                                return "config: string{k:string} expected";
                    }
                    return null;
                };
    
                return TaskTemplate;
            })();
    
            core.ContainerPort = (function() {
    
                /**
                 * Properties of a ContainerPort.
                 * @memberof flyteidl.core
                 * @interface IContainerPort
                 * @property {number|null} [containerPort] ContainerPort containerPort
                 */
    
                /**
                 * Constructs a new ContainerPort.
                 * @memberof flyteidl.core
                 * @classdesc Represents a ContainerPort.
                 * @implements IContainerPort
                 * @constructor
                 * @param {flyteidl.core.IContainerPort=} [properties] Properties to set
                 */
                function ContainerPort(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * ContainerPort containerPort.
                 * @member {number} containerPort
                 * @memberof flyteidl.core.ContainerPort
                 * @instance
                 */
                ContainerPort.prototype.containerPort = 0;
    
                /**
                 * Creates a new ContainerPort instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.ContainerPort
                 * @static
                 * @param {flyteidl.core.IContainerPort=} [properties] Properties to set
                 * @returns {flyteidl.core.ContainerPort} ContainerPort instance
                 */
                ContainerPort.create = function create(properties) {
                    return new ContainerPort(properties);
                };
    
                /**
                 * Encodes the specified ContainerPort message. Does not implicitly {@link flyteidl.core.ContainerPort.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.ContainerPort
                 * @static
                 * @param {flyteidl.core.IContainerPort} message ContainerPort message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ContainerPort.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.containerPort != null && message.hasOwnProperty("containerPort"))
                        writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.containerPort);
                    return writer;
                };
    
                /**
                 * Decodes a ContainerPort message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.ContainerPort
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.ContainerPort} ContainerPort
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ContainerPort.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.ContainerPort();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.containerPort = reader.uint32();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a ContainerPort message.
                 * @function verify
                 * @memberof flyteidl.core.ContainerPort
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ContainerPort.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.containerPort != null && message.hasOwnProperty("containerPort"))
                        if (!$util.isInteger(message.containerPort))
                            return "containerPort: integer expected";
                    return null;
                };
    
                return ContainerPort;
            })();
    
            core.Container = (function() {
    
                /**
                 * Properties of a Container.
                 * @memberof flyteidl.core
                 * @interface IContainer
                 * @property {string|null} [image] Container image
                 * @property {Array.<string>|null} [command] Container command
                 * @property {Array.<string>|null} [args] Container args
                 * @property {flyteidl.core.IResources|null} [resources] Container resources
                 * @property {Array.<flyteidl.core.IKeyValuePair>|null} [env] Container env
                 * @property {Array.<flyteidl.core.IKeyValuePair>|null} [config] Container config
                 * @property {Array.<flyteidl.core.IContainerPort>|null} [ports] Container ports
                 * @property {flyteidl.core.IDataLoadingConfig|null} [dataConfig] Container dataConfig
                 * @property {flyteidl.core.Container.Architecture|null} [architecture] Container architecture
                 */
    
                /**
                 * Constructs a new Container.
                 * @memberof flyteidl.core
                 * @classdesc Represents a Container.
                 * @implements IContainer
                 * @constructor
                 * @param {flyteidl.core.IContainer=} [properties] Properties to set
                 */
                function Container(properties) {
                    this.command = [];
                    this.args = [];
                    this.env = [];
                    this.config = [];
                    this.ports = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Container image.
                 * @member {string} image
                 * @memberof flyteidl.core.Container
                 * @instance
                 */
                Container.prototype.image = "";
    
                /**
                 * Container command.
                 * @member {Array.<string>} command
                 * @memberof flyteidl.core.Container
                 * @instance
                 */
                Container.prototype.command = $util.emptyArray;
    
                /**
                 * Container args.
                 * @member {Array.<string>} args
                 * @memberof flyteidl.core.Container
                 * @instance
                 */
                Container.prototype.args = $util.emptyArray;
    
                /**
                 * Container resources.
                 * @member {flyteidl.core.IResources|null|undefined} resources
                 * @memberof flyteidl.core.Container
                 * @instance
                 */
                Container.prototype.resources = null;
    
                /**
                 * Container env.
                 * @member {Array.<flyteidl.core.IKeyValuePair>} env
                 * @memberof flyteidl.core.Container
                 * @instance
                 */
                Container.prototype.env = $util.emptyArray;
    
                /**
                 * Container config.
                 * @member {Array.<flyteidl.core.IKeyValuePair>} config
                 * @memberof flyteidl.core.Container
                 * @instance
                 */
                Container.prototype.config = $util.emptyArray;
    
                /**
                 * Container ports.
                 * @member {Array.<flyteidl.core.IContainerPort>} ports
                 * @memberof flyteidl.core.Container
                 * @instance
                 */
                Container.prototype.ports = $util.emptyArray;
    
                /**
                 * Container dataConfig.
                 * @member {flyteidl.core.IDataLoadingConfig|null|undefined} dataConfig
                 * @memberof flyteidl.core.Container
                 * @instance
                 */
                Container.prototype.dataConfig = null;
    
                /**
                 * Container architecture.
                 * @member {flyteidl.core.Container.Architecture} architecture
                 * @memberof flyteidl.core.Container
                 * @instance
                 */
                Container.prototype.architecture = 0;
    
                /**
                 * Creates a new Container instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Container
                 * @static
                 * @param {flyteidl.core.IContainer=} [properties] Properties to set
                 * @returns {flyteidl.core.Container} Container instance
                 */
                Container.create = function create(properties) {
                    return new Container(properties);
                };
    
                /**
                 * Encodes the specified Container message. Does not implicitly {@link flyteidl.core.Container.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Container
                 * @static
                 * @param {flyteidl.core.IContainer} message Container message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Container.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.image != null && message.hasOwnProperty("image"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.image);
                    if (message.command != null && message.command.length)
                        for (var i = 0; i < message.command.length; ++i)
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.command[i]);
                    if (message.args != null && message.args.length)
                        for (var i = 0; i < message.args.length; ++i)
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.args[i]);
                    if (message.resources != null && message.hasOwnProperty("resources"))
                        $root.flyteidl.core.Resources.encode(message.resources, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.env != null && message.env.length)
                        for (var i = 0; i < message.env.length; ++i)
                            $root.flyteidl.core.KeyValuePair.encode(message.env[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                    if (message.config != null && message.config.length)
                        for (var i = 0; i < message.config.length; ++i)
                            $root.flyteidl.core.KeyValuePair.encode(message.config[i], writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                    if (message.ports != null && message.ports.length)
                        for (var i = 0; i < message.ports.length; ++i)
                            $root.flyteidl.core.ContainerPort.encode(message.ports[i], writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                    if (message.dataConfig != null && message.hasOwnProperty("dataConfig"))
                        $root.flyteidl.core.DataLoadingConfig.encode(message.dataConfig, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                    if (message.architecture != null && message.hasOwnProperty("architecture"))
                        writer.uint32(/* id 10, wireType 0 =*/80).int32(message.architecture);
                    return writer;
                };
    
                /**
                 * Decodes a Container message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Container
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Container} Container
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Container.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Container();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.image = reader.string();
                            break;
                        case 2:
                            if (!(message.command && message.command.length))
                                message.command = [];
                            message.command.push(reader.string());
                            break;
                        case 3:
                            if (!(message.args && message.args.length))
                                message.args = [];
                            message.args.push(reader.string());
                            break;
                        case 4:
                            message.resources = $root.flyteidl.core.Resources.decode(reader, reader.uint32());
                            break;
                        case 5:
                            if (!(message.env && message.env.length))
                                message.env = [];
                            message.env.push($root.flyteidl.core.KeyValuePair.decode(reader, reader.uint32()));
                            break;
                        case 6:
                            if (!(message.config && message.config.length))
                                message.config = [];
                            message.config.push($root.flyteidl.core.KeyValuePair.decode(reader, reader.uint32()));
                            break;
                        case 7:
                            if (!(message.ports && message.ports.length))
                                message.ports = [];
                            message.ports.push($root.flyteidl.core.ContainerPort.decode(reader, reader.uint32()));
                            break;
                        case 9:
                            message.dataConfig = $root.flyteidl.core.DataLoadingConfig.decode(reader, reader.uint32());
                            break;
                        case 10:
                            message.architecture = reader.int32();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a Container message.
                 * @function verify
                 * @memberof flyteidl.core.Container
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Container.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.image != null && message.hasOwnProperty("image"))
                        if (!$util.isString(message.image))
                            return "image: string expected";
                    if (message.command != null && message.hasOwnProperty("command")) {
                        if (!Array.isArray(message.command))
                            return "command: array expected";
                        for (var i = 0; i < message.command.length; ++i)
                            if (!$util.isString(message.command[i]))
                                return "command: string[] expected";
                    }
                    if (message.args != null && message.hasOwnProperty("args")) {
                        if (!Array.isArray(message.args))
                            return "args: array expected";
                        for (var i = 0; i < message.args.length; ++i)
                            if (!$util.isString(message.args[i]))
                                return "args: string[] expected";
                    }
                    if (message.resources != null && message.hasOwnProperty("resources")) {
                        var error = $root.flyteidl.core.Resources.verify(message.resources);
                        if (error)
                            return "resources." + error;
                    }
                    if (message.env != null && message.hasOwnProperty("env")) {
                        if (!Array.isArray(message.env))
                            return "env: array expected";
                        for (var i = 0; i < message.env.length; ++i) {
                            var error = $root.flyteidl.core.KeyValuePair.verify(message.env[i]);
                            if (error)
                                return "env." + error;
                        }
                    }
                    if (message.config != null && message.hasOwnProperty("config")) {
                        if (!Array.isArray(message.config))
                            return "config: array expected";
                        for (var i = 0; i < message.config.length; ++i) {
                            var error = $root.flyteidl.core.KeyValuePair.verify(message.config[i]);
                            if (error)
                                return "config." + error;
                        }
                    }
                    if (message.ports != null && message.hasOwnProperty("ports")) {
                        if (!Array.isArray(message.ports))
                            return "ports: array expected";
                        for (var i = 0; i < message.ports.length; ++i) {
                            var error = $root.flyteidl.core.ContainerPort.verify(message.ports[i]);
                            if (error)
                                return "ports." + error;
                        }
                    }
                    if (message.dataConfig != null && message.hasOwnProperty("dataConfig")) {
                        var error = $root.flyteidl.core.DataLoadingConfig.verify(message.dataConfig);
                        if (error)
                            return "dataConfig." + error;
                    }
                    if (message.architecture != null && message.hasOwnProperty("architecture"))
                        switch (message.architecture) {
                        default:
                            return "architecture: enum value expected";
                        case 0:
                        case 1:
                        case 2:
                        case 3:
                        case 4:
                            break;
                        }
                    return null;
                };
    
                /**
                 * Architecture enum.
                 * @name flyteidl.core.Container.Architecture
                 * @enum {string}
                 * @property {number} UNKNOWN=0 UNKNOWN value
                 * @property {number} AMD64=1 AMD64 value
                 * @property {number} ARM64=2 ARM64 value
                 * @property {number} ARM_V6=3 ARM_V6 value
                 * @property {number} ARM_V7=4 ARM_V7 value
                 */
                Container.Architecture = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "UNKNOWN"] = 0;
                    values[valuesById[1] = "AMD64"] = 1;
                    values[valuesById[2] = "ARM64"] = 2;
                    values[valuesById[3] = "ARM_V6"] = 3;
                    values[valuesById[4] = "ARM_V7"] = 4;
                    return values;
                })();
    
                return Container;
            })();
    
            core.IOStrategy = (function() {
    
                /**
                 * Properties of a IOStrategy.
                 * @memberof flyteidl.core
                 * @interface IIOStrategy
                 * @property {flyteidl.core.IOStrategy.DownloadMode|null} [downloadMode] IOStrategy downloadMode
                 * @property {flyteidl.core.IOStrategy.UploadMode|null} [uploadMode] IOStrategy uploadMode
                 */
    
                /**
                 * Constructs a new IOStrategy.
                 * @memberof flyteidl.core
                 * @classdesc Represents a IOStrategy.
                 * @implements IIOStrategy
                 * @constructor
                 * @param {flyteidl.core.IIOStrategy=} [properties] Properties to set
                 */
                function IOStrategy(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * IOStrategy downloadMode.
                 * @member {flyteidl.core.IOStrategy.DownloadMode} downloadMode
                 * @memberof flyteidl.core.IOStrategy
                 * @instance
                 */
                IOStrategy.prototype.downloadMode = 0;
    
                /**
                 * IOStrategy uploadMode.
                 * @member {flyteidl.core.IOStrategy.UploadMode} uploadMode
                 * @memberof flyteidl.core.IOStrategy
                 * @instance
                 */
                IOStrategy.prototype.uploadMode = 0;
    
                /**
                 * Creates a new IOStrategy instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.IOStrategy
                 * @static
                 * @param {flyteidl.core.IIOStrategy=} [properties] Properties to set
                 * @returns {flyteidl.core.IOStrategy} IOStrategy instance
                 */
                IOStrategy.create = function create(properties) {
                    return new IOStrategy(properties);
                };
    
                /**
                 * Encodes the specified IOStrategy message. Does not implicitly {@link flyteidl.core.IOStrategy.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.IOStrategy
                 * @static
                 * @param {flyteidl.core.IIOStrategy} message IOStrategy message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                IOStrategy.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.downloadMode != null && message.hasOwnProperty("downloadMode"))
                        writer.uint32(/* id 1, wireType 0 =*/8).int32(message.downloadMode);
                    if (message.uploadMode != null && message.hasOwnProperty("uploadMode"))
                        writer.uint32(/* id 2, wireType 0 =*/16).int32(message.uploadMode);
                    return writer;
                };
    
                /**
                 * Decodes a IOStrategy message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.IOStrategy
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.IOStrategy} IOStrategy
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                IOStrategy.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.IOStrategy();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.downloadMode = reader.int32();
                            break;
                        case 2:
                            message.uploadMode = reader.int32();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a IOStrategy message.
                 * @function verify
                 * @memberof flyteidl.core.IOStrategy
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                IOStrategy.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.downloadMode != null && message.hasOwnProperty("downloadMode"))
                        switch (message.downloadMode) {
                        default:
                            return "downloadMode: enum value expected";
                        case 0:
                        case 1:
                        case 2:
                            break;
                        }
                    if (message.uploadMode != null && message.hasOwnProperty("uploadMode"))
                        switch (message.uploadMode) {
                        default:
                            return "uploadMode: enum value expected";
                        case 0:
                        case 1:
                        case 2:
                            break;
                        }
                    return null;
                };
    
                /**
                 * DownloadMode enum.
                 * @name flyteidl.core.IOStrategy.DownloadMode
                 * @enum {string}
                 * @property {number} DOWNLOAD_EAGER=0 DOWNLOAD_EAGER value
                 * @property {number} DOWNLOAD_STREAM=1 DOWNLOAD_STREAM value
                 * @property {number} DO_NOT_DOWNLOAD=2 DO_NOT_DOWNLOAD value
                 */
                IOStrategy.DownloadMode = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "DOWNLOAD_EAGER"] = 0;
                    values[valuesById[1] = "DOWNLOAD_STREAM"] = 1;
                    values[valuesById[2] = "DO_NOT_DOWNLOAD"] = 2;
                    return values;
                })();
    
                /**
                 * UploadMode enum.
                 * @name flyteidl.core.IOStrategy.UploadMode
                 * @enum {string}
                 * @property {number} UPLOAD_ON_EXIT=0 UPLOAD_ON_EXIT value
                 * @property {number} UPLOAD_EAGER=1 UPLOAD_EAGER value
                 * @property {number} DO_NOT_UPLOAD=2 DO_NOT_UPLOAD value
                 */
                IOStrategy.UploadMode = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "UPLOAD_ON_EXIT"] = 0;
                    values[valuesById[1] = "UPLOAD_EAGER"] = 1;
                    values[valuesById[2] = "DO_NOT_UPLOAD"] = 2;
                    return values;
                })();
    
                return IOStrategy;
            })();
    
            core.DataLoadingConfig = (function() {
    
                /**
                 * Properties of a DataLoadingConfig.
                 * @memberof flyteidl.core
                 * @interface IDataLoadingConfig
                 * @property {boolean|null} [enabled] DataLoadingConfig enabled
                 * @property {string|null} [inputPath] DataLoadingConfig inputPath
                 * @property {string|null} [outputPath] DataLoadingConfig outputPath
                 * @property {flyteidl.core.DataLoadingConfig.LiteralMapFormat|null} [format] DataLoadingConfig format
                 * @property {flyteidl.core.IIOStrategy|null} [ioStrategy] DataLoadingConfig ioStrategy
                 */
    
                /**
                 * Constructs a new DataLoadingConfig.
                 * @memberof flyteidl.core
                 * @classdesc Represents a DataLoadingConfig.
                 * @implements IDataLoadingConfig
                 * @constructor
                 * @param {flyteidl.core.IDataLoadingConfig=} [properties] Properties to set
                 */
                function DataLoadingConfig(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * DataLoadingConfig enabled.
                 * @member {boolean} enabled
                 * @memberof flyteidl.core.DataLoadingConfig
                 * @instance
                 */
                DataLoadingConfig.prototype.enabled = false;
    
                /**
                 * DataLoadingConfig inputPath.
                 * @member {string} inputPath
                 * @memberof flyteidl.core.DataLoadingConfig
                 * @instance
                 */
                DataLoadingConfig.prototype.inputPath = "";
    
                /**
                 * DataLoadingConfig outputPath.
                 * @member {string} outputPath
                 * @memberof flyteidl.core.DataLoadingConfig
                 * @instance
                 */
                DataLoadingConfig.prototype.outputPath = "";
    
                /**
                 * DataLoadingConfig format.
                 * @member {flyteidl.core.DataLoadingConfig.LiteralMapFormat} format
                 * @memberof flyteidl.core.DataLoadingConfig
                 * @instance
                 */
                DataLoadingConfig.prototype.format = 0;
    
                /**
                 * DataLoadingConfig ioStrategy.
                 * @member {flyteidl.core.IIOStrategy|null|undefined} ioStrategy
                 * @memberof flyteidl.core.DataLoadingConfig
                 * @instance
                 */
                DataLoadingConfig.prototype.ioStrategy = null;
    
                /**
                 * Creates a new DataLoadingConfig instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.DataLoadingConfig
                 * @static
                 * @param {flyteidl.core.IDataLoadingConfig=} [properties] Properties to set
                 * @returns {flyteidl.core.DataLoadingConfig} DataLoadingConfig instance
                 */
                DataLoadingConfig.create = function create(properties) {
                    return new DataLoadingConfig(properties);
                };
    
                /**
                 * Encodes the specified DataLoadingConfig message. Does not implicitly {@link flyteidl.core.DataLoadingConfig.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.DataLoadingConfig
                 * @static
                 * @param {flyteidl.core.IDataLoadingConfig} message DataLoadingConfig message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                DataLoadingConfig.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.enabled != null && message.hasOwnProperty("enabled"))
                        writer.uint32(/* id 1, wireType 0 =*/8).bool(message.enabled);
                    if (message.inputPath != null && message.hasOwnProperty("inputPath"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.inputPath);
                    if (message.outputPath != null && message.hasOwnProperty("outputPath"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.outputPath);
                    if (message.format != null && message.hasOwnProperty("format"))
                        writer.uint32(/* id 4, wireType 0 =*/32).int32(message.format);
                    if (message.ioStrategy != null && message.hasOwnProperty("ioStrategy"))
                        $root.flyteidl.core.IOStrategy.encode(message.ioStrategy, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a DataLoadingConfig message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.DataLoadingConfig
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.DataLoadingConfig} DataLoadingConfig
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                DataLoadingConfig.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.DataLoadingConfig();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.enabled = reader.bool();
                            break;
                        case 2:
                            message.inputPath = reader.string();
                            break;
                        case 3:
                            message.outputPath = reader.string();
                            break;
                        case 4:
                            message.format = reader.int32();
                            break;
                        case 5:
                            message.ioStrategy = $root.flyteidl.core.IOStrategy.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a DataLoadingConfig message.
                 * @function verify
                 * @memberof flyteidl.core.DataLoadingConfig
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                DataLoadingConfig.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.enabled != null && message.hasOwnProperty("enabled"))
                        if (typeof message.enabled !== "boolean")
                            return "enabled: boolean expected";
                    if (message.inputPath != null && message.hasOwnProperty("inputPath"))
                        if (!$util.isString(message.inputPath))
                            return "inputPath: string expected";
                    if (message.outputPath != null && message.hasOwnProperty("outputPath"))
                        if (!$util.isString(message.outputPath))
                            return "outputPath: string expected";
                    if (message.format != null && message.hasOwnProperty("format"))
                        switch (message.format) {
                        default:
                            return "format: enum value expected";
                        case 0:
                        case 1:
                        case 2:
                            break;
                        }
                    if (message.ioStrategy != null && message.hasOwnProperty("ioStrategy")) {
                        var error = $root.flyteidl.core.IOStrategy.verify(message.ioStrategy);
                        if (error)
                            return "ioStrategy." + error;
                    }
                    return null;
                };
    
                /**
                 * LiteralMapFormat enum.
                 * @name flyteidl.core.DataLoadingConfig.LiteralMapFormat
                 * @enum {string}
                 * @property {number} JSON=0 JSON value
                 * @property {number} YAML=1 YAML value
                 * @property {number} PROTO=2 PROTO value
                 */
                DataLoadingConfig.LiteralMapFormat = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "JSON"] = 0;
                    values[valuesById[1] = "YAML"] = 1;
                    values[valuesById[2] = "PROTO"] = 2;
                    return values;
                })();
    
                return DataLoadingConfig;
            })();
    
            core.K8sPod = (function() {
    
                /**
                 * Properties of a K8sPod.
                 * @memberof flyteidl.core
                 * @interface IK8sPod
                 * @property {flyteidl.core.IK8sObjectMetadata|null} [metadata] K8sPod metadata
                 * @property {google.protobuf.IStruct|null} [podSpec] K8sPod podSpec
                 * @property {flyteidl.core.IDataLoadingConfig|null} [dataConfig] K8sPod dataConfig
                 */
    
                /**
                 * Constructs a new K8sPod.
                 * @memberof flyteidl.core
                 * @classdesc Represents a K8sPod.
                 * @implements IK8sPod
                 * @constructor
                 * @param {flyteidl.core.IK8sPod=} [properties] Properties to set
                 */
                function K8sPod(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * K8sPod metadata.
                 * @member {flyteidl.core.IK8sObjectMetadata|null|undefined} metadata
                 * @memberof flyteidl.core.K8sPod
                 * @instance
                 */
                K8sPod.prototype.metadata = null;
    
                /**
                 * K8sPod podSpec.
                 * @member {google.protobuf.IStruct|null|undefined} podSpec
                 * @memberof flyteidl.core.K8sPod
                 * @instance
                 */
                K8sPod.prototype.podSpec = null;
    
                /**
                 * K8sPod dataConfig.
                 * @member {flyteidl.core.IDataLoadingConfig|null|undefined} dataConfig
                 * @memberof flyteidl.core.K8sPod
                 * @instance
                 */
                K8sPod.prototype.dataConfig = null;
    
                /**
                 * Creates a new K8sPod instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.K8sPod
                 * @static
                 * @param {flyteidl.core.IK8sPod=} [properties] Properties to set
                 * @returns {flyteidl.core.K8sPod} K8sPod instance
                 */
                K8sPod.create = function create(properties) {
                    return new K8sPod(properties);
                };
    
                /**
                 * Encodes the specified K8sPod message. Does not implicitly {@link flyteidl.core.K8sPod.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.K8sPod
                 * @static
                 * @param {flyteidl.core.IK8sPod} message K8sPod message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                K8sPod.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.metadata != null && message.hasOwnProperty("metadata"))
                        $root.flyteidl.core.K8sObjectMetadata.encode(message.metadata, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.podSpec != null && message.hasOwnProperty("podSpec"))
                        $root.google.protobuf.Struct.encode(message.podSpec, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.dataConfig != null && message.hasOwnProperty("dataConfig"))
                        $root.flyteidl.core.DataLoadingConfig.encode(message.dataConfig, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a K8sPod message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.K8sPod
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.K8sPod} K8sPod
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                K8sPod.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.K8sPod();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.metadata = $root.flyteidl.core.K8sObjectMetadata.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.podSpec = $root.google.protobuf.Struct.decode(reader, reader.uint32());
                            break;
                        case 3:
                            message.dataConfig = $root.flyteidl.core.DataLoadingConfig.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a K8sPod message.
                 * @function verify
                 * @memberof flyteidl.core.K8sPod
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                K8sPod.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.metadata != null && message.hasOwnProperty("metadata")) {
                        var error = $root.flyteidl.core.K8sObjectMetadata.verify(message.metadata);
                        if (error)
                            return "metadata." + error;
                    }
                    if (message.podSpec != null && message.hasOwnProperty("podSpec")) {
                        var error = $root.google.protobuf.Struct.verify(message.podSpec);
                        if (error)
                            return "podSpec." + error;
                    }
                    if (message.dataConfig != null && message.hasOwnProperty("dataConfig")) {
                        var error = $root.flyteidl.core.DataLoadingConfig.verify(message.dataConfig);
                        if (error)
                            return "dataConfig." + error;
                    }
                    return null;
                };
    
                return K8sPod;
            })();
    
            core.K8sObjectMetadata = (function() {
    
                /**
                 * Properties of a K8sObjectMetadata.
                 * @memberof flyteidl.core
                 * @interface IK8sObjectMetadata
                 * @property {Object.<string,string>|null} [labels] K8sObjectMetadata labels
                 * @property {Object.<string,string>|null} [annotations] K8sObjectMetadata annotations
                 */
    
                /**
                 * Constructs a new K8sObjectMetadata.
                 * @memberof flyteidl.core
                 * @classdesc Represents a K8sObjectMetadata.
                 * @implements IK8sObjectMetadata
                 * @constructor
                 * @param {flyteidl.core.IK8sObjectMetadata=} [properties] Properties to set
                 */
                function K8sObjectMetadata(properties) {
                    this.labels = {};
                    this.annotations = {};
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * K8sObjectMetadata labels.
                 * @member {Object.<string,string>} labels
                 * @memberof flyteidl.core.K8sObjectMetadata
                 * @instance
                 */
                K8sObjectMetadata.prototype.labels = $util.emptyObject;
    
                /**
                 * K8sObjectMetadata annotations.
                 * @member {Object.<string,string>} annotations
                 * @memberof flyteidl.core.K8sObjectMetadata
                 * @instance
                 */
                K8sObjectMetadata.prototype.annotations = $util.emptyObject;
    
                /**
                 * Creates a new K8sObjectMetadata instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.K8sObjectMetadata
                 * @static
                 * @param {flyteidl.core.IK8sObjectMetadata=} [properties] Properties to set
                 * @returns {flyteidl.core.K8sObjectMetadata} K8sObjectMetadata instance
                 */
                K8sObjectMetadata.create = function create(properties) {
                    return new K8sObjectMetadata(properties);
                };
    
                /**
                 * Encodes the specified K8sObjectMetadata message. Does not implicitly {@link flyteidl.core.K8sObjectMetadata.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.K8sObjectMetadata
                 * @static
                 * @param {flyteidl.core.IK8sObjectMetadata} message K8sObjectMetadata message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                K8sObjectMetadata.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.labels != null && message.hasOwnProperty("labels"))
                        for (var keys = Object.keys(message.labels), i = 0; i < keys.length; ++i)
                            writer.uint32(/* id 1, wireType 2 =*/10).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.labels[keys[i]]).ldelim();
                    if (message.annotations != null && message.hasOwnProperty("annotations"))
                        for (var keys = Object.keys(message.annotations), i = 0; i < keys.length; ++i)
                            writer.uint32(/* id 2, wireType 2 =*/18).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.annotations[keys[i]]).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a K8sObjectMetadata message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.K8sObjectMetadata
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.K8sObjectMetadata} K8sObjectMetadata
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                K8sObjectMetadata.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.K8sObjectMetadata(), key;
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            reader.skip().pos++;
                            if (message.labels === $util.emptyObject)
                                message.labels = {};
                            key = reader.string();
                            reader.pos++;
                            message.labels[key] = reader.string();
                            break;
                        case 2:
                            reader.skip().pos++;
                            if (message.annotations === $util.emptyObject)
                                message.annotations = {};
                            key = reader.string();
                            reader.pos++;
                            message.annotations[key] = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a K8sObjectMetadata message.
                 * @function verify
                 * @memberof flyteidl.core.K8sObjectMetadata
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                K8sObjectMetadata.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.labels != null && message.hasOwnProperty("labels")) {
                        if (!$util.isObject(message.labels))
                            return "labels: object expected";
                        var key = Object.keys(message.labels);
                        for (var i = 0; i < key.length; ++i)
                            if (!$util.isString(message.labels[key[i]]))
                                return "labels: string{k:string} expected";
                    }
                    if (message.annotations != null && message.hasOwnProperty("annotations")) {
                        if (!$util.isObject(message.annotations))
                            return "annotations: object expected";
                        var key = Object.keys(message.annotations);
                        for (var i = 0; i < key.length; ++i)
                            if (!$util.isString(message.annotations[key[i]]))
                                return "annotations: string{k:string} expected";
                    }
                    return null;
                };
    
                return K8sObjectMetadata;
            })();
    
            core.Sql = (function() {
    
                /**
                 * Properties of a Sql.
                 * @memberof flyteidl.core
                 * @interface ISql
                 * @property {string|null} [statement] Sql statement
                 * @property {flyteidl.core.Sql.Dialect|null} [dialect] Sql dialect
                 */
    
                /**
                 * Constructs a new Sql.
                 * @memberof flyteidl.core
                 * @classdesc Represents a Sql.
                 * @implements ISql
                 * @constructor
                 * @param {flyteidl.core.ISql=} [properties] Properties to set
                 */
                function Sql(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Sql statement.
                 * @member {string} statement
                 * @memberof flyteidl.core.Sql
                 * @instance
                 */
                Sql.prototype.statement = "";
    
                /**
                 * Sql dialect.
                 * @member {flyteidl.core.Sql.Dialect} dialect
                 * @memberof flyteidl.core.Sql
                 * @instance
                 */
                Sql.prototype.dialect = 0;
    
                /**
                 * Creates a new Sql instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Sql
                 * @static
                 * @param {flyteidl.core.ISql=} [properties] Properties to set
                 * @returns {flyteidl.core.Sql} Sql instance
                 */
                Sql.create = function create(properties) {
                    return new Sql(properties);
                };
    
                /**
                 * Encodes the specified Sql message. Does not implicitly {@link flyteidl.core.Sql.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Sql
                 * @static
                 * @param {flyteidl.core.ISql} message Sql message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Sql.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.statement != null && message.hasOwnProperty("statement"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.statement);
                    if (message.dialect != null && message.hasOwnProperty("dialect"))
                        writer.uint32(/* id 2, wireType 0 =*/16).int32(message.dialect);
                    return writer;
                };
    
                /**
                 * Decodes a Sql message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Sql
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Sql} Sql
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Sql.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Sql();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.statement = reader.string();
                            break;
                        case 2:
                            message.dialect = reader.int32();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a Sql message.
                 * @function verify
                 * @memberof flyteidl.core.Sql
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Sql.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.statement != null && message.hasOwnProperty("statement"))
                        if (!$util.isString(message.statement))
                            return "statement: string expected";
                    if (message.dialect != null && message.hasOwnProperty("dialect"))
                        switch (message.dialect) {
                        default:
                            return "dialect: enum value expected";
                        case 0:
                        case 1:
                        case 2:
                        case 3:
                            break;
                        }
                    return null;
                };
    
                /**
                 * Dialect enum.
                 * @name flyteidl.core.Sql.Dialect
                 * @enum {string}
                 * @property {number} UNDEFINED=0 UNDEFINED value
                 * @property {number} ANSI=1 ANSI value
                 * @property {number} HIVE=2 HIVE value
                 * @property {number} OTHER=3 OTHER value
                 */
                Sql.Dialect = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "UNDEFINED"] = 0;
                    values[valuesById[1] = "ANSI"] = 1;
                    values[valuesById[2] = "HIVE"] = 2;
                    values[valuesById[3] = "OTHER"] = 3;
                    return values;
                })();
    
                return Sql;
            })();
    
            core.Secret = (function() {
    
                /**
                 * Properties of a Secret.
                 * @memberof flyteidl.core
                 * @interface ISecret
                 * @property {string|null} [group] Secret group
                 * @property {string|null} [groupVersion] Secret groupVersion
                 * @property {string|null} [key] Secret key
                 * @property {flyteidl.core.Secret.MountType|null} [mountRequirement] Secret mountRequirement
                 */
    
                /**
                 * Constructs a new Secret.
                 * @memberof flyteidl.core
                 * @classdesc Represents a Secret.
                 * @implements ISecret
                 * @constructor
                 * @param {flyteidl.core.ISecret=} [properties] Properties to set
                 */
                function Secret(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Secret group.
                 * @member {string} group
                 * @memberof flyteidl.core.Secret
                 * @instance
                 */
                Secret.prototype.group = "";
    
                /**
                 * Secret groupVersion.
                 * @member {string} groupVersion
                 * @memberof flyteidl.core.Secret
                 * @instance
                 */
                Secret.prototype.groupVersion = "";
    
                /**
                 * Secret key.
                 * @member {string} key
                 * @memberof flyteidl.core.Secret
                 * @instance
                 */
                Secret.prototype.key = "";
    
                /**
                 * Secret mountRequirement.
                 * @member {flyteidl.core.Secret.MountType} mountRequirement
                 * @memberof flyteidl.core.Secret
                 * @instance
                 */
                Secret.prototype.mountRequirement = 0;
    
                /**
                 * Creates a new Secret instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Secret
                 * @static
                 * @param {flyteidl.core.ISecret=} [properties] Properties to set
                 * @returns {flyteidl.core.Secret} Secret instance
                 */
                Secret.create = function create(properties) {
                    return new Secret(properties);
                };
    
                /**
                 * Encodes the specified Secret message. Does not implicitly {@link flyteidl.core.Secret.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Secret
                 * @static
                 * @param {flyteidl.core.ISecret} message Secret message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Secret.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.group != null && message.hasOwnProperty("group"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.group);
                    if (message.groupVersion != null && message.hasOwnProperty("groupVersion"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.groupVersion);
                    if (message.key != null && message.hasOwnProperty("key"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.key);
                    if (message.mountRequirement != null && message.hasOwnProperty("mountRequirement"))
                        writer.uint32(/* id 4, wireType 0 =*/32).int32(message.mountRequirement);
                    return writer;
                };
    
                /**
                 * Decodes a Secret message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Secret
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Secret} Secret
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Secret.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Secret();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.group = reader.string();
                            break;
                        case 2:
                            message.groupVersion = reader.string();
                            break;
                        case 3:
                            message.key = reader.string();
                            break;
                        case 4:
                            message.mountRequirement = reader.int32();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a Secret message.
                 * @function verify
                 * @memberof flyteidl.core.Secret
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Secret.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.group != null && message.hasOwnProperty("group"))
                        if (!$util.isString(message.group))
                            return "group: string expected";
                    if (message.groupVersion != null && message.hasOwnProperty("groupVersion"))
                        if (!$util.isString(message.groupVersion))
                            return "groupVersion: string expected";
                    if (message.key != null && message.hasOwnProperty("key"))
                        if (!$util.isString(message.key))
                            return "key: string expected";
                    if (message.mountRequirement != null && message.hasOwnProperty("mountRequirement"))
                        switch (message.mountRequirement) {
                        default:
                            return "mountRequirement: enum value expected";
                        case 0:
                        case 1:
                        case 2:
                            break;
                        }
                    return null;
                };
    
                /**
                 * MountType enum.
                 * @name flyteidl.core.Secret.MountType
                 * @enum {string}
                 * @property {number} ANY=0 ANY value
                 * @property {number} ENV_VAR=1 ENV_VAR value
                 * @property {number} FILE=2 FILE value
                 */
                Secret.MountType = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "ANY"] = 0;
                    values[valuesById[1] = "ENV_VAR"] = 1;
                    values[valuesById[2] = "FILE"] = 2;
                    return values;
                })();
    
                return Secret;
            })();
    
            core.OAuth2Client = (function() {
    
                /**
                 * Properties of a OAuth2Client.
                 * @memberof flyteidl.core
                 * @interface IOAuth2Client
                 * @property {string|null} [clientId] OAuth2Client clientId
                 * @property {flyteidl.core.ISecret|null} [clientSecret] OAuth2Client clientSecret
                 */
    
                /**
                 * Constructs a new OAuth2Client.
                 * @memberof flyteidl.core
                 * @classdesc Represents a OAuth2Client.
                 * @implements IOAuth2Client
                 * @constructor
                 * @param {flyteidl.core.IOAuth2Client=} [properties] Properties to set
                 */
                function OAuth2Client(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * OAuth2Client clientId.
                 * @member {string} clientId
                 * @memberof flyteidl.core.OAuth2Client
                 * @instance
                 */
                OAuth2Client.prototype.clientId = "";
    
                /**
                 * OAuth2Client clientSecret.
                 * @member {flyteidl.core.ISecret|null|undefined} clientSecret
                 * @memberof flyteidl.core.OAuth2Client
                 * @instance
                 */
                OAuth2Client.prototype.clientSecret = null;
    
                /**
                 * Creates a new OAuth2Client instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.OAuth2Client
                 * @static
                 * @param {flyteidl.core.IOAuth2Client=} [properties] Properties to set
                 * @returns {flyteidl.core.OAuth2Client} OAuth2Client instance
                 */
                OAuth2Client.create = function create(properties) {
                    return new OAuth2Client(properties);
                };
    
                /**
                 * Encodes the specified OAuth2Client message. Does not implicitly {@link flyteidl.core.OAuth2Client.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.OAuth2Client
                 * @static
                 * @param {flyteidl.core.IOAuth2Client} message OAuth2Client message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                OAuth2Client.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.clientId != null && message.hasOwnProperty("clientId"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.clientId);
                    if (message.clientSecret != null && message.hasOwnProperty("clientSecret"))
                        $root.flyteidl.core.Secret.encode(message.clientSecret, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a OAuth2Client message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.OAuth2Client
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.OAuth2Client} OAuth2Client
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                OAuth2Client.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.OAuth2Client();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.clientId = reader.string();
                            break;
                        case 2:
                            message.clientSecret = $root.flyteidl.core.Secret.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a OAuth2Client message.
                 * @function verify
                 * @memberof flyteidl.core.OAuth2Client
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                OAuth2Client.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.clientId != null && message.hasOwnProperty("clientId"))
                        if (!$util.isString(message.clientId))
                            return "clientId: string expected";
                    if (message.clientSecret != null && message.hasOwnProperty("clientSecret")) {
                        var error = $root.flyteidl.core.Secret.verify(message.clientSecret);
                        if (error)
                            return "clientSecret." + error;
                    }
                    return null;
                };
    
                return OAuth2Client;
            })();
    
            core.Identity = (function() {
    
                /**
                 * Properties of an Identity.
                 * @memberof flyteidl.core
                 * @interface IIdentity
                 * @property {string|null} [iamRole] Identity iamRole
                 * @property {string|null} [k8sServiceAccount] Identity k8sServiceAccount
                 * @property {flyteidl.core.IOAuth2Client|null} [oauth2Client] Identity oauth2Client
                 * @property {string|null} [executionIdentity] Identity executionIdentity
                 */
    
                /**
                 * Constructs a new Identity.
                 * @memberof flyteidl.core
                 * @classdesc Represents an Identity.
                 * @implements IIdentity
                 * @constructor
                 * @param {flyteidl.core.IIdentity=} [properties] Properties to set
                 */
                function Identity(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Identity iamRole.
                 * @member {string} iamRole
                 * @memberof flyteidl.core.Identity
                 * @instance
                 */
                Identity.prototype.iamRole = "";
    
                /**
                 * Identity k8sServiceAccount.
                 * @member {string} k8sServiceAccount
                 * @memberof flyteidl.core.Identity
                 * @instance
                 */
                Identity.prototype.k8sServiceAccount = "";
    
                /**
                 * Identity oauth2Client.
                 * @member {flyteidl.core.IOAuth2Client|null|undefined} oauth2Client
                 * @memberof flyteidl.core.Identity
                 * @instance
                 */
                Identity.prototype.oauth2Client = null;
    
                /**
                 * Identity executionIdentity.
                 * @member {string} executionIdentity
                 * @memberof flyteidl.core.Identity
                 * @instance
                 */
                Identity.prototype.executionIdentity = "";
    
                /**
                 * Creates a new Identity instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Identity
                 * @static
                 * @param {flyteidl.core.IIdentity=} [properties] Properties to set
                 * @returns {flyteidl.core.Identity} Identity instance
                 */
                Identity.create = function create(properties) {
                    return new Identity(properties);
                };
    
                /**
                 * Encodes the specified Identity message. Does not implicitly {@link flyteidl.core.Identity.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Identity
                 * @static
                 * @param {flyteidl.core.IIdentity} message Identity message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Identity.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.iamRole != null && message.hasOwnProperty("iamRole"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.iamRole);
                    if (message.k8sServiceAccount != null && message.hasOwnProperty("k8sServiceAccount"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.k8sServiceAccount);
                    if (message.oauth2Client != null && message.hasOwnProperty("oauth2Client"))
                        $root.flyteidl.core.OAuth2Client.encode(message.oauth2Client, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message.executionIdentity != null && message.hasOwnProperty("executionIdentity"))
                        writer.uint32(/* id 4, wireType 2 =*/34).string(message.executionIdentity);
                    return writer;
                };
    
                /**
                 * Decodes an Identity message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Identity
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Identity} Identity
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Identity.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Identity();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.iamRole = reader.string();
                            break;
                        case 2:
                            message.k8sServiceAccount = reader.string();
                            break;
                        case 3:
                            message.oauth2Client = $root.flyteidl.core.OAuth2Client.decode(reader, reader.uint32());
                            break;
                        case 4:
                            message.executionIdentity = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an Identity message.
                 * @function verify
                 * @memberof flyteidl.core.Identity
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Identity.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.iamRole != null && message.hasOwnProperty("iamRole"))
                        if (!$util.isString(message.iamRole))
                            return "iamRole: string expected";
                    if (message.k8sServiceAccount != null && message.hasOwnProperty("k8sServiceAccount"))
                        if (!$util.isString(message.k8sServiceAccount))
                            return "k8sServiceAccount: string expected";
                    if (message.oauth2Client != null && message.hasOwnProperty("oauth2Client")) {
                        var error = $root.flyteidl.core.OAuth2Client.verify(message.oauth2Client);
                        if (error)
                            return "oauth2Client." + error;
                    }
                    if (message.executionIdentity != null && message.hasOwnProperty("executionIdentity"))
                        if (!$util.isString(message.executionIdentity))
                            return "executionIdentity: string expected";
                    return null;
                };
    
                return Identity;
            })();
    
            core.OAuth2TokenRequest = (function() {
    
                /**
                 * Properties of a OAuth2TokenRequest.
                 * @memberof flyteidl.core
                 * @interface IOAuth2TokenRequest
                 * @property {string|null} [name] OAuth2TokenRequest name
                 * @property {flyteidl.core.OAuth2TokenRequest.Type|null} [type] OAuth2TokenRequest type
                 * @property {flyteidl.core.IOAuth2Client|null} [client] OAuth2TokenRequest client
                 * @property {string|null} [idpDiscoveryEndpoint] OAuth2TokenRequest idpDiscoveryEndpoint
                 * @property {string|null} [tokenEndpoint] OAuth2TokenRequest tokenEndpoint
                 */
    
                /**
                 * Constructs a new OAuth2TokenRequest.
                 * @memberof flyteidl.core
                 * @classdesc Represents a OAuth2TokenRequest.
                 * @implements IOAuth2TokenRequest
                 * @constructor
                 * @param {flyteidl.core.IOAuth2TokenRequest=} [properties] Properties to set
                 */
                function OAuth2TokenRequest(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * OAuth2TokenRequest name.
                 * @member {string} name
                 * @memberof flyteidl.core.OAuth2TokenRequest
                 * @instance
                 */
                OAuth2TokenRequest.prototype.name = "";
    
                /**
                 * OAuth2TokenRequest type.
                 * @member {flyteidl.core.OAuth2TokenRequest.Type} type
                 * @memberof flyteidl.core.OAuth2TokenRequest
                 * @instance
                 */
                OAuth2TokenRequest.prototype.type = 0;
    
                /**
                 * OAuth2TokenRequest client.
                 * @member {flyteidl.core.IOAuth2Client|null|undefined} client
                 * @memberof flyteidl.core.OAuth2TokenRequest
                 * @instance
                 */
                OAuth2TokenRequest.prototype.client = null;
    
                /**
                 * OAuth2TokenRequest idpDiscoveryEndpoint.
                 * @member {string} idpDiscoveryEndpoint
                 * @memberof flyteidl.core.OAuth2TokenRequest
                 * @instance
                 */
                OAuth2TokenRequest.prototype.idpDiscoveryEndpoint = "";
    
                /**
                 * OAuth2TokenRequest tokenEndpoint.
                 * @member {string} tokenEndpoint
                 * @memberof flyteidl.core.OAuth2TokenRequest
                 * @instance
                 */
                OAuth2TokenRequest.prototype.tokenEndpoint = "";
    
                /**
                 * Creates a new OAuth2TokenRequest instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.OAuth2TokenRequest
                 * @static
                 * @param {flyteidl.core.IOAuth2TokenRequest=} [properties] Properties to set
                 * @returns {flyteidl.core.OAuth2TokenRequest} OAuth2TokenRequest instance
                 */
                OAuth2TokenRequest.create = function create(properties) {
                    return new OAuth2TokenRequest(properties);
                };
    
                /**
                 * Encodes the specified OAuth2TokenRequest message. Does not implicitly {@link flyteidl.core.OAuth2TokenRequest.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.OAuth2TokenRequest
                 * @static
                 * @param {flyteidl.core.IOAuth2TokenRequest} message OAuth2TokenRequest message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                OAuth2TokenRequest.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.name != null && message.hasOwnProperty("name"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                    if (message.type != null && message.hasOwnProperty("type"))
                        writer.uint32(/* id 2, wireType 0 =*/16).int32(message.type);
                    if (message.client != null && message.hasOwnProperty("client"))
                        $root.flyteidl.core.OAuth2Client.encode(message.client, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message.idpDiscoveryEndpoint != null && message.hasOwnProperty("idpDiscoveryEndpoint"))
                        writer.uint32(/* id 4, wireType 2 =*/34).string(message.idpDiscoveryEndpoint);
                    if (message.tokenEndpoint != null && message.hasOwnProperty("tokenEndpoint"))
                        writer.uint32(/* id 5, wireType 2 =*/42).string(message.tokenEndpoint);
                    return writer;
                };
    
                /**
                 * Decodes a OAuth2TokenRequest message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.OAuth2TokenRequest
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.OAuth2TokenRequest} OAuth2TokenRequest
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                OAuth2TokenRequest.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.OAuth2TokenRequest();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.name = reader.string();
                            break;
                        case 2:
                            message.type = reader.int32();
                            break;
                        case 3:
                            message.client = $root.flyteidl.core.OAuth2Client.decode(reader, reader.uint32());
                            break;
                        case 4:
                            message.idpDiscoveryEndpoint = reader.string();
                            break;
                        case 5:
                            message.tokenEndpoint = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a OAuth2TokenRequest message.
                 * @function verify
                 * @memberof flyteidl.core.OAuth2TokenRequest
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                OAuth2TokenRequest.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.name != null && message.hasOwnProperty("name"))
                        if (!$util.isString(message.name))
                            return "name: string expected";
                    if (message.type != null && message.hasOwnProperty("type"))
                        switch (message.type) {
                        default:
                            return "type: enum value expected";
                        case 0:
                            break;
                        }
                    if (message.client != null && message.hasOwnProperty("client")) {
                        var error = $root.flyteidl.core.OAuth2Client.verify(message.client);
                        if (error)
                            return "client." + error;
                    }
                    if (message.idpDiscoveryEndpoint != null && message.hasOwnProperty("idpDiscoveryEndpoint"))
                        if (!$util.isString(message.idpDiscoveryEndpoint))
                            return "idpDiscoveryEndpoint: string expected";
                    if (message.tokenEndpoint != null && message.hasOwnProperty("tokenEndpoint"))
                        if (!$util.isString(message.tokenEndpoint))
                            return "tokenEndpoint: string expected";
                    return null;
                };
    
                /**
                 * Type enum.
                 * @name flyteidl.core.OAuth2TokenRequest.Type
                 * @enum {string}
                 * @property {number} CLIENT_CREDENTIALS=0 CLIENT_CREDENTIALS value
                 */
                OAuth2TokenRequest.Type = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "CLIENT_CREDENTIALS"] = 0;
                    return values;
                })();
    
                return OAuth2TokenRequest;
            })();
    
            core.SecurityContext = (function() {
    
                /**
                 * Properties of a SecurityContext.
                 * @memberof flyteidl.core
                 * @interface ISecurityContext
                 * @property {flyteidl.core.IIdentity|null} [runAs] SecurityContext runAs
                 * @property {Array.<flyteidl.core.ISecret>|null} [secrets] SecurityContext secrets
                 * @property {Array.<flyteidl.core.IOAuth2TokenRequest>|null} [tokens] SecurityContext tokens
                 */
    
                /**
                 * Constructs a new SecurityContext.
                 * @memberof flyteidl.core
                 * @classdesc Represents a SecurityContext.
                 * @implements ISecurityContext
                 * @constructor
                 * @param {flyteidl.core.ISecurityContext=} [properties] Properties to set
                 */
                function SecurityContext(properties) {
                    this.secrets = [];
                    this.tokens = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * SecurityContext runAs.
                 * @member {flyteidl.core.IIdentity|null|undefined} runAs
                 * @memberof flyteidl.core.SecurityContext
                 * @instance
                 */
                SecurityContext.prototype.runAs = null;
    
                /**
                 * SecurityContext secrets.
                 * @member {Array.<flyteidl.core.ISecret>} secrets
                 * @memberof flyteidl.core.SecurityContext
                 * @instance
                 */
                SecurityContext.prototype.secrets = $util.emptyArray;
    
                /**
                 * SecurityContext tokens.
                 * @member {Array.<flyteidl.core.IOAuth2TokenRequest>} tokens
                 * @memberof flyteidl.core.SecurityContext
                 * @instance
                 */
                SecurityContext.prototype.tokens = $util.emptyArray;
    
                /**
                 * Creates a new SecurityContext instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.SecurityContext
                 * @static
                 * @param {flyteidl.core.ISecurityContext=} [properties] Properties to set
                 * @returns {flyteidl.core.SecurityContext} SecurityContext instance
                 */
                SecurityContext.create = function create(properties) {
                    return new SecurityContext(properties);
                };
    
                /**
                 * Encodes the specified SecurityContext message. Does not implicitly {@link flyteidl.core.SecurityContext.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.SecurityContext
                 * @static
                 * @param {flyteidl.core.ISecurityContext} message SecurityContext message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                SecurityContext.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.runAs != null && message.hasOwnProperty("runAs"))
                        $root.flyteidl.core.Identity.encode(message.runAs, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.secrets != null && message.secrets.length)
                        for (var i = 0; i < message.secrets.length; ++i)
                            $root.flyteidl.core.Secret.encode(message.secrets[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.tokens != null && message.tokens.length)
                        for (var i = 0; i < message.tokens.length; ++i)
                            $root.flyteidl.core.OAuth2TokenRequest.encode(message.tokens[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a SecurityContext message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.SecurityContext
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.SecurityContext} SecurityContext
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                SecurityContext.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.SecurityContext();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.runAs = $root.flyteidl.core.Identity.decode(reader, reader.uint32());
                            break;
                        case 2:
                            if (!(message.secrets && message.secrets.length))
                                message.secrets = [];
                            message.secrets.push($root.flyteidl.core.Secret.decode(reader, reader.uint32()));
                            break;
                        case 3:
                            if (!(message.tokens && message.tokens.length))
                                message.tokens = [];
                            message.tokens.push($root.flyteidl.core.OAuth2TokenRequest.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a SecurityContext message.
                 * @function verify
                 * @memberof flyteidl.core.SecurityContext
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                SecurityContext.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.runAs != null && message.hasOwnProperty("runAs")) {
                        var error = $root.flyteidl.core.Identity.verify(message.runAs);
                        if (error)
                            return "runAs." + error;
                    }
                    if (message.secrets != null && message.hasOwnProperty("secrets")) {
                        if (!Array.isArray(message.secrets))
                            return "secrets: array expected";
                        for (var i = 0; i < message.secrets.length; ++i) {
                            var error = $root.flyteidl.core.Secret.verify(message.secrets[i]);
                            if (error)
                                return "secrets." + error;
                        }
                    }
                    if (message.tokens != null && message.hasOwnProperty("tokens")) {
                        if (!Array.isArray(message.tokens))
                            return "tokens: array expected";
                        for (var i = 0; i < message.tokens.length; ++i) {
                            var error = $root.flyteidl.core.OAuth2TokenRequest.verify(message.tokens[i]);
                            if (error)
                                return "tokens." + error;
                        }
                    }
                    return null;
                };
    
                return SecurityContext;
            })();
    
            core.DynamicJobSpec = (function() {
    
                /**
                 * Properties of a DynamicJobSpec.
                 * @memberof flyteidl.core
                 * @interface IDynamicJobSpec
                 * @property {Array.<flyteidl.core.INode>|null} [nodes] DynamicJobSpec nodes
                 * @property {Long|null} [minSuccesses] DynamicJobSpec minSuccesses
                 * @property {Array.<flyteidl.core.IBinding>|null} [outputs] DynamicJobSpec outputs
                 * @property {Array.<flyteidl.core.ITaskTemplate>|null} [tasks] DynamicJobSpec tasks
                 * @property {Array.<flyteidl.core.IWorkflowTemplate>|null} [subworkflows] DynamicJobSpec subworkflows
                 */
    
                /**
                 * Constructs a new DynamicJobSpec.
                 * @memberof flyteidl.core
                 * @classdesc Represents a DynamicJobSpec.
                 * @implements IDynamicJobSpec
                 * @constructor
                 * @param {flyteidl.core.IDynamicJobSpec=} [properties] Properties to set
                 */
                function DynamicJobSpec(properties) {
                    this.nodes = [];
                    this.outputs = [];
                    this.tasks = [];
                    this.subworkflows = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * DynamicJobSpec nodes.
                 * @member {Array.<flyteidl.core.INode>} nodes
                 * @memberof flyteidl.core.DynamicJobSpec
                 * @instance
                 */
                DynamicJobSpec.prototype.nodes = $util.emptyArray;
    
                /**
                 * DynamicJobSpec minSuccesses.
                 * @member {Long} minSuccesses
                 * @memberof flyteidl.core.DynamicJobSpec
                 * @instance
                 */
                DynamicJobSpec.prototype.minSuccesses = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                /**
                 * DynamicJobSpec outputs.
                 * @member {Array.<flyteidl.core.IBinding>} outputs
                 * @memberof flyteidl.core.DynamicJobSpec
                 * @instance
                 */
                DynamicJobSpec.prototype.outputs = $util.emptyArray;
    
                /**
                 * DynamicJobSpec tasks.
                 * @member {Array.<flyteidl.core.ITaskTemplate>} tasks
                 * @memberof flyteidl.core.DynamicJobSpec
                 * @instance
                 */
                DynamicJobSpec.prototype.tasks = $util.emptyArray;
    
                /**
                 * DynamicJobSpec subworkflows.
                 * @member {Array.<flyteidl.core.IWorkflowTemplate>} subworkflows
                 * @memberof flyteidl.core.DynamicJobSpec
                 * @instance
                 */
                DynamicJobSpec.prototype.subworkflows = $util.emptyArray;
    
                /**
                 * Creates a new DynamicJobSpec instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.DynamicJobSpec
                 * @static
                 * @param {flyteidl.core.IDynamicJobSpec=} [properties] Properties to set
                 * @returns {flyteidl.core.DynamicJobSpec} DynamicJobSpec instance
                 */
                DynamicJobSpec.create = function create(properties) {
                    return new DynamicJobSpec(properties);
                };
    
                /**
                 * Encodes the specified DynamicJobSpec message. Does not implicitly {@link flyteidl.core.DynamicJobSpec.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.DynamicJobSpec
                 * @static
                 * @param {flyteidl.core.IDynamicJobSpec} message DynamicJobSpec message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                DynamicJobSpec.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.nodes != null && message.nodes.length)
                        for (var i = 0; i < message.nodes.length; ++i)
                            $root.flyteidl.core.Node.encode(message.nodes[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.minSuccesses != null && message.hasOwnProperty("minSuccesses"))
                        writer.uint32(/* id 2, wireType 0 =*/16).int64(message.minSuccesses);
                    if (message.outputs != null && message.outputs.length)
                        for (var i = 0; i < message.outputs.length; ++i)
                            $root.flyteidl.core.Binding.encode(message.outputs[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message.tasks != null && message.tasks.length)
                        for (var i = 0; i < message.tasks.length; ++i)
                            $root.flyteidl.core.TaskTemplate.encode(message.tasks[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.subworkflows != null && message.subworkflows.length)
                        for (var i = 0; i < message.subworkflows.length; ++i)
                            $root.flyteidl.core.WorkflowTemplate.encode(message.subworkflows[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a DynamicJobSpec message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.DynamicJobSpec
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.DynamicJobSpec} DynamicJobSpec
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                DynamicJobSpec.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.DynamicJobSpec();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            if (!(message.nodes && message.nodes.length))
                                message.nodes = [];
                            message.nodes.push($root.flyteidl.core.Node.decode(reader, reader.uint32()));
                            break;
                        case 2:
                            message.minSuccesses = reader.int64();
                            break;
                        case 3:
                            if (!(message.outputs && message.outputs.length))
                                message.outputs = [];
                            message.outputs.push($root.flyteidl.core.Binding.decode(reader, reader.uint32()));
                            break;
                        case 4:
                            if (!(message.tasks && message.tasks.length))
                                message.tasks = [];
                            message.tasks.push($root.flyteidl.core.TaskTemplate.decode(reader, reader.uint32()));
                            break;
                        case 5:
                            if (!(message.subworkflows && message.subworkflows.length))
                                message.subworkflows = [];
                            message.subworkflows.push($root.flyteidl.core.WorkflowTemplate.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a DynamicJobSpec message.
                 * @function verify
                 * @memberof flyteidl.core.DynamicJobSpec
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                DynamicJobSpec.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.nodes != null && message.hasOwnProperty("nodes")) {
                        if (!Array.isArray(message.nodes))
                            return "nodes: array expected";
                        for (var i = 0; i < message.nodes.length; ++i) {
                            var error = $root.flyteidl.core.Node.verify(message.nodes[i]);
                            if (error)
                                return "nodes." + error;
                        }
                    }
                    if (message.minSuccesses != null && message.hasOwnProperty("minSuccesses"))
                        if (!$util.isInteger(message.minSuccesses) && !(message.minSuccesses && $util.isInteger(message.minSuccesses.low) && $util.isInteger(message.minSuccesses.high)))
                            return "minSuccesses: integer|Long expected";
                    if (message.outputs != null && message.hasOwnProperty("outputs")) {
                        if (!Array.isArray(message.outputs))
                            return "outputs: array expected";
                        for (var i = 0; i < message.outputs.length; ++i) {
                            var error = $root.flyteidl.core.Binding.verify(message.outputs[i]);
                            if (error)
                                return "outputs." + error;
                        }
                    }
                    if (message.tasks != null && message.hasOwnProperty("tasks")) {
                        if (!Array.isArray(message.tasks))
                            return "tasks: array expected";
                        for (var i = 0; i < message.tasks.length; ++i) {
                            var error = $root.flyteidl.core.TaskTemplate.verify(message.tasks[i]);
                            if (error)
                                return "tasks." + error;
                        }
                    }
                    if (message.subworkflows != null && message.hasOwnProperty("subworkflows")) {
                        if (!Array.isArray(message.subworkflows))
                            return "subworkflows: array expected";
                        for (var i = 0; i < message.subworkflows.length; ++i) {
                            var error = $root.flyteidl.core.WorkflowTemplate.verify(message.subworkflows[i]);
                            if (error)
                                return "subworkflows." + error;
                        }
                    }
                    return null;
                };
    
                return DynamicJobSpec;
            })();
    
            core.ContainerError = (function() {
    
                /**
                 * Properties of a ContainerError.
                 * @memberof flyteidl.core
                 * @interface IContainerError
                 * @property {string|null} [code] ContainerError code
                 * @property {string|null} [message] ContainerError message
                 * @property {flyteidl.core.ContainerError.Kind|null} [kind] ContainerError kind
                 * @property {flyteidl.core.ExecutionError.ErrorKind|null} [origin] ContainerError origin
                 * @property {google.protobuf.ITimestamp|null} [timestamp] ContainerError timestamp
                 * @property {string|null} [worker] ContainerError worker
                 */
    
                /**
                 * Constructs a new ContainerError.
                 * @memberof flyteidl.core
                 * @classdesc Represents a ContainerError.
                 * @implements IContainerError
                 * @constructor
                 * @param {flyteidl.core.IContainerError=} [properties] Properties to set
                 */
                function ContainerError(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * ContainerError code.
                 * @member {string} code
                 * @memberof flyteidl.core.ContainerError
                 * @instance
                 */
                ContainerError.prototype.code = "";
    
                /**
                 * ContainerError message.
                 * @member {string} message
                 * @memberof flyteidl.core.ContainerError
                 * @instance
                 */
                ContainerError.prototype.message = "";
    
                /**
                 * ContainerError kind.
                 * @member {flyteidl.core.ContainerError.Kind} kind
                 * @memberof flyteidl.core.ContainerError
                 * @instance
                 */
                ContainerError.prototype.kind = 0;
    
                /**
                 * ContainerError origin.
                 * @member {flyteidl.core.ExecutionError.ErrorKind} origin
                 * @memberof flyteidl.core.ContainerError
                 * @instance
                 */
                ContainerError.prototype.origin = 0;
    
                /**
                 * ContainerError timestamp.
                 * @member {google.protobuf.ITimestamp|null|undefined} timestamp
                 * @memberof flyteidl.core.ContainerError
                 * @instance
                 */
                ContainerError.prototype.timestamp = null;
    
                /**
                 * ContainerError worker.
                 * @member {string} worker
                 * @memberof flyteidl.core.ContainerError
                 * @instance
                 */
                ContainerError.prototype.worker = "";
    
                /**
                 * Creates a new ContainerError instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.ContainerError
                 * @static
                 * @param {flyteidl.core.IContainerError=} [properties] Properties to set
                 * @returns {flyteidl.core.ContainerError} ContainerError instance
                 */
                ContainerError.create = function create(properties) {
                    return new ContainerError(properties);
                };
    
                /**
                 * Encodes the specified ContainerError message. Does not implicitly {@link flyteidl.core.ContainerError.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.ContainerError
                 * @static
                 * @param {flyteidl.core.IContainerError} message ContainerError message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ContainerError.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.code != null && message.hasOwnProperty("code"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.code);
                    if (message.message != null && message.hasOwnProperty("message"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.message);
                    if (message.kind != null && message.hasOwnProperty("kind"))
                        writer.uint32(/* id 3, wireType 0 =*/24).int32(message.kind);
                    if (message.origin != null && message.hasOwnProperty("origin"))
                        writer.uint32(/* id 4, wireType 0 =*/32).int32(message.origin);
                    if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                        $root.google.protobuf.Timestamp.encode(message.timestamp, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                    if (message.worker != null && message.hasOwnProperty("worker"))
                        writer.uint32(/* id 6, wireType 2 =*/50).string(message.worker);
                    return writer;
                };
    
                /**
                 * Decodes a ContainerError message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.ContainerError
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.ContainerError} ContainerError
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ContainerError.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.ContainerError();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.code = reader.string();
                            break;
                        case 2:
                            message.message = reader.string();
                            break;
                        case 3:
                            message.kind = reader.int32();
                            break;
                        case 4:
                            message.origin = reader.int32();
                            break;
                        case 5:
                            message.timestamp = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                            break;
                        case 6:
                            message.worker = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a ContainerError message.
                 * @function verify
                 * @memberof flyteidl.core.ContainerError
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ContainerError.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.code != null && message.hasOwnProperty("code"))
                        if (!$util.isString(message.code))
                            return "code: string expected";
                    if (message.message != null && message.hasOwnProperty("message"))
                        if (!$util.isString(message.message))
                            return "message: string expected";
                    if (message.kind != null && message.hasOwnProperty("kind"))
                        switch (message.kind) {
                        default:
                            return "kind: enum value expected";
                        case 0:
                        case 1:
                            break;
                        }
                    if (message.origin != null && message.hasOwnProperty("origin"))
                        switch (message.origin) {
                        default:
                            return "origin: enum value expected";
                        case 0:
                        case 1:
                        case 2:
                            break;
                        }
                    if (message.timestamp != null && message.hasOwnProperty("timestamp")) {
                        var error = $root.google.protobuf.Timestamp.verify(message.timestamp);
                        if (error)
                            return "timestamp." + error;
                    }
                    if (message.worker != null && message.hasOwnProperty("worker"))
                        if (!$util.isString(message.worker))
                            return "worker: string expected";
                    return null;
                };
    
                /**
                 * Kind enum.
                 * @name flyteidl.core.ContainerError.Kind
                 * @enum {string}
                 * @property {number} NON_RECOVERABLE=0 NON_RECOVERABLE value
                 * @property {number} RECOVERABLE=1 RECOVERABLE value
                 */
                ContainerError.Kind = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "NON_RECOVERABLE"] = 0;
                    values[valuesById[1] = "RECOVERABLE"] = 1;
                    return values;
                })();
    
                return ContainerError;
            })();
    
            core.ErrorDocument = (function() {
    
                /**
                 * Properties of an ErrorDocument.
                 * @memberof flyteidl.core
                 * @interface IErrorDocument
                 * @property {flyteidl.core.IContainerError|null} [error] ErrorDocument error
                 */
    
                /**
                 * Constructs a new ErrorDocument.
                 * @memberof flyteidl.core
                 * @classdesc Represents an ErrorDocument.
                 * @implements IErrorDocument
                 * @constructor
                 * @param {flyteidl.core.IErrorDocument=} [properties] Properties to set
                 */
                function ErrorDocument(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * ErrorDocument error.
                 * @member {flyteidl.core.IContainerError|null|undefined} error
                 * @memberof flyteidl.core.ErrorDocument
                 * @instance
                 */
                ErrorDocument.prototype.error = null;
    
                /**
                 * Creates a new ErrorDocument instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.ErrorDocument
                 * @static
                 * @param {flyteidl.core.IErrorDocument=} [properties] Properties to set
                 * @returns {flyteidl.core.ErrorDocument} ErrorDocument instance
                 */
                ErrorDocument.create = function create(properties) {
                    return new ErrorDocument(properties);
                };
    
                /**
                 * Encodes the specified ErrorDocument message. Does not implicitly {@link flyteidl.core.ErrorDocument.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.ErrorDocument
                 * @static
                 * @param {flyteidl.core.IErrorDocument} message ErrorDocument message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ErrorDocument.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.error != null && message.hasOwnProperty("error"))
                        $root.flyteidl.core.ContainerError.encode(message.error, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes an ErrorDocument message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.ErrorDocument
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.ErrorDocument} ErrorDocument
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ErrorDocument.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.ErrorDocument();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.error = $root.flyteidl.core.ContainerError.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an ErrorDocument message.
                 * @function verify
                 * @memberof flyteidl.core.ErrorDocument
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ErrorDocument.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.error != null && message.hasOwnProperty("error")) {
                        var error = $root.flyteidl.core.ContainerError.verify(message.error);
                        if (error)
                            return "error." + error;
                    }
                    return null;
                };
    
                return ErrorDocument;
            })();
    
            core.ExecutionEnvAssignment = (function() {
    
                /**
                 * Properties of an ExecutionEnvAssignment.
                 * @memberof flyteidl.core
                 * @interface IExecutionEnvAssignment
                 * @property {Array.<string>|null} [nodeIds] ExecutionEnvAssignment nodeIds
                 * @property {string|null} [taskType] ExecutionEnvAssignment taskType
                 * @property {flyteidl.core.IExecutionEnv|null} [executionEnv] ExecutionEnvAssignment executionEnv
                 */
    
                /**
                 * Constructs a new ExecutionEnvAssignment.
                 * @memberof flyteidl.core
                 * @classdesc Represents an ExecutionEnvAssignment.
                 * @implements IExecutionEnvAssignment
                 * @constructor
                 * @param {flyteidl.core.IExecutionEnvAssignment=} [properties] Properties to set
                 */
                function ExecutionEnvAssignment(properties) {
                    this.nodeIds = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * ExecutionEnvAssignment nodeIds.
                 * @member {Array.<string>} nodeIds
                 * @memberof flyteidl.core.ExecutionEnvAssignment
                 * @instance
                 */
                ExecutionEnvAssignment.prototype.nodeIds = $util.emptyArray;
    
                /**
                 * ExecutionEnvAssignment taskType.
                 * @member {string} taskType
                 * @memberof flyteidl.core.ExecutionEnvAssignment
                 * @instance
                 */
                ExecutionEnvAssignment.prototype.taskType = "";
    
                /**
                 * ExecutionEnvAssignment executionEnv.
                 * @member {flyteidl.core.IExecutionEnv|null|undefined} executionEnv
                 * @memberof flyteidl.core.ExecutionEnvAssignment
                 * @instance
                 */
                ExecutionEnvAssignment.prototype.executionEnv = null;
    
                /**
                 * Creates a new ExecutionEnvAssignment instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.ExecutionEnvAssignment
                 * @static
                 * @param {flyteidl.core.IExecutionEnvAssignment=} [properties] Properties to set
                 * @returns {flyteidl.core.ExecutionEnvAssignment} ExecutionEnvAssignment instance
                 */
                ExecutionEnvAssignment.create = function create(properties) {
                    return new ExecutionEnvAssignment(properties);
                };
    
                /**
                 * Encodes the specified ExecutionEnvAssignment message. Does not implicitly {@link flyteidl.core.ExecutionEnvAssignment.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.ExecutionEnvAssignment
                 * @static
                 * @param {flyteidl.core.IExecutionEnvAssignment} message ExecutionEnvAssignment message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ExecutionEnvAssignment.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.nodeIds != null && message.nodeIds.length)
                        for (var i = 0; i < message.nodeIds.length; ++i)
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.nodeIds[i]);
                    if (message.taskType != null && message.hasOwnProperty("taskType"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.taskType);
                    if (message.executionEnv != null && message.hasOwnProperty("executionEnv"))
                        $root.flyteidl.core.ExecutionEnv.encode(message.executionEnv, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes an ExecutionEnvAssignment message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.ExecutionEnvAssignment
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.ExecutionEnvAssignment} ExecutionEnvAssignment
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ExecutionEnvAssignment.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.ExecutionEnvAssignment();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            if (!(message.nodeIds && message.nodeIds.length))
                                message.nodeIds = [];
                            message.nodeIds.push(reader.string());
                            break;
                        case 2:
                            message.taskType = reader.string();
                            break;
                        case 3:
                            message.executionEnv = $root.flyteidl.core.ExecutionEnv.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an ExecutionEnvAssignment message.
                 * @function verify
                 * @memberof flyteidl.core.ExecutionEnvAssignment
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ExecutionEnvAssignment.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.nodeIds != null && message.hasOwnProperty("nodeIds")) {
                        if (!Array.isArray(message.nodeIds))
                            return "nodeIds: array expected";
                        for (var i = 0; i < message.nodeIds.length; ++i)
                            if (!$util.isString(message.nodeIds[i]))
                                return "nodeIds: string[] expected";
                    }
                    if (message.taskType != null && message.hasOwnProperty("taskType"))
                        if (!$util.isString(message.taskType))
                            return "taskType: string expected";
                    if (message.executionEnv != null && message.hasOwnProperty("executionEnv")) {
                        var error = $root.flyteidl.core.ExecutionEnv.verify(message.executionEnv);
                        if (error)
                            return "executionEnv." + error;
                    }
                    return null;
                };
    
                return ExecutionEnvAssignment;
            })();
    
            core.ExecutionEnv = (function() {
    
                /**
                 * Properties of an ExecutionEnv.
                 * @memberof flyteidl.core
                 * @interface IExecutionEnv
                 * @property {string|null} [name] ExecutionEnv name
                 * @property {string|null} [type] ExecutionEnv type
                 * @property {google.protobuf.IStruct|null} [extant] ExecutionEnv extant
                 * @property {google.protobuf.IStruct|null} [spec] ExecutionEnv spec
                 * @property {string|null} [version] ExecutionEnv version
                 */
    
                /**
                 * Constructs a new ExecutionEnv.
                 * @memberof flyteidl.core
                 * @classdesc Represents an ExecutionEnv.
                 * @implements IExecutionEnv
                 * @constructor
                 * @param {flyteidl.core.IExecutionEnv=} [properties] Properties to set
                 */
                function ExecutionEnv(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * ExecutionEnv name.
                 * @member {string} name
                 * @memberof flyteidl.core.ExecutionEnv
                 * @instance
                 */
                ExecutionEnv.prototype.name = "";
    
                /**
                 * ExecutionEnv type.
                 * @member {string} type
                 * @memberof flyteidl.core.ExecutionEnv
                 * @instance
                 */
                ExecutionEnv.prototype.type = "";
    
                /**
                 * ExecutionEnv extant.
                 * @member {google.protobuf.IStruct|null|undefined} extant
                 * @memberof flyteidl.core.ExecutionEnv
                 * @instance
                 */
                ExecutionEnv.prototype.extant = null;
    
                /**
                 * ExecutionEnv spec.
                 * @member {google.protobuf.IStruct|null|undefined} spec
                 * @memberof flyteidl.core.ExecutionEnv
                 * @instance
                 */
                ExecutionEnv.prototype.spec = null;
    
                /**
                 * ExecutionEnv version.
                 * @member {string} version
                 * @memberof flyteidl.core.ExecutionEnv
                 * @instance
                 */
                ExecutionEnv.prototype.version = "";
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * ExecutionEnv environment.
                 * @member {"extant"|"spec"|undefined} environment
                 * @memberof flyteidl.core.ExecutionEnv
                 * @instance
                 */
                Object.defineProperty(ExecutionEnv.prototype, "environment", {
                    get: $util.oneOfGetter($oneOfFields = ["extant", "spec"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new ExecutionEnv instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.ExecutionEnv
                 * @static
                 * @param {flyteidl.core.IExecutionEnv=} [properties] Properties to set
                 * @returns {flyteidl.core.ExecutionEnv} ExecutionEnv instance
                 */
                ExecutionEnv.create = function create(properties) {
                    return new ExecutionEnv(properties);
                };
    
                /**
                 * Encodes the specified ExecutionEnv message. Does not implicitly {@link flyteidl.core.ExecutionEnv.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.ExecutionEnv
                 * @static
                 * @param {flyteidl.core.IExecutionEnv} message ExecutionEnv message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ExecutionEnv.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.name != null && message.hasOwnProperty("name"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                    if (message.type != null && message.hasOwnProperty("type"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.type);
                    if (message.extant != null && message.hasOwnProperty("extant"))
                        $root.google.protobuf.Struct.encode(message.extant, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message.spec != null && message.hasOwnProperty("spec"))
                        $root.google.protobuf.Struct.encode(message.spec, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.version != null && message.hasOwnProperty("version"))
                        writer.uint32(/* id 5, wireType 2 =*/42).string(message.version);
                    return writer;
                };
    
                /**
                 * Decodes an ExecutionEnv message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.ExecutionEnv
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.ExecutionEnv} ExecutionEnv
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ExecutionEnv.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.ExecutionEnv();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.name = reader.string();
                            break;
                        case 2:
                            message.type = reader.string();
                            break;
                        case 3:
                            message.extant = $root.google.protobuf.Struct.decode(reader, reader.uint32());
                            break;
                        case 4:
                            message.spec = $root.google.protobuf.Struct.decode(reader, reader.uint32());
                            break;
                        case 5:
                            message.version = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an ExecutionEnv message.
                 * @function verify
                 * @memberof flyteidl.core.ExecutionEnv
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ExecutionEnv.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.name != null && message.hasOwnProperty("name"))
                        if (!$util.isString(message.name))
                            return "name: string expected";
                    if (message.type != null && message.hasOwnProperty("type"))
                        if (!$util.isString(message.type))
                            return "type: string expected";
                    if (message.extant != null && message.hasOwnProperty("extant")) {
                        properties.environment = 1;
                        {
                            var error = $root.google.protobuf.Struct.verify(message.extant);
                            if (error)
                                return "extant." + error;
                        }
                    }
                    if (message.spec != null && message.hasOwnProperty("spec")) {
                        if (properties.environment === 1)
                            return "environment: multiple values";
                        properties.environment = 1;
                        {
                            var error = $root.google.protobuf.Struct.verify(message.spec);
                            if (error)
                                return "spec." + error;
                        }
                    }
                    if (message.version != null && message.hasOwnProperty("version"))
                        if (!$util.isString(message.version))
                            return "version: string expected";
                    return null;
                };
    
                return ExecutionEnv;
            })();
    
            core.Span = (function() {
    
                /**
                 * Properties of a Span.
                 * @memberof flyteidl.core
                 * @interface ISpan
                 * @property {google.protobuf.ITimestamp|null} [startTime] Span startTime
                 * @property {google.protobuf.ITimestamp|null} [endTime] Span endTime
                 * @property {flyteidl.core.IWorkflowExecutionIdentifier|null} [workflowId] Span workflowId
                 * @property {flyteidl.core.INodeExecutionIdentifier|null} [nodeId] Span nodeId
                 * @property {flyteidl.core.ITaskExecutionIdentifier|null} [taskId] Span taskId
                 * @property {string|null} [operationId] Span operationId
                 * @property {Array.<flyteidl.core.ISpan>|null} [spans] Span spans
                 */
    
                /**
                 * Constructs a new Span.
                 * @memberof flyteidl.core
                 * @classdesc Represents a Span.
                 * @implements ISpan
                 * @constructor
                 * @param {flyteidl.core.ISpan=} [properties] Properties to set
                 */
                function Span(properties) {
                    this.spans = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * Span startTime.
                 * @member {google.protobuf.ITimestamp|null|undefined} startTime
                 * @memberof flyteidl.core.Span
                 * @instance
                 */
                Span.prototype.startTime = null;
    
                /**
                 * Span endTime.
                 * @member {google.protobuf.ITimestamp|null|undefined} endTime
                 * @memberof flyteidl.core.Span
                 * @instance
                 */
                Span.prototype.endTime = null;
    
                /**
                 * Span workflowId.
                 * @member {flyteidl.core.IWorkflowExecutionIdentifier|null|undefined} workflowId
                 * @memberof flyteidl.core.Span
                 * @instance
                 */
                Span.prototype.workflowId = null;
    
                /**
                 * Span nodeId.
                 * @member {flyteidl.core.INodeExecutionIdentifier|null|undefined} nodeId
                 * @memberof flyteidl.core.Span
                 * @instance
                 */
                Span.prototype.nodeId = null;
    
                /**
                 * Span taskId.
                 * @member {flyteidl.core.ITaskExecutionIdentifier|null|undefined} taskId
                 * @memberof flyteidl.core.Span
                 * @instance
                 */
                Span.prototype.taskId = null;
    
                /**
                 * Span operationId.
                 * @member {string} operationId
                 * @memberof flyteidl.core.Span
                 * @instance
                 */
                Span.prototype.operationId = "";
    
                /**
                 * Span spans.
                 * @member {Array.<flyteidl.core.ISpan>} spans
                 * @memberof flyteidl.core.Span
                 * @instance
                 */
                Span.prototype.spans = $util.emptyArray;
    
                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;
    
                /**
                 * Span id.
                 * @member {"workflowId"|"nodeId"|"taskId"|"operationId"|undefined} id
                 * @memberof flyteidl.core.Span
                 * @instance
                 */
                Object.defineProperty(Span.prototype, "id", {
                    get: $util.oneOfGetter($oneOfFields = ["workflowId", "nodeId", "taskId", "operationId"]),
                    set: $util.oneOfSetter($oneOfFields)
                });
    
                /**
                 * Creates a new Span instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.Span
                 * @static
                 * @param {flyteidl.core.ISpan=} [properties] Properties to set
                 * @returns {flyteidl.core.Span} Span instance
                 */
                Span.create = function create(properties) {
                    return new Span(properties);
                };
    
                /**
                 * Encodes the specified Span message. Does not implicitly {@link flyteidl.core.Span.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.Span
                 * @static
                 * @param {flyteidl.core.ISpan} message Span message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Span.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.startTime != null && message.hasOwnProperty("startTime"))
                        $root.google.protobuf.Timestamp.encode(message.startTime, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.endTime != null && message.hasOwnProperty("endTime"))
                        $root.google.protobuf.Timestamp.encode(message.endTime, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.workflowId != null && message.hasOwnProperty("workflowId"))
                        $root.flyteidl.core.WorkflowExecutionIdentifier.encode(message.workflowId, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message.nodeId != null && message.hasOwnProperty("nodeId"))
                        $root.flyteidl.core.NodeExecutionIdentifier.encode(message.nodeId, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.taskId != null && message.hasOwnProperty("taskId"))
                        $root.flyteidl.core.TaskExecutionIdentifier.encode(message.taskId, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                    if (message.operationId != null && message.hasOwnProperty("operationId"))
                        writer.uint32(/* id 6, wireType 2 =*/50).string(message.operationId);
                    if (message.spans != null && message.spans.length)
                        for (var i = 0; i < message.spans.length; ++i)
                            $root.flyteidl.core.Span.encode(message.spans[i], writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a Span message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.Span
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.Span} Span
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Span.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.Span();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.startTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.endTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                            break;
                        case 3:
                            message.workflowId = $root.flyteidl.core.WorkflowExecutionIdentifier.decode(reader, reader.uint32());
                            break;
                        case 4:
                            message.nodeId = $root.flyteidl.core.NodeExecutionIdentifier.decode(reader, reader.uint32());
                            break;
                        case 5:
                            message.taskId = $root.flyteidl.core.TaskExecutionIdentifier.decode(reader, reader.uint32());
                            break;
                        case 6:
                            message.operationId = reader.string();
                            break;
                        case 7:
                            if (!(message.spans && message.spans.length))
                                message.spans = [];
                            message.spans.push($root.flyteidl.core.Span.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a Span message.
                 * @function verify
                 * @memberof flyteidl.core.Span
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Span.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.startTime != null && message.hasOwnProperty("startTime")) {
                        var error = $root.google.protobuf.Timestamp.verify(message.startTime);
                        if (error)
                            return "startTime." + error;
                    }
                    if (message.endTime != null && message.hasOwnProperty("endTime")) {
                        var error = $root.google.protobuf.Timestamp.verify(message.endTime);
                        if (error)
                            return "endTime." + error;
                    }
                    if (message.workflowId != null && message.hasOwnProperty("workflowId")) {
                        properties.id = 1;
                        {
                            var error = $root.flyteidl.core.WorkflowExecutionIdentifier.verify(message.workflowId);
                            if (error)
                                return "workflowId." + error;
                        }
                    }
                    if (message.nodeId != null && message.hasOwnProperty("nodeId")) {
                        if (properties.id === 1)
                            return "id: multiple values";
                        properties.id = 1;
                        {
                            var error = $root.flyteidl.core.NodeExecutionIdentifier.verify(message.nodeId);
                            if (error)
                                return "nodeId." + error;
                        }
                    }
                    if (message.taskId != null && message.hasOwnProperty("taskId")) {
                        if (properties.id === 1)
                            return "id: multiple values";
                        properties.id = 1;
                        {
                            var error = $root.flyteidl.core.TaskExecutionIdentifier.verify(message.taskId);
                            if (error)
                                return "taskId." + error;
                        }
                    }
                    if (message.operationId != null && message.hasOwnProperty("operationId")) {
                        if (properties.id === 1)
                            return "id: multiple values";
                        properties.id = 1;
                        if (!$util.isString(message.operationId))
                            return "operationId: string expected";
                    }
                    if (message.spans != null && message.hasOwnProperty("spans")) {
                        if (!Array.isArray(message.spans))
                            return "spans: array expected";
                        for (var i = 0; i < message.spans.length; ++i) {
                            var error = $root.flyteidl.core.Span.verify(message.spans[i]);
                            if (error)
                                return "spans." + error;
                        }
                    }
                    return null;
                };
    
                return Span;
            })();
    
            core.ExecutionMetricResult = (function() {
    
                /**
                 * Properties of an ExecutionMetricResult.
                 * @memberof flyteidl.core
                 * @interface IExecutionMetricResult
                 * @property {string|null} [metric] ExecutionMetricResult metric
                 * @property {google.protobuf.IStruct|null} [data] ExecutionMetricResult data
                 */
    
                /**
                 * Constructs a new ExecutionMetricResult.
                 * @memberof flyteidl.core
                 * @classdesc Represents an ExecutionMetricResult.
                 * @implements IExecutionMetricResult
                 * @constructor
                 * @param {flyteidl.core.IExecutionMetricResult=} [properties] Properties to set
                 */
                function ExecutionMetricResult(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * ExecutionMetricResult metric.
                 * @member {string} metric
                 * @memberof flyteidl.core.ExecutionMetricResult
                 * @instance
                 */
                ExecutionMetricResult.prototype.metric = "";
    
                /**
                 * ExecutionMetricResult data.
                 * @member {google.protobuf.IStruct|null|undefined} data
                 * @memberof flyteidl.core.ExecutionMetricResult
                 * @instance
                 */
                ExecutionMetricResult.prototype.data = null;
    
                /**
                 * Creates a new ExecutionMetricResult instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.ExecutionMetricResult
                 * @static
                 * @param {flyteidl.core.IExecutionMetricResult=} [properties] Properties to set
                 * @returns {flyteidl.core.ExecutionMetricResult} ExecutionMetricResult instance
                 */
                ExecutionMetricResult.create = function create(properties) {
                    return new ExecutionMetricResult(properties);
                };
    
                /**
                 * Encodes the specified ExecutionMetricResult message. Does not implicitly {@link flyteidl.core.ExecutionMetricResult.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.ExecutionMetricResult
                 * @static
                 * @param {flyteidl.core.IExecutionMetricResult} message ExecutionMetricResult message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ExecutionMetricResult.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.metric != null && message.hasOwnProperty("metric"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.metric);
                    if (message.data != null && message.hasOwnProperty("data"))
                        $root.google.protobuf.Struct.encode(message.data, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes an ExecutionMetricResult message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.ExecutionMetricResult
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.ExecutionMetricResult} ExecutionMetricResult
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ExecutionMetricResult.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.ExecutionMetricResult();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.metric = reader.string();
                            break;
                        case 2:
                            message.data = $root.google.protobuf.Struct.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies an ExecutionMetricResult message.
                 * @function verify
                 * @memberof flyteidl.core.ExecutionMetricResult
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ExecutionMetricResult.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.metric != null && message.hasOwnProperty("metric"))
                        if (!$util.isString(message.metric))
                            return "metric: string expected";
                    if (message.data != null && message.hasOwnProperty("data")) {
                        var error = $root.google.protobuf.Struct.verify(message.data);
                        if (error)
                            return "data." + error;
                    }
                    return null;
                };
    
                return ExecutionMetricResult;
            })();
    
            core.WorkflowClosure = (function() {
    
                /**
                 * Properties of a WorkflowClosure.
                 * @memberof flyteidl.core
                 * @interface IWorkflowClosure
                 * @property {flyteidl.core.IWorkflowTemplate|null} [workflow] WorkflowClosure workflow
                 * @property {Array.<flyteidl.core.ITaskTemplate>|null} [tasks] WorkflowClosure tasks
                 */
    
                /**
                 * Constructs a new WorkflowClosure.
                 * @memberof flyteidl.core
                 * @classdesc Represents a WorkflowClosure.
                 * @implements IWorkflowClosure
                 * @constructor
                 * @param {flyteidl.core.IWorkflowClosure=} [properties] Properties to set
                 */
                function WorkflowClosure(properties) {
                    this.tasks = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * WorkflowClosure workflow.
                 * @member {flyteidl.core.IWorkflowTemplate|null|undefined} workflow
                 * @memberof flyteidl.core.WorkflowClosure
                 * @instance
                 */
                WorkflowClosure.prototype.workflow = null;
    
                /**
                 * WorkflowClosure tasks.
                 * @member {Array.<flyteidl.core.ITaskTemplate>} tasks
                 * @memberof flyteidl.core.WorkflowClosure
                 * @instance
                 */
                WorkflowClosure.prototype.tasks = $util.emptyArray;
    
                /**
                 * Creates a new WorkflowClosure instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.core.WorkflowClosure
                 * @static
                 * @param {flyteidl.core.IWorkflowClosure=} [properties] Properties to set
                 * @returns {flyteidl.core.WorkflowClosure} WorkflowClosure instance
                 */
                WorkflowClosure.create = function create(properties) {
                    return new WorkflowClosure(properties);
                };
    
                /**
                 * Encodes the specified WorkflowClosure message. Does not implicitly {@link flyteidl.core.WorkflowClosure.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.core.WorkflowClosure
                 * @static
                 * @param {flyteidl.core.IWorkflowClosure} message WorkflowClosure message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                WorkflowClosure.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.workflow != null && message.hasOwnProperty("workflow"))
                        $root.flyteidl.core.WorkflowTemplate.encode(message.workflow, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.tasks != null && message.tasks.length)
                        for (var i = 0; i < message.tasks.length; ++i)
                            $root.flyteidl.core.TaskTemplate.encode(message.tasks[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a WorkflowClosure message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.core.WorkflowClosure
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.core.WorkflowClosure} WorkflowClosure
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                WorkflowClosure.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.core.WorkflowClosure();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.workflow = $root.flyteidl.core.WorkflowTemplate.decode(reader, reader.uint32());
                            break;
                        case 2:
                            if (!(message.tasks && message.tasks.length))
                                message.tasks = [];
                            message.tasks.push($root.flyteidl.core.TaskTemplate.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a WorkflowClosure message.
                 * @function verify
                 * @memberof flyteidl.core.WorkflowClosure
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                WorkflowClosure.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.workflow != null && message.hasOwnProperty("workflow")) {
                        var error = $root.flyteidl.core.WorkflowTemplate.verify(message.workflow);
                        if (error)
                            return "workflow." + error;
                    }
                    if (message.tasks != null && message.hasOwnProperty("tasks")) {
                        if (!Array.isArray(message.tasks))
                            return "tasks: array expected";
                        for (var i = 0; i < message.tasks.length; ++i) {
                            var error = $root.flyteidl.core.TaskTemplate.verify(message.tasks[i]);
                            if (error)
                                return "tasks." + error;
                        }
                    }
                    return null;
                };
    
                return WorkflowClosure;
            })();
    
            return core;
        })();
    
        flyteidl.event = (function() {
    
            /**
             * Namespace event.
             * @memberof flyteidl
             * @namespace
             */
            var event = {};
    
            event.CloudEventWorkflowExecution = (function() {
    
                /**
                 * Properties of a CloudEventWorkflowExecution.
                 * @memberof flyteidl.event
                 * @interface ICloudEventWorkflowExecution
                 * @property {flyteidl.event.IWorkflowExecutionEvent|null} [rawEvent] CloudEventWorkflowExecution rawEvent
                 * @property {flyteidl.core.ITypedInterface|null} [outputInterface] CloudEventWorkflowExecution outputInterface
                 * @property {Array.<flyteidl.core.IArtifactID>|null} [artifactIds] CloudEventWorkflowExecution artifactIds
                 * @property {flyteidl.core.IWorkflowExecutionIdentifier|null} [referenceExecution] CloudEventWorkflowExecution referenceExecution
                 * @property {string|null} [principal] CloudEventWorkflowExecution principal
                 * @property {flyteidl.core.IIdentifier|null} [launchPlanId] CloudEventWorkflowExecution launchPlanId
                 */
    
                /**
                 * Constructs a new CloudEventWorkflowExecution.
                 * @memberof flyteidl.event
                 * @classdesc Represents a CloudEventWorkflowExecution.
                 * @implements ICloudEventWorkflowExecution
                 * @constructor
                 * @param {flyteidl.event.ICloudEventWorkflowExecution=} [properties] Properties to set
                 */
                function CloudEventWorkflowExecution(properties) {
                    this.artifactIds = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * CloudEventWorkflowExecution rawEvent.
                 * @member {flyteidl.event.IWorkflowExecutionEvent|null|undefined} rawEvent
                 * @memberof flyteidl.event.CloudEventWorkflowExecution
                 * @instance
                 */
                CloudEventWorkflowExecution.prototype.rawEvent = null;
    
                /**
                 * CloudEventWorkflowExecution outputInterface.
                 * @member {flyteidl.core.ITypedInterface|null|undefined} outputInterface
                 * @memberof flyteidl.event.CloudEventWorkflowExecution
                 * @instance
                 */
                CloudEventWorkflowExecution.prototype.outputInterface = null;
    
                /**
                 * CloudEventWorkflowExecution artifactIds.
                 * @member {Array.<flyteidl.core.IArtifactID>} artifactIds
                 * @memberof flyteidl.event.CloudEventWorkflowExecution
                 * @instance
                 */
                CloudEventWorkflowExecution.prototype.artifactIds = $util.emptyArray;
    
                /**
                 * CloudEventWorkflowExecution referenceExecution.
                 * @member {flyteidl.core.IWorkflowExecutionIdentifier|null|undefined} referenceExecution
                 * @memberof flyteidl.event.CloudEventWorkflowExecution
                 * @instance
                 */
                CloudEventWorkflowExecution.prototype.referenceExecution = null;
    
                /**
                 * CloudEventWorkflowExecution principal.
                 * @member {string} principal
                 * @memberof flyteidl.event.CloudEventWorkflowExecution
                 * @instance
                 */
                CloudEventWorkflowExecution.prototype.principal = "";
    
                /**
                 * CloudEventWorkflowExecution launchPlanId.
                 * @member {flyteidl.core.IIdentifier|null|undefined} launchPlanId
                 * @memberof flyteidl.event.CloudEventWorkflowExecution
                 * @instance
                 */
                CloudEventWorkflowExecution.prototype.launchPlanId = null;
    
                /**
                 * Creates a new CloudEventWorkflowExecution instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.event.CloudEventWorkflowExecution
                 * @static
                 * @param {flyteidl.event.ICloudEventWorkflowExecution=} [properties] Properties to set
                 * @returns {flyteidl.event.CloudEventWorkflowExecution} CloudEventWorkflowExecution instance
                 */
                CloudEventWorkflowExecution.create = function create(properties) {
                    return new CloudEventWorkflowExecution(properties);
                };
    
                /**
                 * Encodes the specified CloudEventWorkflowExecution message. Does not implicitly {@link flyteidl.event.CloudEventWorkflowExecution.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.event.CloudEventWorkflowExecution
                 * @static
                 * @param {flyteidl.event.ICloudEventWorkflowExecution} message CloudEventWorkflowExecution message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                CloudEventWorkflowExecution.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.rawEvent != null && message.hasOwnProperty("rawEvent"))
                        $root.flyteidl.event.WorkflowExecutionEvent.encode(message.rawEvent, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.outputInterface != null && message.hasOwnProperty("outputInterface"))
                        $root.flyteidl.core.TypedInterface.encode(message.outputInterface, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.artifactIds != null && message.artifactIds.length)
                        for (var i = 0; i < message.artifactIds.length; ++i)
                            $root.flyteidl.core.ArtifactID.encode(message.artifactIds[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message.referenceExecution != null && message.hasOwnProperty("referenceExecution"))
                        $root.flyteidl.core.WorkflowExecutionIdentifier.encode(message.referenceExecution, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.principal != null && message.hasOwnProperty("principal"))
                        writer.uint32(/* id 5, wireType 2 =*/42).string(message.principal);
                    if (message.launchPlanId != null && message.hasOwnProperty("launchPlanId"))
                        $root.flyteidl.core.Identifier.encode(message.launchPlanId, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a CloudEventWorkflowExecution message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.event.CloudEventWorkflowExecution
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.event.CloudEventWorkflowExecution} CloudEventWorkflowExecution
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                CloudEventWorkflowExecution.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.event.CloudEventWorkflowExecution();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.rawEvent = $root.flyteidl.event.WorkflowExecutionEvent.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.outputInterface = $root.flyteidl.core.TypedInterface.decode(reader, reader.uint32());
                            break;
                        case 3:
                            if (!(message.artifactIds && message.artifactIds.length))
                                message.artifactIds = [];
                            message.artifactIds.push($root.flyteidl.core.ArtifactID.decode(reader, reader.uint32()));
                            break;
                        case 4:
                            message.referenceExecution = $root.flyteidl.core.WorkflowExecutionIdentifier.decode(reader, reader.uint32());
                            break;
                        case 5:
                            message.principal = reader.string();
                            break;
                        case 6:
                            message.launchPlanId = $root.flyteidl.core.Identifier.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };
    
                /**
                 * Verifies a CloudEventWorkflowExecution message.
                 * @function verify
                 * @memberof flyteidl.event.CloudEventWorkflowExecution
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                CloudEventWorkflowExecution.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.rawEvent != null && message.hasOwnProperty("rawEvent")) {
                        var error = $root.flyteidl.event.WorkflowExecutionEvent.verify(message.rawEvent);
                        if (error)
                            return "rawEvent." + error;
                    }
                    if (message.outputInterface != null && message.hasOwnProperty("outputInterface")) {
                        var error = $root.flyteidl.core.TypedInterface.verify(message.outputInterface);
                        if (error)
                            return "outputInterface." + error;
                    }
                    if (message.artifactIds != null && message.hasOwnProperty("artifactIds")) {
                        if (!Array.isArray(message.artifactIds))
                            return "artifactIds: array expected";
                        for (var i = 0; i < message.artifactIds.length; ++i) {
                            var error = $root.flyteidl.core.ArtifactID.verify(message.artifactIds[i]);
                            if (error)
                                return "artifactIds." + error;
                        }
                    }
                    if (message.referenceExecution != null && message.hasOwnProperty("referenceExecution")) {
                        var error = $root.flyteidl.core.WorkflowExecutionIdentifier.verify(message.referenceExecution);
                        if (error)
                            return "referenceExecution." + error;
                    }
                    if (message.principal != null && message.hasOwnProperty("principal"))
                        if (!$util.isString(message.principal))
                            return "principal: string expected";
                    if (message.launchPlanId != null && message.hasOwnProperty("launchPlanId")) {
                        var error = $root.flyteidl.core.Identifier.verify(message.launchPlanId);
                        if (error)
                            return "launchPlanId." + error;
                    }
                    return null;
                };
    
                return CloudEventWorkflowExecution;
            })();
    
            event.CloudEventNodeExecution = (function() {
    
                /**
                 * Properties of a CloudEventNodeExecution.
                 * @memberof flyteidl.event
                 * @interface ICloudEventNodeExecution
                 * @property {flyteidl.event.INodeExecutionEvent|null} [rawEvent] CloudEventNodeExecution rawEvent
                 * @property {flyteidl.core.ITaskExecutionIdentifier|null} [taskExecId] CloudEventNodeExecution taskExecId
                 * @property {flyteidl.core.ITypedInterface|null} [outputInterface] CloudEventNodeExecution outputInterface
                 * @property {Array.<flyteidl.core.IArtifactID>|null} [artifactIds] CloudEventNodeExecution artifactIds
                 * @property {string|null} [principal] CloudEventNodeExecution principal
                 * @property {flyteidl.core.IIdentifier|null} [launchPlanId] CloudEventNodeExecution launchPlanId
                 */
    
                /**
                 * Constructs a new CloudEventNodeExecution.
                 * @memberof flyteidl.event
                 * @classdesc Represents a CloudEventNodeExecution.
                 * @implements ICloudEventNodeExecution
                 * @constructor
                 * @param {flyteidl.event.ICloudEventNodeExecution=} [properties] Properties to set
                 */
                function CloudEventNodeExecution(properties) {
                    this.artifactIds = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }
    
                /**
                 * CloudEventNodeExecution rawEvent.
                 * @member {flyteidl.event.INodeExecutionEvent|null|undefined} rawEvent
                 * @memberof flyteidl.event.CloudEventNodeExecution
                 * @instance
                 */
                CloudEventNodeExecution.prototype.rawEvent = null;
    
                /**
                 * CloudEventNodeExecution taskExecId.
                 * @member {flyteidl.core.ITaskExecutionIdentifier|null|undefined} taskExecId
                 * @memberof flyteidl.event.CloudEventNodeExecution
                 * @instance
                 */
                CloudEventNodeExecution.prototype.taskExecId = null;
    
                /**
                 * CloudEventNodeExecution outputInterface.
                 * @member {flyteidl.core.ITypedInterface|null|undefined} outputInterface
                 * @memberof flyteidl.event.CloudEventNodeExecution
                 * @instance
                 */
                CloudEventNodeExecution.prototype.outputInterface = null;
    
                /**
                 * CloudEventNodeExecution artifactIds.
                 * @member {Array.<flyteidl.core.IArtifactID>} artifactIds
                 * @memberof flyteidl.event.CloudEventNodeExecution
                 * @instance
                 */
                CloudEventNodeExecution.prototype.artifactIds = $util.emptyArray;
    
                /**
                 * CloudEventNodeExecution principal.
                 * @member {string} principal
                 * @memberof flyteidl.event.CloudEventNodeExecution
                 * @instance
                 */
                CloudEventNodeExecution.prototype.principal = "";
    
                /**
                 * CloudEventNodeExecution launchPlanId.
                 * @member {flyteidl.core.IIdentifier|null|undefined} launchPlanId
                 * @memberof flyteidl.event.CloudEventNodeExecution
                 * @instance
                 */
                CloudEventNodeExecution.prototype.launchPlanId = null;
    
                /**
                 * Creates a new CloudEventNodeExecution instance using the specified properties.
                 * @function create
                 * @memberof flyteidl.event.CloudEventNodeExecution
                 * @static
                 * @param {flyteidl.event.ICloudEventNodeExecution=} [properties] Properties to set
                 * @returns {flyteidl.event.CloudEventNodeExecution} CloudEventNodeExecution instance
                 */
                CloudEventNodeExecution.create = function create(properties) {
                    return new CloudEventNodeExecution(properties);
                };
    
                /**
                 * Encodes the specified CloudEventNodeExecution message. Does not implicitly {@link flyteidl.event.CloudEventNodeExecution.verify|verify} messages.
                 * @function encode
                 * @memberof flyteidl.event.CloudEventNodeExecution
                 * @static
                 * @param {flyteidl.event.ICloudEventNodeExecution} message CloudEventNodeExecution message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                CloudEventNodeExecution.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.rawEvent != null && message.hasOwnProperty("rawEvent"))
                        $root.flyteidl.event.NodeExecutionEvent.encode(message.rawEvent, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.taskExecId != null && message.hasOwnProperty("taskExecId"))
                        $root.flyteidl.core.TaskExecutionIdentifier.encode(message.taskExecId, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.outputInterface != null && message.hasOwnProperty("outputInterface"))
                        $root.flyteidl.core.TypedInterface.encode(message.outputInterface, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message.artifactIds != null && message.artifactIds.length)
                        for (var i = 0; i < message.artifactIds.length; ++i)
                            $root.flyteidl.core.ArtifactID.encode(message.artifactIds[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.principal != null && message.hasOwnProperty("principal"))
                        writer.uint32(/* id 5, wireType 2 =*/42).string(message.principal);
                    if (message.launchPlanId != null && message.hasOwnProperty("launchPlanId"))
                        $root.flyteidl.core.Identifier.encode(message.launchPlanId, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                    return writer;
                };
    
                /**
                 * Decodes a CloudEventNodeExecution message from the specified reader or buffer.
                 * @function decode
                 * @memberof flyteidl.event.CloudEventNodeExecution
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {flyteidl.event.CloudEventNodeExecution} CloudEventNodeExecution
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                CloudEventNodeExecution.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.flyteidl.event.CloudEventNodeExecution();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.rawEvent = $root.flyteidl.event.NodeExecutionEvent.decode(reader, reader.uint32());
                            break;
                        case 2:
                            message.taskExecId = $root.flyteidl.core.TaskExecutionIdentifier.decode(reader, reader.uint32());
                            break;
                        case 3:
                            message.outputInterface = $root.flyteidl.core.TypedInterface.decode(reader, reader.uint32());
                            break;
                        case 4:
                            if (!(message.artifactIds && message.artifactIds.length))
                                message.artifactIds = [];
                            message.artifactIds.push($root.flyteidl.core.ArtifactID.decode(reader, reader.uint32()));
                            break;
                        case 5:
                            message.principal = reader.string();
             