// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             (unknown)
// source: flyteidl/datacatalog/datacatalog.proto

package datacatalog

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DataCatalog_CreateDataset_FullMethodName          = "/datacatalog.DataCatalog/CreateDataset"
	DataCatalog_GetDataset_FullMethodName             = "/datacatalog.DataCatalog/GetDataset"
	DataCatalog_CreateArtifact_FullMethodName         = "/datacatalog.DataCatalog/CreateArtifact"
	DataCatalog_GetArtifact_FullMethodName            = "/datacatalog.DataCatalog/GetArtifact"
	DataCatalog_AddTag_FullMethodName                 = "/datacatalog.DataCatalog/AddTag"
	DataCatalog_ListArtifacts_FullMethodName          = "/datacatalog.DataCatalog/ListArtifacts"
	DataCatalog_ListDatasets_FullMethodName           = "/datacatalog.DataCatalog/ListDatasets"
	DataCatalog_UpdateArtifact_FullMethodName         = "/datacatalog.DataCatalog/UpdateArtifact"
	DataCatalog_GetOrExtendReservation_FullMethodName = "/datacatalog.DataCatalog/GetOrExtendReservation"
	DataCatalog_ReleaseReservation_FullMethodName     = "/datacatalog.DataCatalog/ReleaseReservation"
)

// DataCatalogClient is the client API for DataCatalog service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DataCatalogClient interface {
	// Create a new Dataset. Datasets are unique based on the DatasetID. Datasets are logical groupings of artifacts.
	// Each dataset can have one or more artifacts
	CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*CreateDatasetResponse, error)
	// Get a Dataset by the DatasetID. This returns the Dataset with the associated metadata.
	GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*GetDatasetResponse, error)
	// Create an artifact and the artifact data associated with it. An artifact can be a hive partition or arbitrary
	// files or data values
	CreateArtifact(ctx context.Context, in *CreateArtifactRequest, opts ...grpc.CallOption) (*CreateArtifactResponse, error)
	// Retrieve an artifact by an identifying handle. This returns an artifact along with the artifact data.
	GetArtifact(ctx context.Context, in *GetArtifactRequest, opts ...grpc.CallOption) (*GetArtifactResponse, error)
	// Associate a tag with an artifact. Tags are unique within a Dataset.
	AddTag(ctx context.Context, in *AddTagRequest, opts ...grpc.CallOption) (*AddTagResponse, error)
	// Return a paginated list of artifacts
	ListArtifacts(ctx context.Context, in *ListArtifactsRequest, opts ...grpc.CallOption) (*ListArtifactsResponse, error)
	// Return a paginated list of datasets
	ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error)
	// Updates an existing artifact, overwriting the stored artifact data in the underlying blob storage.
	UpdateArtifact(ctx context.Context, in *UpdateArtifactRequest, opts ...grpc.CallOption) (*UpdateArtifactResponse, error)
	// Attempts to get or extend a reservation for the corresponding artifact. If one already exists
	// (ie. another entity owns the reservation) then that reservation is retrieved.
	// Once you acquire a reservation, you need to  periodically extend the reservation with an
	// identical call. If the reservation is not extended before the defined expiration, it may be
	// acquired by another task.
	// Note: We may have multiple concurrent tasks with the same signature and the same input that
	// try to populate the same artifact at the same time. Thus with reservation, only one task can
	// run at a time, until the reservation expires.
	// Note: If task A does not extend the reservation in time and the reservation expires, another
	// task B may take over the reservation, resulting in two tasks A and B running in parallel. So
	// a third task C may get the Artifact from A or B, whichever writes last.
	GetOrExtendReservation(ctx context.Context, in *GetOrExtendReservationRequest, opts ...grpc.CallOption) (*GetOrExtendReservationResponse, error)
	// Release the reservation when the task holding the spot fails so that the other tasks
	// can grab the spot.
	ReleaseReservation(ctx context.Context, in *ReleaseReservationRequest, opts ...grpc.CallOption) (*ReleaseReservationResponse, error)
}

type dataCatalogClient struct {
	cc grpc.ClientConnInterface
}

func NewDataCatalogClient(cc grpc.ClientConnInterface) DataCatalogClient {
	return &dataCatalogClient{cc}
}

func (c *dataCatalogClient) CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*CreateDatasetResponse, error) {
	out := new(CreateDatasetResponse)
	err := c.cc.Invoke(ctx, DataCatalog_CreateDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*GetDatasetResponse, error) {
	out := new(GetDatasetResponse)
	err := c.cc.Invoke(ctx, DataCatalog_GetDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) CreateArtifact(ctx context.Context, in *CreateArtifactRequest, opts ...grpc.CallOption) (*CreateArtifactResponse, error) {
	out := new(CreateArtifactResponse)
	err := c.cc.Invoke(ctx, DataCatalog_CreateArtifact_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetArtifact(ctx context.Context, in *GetArtifactRequest, opts ...grpc.CallOption) (*GetArtifactResponse, error) {
	out := new(GetArtifactResponse)
	err := c.cc.Invoke(ctx, DataCatalog_GetArtifact_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) AddTag(ctx context.Context, in *AddTagRequest, opts ...grpc.CallOption) (*AddTagResponse, error) {
	out := new(AddTagResponse)
	err := c.cc.Invoke(ctx, DataCatalog_AddTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) ListArtifacts(ctx context.Context, in *ListArtifactsRequest, opts ...grpc.CallOption) (*ListArtifactsResponse, error) {
	out := new(ListArtifactsResponse)
	err := c.cc.Invoke(ctx, DataCatalog_ListArtifacts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error) {
	out := new(ListDatasetsResponse)
	err := c.cc.Invoke(ctx, DataCatalog_ListDatasets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) UpdateArtifact(ctx context.Context, in *UpdateArtifactRequest, opts ...grpc.CallOption) (*UpdateArtifactResponse, error) {
	out := new(UpdateArtifactResponse)
	err := c.cc.Invoke(ctx, DataCatalog_UpdateArtifact_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) GetOrExtendReservation(ctx context.Context, in *GetOrExtendReservationRequest, opts ...grpc.CallOption) (*GetOrExtendReservationResponse, error) {
	out := new(GetOrExtendReservationResponse)
	err := c.cc.Invoke(ctx, DataCatalog_GetOrExtendReservation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataCatalogClient) ReleaseReservation(ctx context.Context, in *ReleaseReservationRequest, opts ...grpc.CallOption) (*ReleaseReservationResponse, error) {
	out := new(ReleaseReservationResponse)
	err := c.cc.Invoke(ctx, DataCatalog_ReleaseReservation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataCatalogServer is the server API for DataCatalog service.
// All implementations should embed UnimplementedDataCatalogServer
// for forward compatibility
type DataCatalogServer interface {
	// Create a new Dataset. Datasets are unique based on the DatasetID. Datasets are logical groupings of artifacts.
	// Each dataset can have one or more artifacts
	CreateDataset(context.Context, *CreateDatasetRequest) (*CreateDatasetResponse, error)
	// Get a Dataset by the DatasetID. This returns the Dataset with the associated metadata.
	GetDataset(context.Context, *GetDatasetRequest) (*GetDatasetResponse, error)
	// Create an artifact and the artifact data associated with it. An artifact can be a hive partition or arbitrary
	// files or data values
	CreateArtifact(context.Context, *CreateArtifactRequest) (*CreateArtifactResponse, error)
	// Retrieve an artifact by an identifying handle. This returns an artifact along with the artifact data.
	GetArtifact(context.Context, *GetArtifactRequest) (*GetArtifactResponse, error)
	// Associate a tag with an artifact. Tags are unique within a Dataset.
	AddTag(context.Context, *AddTagRequest) (*AddTagResponse, error)
	// Return a paginated list of artifacts
	ListArtifacts(context.Context, *ListArtifactsRequest) (*ListArtifactsResponse, error)
	// Return a paginated list of datasets
	ListDatasets(context.Context, *ListDatasetsRequest) (*ListDatasetsResponse, error)
	// Updates an existing artifact, overwriting the stored artifact data in the underlying blob storage.
	UpdateArtifact(context.Context, *UpdateArtifactRequest) (*UpdateArtifactResponse, error)
	// Attempts to get or extend a reservation for the corresponding artifact. If one already exists
	// (ie. another entity owns the reservation) then that reservation is retrieved.
	// Once you acquire a reservation, you need to  periodically extend the reservation with an
	// identical call. If the reservation is not extended before the defined expiration, it may be
	// acquired by another task.
	// Note: We may have multiple concurrent tasks with the same signature and the same input that
	// try to populate the same artifact at the same time. Thus with reservation, only one task can
	// run at a time, until the reservation expires.
	// Note: If task A does not extend the reservation in time and the reservation expires, another
	// task B may take over the reservation, resulting in two tasks A and B running in parallel. So
	// a third task C may get the Artifact from A or B, whichever writes last.
	GetOrExtendReservation(context.Context, *GetOrExtendReservationRequest) (*GetOrExtendReservationResponse, error)
	// Release the reservation when the task holding the spot fails so that the other tasks
	// can grab the spot.
	ReleaseReservation(context.Context, *ReleaseReservationRequest) (*ReleaseReservationResponse, error)
}

// UnimplementedDataCatalogServer should be embedded to have forward compatible implementations.
type UnimplementedDataCatalogServer struct {
}

func (UnimplementedDataCatalogServer) CreateDataset(context.Context, *CreateDatasetRequest) (*CreateDatasetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataset not implemented")
}
func (UnimplementedDataCatalogServer) GetDataset(context.Context, *GetDatasetRequest) (*GetDatasetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataset not implemented")
}
func (UnimplementedDataCatalogServer) CreateArtifact(context.Context, *CreateArtifactRequest) (*CreateArtifactResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateArtifact not implemented")
}
func (UnimplementedDataCatalogServer) GetArtifact(context.Context, *GetArtifactRequest) (*GetArtifactResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetArtifact not implemented")
}
func (UnimplementedDataCatalogServer) AddTag(context.Context, *AddTagRequest) (*AddTagResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddTag not implemented")
}
func (UnimplementedDataCatalogServer) ListArtifacts(context.Context, *ListArtifactsRequest) (*ListArtifactsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListArtifacts not implemented")
}
func (UnimplementedDataCatalogServer) ListDatasets(context.Context, *ListDatasetsRequest) (*ListDatasetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDatasets not implemented")
}
func (UnimplementedDataCatalogServer) UpdateArtifact(context.Context, *UpdateArtifactRequest) (*UpdateArtifactResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateArtifact not implemented")
}
func (UnimplementedDataCatalogServer) GetOrExtendReservation(context.Context, *GetOrExtendReservationRequest) (*GetOrExtendReservationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOrExtendReservation not implemented")
}
func (UnimplementedDataCatalogServer) ReleaseReservation(context.Context, *ReleaseReservationRequest) (*ReleaseReservationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReleaseReservation not implemented")
}

// UnsafeDataCatalogServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DataCatalogServer will
// result in compilation errors.
type UnsafeDataCatalogServer interface {
	mustEmbedUnimplementedDataCatalogServer()
}

func RegisterDataCatalogServer(s grpc.ServiceRegistrar, srv DataCatalogServer) {
	s.RegisterService(&DataCatalog_ServiceDesc, srv)
}

func _DataCatalog_CreateDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_CreateDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateDataset(ctx, req.(*CreateDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_GetDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetDataset(ctx, req.(*GetDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_CreateArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).CreateArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_CreateArtifact_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).CreateArtifact(ctx, req.(*CreateArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_GetArtifact_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetArtifact(ctx, req.(*GetArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_AddTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).AddTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_AddTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).AddTag(ctx, req.(*AddTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ListArtifacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListArtifactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ListArtifacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_ListArtifacts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ListArtifacts(ctx, req.(*ListArtifactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ListDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ListDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_ListDatasets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ListDatasets(ctx, req.(*ListDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_UpdateArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).UpdateArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_UpdateArtifact_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).UpdateArtifact(ctx, req.(*UpdateArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_GetOrExtendReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOrExtendReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).GetOrExtendReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_GetOrExtendReservation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).GetOrExtendReservation(ctx, req.(*GetOrExtendReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataCatalog_ReleaseReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReleaseReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataCatalogServer).ReleaseReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataCatalog_ReleaseReservation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataCatalogServer).ReleaseReservation(ctx, req.(*ReleaseReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DataCatalog_ServiceDesc is the grpc.ServiceDesc for DataCatalog service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DataCatalog_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "datacatalog.DataCatalog",
	HandlerType: (*DataCatalogServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDataset",
			Handler:    _DataCatalog_CreateDataset_Handler,
		},
		{
			MethodName: "GetDataset",
			Handler:    _DataCatalog_GetDataset_Handler,
		},
		{
			MethodName: "CreateArtifact",
			Handler:    _DataCatalog_CreateArtifact_Handler,
		},
		{
			MethodName: "GetArtifact",
			Handler:    _DataCatalog_GetArtifact_Handler,
		},
		{
			MethodName: "AddTag",
			Handler:    _DataCatalog_AddTag_Handler,
		},
		{
			MethodName: "ListArtifacts",
			Handler:    _DataCatalog_ListArtifacts_Handler,
		},
		{
			MethodName: "ListDatasets",
			Handler:    _DataCatalog_ListDatasets_Handler,
		},
		{
			MethodName: "UpdateArtifact",
			Handler:    _DataCatalog_UpdateArtifact_Handler,
		},
		{
			MethodName: "GetOrExtendReservation",
			Handler:    _DataCatalog_GetOrExtendReservation_Handler,
		},
		{
			MethodName: "ReleaseReservation",
			Handler:    _DataCatalog_ReleaseReservation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "flyteidl/datacatalog/datacatalog.proto",
}
