// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        (unknown)
// source: flyteidl/core/workflow.proto

package core

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type ArrayNode_ExecutionMode int32

const (
	// Indicates the ArrayNode will store minimal state for the sub-nodes.
	// This is more efficient, but only supports a subset of Flyte entities.
	ArrayNode_MINIMAL_STATE ArrayNode_ExecutionMode = 0
	// Indicates the ArrayNode will store full state for the sub-nodes.
	// This supports a wider range of Flyte entities.
	ArrayNode_FULL_STATE ArrayNode_ExecutionMode = 1
)

// Enum value maps for ArrayNode_ExecutionMode.
var (
	ArrayNode_ExecutionMode_name = map[int32]string{
		0: "MINIMAL_STATE",
		1: "FULL_STATE",
	}
	ArrayNode_ExecutionMode_value = map[string]int32{
		"MINIMAL_STATE": 0,
		"FULL_STATE":    1,
	}
)

func (x ArrayNode_ExecutionMode) Enum() *ArrayNode_ExecutionMode {
	p := new(ArrayNode_ExecutionMode)
	*p = x
	return p
}

func (x ArrayNode_ExecutionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ArrayNode_ExecutionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_flyteidl_core_workflow_proto_enumTypes[0].Descriptor()
}

func (ArrayNode_ExecutionMode) Type() protoreflect.EnumType {
	return &file_flyteidl_core_workflow_proto_enumTypes[0]
}

func (x ArrayNode_ExecutionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ArrayNode_ExecutionMode.Descriptor instead.
func (ArrayNode_ExecutionMode) EnumDescriptor() ([]byte, []int) {
	return file_flyteidl_core_workflow_proto_rawDescGZIP(), []int{9, 0}
}

// Failure Handling Strategy
type WorkflowMetadata_OnFailurePolicy int32

const (
	// FAIL_IMMEDIATELY instructs the system to fail as soon as a node fails in the workflow. It'll automatically
	// abort all currently running nodes and clean up resources before finally marking the workflow executions as
	// failed.
	WorkflowMetadata_FAIL_IMMEDIATELY WorkflowMetadata_OnFailurePolicy = 0
	// FAIL_AFTER_EXECUTABLE_NODES_COMPLETE instructs the system to make as much progress as it can. The system will
	// not alter the dependencies of the execution graph so any node that depend on the failed node will not be run.
	// Other nodes that will be executed to completion before cleaning up resources and marking the workflow
	// execution as failed.
	WorkflowMetadata_FAIL_AFTER_EXECUTABLE_NODES_COMPLETE WorkflowMetadata_OnFailurePolicy = 1
)

// Enum value maps for WorkflowMetadata_OnFailurePolicy.
var (
	WorkflowMetadata_OnFailurePolicy_name = map[int32]string{
		0: "FAIL_IMMEDIATELY",
		1: "FAIL_AFTER_EXECUTABLE_NODES_COMPLETE",
	}
	WorkflowMetadata_OnFailurePolicy_value = map[string]int32{
		"FAIL_IMMEDIATELY":                     0,
		"FAIL_AFTER_EXECUTABLE_NODES_COMPLETE": 1,
	}
)

func (x WorkflowMetadata_OnFailurePolicy) Enum() *WorkflowMetadata_OnFailurePolicy {
	p := new(WorkflowMetadata_OnFailurePolicy)
	*p = x
	return p
}

func (x WorkflowMetadata_OnFailurePolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WorkflowMetadata_OnFailurePolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_flyteidl_core_workflow_proto_enumTypes[1].Descriptor()
}

func (WorkflowMetadata_OnFailurePolicy) Type() protoreflect.EnumType {
	return &file_flyteidl_core_workflow_proto_enumTypes[1]
}

func (x WorkflowMetadata_OnFailurePolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WorkflowMetadata_OnFailurePolicy.Descriptor instead.
func (WorkflowMetadata_OnFailurePolicy) EnumDescriptor() ([]byte, []int) {
	return file_flyteidl_core_workflow_proto_rawDescGZIP(), []int{13, 0}
}

// Defines a condition and the execution unit that should be executed if the condition is satisfied.
type IfBlock struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Condition *BooleanExpression `protobuf:"bytes,1,opt,name=condition,proto3" json:"condition,omitempty"`
	ThenNode  *Node              `protobuf:"bytes,2,opt,name=then_node,json=thenNode,proto3" json:"then_node,omitempty"`
}

func (x *IfBlock) Reset() {
	*x = IfBlock{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_core_workflow_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IfBlock) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IfBlock) ProtoMessage() {}

func (x *IfBlock) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_core_workflow_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IfBlock.ProtoReflect.Descriptor instead.
func (*IfBlock) Descriptor() ([]byte, []int) {
	return file_flyteidl_core_workflow_proto_rawDescGZIP(), []int{0}
}

func (x *IfBlock) GetCondition() *BooleanExpression {
	if x != nil {
		return x.Condition
	}
	return nil
}

func (x *IfBlock) GetThenNode() *Node {
	if x != nil {
		return x.ThenNode
	}
	return nil
}

// Defines a series of if/else blocks. The first branch whose condition evaluates to true is the one to execute.
// If no conditions were satisfied, the else_node or the error will execute.
type IfElseBlock struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// +required. First condition to evaluate.
	Case *IfBlock `protobuf:"bytes,1,opt,name=case,proto3" json:"case,omitempty"`
	// +optional. Additional branches to evaluate.
	Other []*IfBlock `protobuf:"bytes,2,rep,name=other,proto3" json:"other,omitempty"`
	// +required.
	//
	// Types that are assignable to Default:
	//
	//	*IfElseBlock_ElseNode
	//	*IfElseBlock_Error
	Default isIfElseBlock_Default `protobuf_oneof:"default"`
}

func (x *IfElseBlock) Reset() {
	*x = IfElseBlock{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_core_workflow_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IfElseBlock) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IfElseBlock) ProtoMessage() {}

func (x *IfElseBlock) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_core_workflow_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IfElseBlock.ProtoReflect.Descriptor instead.
func (*IfElseBlock) Descriptor() ([]byte, []int) {
	return file_flyteidl_core_workflow_proto_rawDescGZIP(), []int{1}
}

func (x *IfElseBlock) GetCase() *IfBlock {
	if x != nil {
		return x.Case
	}
	return nil
}

func (x *IfElseBlock) GetOther() []*IfBlock {
	if x != nil {
		return x.Other
	}
	return nil
}

func (m *IfElseBlock) GetDefault() isIfElseBlock_Default {
	if m != nil {
		return m.Default
	}
	return nil
}

func (x *IfElseBlock) GetElseNode() *Node {
	if x, ok := x.GetDefault().(*IfElseBlock_ElseNode); ok {
		return x.ElseNode
	}
	return nil
}

func (x *IfElseBlock) GetError() *Error {
	if x, ok := x.GetDefault().(*IfElseBlock_Error); ok {
		return x.Error
	}
	return nil
}

type isIfElseBlock_Default interface {
	isIfElseBlock_Default()
}

type IfElseBlock_ElseNode struct {
	// The node to execute in case none of the branches were taken.
	ElseNode *Node `protobuf:"bytes,3,opt,name=else_node,json=elseNode,proto3,oneof"`
}

type IfElseBlock_Error struct {
	// An error to throw in case none of the branches were taken.
	Error *Error `protobuf:"bytes,4,opt,name=error,proto3,oneof"`
}

func (*IfElseBlock_ElseNode) isIfElseBlock_Default() {}

func (*IfElseBlock_Error) isIfElseBlock_Default() {}

// BranchNode is a special node that alter the flow of the workflow graph. It allows the control flow to branch at
// runtime based on a series of conditions that get evaluated on various parameters (e.g. inputs, primitives).
type BranchNode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// +required
	IfElse *IfElseBlock `protobuf:"bytes,1,opt,name=if_else,json=ifElse,proto3" json:"if_else,omitempty"`
}

func (x *BranchNode) Reset() {
	*x = BranchNode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_core_workflow_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BranchNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BranchNode) ProtoMessage() {}

func (x *BranchNode) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_core_workflow_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BranchNode.ProtoReflect.Descriptor instead.
func (*BranchNode) Descriptor() ([]byte, []int) {
	return file_flyteidl_core_workflow_proto_rawDescGZIP(), []int{2}
}

func (x *BranchNode) GetIfElse() *IfElseBlock {
	if x != nil {
		return x.IfElse
	}
	return nil
}

// Refers to the task that the Node is to execute.
type TaskNode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Reference:
	//
	//	*TaskNode_ReferenceId
	Reference isTaskNode_Reference `protobuf_oneof:"reference"`
	// Optional overrides applied at task execution time.
	Overrides *TaskNodeOverrides `protobuf:"bytes,2,opt,name=overrides,proto3" json:"overrides,omitempty"`
}

func (x *TaskNode) Reset() {
	*x = TaskNode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_core_workflow_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TaskNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaskNode) ProtoMessage() {}

func (x *TaskNode) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_core_workflow_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaskNode.ProtoReflect.Descriptor instead.
func (*TaskNode) Descriptor() ([]byte, []int) {
	return file_flyteidl_core_workflow_proto_rawDescGZIP(), []int{3}
}

func (m *TaskNode) GetReference() isTaskNode_Reference {
	if m != nil {
		return m.Reference
	}
	return nil
}

func (x *TaskNode) GetReferenceId() *Identifier {
	if x, ok := x.GetReference().(*TaskNode_ReferenceId); ok {
		return x.ReferenceId
	}
	return nil
}

func (x *TaskNode) GetOverrides() *TaskNodeOverrides {
	if x != nil {
		return x.Overrides
	}
	return nil
}

type isTaskNode_Reference interface {
	isTaskNode_Reference()
}

type TaskNode_ReferenceId struct {
	// A globally unique identifier for the task.
	ReferenceId *Identifier `protobuf:"bytes,1,opt,name=reference_id,json=referenceId,proto3,oneof"`
}

func (*TaskNode_ReferenceId) isTaskNode_Reference() {}

// Refers to a the workflow the node is to execute.
type WorkflowNode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Reference:
	//
	//	*WorkflowNode_LaunchplanRef
	//	*WorkflowNode_SubWorkflowRef
	Reference isWorkflowNode_Reference `protobuf_oneof:"reference"`
}

func (x *WorkflowNode) Reset() {
	*x = WorkflowNode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_core_workflow_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkflowNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkflowNode) ProtoMessage() {}

func (x *WorkflowNode) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_core_workflow_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkflowNode.ProtoReflect.Descriptor instead.
func (*WorkflowNode) Descriptor() ([]byte, []int) {
	return file_flyteidl_core_workflow_proto_rawDescGZIP(), []int{4}
}

func (m *WorkflowNode) GetReference() isWorkflowNode_Reference {
	if m != nil {
		return m.Reference
	}
	return nil
}

func (x *WorkflowNode) GetLaunchplanRef() *Identifier {
	if x, ok := x.GetReference().(*WorkflowNode_LaunchplanRef); ok {
		return x.LaunchplanRef
	}
	return nil
}

func (x *WorkflowNode) GetSubWorkflowRef() *Identifier {
	if x, ok := x.GetReference().(*WorkflowNode_SubWorkflowRef); ok {
		return x.SubWorkflowRef
	}
	return nil
}

type isWorkflowNode_Reference interface {
	isWorkflowNode_Reference()
}

type WorkflowNode_LaunchplanRef struct {
	// A globally unique identifier for the launch plan.
	LaunchplanRef *Identifier `protobuf:"bytes,1,opt,name=launchplan_ref,json=launchplanRef,proto3,oneof"`
}

type WorkflowNode_SubWorkflowRef struct {
	// Reference to a subworkflow, that should be defined with the compiler context
	SubWorkflowRef *Identifier `protobuf:"bytes,2,opt,name=sub_workflow_ref,json=subWorkflowRef,proto3,oneof"`
}

func (*WorkflowNode_LaunchplanRef) isWorkflowNode_Reference() {}

func (*WorkflowNode_SubWorkflowRef) isWorkflowNode_Reference() {}

// ApproveCondition represents a dependency on an external approval. During execution, this will manifest as a boolean
// signal with the provided signal_id.
type ApproveCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier for the requested boolean signal.
	SignalId string `protobuf:"bytes,1,opt,name=signal_id,json=signalId,proto3" json:"signal_id,omitempty"`
}

func (x *ApproveCondition) Reset() {
	*x = ApproveCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_core_workflow_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApproveCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApproveCondition) ProtoMessage() {}

func (x *ApproveCondition) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_core_workflow_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApproveCondition.ProtoReflect.Descriptor instead.
func (*ApproveCondition) Descriptor() ([]byte, []int) {
	return file_flyteidl_core_workflow_proto_rawDescGZIP(), []int{5}
}

func (x *ApproveCondition) GetSignalId() string {
	if x != nil {
		return x.SignalId
	}
	return ""
}

// SignalCondition represents a dependency on an signal.
type SignalCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier for the requested signal.
	SignalId string `protobuf:"bytes,1,opt,name=signal_id,json=signalId,proto3" json:"signal_id,omitempty"`
	// A type denoting the required value type for this signal.
	Type *LiteralType `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// The variable name for the signal value in this nodes outputs.
	OutputVariableName string `protobuf:"bytes,3,opt,name=output_variable_name,json=outputVariableName,proto3" json:"output_variable_name,omitempty"`
}

func (x *SignalCondition) Reset() {
	*x = SignalCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_core_workflow_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SignalCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SignalCondition) ProtoMessage() {}

func (x *SignalCondition) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_core_workflow_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SignalCondition.ProtoReflect.Descriptor instead.
func (*SignalCondition) Descriptor() ([]byte, []int) {
	return file_flyteidl_core_workflow_proto_rawDescGZIP(), []int{6}
}

func (x *SignalCondition) GetSignalId() string {
	if x != nil {
		return x.SignalId
	}
	return ""
}

func (x *SignalCondition) GetType() *LiteralType {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *SignalCondition) GetOutputVariableName() string {
	if x != nil {
		return x.OutputVariableName
	}
	return ""
}

// SleepCondition represents a dependency on waiting for the specified duration.
type SleepCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The overall duration for this sleep.
	Duration *durationpb.Duration `protobuf:"bytes,1,opt,name=duration,proto3" json:"duration,omitempty"`
}

func (x *SleepCondition) Reset() {
	*x = SleepCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_core_workflow_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SleepCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SleepCondition) ProtoMessage() {}

func (x *SleepCondition) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_core_workflow_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SleepCondition.ProtoReflect.Descriptor instead.
func (*SleepCondition) Descriptor() ([]byte, []int) {
	return file_flyteidl_core_workflow_proto_rawDescGZIP(), []int{7}
}

func (x *SleepCondition) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

// GateNode refers to the condition that is required for the gate to successfully complete.
type GateNode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Condition:
	//
	//	*GateNode_Approve
	//	*GateNode_Signal
	//	*GateNode_Sleep
	Condition isGateNode_Condition `protobuf_oneof:"condition"`
}

func (x *GateNode) Reset() {
	*x = GateNode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_core_workflow_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GateNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GateNode) ProtoMessage() {}

func (x *GateNode) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_core_workflow_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GateNode.ProtoReflect.Descriptor instead.
func (*GateNode) Descriptor() ([]byte, []int) {
	return file_flyteidl_core_workflow_proto_rawDescGZIP(), []int{8}
}

func (m *GateNode) GetCondition() isGateNode_Condition {
	if m != nil {
		return m.Condition
	}
	return nil
}

func (x *GateNode) GetApprove() *ApproveCondition {
	if x, ok := x.GetCondition().(*GateNode_Approve); ok {
		return x.Approve
	}
	return nil
}

func (x *GateNode) GetSignal() *SignalCondition {
	if x, ok := x.GetCondition().(*GateNode_Signal); ok {
		return x.Signal
	}
	return nil
}

func (x *GateNode) GetSleep() *SleepCondition {
	if x, ok := x.GetCondition().(*GateNode_Sleep); ok {
		return x.Sleep
	}
	return nil
}

type isGateNode_Condition interface {
	isGateNode_Condition()
}

type GateNode_Approve struct {
	// ApproveCondition represents a dependency on an external approval provided by a boolean signal.
	Approve *ApproveCondition `protobuf:"bytes,1,opt,name=approve,proto3,oneof"`
}

type GateNode_Signal struct {
	// SignalCondition represents a dependency on an signal.
	Signal *SignalCondition `protobuf:"bytes,2,opt,name=signal,proto3,oneof"`
}

type GateNode_Sleep struct {
	// SleepCondition represents a dependency on waiting for the specified duration.
	Sleep *SleepCondition `protobuf:"bytes,3,opt,name=sleep,proto3,oneof"`
}

func (*GateNode_Approve) isGateNode_Condition() {}

func (*GateNode_Signal) isGateNode_Condition() {}

func (*GateNode_Sleep) isGateNode_Condition() {}

// ArrayNode is a Flyte node type that simplifies the execution of a sub-node over a list of input
// values. An ArrayNode can be executed with configurable parallelism (separate from the parent
// workflow) and can be configured to succeed when a certain number of sub-nodes succeed.
type ArrayNode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// node is the sub-node that will be executed for each element in the array.
	Node *Node `protobuf:"bytes,1,opt,name=node,proto3" json:"node,omitempty"`
	// Types that are assignable to ParallelismOption:
	//
	//	*ArrayNode_Parallelism
	ParallelismOption isArrayNode_ParallelismOption `protobuf_oneof:"parallelism_option"`
	// Types that are assignable to SuccessCriteria:
	//
	//	*ArrayNode_MinSuccesses
	//	*ArrayNode_MinSuccessRatio
	SuccessCriteria isArrayNode_SuccessCriteria `protobuf_oneof:"success_criteria"`
	// execution_mode determines the execution path for ArrayNode.
	ExecutionMode ArrayNode_ExecutionMode `protobuf:"varint,5,opt,name=execution_mode,json=executionMode,proto3,enum=flyteidl.core.ArrayNode_ExecutionMode" json:"execution_mode,omitempty"`
	// Indicates whether the sub node's original interface was altered
	IsOriginalSubNodeInterface *wrapperspb.BoolValue `protobuf:"bytes,6,opt,name=is_original_sub_node_interface,json=isOriginalSubNodeInterface,proto3" json:"is_original_sub_node_interface,omitempty"`
}

func (x *ArrayNode) Reset() {
	*x = ArrayNode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_core_workflow_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArrayNode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArrayNode) ProtoMessage() {}

func (x *ArrayNode) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_core_workflow_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArrayNode.ProtoReflect.Descriptor instead.
func (*ArrayNode) Descriptor() ([]byte, []int) {
	return file_flyteidl_core_workflow_proto_rawDescGZIP(), []int{9}
}

func (x *ArrayNode) GetNode() *Node {
	if x != nil {
		return x.Node
	}
	return nil
}

func (m *ArrayNode) GetParallelismOption() isArrayNode_ParallelismOption {
	if m != nil {
		return m.ParallelismOption
	}
	return nil
}

func (x *ArrayNode) GetParallelism() uint32 {
	if x, ok := x.GetParallelismOption().(*ArrayNode_Parallelism); ok {
		return x.Parallelism
	}
	return 0
}

func (m *ArrayNode) GetSuccessCriteria() isArrayNode_SuccessCriteria {
	if m != nil {
		return m.SuccessCriteria
	}
	return nil
}

func (x *ArrayNode) GetMinSuccesses() uint32 {
	if x, ok := x.GetSuccessCriteria().(*ArrayNode_MinSuccesses); ok {
		return x.MinSuccesses
	}
	return 0
}

func (x *ArrayNode) GetMinSuccessRatio() float32 {
	if x, ok := x.GetSuccessCriteria().(*ArrayNode_MinSuccessRatio); ok {
		return x.MinSuccessRatio
	}
	return 0
}

func (x *ArrayNode) GetExecutionMode() ArrayNode_ExecutionMode {
	if x != nil {
		return x.ExecutionMode
	}
	return ArrayNode_MINIMAL_STATE
}

func (x *ArrayNode) GetIsOriginalSubNodeInterface() *wrapperspb.BoolValue {
	if x != nil {
		return x.IsOriginalSubNodeInterface
	}
	return nil
}

type isArrayNode_ParallelismOption interface {
	isArrayNode_ParallelismOption()
}

type ArrayNode_Parallelism struct {
	// parallelism defines the minimum number of instances to bring up concurrently at any given
	// point. Note that this is an optimistic restriction and that, due to network partitioning or
	// other failures, the actual number of currently running instances might be more. This has to
	// be a positive number if assigned. Default value is size.
	Parallelism uint32 `protobuf:"varint,2,opt,name=parallelism,proto3,oneof"`
}

func (*ArrayNode_Parallelism) isArrayNode_ParallelismOption() {}

type isArrayNode_SuccessCriteria interface {
	isArrayNode_SuccessCriteria()
}

type ArrayNode_MinSuccesses struct {
	// min_successes is an absolute number of the minimum number of successful completions of
	// sub-nodes. As soon as this criteria is met, the ArrayNode will be marked as successful
	// and outputs will be computed. This has to be a non-negative number if assigned. Default
	// value is size (if specified).
	MinSuccesses uint32 `protobuf:"varint,3,opt,name=min_successes,json=minSuccesses,proto3,oneof"`
}

type ArrayNode_MinSuccessRatio struct {
	// If the array job size is not known beforehand, the min_success_ratio can instead be used
	// to determine when an ArrayNode can be marked successful.
	MinSuccessRatio float32 `protobuf:"fixed32,4,opt,name=min_success_ratio,json=minSuccessRatio,proto3,oneof"`
}

func (*ArrayNode_MinSuccesses) isArrayNode_SuccessCriteria() {}

func (*ArrayNode_MinSuccessRatio) isArrayNode_SuccessCriteria() {}

// Defines extra information about the Node.
type NodeMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A friendly name for the Node
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The overall timeout of a task.
	Timeout *durationpb.Duration `protobuf:"bytes,4,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// Number of retries per task.
	Retries *RetryStrategy `protobuf:"bytes,5,opt,name=retries,proto3" json:"retries,omitempty"`
	// Identify whether node is interruptible
	//
	// Types that are assignable to InterruptibleValue:
	//
	//	*NodeMetadata_Interruptible
	InterruptibleValue isNodeMetadata_InterruptibleValue `protobuf_oneof:"interruptible_value"`
	// Identify whether a node should have it's outputs cached.
	//
	// Types that are assignable to CacheableValue:
	//
	//	*NodeMetadata_Cacheable
	CacheableValue isNodeMetadata_CacheableValue `protobuf_oneof:"cacheable_value"`
	// The version of the cache to use.
	//
	// Types that are assignable to CacheVersionValue:
	//
	//	*NodeMetadata_CacheVersion
	CacheVersionValue isNodeMetadata_CacheVersionValue `protobuf_oneof:"cache_version_value"`
	// Identify whether caching operations involving this node should be serialized.
	//
	// Types that are assignable to CacheSerializableValue:
	//
	//	*NodeMetadata_CacheSerializable
	CacheSerializableValue isNodeMetadata_CacheSerializableValue `protobuf_oneof:"cache_serializable_value"`
}

func (x *NodeMetadata) Reset() {
	*x = NodeMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_core_workflow_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeMetadata) ProtoMessage() {}

func (x *NodeMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_core_workflow_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeMetadata.ProtoReflect.Descriptor instead.
func (*NodeMetadata) Descriptor() ([]byte, []int) {
	return file_flyteidl_core_workflow_proto_rawDescGZIP(), []int{10}
}

func (x *NodeMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NodeMetadata) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *NodeMetadata) GetRetries() *RetryStrategy {
	if x != nil {
		return x.Retries
	}
	return nil
}

func (m *NodeMetadata) GetInterruptibleValue() isNodeMetadata_InterruptibleValue {
	if m != nil {
		return m.InterruptibleValue
	}
	return nil
}

func (x *NodeMetadata) GetInterruptible() bool {
	if x, ok := x.GetInterruptibleValue().(*NodeMetadata_Interruptible); ok {
		return x.Interruptible
	}
	return false
}

func (m *NodeMetadata) GetCacheableValue() isNodeMetadata_CacheableValue {
	if m != nil {
		return m.CacheableValue
	}
	return nil
}

func (x *NodeMetadata) GetCacheable() bool {
	if x, ok := x.GetCacheableValue().(*NodeMetadata_Cacheable); ok {
		return x.Cacheable
	}
	return false
}

func (m *NodeMetadata) GetCacheVersionValue() isNodeMetadata_CacheVersionValue {
	if m != nil {
		return m.CacheVersionValue
	}
	return nil
}

func (x *NodeMetadata) GetCacheVersion() string {
	if x, ok := x.GetCacheVersionValue().(*NodeMetadata_CacheVersion); ok {
		return x.CacheVersion
	}
	return ""
}

func (m *NodeMetadata) GetCacheSerializableValue() isNodeMetadata_CacheSerializableValue {
	if m != nil {
		return m.CacheSerializableValue
	}
	return nil
}

func (x *NodeMetadata) GetCacheSerializable() bool {
	if x, ok := x.GetCacheSerializableValue().(*NodeMetadata_CacheSerializable); ok {
		return x.CacheSerializable
	}
	return false
}

type isNodeMetadata_InterruptibleValue interface {
	isNodeMetadata_InterruptibleValue()
}

type NodeMetadata_Interruptible struct {
	Interruptible bool `protobuf:"varint,6,opt,name=interruptible,proto3,oneof"`
}

func (*NodeMetadata_Interruptible) isNodeMetadata_InterruptibleValue() {}

type isNodeMetadata_CacheableValue interface {
	isNodeMetadata_CacheableValue()
}

type NodeMetadata_Cacheable struct {
	Cacheable bool `protobuf:"varint,7,opt,name=cacheable,proto3,oneof"`
}

func (*NodeMetadata_Cacheable) isNodeMetadata_CacheableValue() {}

type isNodeMetadata_CacheVersionValue interface {
	isNodeMetadata_CacheVersionValue()
}

type NodeMetadata_CacheVersion struct {
	CacheVersion string `protobuf:"bytes,8,opt,name=cache_version,json=cacheVersion,proto3,oneof"`
}

func (*NodeMetadata_CacheVersion) isNodeMetadata_CacheVersionValue() {}

type isNodeMetadata_CacheSerializableValue interface {
	isNodeMetadata_CacheSerializableValue()
}

type NodeMetadata_CacheSerializable struct {
	CacheSerializable bool `protobuf:"varint,9,opt,name=cache_serializable,json=cacheSerializable,proto3,oneof"`
}

func (*NodeMetadata_CacheSerializable) isNodeMetadata_CacheSerializableValue() {}

// Links a variable to an alias.
type Alias struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Must match one of the output variable names on a node.
	Var string `protobuf:"bytes,1,opt,name=var,proto3" json:"var,omitempty"`
	// A workflow-level unique alias that downstream nodes can refer to in their input.
	Alias string `protobuf:"bytes,2,opt,name=alias,proto3" json:"alias,omitempty"`
}

func (x *Alias) Reset() {
	*x = Alias{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_core_workflow_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Alias) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Alias) ProtoMessage() {}

func (x *Alias) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_core_workflow_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Alias.ProtoReflect.Descriptor instead.
func (*Alias) Descriptor() ([]byte, []int) {
	return file_flyteidl_core_workflow_proto_rawDescGZIP(), []int{11}
}

func (x *Alias) GetVar() string {
	if x != nil {
		return x.Var
	}
	return ""
}

func (x *Alias) GetAlias() string {
	if x != nil {
		return x.Alias
	}
	return ""
}

// A Workflow graph Node. One unit of execution in the graph. Each node can be linked to a Task, a Workflow or a branch
// node.
type Node struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A workflow-level unique identifier that identifies this node in the workflow. 'inputs' and 'outputs' are reserved
	// node ids that cannot be used by other nodes.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Extra metadata about the node.
	Metadata *NodeMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Specifies how to bind the underlying interface's inputs. All required inputs specified in the underlying interface
	// must be fulfilled.
	Inputs []*Binding `protobuf:"bytes,3,rep,name=inputs,proto3" json:"inputs,omitempty"`
	// +optional Specifies execution dependency for this node ensuring it will only get scheduled to run after all its
	// upstream nodes have completed. This node will have an implicit dependency on any node that appears in inputs
	// field.
	UpstreamNodeIds []string `protobuf:"bytes,4,rep,name=upstream_node_ids,json=upstreamNodeIds,proto3" json:"upstream_node_ids,omitempty"`
	// +optional. A node can define aliases for a subset of its outputs. This is particularly useful if different nodes
	// need to conform to the same interface (e.g. all branches in a branch node). Downstream nodes must refer to this
	// nodes outputs using the alias if one's specified.
	OutputAliases []*Alias `protobuf:"bytes,5,rep,name=output_aliases,json=outputAliases,proto3" json:"output_aliases,omitempty"`
	// Information about the target to execute in this node.
	//
	// Types that are assignable to Target:
	//
	//	*Node_TaskNode
	//	*Node_WorkflowNode
	//	*Node_BranchNode
	//	*Node_GateNode
	//	*Node_ArrayNode
	Target isNode_Target `protobuf_oneof:"target"`
}

func (x *Node) Reset() {
	*x = Node{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_core_workflow_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Node) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Node) ProtoMessage() {}

func (x *Node) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_core_workflow_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Node.ProtoReflect.Descriptor instead.
func (*Node) Descriptor() ([]byte, []int) {
	return file_flyteidl_core_workflow_proto_rawDescGZIP(), []int{12}
}

func (x *Node) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Node) GetMetadata() *NodeMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Node) GetInputs() []*Binding {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *Node) GetUpstreamNodeIds() []string {
	if x != nil {
		return x.UpstreamNodeIds
	}
	return nil
}

func (x *Node) GetOutputAliases() []*Alias {
	if x != nil {
		return x.OutputAliases
	}
	return nil
}

func (m *Node) GetTarget() isNode_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (x *Node) GetTaskNode() *TaskNode {
	if x, ok := x.GetTarget().(*Node_TaskNode); ok {
		return x.TaskNode
	}
	return nil
}

func (x *Node) GetWorkflowNode() *WorkflowNode {
	if x, ok := x.GetTarget().(*Node_WorkflowNode); ok {
		return x.WorkflowNode
	}
	return nil
}

func (x *Node) GetBranchNode() *BranchNode {
	if x, ok := x.GetTarget().(*Node_BranchNode); ok {
		return x.BranchNode
	}
	return nil
}

func (x *Node) GetGateNode() *GateNode {
	if x, ok := x.GetTarget().(*Node_GateNode); ok {
		return x.GateNode
	}
	return nil
}

func (x *Node) GetArrayNode() *ArrayNode {
	if x, ok := x.GetTarget().(*Node_ArrayNode); ok {
		return x.ArrayNode
	}
	return nil
}

type isNode_Target interface {
	isNode_Target()
}

type Node_TaskNode struct {
	// Information about the Task to execute in this node.
	TaskNode *TaskNode `protobuf:"bytes,6,opt,name=task_node,json=taskNode,proto3,oneof"`
}

type Node_WorkflowNode struct {
	// Information about the Workflow to execute in this mode.
	WorkflowNode *WorkflowNode `protobuf:"bytes,7,opt,name=workflow_node,json=workflowNode,proto3,oneof"`
}

type Node_BranchNode struct {
	// Information about the branch node to evaluate in this node.
	BranchNode *BranchNode `protobuf:"bytes,8,opt,name=branch_node,json=branchNode,proto3,oneof"`
}

type Node_GateNode struct {
	// Information about the condition to evaluate in this node.
	GateNode *GateNode `protobuf:"bytes,9,opt,name=gate_node,json=gateNode,proto3,oneof"`
}

type Node_ArrayNode struct {
	// Information about the sub-node executions for each value in the list of this nodes
	// inputs values.
	ArrayNode *ArrayNode `protobuf:"bytes,10,opt,name=array_node,json=arrayNode,proto3,oneof"`
}

func (*Node_TaskNode) isNode_Target() {}

func (*Node_WorkflowNode) isNode_Target() {}

func (*Node_BranchNode) isNode_Target() {}

func (*Node_GateNode) isNode_Target() {}

func (*Node_ArrayNode) isNode_Target() {}

// This is workflow layer metadata. These settings are only applicable to the workflow as a whole, and do not
// percolate down to child entities (like tasks) launched by the workflow.
type WorkflowMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates the runtime priority of workflow executions.
	QualityOfService *QualityOfService `protobuf:"bytes,1,opt,name=quality_of_service,json=qualityOfService,proto3" json:"quality_of_service,omitempty"`
	// Defines how the system should behave when a failure is detected in the workflow execution.
	OnFailure WorkflowMetadata_OnFailurePolicy `protobuf:"varint,2,opt,name=on_failure,json=onFailure,proto3,enum=flyteidl.core.WorkflowMetadata_OnFailurePolicy" json:"on_failure,omitempty"`
	// Arbitrary tags that allow users and the platform to store small but arbitrary labels
	Tags map[string]string `protobuf:"bytes,3,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *WorkflowMetadata) Reset() {
	*x = WorkflowMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_core_workflow_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkflowMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkflowMetadata) ProtoMessage() {}

func (x *WorkflowMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_core_workflow_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkflowMetadata.ProtoReflect.Descriptor instead.
func (*WorkflowMetadata) Descriptor() ([]byte, []int) {
	return file_flyteidl_core_workflow_proto_rawDescGZIP(), []int{13}
}

func (x *WorkflowMetadata) GetQualityOfService() *QualityOfService {
	if x != nil {
		return x.QualityOfService
	}
	return nil
}

func (x *WorkflowMetadata) GetOnFailure() WorkflowMetadata_OnFailurePolicy {
	if x != nil {
		return x.OnFailure
	}
	return WorkflowMetadata_FAIL_IMMEDIATELY
}

func (x *WorkflowMetadata) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

// The difference between these settings and the WorkflowMetadata ones is that these are meant to be passed down to
// a workflow's underlying entities (like tasks). For instance, 'interruptible' has no meaning at the workflow layer, it
// is only relevant when a task executes. The settings here are the defaults that are passed to all nodes
// unless explicitly overridden at the node layer.
// If you are adding a setting that applies to both the Workflow itself, and everything underneath it, it should be
// added to both this object and the WorkflowMetadata object above.
type WorkflowMetadataDefaults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether child nodes of the workflow are interruptible.
	Interruptible bool `protobuf:"varint,1,opt,name=interruptible,proto3" json:"interruptible,omitempty"`
}

func (x *WorkflowMetadataDefaults) Reset() {
	*x = WorkflowMetadataDefaults{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_core_workflow_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkflowMetadataDefaults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkflowMetadataDefaults) ProtoMessage() {}

func (x *WorkflowMetadataDefaults) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_core_workflow_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkflowMetadataDefaults.ProtoReflect.Descriptor instead.
func (*WorkflowMetadataDefaults) Descriptor() ([]byte, []int) {
	return file_flyteidl_core_workflow_proto_rawDescGZIP(), []int{14}
}

func (x *WorkflowMetadataDefaults) GetInterruptible() bool {
	if x != nil {
		return x.Interruptible
	}
	return false
}

// Flyte Workflow Structure that encapsulates task, branch and subworkflow nodes to form a statically analyzable,
// directed acyclic graph.
type WorkflowTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A globally unique identifier for the workflow.
	Id *Identifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Extra metadata about the workflow.
	Metadata *WorkflowMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Defines a strongly typed interface for the Workflow. This can include some optional parameters.
	Interface *TypedInterface `protobuf:"bytes,3,opt,name=interface,proto3" json:"interface,omitempty"`
	// A list of nodes. In addition, 'globals' is a special reserved node id that can be used to consume workflow inputs.
	Nodes []*Node `protobuf:"bytes,4,rep,name=nodes,proto3" json:"nodes,omitempty"`
	// A list of output bindings that specify how to construct workflow outputs. Bindings can pull node outputs or
	// specify literals. All workflow outputs specified in the interface field must be bound in order for the workflow
	// to be validated. A workflow has an implicit dependency on all of its nodes to execute successfully in order to
	// bind final outputs.
	// Most of these outputs will be Binding's with a BindingData of type OutputReference.  That is, your workflow can
	// just have an output of some constant (`Output(5)`), but usually, the workflow will be pulling
	// outputs from the output of a task.
	Outputs []*Binding `protobuf:"bytes,5,rep,name=outputs,proto3" json:"outputs,omitempty"`
	// +optional A catch-all node. This node is executed whenever the execution engine determines the workflow has failed.
	// The interface of this node must match the Workflow interface with an additional input named 'error' of type
	// pb.lyft.flyte.core.Error.
	FailureNode *Node `protobuf:"bytes,6,opt,name=failure_node,json=failureNode,proto3" json:"failure_node,omitempty"`
	// workflow defaults
	MetadataDefaults *WorkflowMetadataDefaults `protobuf:"bytes,7,opt,name=metadata_defaults,json=metadataDefaults,proto3" json:"metadata_defaults,omitempty"`
}

func (x *WorkflowTemplate) Reset() {
	*x = WorkflowTemplate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_core_workflow_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkflowTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkflowTemplate) ProtoMessage() {}

func (x *WorkflowTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_core_workflow_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkflowTemplate.ProtoReflect.Descriptor instead.
func (*WorkflowTemplate) Descriptor() ([]byte, []int) {
	return file_flyteidl_core_workflow_proto_rawDescGZIP(), []int{15}
}

func (x *WorkflowTemplate) GetId() *Identifier {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *WorkflowTemplate) GetMetadata() *WorkflowMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *WorkflowTemplate) GetInterface() *TypedInterface {
	if x != nil {
		return x.Interface
	}
	return nil
}

func (x *WorkflowTemplate) GetNodes() []*Node {
	if x != nil {
		return x.Nodes
	}
	return nil
}

func (x *WorkflowTemplate) GetOutputs() []*Binding {
	if x != nil {
		return x.Outputs
	}
	return nil
}

func (x *WorkflowTemplate) GetFailureNode() *Node {
	if x != nil {
		return x.FailureNode
	}
	return nil
}

func (x *WorkflowTemplate) GetMetadataDefaults() *WorkflowMetadataDefaults {
	if x != nil {
		return x.MetadataDefaults
	}
	return nil
}

// Optional task node overrides that will be applied at task execution time.
type TaskNodeOverrides struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A customizable interface to convey resources requested for a task container.
	Resources *Resources `protobuf:"bytes,1,opt,name=resources,proto3" json:"resources,omitempty"`
	// Overrides for all non-standard resources, not captured by
	// v1.ResourceRequirements, to allocate to a task.
	ExtendedResources *ExtendedResources `protobuf:"bytes,2,opt,name=extended_resources,json=extendedResources,proto3" json:"extended_resources,omitempty"`
	// Override for the image used by task pods.
	ContainerImage string `protobuf:"bytes,3,opt,name=container_image,json=containerImage,proto3" json:"container_image,omitempty"`
}

func (x *TaskNodeOverrides) Reset() {
	*x = TaskNodeOverrides{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_core_workflow_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TaskNodeOverrides) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaskNodeOverrides) ProtoMessage() {}

func (x *TaskNodeOverrides) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_core_workflow_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaskNodeOverrides.ProtoReflect.Descriptor instead.
func (*TaskNodeOverrides) Descriptor() ([]byte, []int) {
	return file_flyteidl_core_workflow_proto_rawDescGZIP(), []int{16}
}

func (x *TaskNodeOverrides) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *TaskNodeOverrides) GetExtendedResources() *ExtendedResources {
	if x != nil {
		return x.ExtendedResources
	}
	return nil
}

func (x *TaskNodeOverrides) GetContainerImage() string {
	if x != nil {
		return x.ContainerImage
	}
	return ""
}

// A structure that uniquely identifies a launch plan in the system.
type LaunchPlanTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A globally unique identifier for the launch plan.
	Id *Identifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The input and output interface for the launch plan
	Interface *TypedInterface `protobuf:"bytes,2,opt,name=interface,proto3" json:"interface,omitempty"`
	// A collection of input literals that are fixed for the launch plan
	FixedInputs *LiteralMap `protobuf:"bytes,3,opt,name=fixed_inputs,json=fixedInputs,proto3" json:"fixed_inputs,omitempty"`
}

func (x *LaunchPlanTemplate) Reset() {
	*x = LaunchPlanTemplate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_core_workflow_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LaunchPlanTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LaunchPlanTemplate) ProtoMessage() {}

func (x *LaunchPlanTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_core_workflow_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LaunchPlanTemplate.ProtoReflect.Descriptor instead.
func (*LaunchPlanTemplate) Descriptor() ([]byte, []int) {
	return file_flyteidl_core_workflow_proto_rawDescGZIP(), []int{17}
}

func (x *LaunchPlanTemplate) GetId() *Identifier {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *LaunchPlanTemplate) GetInterface() *TypedInterface {
	if x != nil {
		return x.Interface
	}
	return nil
}

func (x *LaunchPlanTemplate) GetFixedInputs() *LiteralMap {
	if x != nil {
		return x.FixedInputs
	}
	return nil
}

var File_flyteidl_core_workflow_proto protoreflect.FileDescriptor

var file_flyteidl_core_workflow_proto_rawDesc = []byte{
	0x0a, 0x1c, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f,
	0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0d,
	0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x1a, 0x1d, 0x66,
	0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x66, 0x6c,
	0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x66, 0x6c, 0x79,
	0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x66, 0x6c, 0x79,
	0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x66, 0x61, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x66, 0x6c, 0x79, 0x74,
	0x65, 0x69, 0x64, 0x6c, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x6c, 0x69, 0x74, 0x65, 0x72, 0x61,
	0x6c, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69,
	0x64, 0x6c, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x63, 0x6f,
	0x72, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72,
	0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x7b, 0x0a, 0x07,
	0x49, 0x66, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x3e, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x66, 0x6c, 0x79,
	0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x65,
	0x61, 0x6e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x63, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x0a, 0x09, 0x74, 0x68, 0x65, 0x6e, 0x5f,
	0x6e, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x66, 0x6c, 0x79,
	0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x52,
	0x08, 0x74, 0x68, 0x65, 0x6e, 0x4e, 0x6f, 0x64, 0x65, 0x22, 0xd4, 0x01, 0x0a, 0x0b, 0x49, 0x66,
	0x45, 0x6c, 0x73, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x2a, 0x0a, 0x04, 0x63, 0x61, 0x73,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69,
	0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x49, 0x66, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52,
	0x04, 0x63, 0x61, 0x73, 0x65, 0x12, 0x2c, 0x0a, 0x05, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e,
	0x63, 0x6f, 0x72, 0x65, 0x2e, 0x49, 0x66, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x05, 0x6f, 0x74,
	0x68, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x09, 0x65, 0x6c, 0x73, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64,
	0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x48, 0x00, 0x52, 0x08, 0x65,
	0x6c, 0x73, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x2c, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64,
	0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x09, 0x0a, 0x07, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x22, 0x41, 0x0a, 0x0a, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x33,
	0x0a, 0x07, 0x69, 0x66, 0x5f, 0x65, 0x6c, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e,
	0x49, 0x66, 0x45, 0x6c, 0x73, 0x65, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x06, 0x69, 0x66, 0x45,
	0x6c, 0x73, 0x65, 0x22, 0x97, 0x01, 0x0a, 0x08, 0x54, 0x61, 0x73, 0x6b, 0x4e, 0x6f, 0x64, 0x65,
	0x12, 0x3e, 0x0a, 0x0c, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64,
	0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x48, 0x00, 0x52, 0x0b, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x64,
	0x12, 0x3e, 0x0a, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63,
	0x6f, 0x72, 0x65, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x4e, 0x6f, 0x64, 0x65, 0x4f, 0x76, 0x65, 0x72,
	0x72, 0x69, 0x64, 0x65, 0x73, 0x52, 0x09, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73,
	0x42, 0x0b, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xa6, 0x01,
	0x0a, 0x0c, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x42,
	0x0a, 0x0e, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x66,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64,
	0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x48, 0x00, 0x52, 0x0d, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x70, 0x6c, 0x61, 0x6e, 0x52,
	0x65, 0x66, 0x12, 0x45, 0x0a, 0x10, 0x73, 0x75, 0x62, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c,
	0x6f, 0x77, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x66,
	0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x75, 0x62, 0x57, 0x6f,
	0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x52, 0x65, 0x66, 0x42, 0x0b, 0x0a, 0x09, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x2f, 0x0a, 0x10, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76,
	0x65, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x69,
	0x67, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73,
	0x69, 0x67, 0x6e, 0x61, 0x6c, 0x49, 0x64, 0x22, 0x90, 0x01, 0x0a, 0x0f, 0x53, 0x69, 0x67, 0x6e,
	0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x73,
	0x69, 0x67, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64,
	0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x47, 0x0a, 0x0e, 0x53, 0x6c,
	0x65, 0x65, 0x70, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x08,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xc5, 0x01, 0x0a, 0x08, 0x47, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x64, 0x65,
	0x12, 0x3b, 0x0a, 0x07, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1f, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72,
	0x65, 0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x07, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x12, 0x38, 0x0a,
	0x06, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e,
	0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x53, 0x69,
	0x67, 0x6e, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x06, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x12, 0x35, 0x0a, 0x05, 0x73, 0x6c, 0x65, 0x65, 0x70,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64,
	0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x53, 0x6c, 0x65, 0x65, 0x70, 0x43, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x05, 0x73, 0x6c, 0x65, 0x65, 0x70, 0x42, 0x0b,
	0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xba, 0x03, 0x0a, 0x09,
	0x41, 0x72, 0x72, 0x61, 0x79, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x27, 0x0a, 0x04, 0x6e, 0x6f, 0x64,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69,
	0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6e, 0x6f,
	0x64, 0x65, 0x12, 0x22, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x69, 0x73,
	0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x61, 0x6c,
	0x6c, 0x65, 0x6c, 0x69, 0x73, 0x6d, 0x12, 0x25, 0x0a, 0x0d, 0x6d, 0x69, 0x6e, 0x5f, 0x73, 0x75,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x48, 0x01, 0x52,
	0x0c, 0x6d, 0x69, 0x6e, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x2c, 0x0a,
	0x11, 0x6d, 0x69, 0x6e, 0x5f, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x48, 0x01, 0x52, 0x0f, 0x6d, 0x69, 0x6e, 0x53,
	0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x12, 0x4d, 0x0a, 0x0e, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63,
	0x6f, 0x72, 0x65, 0x2e, 0x41, 0x72, 0x72, 0x61, 0x79, 0x4e, 0x6f, 0x64, 0x65, 0x2e, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0d, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x5e, 0x0a, 0x1e, 0x69, 0x73,
	0x5f, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x75, 0x62, 0x5f, 0x6e, 0x6f,
	0x64, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1a,
	0x69, 0x73, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x53, 0x75, 0x62, 0x4e, 0x6f, 0x64,
	0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x22, 0x32, 0x0a, 0x0d, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x11, 0x0a, 0x0d, 0x4d,
	0x49, 0x4e, 0x49, 0x4d, 0x41, 0x4c, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x10, 0x00, 0x12, 0x0e,
	0x0a, 0x0a, 0x46, 0x55, 0x4c, 0x4c, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x10, 0x01, 0x42, 0x14,
	0x0a, 0x12, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x69, 0x73, 0x6d, 0x5f, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x12, 0x0a, 0x10, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f,
	0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x22, 0x8c, 0x03, 0x0a, 0x0c, 0x4e, 0x6f, 0x64,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x33, 0x0a,
	0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f,
	0x75, 0x74, 0x12, 0x36, 0x0a, 0x07, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63,
	0x6f, 0x72, 0x65, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67,
	0x79, 0x52, 0x07, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0d, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x72, 0x75, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x00, 0x52, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x72, 0x75, 0x70, 0x74, 0x69, 0x62,
	0x6c, 0x65, 0x12, 0x1e, 0x0a, 0x09, 0x63, 0x61, 0x63, 0x68, 0x65, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x08, 0x48, 0x01, 0x52, 0x09, 0x63, 0x61, 0x63, 0x68, 0x65, 0x61, 0x62,
	0x6c, 0x65, 0x12, 0x25, 0x0a, 0x0d, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x0c, 0x63, 0x61, 0x63,
	0x68, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x12, 0x63, 0x61, 0x63,
	0x68, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x08, 0x48, 0x03, 0x52, 0x11, 0x63, 0x61, 0x63, 0x68, 0x65, 0x53, 0x65,
	0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x15, 0x0a, 0x13, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x72, 0x75, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x42, 0x11, 0x0a, 0x0f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x42, 0x15, 0x0a, 0x13, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x1a, 0x0a, 0x18, 0x63,
	0x61, 0x63, 0x68, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x2f, 0x0a, 0x05, 0x41, 0x6c, 0x69, 0x61, 0x73,
	0x12, 0x10, 0x0a, 0x03, 0x76, 0x61, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x76,
	0x61, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x22, 0x9f, 0x04, 0x0a, 0x04, 0x4e, 0x6f, 0x64,
	0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x37, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63,
	0x6f, 0x72, 0x65, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2e, 0x0a, 0x06, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x66, 0x6c, 0x79,
	0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x42, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x52, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x75, 0x70,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x75, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4e,
	0x6f, 0x64, 0x65, 0x49, 0x64, 0x73, 0x12, 0x3b, 0x0a, 0x0e, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x5f, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14,
	0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x41,
	0x6c, 0x69, 0x61, 0x73, 0x52, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x6c, 0x69, 0x61,
	0x73, 0x65, 0x73, 0x12, 0x36, 0x0a, 0x09, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x6e, 0x6f, 0x64, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64,
	0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x4e, 0x6f, 0x64, 0x65, 0x48,
	0x00, 0x52, 0x08, 0x74, 0x61, 0x73, 0x6b, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x42, 0x0a, 0x0d, 0x77,
	0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f,
	0x72, 0x65, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x4e, 0x6f, 0x64, 0x65, 0x48,
	0x00, 0x52, 0x0c, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x4e, 0x6f, 0x64, 0x65, 0x12,
	0x3c, 0x0a, 0x0b, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e,
	0x63, 0x6f, 0x72, 0x65, 0x2e, 0x42, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x4e, 0x6f, 0x64, 0x65, 0x48,
	0x00, 0x52, 0x0a, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x36, 0x0a,
	0x09, 0x67, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65,
	0x2e, 0x47, 0x61, 0x74, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x48, 0x00, 0x52, 0x08, 0x67, 0x61, 0x74,
	0x65, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x6e,
	0x6f, 0x64, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x66, 0x6c, 0x79, 0x74,
	0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x41, 0x72, 0x72, 0x61, 0x79, 0x4e,
	0x6f, 0x64, 0x65, 0x48, 0x00, 0x52, 0x09, 0x61, 0x72, 0x72, 0x61, 0x79, 0x4e, 0x6f, 0x64, 0x65,
	0x42, 0x08, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0xfc, 0x02, 0x0a, 0x10, 0x57,
	0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x4d, 0x0a, 0x12, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x6f, 0x66, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x66, 0x6c,
	0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x51, 0x75, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x10, 0x71, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x4e,
	0x0a, 0x0a, 0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f,
	0x72, 0x65, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x4f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x09, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x12, 0x3d,
	0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x66,
	0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x57, 0x6f, 0x72,
	0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61,
	0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x1a, 0x37, 0x0a,
	0x09, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x51, 0x0a, 0x0f, 0x4f, 0x6e, 0x46, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x14, 0x0a, 0x10, 0x46, 0x41, 0x49,
	0x4c, 0x5f, 0x49, 0x4d, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x54, 0x45, 0x4c, 0x59, 0x10, 0x00, 0x12,
	0x28, 0x0a, 0x24, 0x46, 0x41, 0x49, 0x4c, 0x5f, 0x41, 0x46, 0x54, 0x45, 0x52, 0x5f, 0x45, 0x58,
	0x45, 0x43, 0x55, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x53, 0x5f, 0x43,
	0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x01, 0x22, 0x40, 0x0a, 0x18, 0x57, 0x6f, 0x72,
	0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x44, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x24, 0x0a, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x72, 0x75,
	0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x72, 0x75, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x22, 0xa2, 0x03, 0x0a, 0x10,
	0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x12, 0x29, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x66,
	0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x02, 0x69, 0x64, 0x12, 0x3b, 0x0a, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x57, 0x6f,
	0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x66, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x66, 0x6c,
	0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x64, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x52, 0x09, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x66, 0x61, 0x63, 0x65, 0x12, 0x29, 0x0a, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e,
	0x63, 0x6f, 0x72, 0x65, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73,
	0x12, 0x30, 0x0a, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72,
	0x65, 0x2e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x73, 0x12, 0x36, 0x0a, 0x0c, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x6e, 0x6f,
	0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65,
	0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x0b, 0x66,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x4e, 0x6f, 0x64, 0x65, 0x12, 0x54, 0x0a, 0x11, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c,
	0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x10,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73,
	0x22, 0xc5, 0x01, 0x0a, 0x11, 0x54, 0x61, 0x73, 0x6b, 0x4e, 0x6f, 0x64, 0x65, 0x4f, 0x76, 0x65,
	0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x12, 0x36, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x66, 0x6c, 0x79, 0x74,
	0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x4f,
	0x0a, 0x12, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x66, 0x6c, 0x79,
	0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x64, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x11, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x27, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x22, 0xba, 0x01, 0x0a, 0x12, 0x4c, 0x61, 0x75,
	0x6e, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12,
	0x29, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x66, 0x6c,
	0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x02, 0x69, 0x64, 0x12, 0x3b, 0x0a, 0x09, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e,
	0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x54, 0x79,
	0x70, 0x65, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x52, 0x09, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x12, 0x3c, 0x0a, 0x0c, 0x66, 0x69, 0x78, 0x65, 0x64,
	0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x4c, 0x69,
	0x74, 0x65, 0x72, 0x61, 0x6c, 0x4d, 0x61, 0x70, 0x52, 0x0b, 0x66, 0x69, 0x78, 0x65, 0x64, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x73, 0x42, 0xb3, 0x01, 0x0a, 0x11, 0x63, 0x6f, 0x6d, 0x2e, 0x66, 0x6c,
	0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x0d, 0x57, 0x6f, 0x72,
	0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3a, 0x67, 0x69,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x6f, 0x72,
	0x67, 0x2f, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x2f, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c,
	0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x70, 0x62, 0x2d, 0x67, 0x6f, 0x2f, 0x66, 0x6c, 0x79, 0x74, 0x65,
	0x69, 0x64, 0x6c, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0xa2, 0x02, 0x03, 0x46, 0x43, 0x58, 0xaa, 0x02,
	0x0d, 0x46, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x43, 0x6f, 0x72, 0x65, 0xca, 0x02,
	0x0d, 0x46, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x5c, 0x43, 0x6f, 0x72, 0x65, 0xe2, 0x02,
	0x19, 0x46, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x5c, 0x43, 0x6f, 0x72, 0x65, 0x5c, 0x47,
	0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x0e, 0x46, 0x6c, 0x79,
	0x74, 0x65, 0x69, 0x64, 0x6c, 0x3a, 0x3a, 0x43, 0x6f, 0x72, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_flyteidl_core_workflow_proto_rawDescOnce sync.Once
	file_flyteidl_core_workflow_proto_rawDescData = file_flyteidl_core_workflow_proto_rawDesc
)

func file_flyteidl_core_workflow_proto_rawDescGZIP() []byte {
	file_flyteidl_core_workflow_proto_rawDescOnce.Do(func() {
		file_flyteidl_core_workflow_proto_rawDescData = protoimpl.X.CompressGZIP(file_flyteidl_core_workflow_proto_rawDescData)
	})
	return file_flyteidl_core_workflow_proto_rawDescData
}

var file_flyteidl_core_workflow_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_flyteidl_core_workflow_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_flyteidl_core_workflow_proto_goTypes = []interface{}{
	(ArrayNode_ExecutionMode)(0),          // 0: flyteidl.core.ArrayNode.ExecutionMode
	(WorkflowMetadata_OnFailurePolicy)(0), // 1: flyteidl.core.WorkflowMetadata.OnFailurePolicy
	(*IfBlock)(nil),                       // 2: flyteidl.core.IfBlock
	(*IfElseBlock)(nil),                   // 3: flyteidl.core.IfElseBlock
	(*BranchNode)(nil),                    // 4: flyteidl.core.BranchNode
	(*TaskNode)(nil),                      // 5: flyteidl.core.TaskNode
	(*WorkflowNode)(nil),                  // 6: flyteidl.core.WorkflowNode
	(*ApproveCondition)(nil),              // 7: flyteidl.core.ApproveCondition
	(*SignalCondition)(nil),               // 8: flyteidl.core.SignalCondition
	(*SleepCondition)(nil),                // 9: flyteidl.core.SleepCondition
	(*GateNode)(nil),                      // 10: flyteidl.core.GateNode
	(*ArrayNode)(nil),                     // 11: flyteidl.core.ArrayNode
	(*NodeMetadata)(nil),                  // 12: flyteidl.core.NodeMetadata
	(*Alias)(nil),                         // 13: flyteidl.core.Alias
	(*Node)(nil),                          // 14: flyteidl.core.Node
	(*WorkflowMetadata)(nil),              // 15: flyteidl.core.WorkflowMetadata
	(*WorkflowMetadataDefaults)(nil),      // 16: flyteidl.core.WorkflowMetadataDefaults
	(*WorkflowTemplate)(nil),              // 17: flyteidl.core.WorkflowTemplate
	(*TaskNodeOverrides)(nil),             // 18: flyteidl.core.TaskNodeOverrides
	(*LaunchPlanTemplate)(nil),            // 19: flyteidl.core.LaunchPlanTemplate
	nil,                                   // 20: flyteidl.core.WorkflowMetadata.TagsEntry
	(*BooleanExpression)(nil),             // 21: flyteidl.core.BooleanExpression
	(*Error)(nil),                         // 22: flyteidl.core.Error
	(*Identifier)(nil),                    // 23: flyteidl.core.Identifier
	(*LiteralType)(nil),                   // 24: flyteidl.core.LiteralType
	(*durationpb.Duration)(nil),           // 25: google.protobuf.Duration
	(*wrapperspb.BoolValue)(nil),          // 26: google.protobuf.BoolValue
	(*RetryStrategy)(nil),                 // 27: flyteidl.core.RetryStrategy
	(*Binding)(nil),                       // 28: flyteidl.core.Binding
	(*QualityOfService)(nil),              // 29: flyteidl.core.QualityOfService
	(*TypedInterface)(nil),                // 30: flyteidl.core.TypedInterface
	(*Resources)(nil),                     // 31: flyteidl.core.Resources
	(*ExtendedResources)(nil),             // 32: flyteidl.core.ExtendedResources
	(*LiteralMap)(nil),                    // 33: flyteidl.core.LiteralMap
}
var file_flyteidl_core_workflow_proto_depIdxs = []int32{
	21, // 0: flyteidl.core.IfBlock.condition:type_name -> flyteidl.core.BooleanExpression
	14, // 1: flyteidl.core.IfBlock.then_node:type_name -> flyteidl.core.Node
	2,  // 2: flyteidl.core.IfElseBlock.case:type_name -> flyteidl.core.IfBlock
	2,  // 3: flyteidl.core.IfElseBlock.other:type_name -> flyteidl.core.IfBlock
	14, // 4: flyteidl.core.IfElseBlock.else_node:type_name -> flyteidl.core.Node
	22, // 5: flyteidl.core.IfElseBlock.error:type_name -> flyteidl.core.Error
	3,  // 6: flyteidl.core.BranchNode.if_else:type_name -> flyteidl.core.IfElseBlock
	23, // 7: flyteidl.core.TaskNode.reference_id:type_name -> flyteidl.core.Identifier
	18, // 8: flyteidl.core.TaskNode.overrides:type_name -> flyteidl.core.TaskNodeOverrides
	23, // 9: flyteidl.core.WorkflowNode.launchplan_ref:type_name -> flyteidl.core.Identifier
	23, // 10: flyteidl.core.WorkflowNode.sub_workflow_ref:type_name -> flyteidl.core.Identifier
	24, // 11: flyteidl.core.SignalCondition.type:type_name -> flyteidl.core.LiteralType
	25, // 12: flyteidl.core.SleepCondition.duration:type_name -> google.protobuf.Duration
	7,  // 13: flyteidl.core.GateNode.approve:type_name -> flyteidl.core.ApproveCondition
	8,  // 14: flyteidl.core.GateNode.signal:type_name -> flyteidl.core.SignalCondition
	9,  // 15: flyteidl.core.GateNode.sleep:type_name -> flyteidl.core.SleepCondition
	14, // 16: flyteidl.core.ArrayNode.node:type_name -> flyteidl.core.Node
	0,  // 17: flyteidl.core.ArrayNode.execution_mode:type_name -> flyteidl.core.ArrayNode.ExecutionMode
	26, // 18: flyteidl.core.ArrayNode.is_original_sub_node_interface:type_name -> google.protobuf.BoolValue
	25, // 19: flyteidl.core.NodeMetadata.timeout:type_name -> google.protobuf.Duration
	27, // 20: flyteidl.core.NodeMetadata.retries:type_name -> flyteidl.core.RetryStrategy
	12, // 21: flyteidl.core.Node.metadata:type_name -> flyteidl.core.NodeMetadata
	28, // 22: flyteidl.core.Node.inputs:type_name -> flyteidl.core.Binding
	13, // 23: flyteidl.core.Node.output_aliases:type_name -> flyteidl.core.Alias
	5,  // 24: flyteidl.core.Node.task_node:type_name -> flyteidl.core.TaskNode
	6,  // 25: flyteidl.core.Node.workflow_node:type_name -> flyteidl.core.WorkflowNode
	4,  // 26: flyteidl.core.Node.branch_node:type_name -> flyteidl.core.BranchNode
	10, // 27: flyteidl.core.Node.gate_node:type_name -> flyteidl.core.GateNode
	11, // 28: flyteidl.core.Node.array_node:type_name -> flyteidl.core.ArrayNode
	29, // 29: flyteidl.core.WorkflowMetadata.quality_of_service:type_name -> flyteidl.core.QualityOfService
	1,  // 30: flyteidl.core.WorkflowMetadata.on_failure:type_name -> flyteidl.core.WorkflowMetadata.OnFailurePolicy
	20, // 31: flyteidl.core.WorkflowMetadata.tags:type_name -> flyteidl.core.WorkflowMetadata.TagsEntry
	23, // 32: flyteidl.core.WorkflowTemplate.id:type_name -> flyteidl.core.Identifier
	15, // 33: flyteidl.core.WorkflowTemplate.metadata:type_name -> flyteidl.core.WorkflowMetadata
	30, // 34: flyteidl.core.WorkflowTemplate.interface:type_name -> flyteidl.core.TypedInterface
	14, // 35: flyteidl.core.WorkflowTemplate.nodes:type_name -> flyteidl.core.Node
	28, // 36: flyteidl.core.WorkflowTemplate.outputs:type_name -> flyteidl.core.Binding
	14, // 37: flyteidl.core.WorkflowTemplate.failure_node:type_name -> flyteidl.core.Node
	16, // 38: flyteidl.core.WorkflowTemplate.metadata_defaults:type_name -> flyteidl.core.WorkflowMetadataDefaults
	31, // 39: flyteidl.core.TaskNodeOverrides.resources:type_name -> flyteidl.core.Resources
	32, // 40: flyteidl.core.TaskNodeOverrides.extended_resources:type_name -> flyteidl.core.ExtendedResources
	23, // 41: flyteidl.core.LaunchPlanTemplate.id:type_name -> flyteidl.core.Identifier
	30, // 42: flyteidl.core.LaunchPlanTemplate.interface:type_name -> flyteidl.core.TypedInterface
	33, // 43: flyteidl.core.LaunchPlanTemplate.fixed_inputs:type_name -> flyteidl.core.LiteralMap
	44, // [44:44] is the sub-list for method output_type
	44, // [44:44] is the sub-list for method input_type
	44, // [44:44] is the sub-list for extension type_name
	44, // [44:44] is the sub-list for extension extendee
	0,  // [0:44] is the sub-list for field type_name
}

func init() { file_flyteidl_core_workflow_proto_init() }
func file_flyteidl_core_workflow_proto_init() {
	if File_flyteidl_core_workflow_proto != nil {
		return
	}
	file_flyteidl_core_condition_proto_init()
	file_flyteidl_core_execution_proto_init()
	file_flyteidl_core_identifier_proto_init()
	file_flyteidl_core_interface_proto_init()
	file_flyteidl_core_literals_proto_init()
	file_flyteidl_core_tasks_proto_init()
	file_flyteidl_core_types_proto_init()
	file_flyteidl_core_security_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_flyteidl_core_workflow_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IfBlock); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_core_workflow_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IfElseBlock); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_core_workflow_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BranchNode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_core_workflow_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TaskNode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_core_workflow_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkflowNode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_core_workflow_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApproveCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_core_workflow_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SignalCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_core_workflow_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SleepCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_core_workflow_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GateNode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_core_workflow_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArrayNode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_core_workflow_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_core_workflow_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Alias); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_core_workflow_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Node); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_core_workflow_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkflowMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_core_workflow_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkflowMetadataDefaults); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_core_workflow_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkflowTemplate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_core_workflow_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TaskNodeOverrides); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_core_workflow_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LaunchPlanTemplate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_flyteidl_core_workflow_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*IfElseBlock_ElseNode)(nil),
		(*IfElseBlock_Error)(nil),
	}
	file_flyteidl_core_workflow_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*TaskNode_ReferenceId)(nil),
	}
	file_flyteidl_core_workflow_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*WorkflowNode_LaunchplanRef)(nil),
		(*WorkflowNode_SubWorkflowRef)(nil),
	}
	file_flyteidl_core_workflow_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*GateNode_Approve)(nil),
		(*GateNode_Signal)(nil),
		(*GateNode_Sleep)(nil),
	}
	file_flyteidl_core_workflow_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*ArrayNode_Parallelism)(nil),
		(*ArrayNode_MinSuccesses)(nil),
		(*ArrayNode_MinSuccessRatio)(nil),
	}
	file_flyteidl_core_workflow_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*NodeMetadata_Interruptible)(nil),
		(*NodeMetadata_Cacheable)(nil),
		(*NodeMetadata_CacheVersion)(nil),
		(*NodeMetadata_CacheSerializable)(nil),
	}
	file_flyteidl_core_workflow_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*Node_TaskNode)(nil),
		(*Node_WorkflowNode)(nil),
		(*Node_BranchNode)(nil),
		(*Node_GateNode)(nil),
		(*Node_ArrayNode)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_flyteidl_core_workflow_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_flyteidl_core_workflow_proto_goTypes,
		DependencyIndexes: file_flyteidl_core_workflow_proto_depIdxs,
		EnumInfos:         file_flyteidl_core_workflow_proto_enumTypes,
		MessageInfos:      file_flyteidl_core_workflow_proto_msgTypes,
	}.Build()
	File_flyteidl_core_workflow_proto = out.File
	file_flyteidl_core_workflow_proto_rawDesc = nil
	file_flyteidl_core_workflow_proto_goTypes = nil
	file_flyteidl_core_workflow_proto_depIdxs = nil
}
