// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        (unknown)
// source: flyteidl/admin/node_execution.proto

package admin

import (
	core "github.com/flyteorg/flyte/flyteidl/gen/pb-go/flyteidl/core"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A message used to fetch a single node execution entity.
// See :ref:`ref_flyteidl.admin.NodeExecution` for more details
type NodeExecutionGetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Uniquely identifies an individual node execution.
	// +required
	Id *core.NodeExecutionIdentifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *NodeExecutionGetRequest) Reset() {
	*x = NodeExecutionGetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_node_execution_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeExecutionGetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeExecutionGetRequest) ProtoMessage() {}

func (x *NodeExecutionGetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_node_execution_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeExecutionGetRequest.ProtoReflect.Descriptor instead.
func (*NodeExecutionGetRequest) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_node_execution_proto_rawDescGZIP(), []int{0}
}

func (x *NodeExecutionGetRequest) GetId() *core.NodeExecutionIdentifier {
	if x != nil {
		return x.Id
	}
	return nil
}

// Represents a request structure to retrieve a list of node execution entities.
// See :ref:`ref_flyteidl.admin.NodeExecution` for more details
type NodeExecutionListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates the workflow execution to filter by.
	// +required
	WorkflowExecutionId *core.WorkflowExecutionIdentifier `protobuf:"bytes,1,opt,name=workflow_execution_id,json=workflowExecutionId,proto3" json:"workflow_execution_id,omitempty"`
	// Indicates the number of resources to be returned.
	// +required
	Limit uint32 `protobuf:"varint,2,opt,name=limit,proto3" json:"limit,omitempty"`
	Token string `protobuf:"bytes,3,opt,name=token,proto3" json:"token,omitempty"`
	// Indicates a list of filters passed as string.
	// More info on constructing filters : <Link>
	// +optional
	Filters string `protobuf:"bytes,4,opt,name=filters,proto3" json:"filters,omitempty"`
	// Sort ordering.
	// +optional
	SortBy *Sort `protobuf:"bytes,5,opt,name=sort_by,json=sortBy,proto3" json:"sort_by,omitempty"`
	// Unique identifier of the parent node in the execution
	// +optional
	UniqueParentId string `protobuf:"bytes,6,opt,name=unique_parent_id,json=uniqueParentId,proto3" json:"unique_parent_id,omitempty"`
}

func (x *NodeExecutionListRequest) Reset() {
	*x = NodeExecutionListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_node_execution_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeExecutionListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeExecutionListRequest) ProtoMessage() {}

func (x *NodeExecutionListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_node_execution_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeExecutionListRequest.ProtoReflect.Descriptor instead.
func (*NodeExecutionListRequest) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_node_execution_proto_rawDescGZIP(), []int{1}
}

func (x *NodeExecutionListRequest) GetWorkflowExecutionId() *core.WorkflowExecutionIdentifier {
	if x != nil {
		return x.WorkflowExecutionId
	}
	return nil
}

func (x *NodeExecutionListRequest) GetLimit() uint32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *NodeExecutionListRequest) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *NodeExecutionListRequest) GetFilters() string {
	if x != nil {
		return x.Filters
	}
	return ""
}

func (x *NodeExecutionListRequest) GetSortBy() *Sort {
	if x != nil {
		return x.SortBy
	}
	return nil
}

func (x *NodeExecutionListRequest) GetUniqueParentId() string {
	if x != nil {
		return x.UniqueParentId
	}
	return ""
}

// Represents a request structure to retrieve a list of node execution entities launched by a specific task.
// This can arise when a task yields a subworkflow.
type NodeExecutionForTaskListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates the node execution to filter by.
	// +required
	TaskExecutionId *core.TaskExecutionIdentifier `protobuf:"bytes,1,opt,name=task_execution_id,json=taskExecutionId,proto3" json:"task_execution_id,omitempty"`
	// Indicates the number of resources to be returned.
	// +required
	Limit uint32 `protobuf:"varint,2,opt,name=limit,proto3" json:"limit,omitempty"`
	// In the case of multiple pages of results, the, server-provided token can be used to fetch the next page
	// in a query.
	// +optional
	Token string `protobuf:"bytes,3,opt,name=token,proto3" json:"token,omitempty"`
	// Indicates a list of filters passed as string.
	// More info on constructing filters : <Link>
	// +optional
	Filters string `protobuf:"bytes,4,opt,name=filters,proto3" json:"filters,omitempty"`
	// Sort ordering.
	// +optional
	SortBy *Sort `protobuf:"bytes,5,opt,name=sort_by,json=sortBy,proto3" json:"sort_by,omitempty"`
}

func (x *NodeExecutionForTaskListRequest) Reset() {
	*x = NodeExecutionForTaskListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_node_execution_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeExecutionForTaskListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeExecutionForTaskListRequest) ProtoMessage() {}

func (x *NodeExecutionForTaskListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_node_execution_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeExecutionForTaskListRequest.ProtoReflect.Descriptor instead.
func (*NodeExecutionForTaskListRequest) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_node_execution_proto_rawDescGZIP(), []int{2}
}

func (x *NodeExecutionForTaskListRequest) GetTaskExecutionId() *core.TaskExecutionIdentifier {
	if x != nil {
		return x.TaskExecutionId
	}
	return nil
}

func (x *NodeExecutionForTaskListRequest) GetLimit() uint32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *NodeExecutionForTaskListRequest) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *NodeExecutionForTaskListRequest) GetFilters() string {
	if x != nil {
		return x.Filters
	}
	return ""
}

func (x *NodeExecutionForTaskListRequest) GetSortBy() *Sort {
	if x != nil {
		return x.SortBy
	}
	return nil
}

// Encapsulates all details for a single node execution entity.
// A node represents a component in the overall workflow graph. A node launch a task, multiple tasks, an entire nested
// sub-workflow, or even a separate child-workflow execution.
// The same task can be called repeatedly in a single workflow but each node is unique.
type NodeExecution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Uniquely identifies an individual node execution.
	Id *core.NodeExecutionIdentifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Path to remote data store where input blob is stored.
	InputUri string `protobuf:"bytes,2,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Computed results associated with this node execution.
	Closure *NodeExecutionClosure `protobuf:"bytes,3,opt,name=closure,proto3" json:"closure,omitempty"`
	// Metadata for Node Execution
	Metadata *NodeExecutionMetaData `protobuf:"bytes,4,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *NodeExecution) Reset() {
	*x = NodeExecution{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_node_execution_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeExecution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeExecution) ProtoMessage() {}

func (x *NodeExecution) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_node_execution_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeExecution.ProtoReflect.Descriptor instead.
func (*NodeExecution) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_node_execution_proto_rawDescGZIP(), []int{3}
}

func (x *NodeExecution) GetId() *core.NodeExecutionIdentifier {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *NodeExecution) GetInputUri() string {
	if x != nil {
		return x.InputUri
	}
	return ""
}

func (x *NodeExecution) GetClosure() *NodeExecutionClosure {
	if x != nil {
		return x.Closure
	}
	return nil
}

func (x *NodeExecution) GetMetadata() *NodeExecutionMetaData {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// Represents additional attributes related to a Node Execution
type NodeExecutionMetaData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Node executions are grouped depending on retries of the parent
	// Retry group is unique within the context of a parent node.
	RetryGroup string `protobuf:"bytes,1,opt,name=retry_group,json=retryGroup,proto3" json:"retry_group,omitempty"`
	// Boolean flag indicating if the node has child nodes under it
	// This can be true when a node contains a dynamic workflow which then produces
	// child nodes.
	IsParentNode bool `protobuf:"varint,2,opt,name=is_parent_node,json=isParentNode,proto3" json:"is_parent_node,omitempty"`
	// Node id of the node in the original workflow
	// This maps to value of WorkflowTemplate.nodes[X].id
	SpecNodeId string `protobuf:"bytes,3,opt,name=spec_node_id,json=specNodeId,proto3" json:"spec_node_id,omitempty"`
	// Boolean flag indicating if the node has contains a dynamic workflow which then produces child nodes.
	// This is to distinguish between subworkflows and dynamic workflows which can both have is_parent_node as true.
	IsDynamic bool `protobuf:"varint,4,opt,name=is_dynamic,json=isDynamic,proto3" json:"is_dynamic,omitempty"`
	// Boolean flag indicating if the node is an array node. This is intended to uniquely identify
	// array nodes from other nodes which can have is_parent_node as true.
	IsArray bool `protobuf:"varint,5,opt,name=is_array,json=isArray,proto3" json:"is_array,omitempty"`
	// Whether this node is an eager node.
	IsEager bool `protobuf:"varint,6,opt,name=is_eager,json=isEager,proto3" json:"is_eager,omitempty"`
}

func (x *NodeExecutionMetaData) Reset() {
	*x = NodeExecutionMetaData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_node_execution_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeExecutionMetaData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeExecutionMetaData) ProtoMessage() {}

func (x *NodeExecutionMetaData) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_node_execution_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeExecutionMetaData.ProtoReflect.Descriptor instead.
func (*NodeExecutionMetaData) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_node_execution_proto_rawDescGZIP(), []int{4}
}

func (x *NodeExecutionMetaData) GetRetryGroup() string {
	if x != nil {
		return x.RetryGroup
	}
	return ""
}

func (x *NodeExecutionMetaData) GetIsParentNode() bool {
	if x != nil {
		return x.IsParentNode
	}
	return false
}

func (x *NodeExecutionMetaData) GetSpecNodeId() string {
	if x != nil {
		return x.SpecNodeId
	}
	return ""
}

func (x *NodeExecutionMetaData) GetIsDynamic() bool {
	if x != nil {
		return x.IsDynamic
	}
	return false
}

func (x *NodeExecutionMetaData) GetIsArray() bool {
	if x != nil {
		return x.IsArray
	}
	return false
}

func (x *NodeExecutionMetaData) GetIsEager() bool {
	if x != nil {
		return x.IsEager
	}
	return false
}

// Request structure to retrieve a list of node execution entities.
// See :ref:`ref_flyteidl.admin.NodeExecution` for more details
type NodeExecutionList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	NodeExecutions []*NodeExecution `protobuf:"bytes,1,rep,name=node_executions,json=nodeExecutions,proto3" json:"node_executions,omitempty"`
	// In the case of multiple pages of results, the server-provided token can be used to fetch the next page
	// in a query. If there are no more results, this value will be empty.
	Token string `protobuf:"bytes,2,opt,name=token,proto3" json:"token,omitempty"`
}

func (x *NodeExecutionList) Reset() {
	*x = NodeExecutionList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_node_execution_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeExecutionList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeExecutionList) ProtoMessage() {}

func (x *NodeExecutionList) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_node_execution_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeExecutionList.ProtoReflect.Descriptor instead.
func (*NodeExecutionList) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_node_execution_proto_rawDescGZIP(), []int{5}
}

func (x *NodeExecutionList) GetNodeExecutions() []*NodeExecution {
	if x != nil {
		return x.NodeExecutions
	}
	return nil
}

func (x *NodeExecutionList) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

// Container for node execution details and results.
type NodeExecutionClosure struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Only a node in a terminal state will have a non-empty output_result.
	//
	// Types that are assignable to OutputResult:
	//
	//	*NodeExecutionClosure_OutputUri
	//	*NodeExecutionClosure_Error
	//	*NodeExecutionClosure_OutputData
	OutputResult isNodeExecutionClosure_OutputResult `protobuf_oneof:"output_result"`
	// The last recorded phase for this node execution.
	Phase core.NodeExecution_Phase `protobuf:"varint,3,opt,name=phase,proto3,enum=flyteidl.core.NodeExecution_Phase" json:"phase,omitempty"`
	// Time at which the node execution began running.
	StartedAt *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=started_at,json=startedAt,proto3" json:"started_at,omitempty"`
	// The amount of time the node execution spent running.
	Duration *durationpb.Duration `protobuf:"bytes,5,opt,name=duration,proto3" json:"duration,omitempty"`
	// Time at which the node execution was created.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Time at which the node execution was last updated.
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// Store metadata for what the node launched.
	// for ex: if this is a workflow node, we store information for the launched workflow.
	//
	// Types that are assignable to TargetMetadata:
	//
	//	*NodeExecutionClosure_WorkflowNodeMetadata
	//	*NodeExecutionClosure_TaskNodeMetadata
	TargetMetadata isNodeExecutionClosure_TargetMetadata `protobuf_oneof:"target_metadata"`
	// String location uniquely identifying where the deck HTML file is.
	// NativeUrl specifies the url in the format of the configured storage provider (e.g. s3://my-bucket/randomstring/suffix.tar)
	DeckUri string `protobuf:"bytes,11,opt,name=deck_uri,json=deckUri,proto3" json:"deck_uri,omitempty"`
	// dynamic_job_spec_uri is the location of the DynamicJobSpec proto message for a DynamicWorkflow. This is required
	// to correctly recover partially completed executions where the subworkflow has already been compiled.
	DynamicJobSpecUri string `protobuf:"bytes,12,opt,name=dynamic_job_spec_uri,json=dynamicJobSpecUri,proto3" json:"dynamic_job_spec_uri,omitempty"`
}

func (x *NodeExecutionClosure) Reset() {
	*x = NodeExecutionClosure{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_node_execution_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeExecutionClosure) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeExecutionClosure) ProtoMessage() {}

func (x *NodeExecutionClosure) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_node_execution_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeExecutionClosure.ProtoReflect.Descriptor instead.
func (*NodeExecutionClosure) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_node_execution_proto_rawDescGZIP(), []int{6}
}

func (m *NodeExecutionClosure) GetOutputResult() isNodeExecutionClosure_OutputResult {
	if m != nil {
		return m.OutputResult
	}
	return nil
}

// Deprecated: Marked as deprecated in flyteidl/admin/node_execution.proto.
func (x *NodeExecutionClosure) GetOutputUri() string {
	if x, ok := x.GetOutputResult().(*NodeExecutionClosure_OutputUri); ok {
		return x.OutputUri
	}
	return ""
}

func (x *NodeExecutionClosure) GetError() *core.ExecutionError {
	if x, ok := x.GetOutputResult().(*NodeExecutionClosure_Error); ok {
		return x.Error
	}
	return nil
}

// Deprecated: Marked as deprecated in flyteidl/admin/node_execution.proto.
func (x *NodeExecutionClosure) GetOutputData() *core.LiteralMap {
	if x, ok := x.GetOutputResult().(*NodeExecutionClosure_OutputData); ok {
		return x.OutputData
	}
	return nil
}

func (x *NodeExecutionClosure) GetPhase() core.NodeExecution_Phase {
	if x != nil {
		return x.Phase
	}
	return core.NodeExecution_Phase(0)
}

func (x *NodeExecutionClosure) GetStartedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.StartedAt
	}
	return nil
}

func (x *NodeExecutionClosure) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *NodeExecutionClosure) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *NodeExecutionClosure) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

func (m *NodeExecutionClosure) GetTargetMetadata() isNodeExecutionClosure_TargetMetadata {
	if m != nil {
		return m.TargetMetadata
	}
	return nil
}

func (x *NodeExecutionClosure) GetWorkflowNodeMetadata() *WorkflowNodeMetadata {
	if x, ok := x.GetTargetMetadata().(*NodeExecutionClosure_WorkflowNodeMetadata); ok {
		return x.WorkflowNodeMetadata
	}
	return nil
}

func (x *NodeExecutionClosure) GetTaskNodeMetadata() *TaskNodeMetadata {
	if x, ok := x.GetTargetMetadata().(*NodeExecutionClosure_TaskNodeMetadata); ok {
		return x.TaskNodeMetadata
	}
	return nil
}

func (x *NodeExecutionClosure) GetDeckUri() string {
	if x != nil {
		return x.DeckUri
	}
	return ""
}

func (x *NodeExecutionClosure) GetDynamicJobSpecUri() string {
	if x != nil {
		return x.DynamicJobSpecUri
	}
	return ""
}

type isNodeExecutionClosure_OutputResult interface {
	isNodeExecutionClosure_OutputResult()
}

type NodeExecutionClosure_OutputUri struct {
	// Links to a remotely stored, serialized core.LiteralMap of node execution outputs.
	// DEPRECATED. Use GetNodeExecutionData to fetch output data instead.
	//
	// Deprecated: Marked as deprecated in flyteidl/admin/node_execution.proto.
	OutputUri string `protobuf:"bytes,1,opt,name=output_uri,json=outputUri,proto3,oneof"`
}

type NodeExecutionClosure_Error struct {
	// Error information for the Node
	Error *core.ExecutionError `protobuf:"bytes,2,opt,name=error,proto3,oneof"`
}

type NodeExecutionClosure_OutputData struct {
	// Raw output data produced by this node execution.
	// DEPRECATED. Use GetNodeExecutionData to fetch output data instead.
	//
	// Deprecated: Marked as deprecated in flyteidl/admin/node_execution.proto.
	OutputData *core.LiteralMap `protobuf:"bytes,10,opt,name=output_data,json=outputData,proto3,oneof"`
}

func (*NodeExecutionClosure_OutputUri) isNodeExecutionClosure_OutputResult() {}

func (*NodeExecutionClosure_Error) isNodeExecutionClosure_OutputResult() {}

func (*NodeExecutionClosure_OutputData) isNodeExecutionClosure_OutputResult() {}

type isNodeExecutionClosure_TargetMetadata interface {
	isNodeExecutionClosure_TargetMetadata()
}

type NodeExecutionClosure_WorkflowNodeMetadata struct {
	WorkflowNodeMetadata *WorkflowNodeMetadata `protobuf:"bytes,8,opt,name=workflow_node_metadata,json=workflowNodeMetadata,proto3,oneof"`
}

type NodeExecutionClosure_TaskNodeMetadata struct {
	TaskNodeMetadata *TaskNodeMetadata `protobuf:"bytes,9,opt,name=task_node_metadata,json=taskNodeMetadata,proto3,oneof"`
}

func (*NodeExecutionClosure_WorkflowNodeMetadata) isNodeExecutionClosure_TargetMetadata() {}

func (*NodeExecutionClosure_TaskNodeMetadata) isNodeExecutionClosure_TargetMetadata() {}

// Metadata for a WorkflowNode
type WorkflowNodeMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifier for a workflow execution launched by a node.
	ExecutionId *core.WorkflowExecutionIdentifier `protobuf:"bytes,1,opt,name=executionId,proto3" json:"executionId,omitempty"`
}

func (x *WorkflowNodeMetadata) Reset() {
	*x = WorkflowNodeMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_node_execution_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkflowNodeMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkflowNodeMetadata) ProtoMessage() {}

func (x *WorkflowNodeMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_node_execution_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkflowNodeMetadata.ProtoReflect.Descriptor instead.
func (*WorkflowNodeMetadata) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_node_execution_proto_rawDescGZIP(), []int{7}
}

func (x *WorkflowNodeMetadata) GetExecutionId() *core.WorkflowExecutionIdentifier {
	if x != nil {
		return x.ExecutionId
	}
	return nil
}

// Metadata for the case in which the node is a TaskNode
type TaskNodeMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Captures the status of caching for this execution.
	CacheStatus core.CatalogCacheStatus `protobuf:"varint,1,opt,name=cache_status,json=cacheStatus,proto3,enum=flyteidl.core.CatalogCacheStatus" json:"cache_status,omitempty"`
	// This structure carries the catalog artifact information
	CatalogKey *core.CatalogMetadata `protobuf:"bytes,2,opt,name=catalog_key,json=catalogKey,proto3" json:"catalog_key,omitempty"`
	// The latest checkpoint location
	CheckpointUri string `protobuf:"bytes,4,opt,name=checkpoint_uri,json=checkpointUri,proto3" json:"checkpoint_uri,omitempty"`
}

func (x *TaskNodeMetadata) Reset() {
	*x = TaskNodeMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_node_execution_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TaskNodeMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaskNodeMetadata) ProtoMessage() {}

func (x *TaskNodeMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_node_execution_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaskNodeMetadata.ProtoReflect.Descriptor instead.
func (*TaskNodeMetadata) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_node_execution_proto_rawDescGZIP(), []int{8}
}

func (x *TaskNodeMetadata) GetCacheStatus() core.CatalogCacheStatus {
	if x != nil {
		return x.CacheStatus
	}
	return core.CatalogCacheStatus(0)
}

func (x *TaskNodeMetadata) GetCatalogKey() *core.CatalogMetadata {
	if x != nil {
		return x.CatalogKey
	}
	return nil
}

func (x *TaskNodeMetadata) GetCheckpointUri() string {
	if x != nil {
		return x.CheckpointUri
	}
	return ""
}

// For dynamic workflow nodes we capture information about the dynamic workflow definition that gets generated.
type DynamicWorkflowNodeMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// id represents the unique identifier of the workflow.
	Id *core.Identifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Represents the compiled representation of the embedded dynamic workflow.
	CompiledWorkflow *core.CompiledWorkflowClosure `protobuf:"bytes,2,opt,name=compiled_workflow,json=compiledWorkflow,proto3" json:"compiled_workflow,omitempty"`
	// dynamic_job_spec_uri is the location of the DynamicJobSpec proto message for this DynamicWorkflow. This is
	// required to correctly recover partially completed executions where the subworkflow has already been compiled.
	DynamicJobSpecUri string `protobuf:"bytes,3,opt,name=dynamic_job_spec_uri,json=dynamicJobSpecUri,proto3" json:"dynamic_job_spec_uri,omitempty"`
}

func (x *DynamicWorkflowNodeMetadata) Reset() {
	*x = DynamicWorkflowNodeMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_node_execution_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DynamicWorkflowNodeMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DynamicWorkflowNodeMetadata) ProtoMessage() {}

func (x *DynamicWorkflowNodeMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_node_execution_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DynamicWorkflowNodeMetadata.ProtoReflect.Descriptor instead.
func (*DynamicWorkflowNodeMetadata) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_node_execution_proto_rawDescGZIP(), []int{9}
}

func (x *DynamicWorkflowNodeMetadata) GetId() *core.Identifier {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *DynamicWorkflowNodeMetadata) GetCompiledWorkflow() *core.CompiledWorkflowClosure {
	if x != nil {
		return x.CompiledWorkflow
	}
	return nil
}

func (x *DynamicWorkflowNodeMetadata) GetDynamicJobSpecUri() string {
	if x != nil {
		return x.DynamicJobSpecUri
	}
	return ""
}

// Request structure to fetch inputs and output for a node execution.
// By default, these are not returned in :ref:`ref_flyteidl.admin.NodeExecutionGetRequest`
type NodeExecutionGetDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifier of the node execution for which to fetch inputs and outputs.
	Id *core.NodeExecutionIdentifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *NodeExecutionGetDataRequest) Reset() {
	*x = NodeExecutionGetDataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_node_execution_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeExecutionGetDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeExecutionGetDataRequest) ProtoMessage() {}

func (x *NodeExecutionGetDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_node_execution_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeExecutionGetDataRequest.ProtoReflect.Descriptor instead.
func (*NodeExecutionGetDataRequest) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_node_execution_proto_rawDescGZIP(), []int{10}
}

func (x *NodeExecutionGetDataRequest) GetId() *core.NodeExecutionIdentifier {
	if x != nil {
		return x.Id
	}
	return nil
}

// Response structure for NodeExecutionGetDataRequest which contains inputs and outputs for a node execution.
type NodeExecutionGetDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Signed url to fetch a core.LiteralMap of node execution inputs.
	// Deprecated: Please use full_inputs instead.
	//
	// Deprecated: Marked as deprecated in flyteidl/admin/node_execution.proto.
	Inputs *UrlBlob `protobuf:"bytes,1,opt,name=inputs,proto3" json:"inputs,omitempty"`
	// Signed url to fetch a core.LiteralMap of node execution outputs.
	// Deprecated: Please use full_outputs instead.
	//
	// Deprecated: Marked as deprecated in flyteidl/admin/node_execution.proto.
	Outputs *UrlBlob `protobuf:"bytes,2,opt,name=outputs,proto3" json:"outputs,omitempty"`
	// Full_inputs will only be populated if they are under a configured size threshold.
	FullInputs *core.LiteralMap `protobuf:"bytes,3,opt,name=full_inputs,json=fullInputs,proto3" json:"full_inputs,omitempty"`
	// Full_outputs will only be populated if they are under a configured size threshold.
	FullOutputs *core.LiteralMap `protobuf:"bytes,4,opt,name=full_outputs,json=fullOutputs,proto3" json:"full_outputs,omitempty"`
	// Optional Workflow closure for a dynamically generated workflow, in the case this node yields a dynamic workflow we return its structure here.
	DynamicWorkflow *DynamicWorkflowNodeMetadata `protobuf:"bytes,16,opt,name=dynamic_workflow,json=dynamicWorkflow,proto3" json:"dynamic_workflow,omitempty"`
	FlyteUrls       *FlyteURLs                   `protobuf:"bytes,17,opt,name=flyte_urls,json=flyteUrls,proto3" json:"flyte_urls,omitempty"`
}

func (x *NodeExecutionGetDataResponse) Reset() {
	*x = NodeExecutionGetDataResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_node_execution_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeExecutionGetDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeExecutionGetDataResponse) ProtoMessage() {}

func (x *NodeExecutionGetDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_node_execution_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeExecutionGetDataResponse.ProtoReflect.Descriptor instead.
func (*NodeExecutionGetDataResponse) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_node_execution_proto_rawDescGZIP(), []int{11}
}

// Deprecated: Marked as deprecated in flyteidl/admin/node_execution.proto.
func (x *NodeExecutionGetDataResponse) GetInputs() *UrlBlob {
	if x != nil {
		return x.Inputs
	}
	return nil
}

// Deprecated: Marked as deprecated in flyteidl/admin/node_execution.proto.
func (x *NodeExecutionGetDataResponse) GetOutputs() *UrlBlob {
	if x != nil {
		return x.Outputs
	}
	return nil
}

func (x *NodeExecutionGetDataResponse) GetFullInputs() *core.LiteralMap {
	if x != nil {
		return x.FullInputs
	}
	return nil
}

func (x *NodeExecutionGetDataResponse) GetFullOutputs() *core.LiteralMap {
	if x != nil {
		return x.FullOutputs
	}
	return nil
}

func (x *NodeExecutionGetDataResponse) GetDynamicWorkflow() *DynamicWorkflowNodeMetadata {
	if x != nil {
		return x.DynamicWorkflow
	}
	return nil
}

func (x *NodeExecutionGetDataResponse) GetFlyteUrls() *FlyteURLs {
	if x != nil {
		return x.FlyteUrls
	}
	return nil
}

type GetDynamicNodeWorkflowRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id *core.NodeExecutionIdentifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *GetDynamicNodeWorkflowRequest) Reset() {
	*x = GetDynamicNodeWorkflowRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_node_execution_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDynamicNodeWorkflowRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDynamicNodeWorkflowRequest) ProtoMessage() {}

func (x *GetDynamicNodeWorkflowRequest) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_node_execution_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDynamicNodeWorkflowRequest.ProtoReflect.Descriptor instead.
func (*GetDynamicNodeWorkflowRequest) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_node_execution_proto_rawDescGZIP(), []int{12}
}

func (x *GetDynamicNodeWorkflowRequest) GetId() *core.NodeExecutionIdentifier {
	if x != nil {
		return x.Id
	}
	return nil
}

type DynamicNodeWorkflowResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CompiledWorkflow *core.CompiledWorkflowClosure `protobuf:"bytes,1,opt,name=compiled_workflow,json=compiledWorkflow,proto3" json:"compiled_workflow,omitempty"`
}

func (x *DynamicNodeWorkflowResponse) Reset() {
	*x = DynamicNodeWorkflowResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_node_execution_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DynamicNodeWorkflowResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DynamicNodeWorkflowResponse) ProtoMessage() {}

func (x *DynamicNodeWorkflowResponse) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_node_execution_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DynamicNodeWorkflowResponse.ProtoReflect.Descriptor instead.
func (*DynamicNodeWorkflowResponse) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_node_execution_proto_rawDescGZIP(), []int{13}
}

func (x *DynamicNodeWorkflowResponse) GetCompiledWorkflow() *core.CompiledWorkflowClosure {
	if x != nil {
		return x.CompiledWorkflow
	}
	return nil
}

var File_flyteidl_admin_node_execution_proto protoreflect.FileDescriptor

var file_flyteidl_admin_node_execution_proto_rawDesc = []byte{
	0x0a, 0x23, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x1a, 0x1b, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1d, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x63, 0x6f, 0x72,
	0x65, 0x2f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1b, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x63, 0x6f, 0x72, 0x65,
	0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x63, 0x6f,
	0x6d, 0x70, 0x69, 0x6c, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x66, 0x6c,
	0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x66, 0x6c,
	0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x6c, 0x69, 0x74, 0x65,
	0x72, 0x61, 0x6c, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x51, 0x0a, 0x17, 0x4e,
	0x6f, 0x64, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x36, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f,
	0x72, 0x65, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x02, 0x69, 0x64, 0x22, 0x99,
	0x02, 0x0a, 0x18, 0x4e, 0x6f, 0x64, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5e, 0x0a, 0x15, 0x77,
	0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x66, 0x6c, 0x79,
	0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66,
	0x6c, 0x6f, 0x77, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x13, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69,
	0x74, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x73, 0x12, 0x2d, 0x0a, 0x07, 0x73, 0x6f, 0x72, 0x74, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x53, 0x6f, 0x72, 0x74, 0x52, 0x06, 0x73, 0x6f, 0x72, 0x74, 0x42, 0x79,
	0x12, 0x28, 0x0a, 0x10, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x75, 0x6e, 0x69, 0x71,
	0x75, 0x65, 0x50, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x22, 0xea, 0x01, 0x0a, 0x1f, 0x4e,
	0x6f, 0x64, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x6f, 0x72, 0x54,
	0x61, 0x73, 0x6b, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52,
	0x0a, 0x11, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x66, 0x6c, 0x79, 0x74,
	0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x52, 0x0f, 0x74, 0x61, 0x73, 0x6b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x18,
	0x0a, 0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x2d, 0x0a, 0x07, 0x73, 0x6f, 0x72, 0x74,
	0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x66, 0x6c, 0x79, 0x74,
	0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x53, 0x6f, 0x72, 0x74, 0x52,
	0x06, 0x73, 0x6f, 0x72, 0x74, 0x42, 0x79, 0x22, 0xe7, 0x01, 0x0a, 0x0d, 0x4e, 0x6f, 0x64, 0x65,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c,
	0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x12, 0x3e,
	0x0a, 0x07, 0x63, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c,
	0x6f, 0x73, 0x75, 0x72, 0x65, 0x52, 0x07, 0x63, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x12, 0x41,
	0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x44, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x22, 0xd5, 0x01, 0x0a, 0x15, 0x4e, 0x6f, 0x64, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x44, 0x61, 0x74, 0x61, 0x12, 0x1f, 0x0a, 0x0b, 0x72,
	0x65, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x72, 0x65, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x24, 0x0a, 0x0e,
	0x69, 0x73, 0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x69, 0x73, 0x50, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x4e, 0x6f,
	0x64, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x70, 0x65, 0x63, 0x4e, 0x6f,
	0x64, 0x65, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x73, 0x5f, 0x64, 0x79, 0x6e, 0x61, 0x6d,
	0x69, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x69, 0x73, 0x44, 0x79, 0x6e, 0x61,
	0x6d, 0x69, 0x63, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x73, 0x5f, 0x61, 0x72, 0x72, 0x61, 0x79, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x69, 0x73, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x19,
	0x0a, 0x08, 0x69, 0x73, 0x5f, 0x65, 0x61, 0x67, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x07, 0x69, 0x73, 0x45, 0x61, 0x67, 0x65, 0x72, 0x22, 0x71, 0x0a, 0x11, 0x4e, 0x6f, 0x64,
	0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x46,
	0x0a, 0x0f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69,
	0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x6e, 0x6f, 0x64, 0x65, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xf6, 0x05, 0x0a,
	0x14, 0x4e, 0x6f, 0x64, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c,
	0x6f, 0x73, 0x75, 0x72, 0x65, 0x12, 0x23, 0x0a, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52,
	0x09, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x12, 0x35, 0x0a, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x66, 0x6c, 0x79, 0x74,
	0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x12, 0x40, 0x0a, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64,
	0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x4d, 0x61,
	0x70, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x12, 0x38, 0x0a, 0x05, 0x70, 0x68, 0x61, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x22, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f,
	0x72, 0x65, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x50, 0x68, 0x61, 0x73, 0x65, 0x52, 0x05, 0x70, 0x68, 0x61, 0x73, 0x65, 0x12, 0x39, 0x0a,
	0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x39, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x5c, 0x0a, 0x16, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f,
	0x77, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x4e,
	0x6f, 0x64, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x01, 0x52, 0x14, 0x77,
	0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x4e, 0x6f, 0x64, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x50, 0x0a, 0x12, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x6e, 0x6f, 0x64, 0x65,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x20, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x54, 0x61, 0x73, 0x6b, 0x4e, 0x6f, 0x64, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x48, 0x01, 0x52, 0x10, 0x74, 0x61, 0x73, 0x6b, 0x4e, 0x6f, 0x64, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x19, 0x0a, 0x08, 0x64, 0x65, 0x63, 0x6b, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x64, 0x65, 0x63, 0x6b, 0x55, 0x72, 0x69,
	0x12, 0x2f, 0x0a, 0x14, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x6a, 0x6f, 0x62, 0x5f,
	0x73, 0x70, 0x65, 0x63, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11,
	0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4a, 0x6f, 0x62, 0x53, 0x70, 0x65, 0x63, 0x55, 0x72,
	0x69, 0x42, 0x0f, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x42, 0x11, 0x0a, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x64, 0x0a, 0x14, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f,
	0x77, 0x4e, 0x6f, 0x64, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4c, 0x0a,
	0x0b, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f,
	0x72, 0x65, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x0b,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0xc0, 0x01, 0x0a, 0x10,
	0x54, 0x61, 0x73, 0x6b, 0x4e, 0x6f, 0x64, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x44, 0x0a, 0x0c, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64,
	0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x43, 0x61,
	0x63, 0x68, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0b, 0x63, 0x61, 0x63, 0x68, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x3f, 0x0a, 0x0b, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x66, 0x6c,
	0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x43, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0a, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x4b, 0x65, 0x79, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x68, 0x65, 0x63, 0x6b,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x22, 0xce,
	0x01, 0x0a, 0x1b, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c,
	0x6f, 0x77, 0x4e, 0x6f, 0x64, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x29,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x66, 0x6c, 0x79,
	0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x02, 0x69, 0x64, 0x12, 0x53, 0x0a, 0x11, 0x63, 0x6f, 0x6d,
	0x70, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e,
	0x63, 0x6f, 0x72, 0x65, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x64, 0x57, 0x6f, 0x72,
	0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x43, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x52, 0x10, 0x63, 0x6f,
	0x6d, 0x70, 0x69, 0x6c, 0x65, 0x64, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x12, 0x2f,
	0x0a, 0x14, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x64, 0x79,
	0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4a, 0x6f, 0x62, 0x53, 0x70, 0x65, 0x63, 0x55, 0x72, 0x69, 0x22,
	0x55, 0x0a, 0x1b, 0x4e, 0x6f, 0x64, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x36,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x66, 0x6c, 0x79,
	0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x52, 0x02, 0x69, 0x64, 0x22, 0x96, 0x03, 0x0a, 0x1c, 0x4e, 0x6f, 0x64, 0x65, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x33, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69,
	0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x55, 0x72, 0x6c, 0x42, 0x6c, 0x6f, 0x62,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x35, 0x0a, 0x07,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x55,
	0x72, 0x6c, 0x42, 0x6c, 0x6f, 0x62, 0x42, 0x02, 0x18, 0x01, 0x52, 0x07, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x73, 0x12, 0x3a, 0x0a, 0x0b, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65,
	0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c,
	0x4d, 0x61, 0x70, 0x52, 0x0a, 0x66, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12,
	0x3c, 0x0a, 0x0c, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c,
	0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x4d, 0x61, 0x70,
	0x52, 0x0b, 0x66, 0x75, 0x6c, 0x6c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x56, 0x0a,
	0x10, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f,
	0x77, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69,
	0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63,
	0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x4e, 0x6f, 0x64, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x57, 0x6f, 0x72,
	0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x12, 0x38, 0x0a, 0x0a, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x5f, 0x75,
	0x72, 0x6c, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x66, 0x6c, 0x79, 0x74,
	0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x46, 0x6c, 0x79, 0x74, 0x65,
	0x55, 0x52, 0x4c, 0x73, 0x52, 0x09, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x55, 0x72, 0x6c, 0x73, 0x22,
	0x57, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x4e, 0x6f, 0x64,
	0x65, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x36, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x66,
	0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x4e, 0x6f, 0x64,
	0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x52, 0x02, 0x69, 0x64, 0x22, 0x72, 0x0a, 0x1b, 0x44, 0x79, 0x6e, 0x61,
	0x6d, 0x69, 0x63, 0x4e, 0x6f, 0x64, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a, 0x11, 0x63, 0x6f, 0x6d, 0x70, 0x69,
	0x6c, 0x65, 0x64, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f,
	0x72, 0x65, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x64, 0x57, 0x6f, 0x72, 0x6b, 0x66,
	0x6c, 0x6f, 0x77, 0x43, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x52, 0x10, 0x63, 0x6f, 0x6d, 0x70,
	0x69, 0x6c, 0x65, 0x64, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0xbe, 0x01, 0x0a,
	0x12, 0x63, 0x6f, 0x6d, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x42, 0x12, 0x4e, 0x6f, 0x64, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x67, 0x69, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x6f, 0x72, 0x67, 0x2f, 0x66,
	0x6c, 0x79, 0x74, 0x65, 0x2f, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x67, 0x65,
	0x6e, 0x2f, 0x70, 0x62, 0x2d, 0x67, 0x6f, 0x2f, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c,
	0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0xa2, 0x02, 0x03, 0x46, 0x41, 0x58, 0xaa, 0x02, 0x0e, 0x46,
	0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0xca, 0x02, 0x0e,
	0x46, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x5c, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0xe2, 0x02,
	0x1a, 0x46, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x5c, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x5c,
	0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x0f, 0x46, 0x6c,
	0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x3a, 0x3a, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_flyteidl_admin_node_execution_proto_rawDescOnce sync.Once
	file_flyteidl_admin_node_execution_proto_rawDescData = file_flyteidl_admin_node_execution_proto_rawDesc
)

func file_flyteidl_admin_node_execution_proto_rawDescGZIP() []byte {
	file_flyteidl_admin_node_execution_proto_rawDescOnce.Do(func() {
		file_flyteidl_admin_node_execution_proto_rawDescData = protoimpl.X.CompressGZIP(file_flyteidl_admin_node_execution_proto_rawDescData)
	})
	return file_flyteidl_admin_node_execution_proto_rawDescData
}

var file_flyteidl_admin_node_execution_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_flyteidl_admin_node_execution_proto_goTypes = []interface{}{
	(*NodeExecutionGetRequest)(nil),          // 0: flyteidl.admin.NodeExecutionGetRequest
	(*NodeExecutionListRequest)(nil),         // 1: flyteidl.admin.NodeExecutionListRequest
	(*NodeExecutionForTaskListRequest)(nil),  // 2: flyteidl.admin.NodeExecutionForTaskListRequest
	(*NodeExecution)(nil),                    // 3: flyteidl.admin.NodeExecution
	(*NodeExecutionMetaData)(nil),            // 4: flyteidl.admin.NodeExecutionMetaData
	(*NodeExecutionList)(nil),                // 5: flyteidl.admin.NodeExecutionList
	(*NodeExecutionClosure)(nil),             // 6: flyteidl.admin.NodeExecutionClosure
	(*WorkflowNodeMetadata)(nil),             // 7: flyteidl.admin.WorkflowNodeMetadata
	(*TaskNodeMetadata)(nil),                 // 8: flyteidl.admin.TaskNodeMetadata
	(*DynamicWorkflowNodeMetadata)(nil),      // 9: flyteidl.admin.DynamicWorkflowNodeMetadata
	(*NodeExecutionGetDataRequest)(nil),      // 10: flyteidl.admin.NodeExecutionGetDataRequest
	(*NodeExecutionGetDataResponse)(nil),     // 11: flyteidl.admin.NodeExecutionGetDataResponse
	(*GetDynamicNodeWorkflowRequest)(nil),    // 12: flyteidl.admin.GetDynamicNodeWorkflowRequest
	(*DynamicNodeWorkflowResponse)(nil),      // 13: flyteidl.admin.DynamicNodeWorkflowResponse
	(*core.NodeExecutionIdentifier)(nil),     // 14: flyteidl.core.NodeExecutionIdentifier
	(*core.WorkflowExecutionIdentifier)(nil), // 15: flyteidl.core.WorkflowExecutionIdentifier
	(*Sort)(nil),                             // 16: flyteidl.admin.Sort
	(*core.TaskExecutionIdentifier)(nil),     // 17: flyteidl.core.TaskExecutionIdentifier
	(*core.ExecutionError)(nil),              // 18: flyteidl.core.ExecutionError
	(*core.LiteralMap)(nil),                  // 19: flyteidl.core.LiteralMap
	(core.NodeExecution_Phase)(0),            // 20: flyteidl.core.NodeExecution.Phase
	(*timestamppb.Timestamp)(nil),            // 21: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),              // 22: google.protobuf.Duration
	(core.CatalogCacheStatus)(0),             // 23: flyteidl.core.CatalogCacheStatus
	(*core.CatalogMetadata)(nil),             // 24: flyteidl.core.CatalogMetadata
	(*core.Identifier)(nil),                  // 25: flyteidl.core.Identifier
	(*core.CompiledWorkflowClosure)(nil),     // 26: flyteidl.core.CompiledWorkflowClosure
	(*UrlBlob)(nil),                          // 27: flyteidl.admin.UrlBlob
	(*FlyteURLs)(nil),                        // 28: flyteidl.admin.FlyteURLs
}
var file_flyteidl_admin_node_execution_proto_depIdxs = []int32{
	14, // 0: flyteidl.admin.NodeExecutionGetRequest.id:type_name -> flyteidl.core.NodeExecutionIdentifier
	15, // 1: flyteidl.admin.NodeExecutionListRequest.workflow_execution_id:type_name -> flyteidl.core.WorkflowExecutionIdentifier
	16, // 2: flyteidl.admin.NodeExecutionListRequest.sort_by:type_name -> flyteidl.admin.Sort
	17, // 3: flyteidl.admin.NodeExecutionForTaskListRequest.task_execution_id:type_name -> flyteidl.core.TaskExecutionIdentifier
	16, // 4: flyteidl.admin.NodeExecutionForTaskListRequest.sort_by:type_name -> flyteidl.admin.Sort
	14, // 5: flyteidl.admin.NodeExecution.id:type_name -> flyteidl.core.NodeExecutionIdentifier
	6,  // 6: flyteidl.admin.NodeExecution.closure:type_name -> flyteidl.admin.NodeExecutionClosure
	4,  // 7: flyteidl.admin.NodeExecution.metadata:type_name -> flyteidl.admin.NodeExecutionMetaData
	3,  // 8: flyteidl.admin.NodeExecutionList.node_executions:type_name -> flyteidl.admin.NodeExecution
	18, // 9: flyteidl.admin.NodeExecutionClosure.error:type_name -> flyteidl.core.ExecutionError
	19, // 10: flyteidl.admin.NodeExecutionClosure.output_data:type_name -> flyteidl.core.LiteralMap
	20, // 11: flyteidl.admin.NodeExecutionClosure.phase:type_name -> flyteidl.core.NodeExecution.Phase
	21, // 12: flyteidl.admin.NodeExecutionClosure.started_at:type_name -> google.protobuf.Timestamp
	22, // 13: flyteidl.admin.NodeExecutionClosure.duration:type_name -> google.protobuf.Duration
	21, // 14: flyteidl.admin.NodeExecutionClosure.created_at:type_name -> google.protobuf.Timestamp
	21, // 15: flyteidl.admin.NodeExecutionClosure.updated_at:type_name -> google.protobuf.Timestamp
	7,  // 16: flyteidl.admin.NodeExecutionClosure.workflow_node_metadata:type_name -> flyteidl.admin.WorkflowNodeMetadata
	8,  // 17: flyteidl.admin.NodeExecutionClosure.task_node_metadata:type_name -> flyteidl.admin.TaskNodeMetadata
	15, // 18: flyteidl.admin.WorkflowNodeMetadata.executionId:type_name -> flyteidl.core.WorkflowExecutionIdentifier
	23, // 19: flyteidl.admin.TaskNodeMetadata.cache_status:type_name -> flyteidl.core.CatalogCacheStatus
	24, // 20: flyteidl.admin.TaskNodeMetadata.catalog_key:type_name -> flyteidl.core.CatalogMetadata
	25, // 21: flyteidl.admin.DynamicWorkflowNodeMetadata.id:type_name -> flyteidl.core.Identifier
	26, // 22: flyteidl.admin.DynamicWorkflowNodeMetadata.compiled_workflow:type_name -> flyteidl.core.CompiledWorkflowClosure
	14, // 23: flyteidl.admin.NodeExecutionGetDataRequest.id:type_name -> flyteidl.core.NodeExecutionIdentifier
	27, // 24: flyteidl.admin.NodeExecutionGetDataResponse.inputs:type_name -> flyteidl.admin.UrlBlob
	27, // 25: flyteidl.admin.NodeExecutionGetDataResponse.outputs:type_name -> flyteidl.admin.UrlBlob
	19, // 26: flyteidl.admin.NodeExecutionGetDataResponse.full_inputs:type_name -> flyteidl.core.LiteralMap
	19, // 27: flyteidl.admin.NodeExecutionGetDataResponse.full_outputs:type_name -> flyteidl.core.LiteralMap
	9,  // 28: flyteidl.admin.NodeExecutionGetDataResponse.dynamic_workflow:type_name -> flyteidl.admin.DynamicWorkflowNodeMetadata
	28, // 29: flyteidl.admin.NodeExecutionGetDataResponse.flyte_urls:type_name -> flyteidl.admin.FlyteURLs
	14, // 30: flyteidl.admin.GetDynamicNodeWorkflowRequest.id:type_name -> flyteidl.core.NodeExecutionIdentifier
	26, // 31: flyteidl.admin.DynamicNodeWorkflowResponse.compiled_workflow:type_name -> flyteidl.core.CompiledWorkflowClosure
	32, // [32:32] is the sub-list for method output_type
	32, // [32:32] is the sub-list for method input_type
	32, // [32:32] is the sub-list for extension type_name
	32, // [32:32] is the sub-list for extension extendee
	0,  // [0:32] is the sub-list for field type_name
}

func init() { file_flyteidl_admin_node_execution_proto_init() }
func file_flyteidl_admin_node_execution_proto_init() {
	if File_flyteidl_admin_node_execution_proto != nil {
		return
	}
	file_flyteidl_admin_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_flyteidl_admin_node_execution_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeExecutionGetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_node_execution_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeExecutionListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_node_execution_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeExecutionForTaskListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_node_execution_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeExecution); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_node_execution_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeExecutionMetaData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_node_execution_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeExecutionList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_node_execution_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeExecutionClosure); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_node_execution_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkflowNodeMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_node_execution_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TaskNodeMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_node_execution_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DynamicWorkflowNodeMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_node_execution_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeExecutionGetDataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_node_execution_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeExecutionGetDataResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_node_execution_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDynamicNodeWorkflowRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_node_execution_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DynamicNodeWorkflowResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_flyteidl_admin_node_execution_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*NodeExecutionClosure_OutputUri)(nil),
		(*NodeExecutionClosure_Error)(nil),
		(*NodeExecutionClosure_OutputData)(nil),
		(*NodeExecutionClosure_WorkflowNodeMetadata)(nil),
		(*NodeExecutionClosure_TaskNodeMetadata)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_flyteidl_admin_node_execution_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_flyteidl_admin_node_execution_proto_goTypes,
		DependencyIndexes: file_flyteidl_admin_node_execution_proto_depIdxs,
		MessageInfos:      file_flyteidl_admin_node_execution_proto_msgTypes,
	}.Build()
	File_flyteidl_admin_node_execution_proto = out.File
	file_flyteidl_admin_node_execution_proto_rawDesc = nil
	file_flyteidl_admin_node_execution_proto_goTypes = nil
	file_flyteidl_admin_node_execution_proto_depIdxs = nil
}
