// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        (unknown)
// source: flyteidl/admin/launch_plan.proto

package admin

import (
	core "github.com/flyteorg/flyte/flyteidl/gen/pb-go/flyteidl/core"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// By default any launch plan regardless of state can be used to launch a workflow execution.
// However, at most one version of a launch plan
// (e.g. a NamedEntityIdentifier set of shared project, domain and name values) can be
// active at a time in regards to *schedules*. That is, at most one schedule in a NamedEntityIdentifier
// group will be observed and trigger executions at a defined cadence.
type LaunchPlanState int32

const (
	LaunchPlanState_INACTIVE LaunchPlanState = 0
	LaunchPlanState_ACTIVE   LaunchPlanState = 1
)

// Enum value maps for LaunchPlanState.
var (
	LaunchPlanState_name = map[int32]string{
		0: "INACTIVE",
		1: "ACTIVE",
	}
	LaunchPlanState_value = map[string]int32{
		"INACTIVE": 0,
		"ACTIVE":   1,
	}
)

func (x LaunchPlanState) Enum() *LaunchPlanState {
	p := new(LaunchPlanState)
	*p = x
	return p
}

func (x LaunchPlanState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LaunchPlanState) Descriptor() protoreflect.EnumDescriptor {
	return file_flyteidl_admin_launch_plan_proto_enumTypes[0].Descriptor()
}

func (LaunchPlanState) Type() protoreflect.EnumType {
	return &file_flyteidl_admin_launch_plan_proto_enumTypes[0]
}

func (x LaunchPlanState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LaunchPlanState.Descriptor instead.
func (LaunchPlanState) EnumDescriptor() ([]byte, []int) {
	return file_flyteidl_admin_launch_plan_proto_rawDescGZIP(), []int{0}
}

// Request to register a launch plan. The included LaunchPlanSpec may have a complete or incomplete set of inputs required
// to launch a workflow execution. By default all launch plans are registered in state INACTIVE. If you wish to
// set the state to ACTIVE, you must submit a LaunchPlanUpdateRequest, after you have successfully created a launch plan.
type LaunchPlanCreateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Uniquely identifies a launch plan entity.
	Id *core.Identifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// User-provided launch plan details, including reference workflow, inputs and other metadata.
	Spec *LaunchPlanSpec `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
}

func (x *LaunchPlanCreateRequest) Reset() {
	*x = LaunchPlanCreateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LaunchPlanCreateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LaunchPlanCreateRequest) ProtoMessage() {}

func (x *LaunchPlanCreateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LaunchPlanCreateRequest.ProtoReflect.Descriptor instead.
func (*LaunchPlanCreateRequest) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_launch_plan_proto_rawDescGZIP(), []int{0}
}

func (x *LaunchPlanCreateRequest) GetId() *core.Identifier {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *LaunchPlanCreateRequest) GetSpec() *LaunchPlanSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

type LaunchPlanCreateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *LaunchPlanCreateResponse) Reset() {
	*x = LaunchPlanCreateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LaunchPlanCreateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LaunchPlanCreateResponse) ProtoMessage() {}

func (x *LaunchPlanCreateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LaunchPlanCreateResponse.ProtoReflect.Descriptor instead.
func (*LaunchPlanCreateResponse) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_launch_plan_proto_rawDescGZIP(), []int{1}
}

// A LaunchPlan provides the capability to templatize workflow executions.
// Launch plans simplify associating one or more schedules, inputs and notifications with your workflows.
// Launch plans can be shared and used to trigger executions with predefined inputs even when a workflow
// definition doesn't necessarily have a default value for said input.
type LaunchPlan struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Uniquely identifies a launch plan entity.
	Id *core.Identifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// User-provided launch plan details, including reference workflow, inputs and other metadata.
	Spec *LaunchPlanSpec `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	// Values computed by the flyte platform after launch plan registration.
	Closure *LaunchPlanClosure `protobuf:"bytes,3,opt,name=closure,proto3" json:"closure,omitempty"`
}

func (x *LaunchPlan) Reset() {
	*x = LaunchPlan{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LaunchPlan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LaunchPlan) ProtoMessage() {}

func (x *LaunchPlan) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LaunchPlan.ProtoReflect.Descriptor instead.
func (*LaunchPlan) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_launch_plan_proto_rawDescGZIP(), []int{2}
}

func (x *LaunchPlan) GetId() *core.Identifier {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *LaunchPlan) GetSpec() *LaunchPlanSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

func (x *LaunchPlan) GetClosure() *LaunchPlanClosure {
	if x != nil {
		return x.Closure
	}
	return nil
}

// Response object for list launch plan requests.
// See :ref:`ref_flyteidl.admin.LaunchPlan` for more details
type LaunchPlanList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LaunchPlans []*LaunchPlan `protobuf:"bytes,1,rep,name=launch_plans,json=launchPlans,proto3" json:"launch_plans,omitempty"`
	// In the case of multiple pages of results, the server-provided token can be used to fetch the next page
	// in a query. If there are no more results, this value will be empty.
	Token string `protobuf:"bytes,2,opt,name=token,proto3" json:"token,omitempty"`
}

func (x *LaunchPlanList) Reset() {
	*x = LaunchPlanList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LaunchPlanList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LaunchPlanList) ProtoMessage() {}

func (x *LaunchPlanList) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LaunchPlanList.ProtoReflect.Descriptor instead.
func (*LaunchPlanList) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_launch_plan_proto_rawDescGZIP(), []int{3}
}

func (x *LaunchPlanList) GetLaunchPlans() []*LaunchPlan {
	if x != nil {
		return x.LaunchPlans
	}
	return nil
}

func (x *LaunchPlanList) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

// Defines permissions associated with executions created by this launch plan spec.
// Use either of these roles when they have permissions required by your workflow execution.
// Deprecated.
//
// Deprecated: Marked as deprecated in flyteidl/admin/launch_plan.proto.
type Auth struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines an optional iam role which will be used for tasks run in executions created with this launch plan.
	AssumableIamRole string `protobuf:"bytes,1,opt,name=assumable_iam_role,json=assumableIamRole,proto3" json:"assumable_iam_role,omitempty"`
	// Defines an optional kubernetes service account which will be used for tasks run in executions created with this launch plan.
	KubernetesServiceAccount string `protobuf:"bytes,2,opt,name=kubernetes_service_account,json=kubernetesServiceAccount,proto3" json:"kubernetes_service_account,omitempty"`
}

func (x *Auth) Reset() {
	*x = Auth{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Auth) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Auth) ProtoMessage() {}

func (x *Auth) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Auth.ProtoReflect.Descriptor instead.
func (*Auth) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_launch_plan_proto_rawDescGZIP(), []int{4}
}

func (x *Auth) GetAssumableIamRole() string {
	if x != nil {
		return x.AssumableIamRole
	}
	return ""
}

func (x *Auth) GetKubernetesServiceAccount() string {
	if x != nil {
		return x.KubernetesServiceAccount
	}
	return ""
}

// User-provided launch plan definition and configuration values.
type LaunchPlanSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Reference to the Workflow template that the launch plan references
	WorkflowId *core.Identifier `protobuf:"bytes,1,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	// Metadata for the Launch Plan
	EntityMetadata *LaunchPlanMetadata `protobuf:"bytes,2,opt,name=entity_metadata,json=entityMetadata,proto3" json:"entity_metadata,omitempty"`
	// Input values to be passed for the execution.
	// These can be overridden when an execution is created with this launch plan.
	DefaultInputs *core.ParameterMap `protobuf:"bytes,3,opt,name=default_inputs,json=defaultInputs,proto3" json:"default_inputs,omitempty"`
	// Fixed, non-overridable inputs for the Launch Plan.
	// These can not be overridden when an execution is created with this launch plan.
	FixedInputs *core.LiteralMap `protobuf:"bytes,4,opt,name=fixed_inputs,json=fixedInputs,proto3" json:"fixed_inputs,omitempty"`
	// String to indicate the role to use to execute the workflow underneath
	//
	// Deprecated: Marked as deprecated in flyteidl/admin/launch_plan.proto.
	Role string `protobuf:"bytes,5,opt,name=role,proto3" json:"role,omitempty"`
	// Custom labels to be applied to the execution resource.
	Labels *Labels `protobuf:"bytes,6,opt,name=labels,proto3" json:"labels,omitempty"`
	// Custom annotations to be applied to the execution resource.
	Annotations *Annotations `protobuf:"bytes,7,opt,name=annotations,proto3" json:"annotations,omitempty"`
	// Indicates the permission associated with workflow executions triggered with this launch plan.
	//
	// Deprecated: Marked as deprecated in flyteidl/admin/launch_plan.proto.
	Auth *Auth `protobuf:"bytes,8,opt,name=auth,proto3" json:"auth,omitempty"`
	// Deprecated: Marked as deprecated in flyteidl/admin/launch_plan.proto.
	AuthRole *AuthRole `protobuf:"bytes,9,opt,name=auth_role,json=authRole,proto3" json:"auth_role,omitempty"`
	// Indicates security context for permissions triggered with this launch plan
	SecurityContext *core.SecurityContext `protobuf:"bytes,10,opt,name=security_context,json=securityContext,proto3" json:"security_context,omitempty"`
	// Indicates the runtime priority of the execution.
	QualityOfService *core.QualityOfService `protobuf:"bytes,16,opt,name=quality_of_service,json=qualityOfService,proto3" json:"quality_of_service,omitempty"`
	// Encapsulates user settings pertaining to offloaded data (i.e. Blobs, Schema, query data, etc.).
	RawOutputDataConfig *RawOutputDataConfig `protobuf:"bytes,17,opt,name=raw_output_data_config,json=rawOutputDataConfig,proto3" json:"raw_output_data_config,omitempty"`
	// Controls the maximum number of tasknodes that can be run in parallel for the entire workflow.
	// This is useful to achieve fairness. Note: MapTasks are regarded as one unit,
	// and parallelism/concurrency of MapTasks is independent from this.
	MaxParallelism int32 `protobuf:"varint,18,opt,name=max_parallelism,json=maxParallelism,proto3" json:"max_parallelism,omitempty"`
	// Allows for the interruptible flag of a workflow to be overwritten for a single execution.
	// Omitting this field uses the workflow's value as a default.
	// As we need to distinguish between the field not being provided and its default value false, we have to use a wrapper
	// around the bool field.
	Interruptible *wrapperspb.BoolValue `protobuf:"bytes,19,opt,name=interruptible,proto3" json:"interruptible,omitempty"`
	// Allows for all cached values of a workflow and its tasks to be overwritten for a single execution.
	// If enabled, all calculations are performed even if cached results would be available, overwriting the stored
	// data once execution finishes successfully.
	OverwriteCache bool `protobuf:"varint,20,opt,name=overwrite_cache,json=overwriteCache,proto3" json:"overwrite_cache,omitempty"`
	// Environment variables to be set for the execution.
	Envs *Envs `protobuf:"bytes,21,opt,name=envs,proto3" json:"envs,omitempty"`
	// Execution environment assignments to be set for the execution.
	ExecutionEnvAssignments []*core.ExecutionEnvAssignment `protobuf:"bytes,22,rep,name=execution_env_assignments,json=executionEnvAssignments,proto3" json:"execution_env_assignments,omitempty"`
}

func (x *LaunchPlanSpec) Reset() {
	*x = LaunchPlanSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LaunchPlanSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LaunchPlanSpec) ProtoMessage() {}

func (x *LaunchPlanSpec) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LaunchPlanSpec.ProtoReflect.Descriptor instead.
func (*LaunchPlanSpec) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_launch_plan_proto_rawDescGZIP(), []int{5}
}

func (x *LaunchPlanSpec) GetWorkflowId() *core.Identifier {
	if x != nil {
		return x.WorkflowId
	}
	return nil
}

func (x *LaunchPlanSpec) GetEntityMetadata() *LaunchPlanMetadata {
	if x != nil {
		return x.EntityMetadata
	}
	return nil
}

func (x *LaunchPlanSpec) GetDefaultInputs() *core.ParameterMap {
	if x != nil {
		return x.DefaultInputs
	}
	return nil
}

func (x *LaunchPlanSpec) GetFixedInputs() *core.LiteralMap {
	if x != nil {
		return x.FixedInputs
	}
	return nil
}

// Deprecated: Marked as deprecated in flyteidl/admin/launch_plan.proto.
func (x *LaunchPlanSpec) GetRole() string {
	if x != nil {
		return x.Role
	}
	return ""
}

func (x *LaunchPlanSpec) GetLabels() *Labels {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *LaunchPlanSpec) GetAnnotations() *Annotations {
	if x != nil {
		return x.Annotations
	}
	return nil
}

// Deprecated: Marked as deprecated in flyteidl/admin/launch_plan.proto.
func (x *LaunchPlanSpec) GetAuth() *Auth {
	if x != nil {
		return x.Auth
	}
	return nil
}

// Deprecated: Marked as deprecated in flyteidl/admin/launch_plan.proto.
func (x *LaunchPlanSpec) GetAuthRole() *AuthRole {
	if x != nil {
		return x.AuthRole
	}
	return nil
}

func (x *LaunchPlanSpec) GetSecurityContext() *core.SecurityContext {
	if x != nil {
		return x.SecurityContext
	}
	return nil
}

func (x *LaunchPlanSpec) GetQualityOfService() *core.QualityOfService {
	if x != nil {
		return x.QualityOfService
	}
	return nil
}

func (x *LaunchPlanSpec) GetRawOutputDataConfig() *RawOutputDataConfig {
	if x != nil {
		return x.RawOutputDataConfig
	}
	return nil
}

func (x *LaunchPlanSpec) GetMaxParallelism() int32 {
	if x != nil {
		return x.MaxParallelism
	}
	return 0
}

func (x *LaunchPlanSpec) GetInterruptible() *wrapperspb.BoolValue {
	if x != nil {
		return x.Interruptible
	}
	return nil
}

func (x *LaunchPlanSpec) GetOverwriteCache() bool {
	if x != nil {
		return x.OverwriteCache
	}
	return false
}

func (x *LaunchPlanSpec) GetEnvs() *Envs {
	if x != nil {
		return x.Envs
	}
	return nil
}

func (x *LaunchPlanSpec) GetExecutionEnvAssignments() []*core.ExecutionEnvAssignment {
	if x != nil {
		return x.ExecutionEnvAssignments
	}
	return nil
}

// Values computed by the flyte platform after launch plan registration.
// These include expected_inputs required to be present in a CreateExecutionRequest
// to launch the reference workflow as well timestamp values associated with the launch plan.
type LaunchPlanClosure struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicate the Launch plan state.
	State LaunchPlanState `protobuf:"varint,1,opt,name=state,proto3,enum=flyteidl.admin.LaunchPlanState" json:"state,omitempty"`
	// Indicates the set of inputs expected when creating an execution with the Launch plan
	ExpectedInputs *core.ParameterMap `protobuf:"bytes,2,opt,name=expected_inputs,json=expectedInputs,proto3" json:"expected_inputs,omitempty"`
	// Indicates the set of outputs expected to be produced by creating an execution with the Launch plan
	ExpectedOutputs *core.VariableMap `protobuf:"bytes,3,opt,name=expected_outputs,json=expectedOutputs,proto3" json:"expected_outputs,omitempty"`
	// Time at which the launch plan was created.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Time at which the launch plan was last updated.
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
}

func (x *LaunchPlanClosure) Reset() {
	*x = LaunchPlanClosure{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LaunchPlanClosure) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LaunchPlanClosure) ProtoMessage() {}

func (x *LaunchPlanClosure) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LaunchPlanClosure.ProtoReflect.Descriptor instead.
func (*LaunchPlanClosure) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_launch_plan_proto_rawDescGZIP(), []int{6}
}

func (x *LaunchPlanClosure) GetState() LaunchPlanState {
	if x != nil {
		return x.State
	}
	return LaunchPlanState_INACTIVE
}

func (x *LaunchPlanClosure) GetExpectedInputs() *core.ParameterMap {
	if x != nil {
		return x.ExpectedInputs
	}
	return nil
}

func (x *LaunchPlanClosure) GetExpectedOutputs() *core.VariableMap {
	if x != nil {
		return x.ExpectedOutputs
	}
	return nil
}

func (x *LaunchPlanClosure) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *LaunchPlanClosure) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

// Additional launch plan attributes included in the LaunchPlanSpec not strictly required to launch
// the reference workflow.
type LaunchPlanMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Schedule to execute the Launch Plan
	Schedule *Schedule `protobuf:"bytes,1,opt,name=schedule,proto3" json:"schedule,omitempty"`
	// List of notifications based on Execution status transitions
	Notifications []*Notification `protobuf:"bytes,2,rep,name=notifications,proto3" json:"notifications,omitempty"`
	// Additional metadata for how to launch the launch plan
	LaunchConditions *anypb.Any `protobuf:"bytes,3,opt,name=launch_conditions,json=launchConditions,proto3" json:"launch_conditions,omitempty"`
}

func (x *LaunchPlanMetadata) Reset() {
	*x = LaunchPlanMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LaunchPlanMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LaunchPlanMetadata) ProtoMessage() {}

func (x *LaunchPlanMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LaunchPlanMetadata.ProtoReflect.Descriptor instead.
func (*LaunchPlanMetadata) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_launch_plan_proto_rawDescGZIP(), []int{7}
}

func (x *LaunchPlanMetadata) GetSchedule() *Schedule {
	if x != nil {
		return x.Schedule
	}
	return nil
}

func (x *LaunchPlanMetadata) GetNotifications() []*Notification {
	if x != nil {
		return x.Notifications
	}
	return nil
}

func (x *LaunchPlanMetadata) GetLaunchConditions() *anypb.Any {
	if x != nil {
		return x.LaunchConditions
	}
	return nil
}

// Request to set the referenced launch plan state to the configured value.
// See :ref:`ref_flyteidl.admin.LaunchPlan` for more details
type LaunchPlanUpdateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier of launch plan for which to change state.
	// +required.
	Id *core.Identifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Desired state to apply to the launch plan.
	// +required.
	State LaunchPlanState `protobuf:"varint,2,opt,name=state,proto3,enum=flyteidl.admin.LaunchPlanState" json:"state,omitempty"`
}

func (x *LaunchPlanUpdateRequest) Reset() {
	*x = LaunchPlanUpdateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LaunchPlanUpdateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LaunchPlanUpdateRequest) ProtoMessage() {}

func (x *LaunchPlanUpdateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LaunchPlanUpdateRequest.ProtoReflect.Descriptor instead.
func (*LaunchPlanUpdateRequest) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_launch_plan_proto_rawDescGZIP(), []int{8}
}

func (x *LaunchPlanUpdateRequest) GetId() *core.Identifier {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *LaunchPlanUpdateRequest) GetState() LaunchPlanState {
	if x != nil {
		return x.State
	}
	return LaunchPlanState_INACTIVE
}

// Purposefully empty, may be populated in the future.
type LaunchPlanUpdateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *LaunchPlanUpdateResponse) Reset() {
	*x = LaunchPlanUpdateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LaunchPlanUpdateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LaunchPlanUpdateResponse) ProtoMessage() {}

func (x *LaunchPlanUpdateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LaunchPlanUpdateResponse.ProtoReflect.Descriptor instead.
func (*LaunchPlanUpdateResponse) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_launch_plan_proto_rawDescGZIP(), []int{9}
}

// Represents a request struct for finding an active launch plan for a given NamedEntityIdentifier
// See :ref:`ref_flyteidl.admin.LaunchPlan` for more details
type ActiveLaunchPlanRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// +required.
	Id *NamedEntityIdentifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *ActiveLaunchPlanRequest) Reset() {
	*x = ActiveLaunchPlanRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActiveLaunchPlanRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActiveLaunchPlanRequest) ProtoMessage() {}

func (x *ActiveLaunchPlanRequest) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActiveLaunchPlanRequest.ProtoReflect.Descriptor instead.
func (*ActiveLaunchPlanRequest) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_launch_plan_proto_rawDescGZIP(), []int{10}
}

func (x *ActiveLaunchPlanRequest) GetId() *NamedEntityIdentifier {
	if x != nil {
		return x.Id
	}
	return nil
}

// Represents a request structure to list active launch plans within a project/domain and optional org.
// See :ref:`ref_flyteidl.admin.LaunchPlan` for more details
type ActiveLaunchPlanListRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the project that contains the identifiers.
	// +required.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// Name of the domain the identifiers belongs to within the project.
	// +required.
	Domain string `protobuf:"bytes,2,opt,name=domain,proto3" json:"domain,omitempty"`
	// Indicates the number of resources to be returned.
	// +required.
	Limit uint32 `protobuf:"varint,3,opt,name=limit,proto3" json:"limit,omitempty"`
	// In the case of multiple pages of results, the server-provided token can be used to fetch the next page
	// in a query.
	// +optional
	Token string `protobuf:"bytes,4,opt,name=token,proto3" json:"token,omitempty"`
	// Sort ordering.
	// +optional
	SortBy *Sort `protobuf:"bytes,5,opt,name=sort_by,json=sortBy,proto3" json:"sort_by,omitempty"`
	// Optional, org key applied to the resource.
	Org string `protobuf:"bytes,6,opt,name=org,proto3" json:"org,omitempty"`
}

func (x *ActiveLaunchPlanListRequest) Reset() {
	*x = ActiveLaunchPlanListRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActiveLaunchPlanListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActiveLaunchPlanListRequest) ProtoMessage() {}

func (x *ActiveLaunchPlanListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_launch_plan_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActiveLaunchPlanListRequest.ProtoReflect.Descriptor instead.
func (*ActiveLaunchPlanListRequest) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_launch_plan_proto_rawDescGZIP(), []int{11}
}

func (x *ActiveLaunchPlanListRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *ActiveLaunchPlanListRequest) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

func (x *ActiveLaunchPlanListRequest) GetLimit() uint32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *ActiveLaunchPlanListRequest) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *ActiveLaunchPlanListRequest) GetSortBy() *Sort {
	if x != nil {
		return x.SortBy
	}
	return nil
}

func (x *ActiveLaunchPlanListRequest) GetOrg() string {
	if x != nil {
		return x.Org
	}
	return ""
}

var File_flyteidl_admin_launch_plan_proto protoreflect.FileDescriptor

var file_flyteidl_admin_launch_plan_proto_rawDesc = []byte{
	0x0a, 0x20, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2f, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x0e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x1a, 0x1d, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x63, 0x6f, 0x72,
	0x65, 0x2f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x22, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x63, 0x6f, 0x72, 0x65,
	0x2f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x76, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f,
	0x63, 0x6f, 0x72, 0x65, 0x2f, 0x6c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x63, 0x6f,
	0x72, 0x65, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x63, 0x6f,
	0x72, 0x65, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1c, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x63, 0x6f, 0x72,
	0x65, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1d, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1b, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65,
	0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x78, 0x0a, 0x17, 0x4c, 0x61, 0x75, 0x6e,
	0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x29, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e,
	0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x02, 0x69, 0x64, 0x12, 0x32,
	0x0a, 0x04, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x66,
	0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x4c, 0x61,
	0x75, 0x6e, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x04, 0x73, 0x70,
	0x65, 0x63, 0x22, 0x1a, 0x0a, 0x18, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa8,
	0x01, 0x0a, 0x0a, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x29, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x66, 0x6c, 0x79, 0x74,
	0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x52, 0x02, 0x69, 0x64, 0x12, 0x32, 0x0a, 0x04, 0x73, 0x70, 0x65, 0x63,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64,
	0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x50, 0x6c,
	0x61, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x04, 0x73, 0x70, 0x65, 0x63, 0x12, 0x3b, 0x0a, 0x07,
	0x63, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x4c,
	0x61, 0x75, 0x6e, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x43, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65,
	0x52, 0x07, 0x63, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x22, 0x65, 0x0a, 0x0e, 0x4c, 0x61, 0x75,
	0x6e, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x0c, 0x6c,
	0x61, 0x75, 0x6e, 0x63, 0x68, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x0b, 0x6c,
	0x61, 0x75, 0x6e, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x76, 0x0a, 0x04, 0x41, 0x75, 0x74, 0x68, 0x12, 0x2c, 0x0a, 0x12, 0x61, 0x73, 0x73, 0x75,
	0x6d, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x61, 0x6d, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x61, 0x73, 0x73, 0x75, 0x6d, 0x61, 0x62, 0x6c, 0x65, 0x49,
	0x61, 0x6d, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x3c, 0x0a, 0x1a, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e,
	0x65, 0x74, 0x65, 0x73, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x18, 0x6b, 0x75, 0x62, 0x65,
	0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x3a, 0x02, 0x18, 0x01, 0x22, 0xa0, 0x08, 0x0a, 0x0e, 0x4c, 0x61, 0x75,
	0x6e, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x3a, 0x0a, 0x0b, 0x77,
	0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65,
	0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x0a, 0x77, 0x6f, 0x72,
	0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x64, 0x12, 0x4b, 0x0a, 0x0f, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x22, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x0e, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x42, 0x0a, 0x0e, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x66,
	0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x70, 0x52, 0x0d, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x3c, 0x0a, 0x0c, 0x66, 0x69, 0x78, 0x65,
	0x64, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x4c,
	0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x4d, 0x61, 0x70, 0x52, 0x0b, 0x66, 0x69, 0x78, 0x65, 0x64,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x16, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x2e,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x3d,
	0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2c, 0x0a,
	0x04, 0x61, 0x75, 0x74, 0x68, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x66, 0x6c,
	0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x41, 0x75, 0x74,
	0x68, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x61, 0x75, 0x74, 0x68, 0x12, 0x39, 0x0a, 0x09, 0x61,
	0x75, 0x74, 0x68, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18,
	0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x41, 0x75, 0x74, 0x68, 0x52, 0x6f, 0x6c, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08, 0x61, 0x75,
	0x74, 0x68, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x49, 0x0a, 0x10, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1e, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65,
	0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x52, 0x0f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x12, 0x4d, 0x0a, 0x12, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x6f, 0x66, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x51, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x10,
	0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0x58, 0x0a, 0x16, 0x72, 0x61, 0x77, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x52, 0x61, 0x77, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x44, 0x61, 0x74, 0x61, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x13, 0x72, 0x61, 0x77, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x61,
	0x78, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x69, 0x73, 0x6d, 0x18, 0x12, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x50, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c,
	0x69, 0x73, 0x6d, 0x12, 0x40, 0x0a, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x72, 0x75, 0x70, 0x74,
	0x69, 0x62, 0x6c, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f,
	0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x72, 0x75, 0x70,
	0x74, 0x69, 0x62, 0x6c, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69,
	0x74, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e,
	0x6f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x12, 0x28,
	0x0a, 0x04, 0x65, 0x6e, 0x76, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x66,
	0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x45, 0x6e,
	0x76, 0x73, 0x52, 0x04, 0x65, 0x6e, 0x76, 0x73, 0x12, 0x61, 0x0a, 0x19, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x76, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x16, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x66, 0x6c,
	0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x76, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x17, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x76,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0xcd, 0x02, 0x0a, 0x11,
	0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x43, 0x6c, 0x6f, 0x73, 0x75, 0x72,
	0x65, 0x12, 0x35, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1f, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x44, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72,
	0x65, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x70, 0x52, 0x0e,
	0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x45,
	0x0a, 0x10, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65,
	0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c,
	0x65, 0x4d, 0x61, 0x70, 0x52, 0x0f, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74,
	0x12, 0x39, 0x0a, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x09, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x22, 0xd1, 0x01, 0x0a, 0x12,
	0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x34, 0x0a, 0x08, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x08,
	0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x42, 0x0a, 0x0d, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x6e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x41, 0x0a, 0x11,
	0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x10, 0x6c,
	0x61, 0x75, 0x6e, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0x7b, 0x0a, 0x17, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x29, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64,
	0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x52, 0x02, 0x69, 0x64, 0x12, 0x35, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x1a, 0x0a, 0x18,
	0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x50, 0x0a, 0x17, 0x41, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x35, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x02, 0x69, 0x64, 0x22, 0xbc, 0x01, 0x0a, 0x1b, 0x41,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x4c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x14, 0x0a, 0x05,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x2d, 0x0a, 0x07, 0x73, 0x6f, 0x72, 0x74,
	0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x66, 0x6c, 0x79, 0x74,
	0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x53, 0x6f, 0x72, 0x74, 0x52,
	0x06, 0x73, 0x6f, 0x72, 0x74, 0x42, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6f, 0x72, 0x67, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6f, 0x72, 0x67, 0x2a, 0x2b, 0x0a, 0x0f, 0x4c, 0x61, 0x75,
	0x6e, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0c, 0x0a, 0x08,
	0x49, 0x4e, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43,
	0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x42, 0xbb, 0x01, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x2e, 0x66,
	0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x42, 0x0f, 0x4c,
	0x61, 0x75, 0x6e, 0x63, 0x68, 0x50, 0x6c, 0x61, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x3b, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x66, 0x6c, 0x79,
	0x74, 0x65, 0x6f, 0x72, 0x67, 0x2f, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x2f, 0x66, 0x6c, 0x79, 0x74,
	0x65, 0x69, 0x64, 0x6c, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x70, 0x62, 0x2d, 0x67, 0x6f, 0x2f, 0x66,
	0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0xa2, 0x02, 0x03,
	0x46, 0x41, 0x58, 0xaa, 0x02, 0x0e, 0x46, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x41,
	0x64, 0x6d, 0x69, 0x6e, 0xca, 0x02, 0x0e, 0x46, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x5c,
	0x41, 0x64, 0x6d, 0x69, 0x6e, 0xe2, 0x02, 0x1a, 0x46, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c,
	0x5c, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xea, 0x02, 0x0f, 0x46, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x3a, 0x3a, 0x41,
	0x64, 0x6d, 0x69, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_flyteidl_admin_launch_plan_proto_rawDescOnce sync.Once
	file_flyteidl_admin_launch_plan_proto_rawDescData = file_flyteidl_admin_launch_plan_proto_rawDesc
)

func file_flyteidl_admin_launch_plan_proto_rawDescGZIP() []byte {
	file_flyteidl_admin_launch_plan_proto_rawDescOnce.Do(func() {
		file_flyteidl_admin_launch_plan_proto_rawDescData = protoimpl.X.CompressGZIP(file_flyteidl_admin_launch_plan_proto_rawDescData)
	})
	return file_flyteidl_admin_launch_plan_proto_rawDescData
}

var file_flyteidl_admin_launch_plan_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_flyteidl_admin_launch_plan_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_flyteidl_admin_launch_plan_proto_goTypes = []interface{}{
	(LaunchPlanState)(0),                // 0: flyteidl.admin.LaunchPlanState
	(*LaunchPlanCreateRequest)(nil),     // 1: flyteidl.admin.LaunchPlanCreateRequest
	(*LaunchPlanCreateResponse)(nil),    // 2: flyteidl.admin.LaunchPlanCreateResponse
	(*LaunchPlan)(nil),                  // 3: flyteidl.admin.LaunchPlan
	(*LaunchPlanList)(nil),              // 4: flyteidl.admin.LaunchPlanList
	(*Auth)(nil),                        // 5: flyteidl.admin.Auth
	(*LaunchPlanSpec)(nil),              // 6: flyteidl.admin.LaunchPlanSpec
	(*LaunchPlanClosure)(nil),           // 7: flyteidl.admin.LaunchPlanClosure
	(*LaunchPlanMetadata)(nil),          // 8: flyteidl.admin.LaunchPlanMetadata
	(*LaunchPlanUpdateRequest)(nil),     // 9: flyteidl.admin.LaunchPlanUpdateRequest
	(*LaunchPlanUpdateResponse)(nil),    // 10: flyteidl.admin.LaunchPlanUpdateResponse
	(*ActiveLaunchPlanRequest)(nil),     // 11: flyteidl.admin.ActiveLaunchPlanRequest
	(*ActiveLaunchPlanListRequest)(nil), // 12: flyteidl.admin.ActiveLaunchPlanListRequest
	(*core.Identifier)(nil),             // 13: flyteidl.core.Identifier
	(*core.ParameterMap)(nil),           // 14: flyteidl.core.ParameterMap
	(*core.LiteralMap)(nil),             // 15: flyteidl.core.LiteralMap
	(*Labels)(nil),                      // 16: flyteidl.admin.Labels
	(*Annotations)(nil),                 // 17: flyteidl.admin.Annotations
	(*AuthRole)(nil),                    // 18: flyteidl.admin.AuthRole
	(*core.SecurityContext)(nil),        // 19: flyteidl.core.SecurityContext
	(*core.QualityOfService)(nil),       // 20: flyteidl.core.QualityOfService
	(*RawOutputDataConfig)(nil),         // 21: flyteidl.admin.RawOutputDataConfig
	(*wrapperspb.BoolValue)(nil),        // 22: google.protobuf.BoolValue
	(*Envs)(nil),                        // 23: flyteidl.admin.Envs
	(*core.ExecutionEnvAssignment)(nil), // 24: flyteidl.core.ExecutionEnvAssignment
	(*core.VariableMap)(nil),            // 25: flyteidl.core.VariableMap
	(*timestamppb.Timestamp)(nil),       // 26: google.protobuf.Timestamp
	(*Schedule)(nil),                    // 27: flyteidl.admin.Schedule
	(*Notification)(nil),                // 28: flyteidl.admin.Notification
	(*anypb.Any)(nil),                   // 29: google.protobuf.Any
	(*NamedEntityIdentifier)(nil),       // 30: flyteidl.admin.NamedEntityIdentifier
	(*Sort)(nil),                        // 31: flyteidl.admin.Sort
}
var file_flyteidl_admin_launch_plan_proto_depIdxs = []int32{
	13, // 0: flyteidl.admin.LaunchPlanCreateRequest.id:type_name -> flyteidl.core.Identifier
	6,  // 1: flyteidl.admin.LaunchPlanCreateRequest.spec:type_name -> flyteidl.admin.LaunchPlanSpec
	13, // 2: flyteidl.admin.LaunchPlan.id:type_name -> flyteidl.core.Identifier
	6,  // 3: flyteidl.admin.LaunchPlan.spec:type_name -> flyteidl.admin.LaunchPlanSpec
	7,  // 4: flyteidl.admin.LaunchPlan.closure:type_name -> flyteidl.admin.LaunchPlanClosure
	3,  // 5: flyteidl.admin.LaunchPlanList.launch_plans:type_name -> flyteidl.admin.LaunchPlan
	13, // 6: flyteidl.admin.LaunchPlanSpec.workflow_id:type_name -> flyteidl.core.Identifier
	8,  // 7: flyteidl.admin.LaunchPlanSpec.entity_metadata:type_name -> flyteidl.admin.LaunchPlanMetadata
	14, // 8: flyteidl.admin.LaunchPlanSpec.default_inputs:type_name -> flyteidl.core.ParameterMap
	15, // 9: flyteidl.admin.LaunchPlanSpec.fixed_inputs:type_name -> flyteidl.core.LiteralMap
	16, // 10: flyteidl.admin.LaunchPlanSpec.labels:type_name -> flyteidl.admin.Labels
	17, // 11: flyteidl.admin.LaunchPlanSpec.annotations:type_name -> flyteidl.admin.Annotations
	5,  // 12: flyteidl.admin.LaunchPlanSpec.auth:type_name -> flyteidl.admin.Auth
	18, // 13: flyteidl.admin.LaunchPlanSpec.auth_role:type_name -> flyteidl.admin.AuthRole
	19, // 14: flyteidl.admin.LaunchPlanSpec.security_context:type_name -> flyteidl.core.SecurityContext
	20, // 15: flyteidl.admin.LaunchPlanSpec.quality_of_service:type_name -> flyteidl.core.QualityOfService
	21, // 16: flyteidl.admin.LaunchPlanSpec.raw_output_data_config:type_name -> flyteidl.admin.RawOutputDataConfig
	22, // 17: flyteidl.admin.LaunchPlanSpec.interruptible:type_name -> google.protobuf.BoolValue
	23, // 18: flyteidl.admin.LaunchPlanSpec.envs:type_name -> flyteidl.admin.Envs
	24, // 19: flyteidl.admin.LaunchPlanSpec.execution_env_assignments:type_name -> flyteidl.core.ExecutionEnvAssignment
	0,  // 20: flyteidl.admin.LaunchPlanClosure.state:type_name -> flyteidl.admin.LaunchPlanState
	14, // 21: flyteidl.admin.LaunchPlanClosure.expected_inputs:type_name -> flyteidl.core.ParameterMap
	25, // 22: flyteidl.admin.LaunchPlanClosure.expected_outputs:type_name -> flyteidl.core.VariableMap
	26, // 23: flyteidl.admin.LaunchPlanClosure.created_at:type_name -> google.protobuf.Timestamp
	26, // 24: flyteidl.admin.LaunchPlanClosure.updated_at:type_name -> google.protobuf.Timestamp
	27, // 25: flyteidl.admin.LaunchPlanMetadata.schedule:type_name -> flyteidl.admin.Schedule
	28, // 26: flyteidl.admin.LaunchPlanMetadata.notifications:type_name -> flyteidl.admin.Notification
	29, // 27: flyteidl.admin.LaunchPlanMetadata.launch_conditions:type_name -> google.protobuf.Any
	13, // 28: flyteidl.admin.LaunchPlanUpdateRequest.id:type_name -> flyteidl.core.Identifier
	0,  // 29: flyteidl.admin.LaunchPlanUpdateRequest.state:type_name -> flyteidl.admin.LaunchPlanState
	30, // 30: flyteidl.admin.ActiveLaunchPlanRequest.id:type_name -> flyteidl.admin.NamedEntityIdentifier
	31, // 31: flyteidl.admin.ActiveLaunchPlanListRequest.sort_by:type_name -> flyteidl.admin.Sort
	32, // [32:32] is the sub-list for method output_type
	32, // [32:32] is the sub-list for method input_type
	32, // [32:32] is the sub-list for extension type_name
	32, // [32:32] is the sub-list for extension extendee
	0,  // [0:32] is the sub-list for field type_name
}

func init() { file_flyteidl_admin_launch_plan_proto_init() }
func file_flyteidl_admin_launch_plan_proto_init() {
	if File_flyteidl_admin_launch_plan_proto != nil {
		return
	}
	file_flyteidl_admin_schedule_proto_init()
	file_flyteidl_admin_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_flyteidl_admin_launch_plan_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LaunchPlanCreateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_launch_plan_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LaunchPlanCreateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_launch_plan_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LaunchPlan); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_launch_plan_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LaunchPlanList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_launch_plan_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Auth); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_launch_plan_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LaunchPlanSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_launch_plan_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LaunchPlanClosure); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_launch_plan_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LaunchPlanMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_launch_plan_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LaunchPlanUpdateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_launch_plan_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LaunchPlanUpdateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_launch_plan_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActiveLaunchPlanRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_launch_plan_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActiveLaunchPlanListRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_flyteidl_admin_launch_plan_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_flyteidl_admin_launch_plan_proto_goTypes,
		DependencyIndexes: file_flyteidl_admin_launch_plan_proto_depIdxs,
		EnumInfos:         file_flyteidl_admin_launch_plan_proto_enumTypes,
		MessageInfos:      file_flyteidl_admin_launch_plan_proto_msgTypes,
	}.Build()
	File_flyteidl_admin_launch_plan_proto = out.File
	file_flyteidl_admin_launch_plan_proto_rawDesc = nil
	file_flyteidl_admin_launch_plan_proto_goTypes = nil
	file_flyteidl_admin_launch_plan_proto_depIdxs = nil
}
