// @generated by protoc-gen-es v1.7.2 with parameter "target=ts"
// @generated from file flyteidl/event/event.proto (package flyteidl.event, syntax proto3)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { Message, proto3, Struct, Timestamp } from "@bufbuild/protobuf";
import { Identifier, NodeExecutionIdentifier, TaskExecutionIdentifier, WorkflowExecutionIdentifier } from "../core/identifier_pb.js";
import { ExecutionError, NodeExecution_Phase, TaskExecution_Phase, TaskLog, WorkflowExecution_Phase } from "../core/execution_pb.js";
import { LiteralMap } from "../core/literals_pb.js";
import { CatalogCacheStatus, CatalogMetadata, CatalogReservation_Status } from "../core/catalog_pb.js";
import { CompiledWorkflowClosure } from "../core/compiler_pb.js";

/**
 * @generated from message flyteidl.event.WorkflowExecutionEvent
 */
export class WorkflowExecutionEvent extends Message<WorkflowExecutionEvent> {
  /**
   * Workflow execution id
   *
   * @generated from field: flyteidl.core.WorkflowExecutionIdentifier execution_id = 1;
   */
  executionId?: WorkflowExecutionIdentifier;

  /**
   * the id of the originator (Propeller) of the event
   *
   * @generated from field: string producer_id = 2;
   */
  producerId = "";

  /**
   * @generated from field: flyteidl.core.WorkflowExecution.Phase phase = 3;
   */
  phase = WorkflowExecution_Phase.UNDEFINED;

  /**
   * This timestamp represents when the original event occurred, it is generated
   * by the executor of the workflow.
   *
   * @generated from field: google.protobuf.Timestamp occurred_at = 4;
   */
  occurredAt?: Timestamp;

  /**
   * @generated from oneof flyteidl.event.WorkflowExecutionEvent.output_result
   */
  outputResult: {
    /**
     * URL to the output of the execution, it encodes all the information
     * including Cloud source provider. ie., s3://...
     *
     * @generated from field: string output_uri = 5;
     */
    value: string;
    case: "outputUri";
  } | {
    /**
     * Error information for the execution
     *
     * @generated from field: flyteidl.core.ExecutionError error = 6;
     */
    value: ExecutionError;
    case: "error";
  } | {
    /**
     * Raw output data produced by this workflow execution.
     *
     * @generated from field: flyteidl.core.LiteralMap output_data = 7;
     */
    value: LiteralMap;
    case: "outputData";
  } | { case: undefined; value?: undefined } = { case: undefined };

  constructor(data?: PartialMessage<WorkflowExecutionEvent>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.event.WorkflowExecutionEvent";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "execution_id", kind: "message", T: WorkflowExecutionIdentifier },
    { no: 2, name: "producer_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "phase", kind: "enum", T: proto3.getEnumType(WorkflowExecution_Phase) },
    { no: 4, name: "occurred_at", kind: "message", T: Timestamp },
    { no: 5, name: "output_uri", kind: "scalar", T: 9 /* ScalarType.STRING */, oneof: "output_result" },
    { no: 6, name: "error", kind: "message", T: ExecutionError, oneof: "output_result" },
    { no: 7, name: "output_data", kind: "message", T: LiteralMap, oneof: "output_result" },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): WorkflowExecutionEvent {
    return new WorkflowExecutionEvent().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): WorkflowExecutionEvent {
    return new WorkflowExecutionEvent().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): WorkflowExecutionEvent {
    return new WorkflowExecutionEvent().fromJsonString(jsonString, options);
  }

  static equals(a: WorkflowExecutionEvent | PlainMessage<WorkflowExecutionEvent> | undefined, b: WorkflowExecutionEvent | PlainMessage<WorkflowExecutionEvent> | undefined): boolean {
    return proto3.util.equals(WorkflowExecutionEvent, a, b);
  }
}

/**
 * @generated from message flyteidl.event.NodeExecutionEvent
 */
export class NodeExecutionEvent extends Message<NodeExecutionEvent> {
  /**
   * Unique identifier for this node execution
   *
   * @generated from field: flyteidl.core.NodeExecutionIdentifier id = 1;
   */
  id?: NodeExecutionIdentifier;

  /**
   * the id of the originator (Propeller) of the event
   *
   * @generated from field: string producer_id = 2;
   */
  producerId = "";

  /**
   * @generated from field: flyteidl.core.NodeExecution.Phase phase = 3;
   */
  phase = NodeExecution_Phase.UNDEFINED;

  /**
   * This timestamp represents when the original event occurred, it is generated
   * by the executor of the node.
   *
   * @generated from field: google.protobuf.Timestamp occurred_at = 4;
   */
  occurredAt?: Timestamp;

  /**
   * @generated from oneof flyteidl.event.NodeExecutionEvent.input_value
   */
  inputValue: {
    /**
     * @generated from field: string input_uri = 5;
     */
    value: string;
    case: "inputUri";
  } | {
    /**
     * Raw input data consumed by this node execution.
     *
     * @generated from field: flyteidl.core.LiteralMap input_data = 20;
     */
    value: LiteralMap;
    case: "inputData";
  } | { case: undefined; value?: undefined } = { case: undefined };

  /**
   * @generated from oneof flyteidl.event.NodeExecutionEvent.output_result
   */
  outputResult: {
    /**
     * URL to the output of the execution, it encodes all the information
     * including Cloud source provider. ie., s3://...
     *
     * @generated from field: string output_uri = 6;
     */
    value: string;
    case: "outputUri";
  } | {
    /**
     * Error information for the execution
     *
     * @generated from field: flyteidl.core.ExecutionError error = 7;
     */
    value: ExecutionError;
    case: "error";
  } | {
    /**
     * Raw output data produced by this node execution.
     *
     * @generated from field: flyteidl.core.LiteralMap output_data = 15;
     */
    value: LiteralMap;
    case: "outputData";
  } | { case: undefined; value?: undefined } = { case: undefined };

  /**
   * Additional metadata to do with this event's node target based
   * on the node type
   *
   * @generated from oneof flyteidl.event.NodeExecutionEvent.target_metadata
   */
  targetMetadata: {
    /**
     * @generated from field: flyteidl.event.WorkflowNodeMetadata workflow_node_metadata = 8;
     */
    value: WorkflowNodeMetadata;
    case: "workflowNodeMetadata";
  } | {
    /**
     * @generated from field: flyteidl.event.TaskNodeMetadata task_node_metadata = 14;
     */
    value: TaskNodeMetadata;
    case: "taskNodeMetadata";
  } | { case: undefined; value?: undefined } = { case: undefined };

  /**
   * [To be deprecated] Specifies which task (if any) launched this node.
   *
   * @generated from field: flyteidl.event.ParentTaskExecutionMetadata parent_task_metadata = 9;
   */
  parentTaskMetadata?: ParentTaskExecutionMetadata;

  /**
   * Specifies the parent node of the current node execution. Node executions at level zero will not have a parent node.
   *
   * @generated from field: flyteidl.event.ParentNodeExecutionMetadata parent_node_metadata = 10;
   */
  parentNodeMetadata?: ParentNodeExecutionMetadata;

  /**
   * Retry group to indicate grouping of nodes by retries
   *
   * @generated from field: string retry_group = 11;
   */
  retryGroup = "";

  /**
   * Identifier of the node in the original workflow/graph
   * This maps to value of WorkflowTemplate.nodes[X].id
   *
   * @generated from field: string spec_node_id = 12;
   */
  specNodeId = "";

  /**
   * Friendly readable name for the node
   *
   * @generated from field: string node_name = 13;
   */
  nodeName = "";

  /**
   * @generated from field: int32 event_version = 16;
   */
  eventVersion = 0;

  /**
   * Whether this node launched a subworkflow.
   *
   * @generated from field: bool is_parent = 17;
   */
  isParent = false;

  /**
   * Whether this node yielded a dynamic workflow.
   *
   * @generated from field: bool is_dynamic = 18;
   */
  isDynamic = false;

  /**
   * String location uniquely identifying where the deck HTML file is
   * NativeUrl specifies the url in the format of the configured storage provider (e.g. s3://my-bucket/randomstring/suffix.tar)
   *
   * @generated from field: string deck_uri = 19;
   */
  deckUri = "";

  /**
   * This timestamp represents the instant when the event was reported by the executing framework. For example,
   * when first processing a node the `occurred_at` timestamp should be the instant propeller makes progress, so when
   * literal inputs are initially copied. The event however will not be sent until after the copy completes.
   * Extracting both of these timestamps facilitates a more accurate portrayal of the evaluation time-series.
   *
   * @generated from field: google.protobuf.Timestamp reported_at = 21;
   */
  reportedAt?: Timestamp;

  /**
   * Indicates if this node is an ArrayNode.
   *
   * @generated from field: bool is_array = 22;
   */
  isArray = false;

  /**
   * So that Admin doesn't have to rebuild the node execution graph to find the target entity, propeller will fill this
   * in optionally - currently this is only filled in for subworkflows. This is the ID of the subworkflow corresponding
   * to this node execution. It is difficult to find because Admin only sees one node at a time. A subworkflow could be
   * nested multiple layers deep, and you'd need to access the correct workflow template to know the target subworkflow.
   *
   * @generated from field: flyteidl.core.Identifier target_entity = 23;
   */
  targetEntity?: Identifier;

  /**
   * Tasks and subworkflows (but not launch plans) that are run within a dynamic task are effectively independent of
   * the tasks that are registered in Admin's db. Confusingly, they are often identical, but sometimes they are not
   * even registered at all. Similar to the target_entity field, at the time Admin receives this event, it has no idea
   * if the relevant execution entity is was registered, or dynamic. This field indicates that the target_entity ID,
   * as well as task IDs in any corresponding Task Executions, should not be used to looked up the task in Admin's db.
   *
   * @generated from field: bool is_in_dynamic_chain = 24;
   */
  isInDynamicChain = false;

  /**
   * Whether this node launched an eager task.
   *
   * @generated from field: bool is_eager = 25;
   */
  isEager = false;

  constructor(data?: PartialMessage<NodeExecutionEvent>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.event.NodeExecutionEvent";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "message", T: NodeExecutionIdentifier },
    { no: 2, name: "producer_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "phase", kind: "enum", T: proto3.getEnumType(NodeExecution_Phase) },
    { no: 4, name: "occurred_at", kind: "message", T: Timestamp },
    { no: 5, name: "input_uri", kind: "scalar", T: 9 /* ScalarType.STRING */, oneof: "input_value" },
    { no: 20, name: "input_data", kind: "message", T: LiteralMap, oneof: "input_value" },
    { no: 6, name: "output_uri", kind: "scalar", T: 9 /* ScalarType.STRING */, oneof: "output_result" },
    { no: 7, name: "error", kind: "message", T: ExecutionError, oneof: "output_result" },
    { no: 15, name: "output_data", kind: "message", T: LiteralMap, oneof: "output_result" },
    { no: 8, name: "workflow_node_metadata", kind: "message", T: WorkflowNodeMetadata, oneof: "target_metadata" },
    { no: 14, name: "task_node_metadata", kind: "message", T: TaskNodeMetadata, oneof: "target_metadata" },
    { no: 9, name: "parent_task_metadata", kind: "message", T: ParentTaskExecutionMetadata },
    { no: 10, name: "parent_node_metadata", kind: "message", T: ParentNodeExecutionMetadata },
    { no: 11, name: "retry_group", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 12, name: "spec_node_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 13, name: "node_name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 16, name: "event_version", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
    { no: 17, name: "is_parent", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
    { no: 18, name: "is_dynamic", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
    { no: 19, name: "deck_uri", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 21, name: "reported_at", kind: "message", T: Timestamp },
    { no: 22, name: "is_array", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
    { no: 23, name: "target_entity", kind: "message", T: Identifier },
    { no: 24, name: "is_in_dynamic_chain", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
    { no: 25, name: "is_eager", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NodeExecutionEvent {
    return new NodeExecutionEvent().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NodeExecutionEvent {
    return new NodeExecutionEvent().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NodeExecutionEvent {
    return new NodeExecutionEvent().fromJsonString(jsonString, options);
  }

  static equals(a: NodeExecutionEvent | PlainMessage<NodeExecutionEvent> | undefined, b: NodeExecutionEvent | PlainMessage<NodeExecutionEvent> | undefined): boolean {
    return proto3.util.equals(NodeExecutionEvent, a, b);
  }
}

/**
 * For Workflow Nodes we need to send information about the workflow that's launched
 *
 * @generated from message flyteidl.event.WorkflowNodeMetadata
 */
export class WorkflowNodeMetadata extends Message<WorkflowNodeMetadata> {
  /**
   * @generated from field: flyteidl.core.WorkflowExecutionIdentifier execution_id = 1;
   */
  executionId?: WorkflowExecutionIdentifier;

  constructor(data?: PartialMessage<WorkflowNodeMetadata>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.event.WorkflowNodeMetadata";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "execution_id", kind: "message", T: WorkflowExecutionIdentifier },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): WorkflowNodeMetadata {
    return new WorkflowNodeMetadata().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): WorkflowNodeMetadata {
    return new WorkflowNodeMetadata().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): WorkflowNodeMetadata {
    return new WorkflowNodeMetadata().fromJsonString(jsonString, options);
  }

  static equals(a: WorkflowNodeMetadata | PlainMessage<WorkflowNodeMetadata> | undefined, b: WorkflowNodeMetadata | PlainMessage<WorkflowNodeMetadata> | undefined): boolean {
    return proto3.util.equals(WorkflowNodeMetadata, a, b);
  }
}

/**
 * @generated from message flyteidl.event.TaskNodeMetadata
 */
export class TaskNodeMetadata extends Message<TaskNodeMetadata> {
  /**
   * Captures the status of caching for this execution.
   *
   * @generated from field: flyteidl.core.CatalogCacheStatus cache_status = 1;
   */
  cacheStatus = CatalogCacheStatus.CACHE_DISABLED;

  /**
   * This structure carries the catalog artifact information
   *
   * @generated from field: flyteidl.core.CatalogMetadata catalog_key = 2;
   */
  catalogKey?: CatalogMetadata;

  /**
   * Captures the status of cache reservations for this execution.
   *
   * @generated from field: flyteidl.core.CatalogReservation.Status reservation_status = 3;
   */
  reservationStatus = CatalogReservation_Status.RESERVATION_DISABLED;

  /**
   * The latest checkpoint location
   *
   * @generated from field: string checkpoint_uri = 4;
   */
  checkpointUri = "";

  /**
   * In the case this task launched a dynamic workflow we capture its structure here.
   *
   * @generated from field: flyteidl.event.DynamicWorkflowNodeMetadata dynamic_workflow = 16;
   */
  dynamicWorkflow?: DynamicWorkflowNodeMetadata;

  constructor(data?: PartialMessage<TaskNodeMetadata>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.event.TaskNodeMetadata";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "cache_status", kind: "enum", T: proto3.getEnumType(CatalogCacheStatus) },
    { no: 2, name: "catalog_key", kind: "message", T: CatalogMetadata },
    { no: 3, name: "reservation_status", kind: "enum", T: proto3.getEnumType(CatalogReservation_Status) },
    { no: 4, name: "checkpoint_uri", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 16, name: "dynamic_workflow", kind: "message", T: DynamicWorkflowNodeMetadata },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TaskNodeMetadata {
    return new TaskNodeMetadata().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TaskNodeMetadata {
    return new TaskNodeMetadata().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TaskNodeMetadata {
    return new TaskNodeMetadata().fromJsonString(jsonString, options);
  }

  static equals(a: TaskNodeMetadata | PlainMessage<TaskNodeMetadata> | undefined, b: TaskNodeMetadata | PlainMessage<TaskNodeMetadata> | undefined): boolean {
    return proto3.util.equals(TaskNodeMetadata, a, b);
  }
}

/**
 * For dynamic workflow nodes we send information about the dynamic workflow definition that gets generated.
 *
 * @generated from message flyteidl.event.DynamicWorkflowNodeMetadata
 */
export class DynamicWorkflowNodeMetadata extends Message<DynamicWorkflowNodeMetadata> {
  /**
   * id represents the unique identifier of the workflow.
   *
   * @generated from field: flyteidl.core.Identifier id = 1;
   */
  id?: Identifier;

  /**
   * Represents the compiled representation of the embedded dynamic workflow.
   *
   * @generated from field: flyteidl.core.CompiledWorkflowClosure compiled_workflow = 2;
   */
  compiledWorkflow?: CompiledWorkflowClosure;

  /**
   * dynamic_job_spec_uri is the location of the DynamicJobSpec proto message for this DynamicWorkflow. This is
   * required to correctly recover partially completed executions where the workflow has already been compiled.
   *
   * @generated from field: string dynamic_job_spec_uri = 3;
   */
  dynamicJobSpecUri = "";

  constructor(data?: PartialMessage<DynamicWorkflowNodeMetadata>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.event.DynamicWorkflowNodeMetadata";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "message", T: Identifier },
    { no: 2, name: "compiled_workflow", kind: "message", T: CompiledWorkflowClosure },
    { no: 3, name: "dynamic_job_spec_uri", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): DynamicWorkflowNodeMetadata {
    return new DynamicWorkflowNodeMetadata().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): DynamicWorkflowNodeMetadata {
    return new DynamicWorkflowNodeMetadata().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): DynamicWorkflowNodeMetadata {
    return new DynamicWorkflowNodeMetadata().fromJsonString(jsonString, options);
  }

  static equals(a: DynamicWorkflowNodeMetadata | PlainMessage<DynamicWorkflowNodeMetadata> | undefined, b: DynamicWorkflowNodeMetadata | PlainMessage<DynamicWorkflowNodeMetadata> | undefined): boolean {
    return proto3.util.equals(DynamicWorkflowNodeMetadata, a, b);
  }
}

/**
 * @generated from message flyteidl.event.ParentTaskExecutionMetadata
 */
export class ParentTaskExecutionMetadata extends Message<ParentTaskExecutionMetadata> {
  /**
   * @generated from field: flyteidl.core.TaskExecutionIdentifier id = 1;
   */
  id?: TaskExecutionIdentifier;

  constructor(data?: PartialMessage<ParentTaskExecutionMetadata>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.event.ParentTaskExecutionMetadata";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "message", T: TaskExecutionIdentifier },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ParentTaskExecutionMetadata {
    return new ParentTaskExecutionMetadata().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ParentTaskExecutionMetadata {
    return new ParentTaskExecutionMetadata().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ParentTaskExecutionMetadata {
    return new ParentTaskExecutionMetadata().fromJsonString(jsonString, options);
  }

  static equals(a: ParentTaskExecutionMetadata | PlainMessage<ParentTaskExecutionMetadata> | undefined, b: ParentTaskExecutionMetadata | PlainMessage<ParentTaskExecutionMetadata> | undefined): boolean {
    return proto3.util.equals(ParentTaskExecutionMetadata, a, b);
  }
}

/**
 * @generated from message flyteidl.event.ParentNodeExecutionMetadata
 */
export class ParentNodeExecutionMetadata extends Message<ParentNodeExecutionMetadata> {
  /**
   * Unique identifier of the parent node id within the execution
   * This is value of core.NodeExecutionIdentifier.node_id of the parent node 
   *
   * @generated from field: string node_id = 1;
   */
  nodeId = "";

  constructor(data?: PartialMessage<ParentNodeExecutionMetadata>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.event.ParentNodeExecutionMetadata";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "node_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ParentNodeExecutionMetadata {
    return new ParentNodeExecutionMetadata().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ParentNodeExecutionMetadata {
    return new ParentNodeExecutionMetadata().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ParentNodeExecutionMetadata {
    return new ParentNodeExecutionMetadata().fromJsonString(jsonString, options);
  }

  static equals(a: ParentNodeExecutionMetadata | PlainMessage<ParentNodeExecutionMetadata> | undefined, b: ParentNodeExecutionMetadata | PlainMessage<ParentNodeExecutionMetadata> | undefined): boolean {
    return proto3.util.equals(ParentNodeExecutionMetadata, a, b);
  }
}

/**
 * @generated from message flyteidl.event.EventReason
 */
export class EventReason extends Message<EventReason> {
  /**
   * An explanation for this event
   *
   * @generated from field: string reason = 1;
   */
  reason = "";

  /**
   * The time this reason occurred
   *
   * @generated from field: google.protobuf.Timestamp occurred_at = 2;
   */
  occurredAt?: Timestamp;

  constructor(data?: PartialMessage<EventReason>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.event.EventReason";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "reason", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "occurred_at", kind: "message", T: Timestamp },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): EventReason {
    return new EventReason().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): EventReason {
    return new EventReason().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): EventReason {
    return new EventReason().fromJsonString(jsonString, options);
  }

  static equals(a: EventReason | PlainMessage<EventReason> | undefined, b: EventReason | PlainMessage<EventReason> | undefined): boolean {
    return proto3.util.equals(EventReason, a, b);
  }
}

/**
 * Plugin specific execution event information. For tasks like Python, Hive, Spark, DynamicJob.
 *
 * @generated from message flyteidl.event.TaskExecutionEvent
 */
export class TaskExecutionEvent extends Message<TaskExecutionEvent> {
  /**
   * ID of the task. In combination with the retryAttempt this will indicate
   * the task execution uniquely for a given parent node execution.
   *
   * @generated from field: flyteidl.core.Identifier task_id = 1;
   */
  taskId?: Identifier;

  /**
   * A task execution is always kicked off by a node execution, the event consumer
   * will use the parent_id to relate the task to it's parent node execution
   *
   * @generated from field: flyteidl.core.NodeExecutionIdentifier parent_node_execution_id = 2;
   */
  parentNodeExecutionId?: NodeExecutionIdentifier;

  /**
   * retry attempt number for this task, ie., 2 for the second attempt
   *
   * @generated from field: uint32 retry_attempt = 3;
   */
  retryAttempt = 0;

  /**
   * Phase associated with the event
   *
   * @generated from field: flyteidl.core.TaskExecution.Phase phase = 4;
   */
  phase = TaskExecution_Phase.UNDEFINED;

  /**
   * id of the process that sent this event, mainly for trace debugging
   *
   * @generated from field: string producer_id = 5;
   */
  producerId = "";

  /**
   * log information for the task execution
   *
   * @generated from field: repeated flyteidl.core.TaskLog logs = 6;
   */
  logs: TaskLog[] = [];

  /**
   * This timestamp represents when the original event occurred, it is generated
   * by the executor of the task.
   *
   * @generated from field: google.protobuf.Timestamp occurred_at = 7;
   */
  occurredAt?: Timestamp;

  /**
   * @generated from oneof flyteidl.event.TaskExecutionEvent.input_value
   */
  inputValue: {
    /**
     * URI of the input file, it encodes all the information
     * including Cloud source provider. ie., s3://...
     *
     * @generated from field: string input_uri = 8;
     */
    value: string;
    case: "inputUri";
  } | {
    /**
     * Raw input data consumed by this task execution.
     *
     * @generated from field: flyteidl.core.LiteralMap input_data = 19;
     */
    value: LiteralMap;
    case: "inputData";
  } | { case: undefined; value?: undefined } = { case: undefined };

  /**
   * @generated from oneof flyteidl.event.TaskExecutionEvent.output_result
   */
  outputResult: {
    /**
     * URI to the output of the execution, it will be in a format that encodes all the information
     * including Cloud source provider. ie., s3://...
     *
     * @generated from field: string output_uri = 9;
     */
    value: string;
    case: "outputUri";
  } | {
    /**
     * Error information for the execution
     *
     * @generated from field: flyteidl.core.ExecutionError error = 10;
     */
    value: ExecutionError;
    case: "error";
  } | {
    /**
     * Raw output data produced by this task execution.
     *
     * @generated from field: flyteidl.core.LiteralMap output_data = 17;
     */
    value: LiteralMap;
    case: "outputData";
  } | { case: undefined; value?: undefined } = { case: undefined };

  /**
   * Custom data that the task plugin sends back. This is extensible to allow various plugins in the system.
   *
   * @generated from field: google.protobuf.Struct custom_info = 11;
   */
  customInfo?: Struct;

  /**
   * Some phases, like RUNNING, can send multiple events with changed metadata (new logs, additional custom_info, etc)
   * that should be recorded regardless of the lack of phase change.
   * The version field should be incremented when metadata changes across the duration of an individual phase.
   *
   * @generated from field: uint32 phase_version = 12;
   */
  phaseVersion = 0;

  /**
   * An optional explanation for the phase transition.
   * Deprecated: Use reasons instead.
   *
   * @generated from field: string reason = 13 [deprecated = true];
   * @deprecated
   */
  reason = "";

  /**
   * An optional list of explanations for the phase transition.
   *
   * @generated from field: repeated flyteidl.event.EventReason reasons = 21;
   */
  reasons: EventReason[] = [];

  /**
   * A predefined yet extensible Task type identifier. If the task definition is already registered in flyte admin
   * this type will be identical, but not all task executions necessarily use pre-registered definitions and this
   * type is useful to render the task in the UI, filter task executions, etc.
   *
   * @generated from field: string task_type = 14;
   */
  taskType = "";

  /**
   * Metadata around how a task was executed.
   *
   * @generated from field: flyteidl.event.TaskExecutionMetadata metadata = 16;
   */
  metadata?: TaskExecutionMetadata;

  /**
   * The event version is used to indicate versioned changes in how data is reported using this
   * proto message. For example, event_verison > 0 means that maps tasks report logs using the
   * TaskExecutionMetadata ExternalResourceInfo fields for each subtask rather than the TaskLog
   * in this message.
   *
   * @generated from field: int32 event_version = 18;
   */
  eventVersion = 0;

  /**
   * This timestamp represents the instant when the event was reported by the executing framework. For example, a k8s
   * pod task may be marked completed at (ie. `occurred_at`) the instant the container running user code completes,
   * but this event will not be reported until the pod is marked as completed. Extracting both of these timestamps
   * facilitates a more accurate portrayal of the evaluation time-series. 
   *
   * @generated from field: google.protobuf.Timestamp reported_at = 20;
   */
  reportedAt?: Timestamp;

  constructor(data?: PartialMessage<TaskExecutionEvent>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.event.TaskExecutionEvent";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "task_id", kind: "message", T: Identifier },
    { no: 2, name: "parent_node_execution_id", kind: "message", T: NodeExecutionIdentifier },
    { no: 3, name: "retry_attempt", kind: "scalar", T: 13 /* ScalarType.UINT32 */ },
    { no: 4, name: "phase", kind: "enum", T: proto3.getEnumType(TaskExecution_Phase) },
    { no: 5, name: "producer_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 6, name: "logs", kind: "message", T: TaskLog, repeated: true },
    { no: 7, name: "occurred_at", kind: "message", T: Timestamp },
    { no: 8, name: "input_uri", kind: "scalar", T: 9 /* ScalarType.STRING */, oneof: "input_value" },
    { no: 19, name: "input_data", kind: "message", T: LiteralMap, oneof: "input_value" },
    { no: 9, name: "output_uri", kind: "scalar", T: 9 /* ScalarType.STRING */, oneof: "output_result" },
    { no: 10, name: "error", kind: "message", T: ExecutionError, oneof: "output_result" },
    { no: 17, name: "output_data", kind: "message", T: LiteralMap, oneof: "output_result" },
    { no: 11, name: "custom_info", kind: "message", T: Struct },
    { no: 12, name: "phase_version", kind: "scalar", T: 13 /* ScalarType.UINT32 */ },
    { no: 13, name: "reason", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 21, name: "reasons", kind: "message", T: EventReason, repeated: true },
    { no: 14, name: "task_type", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 16, name: "metadata", kind: "message", T: TaskExecutionMetadata },
    { no: 18, name: "event_version", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
    { no: 20, name: "reported_at", kind: "message", T: Timestamp },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TaskExecutionEvent {
    return new TaskExecutionEvent().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TaskExecutionEvent {
    return new TaskExecutionEvent().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TaskExecutionEvent {
    return new TaskExecutionEvent().fromJsonString(jsonString, options);
  }

  static equals(a: TaskExecutionEvent | PlainMessage<TaskExecutionEvent> | undefined, b: TaskExecutionEvent | PlainMessage<TaskExecutionEvent> | undefined): boolean {
    return proto3.util.equals(TaskExecutionEvent, a, b);
  }
}

/**
 * This message contains metadata about external resources produced or used by a specific task execution.
 *
 * @generated from message flyteidl.event.ExternalResourceInfo
 */
export class ExternalResourceInfo extends Message<ExternalResourceInfo> {
  /**
   * Identifier for an external resource created by this task execution, for example Qubole query ID or presto query ids.
   *
   * @generated from field: string external_id = 1;
   */
  externalId = "";

  /**
   * A unique index for the external resource with respect to all external resources for this task. Although the
   * identifier may change between task reporting events or retries, this will remain the same to enable aggregating
   * information from multiple reports.
   *
   * @generated from field: uint32 index = 2;
   */
  index = 0;

  /**
   * Retry attempt number for this external resource, ie., 2 for the second attempt
   *
   * @generated from field: uint32 retry_attempt = 3;
   */
  retryAttempt = 0;

  /**
   * Phase associated with the external resource
   *
   * @generated from field: flyteidl.core.TaskExecution.Phase phase = 4;
   */
  phase = TaskExecution_Phase.UNDEFINED;

  /**
   * Captures the status of caching for this external resource execution.
   *
   * @generated from field: flyteidl.core.CatalogCacheStatus cache_status = 5;
   */
  cacheStatus = CatalogCacheStatus.CACHE_DISABLED;

  /**
   * log information for the external resource execution
   *
   * @generated from field: repeated flyteidl.core.TaskLog logs = 6;
   */
  logs: TaskLog[] = [];

  constructor(data?: PartialMessage<ExternalResourceInfo>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.event.ExternalResourceInfo";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "external_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "index", kind: "scalar", T: 13 /* ScalarType.UINT32 */ },
    { no: 3, name: "retry_attempt", kind: "scalar", T: 13 /* ScalarType.UINT32 */ },
    { no: 4, name: "phase", kind: "enum", T: proto3.getEnumType(TaskExecution_Phase) },
    { no: 5, name: "cache_status", kind: "enum", T: proto3.getEnumType(CatalogCacheStatus) },
    { no: 6, name: "logs", kind: "message", T: TaskLog, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExternalResourceInfo {
    return new ExternalResourceInfo().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExternalResourceInfo {
    return new ExternalResourceInfo().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExternalResourceInfo {
    return new ExternalResourceInfo().fromJsonString(jsonString, options);
  }

  static equals(a: ExternalResourceInfo | PlainMessage<ExternalResourceInfo> | undefined, b: ExternalResourceInfo | PlainMessage<ExternalResourceInfo> | undefined): boolean {
    return proto3.util.equals(ExternalResourceInfo, a, b);
  }
}

/**
 * This message holds task execution metadata specific to resource allocation used to manage concurrent
 * executions for a project namespace.
 *
 * @generated from message flyteidl.event.ResourcePoolInfo
 */
export class ResourcePoolInfo extends Message<ResourcePoolInfo> {
  /**
   * Unique resource ID used to identify this execution when allocating a token.
   *
   * @generated from field: string allocation_token = 1;
   */
  allocationToken = "";

  /**
   * Namespace under which this task execution requested an allocation token.
   *
   * @generated from field: string namespace = 2;
   */
  namespace = "";

  constructor(data?: PartialMessage<ResourcePoolInfo>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.event.ResourcePoolInfo";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "allocation_token", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "namespace", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ResourcePoolInfo {
    return new ResourcePoolInfo().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ResourcePoolInfo {
    return new ResourcePoolInfo().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ResourcePoolInfo {
    return new ResourcePoolInfo().fromJsonString(jsonString, options);
  }

  static equals(a: ResourcePoolInfo | PlainMessage<ResourcePoolInfo> | undefined, b: ResourcePoolInfo | PlainMessage<ResourcePoolInfo> | undefined): boolean {
    return proto3.util.equals(ResourcePoolInfo, a, b);
  }
}

/**
 * Holds metadata around how a task was executed.
 * As a task transitions across event phases during execution some attributes, such its generated name, generated external resources,
 * and more may grow in size but not change necessarily based on the phase transition that sparked the event update.
 * Metadata is a container for these attributes across the task execution lifecycle.
 *
 * @generated from message flyteidl.event.TaskExecutionMetadata
 */
export class TaskExecutionMetadata extends Message<TaskExecutionMetadata> {
  /**
   * Unique, generated name for this task execution used by the backend.
   *
   * @generated from field: string generated_name = 1;
   */
  generatedName = "";

  /**
   * Additional data on external resources on other back-ends or platforms (e.g. Hive, Qubole, etc) launched by this task execution.
   *
   * @generated from field: repeated flyteidl.event.ExternalResourceInfo external_resources = 2;
   */
  externalResources: ExternalResourceInfo[] = [];

  /**
   * Includes additional data on concurrent resource management used during execution..
   * This is a repeated field because a plugin can request multiple resource allocations during execution.
   *
   * @generated from field: repeated flyteidl.event.ResourcePoolInfo resource_pool_info = 3;
   */
  resourcePoolInfo: ResourcePoolInfo[] = [];

  /**
   * The identifier of the plugin used to execute this task.
   *
   * @generated from field: string plugin_identifier = 4;
   */
  pluginIdentifier = "";

  /**
   * @generated from field: flyteidl.event.TaskExecutionMetadata.InstanceClass instance_class = 16;
   */
  instanceClass = TaskExecutionMetadata_InstanceClass.DEFAULT;

  constructor(data?: PartialMessage<TaskExecutionMetadata>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.event.TaskExecutionMetadata";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "generated_name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "external_resources", kind: "message", T: ExternalResourceInfo, repeated: true },
    { no: 3, name: "resource_pool_info", kind: "message", T: ResourcePoolInfo, repeated: true },
    { no: 4, name: "plugin_identifier", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 16, name: "instance_class", kind: "enum", T: proto3.getEnumType(TaskExecutionMetadata_InstanceClass) },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TaskExecutionMetadata {
    return new TaskExecutionMetadata().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TaskExecutionMetadata {
    return new TaskExecutionMetadata().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TaskExecutionMetadata {
    return new TaskExecutionMetadata().fromJsonString(jsonString, options);
  }

  static equals(a: TaskExecutionMetadata | PlainMessage<TaskExecutionMetadata> | undefined, b: TaskExecutionMetadata | PlainMessage<TaskExecutionMetadata> | undefined): boolean {
    return proto3.util.equals(TaskExecutionMetadata, a, b);
  }
}

/**
 * Includes the broad category of machine used for this specific task execution.
 *
 * @generated from enum flyteidl.event.TaskExecutionMetadata.InstanceClass
 */
export enum TaskExecutionMetadata_InstanceClass {
  /**
   * The default instance class configured for the flyte application platform.
   *
   * @generated from enum value: DEFAULT = 0;
   */
  DEFAULT = 0,

  /**
   * The instance class configured for interruptible tasks.
   *
   * @generated from enum value: INTERRUPTIBLE = 1;
   */
  INTERRUPTIBLE = 1,
}
// Retrieve enum metadata with: proto3.getEnumType(TaskExecutionMetadata_InstanceClass)
proto3.util.setEnumType(TaskExecutionMetadata_InstanceClass, "flyteidl.event.TaskExecutionMetadata.InstanceClass", [
  { no: 0, name: "DEFAULT" },
  { no: 1, name: "INTERRUPTIBLE" },
]);

