// @generated by protoc-gen-es v1.7.2 with parameter "target=ts"
// @generated from file flyteidl/datacatalog/datacatalog.proto (package datacatalog, syntax proto3)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { Duration, Message, proto3, Timestamp } from "@bufbuild/protobuf";
import { Literal } from "../core/literals_pb.js";

/**
 *
 * Request message for creating a Dataset.
 *
 * @generated from message datacatalog.CreateDatasetRequest
 */
export class CreateDatasetRequest extends Message<CreateDatasetRequest> {
  /**
   * @generated from field: datacatalog.Dataset dataset = 1;
   */
  dataset?: Dataset;

  constructor(data?: PartialMessage<CreateDatasetRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.CreateDatasetRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "dataset", kind: "message", T: Dataset },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CreateDatasetRequest {
    return new CreateDatasetRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CreateDatasetRequest {
    return new CreateDatasetRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CreateDatasetRequest {
    return new CreateDatasetRequest().fromJsonString(jsonString, options);
  }

  static equals(a: CreateDatasetRequest | PlainMessage<CreateDatasetRequest> | undefined, b: CreateDatasetRequest | PlainMessage<CreateDatasetRequest> | undefined): boolean {
    return proto3.util.equals(CreateDatasetRequest, a, b);
  }
}

/**
 *
 * Response message for creating a Dataset
 *
 * @generated from message datacatalog.CreateDatasetResponse
 */
export class CreateDatasetResponse extends Message<CreateDatasetResponse> {
  constructor(data?: PartialMessage<CreateDatasetResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.CreateDatasetResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CreateDatasetResponse {
    return new CreateDatasetResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CreateDatasetResponse {
    return new CreateDatasetResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CreateDatasetResponse {
    return new CreateDatasetResponse().fromJsonString(jsonString, options);
  }

  static equals(a: CreateDatasetResponse | PlainMessage<CreateDatasetResponse> | undefined, b: CreateDatasetResponse | PlainMessage<CreateDatasetResponse> | undefined): boolean {
    return proto3.util.equals(CreateDatasetResponse, a, b);
  }
}

/**
 *
 * Request message for retrieving a Dataset. The Dataset is retrieved by it's unique identifier
 * which is a combination of several fields.
 *
 * @generated from message datacatalog.GetDatasetRequest
 */
export class GetDatasetRequest extends Message<GetDatasetRequest> {
  /**
   * @generated from field: datacatalog.DatasetID dataset = 1;
   */
  dataset?: DatasetID;

  constructor(data?: PartialMessage<GetDatasetRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.GetDatasetRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "dataset", kind: "message", T: DatasetID },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GetDatasetRequest {
    return new GetDatasetRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GetDatasetRequest {
    return new GetDatasetRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GetDatasetRequest {
    return new GetDatasetRequest().fromJsonString(jsonString, options);
  }

  static equals(a: GetDatasetRequest | PlainMessage<GetDatasetRequest> | undefined, b: GetDatasetRequest | PlainMessage<GetDatasetRequest> | undefined): boolean {
    return proto3.util.equals(GetDatasetRequest, a, b);
  }
}

/**
 *
 * Response message for retrieving a Dataset. The response will include the metadata for the
 * Dataset.
 *
 * @generated from message datacatalog.GetDatasetResponse
 */
export class GetDatasetResponse extends Message<GetDatasetResponse> {
  /**
   * @generated from field: datacatalog.Dataset dataset = 1;
   */
  dataset?: Dataset;

  constructor(data?: PartialMessage<GetDatasetResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.GetDatasetResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "dataset", kind: "message", T: Dataset },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GetDatasetResponse {
    return new GetDatasetResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GetDatasetResponse {
    return new GetDatasetResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GetDatasetResponse {
    return new GetDatasetResponse().fromJsonString(jsonString, options);
  }

  static equals(a: GetDatasetResponse | PlainMessage<GetDatasetResponse> | undefined, b: GetDatasetResponse | PlainMessage<GetDatasetResponse> | undefined): boolean {
    return proto3.util.equals(GetDatasetResponse, a, b);
  }
}

/**
 *
 * Request message for retrieving an Artifact. Retrieve an artifact based on a query handle that
 * can be one of artifact_id or tag. The result returned will include the artifact data and metadata
 * associated with the artifact.
 *
 * @generated from message datacatalog.GetArtifactRequest
 */
export class GetArtifactRequest extends Message<GetArtifactRequest> {
  /**
   * @generated from field: datacatalog.DatasetID dataset = 1;
   */
  dataset?: DatasetID;

  /**
   * @generated from oneof datacatalog.GetArtifactRequest.query_handle
   */
  queryHandle: {
    /**
     * @generated from field: string artifact_id = 2;
     */
    value: string;
    case: "artifactId";
  } | {
    /**
     * @generated from field: string tag_name = 3;
     */
    value: string;
    case: "tagName";
  } | { case: undefined; value?: undefined } = { case: undefined };

  constructor(data?: PartialMessage<GetArtifactRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.GetArtifactRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "dataset", kind: "message", T: DatasetID },
    { no: 2, name: "artifact_id", kind: "scalar", T: 9 /* ScalarType.STRING */, oneof: "query_handle" },
    { no: 3, name: "tag_name", kind: "scalar", T: 9 /* ScalarType.STRING */, oneof: "query_handle" },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GetArtifactRequest {
    return new GetArtifactRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GetArtifactRequest {
    return new GetArtifactRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GetArtifactRequest {
    return new GetArtifactRequest().fromJsonString(jsonString, options);
  }

  static equals(a: GetArtifactRequest | PlainMessage<GetArtifactRequest> | undefined, b: GetArtifactRequest | PlainMessage<GetArtifactRequest> | undefined): boolean {
    return proto3.util.equals(GetArtifactRequest, a, b);
  }
}

/**
 *
 * Response message for retrieving an Artifact. The result returned will include the artifact data
 * and metadata associated with the artifact.
 *
 * @generated from message datacatalog.GetArtifactResponse
 */
export class GetArtifactResponse extends Message<GetArtifactResponse> {
  /**
   * @generated from field: datacatalog.Artifact artifact = 1;
   */
  artifact?: Artifact;

  constructor(data?: PartialMessage<GetArtifactResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.GetArtifactResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "artifact", kind: "message", T: Artifact },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GetArtifactResponse {
    return new GetArtifactResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GetArtifactResponse {
    return new GetArtifactResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GetArtifactResponse {
    return new GetArtifactResponse().fromJsonString(jsonString, options);
  }

  static equals(a: GetArtifactResponse | PlainMessage<GetArtifactResponse> | undefined, b: GetArtifactResponse | PlainMessage<GetArtifactResponse> | undefined): boolean {
    return proto3.util.equals(GetArtifactResponse, a, b);
  }
}

/**
 *
 * Request message for creating an Artifact and its associated artifact Data.
 *
 * @generated from message datacatalog.CreateArtifactRequest
 */
export class CreateArtifactRequest extends Message<CreateArtifactRequest> {
  /**
   * @generated from field: datacatalog.Artifact artifact = 1;
   */
  artifact?: Artifact;

  constructor(data?: PartialMessage<CreateArtifactRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.CreateArtifactRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "artifact", kind: "message", T: Artifact },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CreateArtifactRequest {
    return new CreateArtifactRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CreateArtifactRequest {
    return new CreateArtifactRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CreateArtifactRequest {
    return new CreateArtifactRequest().fromJsonString(jsonString, options);
  }

  static equals(a: CreateArtifactRequest | PlainMessage<CreateArtifactRequest> | undefined, b: CreateArtifactRequest | PlainMessage<CreateArtifactRequest> | undefined): boolean {
    return proto3.util.equals(CreateArtifactRequest, a, b);
  }
}

/**
 *
 * Response message for creating an Artifact.
 *
 * @generated from message datacatalog.CreateArtifactResponse
 */
export class CreateArtifactResponse extends Message<CreateArtifactResponse> {
  constructor(data?: PartialMessage<CreateArtifactResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.CreateArtifactResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CreateArtifactResponse {
    return new CreateArtifactResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CreateArtifactResponse {
    return new CreateArtifactResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CreateArtifactResponse {
    return new CreateArtifactResponse().fromJsonString(jsonString, options);
  }

  static equals(a: CreateArtifactResponse | PlainMessage<CreateArtifactResponse> | undefined, b: CreateArtifactResponse | PlainMessage<CreateArtifactResponse> | undefined): boolean {
    return proto3.util.equals(CreateArtifactResponse, a, b);
  }
}

/**
 *
 * Request message for tagging an Artifact.
 *
 * @generated from message datacatalog.AddTagRequest
 */
export class AddTagRequest extends Message<AddTagRequest> {
  /**
   * @generated from field: datacatalog.Tag tag = 1;
   */
  tag?: Tag;

  constructor(data?: PartialMessage<AddTagRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.AddTagRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "tag", kind: "message", T: Tag },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): AddTagRequest {
    return new AddTagRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): AddTagRequest {
    return new AddTagRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): AddTagRequest {
    return new AddTagRequest().fromJsonString(jsonString, options);
  }

  static equals(a: AddTagRequest | PlainMessage<AddTagRequest> | undefined, b: AddTagRequest | PlainMessage<AddTagRequest> | undefined): boolean {
    return proto3.util.equals(AddTagRequest, a, b);
  }
}

/**
 *
 * Response message for tagging an Artifact.
 *
 * @generated from message datacatalog.AddTagResponse
 */
export class AddTagResponse extends Message<AddTagResponse> {
  constructor(data?: PartialMessage<AddTagResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.AddTagResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): AddTagResponse {
    return new AddTagResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): AddTagResponse {
    return new AddTagResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): AddTagResponse {
    return new AddTagResponse().fromJsonString(jsonString, options);
  }

  static equals(a: AddTagResponse | PlainMessage<AddTagResponse> | undefined, b: AddTagResponse | PlainMessage<AddTagResponse> | undefined): boolean {
    return proto3.util.equals(AddTagResponse, a, b);
  }
}

/**
 * List the artifacts that belong to the Dataset, optionally filtered using filtered expression.
 *
 * @generated from message datacatalog.ListArtifactsRequest
 */
export class ListArtifactsRequest extends Message<ListArtifactsRequest> {
  /**
   * Use a datasetID for which you want to retrieve the artifacts
   *
   * @generated from field: datacatalog.DatasetID dataset = 1;
   */
  dataset?: DatasetID;

  /**
   * Apply the filter expression to this query
   *
   * @generated from field: datacatalog.FilterExpression filter = 2;
   */
  filter?: FilterExpression;

  /**
   * Pagination options to get a page of artifacts
   *
   * @generated from field: datacatalog.PaginationOptions pagination = 3;
   */
  pagination?: PaginationOptions;

  constructor(data?: PartialMessage<ListArtifactsRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.ListArtifactsRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "dataset", kind: "message", T: DatasetID },
    { no: 2, name: "filter", kind: "message", T: FilterExpression },
    { no: 3, name: "pagination", kind: "message", T: PaginationOptions },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ListArtifactsRequest {
    return new ListArtifactsRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ListArtifactsRequest {
    return new ListArtifactsRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ListArtifactsRequest {
    return new ListArtifactsRequest().fromJsonString(jsonString, options);
  }

  static equals(a: ListArtifactsRequest | PlainMessage<ListArtifactsRequest> | undefined, b: ListArtifactsRequest | PlainMessage<ListArtifactsRequest> | undefined): boolean {
    return proto3.util.equals(ListArtifactsRequest, a, b);
  }
}

/**
 * Response to list artifacts
 *
 * @generated from message datacatalog.ListArtifactsResponse
 */
export class ListArtifactsResponse extends Message<ListArtifactsResponse> {
  /**
   * The list of artifacts
   *
   * @generated from field: repeated datacatalog.Artifact artifacts = 1;
   */
  artifacts: Artifact[] = [];

  /**
   * Token to use to request the next page, pass this into the next requests PaginationOptions
   *
   * @generated from field: string next_token = 2;
   */
  nextToken = "";

  constructor(data?: PartialMessage<ListArtifactsResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.ListArtifactsResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "artifacts", kind: "message", T: Artifact, repeated: true },
    { no: 2, name: "next_token", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ListArtifactsResponse {
    return new ListArtifactsResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ListArtifactsResponse {
    return new ListArtifactsResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ListArtifactsResponse {
    return new ListArtifactsResponse().fromJsonString(jsonString, options);
  }

  static equals(a: ListArtifactsResponse | PlainMessage<ListArtifactsResponse> | undefined, b: ListArtifactsResponse | PlainMessage<ListArtifactsResponse> | undefined): boolean {
    return proto3.util.equals(ListArtifactsResponse, a, b);
  }
}

/**
 * List the datasets for the given query
 *
 * @generated from message datacatalog.ListDatasetsRequest
 */
export class ListDatasetsRequest extends Message<ListDatasetsRequest> {
  /**
   * Apply the filter expression to this query
   *
   * @generated from field: datacatalog.FilterExpression filter = 1;
   */
  filter?: FilterExpression;

  /**
   * Pagination options to get a page of datasets
   *
   * @generated from field: datacatalog.PaginationOptions pagination = 2;
   */
  pagination?: PaginationOptions;

  constructor(data?: PartialMessage<ListDatasetsRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.ListDatasetsRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "filter", kind: "message", T: FilterExpression },
    { no: 2, name: "pagination", kind: "message", T: PaginationOptions },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ListDatasetsRequest {
    return new ListDatasetsRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ListDatasetsRequest {
    return new ListDatasetsRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ListDatasetsRequest {
    return new ListDatasetsRequest().fromJsonString(jsonString, options);
  }

  static equals(a: ListDatasetsRequest | PlainMessage<ListDatasetsRequest> | undefined, b: ListDatasetsRequest | PlainMessage<ListDatasetsRequest> | undefined): boolean {
    return proto3.util.equals(ListDatasetsRequest, a, b);
  }
}

/**
 * List the datasets response with token for next pagination
 *
 * @generated from message datacatalog.ListDatasetsResponse
 */
export class ListDatasetsResponse extends Message<ListDatasetsResponse> {
  /**
   * The list of datasets
   *
   * @generated from field: repeated datacatalog.Dataset datasets = 1;
   */
  datasets: Dataset[] = [];

  /**
   * Token to use to request the next page, pass this into the next requests PaginationOptions
   *
   * @generated from field: string next_token = 2;
   */
  nextToken = "";

  constructor(data?: PartialMessage<ListDatasetsResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.ListDatasetsResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "datasets", kind: "message", T: Dataset, repeated: true },
    { no: 2, name: "next_token", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ListDatasetsResponse {
    return new ListDatasetsResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ListDatasetsResponse {
    return new ListDatasetsResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ListDatasetsResponse {
    return new ListDatasetsResponse().fromJsonString(jsonString, options);
  }

  static equals(a: ListDatasetsResponse | PlainMessage<ListDatasetsResponse> | undefined, b: ListDatasetsResponse | PlainMessage<ListDatasetsResponse> | undefined): boolean {
    return proto3.util.equals(ListDatasetsResponse, a, b);
  }
}

/**
 *
 * Request message for updating an Artifact and overwriting its associated ArtifactData.
 *
 * @generated from message datacatalog.UpdateArtifactRequest
 */
export class UpdateArtifactRequest extends Message<UpdateArtifactRequest> {
  /**
   * ID of dataset the artifact is associated with
   *
   * @generated from field: datacatalog.DatasetID dataset = 1;
   */
  dataset?: DatasetID;

  /**
   * Either ID of artifact or name of tag to retrieve existing artifact from
   *
   * @generated from oneof datacatalog.UpdateArtifactRequest.query_handle
   */
  queryHandle: {
    /**
     * @generated from field: string artifact_id = 2;
     */
    value: string;
    case: "artifactId";
  } | {
    /**
     * @generated from field: string tag_name = 3;
     */
    value: string;
    case: "tagName";
  } | { case: undefined; value?: undefined } = { case: undefined };

  /**
   * List of data to overwrite stored artifact data with. Must contain ALL data for updated Artifact as any missing
   * ArtifactData entries will be removed from the underlying blob storage and database.
   *
   * @generated from field: repeated datacatalog.ArtifactData data = 4;
   */
  data: ArtifactData[] = [];

  /**
   * Update execution metadata(including execution domain, name, node, project data) when overwriting cache
   *
   * @generated from field: datacatalog.Metadata metadata = 5;
   */
  metadata?: Metadata;

  constructor(data?: PartialMessage<UpdateArtifactRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.UpdateArtifactRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "dataset", kind: "message", T: DatasetID },
    { no: 2, name: "artifact_id", kind: "scalar", T: 9 /* ScalarType.STRING */, oneof: "query_handle" },
    { no: 3, name: "tag_name", kind: "scalar", T: 9 /* ScalarType.STRING */, oneof: "query_handle" },
    { no: 4, name: "data", kind: "message", T: ArtifactData, repeated: true },
    { no: 5, name: "metadata", kind: "message", T: Metadata },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): UpdateArtifactRequest {
    return new UpdateArtifactRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): UpdateArtifactRequest {
    return new UpdateArtifactRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): UpdateArtifactRequest {
    return new UpdateArtifactRequest().fromJsonString(jsonString, options);
  }

  static equals(a: UpdateArtifactRequest | PlainMessage<UpdateArtifactRequest> | undefined, b: UpdateArtifactRequest | PlainMessage<UpdateArtifactRequest> | undefined): boolean {
    return proto3.util.equals(UpdateArtifactRequest, a, b);
  }
}

/**
 *
 * Response message for updating an Artifact.
 *
 * @generated from message datacatalog.UpdateArtifactResponse
 */
export class UpdateArtifactResponse extends Message<UpdateArtifactResponse> {
  /**
   * The unique ID of the artifact updated
   *
   * @generated from field: string artifact_id = 1;
   */
  artifactId = "";

  constructor(data?: PartialMessage<UpdateArtifactResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.UpdateArtifactResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "artifact_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): UpdateArtifactResponse {
    return new UpdateArtifactResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): UpdateArtifactResponse {
    return new UpdateArtifactResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): UpdateArtifactResponse {
    return new UpdateArtifactResponse().fromJsonString(jsonString, options);
  }

  static equals(a: UpdateArtifactResponse | PlainMessage<UpdateArtifactResponse> | undefined, b: UpdateArtifactResponse | PlainMessage<UpdateArtifactResponse> | undefined): boolean {
    return proto3.util.equals(UpdateArtifactResponse, a, b);
  }
}

/**
 *
 * ReservationID message that is composed of several string fields.
 *
 * @generated from message datacatalog.ReservationID
 */
export class ReservationID extends Message<ReservationID> {
  /**
   * The unique ID for the reserved dataset
   *
   * @generated from field: datacatalog.DatasetID dataset_id = 1;
   */
  datasetId?: DatasetID;

  /**
   * The specific artifact tag for the reservation
   *
   * @generated from field: string tag_name = 2;
   */
  tagName = "";

  constructor(data?: PartialMessage<ReservationID>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.ReservationID";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "dataset_id", kind: "message", T: DatasetID },
    { no: 2, name: "tag_name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ReservationID {
    return new ReservationID().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ReservationID {
    return new ReservationID().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ReservationID {
    return new ReservationID().fromJsonString(jsonString, options);
  }

  static equals(a: ReservationID | PlainMessage<ReservationID> | undefined, b: ReservationID | PlainMessage<ReservationID> | undefined): boolean {
    return proto3.util.equals(ReservationID, a, b);
  }
}

/**
 * Try to acquire or extend an artifact reservation. If an active reservation exists, retrieve that instance.
 *
 * @generated from message datacatalog.GetOrExtendReservationRequest
 */
export class GetOrExtendReservationRequest extends Message<GetOrExtendReservationRequest> {
  /**
   * The unique ID for the reservation
   *
   * @generated from field: datacatalog.ReservationID reservation_id = 1;
   */
  reservationId?: ReservationID;

  /**
   * The unique ID of the owner for the reservation
   *
   * @generated from field: string owner_id = 2;
   */
  ownerId = "";

  /**
   * Requested reservation extension heartbeat interval
   *
   * @generated from field: google.protobuf.Duration heartbeat_interval = 3;
   */
  heartbeatInterval?: Duration;

  constructor(data?: PartialMessage<GetOrExtendReservationRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.GetOrExtendReservationRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "reservation_id", kind: "message", T: ReservationID },
    { no: 2, name: "owner_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "heartbeat_interval", kind: "message", T: Duration },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GetOrExtendReservationRequest {
    return new GetOrExtendReservationRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GetOrExtendReservationRequest {
    return new GetOrExtendReservationRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GetOrExtendReservationRequest {
    return new GetOrExtendReservationRequest().fromJsonString(jsonString, options);
  }

  static equals(a: GetOrExtendReservationRequest | PlainMessage<GetOrExtendReservationRequest> | undefined, b: GetOrExtendReservationRequest | PlainMessage<GetOrExtendReservationRequest> | undefined): boolean {
    return proto3.util.equals(GetOrExtendReservationRequest, a, b);
  }
}

/**
 * A reservation including owner, heartbeat interval, expiration timestamp, and various metadata.
 *
 * @generated from message datacatalog.Reservation
 */
export class Reservation extends Message<Reservation> {
  /**
   * The unique ID for the reservation
   *
   * @generated from field: datacatalog.ReservationID reservation_id = 1;
   */
  reservationId?: ReservationID;

  /**
   * The unique ID of the owner for the reservation
   *
   * @generated from field: string owner_id = 2;
   */
  ownerId = "";

  /**
   * Recommended heartbeat interval to extend reservation
   *
   * @generated from field: google.protobuf.Duration heartbeat_interval = 3;
   */
  heartbeatInterval?: Duration;

  /**
   * Expiration timestamp of this reservation
   *
   * @generated from field: google.protobuf.Timestamp expires_at = 4;
   */
  expiresAt?: Timestamp;

  /**
   * Free-form metadata associated with the artifact
   *
   * @generated from field: datacatalog.Metadata metadata = 6;
   */
  metadata?: Metadata;

  constructor(data?: PartialMessage<Reservation>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.Reservation";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "reservation_id", kind: "message", T: ReservationID },
    { no: 2, name: "owner_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "heartbeat_interval", kind: "message", T: Duration },
    { no: 4, name: "expires_at", kind: "message", T: Timestamp },
    { no: 6, name: "metadata", kind: "message", T: Metadata },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Reservation {
    return new Reservation().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Reservation {
    return new Reservation().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Reservation {
    return new Reservation().fromJsonString(jsonString, options);
  }

  static equals(a: Reservation | PlainMessage<Reservation> | undefined, b: Reservation | PlainMessage<Reservation> | undefined): boolean {
    return proto3.util.equals(Reservation, a, b);
  }
}

/**
 * Response including either a newly minted reservation or the existing reservation
 *
 * @generated from message datacatalog.GetOrExtendReservationResponse
 */
export class GetOrExtendReservationResponse extends Message<GetOrExtendReservationResponse> {
  /**
   * The reservation to be acquired or extended
   *
   * @generated from field: datacatalog.Reservation reservation = 1;
   */
  reservation?: Reservation;

  constructor(data?: PartialMessage<GetOrExtendReservationResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.GetOrExtendReservationResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "reservation", kind: "message", T: Reservation },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GetOrExtendReservationResponse {
    return new GetOrExtendReservationResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GetOrExtendReservationResponse {
    return new GetOrExtendReservationResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GetOrExtendReservationResponse {
    return new GetOrExtendReservationResponse().fromJsonString(jsonString, options);
  }

  static equals(a: GetOrExtendReservationResponse | PlainMessage<GetOrExtendReservationResponse> | undefined, b: GetOrExtendReservationResponse | PlainMessage<GetOrExtendReservationResponse> | undefined): boolean {
    return proto3.util.equals(GetOrExtendReservationResponse, a, b);
  }
}

/**
 * Request to release reservation
 *
 * @generated from message datacatalog.ReleaseReservationRequest
 */
export class ReleaseReservationRequest extends Message<ReleaseReservationRequest> {
  /**
   * The unique ID for the reservation
   *
   * @generated from field: datacatalog.ReservationID reservation_id = 1;
   */
  reservationId?: ReservationID;

  /**
   * The unique ID of the owner for the reservation
   *
   * @generated from field: string owner_id = 2;
   */
  ownerId = "";

  constructor(data?: PartialMessage<ReleaseReservationRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.ReleaseReservationRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "reservation_id", kind: "message", T: ReservationID },
    { no: 2, name: "owner_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ReleaseReservationRequest {
    return new ReleaseReservationRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ReleaseReservationRequest {
    return new ReleaseReservationRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ReleaseReservationRequest {
    return new ReleaseReservationRequest().fromJsonString(jsonString, options);
  }

  static equals(a: ReleaseReservationRequest | PlainMessage<ReleaseReservationRequest> | undefined, b: ReleaseReservationRequest | PlainMessage<ReleaseReservationRequest> | undefined): boolean {
    return proto3.util.equals(ReleaseReservationRequest, a, b);
  }
}

/**
 * Response to release reservation
 *
 * @generated from message datacatalog.ReleaseReservationResponse
 */
export class ReleaseReservationResponse extends Message<ReleaseReservationResponse> {
  constructor(data?: PartialMessage<ReleaseReservationResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.ReleaseReservationResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ReleaseReservationResponse {
    return new ReleaseReservationResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ReleaseReservationResponse {
    return new ReleaseReservationResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ReleaseReservationResponse {
    return new ReleaseReservationResponse().fromJsonString(jsonString, options);
  }

  static equals(a: ReleaseReservationResponse | PlainMessage<ReleaseReservationResponse> | undefined, b: ReleaseReservationResponse | PlainMessage<ReleaseReservationResponse> | undefined): boolean {
    return proto3.util.equals(ReleaseReservationResponse, a, b);
  }
}

/**
 *
 * Dataset message. It is uniquely identified by DatasetID.
 *
 * @generated from message datacatalog.Dataset
 */
export class Dataset extends Message<Dataset> {
  /**
   * @generated from field: datacatalog.DatasetID id = 1;
   */
  id?: DatasetID;

  /**
   * @generated from field: datacatalog.Metadata metadata = 2;
   */
  metadata?: Metadata;

  /**
   * @generated from field: repeated string partitionKeys = 3;
   */
  partitionKeys: string[] = [];

  constructor(data?: PartialMessage<Dataset>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.Dataset";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "message", T: DatasetID },
    { no: 2, name: "metadata", kind: "message", T: Metadata },
    { no: 3, name: "partitionKeys", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Dataset {
    return new Dataset().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Dataset {
    return new Dataset().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Dataset {
    return new Dataset().fromJsonString(jsonString, options);
  }

  static equals(a: Dataset | PlainMessage<Dataset> | undefined, b: Dataset | PlainMessage<Dataset> | undefined): boolean {
    return proto3.util.equals(Dataset, a, b);
  }
}

/**
 *
 * An artifact could have multiple partitions and each partition can have an arbitrary string key/value pair
 *
 * @generated from message datacatalog.Partition
 */
export class Partition extends Message<Partition> {
  /**
   * @generated from field: string key = 1;
   */
  key = "";

  /**
   * @generated from field: string value = 2;
   */
  value = "";

  constructor(data?: PartialMessage<Partition>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.Partition";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "key", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "value", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Partition {
    return new Partition().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Partition {
    return new Partition().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Partition {
    return new Partition().fromJsonString(jsonString, options);
  }

  static equals(a: Partition | PlainMessage<Partition> | undefined, b: Partition | PlainMessage<Partition> | undefined): boolean {
    return proto3.util.equals(Partition, a, b);
  }
}

/**
 *
 * DatasetID message that is composed of several string fields.
 *
 * @generated from message datacatalog.DatasetID
 */
export class DatasetID extends Message<DatasetID> {
  /**
   * The name of the project
   *
   * @generated from field: string project = 1;
   */
  project = "";

  /**
   * The name of the dataset
   *
   * @generated from field: string name = 2;
   */
  name = "";

  /**
   * The domain (eg. environment)
   *
   * @generated from field: string domain = 3;
   */
  domain = "";

  /**
   * Version of the data schema
   *
   * @generated from field: string version = 4;
   */
  version = "";

  /**
   * UUID for the dataset (if set the above fields are optional)
   *
   * @generated from field: string UUID = 5;
   */
  UUID = "";

  /**
   * Optional, org key applied to the resource.
   *
   * @generated from field: string org = 6;
   */
  org = "";

  constructor(data?: PartialMessage<DatasetID>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.DatasetID";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "project", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "domain", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 4, name: "version", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 5, name: "UUID", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 6, name: "org", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): DatasetID {
    return new DatasetID().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): DatasetID {
    return new DatasetID().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): DatasetID {
    return new DatasetID().fromJsonString(jsonString, options);
  }

  static equals(a: DatasetID | PlainMessage<DatasetID> | undefined, b: DatasetID | PlainMessage<DatasetID> | undefined): boolean {
    return proto3.util.equals(DatasetID, a, b);
  }
}

/**
 *
 * Artifact message. It is composed of several string fields.
 *
 * @generated from message datacatalog.Artifact
 */
export class Artifact extends Message<Artifact> {
  /**
   * The unique ID of the artifact
   *
   * @generated from field: string id = 1;
   */
  id = "";

  /**
   * The Dataset that the artifact belongs to
   *
   * @generated from field: datacatalog.DatasetID dataset = 2;
   */
  dataset?: DatasetID;

  /**
   * A list of data that is associated with the artifact
   *
   * @generated from field: repeated datacatalog.ArtifactData data = 3;
   */
  data: ArtifactData[] = [];

  /**
   * Free-form metadata associated with the artifact
   *
   * @generated from field: datacatalog.Metadata metadata = 4;
   */
  metadata?: Metadata;

  /**
   * @generated from field: repeated datacatalog.Partition partitions = 5;
   */
  partitions: Partition[] = [];

  /**
   * @generated from field: repeated datacatalog.Tag tags = 6;
   */
  tags: Tag[] = [];

  /**
   * creation timestamp of artifact, autogenerated by service
   *
   * @generated from field: google.protobuf.Timestamp created_at = 7;
   */
  createdAt?: Timestamp;

  constructor(data?: PartialMessage<Artifact>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.Artifact";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "dataset", kind: "message", T: DatasetID },
    { no: 3, name: "data", kind: "message", T: ArtifactData, repeated: true },
    { no: 4, name: "metadata", kind: "message", T: Metadata },
    { no: 5, name: "partitions", kind: "message", T: Partition, repeated: true },
    { no: 6, name: "tags", kind: "message", T: Tag, repeated: true },
    { no: 7, name: "created_at", kind: "message", T: Timestamp },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Artifact {
    return new Artifact().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Artifact {
    return new Artifact().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Artifact {
    return new Artifact().fromJsonString(jsonString, options);
  }

  static equals(a: Artifact | PlainMessage<Artifact> | undefined, b: Artifact | PlainMessage<Artifact> | undefined): boolean {
    return proto3.util.equals(Artifact, a, b);
  }
}

/**
 *
 * ArtifactData that belongs to an artifact
 *
 * @generated from message datacatalog.ArtifactData
 */
export class ArtifactData extends Message<ArtifactData> {
  /**
   * @generated from field: string name = 1;
   */
  name = "";

  /**
   * @generated from field: flyteidl.core.Literal value = 2;
   */
  value?: Literal;

  constructor(data?: PartialMessage<ArtifactData>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.ArtifactData";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "value", kind: "message", T: Literal },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ArtifactData {
    return new ArtifactData().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ArtifactData {
    return new ArtifactData().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ArtifactData {
    return new ArtifactData().fromJsonString(jsonString, options);
  }

  static equals(a: ArtifactData | PlainMessage<ArtifactData> | undefined, b: ArtifactData | PlainMessage<ArtifactData> | undefined): boolean {
    return proto3.util.equals(ArtifactData, a, b);
  }
}

/**
 *
 * Tag message that is unique to a Dataset. It is associated to a single artifact and
 * can be retrieved by name later.
 *
 * @generated from message datacatalog.Tag
 */
export class Tag extends Message<Tag> {
  /**
   * Name of tag
   *
   * @generated from field: string name = 1;
   */
  name = "";

  /**
   * The tagged artifact
   *
   * @generated from field: string artifact_id = 2;
   */
  artifactId = "";

  /**
   * The Dataset that this tag belongs to
   *
   * @generated from field: datacatalog.DatasetID dataset = 3;
   */
  dataset?: DatasetID;

  constructor(data?: PartialMessage<Tag>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.Tag";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "artifact_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "dataset", kind: "message", T: DatasetID },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Tag {
    return new Tag().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Tag {
    return new Tag().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Tag {
    return new Tag().fromJsonString(jsonString, options);
  }

  static equals(a: Tag | PlainMessage<Tag> | undefined, b: Tag | PlainMessage<Tag> | undefined): boolean {
    return proto3.util.equals(Tag, a, b);
  }
}

/**
 *
 * Metadata representation for artifacts and datasets
 *
 * @generated from message datacatalog.Metadata
 */
export class Metadata extends Message<Metadata> {
  /**
   * key map is a dictionary of key/val strings that represent metadata
   *
   * @generated from field: map<string, string> key_map = 1;
   */
  keyMap: { [key: string]: string } = {};

  constructor(data?: PartialMessage<Metadata>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.Metadata";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "key_map", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Metadata {
    return new Metadata().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Metadata {
    return new Metadata().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Metadata {
    return new Metadata().fromJsonString(jsonString, options);
  }

  static equals(a: Metadata | PlainMessage<Metadata> | undefined, b: Metadata | PlainMessage<Metadata> | undefined): boolean {
    return proto3.util.equals(Metadata, a, b);
  }
}

/**
 * Filter expression that is composed of a combination of single filters
 *
 * @generated from message datacatalog.FilterExpression
 */
export class FilterExpression extends Message<FilterExpression> {
  /**
   * @generated from field: repeated datacatalog.SinglePropertyFilter filters = 1;
   */
  filters: SinglePropertyFilter[] = [];

  constructor(data?: PartialMessage<FilterExpression>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.FilterExpression";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "filters", kind: "message", T: SinglePropertyFilter, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): FilterExpression {
    return new FilterExpression().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): FilterExpression {
    return new FilterExpression().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): FilterExpression {
    return new FilterExpression().fromJsonString(jsonString, options);
  }

  static equals(a: FilterExpression | PlainMessage<FilterExpression> | undefined, b: FilterExpression | PlainMessage<FilterExpression> | undefined): boolean {
    return proto3.util.equals(FilterExpression, a, b);
  }
}

/**
 * A single property to filter on.
 *
 * @generated from message datacatalog.SinglePropertyFilter
 */
export class SinglePropertyFilter extends Message<SinglePropertyFilter> {
  /**
   * @generated from oneof datacatalog.SinglePropertyFilter.property_filter
   */
  propertyFilter: {
    /**
     * @generated from field: datacatalog.TagPropertyFilter tag_filter = 1;
     */
    value: TagPropertyFilter;
    case: "tagFilter";
  } | {
    /**
     * @generated from field: datacatalog.PartitionPropertyFilter partition_filter = 2;
     */
    value: PartitionPropertyFilter;
    case: "partitionFilter";
  } | {
    /**
     * @generated from field: datacatalog.ArtifactPropertyFilter artifact_filter = 3;
     */
    value: ArtifactPropertyFilter;
    case: "artifactFilter";
  } | {
    /**
     * @generated from field: datacatalog.DatasetPropertyFilter dataset_filter = 4;
     */
    value: DatasetPropertyFilter;
    case: "datasetFilter";
  } | { case: undefined; value?: undefined } = { case: undefined };

  /**
   * field 10 in case we add more entities to query
   *
   * @generated from field: datacatalog.SinglePropertyFilter.ComparisonOperator operator = 10;
   */
  operator = SinglePropertyFilter_ComparisonOperator.EQUALS;

  constructor(data?: PartialMessage<SinglePropertyFilter>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.SinglePropertyFilter";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "tag_filter", kind: "message", T: TagPropertyFilter, oneof: "property_filter" },
    { no: 2, name: "partition_filter", kind: "message", T: PartitionPropertyFilter, oneof: "property_filter" },
    { no: 3, name: "artifact_filter", kind: "message", T: ArtifactPropertyFilter, oneof: "property_filter" },
    { no: 4, name: "dataset_filter", kind: "message", T: DatasetPropertyFilter, oneof: "property_filter" },
    { no: 10, name: "operator", kind: "enum", T: proto3.getEnumType(SinglePropertyFilter_ComparisonOperator) },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SinglePropertyFilter {
    return new SinglePropertyFilter().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SinglePropertyFilter {
    return new SinglePropertyFilter().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SinglePropertyFilter {
    return new SinglePropertyFilter().fromJsonString(jsonString, options);
  }

  static equals(a: SinglePropertyFilter | PlainMessage<SinglePropertyFilter> | undefined, b: SinglePropertyFilter | PlainMessage<SinglePropertyFilter> | undefined): boolean {
    return proto3.util.equals(SinglePropertyFilter, a, b);
  }
}

/**
 * as use-cases come up we can add more operators, ex: gte, like, not eq etc.
 *
 * @generated from enum datacatalog.SinglePropertyFilter.ComparisonOperator
 */
export enum SinglePropertyFilter_ComparisonOperator {
  /**
   * @generated from enum value: EQUALS = 0;
   */
  EQUALS = 0,
}
// Retrieve enum metadata with: proto3.getEnumType(SinglePropertyFilter_ComparisonOperator)
proto3.util.setEnumType(SinglePropertyFilter_ComparisonOperator, "datacatalog.SinglePropertyFilter.ComparisonOperator", [
  { no: 0, name: "EQUALS" },
]);

/**
 * Artifact properties we can filter by
 *
 * @generated from message datacatalog.ArtifactPropertyFilter
 */
export class ArtifactPropertyFilter extends Message<ArtifactPropertyFilter> {
  /**
   * oneof because we can add more properties in the future
   *
   * @generated from oneof datacatalog.ArtifactPropertyFilter.property
   */
  property: {
    /**
     * @generated from field: string artifact_id = 1;
     */
    value: string;
    case: "artifactId";
  } | { case: undefined; value?: undefined } = { case: undefined };

  constructor(data?: PartialMessage<ArtifactPropertyFilter>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.ArtifactPropertyFilter";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "artifact_id", kind: "scalar", T: 9 /* ScalarType.STRING */, oneof: "property" },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ArtifactPropertyFilter {
    return new ArtifactPropertyFilter().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ArtifactPropertyFilter {
    return new ArtifactPropertyFilter().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ArtifactPropertyFilter {
    return new ArtifactPropertyFilter().fromJsonString(jsonString, options);
  }

  static equals(a: ArtifactPropertyFilter | PlainMessage<ArtifactPropertyFilter> | undefined, b: ArtifactPropertyFilter | PlainMessage<ArtifactPropertyFilter> | undefined): boolean {
    return proto3.util.equals(ArtifactPropertyFilter, a, b);
  }
}

/**
 * Tag properties we can filter by
 *
 * @generated from message datacatalog.TagPropertyFilter
 */
export class TagPropertyFilter extends Message<TagPropertyFilter> {
  /**
   * @generated from oneof datacatalog.TagPropertyFilter.property
   */
  property: {
    /**
     * @generated from field: string tag_name = 1;
     */
    value: string;
    case: "tagName";
  } | { case: undefined; value?: undefined } = { case: undefined };

  constructor(data?: PartialMessage<TagPropertyFilter>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.TagPropertyFilter";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "tag_name", kind: "scalar", T: 9 /* ScalarType.STRING */, oneof: "property" },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TagPropertyFilter {
    return new TagPropertyFilter().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TagPropertyFilter {
    return new TagPropertyFilter().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TagPropertyFilter {
    return new TagPropertyFilter().fromJsonString(jsonString, options);
  }

  static equals(a: TagPropertyFilter | PlainMessage<TagPropertyFilter> | undefined, b: TagPropertyFilter | PlainMessage<TagPropertyFilter> | undefined): boolean {
    return proto3.util.equals(TagPropertyFilter, a, b);
  }
}

/**
 * Partition properties we can filter by
 *
 * @generated from message datacatalog.PartitionPropertyFilter
 */
export class PartitionPropertyFilter extends Message<PartitionPropertyFilter> {
  /**
   * @generated from oneof datacatalog.PartitionPropertyFilter.property
   */
  property: {
    /**
     * @generated from field: datacatalog.KeyValuePair key_val = 1;
     */
    value: KeyValuePair;
    case: "keyVal";
  } | { case: undefined; value?: undefined } = { case: undefined };

  constructor(data?: PartialMessage<PartitionPropertyFilter>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.PartitionPropertyFilter";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "key_val", kind: "message", T: KeyValuePair, oneof: "property" },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PartitionPropertyFilter {
    return new PartitionPropertyFilter().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PartitionPropertyFilter {
    return new PartitionPropertyFilter().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PartitionPropertyFilter {
    return new PartitionPropertyFilter().fromJsonString(jsonString, options);
  }

  static equals(a: PartitionPropertyFilter | PlainMessage<PartitionPropertyFilter> | undefined, b: PartitionPropertyFilter | PlainMessage<PartitionPropertyFilter> | undefined): boolean {
    return proto3.util.equals(PartitionPropertyFilter, a, b);
  }
}

/**
 * @generated from message datacatalog.KeyValuePair
 */
export class KeyValuePair extends Message<KeyValuePair> {
  /**
   * @generated from field: string key = 1;
   */
  key = "";

  /**
   * @generated from field: string value = 2;
   */
  value = "";

  constructor(data?: PartialMessage<KeyValuePair>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.KeyValuePair";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "key", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "value", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): KeyValuePair {
    return new KeyValuePair().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): KeyValuePair {
    return new KeyValuePair().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): KeyValuePair {
    return new KeyValuePair().fromJsonString(jsonString, options);
  }

  static equals(a: KeyValuePair | PlainMessage<KeyValuePair> | undefined, b: KeyValuePair | PlainMessage<KeyValuePair> | undefined): boolean {
    return proto3.util.equals(KeyValuePair, a, b);
  }
}

/**
 * Dataset properties we can filter by
 *
 * @generated from message datacatalog.DatasetPropertyFilter
 */
export class DatasetPropertyFilter extends Message<DatasetPropertyFilter> {
  /**
   * @generated from oneof datacatalog.DatasetPropertyFilter.property
   */
  property: {
    /**
     * @generated from field: string project = 1;
     */
    value: string;
    case: "project";
  } | {
    /**
     * @generated from field: string name = 2;
     */
    value: string;
    case: "name";
  } | {
    /**
     * @generated from field: string domain = 3;
     */
    value: string;
    case: "domain";
  } | {
    /**
     * @generated from field: string version = 4;
     */
    value: string;
    case: "version";
  } | {
    /**
     * Optional, org key applied to the dataset.
     *
     * @generated from field: string org = 5;
     */
    value: string;
    case: "org";
  } | { case: undefined; value?: undefined } = { case: undefined };

  constructor(data?: PartialMessage<DatasetPropertyFilter>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.DatasetPropertyFilter";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "project", kind: "scalar", T: 9 /* ScalarType.STRING */, oneof: "property" },
    { no: 2, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, oneof: "property" },
    { no: 3, name: "domain", kind: "scalar", T: 9 /* ScalarType.STRING */, oneof: "property" },
    { no: 4, name: "version", kind: "scalar", T: 9 /* ScalarType.STRING */, oneof: "property" },
    { no: 5, name: "org", kind: "scalar", T: 9 /* ScalarType.STRING */, oneof: "property" },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): DatasetPropertyFilter {
    return new DatasetPropertyFilter().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): DatasetPropertyFilter {
    return new DatasetPropertyFilter().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): DatasetPropertyFilter {
    return new DatasetPropertyFilter().fromJsonString(jsonString, options);
  }

  static equals(a: DatasetPropertyFilter | PlainMessage<DatasetPropertyFilter> | undefined, b: DatasetPropertyFilter | PlainMessage<DatasetPropertyFilter> | undefined): boolean {
    return proto3.util.equals(DatasetPropertyFilter, a, b);
  }
}

/**
 * Pagination options for making list requests
 *
 * @generated from message datacatalog.PaginationOptions
 */
export class PaginationOptions extends Message<PaginationOptions> {
  /**
   * the max number of results to return
   *
   * @generated from field: uint32 limit = 1;
   */
  limit = 0;

  /**
   * the token to pass to fetch the next page
   *
   * @generated from field: string token = 2;
   */
  token = "";

  /**
   * the property that we want to sort the results by
   *
   * @generated from field: datacatalog.PaginationOptions.SortKey sortKey = 3;
   */
  sortKey = PaginationOptions_SortKey.CREATION_TIME;

  /**
   * the sort order of the results
   *
   * @generated from field: datacatalog.PaginationOptions.SortOrder sortOrder = 4;
   */
  sortOrder = PaginationOptions_SortOrder.DESCENDING;

  constructor(data?: PartialMessage<PaginationOptions>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "datacatalog.PaginationOptions";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "limit", kind: "scalar", T: 13 /* ScalarType.UINT32 */ },
    { no: 2, name: "token", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "sortKey", kind: "enum", T: proto3.getEnumType(PaginationOptions_SortKey) },
    { no: 4, name: "sortOrder", kind: "enum", T: proto3.getEnumType(PaginationOptions_SortOrder) },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PaginationOptions {
    return new PaginationOptions().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PaginationOptions {
    return new PaginationOptions().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PaginationOptions {
    return new PaginationOptions().fromJsonString(jsonString, options);
  }

  static equals(a: PaginationOptions | PlainMessage<PaginationOptions> | undefined, b: PaginationOptions | PlainMessage<PaginationOptions> | undefined): boolean {
    return proto3.util.equals(PaginationOptions, a, b);
  }
}

/**
 * @generated from enum datacatalog.PaginationOptions.SortOrder
 */
export enum PaginationOptions_SortOrder {
  /**
   * @generated from enum value: DESCENDING = 0;
   */
  DESCENDING = 0,

  /**
   * @generated from enum value: ASCENDING = 1;
   */
  ASCENDING = 1,
}
// Retrieve enum metadata with: proto3.getEnumType(PaginationOptions_SortOrder)
proto3.util.setEnumType(PaginationOptions_SortOrder, "datacatalog.PaginationOptions.SortOrder", [
  { no: 0, name: "DESCENDING" },
  { no: 1, name: "ASCENDING" },
]);

/**
 * @generated from enum datacatalog.PaginationOptions.SortKey
 */
export enum PaginationOptions_SortKey {
  /**
   * @generated from enum value: CREATION_TIME = 0;
   */
  CREATION_TIME = 0,
}
// Retrieve enum metadata with: proto3.getEnumType(PaginationOptions_SortKey)
proto3.util.setEnumType(PaginationOptions_SortKey, "datacatalog.PaginationOptions.SortKey", [
  { no: 0, name: "CREATION_TIME" },
]);

