// @generated by protoc-gen-es v1.7.2 with parameter "target=ts"
// @generated from file flyteidl/admin/common.proto (package flyteidl.admin, syntax proto3)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { Message, proto3, protoInt64 } from "@bufbuild/protobuf";
import { Identifier, ResourceType } from "../core/identifier_pb.js";
import { WorkflowExecution_Phase } from "../core/execution_pb.js";
import { KeyValuePair } from "../core/literals_pb.js";

/**
 * The status of the named entity is used to control its visibility in the UI.
 *
 * @generated from enum flyteidl.admin.NamedEntityState
 */
export enum NamedEntityState {
  /**
   * By default, all named entities are considered active and under development.
   *
   * @generated from enum value: NAMED_ENTITY_ACTIVE = 0;
   */
  NAMED_ENTITY_ACTIVE = 0,

  /**
   * Archived named entities are no longer visible in the UI.
   *
   * @generated from enum value: NAMED_ENTITY_ARCHIVED = 1;
   */
  NAMED_ENTITY_ARCHIVED = 1,

  /**
   * System generated entities that aren't explicitly created or managed by a user.
   *
   * @generated from enum value: SYSTEM_GENERATED = 2;
   */
  SYSTEM_GENERATED = 2,
}
// Retrieve enum metadata with: proto3.getEnumType(NamedEntityState)
proto3.util.setEnumType(NamedEntityState, "flyteidl.admin.NamedEntityState", [
  { no: 0, name: "NAMED_ENTITY_ACTIVE" },
  { no: 1, name: "NAMED_ENTITY_ARCHIVED" },
  { no: 2, name: "SYSTEM_GENERATED" },
]);

/**
 * Encapsulation of fields that identifies a Flyte resource.
 * A Flyte resource can be a task, workflow or launch plan.
 * A resource can internally have multiple versions and is uniquely identified
 * by project, domain, and name.
 *
 * @generated from message flyteidl.admin.NamedEntityIdentifier
 */
export class NamedEntityIdentifier extends Message<NamedEntityIdentifier> {
  /**
   * Name of the project the resource belongs to.
   *
   * @generated from field: string project = 1;
   */
  project = "";

  /**
   * Name of the domain the resource belongs to.
   * A domain can be considered as a subset within a specific project.
   *
   * @generated from field: string domain = 2;
   */
  domain = "";

  /**
   * User provided value for the resource.
   * The combination of project + domain + name uniquely identifies the resource.
   * +optional - in certain contexts - like 'List API', 'Launch plans'
   *
   * @generated from field: string name = 3;
   */
  name = "";

  /**
   * Optional, org key applied to the resource.
   *
   * @generated from field: string org = 4;
   */
  org = "";

  constructor(data?: PartialMessage<NamedEntityIdentifier>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.NamedEntityIdentifier";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "project", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "domain", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 4, name: "org", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NamedEntityIdentifier {
    return new NamedEntityIdentifier().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NamedEntityIdentifier {
    return new NamedEntityIdentifier().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NamedEntityIdentifier {
    return new NamedEntityIdentifier().fromJsonString(jsonString, options);
  }

  static equals(a: NamedEntityIdentifier | PlainMessage<NamedEntityIdentifier> | undefined, b: NamedEntityIdentifier | PlainMessage<NamedEntityIdentifier> | undefined): boolean {
    return proto3.util.equals(NamedEntityIdentifier, a, b);
  }
}

/**
 * Additional metadata around a named entity.
 *
 * @generated from message flyteidl.admin.NamedEntityMetadata
 */
export class NamedEntityMetadata extends Message<NamedEntityMetadata> {
  /**
   * Common description across all versions of the entity
   * +optional
   *
   * @generated from field: string description = 1;
   */
  description = "";

  /**
   * Shared state across all version of the entity
   * At this point in time, only workflow entities can have their state archived.
   *
   * @generated from field: flyteidl.admin.NamedEntityState state = 2;
   */
  state = NamedEntityState.NAMED_ENTITY_ACTIVE;

  constructor(data?: PartialMessage<NamedEntityMetadata>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.NamedEntityMetadata";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "description", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "state", kind: "enum", T: proto3.getEnumType(NamedEntityState) },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NamedEntityMetadata {
    return new NamedEntityMetadata().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NamedEntityMetadata {
    return new NamedEntityMetadata().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NamedEntityMetadata {
    return new NamedEntityMetadata().fromJsonString(jsonString, options);
  }

  static equals(a: NamedEntityMetadata | PlainMessage<NamedEntityMetadata> | undefined, b: NamedEntityMetadata | PlainMessage<NamedEntityMetadata> | undefined): boolean {
    return proto3.util.equals(NamedEntityMetadata, a, b);
  }
}

/**
 * Encapsulates information common to a NamedEntity, a Flyte resource such as a task,
 * workflow or launch plan. A NamedEntity is exclusively identified by its resource type
 * and identifier.
 *
 * @generated from message flyteidl.admin.NamedEntity
 */
export class NamedEntity extends Message<NamedEntity> {
  /**
   * Resource type of the named entity. One of Task, Workflow or LaunchPlan.
   *
   * @generated from field: flyteidl.core.ResourceType resource_type = 1;
   */
  resourceType = ResourceType.UNSPECIFIED;

  /**
   * @generated from field: flyteidl.admin.NamedEntityIdentifier id = 2;
   */
  id?: NamedEntityIdentifier;

  /**
   * Additional metadata around a named entity.
   *
   * @generated from field: flyteidl.admin.NamedEntityMetadata metadata = 3;
   */
  metadata?: NamedEntityMetadata;

  constructor(data?: PartialMessage<NamedEntity>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.NamedEntity";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "resource_type", kind: "enum", T: proto3.getEnumType(ResourceType) },
    { no: 2, name: "id", kind: "message", T: NamedEntityIdentifier },
    { no: 3, name: "metadata", kind: "message", T: NamedEntityMetadata },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NamedEntity {
    return new NamedEntity().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NamedEntity {
    return new NamedEntity().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NamedEntity {
    return new NamedEntity().fromJsonString(jsonString, options);
  }

  static equals(a: NamedEntity | PlainMessage<NamedEntity> | undefined, b: NamedEntity | PlainMessage<NamedEntity> | undefined): boolean {
    return proto3.util.equals(NamedEntity, a, b);
  }
}

/**
 * Specifies sort ordering in a list request.
 *
 * @generated from message flyteidl.admin.Sort
 */
export class Sort extends Message<Sort> {
  /**
   * Indicates an attribute to sort the response values.
   * +required
   *
   * @generated from field: string key = 1;
   */
  key = "";

  /**
   * Indicates the direction to apply sort key for response values.
   * +optional
   *
   * @generated from field: flyteidl.admin.Sort.Direction direction = 2;
   */
  direction = Sort_Direction.DESCENDING;

  constructor(data?: PartialMessage<Sort>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.Sort";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "key", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "direction", kind: "enum", T: proto3.getEnumType(Sort_Direction) },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Sort {
    return new Sort().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Sort {
    return new Sort().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Sort {
    return new Sort().fromJsonString(jsonString, options);
  }

  static equals(a: Sort | PlainMessage<Sort> | undefined, b: Sort | PlainMessage<Sort> | undefined): boolean {
    return proto3.util.equals(Sort, a, b);
  }
}

/**
 * @generated from enum flyteidl.admin.Sort.Direction
 */
export enum Sort_Direction {
  /**
   * By default, fields are sorted in descending order.
   *
   * @generated from enum value: DESCENDING = 0;
   */
  DESCENDING = 0,

  /**
   * @generated from enum value: ASCENDING = 1;
   */
  ASCENDING = 1,
}
// Retrieve enum metadata with: proto3.getEnumType(Sort_Direction)
proto3.util.setEnumType(Sort_Direction, "flyteidl.admin.Sort.Direction", [
  { no: 0, name: "DESCENDING" },
  { no: 1, name: "ASCENDING" },
]);

/**
 * Represents a request structure to list NamedEntityIdentifiers.
 *
 * @generated from message flyteidl.admin.NamedEntityIdentifierListRequest
 */
export class NamedEntityIdentifierListRequest extends Message<NamedEntityIdentifierListRequest> {
  /**
   * Name of the project that contains the identifiers.
   * +required
   *
   * @generated from field: string project = 1;
   */
  project = "";

  /**
   * Name of the domain the identifiers belongs to within the project.
   * +required
   *
   * @generated from field: string domain = 2;
   */
  domain = "";

  /**
   * Indicates the number of resources to be returned.
   * +required
   *
   * @generated from field: uint32 limit = 3;
   */
  limit = 0;

  /**
   * In the case of multiple pages of results, the server-provided token can be used to fetch the next page
   * in a query.
   * +optional
   *
   * @generated from field: string token = 4;
   */
  token = "";

  /**
   * Specifies how listed entities should be sorted in the response.
   * +optional
   *
   * @generated from field: flyteidl.admin.Sort sort_by = 5;
   */
  sortBy?: Sort;

  /**
   * Indicates a list of filters passed as string.
   * +optional
   *
   * @generated from field: string filters = 6;
   */
  filters = "";

  /**
   * Optional, org key applied to the resource.
   *
   * @generated from field: string org = 7;
   */
  org = "";

  constructor(data?: PartialMessage<NamedEntityIdentifierListRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.NamedEntityIdentifierListRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "project", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "domain", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "limit", kind: "scalar", T: 13 /* ScalarType.UINT32 */ },
    { no: 4, name: "token", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 5, name: "sort_by", kind: "message", T: Sort },
    { no: 6, name: "filters", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 7, name: "org", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NamedEntityIdentifierListRequest {
    return new NamedEntityIdentifierListRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NamedEntityIdentifierListRequest {
    return new NamedEntityIdentifierListRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NamedEntityIdentifierListRequest {
    return new NamedEntityIdentifierListRequest().fromJsonString(jsonString, options);
  }

  static equals(a: NamedEntityIdentifierListRequest | PlainMessage<NamedEntityIdentifierListRequest> | undefined, b: NamedEntityIdentifierListRequest | PlainMessage<NamedEntityIdentifierListRequest> | undefined): boolean {
    return proto3.util.equals(NamedEntityIdentifierListRequest, a, b);
  }
}

/**
 * Represents a request structure to list NamedEntity objects
 *
 * @generated from message flyteidl.admin.NamedEntityListRequest
 */
export class NamedEntityListRequest extends Message<NamedEntityListRequest> {
  /**
   * Resource type of the metadata to query. One of Task, Workflow or LaunchPlan.
   * +required
   *
   * @generated from field: flyteidl.core.ResourceType resource_type = 1;
   */
  resourceType = ResourceType.UNSPECIFIED;

  /**
   * Name of the project that contains the identifiers.
   * +required
   *
   * @generated from field: string project = 2;
   */
  project = "";

  /**
   * Name of the domain the identifiers belongs to within the project.
   *
   * @generated from field: string domain = 3;
   */
  domain = "";

  /**
   * Indicates the number of resources to be returned.
   *
   * @generated from field: uint32 limit = 4;
   */
  limit = 0;

  /**
   * In the case of multiple pages of results, the server-provided token can be used to fetch the next page
   * in a query.
   * +optional
   *
   * @generated from field: string token = 5;
   */
  token = "";

  /**
   * Specifies how listed entities should be sorted in the response.
   * +optional
   *
   * @generated from field: flyteidl.admin.Sort sort_by = 6;
   */
  sortBy?: Sort;

  /**
   * Indicates a list of filters passed as string.
   * +optional
   *
   * @generated from field: string filters = 7;
   */
  filters = "";

  /**
   * Optional, org key applied to the resource.
   *
   * @generated from field: string org = 8;
   */
  org = "";

  constructor(data?: PartialMessage<NamedEntityListRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.NamedEntityListRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "resource_type", kind: "enum", T: proto3.getEnumType(ResourceType) },
    { no: 2, name: "project", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "domain", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 4, name: "limit", kind: "scalar", T: 13 /* ScalarType.UINT32 */ },
    { no: 5, name: "token", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 6, name: "sort_by", kind: "message", T: Sort },
    { no: 7, name: "filters", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 8, name: "org", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NamedEntityListRequest {
    return new NamedEntityListRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NamedEntityListRequest {
    return new NamedEntityListRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NamedEntityListRequest {
    return new NamedEntityListRequest().fromJsonString(jsonString, options);
  }

  static equals(a: NamedEntityListRequest | PlainMessage<NamedEntityListRequest> | undefined, b: NamedEntityListRequest | PlainMessage<NamedEntityListRequest> | undefined): boolean {
    return proto3.util.equals(NamedEntityListRequest, a, b);
  }
}

/**
 * Represents a list of NamedEntityIdentifiers.
 *
 * @generated from message flyteidl.admin.NamedEntityIdentifierList
 */
export class NamedEntityIdentifierList extends Message<NamedEntityIdentifierList> {
  /**
   * A list of identifiers.
   *
   * @generated from field: repeated flyteidl.admin.NamedEntityIdentifier entities = 1;
   */
  entities: NamedEntityIdentifier[] = [];

  /**
   * In the case of multiple pages of results, the server-provided token can be used to fetch the next page
   * in a query. If there are no more results, this value will be empty.
   *
   * @generated from field: string token = 2;
   */
  token = "";

  constructor(data?: PartialMessage<NamedEntityIdentifierList>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.NamedEntityIdentifierList";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "entities", kind: "message", T: NamedEntityIdentifier, repeated: true },
    { no: 2, name: "token", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NamedEntityIdentifierList {
    return new NamedEntityIdentifierList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NamedEntityIdentifierList {
    return new NamedEntityIdentifierList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NamedEntityIdentifierList {
    return new NamedEntityIdentifierList().fromJsonString(jsonString, options);
  }

  static equals(a: NamedEntityIdentifierList | PlainMessage<NamedEntityIdentifierList> | undefined, b: NamedEntityIdentifierList | PlainMessage<NamedEntityIdentifierList> | undefined): boolean {
    return proto3.util.equals(NamedEntityIdentifierList, a, b);
  }
}

/**
 * Represents a list of NamedEntityIdentifiers.
 *
 * @generated from message flyteidl.admin.NamedEntityList
 */
export class NamedEntityList extends Message<NamedEntityList> {
  /**
   * A list of NamedEntity objects
   *
   * @generated from field: repeated flyteidl.admin.NamedEntity entities = 1;
   */
  entities: NamedEntity[] = [];

  /**
   * In the case of multiple pages of results, the server-provided token can be used to fetch the next page
   * in a query. If there are no more results, this value will be empty.
   *
   * @generated from field: string token = 2;
   */
  token = "";

  constructor(data?: PartialMessage<NamedEntityList>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.NamedEntityList";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "entities", kind: "message", T: NamedEntity, repeated: true },
    { no: 2, name: "token", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NamedEntityList {
    return new NamedEntityList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NamedEntityList {
    return new NamedEntityList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NamedEntityList {
    return new NamedEntityList().fromJsonString(jsonString, options);
  }

  static equals(a: NamedEntityList | PlainMessage<NamedEntityList> | undefined, b: NamedEntityList | PlainMessage<NamedEntityList> | undefined): boolean {
    return proto3.util.equals(NamedEntityList, a, b);
  }
}

/**
 * A request to retrieve the metadata associated with a NamedEntityIdentifier
 *
 * @generated from message flyteidl.admin.NamedEntityGetRequest
 */
export class NamedEntityGetRequest extends Message<NamedEntityGetRequest> {
  /**
   * Resource type of the metadata to get. One of Task, Workflow or LaunchPlan.
   * +required
   *
   * @generated from field: flyteidl.core.ResourceType resource_type = 1;
   */
  resourceType = ResourceType.UNSPECIFIED;

  /**
   * The identifier for the named entity for which to fetch metadata.
   * +required
   *
   * @generated from field: flyteidl.admin.NamedEntityIdentifier id = 2;
   */
  id?: NamedEntityIdentifier;

  constructor(data?: PartialMessage<NamedEntityGetRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.NamedEntityGetRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "resource_type", kind: "enum", T: proto3.getEnumType(ResourceType) },
    { no: 2, name: "id", kind: "message", T: NamedEntityIdentifier },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NamedEntityGetRequest {
    return new NamedEntityGetRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NamedEntityGetRequest {
    return new NamedEntityGetRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NamedEntityGetRequest {
    return new NamedEntityGetRequest().fromJsonString(jsonString, options);
  }

  static equals(a: NamedEntityGetRequest | PlainMessage<NamedEntityGetRequest> | undefined, b: NamedEntityGetRequest | PlainMessage<NamedEntityGetRequest> | undefined): boolean {
    return proto3.util.equals(NamedEntityGetRequest, a, b);
  }
}

/**
 * Request to set the referenced named entity state to the configured value.
 *
 * @generated from message flyteidl.admin.NamedEntityUpdateRequest
 */
export class NamedEntityUpdateRequest extends Message<NamedEntityUpdateRequest> {
  /**
   * Resource type of the metadata to update
   * +required
   *
   * @generated from field: flyteidl.core.ResourceType resource_type = 1;
   */
  resourceType = ResourceType.UNSPECIFIED;

  /**
   * Identifier of the metadata to update
   * +required
   *
   * @generated from field: flyteidl.admin.NamedEntityIdentifier id = 2;
   */
  id?: NamedEntityIdentifier;

  /**
   * Metadata object to set as the new value
   * +required
   *
   * @generated from field: flyteidl.admin.NamedEntityMetadata metadata = 3;
   */
  metadata?: NamedEntityMetadata;

  constructor(data?: PartialMessage<NamedEntityUpdateRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.NamedEntityUpdateRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "resource_type", kind: "enum", T: proto3.getEnumType(ResourceType) },
    { no: 2, name: "id", kind: "message", T: NamedEntityIdentifier },
    { no: 3, name: "metadata", kind: "message", T: NamedEntityMetadata },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NamedEntityUpdateRequest {
    return new NamedEntityUpdateRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NamedEntityUpdateRequest {
    return new NamedEntityUpdateRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NamedEntityUpdateRequest {
    return new NamedEntityUpdateRequest().fromJsonString(jsonString, options);
  }

  static equals(a: NamedEntityUpdateRequest | PlainMessage<NamedEntityUpdateRequest> | undefined, b: NamedEntityUpdateRequest | PlainMessage<NamedEntityUpdateRequest> | undefined): boolean {
    return proto3.util.equals(NamedEntityUpdateRequest, a, b);
  }
}

/**
 * Purposefully empty, may be populated in the future.
 *
 * @generated from message flyteidl.admin.NamedEntityUpdateResponse
 */
export class NamedEntityUpdateResponse extends Message<NamedEntityUpdateResponse> {
  constructor(data?: PartialMessage<NamedEntityUpdateResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.NamedEntityUpdateResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NamedEntityUpdateResponse {
    return new NamedEntityUpdateResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NamedEntityUpdateResponse {
    return new NamedEntityUpdateResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NamedEntityUpdateResponse {
    return new NamedEntityUpdateResponse().fromJsonString(jsonString, options);
  }

  static equals(a: NamedEntityUpdateResponse | PlainMessage<NamedEntityUpdateResponse> | undefined, b: NamedEntityUpdateResponse | PlainMessage<NamedEntityUpdateResponse> | undefined): boolean {
    return proto3.util.equals(NamedEntityUpdateResponse, a, b);
  }
}

/**
 * Shared request structure to fetch a single resource.
 * Resources include: Task, Workflow, LaunchPlan
 *
 * @generated from message flyteidl.admin.ObjectGetRequest
 */
export class ObjectGetRequest extends Message<ObjectGetRequest> {
  /**
   * Indicates a unique version of resource.
   * +required
   *
   * @generated from field: flyteidl.core.Identifier id = 1;
   */
  id?: Identifier;

  constructor(data?: PartialMessage<ObjectGetRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ObjectGetRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "message", T: Identifier },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ObjectGetRequest {
    return new ObjectGetRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ObjectGetRequest {
    return new ObjectGetRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ObjectGetRequest {
    return new ObjectGetRequest().fromJsonString(jsonString, options);
  }

  static equals(a: ObjectGetRequest | PlainMessage<ObjectGetRequest> | undefined, b: ObjectGetRequest | PlainMessage<ObjectGetRequest> | undefined): boolean {
    return proto3.util.equals(ObjectGetRequest, a, b);
  }
}

/**
 * Shared request structure to retrieve a list of resources.
 * Resources include: Task, Workflow, LaunchPlan
 *
 * @generated from message flyteidl.admin.ResourceListRequest
 */
export class ResourceListRequest extends Message<ResourceListRequest> {
  /**
   * id represents the unique identifier of the resource.
   * +required
   *
   * @generated from field: flyteidl.admin.NamedEntityIdentifier id = 1;
   */
  id?: NamedEntityIdentifier;

  /**
   * Indicates the number of resources to be returned.
   * +required
   *
   * @generated from field: uint32 limit = 2;
   */
  limit = 0;

  /**
   * In the case of multiple pages of results, this server-provided token can be used to fetch the next page
   * in a query.
   * +optional
   *
   * @generated from field: string token = 3;
   */
  token = "";

  /**
   * Indicates a list of filters passed as string.
   * More info on constructing filters : <Link>
   * +optional
   *
   * @generated from field: string filters = 4;
   */
  filters = "";

  /**
   * Sort ordering.
   * +optional
   *
   * @generated from field: flyteidl.admin.Sort sort_by = 5;
   */
  sortBy?: Sort;

  constructor(data?: PartialMessage<ResourceListRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ResourceListRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "message", T: NamedEntityIdentifier },
    { no: 2, name: "limit", kind: "scalar", T: 13 /* ScalarType.UINT32 */ },
    { no: 3, name: "token", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 4, name: "filters", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 5, name: "sort_by", kind: "message", T: Sort },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ResourceListRequest {
    return new ResourceListRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ResourceListRequest {
    return new ResourceListRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ResourceListRequest {
    return new ResourceListRequest().fromJsonString(jsonString, options);
  }

  static equals(a: ResourceListRequest | PlainMessage<ResourceListRequest> | undefined, b: ResourceListRequest | PlainMessage<ResourceListRequest> | undefined): boolean {
    return proto3.util.equals(ResourceListRequest, a, b);
  }
}

/**
 * Defines an email notification specification.
 *
 * @generated from message flyteidl.admin.EmailNotification
 */
export class EmailNotification extends Message<EmailNotification> {
  /**
   * The list of email addresses recipients for this notification.
   * +required
   *
   * @generated from field: repeated string recipients_email = 1;
   */
  recipientsEmail: string[] = [];

  constructor(data?: PartialMessage<EmailNotification>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.EmailNotification";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "recipients_email", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): EmailNotification {
    return new EmailNotification().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): EmailNotification {
    return new EmailNotification().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): EmailNotification {
    return new EmailNotification().fromJsonString(jsonString, options);
  }

  static equals(a: EmailNotification | PlainMessage<EmailNotification> | undefined, b: EmailNotification | PlainMessage<EmailNotification> | undefined): boolean {
    return proto3.util.equals(EmailNotification, a, b);
  }
}

/**
 * Defines a pager duty notification specification.
 *
 * @generated from message flyteidl.admin.PagerDutyNotification
 */
export class PagerDutyNotification extends Message<PagerDutyNotification> {
  /**
   * Currently, PagerDuty notifications leverage email to trigger a notification.
   * +required
   *
   * @generated from field: repeated string recipients_email = 1;
   */
  recipientsEmail: string[] = [];

  constructor(data?: PartialMessage<PagerDutyNotification>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.PagerDutyNotification";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "recipients_email", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PagerDutyNotification {
    return new PagerDutyNotification().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PagerDutyNotification {
    return new PagerDutyNotification().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PagerDutyNotification {
    return new PagerDutyNotification().fromJsonString(jsonString, options);
  }

  static equals(a: PagerDutyNotification | PlainMessage<PagerDutyNotification> | undefined, b: PagerDutyNotification | PlainMessage<PagerDutyNotification> | undefined): boolean {
    return proto3.util.equals(PagerDutyNotification, a, b);
  }
}

/**
 * Defines a slack notification specification.
 *
 * @generated from message flyteidl.admin.SlackNotification
 */
export class SlackNotification extends Message<SlackNotification> {
  /**
   * Currently, Slack notifications leverage email to trigger a notification.
   * +required
   *
   * @generated from field: repeated string recipients_email = 1;
   */
  recipientsEmail: string[] = [];

  constructor(data?: PartialMessage<SlackNotification>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.SlackNotification";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "recipients_email", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SlackNotification {
    return new SlackNotification().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SlackNotification {
    return new SlackNotification().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SlackNotification {
    return new SlackNotification().fromJsonString(jsonString, options);
  }

  static equals(a: SlackNotification | PlainMessage<SlackNotification> | undefined, b: SlackNotification | PlainMessage<SlackNotification> | undefined): boolean {
    return proto3.util.equals(SlackNotification, a, b);
  }
}

/**
 * Represents a structure for notifications based on execution status.
 * The notification content is configured within flyte admin but can be templatized.
 * Future iterations could expose configuring notifications with custom content.
 *
 * @generated from message flyteidl.admin.Notification
 */
export class Notification extends Message<Notification> {
  /**
   * A list of phases to which users can associate the notifications to.
   * +required
   *
   * @generated from field: repeated flyteidl.core.WorkflowExecution.Phase phases = 1;
   */
  phases: WorkflowExecution_Phase[] = [];

  /**
   * The type of notification to trigger.
   * +required
   *
   * @generated from oneof flyteidl.admin.Notification.type
   */
  type: {
    /**
     * @generated from field: flyteidl.admin.EmailNotification email = 2;
     */
    value: EmailNotification;
    case: "email";
  } | {
    /**
     * @generated from field: flyteidl.admin.PagerDutyNotification pager_duty = 3;
     */
    value: PagerDutyNotification;
    case: "pagerDuty";
  } | {
    /**
     * @generated from field: flyteidl.admin.SlackNotification slack = 4;
     */
    value: SlackNotification;
    case: "slack";
  } | { case: undefined; value?: undefined } = { case: undefined };

  constructor(data?: PartialMessage<Notification>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.Notification";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "phases", kind: "enum", T: proto3.getEnumType(WorkflowExecution_Phase), repeated: true },
    { no: 2, name: "email", kind: "message", T: EmailNotification, oneof: "type" },
    { no: 3, name: "pager_duty", kind: "message", T: PagerDutyNotification, oneof: "type" },
    { no: 4, name: "slack", kind: "message", T: SlackNotification, oneof: "type" },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Notification {
    return new Notification().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Notification {
    return new Notification().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Notification {
    return new Notification().fromJsonString(jsonString, options);
  }

  static equals(a: Notification | PlainMessage<Notification> | undefined, b: Notification | PlainMessage<Notification> | undefined): boolean {
    return proto3.util.equals(Notification, a, b);
  }
}

/**
 * Represents a string url and associated metadata used throughout the platform.
 *
 * @generated from message flyteidl.admin.UrlBlob
 * @deprecated
 */
export class UrlBlob extends Message<UrlBlob> {
  /**
   * Actual url value.
   *
   * @generated from field: string url = 1;
   */
  url = "";

  /**
   * Represents the size of the file accessible at the above url.
   *
   * @generated from field: int64 bytes = 2;
   */
  bytes = protoInt64.zero;

  constructor(data?: PartialMessage<UrlBlob>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.UrlBlob";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "url", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "bytes", kind: "scalar", T: 3 /* ScalarType.INT64 */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): UrlBlob {
    return new UrlBlob().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): UrlBlob {
    return new UrlBlob().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): UrlBlob {
    return new UrlBlob().fromJsonString(jsonString, options);
  }

  static equals(a: UrlBlob | PlainMessage<UrlBlob> | undefined, b: UrlBlob | PlainMessage<UrlBlob> | undefined): boolean {
    return proto3.util.equals(UrlBlob, a, b);
  }
}

/**
 * Label values to be applied to an execution resource.
 * In the future a mode (e.g. OVERRIDE, APPEND, etc) can be defined
 * to specify how to merge labels defined at registration and execution time.
 *
 * @generated from message flyteidl.admin.Labels
 */
export class Labels extends Message<Labels> {
  /**
   * Map of custom labels to be applied to the execution resource.
   *
   * @generated from field: map<string, string> values = 1;
   */
  values: { [key: string]: string } = {};

  constructor(data?: PartialMessage<Labels>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.Labels";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "values", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Labels {
    return new Labels().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Labels {
    return new Labels().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Labels {
    return new Labels().fromJsonString(jsonString, options);
  }

  static equals(a: Labels | PlainMessage<Labels> | undefined, b: Labels | PlainMessage<Labels> | undefined): boolean {
    return proto3.util.equals(Labels, a, b);
  }
}

/**
 * Annotation values to be applied to an execution resource.
 * In the future a mode (e.g. OVERRIDE, APPEND, etc) can be defined
 * to specify how to merge annotations defined at registration and execution time.
 *
 * @generated from message flyteidl.admin.Annotations
 */
export class Annotations extends Message<Annotations> {
  /**
   * Map of custom annotations to be applied to the execution resource.
   *
   * @generated from field: map<string, string> values = 1;
   */
  values: { [key: string]: string } = {};

  constructor(data?: PartialMessage<Annotations>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.Annotations";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "values", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Annotations {
    return new Annotations().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Annotations {
    return new Annotations().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Annotations {
    return new Annotations().fromJsonString(jsonString, options);
  }

  static equals(a: Annotations | PlainMessage<Annotations> | undefined, b: Annotations | PlainMessage<Annotations> | undefined): boolean {
    return proto3.util.equals(Annotations, a, b);
  }
}

/**
 * Environment variable values to be applied to an execution resource.
 * In the future a mode (e.g. OVERRIDE, APPEND, etc) can be defined
 * to specify how to merge environment variables defined at registration and execution time.
 *
 * @generated from message flyteidl.admin.Envs
 */
export class Envs extends Message<Envs> {
  /**
   * Map of custom environment variables to be applied to the execution resource.
   *
   * @generated from field: repeated flyteidl.core.KeyValuePair values = 1;
   */
  values: KeyValuePair[] = [];

  constructor(data?: PartialMessage<Envs>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.Envs";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "values", kind: "message", T: KeyValuePair, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Envs {
    return new Envs().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Envs {
    return new Envs().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Envs {
    return new Envs().fromJsonString(jsonString, options);
  }

  static equals(a: Envs | PlainMessage<Envs> | undefined, b: Envs | PlainMessage<Envs> | undefined): boolean {
    return proto3.util.equals(Envs, a, b);
  }
}

/**
 * Defines permissions associated with executions created by this launch plan spec.
 * Use either of these roles when they have permissions required by your workflow execution.
 * Deprecated.
 *
 * @generated from message flyteidl.admin.AuthRole
 * @deprecated
 */
export class AuthRole extends Message<AuthRole> {
  /**
   * Defines an optional iam role which will be used for tasks run in executions created with this launch plan.
   *
   * @generated from field: string assumable_iam_role = 1;
   */
  assumableIamRole = "";

  /**
   * Defines an optional kubernetes service account which will be used for tasks run in executions created with this launch plan.
   *
   * @generated from field: string kubernetes_service_account = 2;
   */
  kubernetesServiceAccount = "";

  constructor(data?: PartialMessage<AuthRole>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.AuthRole";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "assumable_iam_role", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "kubernetes_service_account", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): AuthRole {
    return new AuthRole().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): AuthRole {
    return new AuthRole().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): AuthRole {
    return new AuthRole().fromJsonString(jsonString, options);
  }

  static equals(a: AuthRole | PlainMessage<AuthRole> | undefined, b: AuthRole | PlainMessage<AuthRole> | undefined): boolean {
    return proto3.util.equals(AuthRole, a, b);
  }
}

/**
 * Encapsulates user settings pertaining to offloaded data (i.e. Blobs, Schema, query data, etc.).
 * See https://github.com/flyteorg/flyte/issues/211 for more background information.
 *
 * @generated from message flyteidl.admin.RawOutputDataConfig
 */
export class RawOutputDataConfig extends Message<RawOutputDataConfig> {
  /**
   * Prefix for where offloaded data from user workflows will be written
   * e.g. s3://bucket/key or s3://bucket/
   *
   * @generated from field: string output_location_prefix = 1;
   */
  outputLocationPrefix = "";

  constructor(data?: PartialMessage<RawOutputDataConfig>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.RawOutputDataConfig";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "output_location_prefix", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): RawOutputDataConfig {
    return new RawOutputDataConfig().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): RawOutputDataConfig {
    return new RawOutputDataConfig().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): RawOutputDataConfig {
    return new RawOutputDataConfig().fromJsonString(jsonString, options);
  }

  static equals(a: RawOutputDataConfig | PlainMessage<RawOutputDataConfig> | undefined, b: RawOutputDataConfig | PlainMessage<RawOutputDataConfig> | undefined): boolean {
    return proto3.util.equals(RawOutputDataConfig, a, b);
  }
}

/**
 * These URLs are returned as part of node and task execution data requests.
 *
 * @generated from message flyteidl.admin.FlyteURLs
 */
export class FlyteURLs extends Message<FlyteURLs> {
  /**
   * @generated from field: string inputs = 1;
   */
  inputs = "";

  /**
   * @generated from field: string outputs = 2;
   */
  outputs = "";

  /**
   * @generated from field: string deck = 3;
   */
  deck = "";

  constructor(data?: PartialMessage<FlyteURLs>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.FlyteURLs";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "inputs", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "outputs", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "deck", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): FlyteURLs {
    return new FlyteURLs().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): FlyteURLs {
    return new FlyteURLs().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): FlyteURLs {
    return new FlyteURLs().fromJsonString(jsonString, options);
  }

  static equals(a: FlyteURLs | PlainMessage<FlyteURLs> | undefined, b: FlyteURLs | PlainMessage<FlyteURLs> | undefined): boolean {
    return proto3.util.equals(FlyteURLs, a, b);
  }
}

