package deviceflow

import "golang.org/x/oauth2"

// DeviceAuthorizationRequest sent to authorization server directly from the client app
type DeviceAuthorizationRequest struct {
	// ClientID is the client identifier issued to the client during the registration process of OAuth app with the authorization server
	ClientID string `json:"client_id"`
	// Scope is the scope parameter of the access request
	Scope string `json:"scope"`
	// Audience defines at which endpoints the token can be used.
	Audience string `json:"audience"`
}

// DeviceAuthorizationResponse contains the information that the end user would use to authorize the app requesting the
// resource access.
type DeviceAuthorizationResponse struct {
	// DeviceCode unique device code generated by the authorization server.
	DeviceCode string `json:"device_code"`
	// UserCode unique code generated for the user to enter on another device
	UserCode string `json:"user_code"`
	// VerificationURI url endpoint of the authorization server which host the device and app verification
	VerificationURI string `json:"verification_uri"`
	// VerificationURIComplete url endpoint of the authorization server which host the device and app verification along with user code
	VerificationURIComplete string `json:"verification_uri_complete"`
	// ExpiresIn  lifetime in seconds of the "device_code" and "user_code"
	ExpiresIn int64 `json:"expires_in"`
	// Interval minimum amount of time in secs the client app should wait between polling requests to the token endpoint.
	Interval int64 `json:"interval"`
}

type DeviceAccessTokenRequest struct {
	// ClientID is the client identifier issued to the client during the registration process of OAuth app with the authorization server
	ClientID string `json:"client_id"`
	// DeviceCode unique device code generated by the authorization server.
	DeviceCode string `json:"device_code"`
	//  Value MUST be set to "urn:ietf:params:oauth:grant-type:device_code"
	GrantType string `json:"grant_type"`
}

type DeviceAccessTokenResponse struct {
	oauth2.Token
	Error     string `json:"error"`
	ExpiresIn int64  `json:"expires_in"` // relative seconds from now
}
