package adminservice

import (
	"context"

	"github.com/flyteorg/flyte/flyteadmin/pkg/rpc/adminservice/util"
	"github.com/flyteorg/flyte/flyteidl/gen/pb-go/flyteidl/admin"
	"github.com/flyteorg/flyte/flyteidl/gen/pb-go/flyteidl/core"
	"github.com/flyteorg/flyte/flytestdlib/logger"
)

func (m *AdminService) CreateWorkflow(
	ctx context.Context,
	request *admin.WorkflowCreateRequest) (*admin.WorkflowCreateResponse, error) {
	var response *admin.WorkflowCreateResponse
	var err error
	m.Metrics.workflowEndpointMetrics.create.Time(func() {
		response, err = m.WorkflowManager.CreateWorkflow(ctx, request)
	})
	if err != nil {
		return nil, util.TransformAndRecordError(err, &m.Metrics.workflowEndpointMetrics.create)
	}
	m.Metrics.workflowEndpointMetrics.create.Success()
	return response, nil
}

func (m *AdminService) GetWorkflow(ctx context.Context, request *admin.ObjectGetRequest) (*admin.Workflow, error) {
	// NOTE: When the Get HTTP endpoint is called the resource type is implicit (from the URL) so we must add it
	// to the request.
	if request.GetId() != nil && request.GetId().GetResourceType() == core.ResourceType_UNSPECIFIED {
		logger.Infof(ctx, "Adding resource type for unspecified value in request: [%+v]", request)
		request.Id.ResourceType = core.ResourceType_WORKFLOW
	}
	var response *admin.Workflow
	var err error
	m.Metrics.workflowEndpointMetrics.get.Time(func() {
		response, err = m.WorkflowManager.GetWorkflow(ctx, request)
	})
	if err != nil {
		return nil, util.TransformAndRecordError(err, &m.Metrics.workflowEndpointMetrics.get)
	}
	m.Metrics.workflowEndpointMetrics.get.Success()
	return response, nil
}

func (m *AdminService) ListWorkflowIds(ctx context.Context, request *admin.NamedEntityIdentifierListRequest) (
	*admin.NamedEntityIdentifierList, error) {
	var response *admin.NamedEntityIdentifierList
	var err error
	m.Metrics.workflowEndpointMetrics.listIds.Time(func() {
		response, err = m.WorkflowManager.ListWorkflowIdentifiers(ctx, request)
	})
	if err != nil {
		return nil, util.TransformAndRecordError(err, &m.Metrics.workflowEndpointMetrics.listIds)
	}

	m.Metrics.workflowEndpointMetrics.listIds.Success()
	return response, nil
}

func (m *AdminService) ListWorkflows(ctx context.Context, request *admin.ResourceListRequest) (*admin.WorkflowList, error) {
	var response *admin.WorkflowList
	var err error
	m.Metrics.workflowEndpointMetrics.list.Time(func() {
		response, err = m.WorkflowManager.ListWorkflows(ctx, request)
	})
	if err != nil {
		return nil, util.TransformAndRecordError(err, &m.Metrics.workflowEndpointMetrics.list)
	}
	m.Metrics.workflowEndpointMetrics.list.Success()
	return response, nil
}
