# Run optional test
%if ! (0%{?rhel})
%bcond_without perl_Exporter_enables_optional_test
%else
%bcond_with perl_Exporter_enables_optional_test
%endif

%global base_version 5.70
Name:           perl-Exporter
Version:        5.72
Release:        1001%{?dist}
Summary:        Implements default import method for modules
License:        GPL+ or Artistic
Group:          Development/Libraries
URL:            http://search.cpan.org/dist/Exporter/
Source0:        http://www.cpan.org/authors/id/T/TO/TODDR/Exporter-%{base_version}.tar.gz
# Unbundled from perl 5.21.11
Patch0:         Exporter-5.70-Upgrade-to-5.72.patch
BuildArch:      noarch
BuildRequires:  perl-interpreter
BuildRequires:  perl-generators
BuildRequires:  perl(ExtUtils::MakeMaker)
# Run-time:
BuildRequires:  perl(Carp) >= 1.05
BuildRequires:  perl(strict)
BuildRequires:  perl(warnings)
# Tests:
BuildRequires:  perl(Test::More)
BuildRequires:  perl(vars)
%if %{with perl_Exporter_enables_optional_test} && !%{defined perl_bootstrap}
# Optional tests:
BuildRequires:  perl(Test::Pod) >= 1.18
%endif
Requires:       perl(:MODULE_COMPAT_%(eval "`perl -V:version`"; echo $version))
Requires:       perl(Carp) >= 1.05
Requires:       perl(warnings)

%description
The Exporter module implements an import method which allows a module to
export functions and variables to its users' name spaces. Many modules use
Exporter rather than implementing their own import method because Exporter
provides a highly flexible interface, with an implementation optimized for
the common case.

%prep
%setup -q -n Exporter-%{base_version}
%patch0 -p1

%build
perl Makefile.PL INSTALLDIRS=vendor
make %{?_smp_mflags}

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
%{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc Changes README
%{perl_vendorlib}/*
%{_mandir}/man3/*

%changelog
* Fri Mar 29 2019 Jitka Plesnikova <jplesnik@redhat.com> - 5.72-1001
- Rebuild with enable hardening (bug #1636329)

* Thu Aug 23 2018 Petr Pisar <ppisar@redhat.com> - 5.72-1000
- Increase release not to clash with perl-bootstrap:5.24 subpackages
  (bug #1620192)

* Fri Apr 27 2018 Petr Pisar <ppisar@redhat.com> - 5.72-398
- Increase release not to clash with perl-bootstrap:5.24 subpackages

* Wed Mar 28 2018 Petr Pisar <ppisar@redhat.com> - 5.72-397
- Increase release not to clash with perl-bootstrap:5.24 subpackages

* Thu Feb 08 2018 Fedora Release Engineering <releng@fedoraproject.org> - 5.72-396
- Rebuilt for https://fedoraproject.org/wiki/Fedora_28_Mass_Rebuild

* Thu Jul 27 2017 Fedora Release Engineering <releng@fedoraproject.org> - 5.72-395
- Rebuilt for https://fedoraproject.org/wiki/Fedora_27_Mass_Rebuild

* Wed Jun 07 2017 Jitka Plesnikova <jplesnik@redhat.com> - 5.72-394
- Perl 5.26 re-rebuild of bootstrapped packages

* Sat Jun 03 2017 Jitka Plesnikova <jplesnik@redhat.com> - 5.72-393
- Perl 5.26 rebuild

* Sat Feb 11 2017 Fedora Release Engineering <releng@fedoraproject.org> - 5.72-367
- Rebuilt for https://fedoraproject.org/wiki/Fedora_26_Mass_Rebuild

* Wed May 18 2016 Jitka Plesnikova <jplesnik@redhat.com> - 5.72-366
- Perl 5.24 re-rebuild of bootstrapped packages

* Sat May 14 2016 Jitka Plesnikova <jplesnik@redhat.com> - 5.72-365
- Increase release to favour standalone package

* Thu Feb 04 2016 Fedora Release Engineering <releng@fedoraproject.org> - 5.72-349
- Rebuilt for https://fedoraproject.org/wiki/Fedora_24_Mass_Rebuild

* Tue Oct 20 2015 Petr Pisar <ppisar@redhat.com> - 5.72-348
- Rebuild to utilize perl(:VERSION) dependency symbol

* Thu Jun 18 2015 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 5.72-347
- Rebuilt for https://fedoraproject.org/wiki/Fedora_23_Mass_Rebuild

* Wed Jun 10 2015 Jitka Plesnikova <jplesnik@redhat.com> - 5.72-346
- Perl 5.22 re-rebuild of bootstrapped packages

* Thu Jun 04 2015 Jitka Plesnikova <jplesnik@redhat.com> - 5.72-345
- Increase release to favour standalone package

* Wed Jun 03 2015 Jitka Plesnikova <jplesnik@redhat.com> - 5.72-2
- Perl 5.22 rebuild

* Wed May 06 2015 Petr Pisar <ppisar@redhat.com> - 5.72-1
- 5.72 bump in order to dual-live with perl 5.22

* Sun Sep 07 2014 Jitka Plesnikova <jplesnik@redhat.com> - 5.70-311
- Perl 5.20 re-rebuild of bootstrapped packages

* Wed Sep 03 2014 Jitka Plesnikova <jplesnik@redhat.com> - 5.70-310
- Increase release to favour standalone package

* Tue Aug 26 2014 Jitka Plesnikova <jplesnik@redhat.com> - 5.70-3
- Perl 5.20 rebuild

* Sat Jun 07 2014 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 5.70-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_21_Mass_Rebuild

* Mon Apr 14 2014 Petr Pisar <ppisar@redhat.com> - 5.70-1
- 5.70 bump

* Wed Aug 14 2013 Jitka Plesnikova <jplesnik@redhat.com> - 5.68-293
- Perl 5.18 re-rebuild of bootstrapped packages

* Sat Aug 03 2013 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 5.68-292
- Rebuilt for https://fedoraproject.org/wiki/Fedora_20_Mass_Rebuild

* Fri Jul 26 2013 Petr Pisar <ppisar@redhat.com> - 5.68-291
- Specify all dependencies

* Mon Jul 15 2013 Petr Pisar <ppisar@redhat.com> - 5.68-290
- Increase release to favour standalone package

* Fri Jul 12 2013 Petr Pisar <ppisar@redhat.com> - 5.68-2
- Link minimal build-root packages against libperl.so explicitly

* Thu Mar 28 2013 Petr Pisar <ppisar@redhat.com> - 5.68-1
- 5.68 bump

* Fri Mar 22 2013 Petr Pisar <ppisar@redhat.com> 5.67-1
- Specfile autogenerated by cpanspec 1.78.
