
Summary: User space tools for kernel auditing
Name: audit
Version: 3.0.5
Release: 5%{?dist}
License: GPLv2+
URL: http://people.redhat.com/sgrubb/audit/
Source0: http://people.redhat.com/sgrubb/audit/%{name}-%{version}.tar.gz
Source1: https://www.gnu.org/licenses/lgpl-2.1.txt

Patch1: 0001-Add-ausysrulevalidate.patch
Patch2: 0002-audit-3.0.6-time.patch
Patch3: 0003-Carry-functions-file-from-initscripts-in-audit.patch
Patch4: 0004-When-interpreting-if-val-is-NULL-return-an-empty-str.patch
Patch5: 0005-auparse-refact-nvlist-cleanup-cod.patch

BuildRequires: make gcc swig
BuildRequires: openldap-devel
BuildRequires: krb5-devel libcap-ng-devel
BuildRequires: kernel-headers >= 2.6.29
BuildRequires: systemd

Requires: %{name}-libs%{?_isa} = %{version}-%{release}
Requires(post): systemd coreutils
Requires(preun): systemd initscripts-service
Requires(postun): systemd coreutils initscripts-service

# Placing this here under the assumption that anything using the
# python libraries expects the system to have an audit daemon
Obsoletes: python2-audit < %{version}-%{release}

%description
The audit package contains the user space utilities for
storing and searching the audit records generated by
the audit subsystem in the Linux 2.6 and later kernels.

%package libs
Summary: Dynamic library for libaudit
License: LGPLv2+

%description libs
The audit-libs package contains the dynamic libraries needed for
applications to use the audit framework.

%package libs-devel
Summary: Header files for libaudit
License: LGPLv2+
Requires: %{name}-libs%{?_isa} = %{version}-%{release}
Requires: kernel-headers >= 2.6.29

%description libs-devel
The audit-libs-devel package contains the header files needed for
developing applications that need to use the audit framework libraries.

%package -n python3-audit
Summary: Python3 bindings for libaudit
License: LGPLv2+
BuildRequires: python3-devel
BuildRequires: make
Requires: %{name}-libs%{?_isa} = %{version}-%{release}
Provides: audit-libs-python3 = %{version}-%{release}
Provides: audit-libs-python3%{?_isa} = %{version}-%{release}
Obsoletes: audit-libs-python3 < %{version}-%{release}

%description -n python3-audit
The python3-audit package contains the bindings so that libaudit
and libauparse can be used by python3.

%package -n audispd-plugins
Summary: Plugins for the audit event dispatcher
License: GPLv2+
Requires: %{name}%{?_isa} = %{version}-%{release}
Requires: %{name}-libs%{?_isa} = %{version}-%{release}

%description -n audispd-plugins
The audispd-plugins package provides plugins for the real-time
interface to the audit system, audispd. These plugins can do things
like relay events to remote machines.

%package -n audispd-plugins-zos
Summary: z/OS plugin for the audit event dispatcher
License: GPLv2+
Requires: %{name}%{?_isa} = %{version}-%{release}
Requires: %{name}-libs%{?_isa} = %{version}-%{release}
Requires: openldap

%description -n audispd-plugins-zos
The audispd-plugins-zos package provides a plugin that will forward all
incoming audit events, as they happen, to a configured z/OS SMF (Service
Management Facility) database, through an IBM Tivoli Directory Server
(ITDS) set for Remote Audit service.

%prep
%setup -q
cp %{SOURCE1} .
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

# Remove the ids code, its not ready
sed -i 's/ ids / /' audisp/plugins/Makefile.in

%build
%configure --with-python=no \
	   --with-python3=yes \
	   --enable-gssapi-krb5=yes --with-arm --with-aarch64 \
	   --with-libcap-ng=yes --enable-zos-remote \
	   --enable-systemd --enable-experimental

make CFLAGS="%{optflags}" %{?_smp_mflags}

%install
mkdir -p $RPM_BUILD_ROOT/{sbin,etc/audit/plugins.d,etc/audit/rules.d}
mkdir -p $RPM_BUILD_ROOT/%{_mandir}/{man5,man8}
mkdir -p $RPM_BUILD_ROOT/%{_lib}
mkdir -p $RPM_BUILD_ROOT/%{_libdir}/audit
mkdir -p --mode=0700 $RPM_BUILD_ROOT/%{_var}/log/audit
mkdir -p $RPM_BUILD_ROOT/%{_var}/spool/audit
mkdir -p $RPM_BUILD_ROOT/%{_datadir}
make DESTDIR=$RPM_BUILD_ROOT install

# Copy functions file.
install -m750 %{_builddir}/%{name}-%{version}/init.d/functions \
    $RPM_BUILD_ROOT/%{_datadir}/%{name}/functions

# Validate sample rules shipped.
for r in $RPM_BUILD_ROOT/%{_datadir}/%{name}/sample-rules/*.rules; do
    PYTHONPATH=$RPM_BUILD_ROOT/%{python3_sitearch} \
        %{_builddir}/%{name}-%{version}/contrib/ausysrulevalidate \
        --update --rules-file "${r}"
done

# Remove these items so they don't get picked up.
rm -f $RPM_BUILD_ROOT/%{_libdir}/libaudit.a
rm -f $RPM_BUILD_ROOT/%{_libdir}/libauparse.a

find $RPM_BUILD_ROOT -name '*.la' -delete
find $RPM_BUILD_ROOT/%{_libdir}/python%{python3_version}/site-packages -name '*.a' -delete

# On platforms with 32 & 64 bit libs, we need to coordinate the timestamp
touch -r ./audit.spec $RPM_BUILD_ROOT/etc/libaudit.conf
touch -r ./audit.spec $RPM_BUILD_ROOT/usr/share/man/man5/libaudit.conf.5.gz

%check
make check
# Get rid of make files so that they don't get packaged.
rm -f rules/Makefile*

%post
# Copy default rules into place on new installation
files=`ls /etc/audit/rules.d/ 2>/dev/null | wc -w`
if [ "$files" -eq 0 ] ; then
	if [ -e %{_datadir}/%{name}/sample-rules/10-base-config.rules ] ; then
		cp %{_datadir}/%{name}/sample-rules/10-base-config.rules /etc/audit/rules.d/audit.rules
	else
		touch /etc/audit/rules.d/audit.rules
	fi
	chmod 0600 /etc/audit/rules.d/audit.rules
fi
%systemd_post auditd.service

%preun
%systemd_preun auditd.service
if [ $1 -eq 0 ]; then
    /sbin/service auditd stop > /dev/null 2>&1
fi

%postun
if [ $1 -ge 1 ]; then
    /sbin/service auditd condrestart > /dev/null 2>&1 || :
fi

%files libs
%{!?_licensedir:%global license %%doc}
%license lgpl-2.1.txt
%{_libdir}/libaudit.so.1*
%{_libdir}/libauparse.*
%config(noreplace) %attr(640,root,root) /etc/libaudit.conf
%{_mandir}/man5/libaudit.conf.5.gz

%files libs-devel
%doc contrib/plugin
%{_libdir}/libaudit.so
%{_libdir}/libauparse.so
%{_includedir}/libaudit.h
%{_includedir}/auparse.h
%{_includedir}/auparse-defs.h
%{_datadir}/aclocal/audit.m4
%{_libdir}/pkgconfig/audit.pc
%{_libdir}/pkgconfig/auparse.pc
%{_mandir}/man3/*

%files -n python3-audit
%attr(755,root,root) %{python3_sitearch}/*

%files
%doc README ChangeLog init.d/auditd.cron
%{!?_licensedir:%global license %%doc}
%license COPYING
%attr(644,root,root) %{_datadir}/%{name}/sample-rules/*
%attr(644,root,root) %{_mandir}/man8/auditctl.8.gz
%attr(644,root,root) %{_mandir}/man8/auditd.8.gz
%attr(644,root,root) %{_mandir}/man8/aureport.8.gz
%attr(644,root,root) %{_mandir}/man8/ausearch.8.gz
%attr(644,root,root) %{_mandir}/man8/autrace.8.gz
%attr(644,root,root) %{_mandir}/man8/aulast.8.gz
%attr(644,root,root) %{_mandir}/man8/aulastlog.8.gz
%attr(644,root,root) %{_mandir}/man8/auvirt.8.gz
%attr(644,root,root) %{_mandir}/man8/augenrules.8.gz
%attr(644,root,root) %{_mandir}/man8/ausyscall.8.gz
%attr(644,root,root) %{_mandir}/man7/audit.rules.7.gz
%attr(644,root,root) %{_mandir}/man5/auditd.conf.5.gz
%attr(644,root,root) %{_mandir}/man5/ausearch-expression.5.gz
%attr(644,root,root) %{_mandir}/man5/auditd-plugins.5.gz
%attr(755,root,root) %{_sbindir}/auditctl
%attr(755,root,root) %{_sbindir}/auditd
%attr(755,root,root) %{_sbindir}/ausearch
%attr(755,root,root) %{_sbindir}/aureport
%attr(750,root,root) %{_sbindir}/autrace
%attr(755,root,root) %{_sbindir}/augenrules
%attr(755,root,root) %{_bindir}/aulast
%attr(755,root,root) %{_bindir}/aulastlog
%attr(755,root,root) %{_bindir}/ausyscall
%attr(755,root,root) %{_bindir}/auvirt
%attr(644,root,root) %{_unitdir}/auditd.service
%attr(750,root,root) %dir %{_libexecdir}/initscripts/legacy-actions/auditd
%attr(750,root,root) %{_libexecdir}/initscripts/legacy-actions/auditd/condrestart
%attr(750,root,root) %{_libexecdir}/initscripts/legacy-actions/auditd/reload
%attr(750,root,root) %{_libexecdir}/initscripts/legacy-actions/auditd/restart
%attr(750,root,root) %{_libexecdir}/initscripts/legacy-actions/auditd/resume
%attr(750,root,root) %{_libexecdir}/initscripts/legacy-actions/auditd/rotate
%attr(750,root,root) %{_libexecdir}/initscripts/legacy-actions/auditd/state
%attr(750,root,root) %{_libexecdir}/initscripts/legacy-actions/auditd/stop
%attr(750,root,root) %{_datadir}/%{name}/functions
%ghost %{_localstatedir}/run/auditd.state
%attr(-,root,-) %dir %{_var}/log/audit
%attr(750,root,root) %dir /etc/audit
%attr(750,root,root) %dir /etc/audit/rules.d
%attr(750,root,root) %dir /etc/audit/plugins.d
%config(noreplace) %attr(640,root,root) /etc/audit/auditd.conf
%ghost %config(noreplace) %attr(600,root,root) /etc/audit/rules.d/audit.rules
%ghost %config(noreplace) %attr(640,root,root) /etc/audit/audit.rules
%config(noreplace) %attr(640,root,root) /etc/audit/audit-stop.rules
%config(noreplace) %attr(640,root,root) /etc/audit/plugins.d/af_unix.conf

%files -n audispd-plugins
%config(noreplace) %attr(640,root,root) /etc/audit/audisp-remote.conf
%config(noreplace) %attr(640,root,root) /etc/audit/plugins.d/au-remote.conf
%config(noreplace) %attr(640,root,root) /etc/audit/plugins.d/syslog.conf
%config(noreplace) %attr(640,root,root) /etc/audit/audisp-statsd.conf
%config(noreplace) %attr(640,root,root) /etc/audit/plugins.d/au-statsd.conf
%attr(750,root,root) %{_sbindir}/audisp-remote
%attr(750,root,root) %{_sbindir}/audisp-syslog
%attr(750,root,root) %{_sbindir}/audisp-statsd
%attr(700,root,root) %dir %{_var}/spool/audit
%attr(644,root,root) %{_mandir}/man5/audisp-remote.conf.5.gz
%attr(644,root,root) %{_mandir}/man8/audisp-remote.8.gz
%attr(644,root,root) %{_mandir}/man8/audisp-syslog.8.gz
%attr(644,root,root) %{_mandir}/man8/audisp-statsd.8.gz

%files -n audispd-plugins-zos
%attr(644,root,root) %{_mandir}/man8/audispd-zos-remote.8.gz
%attr(644,root,root) %{_mandir}/man5/zos-remote.conf.5.gz
%config(noreplace) %attr(640,root,root) /etc/audit/plugins.d/audispd-zos-remote.conf
%config(noreplace) %attr(640,root,root) /etc/audit/zos-remote.conf
%attr(750,root,root) %{_sbindir}/audispd-zos-remote

%changelog
* Wed Nov 03 2021 Sergio Correia <scorreia@redhat.com> - 3.0.5-5
- auparse: refact nvlist cleanup code
  Resolves: rhbz#2008965

* Wed Nov 03 2021 Sergio Correia <scorreia@redhat.com> - 3.0.5-4
- When interpreting, if val is NULL return an empty string
  Resolves: rhbz#2004420

* Wed Nov 03 2021 Sergio Correia <scorreia@redhat.com> - 3.0.5-3
- Update dependency to initscripts-service instead of initscripts
  Resolves: rhbz#2000933

* Tue Aug 17 2021 Sergio Correia <scorreia@redhat.com> - 3.0.5-2
- Fix timestamp parsing
  Related: rhbz#1938680

* Mon Aug 16 2021 Sergio Correia <scorreia@redhat.com> - 3.0.5-1
- New upstream release, 3.0.5
  Related: rhbz#1938680

* Mon Aug 16 2021 Sergio Correia <scorreia@redhat.com> - 3.0.2-3
- Validates the sample rules we ship
  Resolves: rhbz#1985630

* Mon Aug 09 2021 Mohan Boddu <mboddu@redhat.com> - 3.0.2-2
- Rebuilt for IMA sigs, glibc 2.34, aarch64 flags
  Related: rhbz#1991688

* Tue Jun 22 2021 Sergio Correia <scorreia@redhat.com> - 3.0.2-1
- New upstream release, 3.0.2.
  Fix issues detected by static analyzers
  Resolves: rhbz#1938680

* Mon Jun 21 2021 Sergio Correia <scorreia@redhat.com> - 3.0.1-4
- Enable default RHEL configuration
  This enables syscall auditing by default.
  Resolves: rhbz#1924561

* Thu Apr 15 2021 Mohan Boddu <mboddu@redhat.com> - 3.0.1-3
- Rebuilt for RHEL 9 BETA on Apr 15th 2021. Related: rhbz#1947937

* Thu Feb 18 2021 Steve Grubb <sgrubb@redhat.com> 3.0.1-2
- Add patch fixing segafult in the audisp-statsd plugin

* Fri Feb 12 2021 Steve Grubb <sgrubb@redhat.com> 3.0.1-1
- New upstream feature and bugfix release
- Enable building the audisp-statsd plugin

* Tue Jan 26 2021 Fedora Release Engineering <releng@fedoraproject.org> - 3.0-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_34_Mass_Rebuild

* Wed Dec 16 2020 Steve Grubb <sgrubb@redhat.com> 3.0-1
- New upstream feature and bugfix release

* Mon Jul 27 2020 Fedora Release Engineering <releng@fedoraproject.org> - 3.0-0.21.20191104git1c2f876
- Rebuilt for https://fedoraproject.org/wiki/Fedora_33_Mass_Rebuild

* Tue May 26 2020 Miro Hrončok <mhroncok@redhat.com> - 3.0-0.20.20191104git1c2f876
- Rebuilt for Python 3.9

* Thu Mar 12 2020 Steve Grubb <sgrubb@redhat.com> 3.0-0.19.20191104git1c2f876
- Add Obsolete python2-audit (#1783061)

* Wed Jan 29 2020 Steve Grubb <sgrubb@redhat.com> 3.0-0.18.20191104git1c2f876
- Fix multiple definition of `event_node_list' (#1794446)

* Tue Jan 28 2020 Fedora Release Engineering <releng@fedoraproject.org> - 3.0-0.17.20191104git1c2f876
- Rebuilt for https://fedoraproject.org/wiki/Fedora_32_Mass_Rebuild

* Fri Nov 22 2019 Steve Grubb <sgrubb@redhat.com> 3.0-0.16.20191104git1c2f876
- Drop python2 subpackage (#1775076)

* Mon Nov 04 2019 Steve Grubb <sgrubb@redhat.com> 3.0-0.14.20191104git1c2f876
- New upstream git snapshot prerelease

* Thu Oct 03 2019 Miro Hrončok <mhroncok@redhat.com> - 3.0-0.14.20190507gitf58ec40
- Rebuilt for Python 3.8.0rc1 (#1748018)

* Mon Aug 19 2019 Miro Hrončok <mhroncok@redhat.com> - 3.0-0.13.20190507gitf58ec40
- Rebuilt for Python 3.8

* Wed Jul 31 2019 Steve Grubb <sgrubb@redhat.com> 3.0-0.12.20190507gitf58ec40
- Fix 1734953 - audit: FTBFS in Fedora rawhide/f31

* Wed Jul 24 2019 Fedora Release Engineering <releng@fedoraproject.org> - 3.0-0.11.20190507gitf58ec40
- Rebuilt for https://fedoraproject.org/wiki/Fedora_31_Mass_Rebuild

* Fri Jul 05 2019 Steve Grubb <sgrubb@redhat.com> 3.0-0.10.20190507gitf58ec40
- Add initscripts package to the requires (bz #1727058)

* Mon Jun 10 2019 Steve Grubb <sgrubb@redhat.com> 3.0-0.9.20190507gitf58ec40
- New upstream git snapshot prerelease which fixes several problems
- Fixed 1698130 - removing audit.rpm doesn't stop auditd

* Tue Mar 26 2019 Steve Grubb <sgrubb@redhat.com> 3.0-0.7.20190326git03e7489
- New upstream git snapshot prerelease which fixes a memory leak

* Thu Jan 31 2019 Fedora Release Engineering <releng@fedoraproject.org> - 3.0-0.6.20181218gitbdb72c0
- Rebuilt for https://fedoraproject.org/wiki/Fedora_30_Mass_Rebuild

* Tue Dec 18 2018 Steve Grubb <sgrubb@redhat.com> 3.0-0.5.20181218gitbdb72c0
- New upstream git snapshot prerelease
- Remove historical ldconfig scriptlet (#1644056)

* Fri Aug 31 2018 Steve Grubb <sgrubb@redhat.com> 3.0-0.4.20180831git0047a6c
- New upstream feature prerelease

* Wed Aug 08 2018 Steve Grubb <sgrubb@redhat.com> 3.0-0.2.20180808git77fbcf3
- New upstream feature prerelease

* Tue Jul 17 2018 Steve Grubb <sgrubb@redhat.com> 3.0-0.1.20180717gitacd53d1
- New upstream feature prerelease

* Thu Jul 12 2018 Fedora Release Engineering <releng@fedoraproject.org> - 2.8.4-4
- Rebuilt for https://fedoraproject.org/wiki/Fedora_29_Mass_Rebuild

* Wed Jul  4 2018 Peter Robinson <pbrobinson@fedoraproject.org> 2.8.4-3
- Remove unused sys V initscripts legacy bits

* Mon Jul 02 2018 Miro Hrončok <mhroncok@redhat.com> - 2.8.4-2
- Rebuilt for Python 3.7

* Tue Jun 19 2018 Steve Grubb <sgrubb@redhat.com> 2.8.4-1
- New upstream bugfix release

* Tue Jun 19 2018 Miro Hrončok <mhroncok@redhat.com> - 2.8.3-4
- Rebuilt for Python 3.7

* Tue Apr 10 2018 Pete Walter <pwalter@fedoraproject.org> - 2.8.3-3
- Rename Python 2 and 3 subpackages to python2-audit and python3-audit as per guidelines

* Mon Mar 26 2018 Steve Grubb <sgrubb@redhat.com> 2.8.3-2
- Fix Obsoletion of audit-libs-python not handled properly (#1559674)

* Sat Mar 10 2018 Steve Grubb <sgrubb@redhat.com> 2.8.3-1
- New upstream bugfix release

* Wed Feb 07 2018 Fedora Release Engineering <releng@fedoraproject.org> - 2.8.2-4
- Rebuilt for https://fedoraproject.org/wiki/Fedora_28_Mass_Rebuild

* Mon Feb 05 2018 Steve Grubb <sgrubb@redhat.com> 2.8.2-3
- Add a Provides audit-libs-python (#1537864)
- Remove tcp_wrappers support?

* Thu Dec 14 2017 Steve Grubb <sgrubb@redhat.com> 2.8.2-2
- Rename things from python to python2

* Thu Dec 14 2017 Steve Grubb <sgrubb@redhat.com> 2.8.2-1
- New upstream bugfix release

* Thu Oct 12 2017 Steve Grubb <sgrubb@redhat.com> 2.8.1-1
- New upstream bugfix release

* Tue Oct 10 2017 Steve Grubb <sgrubb@redhat.com> 2.8-1
- New upstream feature release

* Mon Sep 18 2017 Steve Grubb <sgrubb@redhat.com> 2.7.8-1
- New upstream bugfix release

* Wed Aug 02 2017 Fedora Release Engineering <releng@fedoraproject.org> - 2.7.7-5
- Rebuilt for https://fedoraproject.org/wiki/Fedora_27_Binutils_Mass_Rebuild

* Wed Jul 26 2017 Fedora Release Engineering <releng@fedoraproject.org> - 2.7.7-4
- Rebuilt for https://fedoraproject.org/wiki/Fedora_27_Mass_Rebuild

* Fri Jul 14 2017 Steve Grubb <sgrubb@redhat.com> 2.7.7-3
- undo scratch build

* Fri Jun 16 2017 Steve Grubb <sgrubb@redhat.com> 2.7.7-1
- New upstream bugfix release

* Wed Apr 19 2017 Steve Grubb <sgrubb@redhat.com> 2.7.6-1
- New upstream bugfix release

* Mon Apr 10 2017 Steve Grubb <sgrubb@redhat.com> 2.7.5-1
- New upstream bugfix release

* Tue Mar 28 2017 Steve Grubb <sgrubb@redhat.com> 2.7.4-1
- New upstream feature and bugfix release

* Fri Feb 24 2017 Steve Grubb <sgrubb@redhat.com> 2.7.3-1
- New upstream feature and bugfix release

* Mon Feb 13 2017 Steve Grubb <sgrubb@redhat.com> 2.7.2-2
- Fix ausearch csv output

* Mon Feb 13 2017 Steve Grubb <sgrubb@redhat.com> 2.7.2-1
- New upstream feature and bugfix release

* Fri Feb 10 2017 Fedora Release Engineering <releng@fedoraproject.org> - 2.7.1-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_26_Mass_Rebuild

* Fri Jan 13 2017 Steve Grubb <sgrubb@redhat.com> 2.7.1-1
- New upstream bugfix release

* Mon Dec 19 2016 Miro Hrončok <mhroncok@redhat.com> - 2.7-2
- Rebuild for Python 3.6

* Thu Dec 15 2016 Steve Grubb <sgrubb@redhat.com> 2.7-1
- New upstream feature release

* Sun Sep 11 2016 Steve Grubb <sgrubb@redhat.com> 2.6.7-1
- New upstream bugfix release

* Mon Aug 01 2016 Steve Grubb <sgrubb@redhat.com> 2.6.6-1
- New upstream bugfix release

* Thu Jul 21 2016 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 2.6.5-3
- https://fedoraproject.org/wiki/Changes/golang1.7

* Tue Jul 19 2016 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 2.6.5-2
- https://fedoraproject.org/wiki/Changes/Automatic_Provides_for_Python_RPM_Packages

* Thu Jul 14 2016 Steve Grubb <sgrubb@redhat.com> 2.6.5-1
- New upstream bugfix release

* Fri Jul 08 2016 Steve Grubb <sgrubb@redhat.com> 2.6.4-2
- Correct size information of dispatched event

* Fri Jul 08 2016 Steve Grubb <sgrubb@redhat.com> 2.6.4-1
- New upstream bugfix release

* Tue Jul 05 2016 Steve Grubb <sgrubb@redhat.com> 2.6.3-2
- Fix sockaddr event interpretation

* Tue Jul 05 2016 Steve Grubb <sgrubb@redhat.com> 2.6.3-1
- New upstream bugfix release

* Fri Jul 01 2016 Steve Grubb <sgrubb@redhat.com> 2.6.2-1
- New upstream bugfix release
- Fixes 1351954 - prevents virtual machine from starting up in GNOME Boxes

* Tue Jun 28 2016 Steve Grubb <sgrubb@redhat.com> 2.6.1-1
- New upstream bugfix release

* Wed Jun 22 2016 Steve Grubb <sgrubb@redhat.com> 2.6-3
- New upstream release

* Fri Apr 29 2016 Steve Grubb <sgrubb@redhat.com> 2.5.2-1
- New upstream release

* Thu Apr 28 2016 Steve Grubb <sgrubb@redhat.com> 2.5.1-2
- Refactor plugins to split out zos-remote to lower dependencies

* Wed Apr 13 2016 Steve Grubb <sgrubb@redhat.com> 2.5.1-1
- New upstream release

* Fri Mar 18 2016 Steve Grubb <sgrubb@redhat.com> 2.5-4
- Fixes #1313152 - post script fails on dnf --setopt=tsflags=nodocs install

* Mon Feb 22 2016 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 2.5-3
- https://fedoraproject.org/wiki/Changes/golang1.6

* Wed Feb 03 2016 Fedora Release Engineering <releng@fedoraproject.org> - 2.5-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_24_Mass_Rebuild

* Mon Jan 11 2016 Steve Grubb <sgrubb@redhat.com> 2.5-1
- New upstream release
- Fixes #1241565 - still logs way too much
- Fixes #1238051 - audit.rules should be generated from by augenrules

* Fri Dec 18 2015 Steve Grubb <sgrubb@redhat.com> 2.4.4-1
- New upstream bugfix release

* Wed Nov 04 2015 Robert Kuska <rkuska@redhat.com> - 2.4.4-3
- Rebuilt for Python3.5 rebuild

* Wed Sep 16 2015 Peter Robinson <pbrobinson@fedoraproject.org> 2.4.4-2
- Fix FTBFS with hardened flags by using the distro CFLAGS
- Tighten deps with the _isa macro
- Use goarches macro to define supported GO architectures
- Minor cleanups

* Thu Aug 13 2015 Steve Grubb <sgrubb@redhat.com> 2.4.4-1
- New upstream bugfix release
- Fixes CVE-2015-5186 Audit: log terminal emulator escape sequences handling

* Thu Jul 16 2015 Steve Grubb <sgrubb@redhat.com> 2.4.3-1
- New upstream bugfix release
- Adds python3 support

* Wed Jun 17 2015 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 2.4.2-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_23_Mass_Rebuild

* Tue Apr 28 2015 Steve Grubb <sgrubb@redhat.com> 2.4.2-1
- New upstream bugfix release

* Sat Feb 21 2015 Till Maas <opensource@till.name> - 2.4.1-2
- Rebuilt for Fedora 23 Change
  https://fedoraproject.org/wiki/Changes/Harden_all_packages_with_position-independent_code

* Tue Oct 28 2014 Steve Grubb <sgrubb@redhat.com> 2.4.1-1
- New upstream feature and bugfix release

* Mon Oct 06 2014 Karsten Hopp <karsten@redhat.com> 2.4-2
- bump release and rebuild for upgradepath

* Sun Aug 24 2014 Steve Grubb <sgrubb@redhat.com> 2.4-1
- New upstream feature and bugfix release

* Fri Aug 15 2014 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 2.3.8-0.3.svn20140803
- Rebuilt for https://fedoraproject.org/wiki/Fedora_21_22_Mass_Rebuild

* Mon Aug  4 2014 Peter Robinson <pbrobinson@fedoraproject.org> 2.3.8-0.2.svn20140803
- aarch64/PPC/s390 don't have golang

* Sat Aug 02 2014 Steve Grubb <sgrubb@redhat.com> 2.3.8-0.1.svn20140803
- New upstream svn snapshot

* Tue Jul 22 2014 Steve Grubb <sgrubb@redhat.com> 2.3.7-4
- Bug 1117953 - Per fesco#1311, please disable syscall auditing by default

* Fri Jul 11 2014 Tom Callaway <spot@fedoraproject.org> - 2.3.7-3
- mark license files properly

* Sat Jun 07 2014 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 2.3.7-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_21_Mass_Rebuild

* Tue Jun 03 2014 Steve Grubb <sgrubb@redhat.com> 2.3.7-1
- New upstream bugfix release

* Fri Apr 11 2014 Steve Grubb <sgrubb@redhat.com> 2.3.6-1
- New upstream bugfix/enhancement release

* Mon Mar 17 2014 Steve Grubb <sgrubb@redhat.com> 2.3.5-1
- New upstream bugfix/enhancement release

* Thu Feb 27 2014 Steve Grubb <sgrubb@redhat.com> 2.3.4-1
- New upstream bugfix/enhancement release

* Thu Jan 16 2014 Steve Grubb <sgrubb@redhat.com> 2.3.3-1
- New upstream bugfix/enhancement release

* Mon Jul 29 2013 Steve Grubb <sgrubb@redhat.com> 2.3.2-1
- New upstream bugfix/enhancement release

* Fri Jun 21 2013 Steve Grubb <sgrubb@redhat.com> 2.3.1-3
- Drop prelude support

* Fri May 31 2013 Steve Grubb <sgrubb@redhat.com> 2.3.1-2
- Fix unknown lvalue in auditd.service (#969345)

* Thu May 30 2013 Steve Grubb <sgrubb@redhat.com> 2.3.1-1
- New upstream bugfix/enhancement release

* Fri May 03 2013 Steve Grubb <sgrubb@redhat.com> 2.3-2
- If no rules exist, copy shipped rules into place

