<!--- This file is automatically generated using build/configure.js --->

# Rule Descriptions

## Table of Contents

- [WCAG 2.0 Level A & AA Rules](#wcag-20-level-a--aa-rules)
- [WCAG 2.1 Level A & AA Rules](#wcag-21-level-a--aa-rules)
- [WCAG 2.2 Level A & AA Rules](#wcag-22-level-a--aa-rules)
- [Best Practices Rules](#best-practices-rules)
- [WCAG 2.x level AAA rules](#wcag-2x-level-aaa-rules)
- [Experimental Rules](#experimental-rules)
- [Deprecated Rules](#deprecated-rules)

## WCAG 2.0 Level A & AA Rules

| Rule ID                                                                                                                           | Description                                                                                                                                          | Impact   | Tags                                                                                                                               | Issue Type                 | ACT Rules                                                                                                                                                                                                                                                          |
| :-------------------------------------------------------------------------------------------------------------------------------- | :--------------------------------------------------------------------------------------------------------------------------------------------------- | :------- | :--------------------------------------------------------------------------------------------------------------------------------- | :------------------------- | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [area-alt](https://dequeuniversity.com/rules/axe/4.10/area-alt?application=RuleDescription)                                       | Ensure &lt;area&gt; elements of image maps have alternate text                                                                                       | Critical | cat.text-alternatives, wcag2a, wcag244, wcag412, section508, section508.22.a, TTv5, TT6.a, EN-301-549, EN-9.2.4.4, EN-9.4.1.2, ACT | failure, needs&nbsp;review | [c487ae](https://act-rules.github.io/rules/c487ae)                                                                                                                                                                                                                 |
| [aria-allowed-attr](https://dequeuniversity.com/rules/axe/4.10/aria-allowed-attr?application=RuleDescription)                     | Ensure an element&apos;s role supports its ARIA attributes                                                                                           | Critical | cat.aria, wcag2a, wcag412, EN-301-549, EN-9.4.1.2                                                                                  | failure, needs&nbsp;review | [5c01ea](https://act-rules.github.io/rules/5c01ea)                                                                                                                                                                                                                 |
| [aria-braille-equivalent](https://dequeuniversity.com/rules/axe/4.10/aria-braille-equivalent?application=RuleDescription)         | Ensure aria-braillelabel and aria-brailleroledescription have a non-braille equivalent                                                               | Serious  | cat.aria, wcag2a, wcag412, EN-301-549, EN-9.4.1.2                                                                                  | needs&nbsp;review          |                                                                                                                                                                                                                                                                    |
| [aria-command-name](https://dequeuniversity.com/rules/axe/4.10/aria-command-name?application=RuleDescription)                     | Ensure every ARIA button, link and menuitem has an accessible name                                                                                   | Serious  | cat.aria, wcag2a, wcag412, TTv5, TT6.a, EN-301-549, EN-9.4.1.2, ACT                                                                | failure, needs&nbsp;review | [97a4e1](https://act-rules.github.io/rules/97a4e1)                                                                                                                                                                                                                 |
| [aria-conditional-attr](https://dequeuniversity.com/rules/axe/4.10/aria-conditional-attr?application=RuleDescription)             | Ensure ARIA attributes are used as described in the specification of the element&apos;s role                                                         | Serious  | cat.aria, wcag2a, wcag412, EN-301-549, EN-9.4.1.2                                                                                  | failure                    | [5c01ea](https://act-rules.github.io/rules/5c01ea)                                                                                                                                                                                                                 |
| [aria-deprecated-role](https://dequeuniversity.com/rules/axe/4.10/aria-deprecated-role?application=RuleDescription)               | Ensure elements do not use deprecated roles                                                                                                          | Minor    | cat.aria, wcag2a, wcag412, EN-301-549, EN-9.4.1.2                                                                                  | failure                    | [674b10](https://act-rules.github.io/rules/674b10)                                                                                                                                                                                                                 |
| [aria-hidden-body](https://dequeuniversity.com/rules/axe/4.10/aria-hidden-body?application=RuleDescription)                       | Ensure aria-hidden=&quot;true&quot; is not present on the document body.                                                                             | Critical | cat.aria, wcag2a, wcag131, wcag412, EN-301-549, EN-9.1.3.1, EN-9.4.1.2                                                             | failure                    |                                                                                                                                                                                                                                                                    |
| [aria-hidden-focus](https://dequeuniversity.com/rules/axe/4.10/aria-hidden-focus?application=RuleDescription)                     | Ensure aria-hidden elements are not focusable nor contain focusable elements                                                                         | Serious  | cat.name-role-value, wcag2a, wcag412, TTv5, TT6.a, EN-301-549, EN-9.4.1.2                                                          | failure, needs&nbsp;review | [6cfa84](https://act-rules.github.io/rules/6cfa84)                                                                                                                                                                                                                 |
| [aria-input-field-name](https://dequeuniversity.com/rules/axe/4.10/aria-input-field-name?application=RuleDescription)             | Ensure every ARIA input field has an accessible name                                                                                                 | Serious  | cat.aria, wcag2a, wcag412, TTv5, TT5.c, EN-301-549, EN-9.4.1.2, ACT                                                                | failure, needs&nbsp;review | [e086e5](https://act-rules.github.io/rules/e086e5)                                                                                                                                                                                                                 |
| [aria-meter-name](https://dequeuniversity.com/rules/axe/4.10/aria-meter-name?application=RuleDescription)                         | Ensure every ARIA meter node has an accessible name                                                                                                  | Serious  | cat.aria, wcag2a, wcag111, EN-301-549, EN-9.1.1.1                                                                                  | failure, needs&nbsp;review |                                                                                                                                                                                                                                                                    |
| [aria-progressbar-name](https://dequeuniversity.com/rules/axe/4.10/aria-progressbar-name?application=RuleDescription)             | Ensure every ARIA progressbar node has an accessible name                                                                                            | Serious  | cat.aria, wcag2a, wcag111, EN-301-549, EN-9.1.1.1                                                                                  | failure, needs&nbsp;review |                                                                                                                                                                                                                                                                    |
| [aria-prohibited-attr](https://dequeuniversity.com/rules/axe/4.10/aria-prohibited-attr?application=RuleDescription)               | Ensure ARIA attributes are not prohibited for an element&apos;s role                                                                                 | Serious  | cat.aria, wcag2a, wcag412, EN-301-549, EN-9.4.1.2                                                                                  | failure, needs&nbsp;review | [5c01ea](https://act-rules.github.io/rules/5c01ea)                                                                                                                                                                                                                 |
| [aria-required-attr](https://dequeuniversity.com/rules/axe/4.10/aria-required-attr?application=RuleDescription)                   | Ensure elements with ARIA roles have all required ARIA attributes                                                                                    | Critical | cat.aria, wcag2a, wcag412, EN-301-549, EN-9.4.1.2                                                                                  | failure                    | [4e8ab6](https://act-rules.github.io/rules/4e8ab6)                                                                                                                                                                                                                 |
| [aria-required-children](https://dequeuniversity.com/rules/axe/4.10/aria-required-children?application=RuleDescription)           | Ensure elements with an ARIA role that require child roles contain them                                                                              | Critical | cat.aria, wcag2a, wcag131, EN-301-549, EN-9.1.3.1                                                                                  | failure, needs&nbsp;review | [bc4a75](https://act-rules.github.io/rules/bc4a75), [ff89c9](https://act-rules.github.io/rules/ff89c9)                                                                                                                                                             |
| [aria-required-parent](https://dequeuniversity.com/rules/axe/4.10/aria-required-parent?application=RuleDescription)               | Ensure elements with an ARIA role that require parent roles are contained by them                                                                    | Critical | cat.aria, wcag2a, wcag131, EN-301-549, EN-9.1.3.1                                                                                  | failure                    | [ff89c9](https://act-rules.github.io/rules/ff89c9)                                                                                                                                                                                                                 |
| [aria-roles](https://dequeuniversity.com/rules/axe/4.10/aria-roles?application=RuleDescription)                                   | Ensure all elements with a role attribute use a valid value                                                                                          | Critical | cat.aria, wcag2a, wcag412, EN-301-549, EN-9.4.1.2                                                                                  | failure                    | [674b10](https://act-rules.github.io/rules/674b10)                                                                                                                                                                                                                 |
| [aria-toggle-field-name](https://dequeuniversity.com/rules/axe/4.10/aria-toggle-field-name?application=RuleDescription)           | Ensure every ARIA toggle field has an accessible name                                                                                                | Serious  | cat.aria, wcag2a, wcag412, TTv5, TT5.c, EN-301-549, EN-9.4.1.2, ACT                                                                | failure, needs&nbsp;review | [e086e5](https://act-rules.github.io/rules/e086e5)                                                                                                                                                                                                                 |
| [aria-tooltip-name](https://dequeuniversity.com/rules/axe/4.10/aria-tooltip-name?application=RuleDescription)                     | Ensure every ARIA tooltip node has an accessible name                                                                                                | Serious  | cat.aria, wcag2a, wcag412, EN-301-549, EN-9.4.1.2                                                                                  | failure, needs&nbsp;review |                                                                                                                                                                                                                                                                    |
| [aria-valid-attr-value](https://dequeuniversity.com/rules/axe/4.10/aria-valid-attr-value?application=RuleDescription)             | Ensure all ARIA attributes have valid values                                                                                                         | Critical | cat.aria, wcag2a, wcag412, EN-301-549, EN-9.4.1.2                                                                                  | failure, needs&nbsp;review | [6a7281](https://act-rules.github.io/rules/6a7281)                                                                                                                                                                                                                 |
| [aria-valid-attr](https://dequeuniversity.com/rules/axe/4.10/aria-valid-attr?application=RuleDescription)                         | Ensure attributes that begin with aria- are valid ARIA attributes                                                                                    | Critical | cat.aria, wcag2a, wcag412, EN-301-549, EN-9.4.1.2                                                                                  | failure                    | [5f99a7](https://act-rules.github.io/rules/5f99a7)                                                                                                                                                                                                                 |
| [blink](https://dequeuniversity.com/rules/axe/4.10/blink?application=RuleDescription)                                             | Ensure &lt;blink&gt; elements are not used                                                                                                           | Serious  | cat.time-and-media, wcag2a, wcag222, section508, section508.22.j, TTv5, TT2.b, EN-301-549, EN-9.2.2.2                              | failure                    |                                                                                                                                                                                                                                                                    |
| [button-name](https://dequeuniversity.com/rules/axe/4.10/button-name?application=RuleDescription)                                 | Ensure buttons have discernible text                                                                                                                 | Critical | cat.name-role-value, wcag2a, wcag412, section508, section508.22.a, TTv5, TT6.a, EN-301-549, EN-9.4.1.2, ACT                        | failure, needs&nbsp;review | [97a4e1](https://act-rules.github.io/rules/97a4e1), [m6b1q3](https://act-rules.github.io/rules/m6b1q3)                                                                                                                                                             |
| [bypass](https://dequeuniversity.com/rules/axe/4.10/bypass?application=RuleDescription)                                           | Ensure each page has at least one mechanism for a user to bypass navigation and jump straight to the content                                         | Serious  | cat.keyboard, wcag2a, wcag241, section508, section508.22.o, TTv5, TT9.a, EN-301-549, EN-9.2.4.1                                    | needs&nbsp;review          | [cf77f2](https://act-rules.github.io/rules/cf77f2), [047fe0](https://act-rules.github.io/rules/047fe0), [b40fd1](https://act-rules.github.io/rules/b40fd1), [3e12e1](https://act-rules.github.io/rules/3e12e1), [ye5d6e](https://act-rules.github.io/rules/ye5d6e) |
| [color-contrast](https://dequeuniversity.com/rules/axe/4.10/color-contrast?application=RuleDescription)                           | Ensure the contrast between foreground and background colors meets WCAG 2 AA minimum contrast ratio thresholds                                       | Serious  | cat.color, wcag2aa, wcag143, TTv5, TT13.c, EN-301-549, EN-9.1.4.3, ACT                                                             | failure, needs&nbsp;review | [afw4f7](https://act-rules.github.io/rules/afw4f7), [09o5cg](https://act-rules.github.io/rules/09o5cg)                                                                                                                                                             |
| [definition-list](https://dequeuniversity.com/rules/axe/4.10/definition-list?application=RuleDescription)                         | Ensure &lt;dl&gt; elements are structured correctly                                                                                                  | Serious  | cat.structure, wcag2a, wcag131, EN-301-549, EN-9.1.3.1                                                                             | failure                    |                                                                                                                                                                                                                                                                    |
| [dlitem](https://dequeuniversity.com/rules/axe/4.10/dlitem?application=RuleDescription)                                           | Ensure &lt;dt&gt; and &lt;dd&gt; elements are contained by a &lt;dl&gt;                                                                              | Serious  | cat.structure, wcag2a, wcag131, EN-301-549, EN-9.1.3.1                                                                             | failure                    |                                                                                                                                                                                                                                                                    |
| [document-title](https://dequeuniversity.com/rules/axe/4.10/document-title?application=RuleDescription)                           | Ensure each HTML document contains a non-empty &lt;title&gt; element                                                                                 | Serious  | cat.text-alternatives, wcag2a, wcag242, TTv5, TT12.a, EN-301-549, EN-9.2.4.2, ACT                                                  | failure                    | [2779a5](https://act-rules.github.io/rules/2779a5)                                                                                                                                                                                                                 |
| [duplicate-id-aria](https://dequeuniversity.com/rules/axe/4.10/duplicate-id-aria?application=RuleDescription)                     | Ensure every id attribute value used in ARIA and in labels is unique                                                                                 | Critical | cat.parsing, wcag2a, wcag412, EN-301-549, EN-9.4.1.2                                                                               | needs&nbsp;review          | [3ea0c8](https://act-rules.github.io/rules/3ea0c8)                                                                                                                                                                                                                 |
| [form-field-multiple-labels](https://dequeuniversity.com/rules/axe/4.10/form-field-multiple-labels?application=RuleDescription)   | Ensure form field does not have multiple label elements                                                                                              | Moderate | cat.forms, wcag2a, wcag332, TTv5, TT5.c, EN-301-549, EN-9.3.3.2                                                                    | needs&nbsp;review          |                                                                                                                                                                                                                                                                    |
| [frame-focusable-content](https://dequeuniversity.com/rules/axe/4.10/frame-focusable-content?application=RuleDescription)         | Ensure &lt;frame&gt; and &lt;iframe&gt; elements with focusable content do not have tabindex=-1                                                      | Serious  | cat.keyboard, wcag2a, wcag211, TTv5, TT4.a, EN-301-549, EN-9.2.1.1                                                                 | failure, needs&nbsp;review | [akn7bn](https://act-rules.github.io/rules/akn7bn)                                                                                                                                                                                                                 |
| [frame-title-unique](https://dequeuniversity.com/rules/axe/4.10/frame-title-unique?application=RuleDescription)                   | Ensure &lt;iframe&gt; and &lt;frame&gt; elements contain a unique title attribute                                                                    | Serious  | cat.text-alternatives, wcag2a, wcag412, TTv5, TT12.d, EN-301-549, EN-9.4.1.2                                                       | needs&nbsp;review          | [4b1c6c](https://act-rules.github.io/rules/4b1c6c)                                                                                                                                                                                                                 |
| [frame-title](https://dequeuniversity.com/rules/axe/4.10/frame-title?application=RuleDescription)                                 | Ensure &lt;iframe&gt; and &lt;frame&gt; elements have an accessible name                                                                             | Serious  | cat.text-alternatives, wcag2a, wcag412, section508, section508.22.i, TTv5, TT12.d, EN-301-549, EN-9.4.1.2                          | failure, needs&nbsp;review | [cae760](https://act-rules.github.io/rules/cae760)                                                                                                                                                                                                                 |
| [html-has-lang](https://dequeuniversity.com/rules/axe/4.10/html-has-lang?application=RuleDescription)                             | Ensure every HTML document has a lang attribute                                                                                                      | Serious  | cat.language, wcag2a, wcag311, TTv5, TT11.a, EN-301-549, EN-9.3.1.1, ACT                                                           | failure                    | [b5c3f8](https://act-rules.github.io/rules/b5c3f8)                                                                                                                                                                                                                 |
| [html-lang-valid](https://dequeuniversity.com/rules/axe/4.10/html-lang-valid?application=RuleDescription)                         | Ensure the lang attribute of the &lt;html&gt; element has a valid value                                                                              | Serious  | cat.language, wcag2a, wcag311, TTv5, TT11.a, EN-301-549, EN-9.3.1.1, ACT                                                           | failure                    | [bf051a](https://act-rules.github.io/rules/bf051a)                                                                                                                                                                                                                 |
| [html-xml-lang-mismatch](https://dequeuniversity.com/rules/axe/4.10/html-xml-lang-mismatch?application=RuleDescription)           | Ensure that HTML elements with both valid lang and xml:lang attributes agree on the base language of the page                                        | Moderate | cat.language, wcag2a, wcag311, EN-301-549, EN-9.3.1.1, ACT                                                                         | failure                    | [5b7ae0](https://act-rules.github.io/rules/5b7ae0)                                                                                                                                                                                                                 |
| [image-alt](https://dequeuniversity.com/rules/axe/4.10/image-alt?application=RuleDescription)                                     | Ensure &lt;img&gt; elements have alternate text or a role of none or presentation                                                                    | Critical | cat.text-alternatives, wcag2a, wcag111, section508, section508.22.a, TTv5, TT7.a, TT7.b, EN-301-549, EN-9.1.1.1, ACT               | failure, needs&nbsp;review | [23a2a8](https://act-rules.github.io/rules/23a2a8)                                                                                                                                                                                                                 |
| [input-button-name](https://dequeuniversity.com/rules/axe/4.10/input-button-name?application=RuleDescription)                     | Ensure input buttons have discernible text                                                                                                           | Critical | cat.name-role-value, wcag2a, wcag412, section508, section508.22.a, TTv5, TT5.c, EN-301-549, EN-9.4.1.2, ACT                        | failure, needs&nbsp;review | [97a4e1](https://act-rules.github.io/rules/97a4e1)                                                                                                                                                                                                                 |
| [input-image-alt](https://dequeuniversity.com/rules/axe/4.10/input-image-alt?application=RuleDescription)                         | Ensure &lt;input type=&quot;image&quot;&gt; elements have alternate text                                                                             | Critical | cat.text-alternatives, wcag2a, wcag111, wcag412, section508, section508.22.a, TTv5, TT7.a, EN-301-549, EN-9.1.1.1, EN-9.4.1.2, ACT | failure, needs&nbsp;review | [59796f](https://act-rules.github.io/rules/59796f)                                                                                                                                                                                                                 |
| [label](https://dequeuniversity.com/rules/axe/4.10/label?application=RuleDescription)                                             | Ensure every form element has a label                                                                                                                | Critical | cat.forms, wcag2a, wcag412, section508, section508.22.n, TTv5, TT5.c, EN-301-549, EN-9.4.1.2, ACT                                  | failure, needs&nbsp;review | [e086e5](https://act-rules.github.io/rules/e086e5)                                                                                                                                                                                                                 |
| [link-in-text-block](https://dequeuniversity.com/rules/axe/4.10/link-in-text-block?application=RuleDescription)                   | Ensure links are distinguished from surrounding text in a way that does not rely on color                                                            | Serious  | cat.color, wcag2a, wcag141, TTv5, TT13.a, EN-301-549, EN-9.1.4.1                                                                   | failure, needs&nbsp;review |                                                                                                                                                                                                                                                                    |
| [link-name](https://dequeuniversity.com/rules/axe/4.10/link-name?application=RuleDescription)                                     | Ensure links have discernible text                                                                                                                   | Serious  | cat.name-role-value, wcag2a, wcag244, wcag412, section508, section508.22.a, TTv5, TT6.a, EN-301-549, EN-9.2.4.4, EN-9.4.1.2, ACT   | failure, needs&nbsp;review | [c487ae](https://act-rules.github.io/rules/c487ae)                                                                                                                                                                                                                 |
| [list](https://dequeuniversity.com/rules/axe/4.10/list?application=RuleDescription)                                               | Ensure that lists are structured correctly                                                                                                           | Serious  | cat.structure, wcag2a, wcag131, EN-301-549, EN-9.1.3.1                                                                             | failure                    |                                                                                                                                                                                                                                                                    |
| [listitem](https://dequeuniversity.com/rules/axe/4.10/listitem?application=RuleDescription)                                       | Ensure &lt;li&gt; elements are used semantically                                                                                                     | Serious  | cat.structure, wcag2a, wcag131, EN-301-549, EN-9.1.3.1                                                                             | failure                    |                                                                                                                                                                                                                                                                    |
| [marquee](https://dequeuniversity.com/rules/axe/4.10/marquee?application=RuleDescription)                                         | Ensure &lt;marquee&gt; elements are not used                                                                                                         | Serious  | cat.parsing, wcag2a, wcag222, TTv5, TT2.b, EN-301-549, EN-9.2.2.2                                                                  | failure                    |                                                                                                                                                                                                                                                                    |
| [meta-refresh](https://dequeuniversity.com/rules/axe/4.10/meta-refresh?application=RuleDescription)                               | Ensure &lt;meta http-equiv=&quot;refresh&quot;&gt; is not used for delayed refresh                                                                   | Critical | cat.time-and-media, wcag2a, wcag221, TTv5, TT8.a, EN-301-549, EN-9.2.2.1                                                           | failure                    | [bc659a](https://act-rules.github.io/rules/bc659a), [bisz58](https://act-rules.github.io/rules/bisz58)                                                                                                                                                             |
| [meta-viewport](https://dequeuniversity.com/rules/axe/4.10/meta-viewport?application=RuleDescription)                             | Ensure &lt;meta name=&quot;viewport&quot;&gt; does not disable text scaling and zooming                                                              | Critical | cat.sensory-and-visual-cues, wcag2aa, wcag144, EN-301-549, EN-9.1.4.4, ACT                                                         | failure                    | [b4f0c3](https://act-rules.github.io/rules/b4f0c3)                                                                                                                                                                                                                 |
| [nested-interactive](https://dequeuniversity.com/rules/axe/4.10/nested-interactive?application=RuleDescription)                   | Ensure interactive controls are not nested as they are not always announced by screen readers or can cause focus problems for assistive technologies | Serious  | cat.keyboard, wcag2a, wcag412, TTv5, TT6.a, EN-301-549, EN-9.4.1.2                                                                 | failure, needs&nbsp;review | [307n5z](https://act-rules.github.io/rules/307n5z)                                                                                                                                                                                                                 |
| [no-autoplay-audio](https://dequeuniversity.com/rules/axe/4.10/no-autoplay-audio?application=RuleDescription)                     | Ensure &lt;video&gt; or &lt;audio&gt; elements do not autoplay audio for more than 3 seconds without a control mechanism to stop or mute the audio   | Moderate | cat.time-and-media, wcag2a, wcag142, TTv5, TT2.a, EN-301-549, EN-9.1.4.2, ACT                                                      | needs&nbsp;review          | [80f0bf](https://act-rules.github.io/rules/80f0bf)                                                                                                                                                                                                                 |
| [object-alt](https://dequeuniversity.com/rules/axe/4.10/object-alt?application=RuleDescription)                                   | Ensure &lt;object&gt; elements have alternate text                                                                                                   | Serious  | cat.text-alternatives, wcag2a, wcag111, section508, section508.22.a, EN-301-549, EN-9.1.1.1                                        | failure, needs&nbsp;review | [8fc3b6](https://act-rules.github.io/rules/8fc3b6)                                                                                                                                                                                                                 |
| [role-img-alt](https://dequeuniversity.com/rules/axe/4.10/role-img-alt?application=RuleDescription)                               | Ensure [role=&quot;img&quot;] elements have alternate text                                                                                           | Serious  | cat.text-alternatives, wcag2a, wcag111, section508, section508.22.a, TTv5, TT7.a, EN-301-549, EN-9.1.1.1, ACT                      | failure, needs&nbsp;review | [23a2a8](https://act-rules.github.io/rules/23a2a8)                                                                                                                                                                                                                 |
| [scrollable-region-focusable](https://dequeuniversity.com/rules/axe/4.10/scrollable-region-focusable?application=RuleDescription) | Ensure elements that have scrollable content are accessible by keyboard                                                                              | Serious  | cat.keyboard, wcag2a, wcag211, wcag213, TTv5, TT4.a, EN-301-549, EN-9.2.1.1, EN-9.2.1.3                                            | failure                    | [0ssw9k](https://act-rules.github.io/rules/0ssw9k)                                                                                                                                                                                                                 |
| [select-name](https://dequeuniversity.com/rules/axe/4.10/select-name?application=RuleDescription)                                 | Ensure select element has an accessible name                                                                                                         | Critical | cat.forms, wcag2a, wcag412, section508, section508.22.n, TTv5, TT5.c, EN-301-549, EN-9.4.1.2, ACT                                  | failure, needs&nbsp;review | [e086e5](https://act-rules.github.io/rules/e086e5)                                                                                                                                                                                                                 |
| [server-side-image-map](https://dequeuniversity.com/rules/axe/4.10/server-side-image-map?application=RuleDescription)             | Ensure that server-side image maps are not used                                                                                                      | Minor    | cat.text-alternatives, wcag2a, wcag211, section508, section508.22.f, TTv5, TT4.a, EN-301-549, EN-9.2.1.1                           | needs&nbsp;review          |                                                                                                                                                                                                                                                                    |
| [summary-name](https://dequeuniversity.com/rules/axe/4.10/summary-name?application=RuleDescription)                               | Ensure summary elements have discernible text                                                                                                        | Serious  | cat.name-role-value, wcag2a, wcag412, section508, section508.22.a, TTv5, TT6.a, EN-301-549, EN-9.4.1.2                             | failure, needs&nbsp;review |                                                                                                                                                                                                                                                                    |
| [svg-img-alt](https://dequeuniversity.com/rules/axe/4.10/svg-img-alt?application=RuleDescription)                                 | Ensure &lt;svg&gt; elements with an img, graphics-document or graphics-symbol role have an accessible text                                           | Serious  | cat.text-alternatives, wcag2a, wcag111, section508, section508.22.a, TTv5, TT7.a, EN-301-549, EN-9.1.1.1, ACT                      | failure, needs&nbsp;review | [7d6734](https://act-rules.github.io/rules/7d6734)                                                                                                                                                                                                                 |
| [td-headers-attr](https://dequeuniversity.com/rules/axe/4.10/td-headers-attr?application=RuleDescription)                         | Ensure that each cell in a table that uses the headers attribute refers only to other cells in that table                                            | Serious  | cat.tables, wcag2a, wcag131, section508, section508.22.g, TTv5, TT14.b, EN-301-549, EN-9.1.3.1                                     | failure, needs&nbsp;review | [a25f45](https://act-rules.github.io/rules/a25f45)                                                                                                                                                                                                                 |
| [th-has-data-cells](https://dequeuniversity.com/rules/axe/4.10/th-has-data-cells?application=RuleDescription)                     | Ensure that &lt;th&gt; elements and elements with role=columnheader/rowheader have data cells they describe                                          | Serious  | cat.tables, wcag2a, wcag131, section508, section508.22.g, TTv5, TT14.b, EN-301-549, EN-9.1.3.1                                     | failure, needs&nbsp;review | [d0f69e](https://act-rules.github.io/rules/d0f69e)                                                                                                                                                                                                                 |
| [valid-lang](https://dequeuniversity.com/rules/axe/4.10/valid-lang?application=RuleDescription)                                   | Ensure lang attributes have valid values                                                                                                             | Serious  | cat.language, wcag2aa, wcag312, TTv5, TT11.b, EN-301-549, EN-9.3.1.2, ACT                                                          | failure                    | [de46e4](https://act-rules.github.io/rules/de46e4)                                                                                                                                                                                                                 |
| [video-caption](https://dequeuniversity.com/rules/axe/4.10/video-caption?application=RuleDescription)                             | Ensure &lt;video&gt; elements have captions                                                                                                          | Critical | cat.text-alternatives, wcag2a, wcag122, section508, section508.22.a, TTv5, TT17.a, EN-301-549, EN-9.1.2.2                          | needs&nbsp;review          | [eac66b](https://act-rules.github.io/rules/eac66b)                                                                                                                                                                                                                 |

## WCAG 2.1 Level A & AA Rules

| Rule ID                                                                                                             | Description                                                                                   | Impact  | Tags                                                            | Issue Type                 | ACT Rules                                                                                                                                                  |
| :------------------------------------------------------------------------------------------------------------------ | :-------------------------------------------------------------------------------------------- | :------ | :-------------------------------------------------------------- | :------------------------- | :--------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [autocomplete-valid](https://dequeuniversity.com/rules/axe/4.10/autocomplete-valid?application=RuleDescription)     | Ensure the autocomplete attribute is correct and suitable for the form field                  | Serious | cat.forms, wcag21aa, wcag135, EN-301-549, EN-9.1.3.5, ACT       | failure, needs&nbsp;review | [73f2c2](https://act-rules.github.io/rules/73f2c2)                                                                                                         |
| [avoid-inline-spacing](https://dequeuniversity.com/rules/axe/4.10/avoid-inline-spacing?application=RuleDescription) | Ensure that text spacing set through style attributes can be adjusted with custom stylesheets | Serious | cat.structure, wcag21aa, wcag1412, EN-301-549, EN-9.1.4.12, ACT | failure                    | [24afc2](https://act-rules.github.io/rules/24afc2), [9e45ec](https://act-rules.github.io/rules/9e45ec), [78fd32](https://act-rules.github.io/rules/78fd32) |

## WCAG 2.2 Level A & AA Rules

These rules are disabled by default, until WCAG 2.2 is more widely adopted and required.

| Rule ID                                                                                           | Description                                         | Impact  | Tags                                           | Issue Type                 | ACT Rules |
| :------------------------------------------------------------------------------------------------ | :-------------------------------------------------- | :------ | :--------------------------------------------- | :------------------------- | :-------- |
| [target-size](https://dequeuniversity.com/rules/axe/4.10/target-size?application=RuleDescription) | Ensure touch targets have sufficient size and space | Serious | cat.sensory-and-visual-cues, wcag22aa, wcag258 | failure, needs&nbsp;review |           |

## Best Practices Rules

Rules that do not necessarily conform to WCAG success criterion but are industry accepted practices that improve the user experience.

| Rule ID                                                                                                                                           | Description                                                                                                                                   | Impact   | Tags                                       | Issue Type                 | ACT Rules                                          |
| :------------------------------------------------------------------------------------------------------------------------------------------------ | :-------------------------------------------------------------------------------------------------------------------------------------------- | :------- | :----------------------------------------- | :------------------------- | :------------------------------------------------- |
| [accesskeys](https://dequeuniversity.com/rules/axe/4.10/accesskeys?application=RuleDescription)                                                   | Ensure every accesskey attribute value is unique                                                                                              | Serious  | cat.keyboard, best-practice                | failure                    |                                                    |
| [aria-allowed-role](https://dequeuniversity.com/rules/axe/4.10/aria-allowed-role?application=RuleDescription)                                     | Ensure role attribute has an appropriate value for the element                                                                                | Minor    | cat.aria, best-practice                    | failure, needs&nbsp;review |                                                    |
| [aria-dialog-name](https://dequeuniversity.com/rules/axe/4.10/aria-dialog-name?application=RuleDescription)                                       | Ensure every ARIA dialog and alertdialog node has an accessible name                                                                          | Serious  | cat.aria, best-practice                    | failure, needs&nbsp;review |                                                    |
| [aria-text](https://dequeuniversity.com/rules/axe/4.10/aria-text?application=RuleDescription)                                                     | Ensure role=&quot;text&quot; is used on elements with no focusable descendants                                                                | Serious  | cat.aria, best-practice                    | failure, needs&nbsp;review |                                                    |
| [aria-treeitem-name](https://dequeuniversity.com/rules/axe/4.10/aria-treeitem-name?application=RuleDescription)                                   | Ensure every ARIA treeitem node has an accessible name                                                                                        | Serious  | cat.aria, best-practice                    | failure, needs&nbsp;review |                                                    |
| [empty-heading](https://dequeuniversity.com/rules/axe/4.10/empty-heading?application=RuleDescription)                                             | Ensure headings have discernible text                                                                                                         | Minor    | cat.name-role-value, best-practice         | failure, needs&nbsp;review | [ffd0e9](https://act-rules.github.io/rules/ffd0e9) |
| [empty-table-header](https://dequeuniversity.com/rules/axe/4.10/empty-table-header?application=RuleDescription)                                   | Ensure table headers have discernible text                                                                                                    | Minor    | cat.name-role-value, best-practice         | failure, needs&nbsp;review |                                                    |
| [frame-tested](https://dequeuniversity.com/rules/axe/4.10/frame-tested?application=RuleDescription)                                               | Ensure &lt;iframe&gt; and &lt;frame&gt; elements contain the axe-core script                                                                  | Critical | cat.structure, best-practice, review-item  | failure, needs&nbsp;review |                                                    |
| [heading-order](https://dequeuniversity.com/rules/axe/4.10/heading-order?application=RuleDescription)                                             | Ensure the order of headings is semantically correct                                                                                          | Moderate | cat.semantics, best-practice               | failure, needs&nbsp;review |                                                    |
| [image-redundant-alt](https://dequeuniversity.com/rules/axe/4.10/image-redundant-alt?application=RuleDescription)                                 | Ensure image alternative is not repeated as text                                                                                              | Minor    | cat.text-alternatives, best-practice       | failure                    |                                                    |
| [label-title-only](https://dequeuniversity.com/rules/axe/4.10/label-title-only?application=RuleDescription)                                       | Ensure that every form element has a visible label and is not solely labeled using hidden labels, or the title or aria-describedby attributes | Serious  | cat.forms, best-practice                   | failure                    |                                                    |
| [landmark-banner-is-top-level](https://dequeuniversity.com/rules/axe/4.10/landmark-banner-is-top-level?application=RuleDescription)               | Ensure the banner landmark is at top level                                                                                                    | Moderate | cat.semantics, best-practice               | failure                    |                                                    |
| [landmark-complementary-is-top-level](https://dequeuniversity.com/rules/axe/4.10/landmark-complementary-is-top-level?application=RuleDescription) | Ensure the complementary landmark or aside is at top level                                                                                    | Moderate | cat.semantics, best-practice               | failure                    |                                                    |
| [landmark-contentinfo-is-top-level](https://dequeuniversity.com/rules/axe/4.10/landmark-contentinfo-is-top-level?application=RuleDescription)     | Ensure the contentinfo landmark is at top level                                                                                               | Moderate | cat.semantics, best-practice               | failure                    |                                                    |
| [landmark-main-is-top-level](https://dequeuniversity.com/rules/axe/4.10/landmark-main-is-top-level?application=RuleDescription)                   | Ensure the main landmark is at top level                                                                                                      | Moderate | cat.semantics, best-practice               | failure                    |                                                    |
| [landmark-no-duplicate-banner](https://dequeuniversity.com/rules/axe/4.10/landmark-no-duplicate-banner?application=RuleDescription)               | Ensure the document has at most one banner landmark                                                                                           | Moderate | cat.semantics, best-practice               | failure                    |                                                    |
| [landmark-no-duplicate-contentinfo](https://dequeuniversity.com/rules/axe/4.10/landmark-no-duplicate-contentinfo?application=RuleDescription)     | Ensure the document has at most one contentinfo landmark                                                                                      | Moderate | cat.semantics, best-practice               | failure                    |                                                    |
| [landmark-no-duplicate-main](https://dequeuniversity.com/rules/axe/4.10/landmark-no-duplicate-main?application=RuleDescription)                   | Ensure the document has at most one main landmark                                                                                             | Moderate | cat.semantics, best-practice               | failure                    |                                                    |
| [landmark-one-main](https://dequeuniversity.com/rules/axe/4.10/landmark-one-main?application=RuleDescription)                                     | Ensure the document has a main landmark                                                                                                       | Moderate | cat.semantics, best-practice               | failure                    |                                                    |
| [landmark-unique](https://dequeuniversity.com/rules/axe/4.10/landmark-unique?application=RuleDescription)                                         | Ensure landmarks are unique                                                                                                                   | Moderate | cat.semantics, best-practice               | failure                    |                                                    |
| [meta-viewport-large](https://dequeuniversity.com/rules/axe/4.10/meta-viewport-large?application=RuleDescription)                                 | Ensure &lt;meta name=&quot;viewport&quot;&gt; can scale a significant amount                                                                  | Minor    | cat.sensory-and-visual-cues, best-practice | failure                    |                                                    |
| [page-has-heading-one](https://dequeuniversity.com/rules/axe/4.10/page-has-heading-one?application=RuleDescription)                               | Ensure that the page, or at least one of its frames contains a level-one heading                                                              | Moderate | cat.semantics, best-practice               | failure                    |                                                    |
| [presentation-role-conflict](https://dequeuniversity.com/rules/axe/4.10/presentation-role-conflict?application=RuleDescription)                   | Elements marked as presentational should not have global ARIA or tabindex to ensure all screen readers ignore them                            | Minor    | cat.aria, best-practice, ACT               | failure                    | [46ca7f](https://act-rules.github.io/rules/46ca7f) |
| [region](https://dequeuniversity.com/rules/axe/4.10/region?application=RuleDescription)                                                           | Ensure all page content is contained by landmarks                                                                                             | Moderate | cat.keyboard, best-practice                | failure                    |                                                    |
| [scope-attr-valid](https://dequeuniversity.com/rules/axe/4.10/scope-attr-valid?application=RuleDescription)                                       | Ensure the scope attribute is used correctly on tables                                                                                        | Moderate | cat.tables, best-practice                  | failure                    |                                                    |
| [skip-link](https://dequeuniversity.com/rules/axe/4.10/skip-link?application=RuleDescription)                                                     | Ensure all skip links have a focusable target                                                                                                 | Moderate | cat.keyboard, best-practice                | failure, needs&nbsp;review |                                                    |
| [tabindex](https://dequeuniversity.com/rules/axe/4.10/tabindex?application=RuleDescription)                                                       | Ensure tabindex attribute values are not greater than 0                                                                                       | Serious  | cat.keyboard, best-practice                | failure                    |                                                    |
| [table-duplicate-name](https://dequeuniversity.com/rules/axe/4.10/table-duplicate-name?application=RuleDescription)                               | Ensure the &lt;caption&gt; element does not contain the same text as the summary attribute                                                    | Minor    | cat.tables, best-practice                  | failure, needs&nbsp;review |                                                    |

## WCAG 2.x level AAA rules

Rules that check for conformance to WCAG AAA success criteria that can be fully automated. These are disabled by default in axe-core.

| Rule ID                                                                                                                             | Description                                                                                                      | Impact  | Tags                                           | Issue Type                 | ACT Rules                                          |
| :---------------------------------------------------------------------------------------------------------------------------------- | :--------------------------------------------------------------------------------------------------------------- | :------ | :--------------------------------------------- | :------------------------- | :------------------------------------------------- |
| [color-contrast-enhanced](https://dequeuniversity.com/rules/axe/4.10/color-contrast-enhanced?application=RuleDescription)           | Ensure the contrast between foreground and background colors meets WCAG 2 AAA enhanced contrast ratio thresholds | Serious | cat.color, wcag2aaa, wcag146, ACT              | failure, needs&nbsp;review | [09o5cg](https://act-rules.github.io/rules/09o5cg) |
| [identical-links-same-purpose](https://dequeuniversity.com/rules/axe/4.10/identical-links-same-purpose?application=RuleDescription) | Ensure that links with the same accessible name serve a similar purpose                                          | Minor   | cat.semantics, wcag2aaa, wcag249               | needs&nbsp;review          | [b20e66](https://act-rules.github.io/rules/b20e66) |
| [meta-refresh-no-exceptions](https://dequeuniversity.com/rules/axe/4.10/meta-refresh-no-exceptions?application=RuleDescription)     | Ensure &lt;meta http-equiv=&quot;refresh&quot;&gt; is not used for delayed refresh                               | Minor   | cat.time-and-media, wcag2aaa, wcag224, wcag325 | failure                    | [bisz58](https://act-rules.github.io/rules/bisz58) |

## Experimental Rules

Rules we are still testing and developing. They are disabled by default in axe-core, but are enabled for the axe browser extensions.

| Rule ID                                                                                                                           | Description                                                                                                               | Impact   | Tags                                                                                                         | Issue Type                 | ACT Rules                                          |
| :-------------------------------------------------------------------------------------------------------------------------------- | :------------------------------------------------------------------------------------------------------------------------ | :------- | :----------------------------------------------------------------------------------------------------------- | :------------------------- | :------------------------------------------------- |
| [css-orientation-lock](https://dequeuniversity.com/rules/axe/4.10/css-orientation-lock?application=RuleDescription)               | Ensure content is not locked to any specific display orientation, and the content is operable in all display orientations | Serious  | cat.structure, wcag134, wcag21aa, EN-301-549, EN-9.1.3.4, experimental                                       | failure, needs&nbsp;review | [b33eff](https://act-rules.github.io/rules/b33eff) |
| [focus-order-semantics](https://dequeuniversity.com/rules/axe/4.10/focus-order-semantics?application=RuleDescription)             | Ensure elements in the focus order have a role appropriate for interactive content                                        | Minor    | cat.keyboard, best-practice, experimental                                                                    | failure                    |                                                    |
| [hidden-content](https://dequeuniversity.com/rules/axe/4.10/hidden-content?application=RuleDescription)                           | Informs users about hidden content.                                                                                       | Minor    | cat.structure, best-practice, experimental, review-item                                                      | failure, needs&nbsp;review |                                                    |
| [label-content-name-mismatch](https://dequeuniversity.com/rules/axe/4.10/label-content-name-mismatch?application=RuleDescription) | Ensure that elements labelled through their content must have their visible text as part of their accessible name         | Serious  | cat.semantics, wcag21a, wcag253, EN-301-549, EN-9.2.5.3, experimental                                        | failure                    | [2ee8b8](https://act-rules.github.io/rules/2ee8b8) |
| [p-as-heading](https://dequeuniversity.com/rules/axe/4.10/p-as-heading?application=RuleDescription)                               | Ensure bold, italic text and font-size is not used to style &lt;p&gt; elements as a heading                               | Serious  | cat.semantics, wcag2a, wcag131, EN-301-549, EN-9.1.3.1, experimental                                         | failure, needs&nbsp;review |                                                    |
| [table-fake-caption](https://dequeuniversity.com/rules/axe/4.10/table-fake-caption?application=RuleDescription)                   | Ensure that tables with a caption use the &lt;caption&gt; element.                                                        | Serious  | cat.tables, experimental, wcag2a, wcag131, section508, section508.22.g, EN-301-549, EN-9.1.3.1               | failure                    |                                                    |
| [td-has-header](https://dequeuniversity.com/rules/axe/4.10/td-has-header?application=RuleDescription)                             | Ensure that each non-empty data cell in a &lt;table&gt; larger than 3 by 3 has one or more table headers                  | Critical | cat.tables, experimental, wcag2a, wcag131, section508, section508.22.g, TTv5, TT14.b, EN-301-549, EN-9.1.3.1 | failure                    |                                                    |

## Deprecated Rules

Deprecated rules are disabled by default and will be removed in the next major release.

| Rule ID                                                                                                             | Description                                                                            | Impact   | Tags                                                                                                 | Issue Type                 | ACT Rules                                                                                              |
| :------------------------------------------------------------------------------------------------------------------ | :------------------------------------------------------------------------------------- | :------- | :--------------------------------------------------------------------------------------------------- | :------------------------- | :----------------------------------------------------------------------------------------------------- |
| [aria-roledescription](https://dequeuniversity.com/rules/axe/4.10/aria-roledescription?application=RuleDescription) | Ensure aria-roledescription is only used on elements with an implicit or explicit role | Serious  | cat.aria, wcag2a, wcag412, EN-301-549, EN-9.4.1.2, deprecated                                        | failure, needs&nbsp;review |                                                                                                        |
| [audio-caption](https://dequeuniversity.com/rules/axe/4.10/audio-caption?application=RuleDescription)               | Ensure &lt;audio&gt; elements have captions                                            | Critical | cat.time-and-media, wcag2a, wcag121, EN-301-549, EN-9.1.2.1, section508, section508.22.a, deprecated | needs&nbsp;review          | [2eb176](https://act-rules.github.io/rules/2eb176), [afb423](https://act-rules.github.io/rules/afb423) |
| [duplicate-id-active](https://dequeuniversity.com/rules/axe/4.10/duplicate-id-active?application=RuleDescription)   | Ensure every id attribute value of active elements is unique                           | Serious  | cat.parsing, wcag2a-obsolete, wcag411, deprecated                                                    | failure                    | [3ea0c8](https://act-rules.github.io/rules/3ea0c8)                                                     |
| [duplicate-id](https://dequeuniversity.com/rules/axe/4.10/duplicate-id?application=RuleDescription)                 | Ensure every id attribute value is unique                                              | Minor    | cat.parsing, wcag2a-obsolete, wcag411, deprecated                                                    | failure                    | [3ea0c8](https://act-rules.github.io/rules/3ea0c8)                                                     |
