// Code generated by go generate; DO NOT EDIT.
// This file was generated by robots.

package dask

import (
	"encoding/json"
	"fmt"
	"reflect"
	"strings"
	"testing"

	"github.com/mitchellh/mapstructure"
	"github.com/stretchr/testify/assert"
)

var dereferencableKindsConfig = map[reflect.Kind]struct{}{
	reflect.Array: {}, reflect.Chan: {}, reflect.Map: {}, reflect.Ptr: {}, reflect.Slice: {},
}

// Checks if t is a kind that can be dereferenced to get its underlying type.
func canGetElementConfig(t reflect.Kind) bool {
	_, exists := dereferencableKindsConfig[t]
	return exists
}

// This decoder hook tests types for json unmarshaling capability. If implemented, it uses json unmarshal to build the
// object. Otherwise, it'll just pass on the original data.
func jsonUnmarshalerHookConfig(_, to reflect.Type, data interface{}) (interface{}, error) {
	unmarshalerType := reflect.TypeOf((*json.Unmarshaler)(nil)).Elem()
	if to.Implements(unmarshalerType) || reflect.PtrTo(to).Implements(unmarshalerType) ||
		(canGetElementConfig(to.Kind()) && to.Elem().Implements(unmarshalerType)) {

		raw, err := json.Marshal(data)
		if err != nil {
			fmt.Printf("Failed to marshal Data: %v. Error: %v. Skipping jsonUnmarshalHook", data, err)
			return data, nil
		}

		res := reflect.New(to).Interface()
		err = json.Unmarshal(raw, &res)
		if err != nil {
			fmt.Printf("Failed to umarshal Data: %v. Error: %v. Skipping jsonUnmarshalHook", data, err)
			return data, nil
		}

		return res, nil
	}

	return data, nil
}

func decode_Config(input, result interface{}) error {
	config := &mapstructure.DecoderConfig{
		TagName:          "json",
		WeaklyTypedInput: true,
		Result:           result,
		DecodeHook: mapstructure.ComposeDecodeHookFunc(
			mapstructure.StringToTimeDurationHookFunc(),
			mapstructure.StringToSliceHookFunc(","),
			jsonUnmarshalerHookConfig,
		),
	}

	decoder, err := mapstructure.NewDecoder(config)
	if err != nil {
		return err
	}

	return decoder.Decode(input)
}

func join_Config(arr interface{}, sep string) string {
	listValue := reflect.ValueOf(arr)
	strs := make([]string, 0, listValue.Len())
	for i := 0; i < listValue.Len(); i++ {
		strs = append(strs, fmt.Sprintf("%v", listValue.Index(i)))
	}

	return strings.Join(strs, sep)
}

func testDecodeJson_Config(t *testing.T, val, result interface{}) {
	assert.NoError(t, decode_Config(val, result))
}

func testDecodeRaw_Config(t *testing.T, vStringSlice, result interface{}) {
	assert.NoError(t, decode_Config(vStringSlice, result))
}

func TestConfig_GetPFlagSet(t *testing.T) {
	val := Config{}
	cmdFlags := val.GetPFlagSet("")
	assert.True(t, cmdFlags.HasFlags())
}

func TestConfig_SetFlags(t *testing.T) {
	actual := Config{}
	cmdFlags := actual.GetPFlagSet("")
	assert.True(t, cmdFlags.HasFlags())

	t.Run("Test_logs.cloudwatch-enabled", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.cloudwatch-enabled", testValue)
			if vBool, err := cmdFlags.GetBool("logs.cloudwatch-enabled"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vBool), &actual.Logs.IsCloudwatchEnabled)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.cloudwatch-region", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.cloudwatch-region", testValue)
			if vString, err := cmdFlags.GetString("logs.cloudwatch-region"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.Logs.CloudwatchRegion)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.cloudwatch-log-group", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.cloudwatch-log-group", testValue)
			if vString, err := cmdFlags.GetString("logs.cloudwatch-log-group"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.Logs.CloudwatchLogGroup)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.cloudwatch-template-uri", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.cloudwatch-template-uri", testValue)
			if vString, err := cmdFlags.GetString("logs.cloudwatch-template-uri"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.Logs.CloudwatchTemplateURI)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.kubernetes-enabled", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.kubernetes-enabled", testValue)
			if vBool, err := cmdFlags.GetBool("logs.kubernetes-enabled"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vBool), &actual.Logs.IsKubernetesEnabled)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.kubernetes-url", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.kubernetes-url", testValue)
			if vString, err := cmdFlags.GetString("logs.kubernetes-url"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.Logs.KubernetesURL)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.kubernetes-template-uri", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.kubernetes-template-uri", testValue)
			if vString, err := cmdFlags.GetString("logs.kubernetes-template-uri"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.Logs.KubernetesTemplateURI)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.stackdriver-enabled", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.stackdriver-enabled", testValue)
			if vBool, err := cmdFlags.GetBool("logs.stackdriver-enabled"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vBool), &actual.Logs.IsStackDriverEnabled)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.gcp-project", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.gcp-project", testValue)
			if vString, err := cmdFlags.GetString("logs.gcp-project"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.Logs.GCPProjectName)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.stackdriver-logresourcename", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.stackdriver-logresourcename", testValue)
			if vString, err := cmdFlags.GetString("logs.stackdriver-logresourcename"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.Logs.StackdriverLogResourceName)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_logs.stackdriver-template-uri", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("logs.stackdriver-template-uri", testValue)
			if vString, err := cmdFlags.GetString("logs.stackdriver-template-uri"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.Logs.StackDriverTemplateURI)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
}
