// Code generated by go generate; DO NOT EDIT.
// This file was generated by robots.

package admin

import (
	"encoding/json"
	"fmt"
	"reflect"
	"strings"
	"testing"

	"github.com/mitchellh/mapstructure"
	"github.com/stretchr/testify/assert"
)

var dereferencableKindsConfig = map[reflect.Kind]struct{}{
	reflect.Array: {}, reflect.Chan: {}, reflect.Map: {}, reflect.Ptr: {}, reflect.Slice: {},
}

// Checks if t is a kind that can be dereferenced to get its underlying type.
func canGetElementConfig(t reflect.Kind) bool {
	_, exists := dereferencableKindsConfig[t]
	return exists
}

// This decoder hook tests types for json unmarshaling capability. If implemented, it uses json unmarshal to build the
// object. Otherwise, it'll just pass on the original data.
func jsonUnmarshalerHookConfig(_, to reflect.Type, data interface{}) (interface{}, error) {
	unmarshalerType := reflect.TypeOf((*json.Unmarshaler)(nil)).Elem()
	if to.Implements(unmarshalerType) || reflect.PtrTo(to).Implements(unmarshalerType) ||
		(canGetElementConfig(to.Kind()) && to.Elem().Implements(unmarshalerType)) {

		raw, err := json.Marshal(data)
		if err != nil {
			fmt.Printf("Failed to marshal Data: %v. Error: %v. Skipping jsonUnmarshalHook", data, err)
			return data, nil
		}

		res := reflect.New(to).Interface()
		err = json.Unmarshal(raw, &res)
		if err != nil {
			fmt.Printf("Failed to umarshal Data: %v. Error: %v. Skipping jsonUnmarshalHook", data, err)
			return data, nil
		}

		return res, nil
	}

	return data, nil
}

func decode_Config(input, result interface{}) error {
	config := &mapstructure.DecoderConfig{
		TagName:          "json",
		WeaklyTypedInput: true,
		Result:           result,
		DecodeHook: mapstructure.ComposeDecodeHookFunc(
			mapstructure.StringToTimeDurationHookFunc(),
			mapstructure.StringToSliceHookFunc(","),
			jsonUnmarshalerHookConfig,
		),
	}

	decoder, err := mapstructure.NewDecoder(config)
	if err != nil {
		return err
	}

	return decoder.Decode(input)
}

func join_Config(arr interface{}, sep string) string {
	listValue := reflect.ValueOf(arr)
	strs := make([]string, 0, listValue.Len())
	for i := 0; i < listValue.Len(); i++ {
		strs = append(strs, fmt.Sprintf("%v", listValue.Index(i)))
	}

	return strings.Join(strs, sep)
}

func testDecodeJson_Config(t *testing.T, val, result interface{}) {
	assert.NoError(t, decode_Config(val, result))
}

func testDecodeRaw_Config(t *testing.T, vStringSlice, result interface{}) {
	assert.NoError(t, decode_Config(vStringSlice, result))
}

func TestConfig_GetPFlagSet(t *testing.T) {
	val := Config{}
	cmdFlags := val.GetPFlagSet("")
	assert.True(t, cmdFlags.HasFlags())
}

func TestConfig_SetFlags(t *testing.T) {
	actual := Config{}
	cmdFlags := actual.GetPFlagSet("")
	assert.True(t, cmdFlags.HasFlags())

	t.Run("Test_endpoint", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := defaultConfig.Endpoint.String()

			cmdFlags.Set("endpoint", testValue)
			if vString, err := cmdFlags.GetString("endpoint"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.Endpoint)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_insecure", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("insecure", testValue)
			if vBool, err := cmdFlags.GetBool("insecure"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vBool), &actual.UseInsecureConnection)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_insecureSkipVerify", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("insecureSkipVerify", testValue)
			if vBool, err := cmdFlags.GetBool("insecureSkipVerify"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vBool), &actual.InsecureSkipVerify)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_caCertFilePath", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("caCertFilePath", testValue)
			if vString, err := cmdFlags.GetString("caCertFilePath"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.CACertFilePath)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_maxBackoffDelay", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := defaultConfig.MaxBackoffDelay.String()

			cmdFlags.Set("maxBackoffDelay", testValue)
			if vString, err := cmdFlags.GetString("maxBackoffDelay"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.MaxBackoffDelay)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_perRetryTimeout", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := defaultConfig.PerRetryTimeout.String()

			cmdFlags.Set("perRetryTimeout", testValue)
			if vString, err := cmdFlags.GetString("perRetryTimeout"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.PerRetryTimeout)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_maxRetries", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("maxRetries", testValue)
			if vInt, err := cmdFlags.GetInt("maxRetries"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vInt), &actual.MaxRetries)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_maxMessageSizeBytes", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("maxMessageSizeBytes", testValue)
			if vInt, err := cmdFlags.GetInt("maxMessageSizeBytes"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vInt), &actual.MaxMessageSizeBytes)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_authType", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("authType", testValue)
			if vString, err := cmdFlags.GetString("authType"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.AuthType)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_tokenRefreshWindow", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := defaultConfig.TokenRefreshWindow.String()

			cmdFlags.Set("tokenRefreshWindow", testValue)
			if vString, err := cmdFlags.GetString("tokenRefreshWindow"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.TokenRefreshWindow)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_useAuth", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("useAuth", testValue)
			if vBool, err := cmdFlags.GetBool("useAuth"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vBool), &actual.DeprecatedUseAuth)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_clientId", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("clientId", testValue)
			if vString, err := cmdFlags.GetString("clientId"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.ClientID)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_clientSecretLocation", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("clientSecretLocation", testValue)
			if vString, err := cmdFlags.GetString("clientSecretLocation"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.ClientSecretLocation)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_clientSecretEnvVar", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("clientSecretEnvVar", testValue)
			if vString, err := cmdFlags.GetString("clientSecretEnvVar"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.ClientSecretEnvVar)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_scopes", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := join_Config(defaultConfig.Scopes, ",")

			cmdFlags.Set("scopes", testValue)
			if vStringSlice, err := cmdFlags.GetStringSlice("scopes"); err == nil {
				testDecodeRaw_Config(t, join_Config(vStringSlice, ","), &actual.Scopes)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_useAudienceFromAdmin", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("useAudienceFromAdmin", testValue)
			if vBool, err := cmdFlags.GetBool("useAudienceFromAdmin"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vBool), &actual.UseAudienceFromAdmin)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_audience", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("audience", testValue)
			if vString, err := cmdFlags.GetString("audience"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.Audience)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_authorizationServerUrl", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("authorizationServerUrl", testValue)
			if vString, err := cmdFlags.GetString("authorizationServerUrl"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.DeprecatedAuthorizationServerURL)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_tokenUrl", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("tokenUrl", testValue)
			if vString, err := cmdFlags.GetString("tokenUrl"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.TokenURL)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_authorizationHeader", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("authorizationHeader", testValue)
			if vString, err := cmdFlags.GetString("authorizationHeader"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.AuthorizationHeader)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_pkceConfig.timeout", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := defaultConfig.PkceConfig.BrowserSessionTimeout.String()

			cmdFlags.Set("pkceConfig.timeout", testValue)
			if vString, err := cmdFlags.GetString("pkceConfig.timeout"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.PkceConfig.BrowserSessionTimeout)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_pkceConfig.refreshTime", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := defaultConfig.PkceConfig.TokenRefreshGracePeriod.String()

			cmdFlags.Set("pkceConfig.refreshTime", testValue)
			if vString, err := cmdFlags.GetString("pkceConfig.refreshTime"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.PkceConfig.TokenRefreshGracePeriod)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_deviceFlowConfig.refreshTime", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := defaultConfig.DeviceFlowConfig.TokenRefreshGracePeriod.String()

			cmdFlags.Set("deviceFlowConfig.refreshTime", testValue)
			if vString, err := cmdFlags.GetString("deviceFlowConfig.refreshTime"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.DeviceFlowConfig.TokenRefreshGracePeriod)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_deviceFlowConfig.timeout", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := defaultConfig.DeviceFlowConfig.Timeout.String()

			cmdFlags.Set("deviceFlowConfig.timeout", testValue)
			if vString, err := cmdFlags.GetString("deviceFlowConfig.timeout"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.DeviceFlowConfig.Timeout)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_deviceFlowConfig.pollInterval", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := defaultConfig.DeviceFlowConfig.PollInterval.String()

			cmdFlags.Set("deviceFlowConfig.pollInterval", testValue)
			if vString, err := cmdFlags.GetString("deviceFlowConfig.pollInterval"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.DeviceFlowConfig.PollInterval)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_command", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := join_Config(defaultConfig.Command, ",")

			cmdFlags.Set("command", testValue)
			if vStringSlice, err := cmdFlags.GetStringSlice("command"); err == nil {
				testDecodeRaw_Config(t, join_Config(vStringSlice, ","), &actual.Command)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_proxyCommand", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := join_Config(defaultConfig.ProxyCommand, ",")

			cmdFlags.Set("proxyCommand", testValue)
			if vStringSlice, err := cmdFlags.GetStringSlice("proxyCommand"); err == nil {
				testDecodeRaw_Config(t, join_Config(vStringSlice, ","), &actual.ProxyCommand)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_defaultServiceConfig", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("defaultServiceConfig", testValue)
			if vString, err := cmdFlags.GetString("defaultServiceConfig"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.DefaultServiceConfig)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_httpProxyURL", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := defaultConfig.HTTPProxyURL.String()

			cmdFlags.Set("httpProxyURL", testValue)
			if vString, err := cmdFlags.GetString("httpProxyURL"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.HTTPProxyURL)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
}
