/*******************************************************************************
 * Copyright (c) 2017 Kiel University and others.
 * 
 * This program and the accompanying materials are made 
 * available under the terms of the Eclipse Public License 2.0 
 * which is available at https://www.eclipse.org/legal/epl-2.0/ 
 * 
 * SPDX-License-Identifier: EPL-2.0
 *******************************************************************************/
const chai = require("chai");
const chaiAsPromised = require("chai-as-promised");
chai.use(chaiAsPromised);
chai.should();

const ELK = require('../../lib/main.js')
const elk = new ELK()

describe('elkjs#7', function() {
  describe('#layout()', function() {

    it('should not raise an error', function() {
      return elk.layout(graph)
        .should.eventually.be.fulfilled
    })

  })
})

const graph = {
  "id":"root",
  "children":[
     {
        "id":"57da8b44fffd97e2179faa24",
        "width":174,
        "height":80,
        "ports":[
           {
              "id":"57da8b44fffd97e2179faa24_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da8b5efffd97e2179fb9d9",
        "width":232,
        "height":80
     },
     {
        "id":"57da7b5dfffd97e2179e06df",
        "width":165,
        "height":80,
        "ports":[
           {
              "id":"57da7b5dfffd97e2179e06df_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           },
           {
              "id":"57da7b5dfffd97e2179e06df_1",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"1"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da78b9fffd97e2179de456",
        "width":165,
        "height":80,
        "ports":[
           {
              "id":"57da78b9fffd97e2179de456_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           },
           {
              "id":"57da78b9fffd97e2179de456_1",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"1"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da7725fffd97e2179dda52",
        "width":232,
        "height":80,
        "ports":[
           {
              "id":"57da7725fffd97e2179dda52_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da80bcfffd97e2179ecfcc",
        "width":165,
        "height":80,
        "ports":[
           {
              "id":"57da80bcfffd97e2179ecfcc_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           },
           {
              "id":"57da80bcfffd97e2179ecfcc_1",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"1"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da7be7fffd97e2179e1aab",
        "width":174,
        "height":80,
        "ports":[
           {
              "id":"57da7be7fffd97e2179e1aab_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da7a5efffd97e2179dfcc3",
        "width":174,
        "height":80,
        "ports":[
           {
              "id":"57da7a5efffd97e2179dfcc3_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da75fdfffd97e2179dd20a",
        "width":232,
        "height":80
     },
     {
        "id":"57da8b77fffd97e2179fc13f",
        "width":188,
        "height":80,
        "ports":[
           {
              "id":"57da8b77fffd97e2179fc13f_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           },
           {
              "id":"57da8b77fffd97e2179fc13f_1",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"1"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"581b09ebfffd970e5c907418",
        "width":292,
        "height":80,
        "ports":[
           {
              "id":"581b09ebfffd970e5c907418_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da8a27fffd97e2179f4546",
        "width":194,
        "height":80,
        "ports":[
           {
              "id":"57da8a27fffd97e2179f4546_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da79b5fffd97e2179dedc6",
        "width":165,
        "height":80,
        "ports":[
           {
              "id":"57da79b5fffd97e2179dedc6_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           },
           {
              "id":"57da79b5fffd97e2179dedc6_1",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"1"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da87fbfffd97e2179ef368",
        "width":174,
        "height":80,
        "ports":[
           {
              "id":"57da87fbfffd97e2179ef368_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da7827fffd97e2179ddf9a",
        "width":294,
        "height":80,
        "ports":[
           {
              "id":"57da7827fffd97e2179ddf9a_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da79f7fffd97e2179df786",
        "width":167,
        "height":80,
        "ports":[
           {
              "id":"57da79f7fffd97e2179df786_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da7babfffd97e2179e1374",
        "width":167,
        "height":80,
        "ports":[
           {
              "id":"57da7babfffd97e2179e1374_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da7920fffd97e2179de7aa",
        "width":254,
        "height":80,
        "ports":[
           {
              "id":"57da7920fffd97e2179de7aa_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da7aa8fffd97e2179e001f",
        "width":246,
        "height":80,
        "ports":[
           {
              "id":"57da7aa8fffd97e2179e001f_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da8aacfffd97e2179f53be",
        "width":165,
        "height":80,
        "ports":[
           {
              "id":"57da8aacfffd97e2179f53be_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           },
           {
              "id":"57da8aacfffd97e2179f53be_1",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"1"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da8bcafffd97e2179ffd5e",
        "width":174,
        "height":80,
        "ports":[
           {
              "id":"57da8bcafffd97e2179ffd5e_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da7f59fffd97e2179ebf83",
        "width":233,
        "height":80,
        "ports":[
           {
              "id":"57da7f59fffd97e2179ebf83_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da7634fffd97e2179dd89a",
        "width":187,
        "height":80,
        "ports":[
           {
              "id":"57da7634fffd97e2179dd89a_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"581b0995fffd970e5c9061d9",
        "width":313,
        "height":80,
        "ports":[
           {
              "id":"581b0995fffd970e5c9061d9_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da8115fffd97e2179eea72",
        "width":167,
        "height":80,
        "ports":[
           {
              "id":"57da8115fffd97e2179eea72_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da8b03fffd97e2179f6a93",
        "width":167,
        "height":80,
        "ports":[
           {
              "id":"57da8b03fffd97e2179f6a93_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da9b1ffffd97e217a2b164",
        "width":168,
        "height":80,
        "ports":[
           {
              "id":"57da9b1ffffd97e217a2b164_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da7776fffd97e2179ddbce",
        "width":273,
        "height":80,
        "ports":[
           {
              "id":"57da7776fffd97e2179ddbce_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     },
     {
        "id":"57da9b3ffffd97e217a2c5b0",
        "width":463,
        "height":80,
        "ports":[
           {
              "id":"57da9b3ffffd97e217a2c5b0_0",
              "width":18,
              "height":18,
              "properties":{
                 "port.side":"NORTH",
                 "port.index":"0"
              }
           }
        ],
        "properties":{
           "portConstraints":"FIXED_ORDER"
        }
     }
  ],
  "edges":[
     {
        "id":"57da8b44fffd97e2179faa24:57da8b77fffd97e2179fc13f",
        "sources":[
           "57da8b44fffd97e2179faa24"
        ],
        "targets":[
           "57da8b77fffd97e2179fc13f_0"
        ]
     },
     {
        "id":"57da8b5efffd97e2179fb9d9:57da8b77fffd97e2179fc13f",
        "sources":[
           "57da8b5efffd97e2179fb9d9"
        ],
        "targets":[
           "57da8b77fffd97e2179fc13f_1"
        ]
     },
     {
        "id":"57da7b5dfffd97e2179e06df:57da7babfffd97e2179e1374",
        "sources":[
           "57da7b5dfffd97e2179e06df"
        ],
        "targets":[
           "57da7babfffd97e2179e1374_0"
        ]
     },
     {
        "id":"57da78b9fffd97e2179de456:57da79b5fffd97e2179dedc6",
        "sources":[
           "57da78b9fffd97e2179de456"
        ],
        "targets":[
           "57da79b5fffd97e2179dedc6_0"
        ]
     },
     {
        "id":"57da7725fffd97e2179dda52:57da7776fffd97e2179ddbce",
        "sources":[
           "57da7725fffd97e2179dda52"
        ],
        "targets":[
           "57da7776fffd97e2179ddbce_0"
        ]
     },
     {
        "id":"57da80bcfffd97e2179ecfcc:57da8115fffd97e2179eea72",
        "sources":[
           "57da80bcfffd97e2179ecfcc"
        ],
        "targets":[
           "57da8115fffd97e2179eea72_0"
        ]
     },
     {
        "id":"57da7be7fffd97e2179e1aab:57da80bcfffd97e2179ecfcc",
        "sources":[
           "57da7be7fffd97e2179e1aab"
        ],
        "targets":[
           "57da80bcfffd97e2179ecfcc_0"
        ]
     },
     {
        "id":"57da7a5efffd97e2179dfcc3:57da7b5dfffd97e2179e06df",
        "sources":[
           "57da7a5efffd97e2179dfcc3"
        ],
        "targets":[
           "57da7b5dfffd97e2179e06df_0"
        ]
     },
     {
        "id":"57da75fdfffd97e2179dd20a:57da7634fffd97e2179dd89a",
        "sources":[
           "57da75fdfffd97e2179dd20a"
        ],
        "targets":[
           "57da7634fffd97e2179dd89a_0"
        ]
     },
     {
        "id":"57da75fdfffd97e2179dd20a:57da7725fffd97e2179dda52",
        "sources":[
           "57da75fdfffd97e2179dd20a"
        ],
        "targets":[
           "57da7725fffd97e2179dda52_0"
        ]
     },
     {
        "id":"57da75fdfffd97e2179dd20a:57da7920fffd97e2179de7aa",
        "sources":[
           "57da75fdfffd97e2179dd20a"
        ],
        "targets":[
           "57da7920fffd97e2179de7aa_0"
        ]
     },
     {
        "id":"57da75fdfffd97e2179dd20a:57da7aa8fffd97e2179e001f",
        "sources":[
           "57da75fdfffd97e2179dd20a"
        ],
        "targets":[
           "57da7aa8fffd97e2179e001f_0"
        ]
     },
     {
        "id":"57da75fdfffd97e2179dd20a:57da7f59fffd97e2179ebf83",
        "sources":[
           "57da75fdfffd97e2179dd20a"
        ],
        "targets":[
           "57da7f59fffd97e2179ebf83_0"
        ]
     },
     {
        "id":"57da75fdfffd97e2179dd20a:57da8a27fffd97e2179f4546",
        "sources":[
           "57da75fdfffd97e2179dd20a"
        ],
        "targets":[
           "57da8a27fffd97e2179f4546_0"
        ]
     },
     {
        "id":"57da8b77fffd97e2179fc13f:57da8bcafffd97e2179ffd5e",
        "sources":[
           "57da8b77fffd97e2179fc13f"
        ],
        "targets":[
           "57da8bcafffd97e2179ffd5e_0"
        ]
     },
     {
        "id":"581b09ebfffd970e5c907418:581b0995fffd970e5c9061d9",
        "sources":[
           "581b09ebfffd970e5c907418"
        ],
        "targets":[
           "581b0995fffd970e5c9061d9_0"
        ]
     },
     {
        "id":"57da8a27fffd97e2179f4546:57da8aacfffd97e2179f53be",
        "sources":[
           "57da8a27fffd97e2179f4546"
        ],
        "targets":[
           "57da8aacfffd97e2179f53be_1"
        ]
     },
     {
        "id":"57da79b5fffd97e2179dedc6:57da79f7fffd97e2179df786",
        "sources":[
           "57da79b5fffd97e2179dedc6"
        ],
        "targets":[
           "57da79f7fffd97e2179df786_0"
        ]
     },
     {
        "id":"57da87fbfffd97e2179ef368:57da8aacfffd97e2179f53be",
        "sources":[
           "57da87fbfffd97e2179ef368"
        ],
        "targets":[
           "57da8aacfffd97e2179f53be_0"
        ]
     },
     {
        "id":"57da7827fffd97e2179ddf9a:57da78b9fffd97e2179de456",
        "sources":[
           "57da7827fffd97e2179ddf9a"
        ],
        "targets":[
           "57da78b9fffd97e2179de456_1"
        ]
     },
     {
        "id":"57da79f7fffd97e2179df786:57da7a5efffd97e2179dfcc3",
        "sources":[
           "57da79f7fffd97e2179df786"
        ],
        "targets":[
           "57da7a5efffd97e2179dfcc3_0"
        ]
     },
     {
        "id":"57da7babfffd97e2179e1374:57da7be7fffd97e2179e1aab",
        "sources":[
           "57da7babfffd97e2179e1374"
        ],
        "targets":[
           "57da7be7fffd97e2179e1aab_0"
        ]
     },
     {
        "id":"57da7920fffd97e2179de7aa:57da79b5fffd97e2179dedc6",
        "sources":[
           "57da7920fffd97e2179de7aa"
        ],
        "targets":[
           "57da79b5fffd97e2179dedc6_1"
        ]
     },
     {
        "id":"57da7aa8fffd97e2179e001f:57da7b5dfffd97e2179e06df",
        "sources":[
           "57da7aa8fffd97e2179e001f"
        ],
        "targets":[
           "57da7b5dfffd97e2179e06df_1"
        ]
     },
     {
        "id":"57da8aacfffd97e2179f53be:57da8b03fffd97e2179f6a93",
        "sources":[
           "57da8aacfffd97e2179f53be"
        ],
        "targets":[
           "57da8b03fffd97e2179f6a93_0"
        ]
     },
     {
        "id":"57da8bcafffd97e2179ffd5e:57da9b1ffffd97e217a2b164",
        "sources":[
           "57da8bcafffd97e2179ffd5e"
        ],
        "targets":[
           "57da9b1ffffd97e217a2b164_0"
        ]
     },
     {
        "id":"57da8bcafffd97e2179ffd5e:57da9b3ffffd97e217a2c5b0",
        "sources":[
           "57da8bcafffd97e2179ffd5e"
        ],
        "targets":[
           "57da9b3ffffd97e217a2c5b0_0"
        ]
     },
     {
        "id":"57da8bcafffd97e2179ffd5e:581b09ebfffd970e5c907418",
        "sources":[
           "57da8bcafffd97e2179ffd5e"
        ],
        "targets":[
           "581b09ebfffd970e5c907418_0"
        ]
     },
     {
        "id":"57da7f59fffd97e2179ebf83:57da80bcfffd97e2179ecfcc",
        "sources":[
           "57da7f59fffd97e2179ebf83"
        ],
        "targets":[
           "57da80bcfffd97e2179ecfcc_1"
        ]
     },
     {
        "id":"57da7634fffd97e2179dd89a:57da78b9fffd97e2179de456",
        "sources":[
           "57da7634fffd97e2179dd89a"
        ],
        "targets":[
           "57da78b9fffd97e2179de456_0"
        ]
     },
     {
        "id":"57da8115fffd97e2179eea72:57da87fbfffd97e2179ef368",
        "sources":[
           "57da8115fffd97e2179eea72"
        ],
        "targets":[
           "57da87fbfffd97e2179ef368_0"
        ]
     },
     {
        "id":"57da8b03fffd97e2179f6a93:57da8b44fffd97e2179faa24",
        "sources":[
           "57da8b03fffd97e2179f6a93"
        ],
        "targets":[
           "57da8b44fffd97e2179faa24_0"
        ]
     },
     {
        "id":"57da7776fffd97e2179ddbce:57da7827fffd97e2179ddf9a",
        "sources":[
           "57da7776fffd97e2179ddbce"
        ],
        "targets":[
           "57da7827fffd97e2179ddf9a_0"
        ]
     }
  ],
  "properties":{
     "elk.algorithm":"layered"
  }
}