// Code generated by go generate; DO NOT EDIT.
// This file was generated by robots.

package config

import (
	"encoding/json"
	"fmt"
	"reflect"
	"strings"
	"testing"

	"github.com/mitchellh/mapstructure"
	"github.com/stretchr/testify/assert"
)

var dereferencableKindsConfig = map[reflect.Kind]struct{}{
	reflect.Array: {}, reflect.Chan: {}, reflect.Map: {}, reflect.Ptr: {}, reflect.Slice: {},
}

// Checks if t is a kind that can be dereferenced to get its underlying type.
func canGetElementConfig(t reflect.Kind) bool {
	_, exists := dereferencableKindsConfig[t]
	return exists
}

// This decoder hook tests types for json unmarshaling capability. If implemented, it uses json unmarshal to build the
// object. Otherwise, it'll just pass on the original data.
func jsonUnmarshalerHookConfig(_, to reflect.Type, data interface{}) (interface{}, error) {
	unmarshalerType := reflect.TypeOf((*json.Unmarshaler)(nil)).Elem()
	if to.Implements(unmarshalerType) || reflect.PtrTo(to).Implements(unmarshalerType) ||
		(canGetElementConfig(to.Kind()) && to.Elem().Implements(unmarshalerType)) {

		raw, err := json.Marshal(data)
		if err != nil {
			fmt.Printf("Failed to marshal Data: %v. Error: %v. Skipping jsonUnmarshalHook", data, err)
			return data, nil
		}

		res := reflect.New(to).Interface()
		err = json.Unmarshal(raw, &res)
		if err != nil {
			fmt.Printf("Failed to umarshal Data: %v. Error: %v. Skipping jsonUnmarshalHook", data, err)
			return data, nil
		}

		return res, nil
	}

	return data, nil
}

func decode_Config(input, result interface{}) error {
	config := &mapstructure.DecoderConfig{
		TagName:          "json",
		WeaklyTypedInput: true,
		Result:           result,
		DecodeHook: mapstructure.ComposeDecodeHookFunc(
			mapstructure.StringToTimeDurationHookFunc(),
			mapstructure.StringToSliceHookFunc(","),
			jsonUnmarshalerHookConfig,
		),
	}

	decoder, err := mapstructure.NewDecoder(config)
	if err != nil {
		return err
	}

	return decoder.Decode(input)
}

func join_Config(arr interface{}, sep string) string {
	listValue := reflect.ValueOf(arr)
	strs := make([]string, 0, listValue.Len())
	for i := 0; i < listValue.Len(); i++ {
		strs = append(strs, fmt.Sprintf("%v", listValue.Index(i)))
	}

	return strings.Join(strs, sep)
}

func testDecodeJson_Config(t *testing.T, val, result interface{}) {
	assert.NoError(t, decode_Config(val, result))
}

func testDecodeRaw_Config(t *testing.T, vStringSlice, result interface{}) {
	assert.NoError(t, decode_Config(vStringSlice, result))
}

func TestConfig_GetPFlagSet(t *testing.T) {
	val := Config{}
	cmdFlags := val.GetPFlagSet("")
	assert.True(t, cmdFlags.HasFlags())
}

func TestConfig_SetFlags(t *testing.T) {
	actual := Config{}
	cmdFlags := actual.GetPFlagSet("")
	assert.True(t, cmdFlags.HasFlags())

	t.Run("Test_environment", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := defaultConfig.Environment.String()

			cmdFlags.Set("environment", testValue)
			if vString, err := cmdFlags.GetString("environment"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.Environment)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_defaultRoutingGroup", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("defaultRoutingGroup", testValue)
			if vString, err := cmdFlags.GetString("defaultRoutingGroup"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.DefaultRoutingGroup)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_defaultUser", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("defaultUser", testValue)
			if vString, err := cmdFlags.GetString("defaultUser"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.DefaultUser)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_useNamespaceAsUser", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("useNamespaceAsUser", testValue)
			if vBool, err := cmdFlags.GetBool("useNamespaceAsUser"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vBool), &actual.UseNamespaceAsUser)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_refreshCacheConfig.name", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("refreshCacheConfig.name", testValue)
			if vString, err := cmdFlags.GetString("refreshCacheConfig.name"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.RefreshCacheConfig.Name)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_refreshCacheConfig.syncPeriod", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := defaultConfig.RefreshCacheConfig.SyncPeriod.String()

			cmdFlags.Set("refreshCacheConfig.syncPeriod", testValue)
			if vString, err := cmdFlags.GetString("refreshCacheConfig.syncPeriod"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vString), &actual.RefreshCacheConfig.SyncPeriod)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_refreshCacheConfig.workers", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("refreshCacheConfig.workers", testValue)
			if vInt, err := cmdFlags.GetInt("refreshCacheConfig.workers"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vInt), &actual.RefreshCacheConfig.Workers)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_refreshCacheConfig.lruCacheSize", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("refreshCacheConfig.lruCacheSize", testValue)
			if vInt, err := cmdFlags.GetInt("refreshCacheConfig.lruCacheSize"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vInt), &actual.RefreshCacheConfig.LruCacheSize)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_readRateLimiterConfig.rate", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("readRateLimiterConfig.rate", testValue)
			if vInt64, err := cmdFlags.GetInt64("readRateLimiterConfig.rate"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vInt64), &actual.ReadRateLimiterConfig.Rate)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_readRateLimiterConfig.burst", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("readRateLimiterConfig.burst", testValue)
			if vInt, err := cmdFlags.GetInt("readRateLimiterConfig.burst"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vInt), &actual.ReadRateLimiterConfig.Burst)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_writeRateLimiterConfig.rate", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("writeRateLimiterConfig.rate", testValue)
			if vInt64, err := cmdFlags.GetInt64("writeRateLimiterConfig.rate"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vInt64), &actual.WriteRateLimiterConfig.Rate)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
	t.Run("Test_writeRateLimiterConfig.burst", func(t *testing.T) {

		t.Run("Override", func(t *testing.T) {
			testValue := "1"

			cmdFlags.Set("writeRateLimiterConfig.burst", testValue)
			if vInt, err := cmdFlags.GetInt("writeRateLimiterConfig.burst"); err == nil {
				testDecodeJson_Config(t, fmt.Sprintf("%v", vInt), &actual.WriteRateLimiterConfig.Burst)

			} else {
				assert.FailNow(t, err.Error())
			}
		})
	})
}
