// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        (unknown)
// source: flyteidl/admin/execution.proto

package admin

import (
	core "github.com/flyteorg/flyte/flyteidl/gen/pb-go/flyteidl/core"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The state of the execution is used to control its visibility in the UI/CLI.
type ExecutionState int32

const (
	// By default, all executions are considered active.
	ExecutionState_EXECUTION_ACTIVE ExecutionState = 0
	// Archived executions are no longer visible in the UI.
	ExecutionState_EXECUTION_ARCHIVED ExecutionState = 1
)

// Enum value maps for ExecutionState.
var (
	ExecutionState_name = map[int32]string{
		0: "EXECUTION_ACTIVE",
		1: "EXECUTION_ARCHIVED",
	}
	ExecutionState_value = map[string]int32{
		"EXECUTION_ACTIVE":   0,
		"EXECUTION_ARCHIVED": 1,
	}
)

func (x ExecutionState) Enum() *ExecutionState {
	p := new(ExecutionState)
	*p = x
	return p
}

func (x ExecutionState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecutionState) Descriptor() protoreflect.EnumDescriptor {
	return file_flyteidl_admin_execution_proto_enumTypes[0].Descriptor()
}

func (ExecutionState) Type() protoreflect.EnumType {
	return &file_flyteidl_admin_execution_proto_enumTypes[0]
}

func (x ExecutionState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecutionState.Descriptor instead.
func (ExecutionState) EnumDescriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{0}
}

// The method by which this execution was launched.
type ExecutionMetadata_ExecutionMode int32

const (
	// The default execution mode, MANUAL implies that an execution was launched by an individual.
	ExecutionMetadata_MANUAL ExecutionMetadata_ExecutionMode = 0
	// A schedule triggered this execution launch.
	ExecutionMetadata_SCHEDULED ExecutionMetadata_ExecutionMode = 1
	// A system process was responsible for launching this execution rather an individual.
	ExecutionMetadata_SYSTEM ExecutionMetadata_ExecutionMode = 2
	// This execution was launched with identical inputs as a previous execution.
	ExecutionMetadata_RELAUNCH ExecutionMetadata_ExecutionMode = 3
	// This execution was triggered by another execution.
	ExecutionMetadata_CHILD_WORKFLOW ExecutionMetadata_ExecutionMode = 4
	// This execution was recovered from another execution.
	ExecutionMetadata_RECOVERED ExecutionMetadata_ExecutionMode = 5
	// Execution was kicked off by the artifact trigger system
	ExecutionMetadata_TRIGGER ExecutionMetadata_ExecutionMode = 6
)

// Enum value maps for ExecutionMetadata_ExecutionMode.
var (
	ExecutionMetadata_ExecutionMode_name = map[int32]string{
		0: "MANUAL",
		1: "SCHEDULED",
		2: "SYSTEM",
		3: "RELAUNCH",
		4: "CHILD_WORKFLOW",
		5: "RECOVERED",
		6: "TRIGGER",
	}
	ExecutionMetadata_ExecutionMode_value = map[string]int32{
		"MANUAL":         0,
		"SCHEDULED":      1,
		"SYSTEM":         2,
		"RELAUNCH":       3,
		"CHILD_WORKFLOW": 4,
		"RECOVERED":      5,
		"TRIGGER":        6,
	}
)

func (x ExecutionMetadata_ExecutionMode) Enum() *ExecutionMetadata_ExecutionMode {
	p := new(ExecutionMetadata_ExecutionMode)
	*p = x
	return p
}

func (x ExecutionMetadata_ExecutionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecutionMetadata_ExecutionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_flyteidl_admin_execution_proto_enumTypes[1].Descriptor()
}

func (ExecutionMetadata_ExecutionMode) Type() protoreflect.EnumType {
	return &file_flyteidl_admin_execution_proto_enumTypes[1]
}

func (x ExecutionMetadata_ExecutionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecutionMetadata_ExecutionMode.Descriptor instead.
func (ExecutionMetadata_ExecutionMode) EnumDescriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{11, 0}
}

// Request to launch an execution with the given project, domain and optionally-assigned name.
type ExecutionCreateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the project the execution belongs to.
	// +required
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
	// Name of the domain the execution belongs to.
	// A domain can be considered as a subset within a specific project.
	// +required
	Domain string `protobuf:"bytes,2,opt,name=domain,proto3" json:"domain,omitempty"`
	// User provided value for the resource.
	// If none is provided the system will generate a unique string.
	// +optional
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Additional fields necessary to launch the execution.
	// +optional
	Spec *ExecutionSpec `protobuf:"bytes,4,opt,name=spec,proto3" json:"spec,omitempty"`
	// The inputs required to start the execution. All required inputs must be
	// included in this map. If not required and not provided, defaults apply.
	// +optional
	Inputs *core.LiteralMap `protobuf:"bytes,5,opt,name=inputs,proto3" json:"inputs,omitempty"`
	// Optional, org key applied to the resource.
	Org string `protobuf:"bytes,6,opt,name=org,proto3" json:"org,omitempty"`
}

func (x *ExecutionCreateRequest) Reset() {
	*x = ExecutionCreateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionCreateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionCreateRequest) ProtoMessage() {}

func (x *ExecutionCreateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionCreateRequest.ProtoReflect.Descriptor instead.
func (*ExecutionCreateRequest) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{0}
}

func (x *ExecutionCreateRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *ExecutionCreateRequest) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

func (x *ExecutionCreateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExecutionCreateRequest) GetSpec() *ExecutionSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

func (x *ExecutionCreateRequest) GetInputs() *core.LiteralMap {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *ExecutionCreateRequest) GetOrg() string {
	if x != nil {
		return x.Org
	}
	return ""
}

// Request to relaunch the referenced execution.
type ExecutionRelaunchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier of the workflow execution to relaunch.
	// +required
	Id *core.WorkflowExecutionIdentifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// User provided value for the relaunched execution.
	// If none is provided the system will generate a unique string.
	// +optional
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Allows for all cached values of a workflow and its tasks to be overwritten for a single execution.
	// If enabled, all calculations are performed even if cached results would be available, overwriting the stored
	// data once execution finishes successfully.
	OverwriteCache bool `protobuf:"varint,4,opt,name=overwrite_cache,json=overwriteCache,proto3" json:"overwrite_cache,omitempty"`
}

func (x *ExecutionRelaunchRequest) Reset() {
	*x = ExecutionRelaunchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionRelaunchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionRelaunchRequest) ProtoMessage() {}

func (x *ExecutionRelaunchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionRelaunchRequest.ProtoReflect.Descriptor instead.
func (*ExecutionRelaunchRequest) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{1}
}

func (x *ExecutionRelaunchRequest) GetId() *core.WorkflowExecutionIdentifier {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *ExecutionRelaunchRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExecutionRelaunchRequest) GetOverwriteCache() bool {
	if x != nil {
		return x.OverwriteCache
	}
	return false
}

// Request to recover the referenced execution.
type ExecutionRecoverRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier of the workflow execution to recover.
	Id *core.WorkflowExecutionIdentifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// User provided value for the recovered execution.
	// If none is provided the system will generate a unique string.
	// +optional
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Additional metadata which will be used to overwrite any metadata in the reference execution when triggering a recovery execution.
	Metadata *ExecutionMetadata `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *ExecutionRecoverRequest) Reset() {
	*x = ExecutionRecoverRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionRecoverRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionRecoverRequest) ProtoMessage() {}

func (x *ExecutionRecoverRequest) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionRecoverRequest.ProtoReflect.Descriptor instead.
func (*ExecutionRecoverRequest) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{2}
}

func (x *ExecutionRecoverRequest) GetId() *core.WorkflowExecutionIdentifier {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *ExecutionRecoverRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExecutionRecoverRequest) GetMetadata() *ExecutionMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// The unique identifier for a successfully created execution.
// If the name was *not* specified in the create request, this identifier will include a generated name.
type ExecutionCreateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id *core.WorkflowExecutionIdentifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *ExecutionCreateResponse) Reset() {
	*x = ExecutionCreateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionCreateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionCreateResponse) ProtoMessage() {}

func (x *ExecutionCreateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionCreateResponse.ProtoReflect.Descriptor instead.
func (*ExecutionCreateResponse) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{3}
}

func (x *ExecutionCreateResponse) GetId() *core.WorkflowExecutionIdentifier {
	if x != nil {
		return x.Id
	}
	return nil
}

// A message used to fetch a single workflow execution entity.
// See :ref:`ref_flyteidl.admin.Execution` for more details
type WorkflowExecutionGetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Uniquely identifies an individual workflow execution.
	Id *core.WorkflowExecutionIdentifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *WorkflowExecutionGetRequest) Reset() {
	*x = WorkflowExecutionGetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkflowExecutionGetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkflowExecutionGetRequest) ProtoMessage() {}

func (x *WorkflowExecutionGetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkflowExecutionGetRequest.ProtoReflect.Descriptor instead.
func (*WorkflowExecutionGetRequest) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{4}
}

func (x *WorkflowExecutionGetRequest) GetId() *core.WorkflowExecutionIdentifier {
	if x != nil {
		return x.Id
	}
	return nil
}

// A workflow execution represents an instantiated workflow, including all inputs and additional
// metadata as well as computed results included state, outputs, and duration-based attributes.
// Used as a response object used in Get and List execution requests.
type Execution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique identifier of the workflow execution.
	Id *core.WorkflowExecutionIdentifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// User-provided configuration and inputs for launching the execution.
	Spec *ExecutionSpec `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	// Execution results.
	Closure *ExecutionClosure `protobuf:"bytes,3,opt,name=closure,proto3" json:"closure,omitempty"`
}

func (x *Execution) Reset() {
	*x = Execution{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Execution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Execution) ProtoMessage() {}

func (x *Execution) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Execution.ProtoReflect.Descriptor instead.
func (*Execution) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{5}
}

func (x *Execution) GetId() *core.WorkflowExecutionIdentifier {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *Execution) GetSpec() *ExecutionSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

func (x *Execution) GetClosure() *ExecutionClosure {
	if x != nil {
		return x.Closure
	}
	return nil
}

// Used as a response for request to list executions.
// See :ref:`ref_flyteidl.admin.Execution` for more details
type ExecutionList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Executions []*Execution `protobuf:"bytes,1,rep,name=executions,proto3" json:"executions,omitempty"`
	// In the case of multiple pages of results, the server-provided token can be used to fetch the next page
	// in a query. If there are no more results, this value will be empty.
	Token string `protobuf:"bytes,2,opt,name=token,proto3" json:"token,omitempty"`
}

func (x *ExecutionList) Reset() {
	*x = ExecutionList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionList) ProtoMessage() {}

func (x *ExecutionList) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionList.ProtoReflect.Descriptor instead.
func (*ExecutionList) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{6}
}

func (x *ExecutionList) GetExecutions() []*Execution {
	if x != nil {
		return x.Executions
	}
	return nil
}

func (x *ExecutionList) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

// Input/output data can represented by actual values or a link to where values are stored
type LiteralMapBlob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Data:
	//
	//	*LiteralMapBlob_Values
	//	*LiteralMapBlob_Uri
	Data isLiteralMapBlob_Data `protobuf_oneof:"data"`
}

func (x *LiteralMapBlob) Reset() {
	*x = LiteralMapBlob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LiteralMapBlob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LiteralMapBlob) ProtoMessage() {}

func (x *LiteralMapBlob) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LiteralMapBlob.ProtoReflect.Descriptor instead.
func (*LiteralMapBlob) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{7}
}

func (m *LiteralMapBlob) GetData() isLiteralMapBlob_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

// Deprecated: Marked as deprecated in flyteidl/admin/execution.proto.
func (x *LiteralMapBlob) GetValues() *core.LiteralMap {
	if x, ok := x.GetData().(*LiteralMapBlob_Values); ok {
		return x.Values
	}
	return nil
}

func (x *LiteralMapBlob) GetUri() string {
	if x, ok := x.GetData().(*LiteralMapBlob_Uri); ok {
		return x.Uri
	}
	return ""
}

type isLiteralMapBlob_Data interface {
	isLiteralMapBlob_Data()
}

type LiteralMapBlob_Values struct {
	// Data in LiteralMap format
	//
	// Deprecated: Marked as deprecated in flyteidl/admin/execution.proto.
	Values *core.LiteralMap `protobuf:"bytes,1,opt,name=values,proto3,oneof"`
}

type LiteralMapBlob_Uri struct {
	// In the event that the map is too large, we return a uri to the data
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3,oneof"`
}

func (*LiteralMapBlob_Values) isLiteralMapBlob_Data() {}

func (*LiteralMapBlob_Uri) isLiteralMapBlob_Data() {}

// Specifies metadata around an aborted workflow execution.
type AbortMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// In the case of a user-specified abort, this will pass along the user-supplied cause.
	Cause string `protobuf:"bytes,1,opt,name=cause,proto3" json:"cause,omitempty"`
	// Identifies the entity (if any) responsible for terminating the execution
	Principal string `protobuf:"bytes,2,opt,name=principal,proto3" json:"principal,omitempty"`
}

func (x *AbortMetadata) Reset() {
	*x = AbortMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AbortMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AbortMetadata) ProtoMessage() {}

func (x *AbortMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AbortMetadata.ProtoReflect.Descriptor instead.
func (*AbortMetadata) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{8}
}

func (x *AbortMetadata) GetCause() string {
	if x != nil {
		return x.Cause
	}
	return ""
}

func (x *AbortMetadata) GetPrincipal() string {
	if x != nil {
		return x.Principal
	}
	return ""
}

// Encapsulates the results of the Execution
type ExecutionClosure struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A result produced by a terminated execution.
	// A pending (non-terminal) execution will not have any output result.
	//
	// Types that are assignable to OutputResult:
	//
	//	*ExecutionClosure_Outputs
	//	*ExecutionClosure_Error
	//	*ExecutionClosure_AbortCause
	//	*ExecutionClosure_AbortMetadata
	//	*ExecutionClosure_OutputData
	OutputResult isExecutionClosure_OutputResult `protobuf_oneof:"output_result"`
	// Inputs computed and passed for execution.
	// computed_inputs depends on inputs in ExecutionSpec, fixed and default inputs in launch plan
	//
	// Deprecated: Marked as deprecated in flyteidl/admin/execution.proto.
	ComputedInputs *core.LiteralMap `protobuf:"bytes,3,opt,name=computed_inputs,json=computedInputs,proto3" json:"computed_inputs,omitempty"`
	// Most recent recorded phase for the execution.
	Phase core.WorkflowExecution_Phase `protobuf:"varint,4,opt,name=phase,proto3,enum=flyteidl.core.WorkflowExecution_Phase" json:"phase,omitempty"`
	// Reported time at which the execution began running.
	StartedAt *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=started_at,json=startedAt,proto3" json:"started_at,omitempty"`
	// The amount of time the execution spent running.
	Duration *durationpb.Duration `protobuf:"bytes,6,opt,name=duration,proto3" json:"duration,omitempty"`
	// Reported time at which the execution was created.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Reported time at which the execution was last updated.
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// The notification settings to use after merging the CreateExecutionRequest and the launch plan
	// notification settings. An execution launched with notifications will always prefer that definition
	// to notifications defined statically in a launch plan.
	Notifications []*Notification `protobuf:"bytes,9,rep,name=notifications,proto3" json:"notifications,omitempty"`
	// Identifies the workflow definition for this execution.
	WorkflowId *core.Identifier `protobuf:"bytes,11,opt,name=workflow_id,json=workflowId,proto3" json:"workflow_id,omitempty"`
	// Provides the details of the last stage change
	StateChangeDetails *ExecutionStateChangeDetails `protobuf:"bytes,14,opt,name=state_change_details,json=stateChangeDetails,proto3" json:"state_change_details,omitempty"`
}

func (x *ExecutionClosure) Reset() {
	*x = ExecutionClosure{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionClosure) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionClosure) ProtoMessage() {}

func (x *ExecutionClosure) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionClosure.ProtoReflect.Descriptor instead.
func (*ExecutionClosure) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{9}
}

func (m *ExecutionClosure) GetOutputResult() isExecutionClosure_OutputResult {
	if m != nil {
		return m.OutputResult
	}
	return nil
}

// Deprecated: Marked as deprecated in flyteidl/admin/execution.proto.
func (x *ExecutionClosure) GetOutputs() *LiteralMapBlob {
	if x, ok := x.GetOutputResult().(*ExecutionClosure_Outputs); ok {
		return x.Outputs
	}
	return nil
}

func (x *ExecutionClosure) GetError() *core.ExecutionError {
	if x, ok := x.GetOutputResult().(*ExecutionClosure_Error); ok {
		return x.Error
	}
	return nil
}

// Deprecated: Marked as deprecated in flyteidl/admin/execution.proto.
func (x *ExecutionClosure) GetAbortCause() string {
	if x, ok := x.GetOutputResult().(*ExecutionClosure_AbortCause); ok {
		return x.AbortCause
	}
	return ""
}

func (x *ExecutionClosure) GetAbortMetadata() *AbortMetadata {
	if x, ok := x.GetOutputResult().(*ExecutionClosure_AbortMetadata); ok {
		return x.AbortMetadata
	}
	return nil
}

// Deprecated: Marked as deprecated in flyteidl/admin/execution.proto.
func (x *ExecutionClosure) GetOutputData() *core.LiteralMap {
	if x, ok := x.GetOutputResult().(*ExecutionClosure_OutputData); ok {
		return x.OutputData
	}
	return nil
}

// Deprecated: Marked as deprecated in flyteidl/admin/execution.proto.
func (x *ExecutionClosure) GetComputedInputs() *core.LiteralMap {
	if x != nil {
		return x.ComputedInputs
	}
	return nil
}

func (x *ExecutionClosure) GetPhase() core.WorkflowExecution_Phase {
	if x != nil {
		return x.Phase
	}
	return core.WorkflowExecution_Phase(0)
}

func (x *ExecutionClosure) GetStartedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.StartedAt
	}
	return nil
}

func (x *ExecutionClosure) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *ExecutionClosure) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *ExecutionClosure) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

func (x *ExecutionClosure) GetNotifications() []*Notification {
	if x != nil {
		return x.Notifications
	}
	return nil
}

func (x *ExecutionClosure) GetWorkflowId() *core.Identifier {
	if x != nil {
		return x.WorkflowId
	}
	return nil
}

func (x *ExecutionClosure) GetStateChangeDetails() *ExecutionStateChangeDetails {
	if x != nil {
		return x.StateChangeDetails
	}
	return nil
}

type isExecutionClosure_OutputResult interface {
	isExecutionClosure_OutputResult()
}

type ExecutionClosure_Outputs struct {
	// Output URI in the case of a successful execution.
	// DEPRECATED. Use GetExecutionData to fetch output data instead.
	//
	// Deprecated: Marked as deprecated in flyteidl/admin/execution.proto.
	Outputs *LiteralMapBlob `protobuf:"bytes,1,opt,name=outputs,proto3,oneof"`
}

type ExecutionClosure_Error struct {
	// Error information in the case of a failed execution.
	Error *core.ExecutionError `protobuf:"bytes,2,opt,name=error,proto3,oneof"`
}

type ExecutionClosure_AbortCause struct {
	// In the case of a user-specified abort, this will pass along the user-supplied cause.
	//
	// Deprecated: Marked as deprecated in flyteidl/admin/execution.proto.
	AbortCause string `protobuf:"bytes,10,opt,name=abort_cause,json=abortCause,proto3,oneof"`
}

type ExecutionClosure_AbortMetadata struct {
	// In the case of a user-specified abort, this will pass along the user and their supplied cause.
	AbortMetadata *AbortMetadata `protobuf:"bytes,12,opt,name=abort_metadata,json=abortMetadata,proto3,oneof"`
}

type ExecutionClosure_OutputData struct {
	// Raw output data produced by this execution.
	// DEPRECATED. Use GetExecutionData to fetch output data instead.
	//
	// Deprecated: Marked as deprecated in flyteidl/admin/execution.proto.
	OutputData *core.LiteralMap `protobuf:"bytes,13,opt,name=output_data,json=outputData,proto3,oneof"`
}

func (*ExecutionClosure_Outputs) isExecutionClosure_OutputResult() {}

func (*ExecutionClosure_Error) isExecutionClosure_OutputResult() {}

func (*ExecutionClosure_AbortCause) isExecutionClosure_OutputResult() {}

func (*ExecutionClosure_AbortMetadata) isExecutionClosure_OutputResult() {}

func (*ExecutionClosure_OutputData) isExecutionClosure_OutputResult() {}

// Represents system, rather than user-facing, metadata about an execution.
type SystemMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Which execution cluster this execution ran on.
	ExecutionCluster string `protobuf:"bytes,1,opt,name=execution_cluster,json=executionCluster,proto3" json:"execution_cluster,omitempty"`
	// Which kubernetes namespace the execution ran under.
	Namespace string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
}

func (x *SystemMetadata) Reset() {
	*x = SystemMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SystemMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SystemMetadata) ProtoMessage() {}

func (x *SystemMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SystemMetadata.ProtoReflect.Descriptor instead.
func (*SystemMetadata) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{10}
}

func (x *SystemMetadata) GetExecutionCluster() string {
	if x != nil {
		return x.ExecutionCluster
	}
	return ""
}

func (x *SystemMetadata) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

// Represents attributes about an execution which are not required to launch the execution but are useful to record.
// These attributes are assigned at launch time and do not change.
type ExecutionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Mode ExecutionMetadata_ExecutionMode `protobuf:"varint,1,opt,name=mode,proto3,enum=flyteidl.admin.ExecutionMetadata_ExecutionMode" json:"mode,omitempty"`
	// Identifier of the entity that triggered this execution.
	// For systems using back-end authentication any value set here will be discarded in favor of the
	// authenticated user context.
	Principal string `protobuf:"bytes,2,opt,name=principal,proto3" json:"principal,omitempty"`
	// Indicates the nestedness of this execution.
	// If a user launches a workflow execution, the default nesting is 0.
	// If this execution further launches a workflow (child workflow), the nesting level is incremented by 0 => 1
	// Generally, if workflow at nesting level k launches a workflow then the child workflow will have
	// nesting = k + 1.
	Nesting uint32 `protobuf:"varint,3,opt,name=nesting,proto3" json:"nesting,omitempty"`
	// For scheduled executions, the requested time for execution for this specific schedule invocation.
	ScheduledAt *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=scheduled_at,json=scheduledAt,proto3" json:"scheduled_at,omitempty"`
	// Which subworkflow node (if any) launched this execution
	ParentNodeExecution *core.NodeExecutionIdentifier `protobuf:"bytes,5,opt,name=parent_node_execution,json=parentNodeExecution,proto3" json:"parent_node_execution,omitempty"`
	// Optional, a reference workflow execution related to this execution.
	// In the case of a relaunch, this references the original workflow execution.
	ReferenceExecution *core.WorkflowExecutionIdentifier `protobuf:"bytes,16,opt,name=reference_execution,json=referenceExecution,proto3" json:"reference_execution,omitempty"`
	// Optional, platform-specific metadata about the execution.
	// In this the future this may be gated behind an ACL or some sort of authorization.
	SystemMetadata *SystemMetadata `protobuf:"bytes,17,opt,name=system_metadata,json=systemMetadata,proto3" json:"system_metadata,omitempty"`
	// Save a list of the artifacts used in this execution for now. This is a list only rather than a mapping
	// since we don't have a structure to handle nested ones anyways.
	ArtifactIds []*core.ArtifactID `protobuf:"bytes,18,rep,name=artifact_ids,json=artifactIds,proto3" json:"artifact_ids,omitempty"`
}

func (x *ExecutionMetadata) Reset() {
	*x = ExecutionMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionMetadata) ProtoMessage() {}

func (x *ExecutionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionMetadata.ProtoReflect.Descriptor instead.
func (*ExecutionMetadata) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{11}
}

func (x *ExecutionMetadata) GetMode() ExecutionMetadata_ExecutionMode {
	if x != nil {
		return x.Mode
	}
	return ExecutionMetadata_MANUAL
}

func (x *ExecutionMetadata) GetPrincipal() string {
	if x != nil {
		return x.Principal
	}
	return ""
}

func (x *ExecutionMetadata) GetNesting() uint32 {
	if x != nil {
		return x.Nesting
	}
	return 0
}

func (x *ExecutionMetadata) GetScheduledAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ScheduledAt
	}
	return nil
}

func (x *ExecutionMetadata) GetParentNodeExecution() *core.NodeExecutionIdentifier {
	if x != nil {
		return x.ParentNodeExecution
	}
	return nil
}

func (x *ExecutionMetadata) GetReferenceExecution() *core.WorkflowExecutionIdentifier {
	if x != nil {
		return x.ReferenceExecution
	}
	return nil
}

func (x *ExecutionMetadata) GetSystemMetadata() *SystemMetadata {
	if x != nil {
		return x.SystemMetadata
	}
	return nil
}

func (x *ExecutionMetadata) GetArtifactIds() []*core.ArtifactID {
	if x != nil {
		return x.ArtifactIds
	}
	return nil
}

type NotificationList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Notifications []*Notification `protobuf:"bytes,1,rep,name=notifications,proto3" json:"notifications,omitempty"`
}

func (x *NotificationList) Reset() {
	*x = NotificationList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NotificationList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NotificationList) ProtoMessage() {}

func (x *NotificationList) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NotificationList.ProtoReflect.Descriptor instead.
func (*NotificationList) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{12}
}

func (x *NotificationList) GetNotifications() []*Notification {
	if x != nil {
		return x.Notifications
	}
	return nil
}

// An ExecutionSpec encompasses all data used to launch this execution. The Spec does not change over the lifetime
// of an execution as it progresses across phase changes.
type ExecutionSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Launch plan to be executed
	LaunchPlan *core.Identifier `protobuf:"bytes,1,opt,name=launch_plan,json=launchPlan,proto3" json:"launch_plan,omitempty"`
	// Input values to be passed for the execution
	//
	// Deprecated: Marked as deprecated in flyteidl/admin/execution.proto.
	Inputs *core.LiteralMap `protobuf:"bytes,2,opt,name=inputs,proto3" json:"inputs,omitempty"`
	// Metadata for the execution
	Metadata *ExecutionMetadata `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Types that are assignable to NotificationOverrides:
	//
	//	*ExecutionSpec_Notifications
	//	*ExecutionSpec_DisableAll
	NotificationOverrides isExecutionSpec_NotificationOverrides `protobuf_oneof:"notification_overrides"`
	// Labels to apply to the execution resource.
	Labels *Labels `protobuf:"bytes,7,opt,name=labels,proto3" json:"labels,omitempty"`
	// Annotations to apply to the execution resource.
	Annotations *Annotations `protobuf:"bytes,8,opt,name=annotations,proto3" json:"annotations,omitempty"`
	// Optional: security context override to apply this execution.
	SecurityContext *core.SecurityContext `protobuf:"bytes,10,opt,name=security_context,json=securityContext,proto3" json:"security_context,omitempty"`
	// Optional: auth override to apply this execution.
	//
	// Deprecated: Marked as deprecated in flyteidl/admin/execution.proto.
	AuthRole *AuthRole `protobuf:"bytes,16,opt,name=auth_role,json=authRole,proto3" json:"auth_role,omitempty"`
	// Indicates the runtime priority of the execution.
	QualityOfService *core.QualityOfService `protobuf:"bytes,17,opt,name=quality_of_service,json=qualityOfService,proto3" json:"quality_of_service,omitempty"`
	// Controls the maximum number of task nodes that can be run in parallel for the entire workflow.
	// This is useful to achieve fairness. Note: MapTasks are regarded as one unit,
	// and parallelism/concurrency of MapTasks is independent from this.
	MaxParallelism int32 `protobuf:"varint,18,opt,name=max_parallelism,json=maxParallelism,proto3" json:"max_parallelism,omitempty"`
	// User setting to configure where to store offloaded data (i.e. Blobs, structured datasets, query data, etc.).
	// This should be a prefix like s3://my-bucket/my-data
	RawOutputDataConfig *RawOutputDataConfig `protobuf:"bytes,19,opt,name=raw_output_data_config,json=rawOutputDataConfig,proto3" json:"raw_output_data_config,omitempty"`
	// Controls how to select an available cluster on which this execution should run.
	ClusterAssignment *ClusterAssignment `protobuf:"bytes,20,opt,name=cluster_assignment,json=clusterAssignment,proto3" json:"cluster_assignment,omitempty"`
	// Allows for the interruptible flag of a workflow to be overwritten for a single execution.
	// Omitting this field uses the workflow's value as a default.
	// As we need to distinguish between the field not being provided and its default value false, we have to use a wrapper
	// around the bool field.
	Interruptible *wrapperspb.BoolValue `protobuf:"bytes,21,opt,name=interruptible,proto3" json:"interruptible,omitempty"`
	// Allows for all cached values of a workflow and its tasks to be overwritten for a single execution.
	// If enabled, all calculations are performed even if cached results would be available, overwriting the stored
	// data once execution finishes successfully.
	OverwriteCache bool `protobuf:"varint,22,opt,name=overwrite_cache,json=overwriteCache,proto3" json:"overwrite_cache,omitempty"`
	// Environment variables to be set for the execution.
	Envs *Envs `protobuf:"bytes,23,opt,name=envs,proto3" json:"envs,omitempty"`
	// Tags to be set for the execution.
	//
	// Deprecated: Marked as deprecated in flyteidl/admin/execution.proto.
	Tags []string `protobuf:"bytes,24,rep,name=tags,proto3" json:"tags,omitempty"`
	// Execution cluster label to be set for the execution.
	ExecutionClusterLabel *ExecutionClusterLabel `protobuf:"bytes,25,opt,name=execution_cluster_label,json=executionClusterLabel,proto3" json:"execution_cluster_label,omitempty"`
	// Execution environment assignments to be set for the execution.
	ExecutionEnvAssignments []*core.ExecutionEnvAssignment `protobuf:"bytes,26,rep,name=execution_env_assignments,json=executionEnvAssignments,proto3" json:"execution_env_assignments,omitempty"`
}

func (x *ExecutionSpec) Reset() {
	*x = ExecutionSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionSpec) ProtoMessage() {}

func (x *ExecutionSpec) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionSpec.ProtoReflect.Descriptor instead.
func (*ExecutionSpec) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{13}
}

func (x *ExecutionSpec) GetLaunchPlan() *core.Identifier {
	if x != nil {
		return x.LaunchPlan
	}
	return nil
}

// Deprecated: Marked as deprecated in flyteidl/admin/execution.proto.
func (x *ExecutionSpec) GetInputs() *core.LiteralMap {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *ExecutionSpec) GetMetadata() *ExecutionMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (m *ExecutionSpec) GetNotificationOverrides() isExecutionSpec_NotificationOverrides {
	if m != nil {
		return m.NotificationOverrides
	}
	return nil
}

func (x *ExecutionSpec) GetNotifications() *NotificationList {
	if x, ok := x.GetNotificationOverrides().(*ExecutionSpec_Notifications); ok {
		return x.Notifications
	}
	return nil
}

func (x *ExecutionSpec) GetDisableAll() bool {
	if x, ok := x.GetNotificationOverrides().(*ExecutionSpec_DisableAll); ok {
		return x.DisableAll
	}
	return false
}

func (x *ExecutionSpec) GetLabels() *Labels {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ExecutionSpec) GetAnnotations() *Annotations {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *ExecutionSpec) GetSecurityContext() *core.SecurityContext {
	if x != nil {
		return x.SecurityContext
	}
	return nil
}

// Deprecated: Marked as deprecated in flyteidl/admin/execution.proto.
func (x *ExecutionSpec) GetAuthRole() *AuthRole {
	if x != nil {
		return x.AuthRole
	}
	return nil
}

func (x *ExecutionSpec) GetQualityOfService() *core.QualityOfService {
	if x != nil {
		return x.QualityOfService
	}
	return nil
}

func (x *ExecutionSpec) GetMaxParallelism() int32 {
	if x != nil {
		return x.MaxParallelism
	}
	return 0
}

func (x *ExecutionSpec) GetRawOutputDataConfig() *RawOutputDataConfig {
	if x != nil {
		return x.RawOutputDataConfig
	}
	return nil
}

func (x *ExecutionSpec) GetClusterAssignment() *ClusterAssignment {
	if x != nil {
		return x.ClusterAssignment
	}
	return nil
}

func (x *ExecutionSpec) GetInterruptible() *wrapperspb.BoolValue {
	if x != nil {
		return x.Interruptible
	}
	return nil
}

func (x *ExecutionSpec) GetOverwriteCache() bool {
	if x != nil {
		return x.OverwriteCache
	}
	return false
}

func (x *ExecutionSpec) GetEnvs() *Envs {
	if x != nil {
		return x.Envs
	}
	return nil
}

// Deprecated: Marked as deprecated in flyteidl/admin/execution.proto.
func (x *ExecutionSpec) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *ExecutionSpec) GetExecutionClusterLabel() *ExecutionClusterLabel {
	if x != nil {
		return x.ExecutionClusterLabel
	}
	return nil
}

func (x *ExecutionSpec) GetExecutionEnvAssignments() []*core.ExecutionEnvAssignment {
	if x != nil {
		return x.ExecutionEnvAssignments
	}
	return nil
}

type isExecutionSpec_NotificationOverrides interface {
	isExecutionSpec_NotificationOverrides()
}

type ExecutionSpec_Notifications struct {
	// List of notifications based on Execution status transitions
	// When this list is not empty it is used rather than any notifications defined in the referenced launch plan.
	// When this list is empty, the notifications defined for the launch plan will be applied.
	Notifications *NotificationList `protobuf:"bytes,5,opt,name=notifications,proto3,oneof"`
}

type ExecutionSpec_DisableAll struct {
	// This should be set to true if all notifications are intended to be disabled for this execution.
	DisableAll bool `protobuf:"varint,6,opt,name=disable_all,json=disableAll,proto3,oneof"`
}

func (*ExecutionSpec_Notifications) isExecutionSpec_NotificationOverrides() {}

func (*ExecutionSpec_DisableAll) isExecutionSpec_NotificationOverrides() {}

// Request to terminate an in-progress execution.  This action is irreversible.
// If an execution is already terminated, this request will simply be a no-op.
// This request will fail if it references a non-existent execution.
// If the request succeeds the phase "ABORTED" will be recorded for the termination
// with the optional cause added to the output_result.
type ExecutionTerminateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Uniquely identifies the individual workflow execution to be terminated.
	Id *core.WorkflowExecutionIdentifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Optional reason for aborting.
	Cause string `protobuf:"bytes,2,opt,name=cause,proto3" json:"cause,omitempty"`
}

func (x *ExecutionTerminateRequest) Reset() {
	*x = ExecutionTerminateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionTerminateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionTerminateRequest) ProtoMessage() {}

func (x *ExecutionTerminateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionTerminateRequest.ProtoReflect.Descriptor instead.
func (*ExecutionTerminateRequest) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{14}
}

func (x *ExecutionTerminateRequest) GetId() *core.WorkflowExecutionIdentifier {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *ExecutionTerminateRequest) GetCause() string {
	if x != nil {
		return x.Cause
	}
	return ""
}

type ExecutionTerminateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExecutionTerminateResponse) Reset() {
	*x = ExecutionTerminateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionTerminateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionTerminateResponse) ProtoMessage() {}

func (x *ExecutionTerminateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionTerminateResponse.ProtoReflect.Descriptor instead.
func (*ExecutionTerminateResponse) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{15}
}

// Request structure to fetch inputs, output and other data produced by an execution.
// By default this data is not returned inline in :ref:`ref_flyteidl.admin.WorkflowExecutionGetRequest`
type WorkflowExecutionGetDataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifier of the execution for which to fetch inputs and outputs.
	Id *core.WorkflowExecutionIdentifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *WorkflowExecutionGetDataRequest) Reset() {
	*x = WorkflowExecutionGetDataRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkflowExecutionGetDataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkflowExecutionGetDataRequest) ProtoMessage() {}

func (x *WorkflowExecutionGetDataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkflowExecutionGetDataRequest.ProtoReflect.Descriptor instead.
func (*WorkflowExecutionGetDataRequest) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{16}
}

func (x *WorkflowExecutionGetDataRequest) GetId() *core.WorkflowExecutionIdentifier {
	if x != nil {
		return x.Id
	}
	return nil
}

// Response structure for WorkflowExecutionGetDataRequest which contains inputs and outputs for an execution.
type WorkflowExecutionGetDataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Signed url to fetch a core.LiteralMap of execution outputs.
	// Deprecated: Please use full_outputs instead.
	//
	// Deprecated: Marked as deprecated in flyteidl/admin/execution.proto.
	Outputs *UrlBlob `protobuf:"bytes,1,opt,name=outputs,proto3" json:"outputs,omitempty"`
	// Signed url to fetch a core.LiteralMap of execution inputs.
	// Deprecated: Please use full_inputs instead.
	//
	// Deprecated: Marked as deprecated in flyteidl/admin/execution.proto.
	Inputs *UrlBlob `protobuf:"bytes,2,opt,name=inputs,proto3" json:"inputs,omitempty"`
	// Full_inputs will only be populated if they are under a configured size threshold.
	FullInputs *core.LiteralMap `protobuf:"bytes,3,opt,name=full_inputs,json=fullInputs,proto3" json:"full_inputs,omitempty"`
	// Full_outputs will only be populated if they are under a configured size threshold.
	FullOutputs *core.LiteralMap `protobuf:"bytes,4,opt,name=full_outputs,json=fullOutputs,proto3" json:"full_outputs,omitempty"`
}

func (x *WorkflowExecutionGetDataResponse) Reset() {
	*x = WorkflowExecutionGetDataResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkflowExecutionGetDataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkflowExecutionGetDataResponse) ProtoMessage() {}

func (x *WorkflowExecutionGetDataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkflowExecutionGetDataResponse.ProtoReflect.Descriptor instead.
func (*WorkflowExecutionGetDataResponse) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{17}
}

// Deprecated: Marked as deprecated in flyteidl/admin/execution.proto.
func (x *WorkflowExecutionGetDataResponse) GetOutputs() *UrlBlob {
	if x != nil {
		return x.Outputs
	}
	return nil
}

// Deprecated: Marked as deprecated in flyteidl/admin/execution.proto.
func (x *WorkflowExecutionGetDataResponse) GetInputs() *UrlBlob {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *WorkflowExecutionGetDataResponse) GetFullInputs() *core.LiteralMap {
	if x != nil {
		return x.FullInputs
	}
	return nil
}

func (x *WorkflowExecutionGetDataResponse) GetFullOutputs() *core.LiteralMap {
	if x != nil {
		return x.FullOutputs
	}
	return nil
}

type ExecutionUpdateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier of the execution to update
	Id *core.WorkflowExecutionIdentifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// State to set as the new value active/archive
	State ExecutionState `protobuf:"varint,2,opt,name=state,proto3,enum=flyteidl.admin.ExecutionState" json:"state,omitempty"`
}

func (x *ExecutionUpdateRequest) Reset() {
	*x = ExecutionUpdateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionUpdateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionUpdateRequest) ProtoMessage() {}

func (x *ExecutionUpdateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionUpdateRequest.ProtoReflect.Descriptor instead.
func (*ExecutionUpdateRequest) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{18}
}

func (x *ExecutionUpdateRequest) GetId() *core.WorkflowExecutionIdentifier {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *ExecutionUpdateRequest) GetState() ExecutionState {
	if x != nil {
		return x.State
	}
	return ExecutionState_EXECUTION_ACTIVE
}

type ExecutionStateChangeDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of the execution is used to control its visibility in the UI/CLI.
	State ExecutionState `protobuf:"varint,1,opt,name=state,proto3,enum=flyteidl.admin.ExecutionState" json:"state,omitempty"`
	// This timestamp represents when the state changed.
	OccurredAt *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=occurred_at,json=occurredAt,proto3" json:"occurred_at,omitempty"`
	// Identifies the entity (if any) responsible for causing the state change of the execution
	Principal string `protobuf:"bytes,3,opt,name=principal,proto3" json:"principal,omitempty"`
}

func (x *ExecutionStateChangeDetails) Reset() {
	*x = ExecutionStateChangeDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionStateChangeDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionStateChangeDetails) ProtoMessage() {}

func (x *ExecutionStateChangeDetails) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionStateChangeDetails.ProtoReflect.Descriptor instead.
func (*ExecutionStateChangeDetails) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{19}
}

func (x *ExecutionStateChangeDetails) GetState() ExecutionState {
	if x != nil {
		return x.State
	}
	return ExecutionState_EXECUTION_ACTIVE
}

func (x *ExecutionStateChangeDetails) GetOccurredAt() *timestamppb.Timestamp {
	if x != nil {
		return x.OccurredAt
	}
	return nil
}

func (x *ExecutionStateChangeDetails) GetPrincipal() string {
	if x != nil {
		return x.Principal
	}
	return ""
}

type ExecutionUpdateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExecutionUpdateResponse) Reset() {
	*x = ExecutionUpdateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionUpdateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionUpdateResponse) ProtoMessage() {}

func (x *ExecutionUpdateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionUpdateResponse.ProtoReflect.Descriptor instead.
func (*ExecutionUpdateResponse) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{20}
}

// WorkflowExecutionGetMetricsRequest represents a request to retrieve metrics for the specified workflow execution.
type WorkflowExecutionGetMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// id defines the workflow execution to query for.
	Id *core.WorkflowExecutionIdentifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// depth defines the number of Flyte entity levels to traverse when breaking down execution details.
	Depth int32 `protobuf:"varint,2,opt,name=depth,proto3" json:"depth,omitempty"`
}

func (x *WorkflowExecutionGetMetricsRequest) Reset() {
	*x = WorkflowExecutionGetMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkflowExecutionGetMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkflowExecutionGetMetricsRequest) ProtoMessage() {}

func (x *WorkflowExecutionGetMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkflowExecutionGetMetricsRequest.ProtoReflect.Descriptor instead.
func (*WorkflowExecutionGetMetricsRequest) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{21}
}

func (x *WorkflowExecutionGetMetricsRequest) GetId() *core.WorkflowExecutionIdentifier {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *WorkflowExecutionGetMetricsRequest) GetDepth() int32 {
	if x != nil {
		return x.Depth
	}
	return 0
}

// WorkflowExecutionGetMetricsResponse represents the response containing metrics for the specified workflow execution.
type WorkflowExecutionGetMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Span defines the top-level breakdown of the workflows execution. More precise information is nested in a
	// hierarchical structure using Flyte entity references.
	Span *core.Span `protobuf:"bytes,1,opt,name=span,proto3" json:"span,omitempty"`
}

func (x *WorkflowExecutionGetMetricsResponse) Reset() {
	*x = WorkflowExecutionGetMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_flyteidl_admin_execution_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkflowExecutionGetMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkflowExecutionGetMetricsResponse) ProtoMessage() {}

func (x *WorkflowExecutionGetMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_flyteidl_admin_execution_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkflowExecutionGetMetricsResponse.ProtoReflect.Descriptor instead.
func (*WorkflowExecutionGetMetricsResponse) Descriptor() ([]byte, []int) {
	return file_flyteidl_admin_execution_proto_rawDescGZIP(), []int{22}
}

func (x *WorkflowExecutionGetMetricsResponse) GetSpan() *core.Span {
	if x != nil {
		return x.Span
	}
	return nil
}

var File_flyteidl_admin_execution_proto protoreflect.FileDescriptor

var file_flyteidl_admin_execution_proto_rawDesc = []byte{
	0x0a, 0x1e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x0e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x1a, 0x27, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x66, 0x6c, 0x79, 0x74, 0x65,
	0x69, 0x64, 0x6c, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c,
	0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x6c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x63,
	0x6f, 0x72, 0x65, 0x2f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x63, 0x6f,
	0x72, 0x65, 0x2f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x76,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64,
	0x6c, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69,
	0x64, 0x6c, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69,
	0x64, 0x6c, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f,
	0x63, 0x6f, 0x72, 0x65, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd6, 0x01,
	0x0a, 0x16, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x31,
	0x0a, 0x04, 0x73, 0x70, 0x65, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x66,
	0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x04, 0x73, 0x70, 0x65,
	0x63, 0x12, 0x31, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72,
	0x65, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x4d, 0x61, 0x70, 0x52, 0x06, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x6f, 0x72, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6f, 0x72, 0x67, 0x22, 0x99, 0x01, 0x0a, 0x18, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e,
	0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65,
	0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x6f, 0x76,
	0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x4a, 0x04, 0x08, 0x02,
	0x10, 0x03, 0x22, 0xa8, 0x01, 0x0a, 0x17, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x66, 0x6c, 0x79,
	0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66,
	0x6c, 0x6f, 0x77, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3d,
	0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x55, 0x0a,
	0x17, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3a, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e,
	0x63, 0x6f, 0x72, 0x65, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x52, 0x02, 0x69, 0x64, 0x22, 0x59, 0x0a, 0x1b, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e,
	0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x02, 0x69, 0x64, 0x22,
	0xb6, 0x01, 0x0a, 0x09, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x66, 0x6c, 0x79, 0x74,
	0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c,
	0x6f, 0x77, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x02, 0x69, 0x64, 0x12, 0x31, 0x0a, 0x04, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69,
	0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x04, 0x73, 0x70, 0x65, 0x63, 0x12, 0x3a, 0x0a, 0x07,
	0x63, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x52,
	0x07, 0x63, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x22, 0x60, 0x0a, 0x0d, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x65, 0x0a, 0x0e, 0x4c, 0x69,
	0x74, 0x65, 0x72, 0x61, 0x6c, 0x4d, 0x61, 0x70, 0x42, 0x6c, 0x6f, 0x62, 0x12, 0x37, 0x0a, 0x06,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x66,
	0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x4c, 0x69, 0x74,
	0x65, 0x72, 0x61, 0x6c, 0x4d, 0x61, 0x70, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x03, 0x75, 0x72, 0x69, 0x42, 0x06, 0x0a, 0x04, 0x64, 0x61, 0x74,
	0x61, 0x22, 0x43, 0x0a, 0x0d, 0x41, 0x62, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x61, 0x75, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x63, 0x61, 0x75, 0x73, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x72, 0x69, 0x6e,
	0x63, 0x69, 0x70, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x69,
	0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x22, 0x98, 0x07, 0x0a, 0x10, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x12, 0x3e, 0x0a, 0x07, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x66,
	0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x4c, 0x69,
	0x74, 0x65, 0x72, 0x61, 0x6c, 0x4d, 0x61, 0x70, 0x42, 0x6c, 0x6f, 0x62, 0x42, 0x02, 0x18, 0x01,
	0x48, 0x00, 0x52, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x35, 0x0a, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x66, 0x6c, 0x79,
	0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x12, 0x25, 0x0a, 0x0b, 0x61, 0x62, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x61, 0x75, 0x73,
	0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x61,
	0x62, 0x6f, 0x72, 0x74, 0x43, 0x61, 0x75, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x0e, 0x61, 0x62, 0x6f,
	0x72, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1d, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x41, 0x62, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x48, 0x00, 0x52, 0x0d, 0x61, 0x62, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x40, 0x0a, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64,
	0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x4d, 0x61,
	0x70, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x12, 0x46, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x64, 0x5f,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x66,
	0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x4c, 0x69, 0x74,
	0x65, 0x72, 0x61, 0x6c, 0x4d, 0x61, 0x70, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x63, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x64, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x3c, 0x0a, 0x05, 0x70,
	0x68, 0x61, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x66, 0x6c, 0x79,
	0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66,
	0x6c, 0x6f, 0x77, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x68, 0x61,
	0x73, 0x65, 0x52, 0x05, 0x70, 0x68, 0x61, 0x73, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x65, 0x64, 0x41, 0x74, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x61, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x41,
	0x74, 0x12, 0x42, 0x0a, 0x0d, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65,
	0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3a, 0x0a, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f,
	0x77, 0x5f, 0x69, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x66, 0x6c, 0x79,
	0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x49,
	0x64, 0x12, 0x5d, 0x0a, 0x14, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x12, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x42, 0x0f, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x22, 0x5b, 0x0a, 0x0e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x2b, 0x0a, 0x11, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x12, 0x1c, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x22, 0x8b,
	0x05, 0x0a, 0x11, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x43, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x72, 0x69,
	0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72,
	0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x6e, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x67, 0x12, 0x3d, 0x0a, 0x0c, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x5f, 0x61,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0b, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x41, 0x74,
	0x12, 0x5a, 0x0a, 0x15, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e,
	0x4e, 0x6f, 0x64, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x13, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x4e,
	0x6f, 0x64, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5b, 0x0a, 0x13,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x66, 0x6c, 0x79, 0x74,
	0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c,
	0x6f, 0x77, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x12, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x47, 0x0a, 0x0f, 0x73, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x11, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x0e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x3c, 0x0a, 0x0c, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x73, 0x18, 0x12, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65,
	0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x49, 0x44, 0x52, 0x0b, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x49, 0x64, 0x73,
	0x22, 0x7a, 0x0a, 0x0d, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64,
	0x65, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x41, 0x4e, 0x55, 0x41, 0x4c, 0x10, 0x00, 0x12, 0x0d, 0x0a,
	0x09, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06,
	0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x4c, 0x41,
	0x55, 0x4e, 0x43, 0x48, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x48, 0x49, 0x4c, 0x44, 0x5f,
	0x57, 0x4f, 0x52, 0x4b, 0x46, 0x4c, 0x4f, 0x57, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45,
	0x43, 0x4f, 0x56, 0x45, 0x52, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x54, 0x52, 0x49,
	0x47, 0x47, 0x45, 0x52, 0x10, 0x06, 0x22, 0x04, 0x08, 0x07, 0x10, 0x07, 0x22, 0x56, 0x0a, 0x10,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74,
	0x12, 0x42, 0x0a, 0x0d, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69,
	0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x22, 0xd6, 0x09, 0x0a, 0x0d, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x3a, 0x0a, 0x0b, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68,
	0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x66, 0x6c,
	0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x0a, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x50, 0x6c,
	0x61, 0x6e, 0x12, 0x35, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f,
	0x72, 0x65, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x4d, 0x61, 0x70, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x3d, 0x0a, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x66, 0x6c,
	0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x48, 0x0a, 0x0d, 0x6e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x20, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73,
	0x74, 0x48, 0x00, 0x52, 0x0d, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x21, 0x0a, 0x0b, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x6c,
	0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x41, 0x6c, 0x6c, 0x12, 0x2e, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x3d, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x66, 0x6c, 0x79,
	0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x49, 0x0a, 0x10, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e,
	0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12,
	0x39, 0x0a, 0x09, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x18, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x52, 0x6f, 0x6c, 0x65, 0x42, 0x02, 0x18, 0x01,
	0x52, 0x08, 0x61, 0x75, 0x74, 0x68, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x4d, 0x0a, 0x12, 0x71, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x6f, 0x66, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64,
	0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x4f, 0x66,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x10, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x4f, 0x66, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x61, 0x78,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x69, 0x73, 0x6d, 0x18, 0x12, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0e, 0x6d, 0x61, 0x78, 0x50, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x69,
	0x73, 0x6d, 0x12, 0x58, 0x0a, 0x16, 0x72, 0x61, 0x77, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x13, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x52, 0x61, 0x77, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x13, 0x72, 0x61, 0x77, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x50, 0x0a, 0x12,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65,
	0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x11, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x40,
	0x0a, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x72, 0x75, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x18,
	0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x72, 0x75, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65,
	0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x63, 0x61,
	0x63, 0x68, 0x65, 0x18, 0x16, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x6f, 0x76, 0x65, 0x72, 0x77,
	0x72, 0x69, 0x74, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x12, 0x28, 0x0a, 0x04, 0x65, 0x6e, 0x76,
	0x73, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69,
	0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x45, 0x6e, 0x76, 0x73, 0x52, 0x04, 0x65,
	0x6e, 0x76, 0x73, 0x12, 0x16, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x18, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x5d, 0x0a, 0x17, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x66,
	0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x52, 0x15, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x61, 0x0a, 0x19, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x76, 0x5f, 0x61, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x1a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x76, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x17, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x6e, 0x76, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x42, 0x18, 0x0a,
	0x16, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x76,
	0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x4a, 0x04, 0x08, 0x04, 0x10, 0x05, 0x22, 0x6d, 0x0a,
	0x19, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64,
	0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x52, 0x02, 0x69, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x61, 0x75, 0x73, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x63, 0x61, 0x75, 0x73, 0x65, 0x22, 0x1c, 0x0a, 0x1a,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5d, 0x0a, 0x1f, 0x57, 0x6f,
	0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x47,
	0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x66, 0x6c, 0x79, 0x74,
	0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c,
	0x6f, 0x77, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x02, 0x69, 0x64, 0x22, 0x88, 0x02, 0x0a, 0x20, 0x57, 0x6f,
	0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x47,
	0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x35,
	0x0a, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x55, 0x72, 0x6c, 0x42, 0x6c, 0x6f, 0x62, 0x42, 0x02, 0x18, 0x01, 0x52, 0x07, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x33, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x55, 0x72, 0x6c, 0x42, 0x6c, 0x6f, 0x62, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x3a, 0x0a, 0x0b, 0x66, 0x75,
	0x6c, 0x6c, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e,
	0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x4d, 0x61, 0x70, 0x52, 0x0a, 0x66, 0x75, 0x6c, 0x6c,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x3c, 0x0a, 0x0c, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x66,
	0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x4c, 0x69, 0x74,
	0x65, 0x72, 0x61, 0x6c, 0x4d, 0x61, 0x70, 0x52, 0x0b, 0x66, 0x75, 0x6c, 0x6c, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x73, 0x22, 0x8a, 0x01, 0x0a, 0x16, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3a, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x66, 0x6c,
	0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x57, 0x6f, 0x72, 0x6b,
	0x66, 0x6c, 0x6f, 0x77, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x02, 0x69, 0x64, 0x12, 0x34, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x66, 0x6c, 0x79,
	0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x22, 0xae, 0x01, 0x0a, 0x1b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x12, 0x34, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1e, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x6f, 0x63, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x64, 0x41, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61,
	0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70,
	0x61, 0x6c, 0x22, 0x19, 0x0a, 0x17, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x76, 0x0a,
	0x22, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e,
	0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x14, 0x0a, 0x05, 0x64, 0x65, 0x70, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05,
	0x64, 0x65, 0x70, 0x74, 0x68, 0x22, 0x4e, 0x0a, 0x23, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f,
	0x77, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x27, 0x0a, 0x04,
	0x73, 0x70, 0x61, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x66, 0x6c, 0x79,
	0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x52,
	0x04, 0x73, 0x70, 0x61, 0x6e, 0x2a, 0x3e, 0x0a, 0x0e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x58, 0x45, 0x43, 0x55,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x00, 0x12, 0x16, 0x0a,
	0x12, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x52, 0x43, 0x48, 0x49,
	0x56, 0x45, 0x44, 0x10, 0x01, 0x42, 0xba, 0x01, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x2e, 0x66, 0x6c,
	0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x42, 0x0e, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b,
	0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x66, 0x6c, 0x79, 0x74, 0x65,
	0x6f, 0x72, 0x67, 0x2f, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x2f, 0x66, 0x6c, 0x79, 0x74, 0x65, 0x69,
	0x64, 0x6c, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x70, 0x62, 0x2d, 0x67, 0x6f, 0x2f, 0x66, 0x6c, 0x79,
	0x74, 0x65, 0x69, 0x64, 0x6c, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0xa2, 0x02, 0x03, 0x46, 0x41,
	0x58, 0xaa, 0x02, 0x0e, 0x46, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x2e, 0x41, 0x64, 0x6d,
	0x69, 0x6e, 0xca, 0x02, 0x0e, 0x46, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x5c, 0x41, 0x64,
	0x6d, 0x69, 0x6e, 0xe2, 0x02, 0x1a, 0x46, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x5c, 0x41,
	0x64, 0x6d, 0x69, 0x6e, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xea, 0x02, 0x0f, 0x46, 0x6c, 0x79, 0x74, 0x65, 0x69, 0x64, 0x6c, 0x3a, 0x3a, 0x41, 0x64, 0x6d,
	0x69, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_flyteidl_admin_execution_proto_rawDescOnce sync.Once
	file_flyteidl_admin_execution_proto_rawDescData = file_flyteidl_admin_execution_proto_rawDesc
)

func file_flyteidl_admin_execution_proto_rawDescGZIP() []byte {
	file_flyteidl_admin_execution_proto_rawDescOnce.Do(func() {
		file_flyteidl_admin_execution_proto_rawDescData = protoimpl.X.CompressGZIP(file_flyteidl_admin_execution_proto_rawDescData)
	})
	return file_flyteidl_admin_execution_proto_rawDescData
}

var file_flyteidl_admin_execution_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_flyteidl_admin_execution_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_flyteidl_admin_execution_proto_goTypes = []interface{}{
	(ExecutionState)(0),                         // 0: flyteidl.admin.ExecutionState
	(ExecutionMetadata_ExecutionMode)(0),        // 1: flyteidl.admin.ExecutionMetadata.ExecutionMode
	(*ExecutionCreateRequest)(nil),              // 2: flyteidl.admin.ExecutionCreateRequest
	(*ExecutionRelaunchRequest)(nil),            // 3: flyteidl.admin.ExecutionRelaunchRequest
	(*ExecutionRecoverRequest)(nil),             // 4: flyteidl.admin.ExecutionRecoverRequest
	(*ExecutionCreateResponse)(nil),             // 5: flyteidl.admin.ExecutionCreateResponse
	(*WorkflowExecutionGetRequest)(nil),         // 6: flyteidl.admin.WorkflowExecutionGetRequest
	(*Execution)(nil),                           // 7: flyteidl.admin.Execution
	(*ExecutionList)(nil),                       // 8: flyteidl.admin.ExecutionList
	(*LiteralMapBlob)(nil),                      // 9: flyteidl.admin.LiteralMapBlob
	(*AbortMetadata)(nil),                       // 10: flyteidl.admin.AbortMetadata
	(*ExecutionClosure)(nil),                    // 11: flyteidl.admin.ExecutionClosure
	(*SystemMetadata)(nil),                      // 12: flyteidl.admin.SystemMetadata
	(*ExecutionMetadata)(nil),                   // 13: flyteidl.admin.ExecutionMetadata
	(*NotificationList)(nil),                    // 14: flyteidl.admin.NotificationList
	(*ExecutionSpec)(nil),                       // 15: flyteidl.admin.ExecutionSpec
	(*ExecutionTerminateRequest)(nil),           // 16: flyteidl.admin.ExecutionTerminateRequest
	(*ExecutionTerminateResponse)(nil),          // 17: flyteidl.admin.ExecutionTerminateResponse
	(*WorkflowExecutionGetDataRequest)(nil),     // 18: flyteidl.admin.WorkflowExecutionGetDataRequest
	(*WorkflowExecutionGetDataResponse)(nil),    // 19: flyteidl.admin.WorkflowExecutionGetDataResponse
	(*ExecutionUpdateRequest)(nil),              // 20: flyteidl.admin.ExecutionUpdateRequest
	(*ExecutionStateChangeDetails)(nil),         // 21: flyteidl.admin.ExecutionStateChangeDetails
	(*ExecutionUpdateResponse)(nil),             // 22: flyteidl.admin.ExecutionUpdateResponse
	(*WorkflowExecutionGetMetricsRequest)(nil),  // 23: flyteidl.admin.WorkflowExecutionGetMetricsRequest
	(*WorkflowExecutionGetMetricsResponse)(nil), // 24: flyteidl.admin.WorkflowExecutionGetMetricsResponse
	(*core.LiteralMap)(nil),                     // 25: flyteidl.core.LiteralMap
	(*core.WorkflowExecutionIdentifier)(nil),    // 26: flyteidl.core.WorkflowExecutionIdentifier
	(*core.ExecutionError)(nil),                 // 27: flyteidl.core.ExecutionError
	(core.WorkflowExecution_Phase)(0),           // 28: flyteidl.core.WorkflowExecution.Phase
	(*timestamppb.Timestamp)(nil),               // 29: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                 // 30: google.protobuf.Duration
	(*Notification)(nil),                        // 31: flyteidl.admin.Notification
	(*core.Identifier)(nil),                     // 32: flyteidl.core.Identifier
	(*core.NodeExecutionIdentifier)(nil),        // 33: flyteidl.core.NodeExecutionIdentifier
	(*core.ArtifactID)(nil),                     // 34: flyteidl.core.ArtifactID
	(*Labels)(nil),                              // 35: flyteidl.admin.Labels
	(*Annotations)(nil),                         // 36: flyteidl.admin.Annotations
	(*core.SecurityContext)(nil),                // 37: flyteidl.core.SecurityContext
	(*AuthRole)(nil),                            // 38: flyteidl.admin.AuthRole
	(*core.QualityOfService)(nil),               // 39: flyteidl.core.QualityOfService
	(*RawOutputDataConfig)(nil),                 // 40: flyteidl.admin.RawOutputDataConfig
	(*ClusterAssignment)(nil),                   // 41: flyteidl.admin.ClusterAssignment
	(*wrapperspb.BoolValue)(nil),                // 42: google.protobuf.BoolValue
	(*Envs)(nil),                                // 43: flyteidl.admin.Envs
	(*ExecutionClusterLabel)(nil),               // 44: flyteidl.admin.ExecutionClusterLabel
	(*core.ExecutionEnvAssignment)(nil),         // 45: flyteidl.core.ExecutionEnvAssignment
	(*UrlBlob)(nil),                             // 46: flyteidl.admin.UrlBlob
	(*core.Span)(nil),                           // 47: flyteidl.core.Span
}
var file_flyteidl_admin_execution_proto_depIdxs = []int32{
	15, // 0: flyteidl.admin.ExecutionCreateRequest.spec:type_name -> flyteidl.admin.ExecutionSpec
	25, // 1: flyteidl.admin.ExecutionCreateRequest.inputs:type_name -> flyteidl.core.LiteralMap
	26, // 2: flyteidl.admin.ExecutionRelaunchRequest.id:type_name -> flyteidl.core.WorkflowExecutionIdentifier
	26, // 3: flyteidl.admin.ExecutionRecoverRequest.id:type_name -> flyteidl.core.WorkflowExecutionIdentifier
	13, // 4: flyteidl.admin.ExecutionRecoverRequest.metadata:type_name -> flyteidl.admin.ExecutionMetadata
	26, // 5: flyteidl.admin.ExecutionCreateResponse.id:type_name -> flyteidl.core.WorkflowExecutionIdentifier
	26, // 6: flyteidl.admin.WorkflowExecutionGetRequest.id:type_name -> flyteidl.core.WorkflowExecutionIdentifier
	26, // 7: flyteidl.admin.Execution.id:type_name -> flyteidl.core.WorkflowExecutionIdentifier
	15, // 8: flyteidl.admin.Execution.spec:type_name -> flyteidl.admin.ExecutionSpec
	11, // 9: flyteidl.admin.Execution.closure:type_name -> flyteidl.admin.ExecutionClosure
	7,  // 10: flyteidl.admin.ExecutionList.executions:type_name -> flyteidl.admin.Execution
	25, // 11: flyteidl.admin.LiteralMapBlob.values:type_name -> flyteidl.core.LiteralMap
	9,  // 12: flyteidl.admin.ExecutionClosure.outputs:type_name -> flyteidl.admin.LiteralMapBlob
	27, // 13: flyteidl.admin.ExecutionClosure.error:type_name -> flyteidl.core.ExecutionError
	10, // 14: flyteidl.admin.ExecutionClosure.abort_metadata:type_name -> flyteidl.admin.AbortMetadata
	25, // 15: flyteidl.admin.ExecutionClosure.output_data:type_name -> flyteidl.core.LiteralMap
	25, // 16: flyteidl.admin.ExecutionClosure.computed_inputs:type_name -> flyteidl.core.LiteralMap
	28, // 17: flyteidl.admin.ExecutionClosure.phase:type_name -> flyteidl.core.WorkflowExecution.Phase
	29, // 18: flyteidl.admin.ExecutionClosure.started_at:type_name -> google.protobuf.Timestamp
	30, // 19: flyteidl.admin.ExecutionClosure.duration:type_name -> google.protobuf.Duration
	29, // 20: flyteidl.admin.ExecutionClosure.created_at:type_name -> google.protobuf.Timestamp
	29, // 21: flyteidl.admin.ExecutionClosure.updated_at:type_name -> google.protobuf.Timestamp
	31, // 22: flyteidl.admin.ExecutionClosure.notifications:type_name -> flyteidl.admin.Notification
	32, // 23: flyteidl.admin.ExecutionClosure.workflow_id:type_name -> flyteidl.core.Identifier
	21, // 24: flyteidl.admin.ExecutionClosure.state_change_details:type_name -> flyteidl.admin.ExecutionStateChangeDetails
	1,  // 25: flyteidl.admin.ExecutionMetadata.mode:type_name -> flyteidl.admin.ExecutionMetadata.ExecutionMode
	29, // 26: flyteidl.admin.ExecutionMetadata.scheduled_at:type_name -> google.protobuf.Timestamp
	33, // 27: flyteidl.admin.ExecutionMetadata.parent_node_execution:type_name -> flyteidl.core.NodeExecutionIdentifier
	26, // 28: flyteidl.admin.ExecutionMetadata.reference_execution:type_name -> flyteidl.core.WorkflowExecutionIdentifier
	12, // 29: flyteidl.admin.ExecutionMetadata.system_metadata:type_name -> flyteidl.admin.SystemMetadata
	34, // 30: flyteidl.admin.ExecutionMetadata.artifact_ids:type_name -> flyteidl.core.ArtifactID
	31, // 31: flyteidl.admin.NotificationList.notifications:type_name -> flyteidl.admin.Notification
	32, // 32: flyteidl.admin.ExecutionSpec.launch_plan:type_name -> flyteidl.core.Identifier
	25, // 33: flyteidl.admin.ExecutionSpec.inputs:type_name -> flyteidl.core.LiteralMap
	13, // 34: flyteidl.admin.ExecutionSpec.metadata:type_name -> flyteidl.admin.ExecutionMetadata
	14, // 35: flyteidl.admin.ExecutionSpec.notifications:type_name -> flyteidl.admin.NotificationList
	35, // 36: flyteidl.admin.ExecutionSpec.labels:type_name -> flyteidl.admin.Labels
	36, // 37: flyteidl.admin.ExecutionSpec.annotations:type_name -> flyteidl.admin.Annotations
	37, // 38: flyteidl.admin.ExecutionSpec.security_context:type_name -> flyteidl.core.SecurityContext
	38, // 39: flyteidl.admin.ExecutionSpec.auth_role:type_name -> flyteidl.admin.AuthRole
	39, // 40: flyteidl.admin.ExecutionSpec.quality_of_service:type_name -> flyteidl.core.QualityOfService
	40, // 41: flyteidl.admin.ExecutionSpec.raw_output_data_config:type_name -> flyteidl.admin.RawOutputDataConfig
	41, // 42: flyteidl.admin.ExecutionSpec.cluster_assignment:type_name -> flyteidl.admin.ClusterAssignment
	42, // 43: flyteidl.admin.ExecutionSpec.interruptible:type_name -> google.protobuf.BoolValue
	43, // 44: flyteidl.admin.ExecutionSpec.envs:type_name -> flyteidl.admin.Envs
	44, // 45: flyteidl.admin.ExecutionSpec.execution_cluster_label:type_name -> flyteidl.admin.ExecutionClusterLabel
	45, // 46: flyteidl.admin.ExecutionSpec.execution_env_assignments:type_name -> flyteidl.core.ExecutionEnvAssignment
	26, // 47: flyteidl.admin.ExecutionTerminateRequest.id:type_name -> flyteidl.core.WorkflowExecutionIdentifier
	26, // 48: flyteidl.admin.WorkflowExecutionGetDataRequest.id:type_name -> flyteidl.core.WorkflowExecutionIdentifier
	46, // 49: flyteidl.admin.WorkflowExecutionGetDataResponse.outputs:type_name -> flyteidl.admin.UrlBlob
	46, // 50: flyteidl.admin.WorkflowExecutionGetDataResponse.inputs:type_name -> flyteidl.admin.UrlBlob
	25, // 51: flyteidl.admin.WorkflowExecutionGetDataResponse.full_inputs:type_name -> flyteidl.core.LiteralMap
	25, // 52: flyteidl.admin.WorkflowExecutionGetDataResponse.full_outputs:type_name -> flyteidl.core.LiteralMap
	26, // 53: flyteidl.admin.ExecutionUpdateRequest.id:type_name -> flyteidl.core.WorkflowExecutionIdentifier
	0,  // 54: flyteidl.admin.ExecutionUpdateRequest.state:type_name -> flyteidl.admin.ExecutionState
	0,  // 55: flyteidl.admin.ExecutionStateChangeDetails.state:type_name -> flyteidl.admin.ExecutionState
	29, // 56: flyteidl.admin.ExecutionStateChangeDetails.occurred_at:type_name -> google.protobuf.Timestamp
	26, // 57: flyteidl.admin.WorkflowExecutionGetMetricsRequest.id:type_name -> flyteidl.core.WorkflowExecutionIdentifier
	47, // 58: flyteidl.admin.WorkflowExecutionGetMetricsResponse.span:type_name -> flyteidl.core.Span
	59, // [59:59] is the sub-list for method output_type
	59, // [59:59] is the sub-list for method input_type
	59, // [59:59] is the sub-list for extension type_name
	59, // [59:59] is the sub-list for extension extendee
	0,  // [0:59] is the sub-list for field type_name
}

func init() { file_flyteidl_admin_execution_proto_init() }
func file_flyteidl_admin_execution_proto_init() {
	if File_flyteidl_admin_execution_proto != nil {
		return
	}
	file_flyteidl_admin_cluster_assignment_proto_init()
	file_flyteidl_admin_common_proto_init()
	file_flyteidl_admin_matchable_resource_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_flyteidl_admin_execution_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionCreateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionRelaunchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionRecoverRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionCreateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkflowExecutionGetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Execution); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LiteralMapBlob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AbortMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionClosure); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SystemMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NotificationList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionTerminateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionTerminateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkflowExecutionGetDataRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkflowExecutionGetDataResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionUpdateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionStateChangeDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionUpdateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkflowExecutionGetMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_flyteidl_admin_execution_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkflowExecutionGetMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_flyteidl_admin_execution_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*LiteralMapBlob_Values)(nil),
		(*LiteralMapBlob_Uri)(nil),
	}
	file_flyteidl_admin_execution_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*ExecutionClosure_Outputs)(nil),
		(*ExecutionClosure_Error)(nil),
		(*ExecutionClosure_AbortCause)(nil),
		(*ExecutionClosure_AbortMetadata)(nil),
		(*ExecutionClosure_OutputData)(nil),
	}
	file_flyteidl_admin_execution_proto_msgTypes[13].OneofWrappers = []interface{}{
		(*ExecutionSpec_Notifications)(nil),
		(*ExecutionSpec_DisableAll)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_flyteidl_admin_execution_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_flyteidl_admin_execution_proto_goTypes,
		DependencyIndexes: file_flyteidl_admin_execution_proto_depIdxs,
		EnumInfos:         file_flyteidl_admin_execution_proto_enumTypes,
		MessageInfos:      file_flyteidl_admin_execution_proto_msgTypes,
	}.Build()
	File_flyteidl_admin_execution_proto = out.File
	file_flyteidl_admin_execution_proto_rawDesc = nil
	file_flyteidl_admin_execution_proto_goTypes = nil
	file_flyteidl_admin_execution_proto_depIdxs = nil
}
