// @generated by protoc-gen-es v1.7.2 with parameter "target=ts"
// @generated from file flyteidl/plugins/array_job.proto (package flyteidl.plugins, syntax proto3)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { Message, proto3, protoInt64 } from "@bufbuild/protobuf";

/**
 * Describes a job that can process independent pieces of data concurrently. Multiple copies of the runnable component
 * will be executed concurrently.
 *
 * @generated from message flyteidl.plugins.ArrayJob
 */
export class ArrayJob extends Message<ArrayJob> {
  /**
   * Defines the maximum number of instances to bring up concurrently at any given point. Note that this is an
   * optimistic restriction and that, due to network partitioning or other failures, the actual number of currently
   * running instances might be more. This has to be a positive number if assigned. Default value is size.
   *
   * @generated from field: int64 parallelism = 1;
   */
  parallelism = protoInt64.zero;

  /**
   * Defines the number of instances to launch at most. This number should match the size of the input if the job
   * requires processing of all input data. This has to be a positive number.
   * In the case this is not defined, the back-end will determine the size at run-time by reading the inputs.
   *
   * @generated from field: int64 size = 2;
   */
  size = protoInt64.zero;

  /**
   * @generated from oneof flyteidl.plugins.ArrayJob.success_criteria
   */
  successCriteria: {
    /**
     * An absolute number of the minimum number of successful completions of subtasks. As soon as this criteria is met,
     * the array job will be marked as successful and outputs will be computed. This has to be a non-negative number if
     * assigned. Default value is size (if specified).
     *
     * @generated from field: int64 min_successes = 3;
     */
    value: bigint;
    case: "minSuccesses";
  } | {
    /**
     * If the array job size is not known beforehand, the min_success_ratio can instead be used to determine when an array
     * job can be marked successful.
     *
     * @generated from field: float min_success_ratio = 4;
     */
    value: number;
    case: "minSuccessRatio";
  } | { case: undefined; value?: undefined } = { case: undefined };

  constructor(data?: PartialMessage<ArrayJob>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.plugins.ArrayJob";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "parallelism", kind: "scalar", T: 3 /* ScalarType.INT64 */ },
    { no: 2, name: "size", kind: "scalar", T: 3 /* ScalarType.INT64 */ },
    { no: 3, name: "min_successes", kind: "scalar", T: 3 /* ScalarType.INT64 */, oneof: "success_criteria" },
    { no: 4, name: "min_success_ratio", kind: "scalar", T: 2 /* ScalarType.FLOAT */, oneof: "success_criteria" },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ArrayJob {
    return new ArrayJob().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ArrayJob {
    return new ArrayJob().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ArrayJob {
    return new ArrayJob().fromJsonString(jsonString, options);
  }

  static equals(a: ArrayJob | PlainMessage<ArrayJob> | undefined, b: ArrayJob | PlainMessage<ArrayJob> | undefined): boolean {
    return proto3.util.equals(ArrayJob, a, b);
  }
}

