// @generated by protoc-gen-es v1.7.2 with parameter "target=ts"
// @generated from file flyteidl/core/workflow.proto (package flyteidl.core, syntax proto3)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { BoolValue, Duration, Message, proto3 } from "@bufbuild/protobuf";
import { BooleanExpression } from "./condition_pb.js";
import { Error, LiteralType } from "./types_pb.js";
import { Identifier } from "./identifier_pb.js";
import { Binding, LiteralMap, RetryStrategy } from "./literals_pb.js";
import { QualityOfService } from "./execution_pb.js";
import { TypedInterface } from "./interface_pb.js";
import { ExtendedResources, Resources } from "./tasks_pb.js";

/**
 * Defines a condition and the execution unit that should be executed if the condition is satisfied.
 *
 * @generated from message flyteidl.core.IfBlock
 */
export class IfBlock extends Message<IfBlock> {
  /**
   * @generated from field: flyteidl.core.BooleanExpression condition = 1;
   */
  condition?: BooleanExpression;

  /**
   * @generated from field: flyteidl.core.Node then_node = 2;
   */
  thenNode?: Node;

  constructor(data?: PartialMessage<IfBlock>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.IfBlock";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "condition", kind: "message", T: BooleanExpression },
    { no: 2, name: "then_node", kind: "message", T: Node },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): IfBlock {
    return new IfBlock().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): IfBlock {
    return new IfBlock().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): IfBlock {
    return new IfBlock().fromJsonString(jsonString, options);
  }

  static equals(a: IfBlock | PlainMessage<IfBlock> | undefined, b: IfBlock | PlainMessage<IfBlock> | undefined): boolean {
    return proto3.util.equals(IfBlock, a, b);
  }
}

/**
 * Defines a series of if/else blocks. The first branch whose condition evaluates to true is the one to execute.
 * If no conditions were satisfied, the else_node or the error will execute.
 *
 * @generated from message flyteidl.core.IfElseBlock
 */
export class IfElseBlock extends Message<IfElseBlock> {
  /**
   * +required. First condition to evaluate.
   *
   * @generated from field: flyteidl.core.IfBlock case = 1;
   */
  case?: IfBlock;

  /**
   * +optional. Additional branches to evaluate.
   *
   * @generated from field: repeated flyteidl.core.IfBlock other = 2;
   */
  other: IfBlock[] = [];

  /**
   * +required.
   *
   * @generated from oneof flyteidl.core.IfElseBlock.default
   */
  default: {
    /**
     * The node to execute in case none of the branches were taken.
     *
     * @generated from field: flyteidl.core.Node else_node = 3;
     */
    value: Node;
    case: "elseNode";
  } | {
    /**
     * An error to throw in case none of the branches were taken.
     *
     * @generated from field: flyteidl.core.Error error = 4;
     */
    value: Error;
    case: "error";
  } | { case: undefined; value?: undefined } = { case: undefined };

  constructor(data?: PartialMessage<IfElseBlock>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.IfElseBlock";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "case", kind: "message", T: IfBlock },
    { no: 2, name: "other", kind: "message", T: IfBlock, repeated: true },
    { no: 3, name: "else_node", kind: "message", T: Node, oneof: "default" },
    { no: 4, name: "error", kind: "message", T: Error, oneof: "default" },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): IfElseBlock {
    return new IfElseBlock().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): IfElseBlock {
    return new IfElseBlock().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): IfElseBlock {
    return new IfElseBlock().fromJsonString(jsonString, options);
  }

  static equals(a: IfElseBlock | PlainMessage<IfElseBlock> | undefined, b: IfElseBlock | PlainMessage<IfElseBlock> | undefined): boolean {
    return proto3.util.equals(IfElseBlock, a, b);
  }
}

/**
 * BranchNode is a special node that alter the flow of the workflow graph. It allows the control flow to branch at
 * runtime based on a series of conditions that get evaluated on various parameters (e.g. inputs, primitives).
 *
 * @generated from message flyteidl.core.BranchNode
 */
export class BranchNode extends Message<BranchNode> {
  /**
   * +required
   *
   * @generated from field: flyteidl.core.IfElseBlock if_else = 1;
   */
  ifElse?: IfElseBlock;

  constructor(data?: PartialMessage<BranchNode>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.BranchNode";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "if_else", kind: "message", T: IfElseBlock },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): BranchNode {
    return new BranchNode().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): BranchNode {
    return new BranchNode().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): BranchNode {
    return new BranchNode().fromJsonString(jsonString, options);
  }

  static equals(a: BranchNode | PlainMessage<BranchNode> | undefined, b: BranchNode | PlainMessage<BranchNode> | undefined): boolean {
    return proto3.util.equals(BranchNode, a, b);
  }
}

/**
 * Refers to the task that the Node is to execute.
 *
 * @generated from message flyteidl.core.TaskNode
 */
export class TaskNode extends Message<TaskNode> {
  /**
   * @generated from oneof flyteidl.core.TaskNode.reference
   */
  reference: {
    /**
     * A globally unique identifier for the task.
     *
     * @generated from field: flyteidl.core.Identifier reference_id = 1;
     */
    value: Identifier;
    case: "referenceId";
  } | { case: undefined; value?: undefined } = { case: undefined };

  /**
   * Optional overrides applied at task execution time.
   *
   * @generated from field: flyteidl.core.TaskNodeOverrides overrides = 2;
   */
  overrides?: TaskNodeOverrides;

  constructor(data?: PartialMessage<TaskNode>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.TaskNode";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "reference_id", kind: "message", T: Identifier, oneof: "reference" },
    { no: 2, name: "overrides", kind: "message", T: TaskNodeOverrides },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TaskNode {
    return new TaskNode().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TaskNode {
    return new TaskNode().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TaskNode {
    return new TaskNode().fromJsonString(jsonString, options);
  }

  static equals(a: TaskNode | PlainMessage<TaskNode> | undefined, b: TaskNode | PlainMessage<TaskNode> | undefined): boolean {
    return proto3.util.equals(TaskNode, a, b);
  }
}

/**
 * Refers to a the workflow the node is to execute.
 *
 * @generated from message flyteidl.core.WorkflowNode
 */
export class WorkflowNode extends Message<WorkflowNode> {
  /**
   * @generated from oneof flyteidl.core.WorkflowNode.reference
   */
  reference: {
    /**
     * A globally unique identifier for the launch plan.
     *
     * @generated from field: flyteidl.core.Identifier launchplan_ref = 1;
     */
    value: Identifier;
    case: "launchplanRef";
  } | {
    /**
     * Reference to a subworkflow, that should be defined with the compiler context
     *
     * @generated from field: flyteidl.core.Identifier sub_workflow_ref = 2;
     */
    value: Identifier;
    case: "subWorkflowRef";
  } | { case: undefined; value?: undefined } = { case: undefined };

  constructor(data?: PartialMessage<WorkflowNode>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.WorkflowNode";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "launchplan_ref", kind: "message", T: Identifier, oneof: "reference" },
    { no: 2, name: "sub_workflow_ref", kind: "message", T: Identifier, oneof: "reference" },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): WorkflowNode {
    return new WorkflowNode().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): WorkflowNode {
    return new WorkflowNode().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): WorkflowNode {
    return new WorkflowNode().fromJsonString(jsonString, options);
  }

  static equals(a: WorkflowNode | PlainMessage<WorkflowNode> | undefined, b: WorkflowNode | PlainMessage<WorkflowNode> | undefined): boolean {
    return proto3.util.equals(WorkflowNode, a, b);
  }
}

/**
 * ApproveCondition represents a dependency on an external approval. During execution, this will manifest as a boolean
 * signal with the provided signal_id.
 *
 * @generated from message flyteidl.core.ApproveCondition
 */
export class ApproveCondition extends Message<ApproveCondition> {
  /**
   * A unique identifier for the requested boolean signal.
   *
   * @generated from field: string signal_id = 1;
   */
  signalId = "";

  constructor(data?: PartialMessage<ApproveCondition>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.ApproveCondition";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "signal_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ApproveCondition {
    return new ApproveCondition().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ApproveCondition {
    return new ApproveCondition().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ApproveCondition {
    return new ApproveCondition().fromJsonString(jsonString, options);
  }

  static equals(a: ApproveCondition | PlainMessage<ApproveCondition> | undefined, b: ApproveCondition | PlainMessage<ApproveCondition> | undefined): boolean {
    return proto3.util.equals(ApproveCondition, a, b);
  }
}

/**
 * SignalCondition represents a dependency on an signal.
 *
 * @generated from message flyteidl.core.SignalCondition
 */
export class SignalCondition extends Message<SignalCondition> {
  /**
   * A unique identifier for the requested signal.
   *
   * @generated from field: string signal_id = 1;
   */
  signalId = "";

  /**
   * A type denoting the required value type for this signal.
   *
   * @generated from field: flyteidl.core.LiteralType type = 2;
   */
  type?: LiteralType;

  /**
   * The variable name for the signal value in this nodes outputs.
   *
   * @generated from field: string output_variable_name = 3;
   */
  outputVariableName = "";

  constructor(data?: PartialMessage<SignalCondition>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.SignalCondition";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "signal_id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "type", kind: "message", T: LiteralType },
    { no: 3, name: "output_variable_name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SignalCondition {
    return new SignalCondition().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SignalCondition {
    return new SignalCondition().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SignalCondition {
    return new SignalCondition().fromJsonString(jsonString, options);
  }

  static equals(a: SignalCondition | PlainMessage<SignalCondition> | undefined, b: SignalCondition | PlainMessage<SignalCondition> | undefined): boolean {
    return proto3.util.equals(SignalCondition, a, b);
  }
}

/**
 * SleepCondition represents a dependency on waiting for the specified duration.
 *
 * @generated from message flyteidl.core.SleepCondition
 */
export class SleepCondition extends Message<SleepCondition> {
  /**
   * The overall duration for this sleep.
   *
   * @generated from field: google.protobuf.Duration duration = 1;
   */
  duration?: Duration;

  constructor(data?: PartialMessage<SleepCondition>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.SleepCondition";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "duration", kind: "message", T: Duration },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SleepCondition {
    return new SleepCondition().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SleepCondition {
    return new SleepCondition().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SleepCondition {
    return new SleepCondition().fromJsonString(jsonString, options);
  }

  static equals(a: SleepCondition | PlainMessage<SleepCondition> | undefined, b: SleepCondition | PlainMessage<SleepCondition> | undefined): boolean {
    return proto3.util.equals(SleepCondition, a, b);
  }
}

/**
 * GateNode refers to the condition that is required for the gate to successfully complete.
 *
 * @generated from message flyteidl.core.GateNode
 */
export class GateNode extends Message<GateNode> {
  /**
   * @generated from oneof flyteidl.core.GateNode.condition
   */
  condition: {
    /**
     * ApproveCondition represents a dependency on an external approval provided by a boolean signal.
     *
     * @generated from field: flyteidl.core.ApproveCondition approve = 1;
     */
    value: ApproveCondition;
    case: "approve";
  } | {
    /**
     * SignalCondition represents a dependency on an signal.
     *
     * @generated from field: flyteidl.core.SignalCondition signal = 2;
     */
    value: SignalCondition;
    case: "signal";
  } | {
    /**
     * SleepCondition represents a dependency on waiting for the specified duration.
     *
     * @generated from field: flyteidl.core.SleepCondition sleep = 3;
     */
    value: SleepCondition;
    case: "sleep";
  } | { case: undefined; value?: undefined } = { case: undefined };

  constructor(data?: PartialMessage<GateNode>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.GateNode";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "approve", kind: "message", T: ApproveCondition, oneof: "condition" },
    { no: 2, name: "signal", kind: "message", T: SignalCondition, oneof: "condition" },
    { no: 3, name: "sleep", kind: "message", T: SleepCondition, oneof: "condition" },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GateNode {
    return new GateNode().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GateNode {
    return new GateNode().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GateNode {
    return new GateNode().fromJsonString(jsonString, options);
  }

  static equals(a: GateNode | PlainMessage<GateNode> | undefined, b: GateNode | PlainMessage<GateNode> | undefined): boolean {
    return proto3.util.equals(GateNode, a, b);
  }
}

/**
 * ArrayNode is a Flyte node type that simplifies the execution of a sub-node over a list of input
 * values. An ArrayNode can be executed with configurable parallelism (separate from the parent
 * workflow) and can be configured to succeed when a certain number of sub-nodes succeed.
 *
 * @generated from message flyteidl.core.ArrayNode
 */
export class ArrayNode extends Message<ArrayNode> {
  /**
   * node is the sub-node that will be executed for each element in the array.
   *
   * @generated from field: flyteidl.core.Node node = 1;
   */
  node?: Node;

  /**
   * @generated from oneof flyteidl.core.ArrayNode.parallelism_option
   */
  parallelismOption: {
    /**
     * parallelism defines the minimum number of instances to bring up concurrently at any given
     * point. Note that this is an optimistic restriction and that, due to network partitioning or
     * other failures, the actual number of currently running instances might be more. This has to
     * be a positive number if assigned. Default value is size.
     *
     * @generated from field: uint32 parallelism = 2;
     */
    value: number;
    case: "parallelism";
  } | { case: undefined; value?: undefined } = { case: undefined };

  /**
   * @generated from oneof flyteidl.core.ArrayNode.success_criteria
   */
  successCriteria: {
    /**
     * min_successes is an absolute number of the minimum number of successful completions of
     * sub-nodes. As soon as this criteria is met, the ArrayNode will be marked as successful
     * and outputs will be computed. This has to be a non-negative number if assigned. Default
     * value is size (if specified).
     *
     * @generated from field: uint32 min_successes = 3;
     */
    value: number;
    case: "minSuccesses";
  } | {
    /**
     * If the array job size is not known beforehand, the min_success_ratio can instead be used
     * to determine when an ArrayNode can be marked successful.
     *
     * @generated from field: float min_success_ratio = 4;
     */
    value: number;
    case: "minSuccessRatio";
  } | { case: undefined; value?: undefined } = { case: undefined };

  /**
   * execution_mode determines the execution path for ArrayNode.
   *
   * @generated from field: flyteidl.core.ArrayNode.ExecutionMode execution_mode = 5;
   */
  executionMode = ArrayNode_ExecutionMode.MINIMAL_STATE;

  /**
   * Indicates whether the sub node's original interface was altered
   *
   * @generated from field: google.protobuf.BoolValue is_original_sub_node_interface = 6;
   */
  isOriginalSubNodeInterface?: boolean;

  constructor(data?: PartialMessage<ArrayNode>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.ArrayNode";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "node", kind: "message", T: Node },
    { no: 2, name: "parallelism", kind: "scalar", T: 13 /* ScalarType.UINT32 */, oneof: "parallelism_option" },
    { no: 3, name: "min_successes", kind: "scalar", T: 13 /* ScalarType.UINT32 */, oneof: "success_criteria" },
    { no: 4, name: "min_success_ratio", kind: "scalar", T: 2 /* ScalarType.FLOAT */, oneof: "success_criteria" },
    { no: 5, name: "execution_mode", kind: "enum", T: proto3.getEnumType(ArrayNode_ExecutionMode) },
    { no: 6, name: "is_original_sub_node_interface", kind: "message", T: BoolValue },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ArrayNode {
    return new ArrayNode().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ArrayNode {
    return new ArrayNode().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ArrayNode {
    return new ArrayNode().fromJsonString(jsonString, options);
  }

  static equals(a: ArrayNode | PlainMessage<ArrayNode> | undefined, b: ArrayNode | PlainMessage<ArrayNode> | undefined): boolean {
    return proto3.util.equals(ArrayNode, a, b);
  }
}

/**
 * @generated from enum flyteidl.core.ArrayNode.ExecutionMode
 */
export enum ArrayNode_ExecutionMode {
  /**
   * Indicates the ArrayNode will store minimal state for the sub-nodes.
   * This is more efficient, but only supports a subset of Flyte entities.
   *
   * @generated from enum value: MINIMAL_STATE = 0;
   */
  MINIMAL_STATE = 0,

  /**
   * Indicates the ArrayNode will store full state for the sub-nodes.
   * This supports a wider range of Flyte entities.
   *
   * @generated from enum value: FULL_STATE = 1;
   */
  FULL_STATE = 1,
}
// Retrieve enum metadata with: proto3.getEnumType(ArrayNode_ExecutionMode)
proto3.util.setEnumType(ArrayNode_ExecutionMode, "flyteidl.core.ArrayNode.ExecutionMode", [
  { no: 0, name: "MINIMAL_STATE" },
  { no: 1, name: "FULL_STATE" },
]);

/**
 * Defines extra information about the Node.
 *
 * @generated from message flyteidl.core.NodeMetadata
 */
export class NodeMetadata extends Message<NodeMetadata> {
  /**
   * A friendly name for the Node
   *
   * @generated from field: string name = 1;
   */
  name = "";

  /**
   * The overall timeout of a task.
   *
   * @generated from field: google.protobuf.Duration timeout = 4;
   */
  timeout?: Duration;

  /**
   * Number of retries per task.
   *
   * @generated from field: flyteidl.core.RetryStrategy retries = 5;
   */
  retries?: RetryStrategy;

  /**
   * Identify whether node is interruptible
   *
   * @generated from oneof flyteidl.core.NodeMetadata.interruptible_value
   */
  interruptibleValue: {
    /**
     * @generated from field: bool interruptible = 6;
     */
    value: boolean;
    case: "interruptible";
  } | { case: undefined; value?: undefined } = { case: undefined };

  /**
   * Identify whether a node should have it's outputs cached.
   *
   * @generated from oneof flyteidl.core.NodeMetadata.cacheable_value
   */
  cacheableValue: {
    /**
     * @generated from field: bool cacheable = 7;
     */
    value: boolean;
    case: "cacheable";
  } | { case: undefined; value?: undefined } = { case: undefined };

  /**
   * The version of the cache to use.
   *
   * @generated from oneof flyteidl.core.NodeMetadata.cache_version_value
   */
  cacheVersionValue: {
    /**
     * @generated from field: string cache_version = 8;
     */
    value: string;
    case: "cacheVersion";
  } | { case: undefined; value?: undefined } = { case: undefined };

  /**
   * Identify whether caching operations involving this node should be serialized.
   *
   * @generated from oneof flyteidl.core.NodeMetadata.cache_serializable_value
   */
  cacheSerializableValue: {
    /**
     * @generated from field: bool cache_serializable = 9;
     */
    value: boolean;
    case: "cacheSerializable";
  } | { case: undefined; value?: undefined } = { case: undefined };

  constructor(data?: PartialMessage<NodeMetadata>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.NodeMetadata";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 4, name: "timeout", kind: "message", T: Duration },
    { no: 5, name: "retries", kind: "message", T: RetryStrategy },
    { no: 6, name: "interruptible", kind: "scalar", T: 8 /* ScalarType.BOOL */, oneof: "interruptible_value" },
    { no: 7, name: "cacheable", kind: "scalar", T: 8 /* ScalarType.BOOL */, oneof: "cacheable_value" },
    { no: 8, name: "cache_version", kind: "scalar", T: 9 /* ScalarType.STRING */, oneof: "cache_version_value" },
    { no: 9, name: "cache_serializable", kind: "scalar", T: 8 /* ScalarType.BOOL */, oneof: "cache_serializable_value" },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NodeMetadata {
    return new NodeMetadata().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NodeMetadata {
    return new NodeMetadata().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NodeMetadata {
    return new NodeMetadata().fromJsonString(jsonString, options);
  }

  static equals(a: NodeMetadata | PlainMessage<NodeMetadata> | undefined, b: NodeMetadata | PlainMessage<NodeMetadata> | undefined): boolean {
    return proto3.util.equals(NodeMetadata, a, b);
  }
}

/**
 * Links a variable to an alias.
 *
 * @generated from message flyteidl.core.Alias
 */
export class Alias extends Message<Alias> {
  /**
   * Must match one of the output variable names on a node.
   *
   * @generated from field: string var = 1;
   */
  var = "";

  /**
   * A workflow-level unique alias that downstream nodes can refer to in their input.
   *
   * @generated from field: string alias = 2;
   */
  alias = "";

  constructor(data?: PartialMessage<Alias>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.Alias";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "var", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "alias", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Alias {
    return new Alias().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Alias {
    return new Alias().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Alias {
    return new Alias().fromJsonString(jsonString, options);
  }

  static equals(a: Alias | PlainMessage<Alias> | undefined, b: Alias | PlainMessage<Alias> | undefined): boolean {
    return proto3.util.equals(Alias, a, b);
  }
}

/**
 * A Workflow graph Node. One unit of execution in the graph. Each node can be linked to a Task, a Workflow or a branch
 * node.
 *
 * @generated from message flyteidl.core.Node
 */
export class Node extends Message<Node> {
  /**
   * A workflow-level unique identifier that identifies this node in the workflow. 'inputs' and 'outputs' are reserved
   * node ids that cannot be used by other nodes.
   *
   * @generated from field: string id = 1;
   */
  id = "";

  /**
   * Extra metadata about the node.
   *
   * @generated from field: flyteidl.core.NodeMetadata metadata = 2;
   */
  metadata?: NodeMetadata;

  /**
   * Specifies how to bind the underlying interface's inputs. All required inputs specified in the underlying interface
   * must be fulfilled.
   *
   * @generated from field: repeated flyteidl.core.Binding inputs = 3;
   */
  inputs: Binding[] = [];

  /**
   * +optional Specifies execution dependency for this node ensuring it will only get scheduled to run after all its
   * upstream nodes have completed. This node will have an implicit dependency on any node that appears in inputs
   * field.
   *
   * @generated from field: repeated string upstream_node_ids = 4;
   */
  upstreamNodeIds: string[] = [];

  /**
   * +optional. A node can define aliases for a subset of its outputs. This is particularly useful if different nodes
   * need to conform to the same interface (e.g. all branches in a branch node). Downstream nodes must refer to this
   * nodes outputs using the alias if one's specified.
   *
   * @generated from field: repeated flyteidl.core.Alias output_aliases = 5;
   */
  outputAliases: Alias[] = [];

  /**
   * Information about the target to execute in this node.
   *
   * @generated from oneof flyteidl.core.Node.target
   */
  target: {
    /**
     * Information about the Task to execute in this node.
     *
     * @generated from field: flyteidl.core.TaskNode task_node = 6;
     */
    value: TaskNode;
    case: "taskNode";
  } | {
    /**
     * Information about the Workflow to execute in this mode.
     *
     * @generated from field: flyteidl.core.WorkflowNode workflow_node = 7;
     */
    value: WorkflowNode;
    case: "workflowNode";
  } | {
    /**
     * Information about the branch node to evaluate in this node.
     *
     * @generated from field: flyteidl.core.BranchNode branch_node = 8;
     */
    value: BranchNode;
    case: "branchNode";
  } | {
    /**
     * Information about the condition to evaluate in this node.
     *
     * @generated from field: flyteidl.core.GateNode gate_node = 9;
     */
    value: GateNode;
    case: "gateNode";
  } | {
    /**
     * Information about the sub-node executions for each value in the list of this nodes
     * inputs values.
     *
     * @generated from field: flyteidl.core.ArrayNode array_node = 10;
     */
    value: ArrayNode;
    case: "arrayNode";
  } | { case: undefined; value?: undefined } = { case: undefined };

  constructor(data?: PartialMessage<Node>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.Node";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "metadata", kind: "message", T: NodeMetadata },
    { no: 3, name: "inputs", kind: "message", T: Binding, repeated: true },
    { no: 4, name: "upstream_node_ids", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 5, name: "output_aliases", kind: "message", T: Alias, repeated: true },
    { no: 6, name: "task_node", kind: "message", T: TaskNode, oneof: "target" },
    { no: 7, name: "workflow_node", kind: "message", T: WorkflowNode, oneof: "target" },
    { no: 8, name: "branch_node", kind: "message", T: BranchNode, oneof: "target" },
    { no: 9, name: "gate_node", kind: "message", T: GateNode, oneof: "target" },
    { no: 10, name: "array_node", kind: "message", T: ArrayNode, oneof: "target" },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Node {
    return new Node().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Node {
    return new Node().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Node {
    return new Node().fromJsonString(jsonString, options);
  }

  static equals(a: Node | PlainMessage<Node> | undefined, b: Node | PlainMessage<Node> | undefined): boolean {
    return proto3.util.equals(Node, a, b);
  }
}

/**
 * This is workflow layer metadata. These settings are only applicable to the workflow as a whole, and do not
 * percolate down to child entities (like tasks) launched by the workflow.
 *
 * @generated from message flyteidl.core.WorkflowMetadata
 */
export class WorkflowMetadata extends Message<WorkflowMetadata> {
  /**
   * Indicates the runtime priority of workflow executions. 
   *
   * @generated from field: flyteidl.core.QualityOfService quality_of_service = 1;
   */
  qualityOfService?: QualityOfService;

  /**
   * Defines how the system should behave when a failure is detected in the workflow execution.
   *
   * @generated from field: flyteidl.core.WorkflowMetadata.OnFailurePolicy on_failure = 2;
   */
  onFailure = WorkflowMetadata_OnFailurePolicy.FAIL_IMMEDIATELY;

  /**
   * Arbitrary tags that allow users and the platform to store small but arbitrary labels
   *
   * @generated from field: map<string, string> tags = 3;
   */
  tags: { [key: string]: string } = {};

  constructor(data?: PartialMessage<WorkflowMetadata>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.WorkflowMetadata";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "quality_of_service", kind: "message", T: QualityOfService },
    { no: 2, name: "on_failure", kind: "enum", T: proto3.getEnumType(WorkflowMetadata_OnFailurePolicy) },
    { no: 3, name: "tags", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): WorkflowMetadata {
    return new WorkflowMetadata().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): WorkflowMetadata {
    return new WorkflowMetadata().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): WorkflowMetadata {
    return new WorkflowMetadata().fromJsonString(jsonString, options);
  }

  static equals(a: WorkflowMetadata | PlainMessage<WorkflowMetadata> | undefined, b: WorkflowMetadata | PlainMessage<WorkflowMetadata> | undefined): boolean {
    return proto3.util.equals(WorkflowMetadata, a, b);
  }
}

/**
 * Failure Handling Strategy
 *
 * @generated from enum flyteidl.core.WorkflowMetadata.OnFailurePolicy
 */
export enum WorkflowMetadata_OnFailurePolicy {
  /**
   * FAIL_IMMEDIATELY instructs the system to fail as soon as a node fails in the workflow. It'll automatically
   * abort all currently running nodes and clean up resources before finally marking the workflow executions as
   * failed.
   *
   * @generated from enum value: FAIL_IMMEDIATELY = 0;
   */
  FAIL_IMMEDIATELY = 0,

  /**
   * FAIL_AFTER_EXECUTABLE_NODES_COMPLETE instructs the system to make as much progress as it can. The system will
   * not alter the dependencies of the execution graph so any node that depend on the failed node will not be run.
   * Other nodes that will be executed to completion before cleaning up resources and marking the workflow
   * execution as failed.
   *
   * @generated from enum value: FAIL_AFTER_EXECUTABLE_NODES_COMPLETE = 1;
   */
  FAIL_AFTER_EXECUTABLE_NODES_COMPLETE = 1,
}
// Retrieve enum metadata with: proto3.getEnumType(WorkflowMetadata_OnFailurePolicy)
proto3.util.setEnumType(WorkflowMetadata_OnFailurePolicy, "flyteidl.core.WorkflowMetadata.OnFailurePolicy", [
  { no: 0, name: "FAIL_IMMEDIATELY" },
  { no: 1, name: "FAIL_AFTER_EXECUTABLE_NODES_COMPLETE" },
]);

/**
 * The difference between these settings and the WorkflowMetadata ones is that these are meant to be passed down to
 * a workflow's underlying entities (like tasks). For instance, 'interruptible' has no meaning at the workflow layer, it
 * is only relevant when a task executes. The settings here are the defaults that are passed to all nodes
 * unless explicitly overridden at the node layer.
 * If you are adding a setting that applies to both the Workflow itself, and everything underneath it, it should be
 * added to both this object and the WorkflowMetadata object above.
 *
 * @generated from message flyteidl.core.WorkflowMetadataDefaults
 */
export class WorkflowMetadataDefaults extends Message<WorkflowMetadataDefaults> {
  /**
   * Whether child nodes of the workflow are interruptible.
   *
   * @generated from field: bool interruptible = 1;
   */
  interruptible = false;

  constructor(data?: PartialMessage<WorkflowMetadataDefaults>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.WorkflowMetadataDefaults";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "interruptible", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): WorkflowMetadataDefaults {
    return new WorkflowMetadataDefaults().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): WorkflowMetadataDefaults {
    return new WorkflowMetadataDefaults().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): WorkflowMetadataDefaults {
    return new WorkflowMetadataDefaults().fromJsonString(jsonString, options);
  }

  static equals(a: WorkflowMetadataDefaults | PlainMessage<WorkflowMetadataDefaults> | undefined, b: WorkflowMetadataDefaults | PlainMessage<WorkflowMetadataDefaults> | undefined): boolean {
    return proto3.util.equals(WorkflowMetadataDefaults, a, b);
  }
}

/**
 * Flyte Workflow Structure that encapsulates task, branch and subworkflow nodes to form a statically analyzable,
 * directed acyclic graph.
 *
 * @generated from message flyteidl.core.WorkflowTemplate
 */
export class WorkflowTemplate extends Message<WorkflowTemplate> {
  /**
   * A globally unique identifier for the workflow.
   *
   * @generated from field: flyteidl.core.Identifier id = 1;
   */
  id?: Identifier;

  /**
   * Extra metadata about the workflow.
   *
   * @generated from field: flyteidl.core.WorkflowMetadata metadata = 2;
   */
  metadata?: WorkflowMetadata;

  /**
   * Defines a strongly typed interface for the Workflow. This can include some optional parameters.
   *
   * @generated from field: flyteidl.core.TypedInterface interface = 3;
   */
  interface?: TypedInterface;

  /**
   * A list of nodes. In addition, 'globals' is a special reserved node id that can be used to consume workflow inputs.
   *
   * @generated from field: repeated flyteidl.core.Node nodes = 4;
   */
  nodes: Node[] = [];

  /**
   * A list of output bindings that specify how to construct workflow outputs. Bindings can pull node outputs or
   * specify literals. All workflow outputs specified in the interface field must be bound in order for the workflow
   * to be validated. A workflow has an implicit dependency on all of its nodes to execute successfully in order to
   * bind final outputs.
   * Most of these outputs will be Binding's with a BindingData of type OutputReference.  That is, your workflow can
   * just have an output of some constant (`Output(5)`), but usually, the workflow will be pulling
   * outputs from the output of a task.
   *
   * @generated from field: repeated flyteidl.core.Binding outputs = 5;
   */
  outputs: Binding[] = [];

  /**
   * +optional A catch-all node. This node is executed whenever the execution engine determines the workflow has failed.
   * The interface of this node must match the Workflow interface with an additional input named 'error' of type
   * pb.lyft.flyte.core.Error.
   *
   * @generated from field: flyteidl.core.Node failure_node = 6;
   */
  failureNode?: Node;

  /**
   * workflow defaults
   *
   * @generated from field: flyteidl.core.WorkflowMetadataDefaults metadata_defaults = 7;
   */
  metadataDefaults?: WorkflowMetadataDefaults;

  constructor(data?: PartialMessage<WorkflowTemplate>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.WorkflowTemplate";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "message", T: Identifier },
    { no: 2, name: "metadata", kind: "message", T: WorkflowMetadata },
    { no: 3, name: "interface", kind: "message", T: TypedInterface },
    { no: 4, name: "nodes", kind: "message", T: Node, repeated: true },
    { no: 5, name: "outputs", kind: "message", T: Binding, repeated: true },
    { no: 6, name: "failure_node", kind: "message", T: Node },
    { no: 7, name: "metadata_defaults", kind: "message", T: WorkflowMetadataDefaults },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): WorkflowTemplate {
    return new WorkflowTemplate().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): WorkflowTemplate {
    return new WorkflowTemplate().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): WorkflowTemplate {
    return new WorkflowTemplate().fromJsonString(jsonString, options);
  }

  static equals(a: WorkflowTemplate | PlainMessage<WorkflowTemplate> | undefined, b: WorkflowTemplate | PlainMessage<WorkflowTemplate> | undefined): boolean {
    return proto3.util.equals(WorkflowTemplate, a, b);
  }
}

/**
 * Optional task node overrides that will be applied at task execution time.
 *
 * @generated from message flyteidl.core.TaskNodeOverrides
 */
export class TaskNodeOverrides extends Message<TaskNodeOverrides> {
  /**
   * A customizable interface to convey resources requested for a task container. 
   *
   * @generated from field: flyteidl.core.Resources resources = 1;
   */
  resources?: Resources;

  /**
   * Overrides for all non-standard resources, not captured by
   * v1.ResourceRequirements, to allocate to a task.
   *
   * @generated from field: flyteidl.core.ExtendedResources extended_resources = 2;
   */
  extendedResources?: ExtendedResources;

  /**
   * Override for the image used by task pods.
   *
   * @generated from field: string container_image = 3;
   */
  containerImage = "";

  constructor(data?: PartialMessage<TaskNodeOverrides>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.TaskNodeOverrides";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "resources", kind: "message", T: Resources },
    { no: 2, name: "extended_resources", kind: "message", T: ExtendedResources },
    { no: 3, name: "container_image", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TaskNodeOverrides {
    return new TaskNodeOverrides().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TaskNodeOverrides {
    return new TaskNodeOverrides().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TaskNodeOverrides {
    return new TaskNodeOverrides().fromJsonString(jsonString, options);
  }

  static equals(a: TaskNodeOverrides | PlainMessage<TaskNodeOverrides> | undefined, b: TaskNodeOverrides | PlainMessage<TaskNodeOverrides> | undefined): boolean {
    return proto3.util.equals(TaskNodeOverrides, a, b);
  }
}

/**
 * A structure that uniquely identifies a launch plan in the system.
 *
 * @generated from message flyteidl.core.LaunchPlanTemplate
 */
export class LaunchPlanTemplate extends Message<LaunchPlanTemplate> {
  /**
   * A globally unique identifier for the launch plan.
   *
   * @generated from field: flyteidl.core.Identifier id = 1;
   */
  id?: Identifier;

  /**
   * The input and output interface for the launch plan
   *
   * @generated from field: flyteidl.core.TypedInterface interface = 2;
   */
  interface?: TypedInterface;

  /**
   * A collection of input literals that are fixed for the launch plan
   *
   * @generated from field: flyteidl.core.LiteralMap fixed_inputs = 3;
   */
  fixedInputs?: LiteralMap;

  constructor(data?: PartialMessage<LaunchPlanTemplate>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.core.LaunchPlanTemplate";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "message", T: Identifier },
    { no: 2, name: "interface", kind: "message", T: TypedInterface },
    { no: 3, name: "fixed_inputs", kind: "message", T: LiteralMap },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): LaunchPlanTemplate {
    return new LaunchPlanTemplate().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): LaunchPlanTemplate {
    return new LaunchPlanTemplate().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): LaunchPlanTemplate {
    return new LaunchPlanTemplate().fromJsonString(jsonString, options);
  }

  static equals(a: LaunchPlanTemplate | PlainMessage<LaunchPlanTemplate> | undefined, b: LaunchPlanTemplate | PlainMessage<LaunchPlanTemplate> | undefined): boolean {
    return proto3.util.equals(LaunchPlanTemplate, a, b);
  }
}

