// @generated by protoc-gen-es v1.7.2 with parameter "target=ts"
// @generated from file flyteidl/admin/matchable_resource.proto (package flyteidl.admin, syntax proto3)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { BoolValue, Message, proto3 } from "@bufbuild/protobuf";
import { SecurityContext } from "../core/security_pb.js";
import { Annotations, Envs, Labels, RawOutputDataConfig } from "./common_pb.js";
import { ExecutionEnvAssignment } from "../core/execution_envs_pb.js";
import { QualityOfService } from "../core/execution_pb.js";
import { ClusterAssignment } from "./cluster_assignment_pb.js";

/**
 * Defines a resource that can be configured by customizable Project-, ProjectDomain- or WorkflowAttributes
 * based on matching tags.
 *
 * @generated from enum flyteidl.admin.MatchableResource
 */
export enum MatchableResource {
  /**
   * Applies to customizable task resource requests and limits.
   *
   * @generated from enum value: TASK_RESOURCE = 0;
   */
  TASK_RESOURCE = 0,

  /**
   * Applies to configuring templated kubernetes cluster resources.
   *
   * @generated from enum value: CLUSTER_RESOURCE = 1;
   */
  CLUSTER_RESOURCE = 1,

  /**
   * Configures task and dynamic task execution queue assignment.
   *
   * @generated from enum value: EXECUTION_QUEUE = 2;
   */
  EXECUTION_QUEUE = 2,

  /**
   * Configures the K8s cluster label to be used for execution to be run
   *
   * @generated from enum value: EXECUTION_CLUSTER_LABEL = 3;
   */
  EXECUTION_CLUSTER_LABEL = 3,

  /**
   * Configures default quality of service when undefined in an execution spec.
   *
   * @generated from enum value: QUALITY_OF_SERVICE_SPECIFICATION = 4;
   */
  QUALITY_OF_SERVICE_SPECIFICATION = 4,

  /**
   * Selects configurable plugin implementation behavior for a given task type.
   *
   * @generated from enum value: PLUGIN_OVERRIDE = 5;
   */
  PLUGIN_OVERRIDE = 5,

  /**
   * Adds defaults for customizable workflow-execution specifications and overrides.
   *
   * @generated from enum value: WORKFLOW_EXECUTION_CONFIG = 6;
   */
  WORKFLOW_EXECUTION_CONFIG = 6,

  /**
   * Controls how to select an available cluster on which this execution should run.
   *
   * @generated from enum value: CLUSTER_ASSIGNMENT = 7;
   */
  CLUSTER_ASSIGNMENT = 7,
}
// Retrieve enum metadata with: proto3.getEnumType(MatchableResource)
proto3.util.setEnumType(MatchableResource, "flyteidl.admin.MatchableResource", [
  { no: 0, name: "TASK_RESOURCE" },
  { no: 1, name: "CLUSTER_RESOURCE" },
  { no: 2, name: "EXECUTION_QUEUE" },
  { no: 3, name: "EXECUTION_CLUSTER_LABEL" },
  { no: 4, name: "QUALITY_OF_SERVICE_SPECIFICATION" },
  { no: 5, name: "PLUGIN_OVERRIDE" },
  { no: 6, name: "WORKFLOW_EXECUTION_CONFIG" },
  { no: 7, name: "CLUSTER_ASSIGNMENT" },
]);

/**
 * Defines a set of overridable task resource attributes set during task registration.
 *
 * @generated from message flyteidl.admin.TaskResourceSpec
 */
export class TaskResourceSpec extends Message<TaskResourceSpec> {
  /**
   * @generated from field: string cpu = 1;
   */
  cpu = "";

  /**
   * @generated from field: string gpu = 2;
   */
  gpu = "";

  /**
   * @generated from field: string memory = 3;
   */
  memory = "";

  /**
   * @generated from field: string storage = 4;
   */
  storage = "";

  /**
   * @generated from field: string ephemeral_storage = 5;
   */
  ephemeralStorage = "";

  constructor(data?: PartialMessage<TaskResourceSpec>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.TaskResourceSpec";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "cpu", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "gpu", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "memory", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 4, name: "storage", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 5, name: "ephemeral_storage", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TaskResourceSpec {
    return new TaskResourceSpec().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TaskResourceSpec {
    return new TaskResourceSpec().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TaskResourceSpec {
    return new TaskResourceSpec().fromJsonString(jsonString, options);
  }

  static equals(a: TaskResourceSpec | PlainMessage<TaskResourceSpec> | undefined, b: TaskResourceSpec | PlainMessage<TaskResourceSpec> | undefined): boolean {
    return proto3.util.equals(TaskResourceSpec, a, b);
  }
}

/**
 * Defines task resource defaults and limits that will be applied at task registration.
 *
 * @generated from message flyteidl.admin.TaskResourceAttributes
 */
export class TaskResourceAttributes extends Message<TaskResourceAttributes> {
  /**
   * @generated from field: flyteidl.admin.TaskResourceSpec defaults = 1;
   */
  defaults?: TaskResourceSpec;

  /**
   * @generated from field: flyteidl.admin.TaskResourceSpec limits = 2;
   */
  limits?: TaskResourceSpec;

  constructor(data?: PartialMessage<TaskResourceAttributes>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.TaskResourceAttributes";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "defaults", kind: "message", T: TaskResourceSpec },
    { no: 2, name: "limits", kind: "message", T: TaskResourceSpec },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TaskResourceAttributes {
    return new TaskResourceAttributes().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TaskResourceAttributes {
    return new TaskResourceAttributes().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TaskResourceAttributes {
    return new TaskResourceAttributes().fromJsonString(jsonString, options);
  }

  static equals(a: TaskResourceAttributes | PlainMessage<TaskResourceAttributes> | undefined, b: TaskResourceAttributes | PlainMessage<TaskResourceAttributes> | undefined): boolean {
    return proto3.util.equals(TaskResourceAttributes, a, b);
  }
}

/**
 * @generated from message flyteidl.admin.ClusterResourceAttributes
 */
export class ClusterResourceAttributes extends Message<ClusterResourceAttributes> {
  /**
   * Custom resource attributes which will be applied in cluster resource creation (e.g. quotas).
   * Map keys are the *case-sensitive* names of variables in templatized resource files.
   * Map values should be the custom values which get substituted during resource creation.
   *
   * @generated from field: map<string, string> attributes = 1;
   */
  attributes: { [key: string]: string } = {};

  constructor(data?: PartialMessage<ClusterResourceAttributes>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ClusterResourceAttributes";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "attributes", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ClusterResourceAttributes {
    return new ClusterResourceAttributes().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ClusterResourceAttributes {
    return new ClusterResourceAttributes().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ClusterResourceAttributes {
    return new ClusterResourceAttributes().fromJsonString(jsonString, options);
  }

  static equals(a: ClusterResourceAttributes | PlainMessage<ClusterResourceAttributes> | undefined, b: ClusterResourceAttributes | PlainMessage<ClusterResourceAttributes> | undefined): boolean {
    return proto3.util.equals(ClusterResourceAttributes, a, b);
  }
}

/**
 * @generated from message flyteidl.admin.ExecutionQueueAttributes
 */
export class ExecutionQueueAttributes extends Message<ExecutionQueueAttributes> {
  /**
   * Tags used for assigning execution queues for tasks defined within this project.
   *
   * @generated from field: repeated string tags = 1;
   */
  tags: string[] = [];

  constructor(data?: PartialMessage<ExecutionQueueAttributes>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ExecutionQueueAttributes";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "tags", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExecutionQueueAttributes {
    return new ExecutionQueueAttributes().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExecutionQueueAttributes {
    return new ExecutionQueueAttributes().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExecutionQueueAttributes {
    return new ExecutionQueueAttributes().fromJsonString(jsonString, options);
  }

  static equals(a: ExecutionQueueAttributes | PlainMessage<ExecutionQueueAttributes> | undefined, b: ExecutionQueueAttributes | PlainMessage<ExecutionQueueAttributes> | undefined): boolean {
    return proto3.util.equals(ExecutionQueueAttributes, a, b);
  }
}

/**
 * @generated from message flyteidl.admin.ExecutionClusterLabel
 */
export class ExecutionClusterLabel extends Message<ExecutionClusterLabel> {
  /**
   * Label value to determine where the execution will be run
   *
   * @generated from field: string value = 1;
   */
  value = "";

  constructor(data?: PartialMessage<ExecutionClusterLabel>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ExecutionClusterLabel";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "value", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExecutionClusterLabel {
    return new ExecutionClusterLabel().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExecutionClusterLabel {
    return new ExecutionClusterLabel().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExecutionClusterLabel {
    return new ExecutionClusterLabel().fromJsonString(jsonString, options);
  }

  static equals(a: ExecutionClusterLabel | PlainMessage<ExecutionClusterLabel> | undefined, b: ExecutionClusterLabel | PlainMessage<ExecutionClusterLabel> | undefined): boolean {
    return proto3.util.equals(ExecutionClusterLabel, a, b);
  }
}

/**
 * This MatchableAttribute configures selecting alternate plugin implementations for a given task type.
 * In addition to an override implementation a selection of fallbacks can be provided or other modes
 * for handling cases where the desired plugin override is not enabled in a given Flyte deployment.
 *
 * @generated from message flyteidl.admin.PluginOverride
 */
export class PluginOverride extends Message<PluginOverride> {
  /**
   * A predefined yet extensible Task type identifier.
   *
   * @generated from field: string task_type = 1;
   */
  taskType = "";

  /**
   * A set of plugin ids which should handle tasks of this type instead of the default registered plugin. The list will be tried in order until a plugin is found with that id.
   *
   * @generated from field: repeated string plugin_id = 2;
   */
  pluginId: string[] = [];

  /**
   * Defines the behavior when no plugin from the plugin_id list is not found.
   *
   * @generated from field: flyteidl.admin.PluginOverride.MissingPluginBehavior missing_plugin_behavior = 4;
   */
  missingPluginBehavior = PluginOverride_MissingPluginBehavior.FAIL;

  constructor(data?: PartialMessage<PluginOverride>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.PluginOverride";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "task_type", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "plugin_id", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 4, name: "missing_plugin_behavior", kind: "enum", T: proto3.getEnumType(PluginOverride_MissingPluginBehavior) },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PluginOverride {
    return new PluginOverride().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PluginOverride {
    return new PluginOverride().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PluginOverride {
    return new PluginOverride().fromJsonString(jsonString, options);
  }

  static equals(a: PluginOverride | PlainMessage<PluginOverride> | undefined, b: PluginOverride | PlainMessage<PluginOverride> | undefined): boolean {
    return proto3.util.equals(PluginOverride, a, b);
  }
}

/**
 * @generated from enum flyteidl.admin.PluginOverride.MissingPluginBehavior
 */
export enum PluginOverride_MissingPluginBehavior {
  /**
   * By default, if this plugin is not enabled for a Flyte deployment then execution will fail.
   *
   * @generated from enum value: FAIL = 0;
   */
  FAIL = 0,

  /**
   * Uses the system-configured default implementation.
   *
   * @generated from enum value: USE_DEFAULT = 1;
   */
  USE_DEFAULT = 1,
}
// Retrieve enum metadata with: proto3.getEnumType(PluginOverride_MissingPluginBehavior)
proto3.util.setEnumType(PluginOverride_MissingPluginBehavior, "flyteidl.admin.PluginOverride.MissingPluginBehavior", [
  { no: 0, name: "FAIL" },
  { no: 1, name: "USE_DEFAULT" },
]);

/**
 * @generated from message flyteidl.admin.PluginOverrides
 */
export class PluginOverrides extends Message<PluginOverrides> {
  /**
   * @generated from field: repeated flyteidl.admin.PluginOverride overrides = 1;
   */
  overrides: PluginOverride[] = [];

  constructor(data?: PartialMessage<PluginOverrides>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.PluginOverrides";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "overrides", kind: "message", T: PluginOverride, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PluginOverrides {
    return new PluginOverrides().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PluginOverrides {
    return new PluginOverrides().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PluginOverrides {
    return new PluginOverrides().fromJsonString(jsonString, options);
  }

  static equals(a: PluginOverrides | PlainMessage<PluginOverrides> | undefined, b: PluginOverrides | PlainMessage<PluginOverrides> | undefined): boolean {
    return proto3.util.equals(PluginOverrides, a, b);
  }
}

/**
 * Adds defaults for customizable workflow-execution specifications and overrides.
 *
 * @generated from message flyteidl.admin.WorkflowExecutionConfig
 */
export class WorkflowExecutionConfig extends Message<WorkflowExecutionConfig> {
  /**
   * Can be used to control the number of parallel nodes to run within the workflow. This is useful to achieve fairness.
   *
   * @generated from field: int32 max_parallelism = 1;
   */
  maxParallelism = 0;

  /**
   * Indicates security context permissions for executions triggered with this matchable attribute. 
   *
   * @generated from field: flyteidl.core.SecurityContext security_context = 2;
   */
  securityContext?: SecurityContext;

  /**
   * Encapsulates user settings pertaining to offloaded data (i.e. Blobs, Schema, query data, etc.).
   *
   * @generated from field: flyteidl.admin.RawOutputDataConfig raw_output_data_config = 3;
   */
  rawOutputDataConfig?: RawOutputDataConfig;

  /**
   * Custom labels to be applied to a triggered execution resource.
   *
   * @generated from field: flyteidl.admin.Labels labels = 4;
   */
  labels?: Labels;

  /**
   * Custom annotations to be applied to a triggered execution resource.
   *
   * @generated from field: flyteidl.admin.Annotations annotations = 5;
   */
  annotations?: Annotations;

  /**
   * Allows for the interruptible flag of a workflow to be overwritten for a single execution.
   * Omitting this field uses the workflow's value as a default.
   * As we need to distinguish between the field not being provided and its default value false, we have to use a wrapper
   * around the bool field.
   *
   * @generated from field: google.protobuf.BoolValue interruptible = 6;
   */
  interruptible?: boolean;

  /**
   * Allows for all cached values of a workflow and its tasks to be overwritten for a single execution.
   * If enabled, all calculations are performed even if cached results would be available, overwriting the stored
   * data once execution finishes successfully.
   *
   * @generated from field: bool overwrite_cache = 7;
   */
  overwriteCache = false;

  /**
   * Environment variables to be set for the execution.
   *
   * @generated from field: flyteidl.admin.Envs envs = 8;
   */
  envs?: Envs;

  /**
   * Execution environment assignments to be set for the execution.
   *
   * @generated from field: repeated flyteidl.core.ExecutionEnvAssignment execution_env_assignments = 9;
   */
  executionEnvAssignments: ExecutionEnvAssignment[] = [];

  constructor(data?: PartialMessage<WorkflowExecutionConfig>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.WorkflowExecutionConfig";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "max_parallelism", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
    { no: 2, name: "security_context", kind: "message", T: SecurityContext },
    { no: 3, name: "raw_output_data_config", kind: "message", T: RawOutputDataConfig },
    { no: 4, name: "labels", kind: "message", T: Labels },
    { no: 5, name: "annotations", kind: "message", T: Annotations },
    { no: 6, name: "interruptible", kind: "message", T: BoolValue },
    { no: 7, name: "overwrite_cache", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
    { no: 8, name: "envs", kind: "message", T: Envs },
    { no: 9, name: "execution_env_assignments", kind: "message", T: ExecutionEnvAssignment, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): WorkflowExecutionConfig {
    return new WorkflowExecutionConfig().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): WorkflowExecutionConfig {
    return new WorkflowExecutionConfig().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): WorkflowExecutionConfig {
    return new WorkflowExecutionConfig().fromJsonString(jsonString, options);
  }

  static equals(a: WorkflowExecutionConfig | PlainMessage<WorkflowExecutionConfig> | undefined, b: WorkflowExecutionConfig | PlainMessage<WorkflowExecutionConfig> | undefined): boolean {
    return proto3.util.equals(WorkflowExecutionConfig, a, b);
  }
}

/**
 * Generic container for encapsulating all types of the above attributes messages.
 *
 * @generated from message flyteidl.admin.MatchingAttributes
 */
export class MatchingAttributes extends Message<MatchingAttributes> {
  /**
   * @generated from oneof flyteidl.admin.MatchingAttributes.target
   */
  target: {
    /**
     * @generated from field: flyteidl.admin.TaskResourceAttributes task_resource_attributes = 1;
     */
    value: TaskResourceAttributes;
    case: "taskResourceAttributes";
  } | {
    /**
     * @generated from field: flyteidl.admin.ClusterResourceAttributes cluster_resource_attributes = 2;
     */
    value: ClusterResourceAttributes;
    case: "clusterResourceAttributes";
  } | {
    /**
     * @generated from field: flyteidl.admin.ExecutionQueueAttributes execution_queue_attributes = 3;
     */
    value: ExecutionQueueAttributes;
    case: "executionQueueAttributes";
  } | {
    /**
     * @generated from field: flyteidl.admin.ExecutionClusterLabel execution_cluster_label = 4;
     */
    value: ExecutionClusterLabel;
    case: "executionClusterLabel";
  } | {
    /**
     * @generated from field: flyteidl.core.QualityOfService quality_of_service = 5;
     */
    value: QualityOfService;
    case: "qualityOfService";
  } | {
    /**
     * @generated from field: flyteidl.admin.PluginOverrides plugin_overrides = 6;
     */
    value: PluginOverrides;
    case: "pluginOverrides";
  } | {
    /**
     * @generated from field: flyteidl.admin.WorkflowExecutionConfig workflow_execution_config = 7;
     */
    value: WorkflowExecutionConfig;
    case: "workflowExecutionConfig";
  } | {
    /**
     * @generated from field: flyteidl.admin.ClusterAssignment cluster_assignment = 8;
     */
    value: ClusterAssignment;
    case: "clusterAssignment";
  } | { case: undefined; value?: undefined } = { case: undefined };

  constructor(data?: PartialMessage<MatchingAttributes>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.MatchingAttributes";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "task_resource_attributes", kind: "message", T: TaskResourceAttributes, oneof: "target" },
    { no: 2, name: "cluster_resource_attributes", kind: "message", T: ClusterResourceAttributes, oneof: "target" },
    { no: 3, name: "execution_queue_attributes", kind: "message", T: ExecutionQueueAttributes, oneof: "target" },
    { no: 4, name: "execution_cluster_label", kind: "message", T: ExecutionClusterLabel, oneof: "target" },
    { no: 5, name: "quality_of_service", kind: "message", T: QualityOfService, oneof: "target" },
    { no: 6, name: "plugin_overrides", kind: "message", T: PluginOverrides, oneof: "target" },
    { no: 7, name: "workflow_execution_config", kind: "message", T: WorkflowExecutionConfig, oneof: "target" },
    { no: 8, name: "cluster_assignment", kind: "message", T: ClusterAssignment, oneof: "target" },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): MatchingAttributes {
    return new MatchingAttributes().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): MatchingAttributes {
    return new MatchingAttributes().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): MatchingAttributes {
    return new MatchingAttributes().fromJsonString(jsonString, options);
  }

  static equals(a: MatchingAttributes | PlainMessage<MatchingAttributes> | undefined, b: MatchingAttributes | PlainMessage<MatchingAttributes> | undefined): boolean {
    return proto3.util.equals(MatchingAttributes, a, b);
  }
}

/**
 * Represents a custom set of attributes applied for either a domain (and optional org); a domain and project (and optional org);
 * or domain, project and workflow name (and optional org).
 * These are used to override system level defaults for kubernetes cluster resource management,
 * default execution values, and more all across different levels of specificity.
 *
 * @generated from message flyteidl.admin.MatchableAttributesConfiguration
 */
export class MatchableAttributesConfiguration extends Message<MatchableAttributesConfiguration> {
  /**
   * @generated from field: flyteidl.admin.MatchingAttributes attributes = 1;
   */
  attributes?: MatchingAttributes;

  /**
   * @generated from field: string domain = 2;
   */
  domain = "";

  /**
   * @generated from field: string project = 3;
   */
  project = "";

  /**
   * @generated from field: string workflow = 4;
   */
  workflow = "";

  /**
   * @generated from field: string launch_plan = 5;
   */
  launchPlan = "";

  /**
   * Optional, org key applied to the resource.
   *
   * @generated from field: string org = 6;
   */
  org = "";

  constructor(data?: PartialMessage<MatchableAttributesConfiguration>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.MatchableAttributesConfiguration";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "attributes", kind: "message", T: MatchingAttributes },
    { no: 2, name: "domain", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "project", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 4, name: "workflow", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 5, name: "launch_plan", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 6, name: "org", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): MatchableAttributesConfiguration {
    return new MatchableAttributesConfiguration().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): MatchableAttributesConfiguration {
    return new MatchableAttributesConfiguration().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): MatchableAttributesConfiguration {
    return new MatchableAttributesConfiguration().fromJsonString(jsonString, options);
  }

  static equals(a: MatchableAttributesConfiguration | PlainMessage<MatchableAttributesConfiguration> | undefined, b: MatchableAttributesConfiguration | PlainMessage<MatchableAttributesConfiguration> | undefined): boolean {
    return proto3.util.equals(MatchableAttributesConfiguration, a, b);
  }
}

/**
 * Request all matching resource attributes for a resource type.
 * See :ref:`ref_flyteidl.admin.MatchableAttributesConfiguration` for more details
 *
 * @generated from message flyteidl.admin.ListMatchableAttributesRequest
 */
export class ListMatchableAttributesRequest extends Message<ListMatchableAttributesRequest> {
  /**
   * +required
   *
   * @generated from field: flyteidl.admin.MatchableResource resource_type = 1;
   */
  resourceType = MatchableResource.TASK_RESOURCE;

  /**
   * Optional, org filter applied to list project requests.
   *
   * @generated from field: string org = 2;
   */
  org = "";

  constructor(data?: PartialMessage<ListMatchableAttributesRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ListMatchableAttributesRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "resource_type", kind: "enum", T: proto3.getEnumType(MatchableResource) },
    { no: 2, name: "org", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ListMatchableAttributesRequest {
    return new ListMatchableAttributesRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ListMatchableAttributesRequest {
    return new ListMatchableAttributesRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ListMatchableAttributesRequest {
    return new ListMatchableAttributesRequest().fromJsonString(jsonString, options);
  }

  static equals(a: ListMatchableAttributesRequest | PlainMessage<ListMatchableAttributesRequest> | undefined, b: ListMatchableAttributesRequest | PlainMessage<ListMatchableAttributesRequest> | undefined): boolean {
    return proto3.util.equals(ListMatchableAttributesRequest, a, b);
  }
}

/**
 * Response for a request for all matching resource attributes for a resource type.
 * See :ref:`ref_flyteidl.admin.MatchableAttributesConfiguration` for more details
 *
 * @generated from message flyteidl.admin.ListMatchableAttributesResponse
 */
export class ListMatchableAttributesResponse extends Message<ListMatchableAttributesResponse> {
  /**
   * @generated from field: repeated flyteidl.admin.MatchableAttributesConfiguration configurations = 1;
   */
  configurations: MatchableAttributesConfiguration[] = [];

  constructor(data?: PartialMessage<ListMatchableAttributesResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ListMatchableAttributesResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "configurations", kind: "message", T: MatchableAttributesConfiguration, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ListMatchableAttributesResponse {
    return new ListMatchableAttributesResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ListMatchableAttributesResponse {
    return new ListMatchableAttributesResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ListMatchableAttributesResponse {
    return new ListMatchableAttributesResponse().fromJsonString(jsonString, options);
  }

  static equals(a: ListMatchableAttributesResponse | PlainMessage<ListMatchableAttributesResponse> | undefined, b: ListMatchableAttributesResponse | PlainMessage<ListMatchableAttributesResponse> | undefined): boolean {
    return proto3.util.equals(ListMatchableAttributesResponse, a, b);
  }
}

