// @generated by protoc-gen-es v1.7.2 with parameter "target=ts"
// @generated from file flyteidl/admin/execution.proto (package flyteidl.admin, syntax proto3)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { BoolValue, Duration, Message, proto3, Timestamp } from "@bufbuild/protobuf";
import { LiteralMap } from "../core/literals_pb.js";
import { Identifier, NodeExecutionIdentifier, WorkflowExecutionIdentifier } from "../core/identifier_pb.js";
import { ExecutionError, QualityOfService, WorkflowExecution_Phase } from "../core/execution_pb.js";
import { Annotations, AuthRole, Envs, Labels, Notification, RawOutputDataConfig, UrlBlob } from "./common_pb.js";
import { ArtifactID } from "../core/artifact_id_pb.js";
import { SecurityContext } from "../core/security_pb.js";
import { ClusterAssignment } from "./cluster_assignment_pb.js";
import { ExecutionClusterLabel } from "./matchable_resource_pb.js";
import { ExecutionEnvAssignment } from "../core/execution_envs_pb.js";
import { Span } from "../core/metrics_pb.js";

/**
 * The state of the execution is used to control its visibility in the UI/CLI.
 *
 * @generated from enum flyteidl.admin.ExecutionState
 */
export enum ExecutionState {
  /**
   * By default, all executions are considered active.
   *
   * @generated from enum value: EXECUTION_ACTIVE = 0;
   */
  EXECUTION_ACTIVE = 0,

  /**
   * Archived executions are no longer visible in the UI.
   *
   * @generated from enum value: EXECUTION_ARCHIVED = 1;
   */
  EXECUTION_ARCHIVED = 1,
}
// Retrieve enum metadata with: proto3.getEnumType(ExecutionState)
proto3.util.setEnumType(ExecutionState, "flyteidl.admin.ExecutionState", [
  { no: 0, name: "EXECUTION_ACTIVE" },
  { no: 1, name: "EXECUTION_ARCHIVED" },
]);

/**
 * Request to launch an execution with the given project, domain and optionally-assigned name.
 *
 * @generated from message flyteidl.admin.ExecutionCreateRequest
 */
export class ExecutionCreateRequest extends Message<ExecutionCreateRequest> {
  /**
   * Name of the project the execution belongs to.
   * +required
   *
   * @generated from field: string project = 1;
   */
  project = "";

  /**
   * Name of the domain the execution belongs to.
   * A domain can be considered as a subset within a specific project.
   * +required
   *
   * @generated from field: string domain = 2;
   */
  domain = "";

  /**
   * User provided value for the resource.
   * If none is provided the system will generate a unique string.
   * +optional
   *
   * @generated from field: string name = 3;
   */
  name = "";

  /**
   * Additional fields necessary to launch the execution.
   * +optional
   *
   * @generated from field: flyteidl.admin.ExecutionSpec spec = 4;
   */
  spec?: ExecutionSpec;

  /**
   * The inputs required to start the execution. All required inputs must be
   * included in this map. If not required and not provided, defaults apply.
   * +optional
   *
   * @generated from field: flyteidl.core.LiteralMap inputs = 5;
   */
  inputs?: LiteralMap;

  /**
   * Optional, org key applied to the resource.
   *
   * @generated from field: string org = 6;
   */
  org = "";

  constructor(data?: PartialMessage<ExecutionCreateRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ExecutionCreateRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "project", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "domain", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 4, name: "spec", kind: "message", T: ExecutionSpec },
    { no: 5, name: "inputs", kind: "message", T: LiteralMap },
    { no: 6, name: "org", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExecutionCreateRequest {
    return new ExecutionCreateRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExecutionCreateRequest {
    return new ExecutionCreateRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExecutionCreateRequest {
    return new ExecutionCreateRequest().fromJsonString(jsonString, options);
  }

  static equals(a: ExecutionCreateRequest | PlainMessage<ExecutionCreateRequest> | undefined, b: ExecutionCreateRequest | PlainMessage<ExecutionCreateRequest> | undefined): boolean {
    return proto3.util.equals(ExecutionCreateRequest, a, b);
  }
}

/**
 * Request to relaunch the referenced execution.
 *
 * @generated from message flyteidl.admin.ExecutionRelaunchRequest
 */
export class ExecutionRelaunchRequest extends Message<ExecutionRelaunchRequest> {
  /**
   * Identifier of the workflow execution to relaunch.
   * +required
   *
   * @generated from field: flyteidl.core.WorkflowExecutionIdentifier id = 1;
   */
  id?: WorkflowExecutionIdentifier;

  /**
   * User provided value for the relaunched execution.
   * If none is provided the system will generate a unique string.
   * +optional
   *
   * @generated from field: string name = 3;
   */
  name = "";

  /**
   * Allows for all cached values of a workflow and its tasks to be overwritten for a single execution.
   * If enabled, all calculations are performed even if cached results would be available, overwriting the stored
   * data once execution finishes successfully.
   *
   * @generated from field: bool overwrite_cache = 4;
   */
  overwriteCache = false;

  constructor(data?: PartialMessage<ExecutionRelaunchRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ExecutionRelaunchRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "message", T: WorkflowExecutionIdentifier },
    { no: 3, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 4, name: "overwrite_cache", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExecutionRelaunchRequest {
    return new ExecutionRelaunchRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExecutionRelaunchRequest {
    return new ExecutionRelaunchRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExecutionRelaunchRequest {
    return new ExecutionRelaunchRequest().fromJsonString(jsonString, options);
  }

  static equals(a: ExecutionRelaunchRequest | PlainMessage<ExecutionRelaunchRequest> | undefined, b: ExecutionRelaunchRequest | PlainMessage<ExecutionRelaunchRequest> | undefined): boolean {
    return proto3.util.equals(ExecutionRelaunchRequest, a, b);
  }
}

/**
 * Request to recover the referenced execution.
 *
 * @generated from message flyteidl.admin.ExecutionRecoverRequest
 */
export class ExecutionRecoverRequest extends Message<ExecutionRecoverRequest> {
  /**
   * Identifier of the workflow execution to recover.
   *
   * @generated from field: flyteidl.core.WorkflowExecutionIdentifier id = 1;
   */
  id?: WorkflowExecutionIdentifier;

  /**
   * User provided value for the recovered execution.
   * If none is provided the system will generate a unique string.
   * +optional
   *
   * @generated from field: string name = 2;
   */
  name = "";

  /**
   * Additional metadata which will be used to overwrite any metadata in the reference execution when triggering a recovery execution.
   *
   * @generated from field: flyteidl.admin.ExecutionMetadata metadata = 3;
   */
  metadata?: ExecutionMetadata;

  constructor(data?: PartialMessage<ExecutionRecoverRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ExecutionRecoverRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "message", T: WorkflowExecutionIdentifier },
    { no: 2, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "metadata", kind: "message", T: ExecutionMetadata },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExecutionRecoverRequest {
    return new ExecutionRecoverRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExecutionRecoverRequest {
    return new ExecutionRecoverRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExecutionRecoverRequest {
    return new ExecutionRecoverRequest().fromJsonString(jsonString, options);
  }

  static equals(a: ExecutionRecoverRequest | PlainMessage<ExecutionRecoverRequest> | undefined, b: ExecutionRecoverRequest | PlainMessage<ExecutionRecoverRequest> | undefined): boolean {
    return proto3.util.equals(ExecutionRecoverRequest, a, b);
  }
}

/**
 * The unique identifier for a successfully created execution.
 * If the name was *not* specified in the create request, this identifier will include a generated name.
 *
 * @generated from message flyteidl.admin.ExecutionCreateResponse
 */
export class ExecutionCreateResponse extends Message<ExecutionCreateResponse> {
  /**
   * @generated from field: flyteidl.core.WorkflowExecutionIdentifier id = 1;
   */
  id?: WorkflowExecutionIdentifier;

  constructor(data?: PartialMessage<ExecutionCreateResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ExecutionCreateResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "message", T: WorkflowExecutionIdentifier },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExecutionCreateResponse {
    return new ExecutionCreateResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExecutionCreateResponse {
    return new ExecutionCreateResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExecutionCreateResponse {
    return new ExecutionCreateResponse().fromJsonString(jsonString, options);
  }

  static equals(a: ExecutionCreateResponse | PlainMessage<ExecutionCreateResponse> | undefined, b: ExecutionCreateResponse | PlainMessage<ExecutionCreateResponse> | undefined): boolean {
    return proto3.util.equals(ExecutionCreateResponse, a, b);
  }
}

/**
 * A message used to fetch a single workflow execution entity.
 * See :ref:`ref_flyteidl.admin.Execution` for more details
 *
 * @generated from message flyteidl.admin.WorkflowExecutionGetRequest
 */
export class WorkflowExecutionGetRequest extends Message<WorkflowExecutionGetRequest> {
  /**
   * Uniquely identifies an individual workflow execution.
   *
   * @generated from field: flyteidl.core.WorkflowExecutionIdentifier id = 1;
   */
  id?: WorkflowExecutionIdentifier;

  constructor(data?: PartialMessage<WorkflowExecutionGetRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.WorkflowExecutionGetRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "message", T: WorkflowExecutionIdentifier },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): WorkflowExecutionGetRequest {
    return new WorkflowExecutionGetRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): WorkflowExecutionGetRequest {
    return new WorkflowExecutionGetRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): WorkflowExecutionGetRequest {
    return new WorkflowExecutionGetRequest().fromJsonString(jsonString, options);
  }

  static equals(a: WorkflowExecutionGetRequest | PlainMessage<WorkflowExecutionGetRequest> | undefined, b: WorkflowExecutionGetRequest | PlainMessage<WorkflowExecutionGetRequest> | undefined): boolean {
    return proto3.util.equals(WorkflowExecutionGetRequest, a, b);
  }
}

/**
 * A workflow execution represents an instantiated workflow, including all inputs and additional
 * metadata as well as computed results included state, outputs, and duration-based attributes.
 * Used as a response object used in Get and List execution requests.
 *
 * @generated from message flyteidl.admin.Execution
 */
export class Execution extends Message<Execution> {
  /**
   * Unique identifier of the workflow execution.
   *
   * @generated from field: flyteidl.core.WorkflowExecutionIdentifier id = 1;
   */
  id?: WorkflowExecutionIdentifier;

  /**
   * User-provided configuration and inputs for launching the execution.
   *
   * @generated from field: flyteidl.admin.ExecutionSpec spec = 2;
   */
  spec?: ExecutionSpec;

  /**
   * Execution results.
   *
   * @generated from field: flyteidl.admin.ExecutionClosure closure = 3;
   */
  closure?: ExecutionClosure;

  constructor(data?: PartialMessage<Execution>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.Execution";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "message", T: WorkflowExecutionIdentifier },
    { no: 2, name: "spec", kind: "message", T: ExecutionSpec },
    { no: 3, name: "closure", kind: "message", T: ExecutionClosure },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Execution {
    return new Execution().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Execution {
    return new Execution().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Execution {
    return new Execution().fromJsonString(jsonString, options);
  }

  static equals(a: Execution | PlainMessage<Execution> | undefined, b: Execution | PlainMessage<Execution> | undefined): boolean {
    return proto3.util.equals(Execution, a, b);
  }
}

/**
 * Used as a response for request to list executions.
 * See :ref:`ref_flyteidl.admin.Execution` for more details
 *
 * @generated from message flyteidl.admin.ExecutionList
 */
export class ExecutionList extends Message<ExecutionList> {
  /**
   * @generated from field: repeated flyteidl.admin.Execution executions = 1;
   */
  executions: Execution[] = [];

  /**
   * In the case of multiple pages of results, the server-provided token can be used to fetch the next page
   * in a query. If there are no more results, this value will be empty.
   *
   * @generated from field: string token = 2;
   */
  token = "";

  constructor(data?: PartialMessage<ExecutionList>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ExecutionList";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "executions", kind: "message", T: Execution, repeated: true },
    { no: 2, name: "token", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExecutionList {
    return new ExecutionList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExecutionList {
    return new ExecutionList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExecutionList {
    return new ExecutionList().fromJsonString(jsonString, options);
  }

  static equals(a: ExecutionList | PlainMessage<ExecutionList> | undefined, b: ExecutionList | PlainMessage<ExecutionList> | undefined): boolean {
    return proto3.util.equals(ExecutionList, a, b);
  }
}

/**
 * Input/output data can represented by actual values or a link to where values are stored
 *
 * @generated from message flyteidl.admin.LiteralMapBlob
 */
export class LiteralMapBlob extends Message<LiteralMapBlob> {
  /**
   * @generated from oneof flyteidl.admin.LiteralMapBlob.data
   */
  data: {
    /**
     * Data in LiteralMap format
     *
     * @generated from field: flyteidl.core.LiteralMap values = 1 [deprecated = true];
     * @deprecated
     */
    value: LiteralMap;
    case: "values";
  } | {
    /**
     * In the event that the map is too large, we return a uri to the data
     *
     * @generated from field: string uri = 2;
     */
    value: string;
    case: "uri";
  } | { case: undefined; value?: undefined } = { case: undefined };

  constructor(data?: PartialMessage<LiteralMapBlob>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.LiteralMapBlob";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "values", kind: "message", T: LiteralMap, oneof: "data" },
    { no: 2, name: "uri", kind: "scalar", T: 9 /* ScalarType.STRING */, oneof: "data" },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): LiteralMapBlob {
    return new LiteralMapBlob().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): LiteralMapBlob {
    return new LiteralMapBlob().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): LiteralMapBlob {
    return new LiteralMapBlob().fromJsonString(jsonString, options);
  }

  static equals(a: LiteralMapBlob | PlainMessage<LiteralMapBlob> | undefined, b: LiteralMapBlob | PlainMessage<LiteralMapBlob> | undefined): boolean {
    return proto3.util.equals(LiteralMapBlob, a, b);
  }
}

/**
 * Specifies metadata around an aborted workflow execution.
 *
 * @generated from message flyteidl.admin.AbortMetadata
 */
export class AbortMetadata extends Message<AbortMetadata> {
  /**
   * In the case of a user-specified abort, this will pass along the user-supplied cause.
   *
   * @generated from field: string cause = 1;
   */
  cause = "";

  /**
   * Identifies the entity (if any) responsible for terminating the execution
   *
   * @generated from field: string principal = 2;
   */
  principal = "";

  constructor(data?: PartialMessage<AbortMetadata>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.AbortMetadata";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "cause", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "principal", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): AbortMetadata {
    return new AbortMetadata().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): AbortMetadata {
    return new AbortMetadata().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): AbortMetadata {
    return new AbortMetadata().fromJsonString(jsonString, options);
  }

  static equals(a: AbortMetadata | PlainMessage<AbortMetadata> | undefined, b: AbortMetadata | PlainMessage<AbortMetadata> | undefined): boolean {
    return proto3.util.equals(AbortMetadata, a, b);
  }
}

/**
 * Encapsulates the results of the Execution
 *
 * @generated from message flyteidl.admin.ExecutionClosure
 */
export class ExecutionClosure extends Message<ExecutionClosure> {
  /**
   * A result produced by a terminated execution.
   * A pending (non-terminal) execution will not have any output result.
   *
   * @generated from oneof flyteidl.admin.ExecutionClosure.output_result
   */
  outputResult: {
    /**
     * Output URI in the case of a successful execution.
     * DEPRECATED. Use GetExecutionData to fetch output data instead.
     *
     * @generated from field: flyteidl.admin.LiteralMapBlob outputs = 1 [deprecated = true];
     * @deprecated
     */
    value: LiteralMapBlob;
    case: "outputs";
  } | {
    /**
     * Error information in the case of a failed execution.
     *
     * @generated from field: flyteidl.core.ExecutionError error = 2;
     */
    value: ExecutionError;
    case: "error";
  } | {
    /**
     * In the case of a user-specified abort, this will pass along the user-supplied cause.
     *
     * @generated from field: string abort_cause = 10 [deprecated = true];
     * @deprecated
     */
    value: string;
    case: "abortCause";
  } | {
    /**
     * In the case of a user-specified abort, this will pass along the user and their supplied cause.
     *
     * @generated from field: flyteidl.admin.AbortMetadata abort_metadata = 12;
     */
    value: AbortMetadata;
    case: "abortMetadata";
  } | {
    /**
     * Raw output data produced by this execution.
     * DEPRECATED. Use GetExecutionData to fetch output data instead.
     *
     * @generated from field: flyteidl.core.LiteralMap output_data = 13 [deprecated = true];
     * @deprecated
     */
    value: LiteralMap;
    case: "outputData";
  } | { case: undefined; value?: undefined } = { case: undefined };

  /**
   * Inputs computed and passed for execution.
   * computed_inputs depends on inputs in ExecutionSpec, fixed and default inputs in launch plan
   *
   * @generated from field: flyteidl.core.LiteralMap computed_inputs = 3 [deprecated = true];
   * @deprecated
   */
  computedInputs?: LiteralMap;

  /**
   * Most recent recorded phase for the execution.
   *
   * @generated from field: flyteidl.core.WorkflowExecution.Phase phase = 4;
   */
  phase = WorkflowExecution_Phase.UNDEFINED;

  /**
   * Reported time at which the execution began running.
   *
   * @generated from field: google.protobuf.Timestamp started_at = 5;
   */
  startedAt?: Timestamp;

  /**
   * The amount of time the execution spent running.
   *
   * @generated from field: google.protobuf.Duration duration = 6;
   */
  duration?: Duration;

  /**
   * Reported time at which the execution was created.
   *
   * @generated from field: google.protobuf.Timestamp created_at = 7;
   */
  createdAt?: Timestamp;

  /**
   * Reported time at which the execution was last updated.
   *
   * @generated from field: google.protobuf.Timestamp updated_at = 8;
   */
  updatedAt?: Timestamp;

  /**
   * The notification settings to use after merging the CreateExecutionRequest and the launch plan
   * notification settings. An execution launched with notifications will always prefer that definition
   * to notifications defined statically in a launch plan.
   *
   * @generated from field: repeated flyteidl.admin.Notification notifications = 9;
   */
  notifications: Notification[] = [];

  /**
   * Identifies the workflow definition for this execution.
   *
   * @generated from field: flyteidl.core.Identifier workflow_id = 11;
   */
  workflowId?: Identifier;

  /**
   * Provides the details of the last stage change
   *
   * @generated from field: flyteidl.admin.ExecutionStateChangeDetails state_change_details = 14;
   */
  stateChangeDetails?: ExecutionStateChangeDetails;

  constructor(data?: PartialMessage<ExecutionClosure>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ExecutionClosure";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "outputs", kind: "message", T: LiteralMapBlob, oneof: "output_result" },
    { no: 2, name: "error", kind: "message", T: ExecutionError, oneof: "output_result" },
    { no: 10, name: "abort_cause", kind: "scalar", T: 9 /* ScalarType.STRING */, oneof: "output_result" },
    { no: 12, name: "abort_metadata", kind: "message", T: AbortMetadata, oneof: "output_result" },
    { no: 13, name: "output_data", kind: "message", T: LiteralMap, oneof: "output_result" },
    { no: 3, name: "computed_inputs", kind: "message", T: LiteralMap },
    { no: 4, name: "phase", kind: "enum", T: proto3.getEnumType(WorkflowExecution_Phase) },
    { no: 5, name: "started_at", kind: "message", T: Timestamp },
    { no: 6, name: "duration", kind: "message", T: Duration },
    { no: 7, name: "created_at", kind: "message", T: Timestamp },
    { no: 8, name: "updated_at", kind: "message", T: Timestamp },
    { no: 9, name: "notifications", kind: "message", T: Notification, repeated: true },
    { no: 11, name: "workflow_id", kind: "message", T: Identifier },
    { no: 14, name: "state_change_details", kind: "message", T: ExecutionStateChangeDetails },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExecutionClosure {
    return new ExecutionClosure().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExecutionClosure {
    return new ExecutionClosure().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExecutionClosure {
    return new ExecutionClosure().fromJsonString(jsonString, options);
  }

  static equals(a: ExecutionClosure | PlainMessage<ExecutionClosure> | undefined, b: ExecutionClosure | PlainMessage<ExecutionClosure> | undefined): boolean {
    return proto3.util.equals(ExecutionClosure, a, b);
  }
}

/**
 * Represents system, rather than user-facing, metadata about an execution.
 *
 * @generated from message flyteidl.admin.SystemMetadata
 */
export class SystemMetadata extends Message<SystemMetadata> {
  /**
   * Which execution cluster this execution ran on.
   *
   * @generated from field: string execution_cluster = 1;
   */
  executionCluster = "";

  /**
   * Which kubernetes namespace the execution ran under.
   *
   * @generated from field: string namespace = 2;
   */
  namespace = "";

  constructor(data?: PartialMessage<SystemMetadata>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.SystemMetadata";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "execution_cluster", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 2, name: "namespace", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SystemMetadata {
    return new SystemMetadata().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SystemMetadata {
    return new SystemMetadata().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SystemMetadata {
    return new SystemMetadata().fromJsonString(jsonString, options);
  }

  static equals(a: SystemMetadata | PlainMessage<SystemMetadata> | undefined, b: SystemMetadata | PlainMessage<SystemMetadata> | undefined): boolean {
    return proto3.util.equals(SystemMetadata, a, b);
  }
}

/**
 * Represents attributes about an execution which are not required to launch the execution but are useful to record.
 * These attributes are assigned at launch time and do not change.
 *
 * @generated from message flyteidl.admin.ExecutionMetadata
 */
export class ExecutionMetadata extends Message<ExecutionMetadata> {
  /**
   * @generated from field: flyteidl.admin.ExecutionMetadata.ExecutionMode mode = 1;
   */
  mode = ExecutionMetadata_ExecutionMode.MANUAL;

  /**
   * Identifier of the entity that triggered this execution.
   * For systems using back-end authentication any value set here will be discarded in favor of the
   * authenticated user context.
   *
   * @generated from field: string principal = 2;
   */
  principal = "";

  /**
   * Indicates the nestedness of this execution.
   * If a user launches a workflow execution, the default nesting is 0.
   * If this execution further launches a workflow (child workflow), the nesting level is incremented by 0 => 1
   * Generally, if workflow at nesting level k launches a workflow then the child workflow will have
   * nesting = k + 1.
   *
   * @generated from field: uint32 nesting = 3;
   */
  nesting = 0;

  /**
   * For scheduled executions, the requested time for execution for this specific schedule invocation.
   *
   * @generated from field: google.protobuf.Timestamp scheduled_at = 4;
   */
  scheduledAt?: Timestamp;

  /**
   * Which subworkflow node (if any) launched this execution
   *
   * @generated from field: flyteidl.core.NodeExecutionIdentifier parent_node_execution = 5;
   */
  parentNodeExecution?: NodeExecutionIdentifier;

  /**
   * Optional, a reference workflow execution related to this execution.
   * In the case of a relaunch, this references the original workflow execution.
   *
   * @generated from field: flyteidl.core.WorkflowExecutionIdentifier reference_execution = 16;
   */
  referenceExecution?: WorkflowExecutionIdentifier;

  /**
   * Optional, platform-specific metadata about the execution.
   * In this the future this may be gated behind an ACL or some sort of authorization.
   *
   * @generated from field: flyteidl.admin.SystemMetadata system_metadata = 17;
   */
  systemMetadata?: SystemMetadata;

  /**
   * Save a list of the artifacts used in this execution for now. This is a list only rather than a mapping
   * since we don't have a structure to handle nested ones anyways.
   *
   * @generated from field: repeated flyteidl.core.ArtifactID artifact_ids = 18;
   */
  artifactIds: ArtifactID[] = [];

  constructor(data?: PartialMessage<ExecutionMetadata>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ExecutionMetadata";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "mode", kind: "enum", T: proto3.getEnumType(ExecutionMetadata_ExecutionMode) },
    { no: 2, name: "principal", kind: "scalar", T: 9 /* ScalarType.STRING */ },
    { no: 3, name: "nesting", kind: "scalar", T: 13 /* ScalarType.UINT32 */ },
    { no: 4, name: "scheduled_at", kind: "message", T: Timestamp },
    { no: 5, name: "parent_node_execution", kind: "message", T: NodeExecutionIdentifier },
    { no: 16, name: "reference_execution", kind: "message", T: WorkflowExecutionIdentifier },
    { no: 17, name: "system_metadata", kind: "message", T: SystemMetadata },
    { no: 18, name: "artifact_ids", kind: "message", T: ArtifactID, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExecutionMetadata {
    return new ExecutionMetadata().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExecutionMetadata {
    return new ExecutionMetadata().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExecutionMetadata {
    return new ExecutionMetadata().fromJsonString(jsonString, options);
  }

  static equals(a: ExecutionMetadata | PlainMessage<ExecutionMetadata> | undefined, b: ExecutionMetadata | PlainMessage<ExecutionMetadata> | undefined): boolean {
    return proto3.util.equals(ExecutionMetadata, a, b);
  }
}

/**
 * The method by which this execution was launched.
 *
 * @generated from enum flyteidl.admin.ExecutionMetadata.ExecutionMode
 */
export enum ExecutionMetadata_ExecutionMode {
  /**
   * The default execution mode, MANUAL implies that an execution was launched by an individual.
   *
   * @generated from enum value: MANUAL = 0;
   */
  MANUAL = 0,

  /**
   * A schedule triggered this execution launch.
   *
   * @generated from enum value: SCHEDULED = 1;
   */
  SCHEDULED = 1,

  /**
   * A system process was responsible for launching this execution rather an individual.
   *
   * @generated from enum value: SYSTEM = 2;
   */
  SYSTEM = 2,

  /**
   * This execution was launched with identical inputs as a previous execution.
   *
   * @generated from enum value: RELAUNCH = 3;
   */
  RELAUNCH = 3,

  /**
   * This execution was triggered by another execution.
   *
   * @generated from enum value: CHILD_WORKFLOW = 4;
   */
  CHILD_WORKFLOW = 4,

  /**
   * This execution was recovered from another execution.
   *
   * @generated from enum value: RECOVERED = 5;
   */
  RECOVERED = 5,

  /**
   * Execution was kicked off by the artifact trigger system
   *
   * @generated from enum value: TRIGGER = 6;
   */
  TRIGGER = 6,
}
// Retrieve enum metadata with: proto3.getEnumType(ExecutionMetadata_ExecutionMode)
proto3.util.setEnumType(ExecutionMetadata_ExecutionMode, "flyteidl.admin.ExecutionMetadata.ExecutionMode", [
  { no: 0, name: "MANUAL" },
  { no: 1, name: "SCHEDULED" },
  { no: 2, name: "SYSTEM" },
  { no: 3, name: "RELAUNCH" },
  { no: 4, name: "CHILD_WORKFLOW" },
  { no: 5, name: "RECOVERED" },
  { no: 6, name: "TRIGGER" },
]);

/**
 * @generated from message flyteidl.admin.NotificationList
 */
export class NotificationList extends Message<NotificationList> {
  /**
   * @generated from field: repeated flyteidl.admin.Notification notifications = 1;
   */
  notifications: Notification[] = [];

  constructor(data?: PartialMessage<NotificationList>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.NotificationList";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "notifications", kind: "message", T: Notification, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NotificationList {
    return new NotificationList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NotificationList {
    return new NotificationList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NotificationList {
    return new NotificationList().fromJsonString(jsonString, options);
  }

  static equals(a: NotificationList | PlainMessage<NotificationList> | undefined, b: NotificationList | PlainMessage<NotificationList> | undefined): boolean {
    return proto3.util.equals(NotificationList, a, b);
  }
}

/**
 * An ExecutionSpec encompasses all data used to launch this execution. The Spec does not change over the lifetime
 * of an execution as it progresses across phase changes.
 *
 * @generated from message flyteidl.admin.ExecutionSpec
 */
export class ExecutionSpec extends Message<ExecutionSpec> {
  /**
   * Launch plan to be executed
   *
   * @generated from field: flyteidl.core.Identifier launch_plan = 1;
   */
  launchPlan?: Identifier;

  /**
   * Input values to be passed for the execution
   *
   * @generated from field: flyteidl.core.LiteralMap inputs = 2 [deprecated = true];
   * @deprecated
   */
  inputs?: LiteralMap;

  /**
   * Metadata for the execution
   *
   * @generated from field: flyteidl.admin.ExecutionMetadata metadata = 3;
   */
  metadata?: ExecutionMetadata;

  /**
   * @generated from oneof flyteidl.admin.ExecutionSpec.notification_overrides
   */
  notificationOverrides: {
    /**
     * List of notifications based on Execution status transitions
     * When this list is not empty it is used rather than any notifications defined in the referenced launch plan.
     * When this list is empty, the notifications defined for the launch plan will be applied.
     *
     * @generated from field: flyteidl.admin.NotificationList notifications = 5;
     */
    value: NotificationList;
    case: "notifications";
  } | {
    /**
     * This should be set to true if all notifications are intended to be disabled for this execution.
     *
     * @generated from field: bool disable_all = 6;
     */
    value: boolean;
    case: "disableAll";
  } | { case: undefined; value?: undefined } = { case: undefined };

  /**
   * Labels to apply to the execution resource.
   *
   * @generated from field: flyteidl.admin.Labels labels = 7;
   */
  labels?: Labels;

  /**
   * Annotations to apply to the execution resource.
   *
   * @generated from field: flyteidl.admin.Annotations annotations = 8;
   */
  annotations?: Annotations;

  /**
   * Optional: security context override to apply this execution.
   *
   * @generated from field: flyteidl.core.SecurityContext security_context = 10;
   */
  securityContext?: SecurityContext;

  /**
   * Optional: auth override to apply this execution.
   *
   * @generated from field: flyteidl.admin.AuthRole auth_role = 16 [deprecated = true];
   * @deprecated
   */
  authRole?: AuthRole;

  /**
   * Indicates the runtime priority of the execution.
   *
   * @generated from field: flyteidl.core.QualityOfService quality_of_service = 17;
   */
  qualityOfService?: QualityOfService;

  /**
   * Controls the maximum number of task nodes that can be run in parallel for the entire workflow.
   * This is useful to achieve fairness. Note: MapTasks are regarded as one unit,
   * and parallelism/concurrency of MapTasks is independent from this.
   *
   * @generated from field: int32 max_parallelism = 18;
   */
  maxParallelism = 0;

  /**
   * User setting to configure where to store offloaded data (i.e. Blobs, structured datasets, query data, etc.).
   * This should be a prefix like s3://my-bucket/my-data
   *
   * @generated from field: flyteidl.admin.RawOutputDataConfig raw_output_data_config = 19;
   */
  rawOutputDataConfig?: RawOutputDataConfig;

  /**
   * Controls how to select an available cluster on which this execution should run.
   *
   * @generated from field: flyteidl.admin.ClusterAssignment cluster_assignment = 20;
   */
  clusterAssignment?: ClusterAssignment;

  /**
   * Allows for the interruptible flag of a workflow to be overwritten for a single execution.
   * Omitting this field uses the workflow's value as a default.
   * As we need to distinguish between the field not being provided and its default value false, we have to use a wrapper
   * around the bool field.
   *
   * @generated from field: google.protobuf.BoolValue interruptible = 21;
   */
  interruptible?: boolean;

  /**
   * Allows for all cached values of a workflow and its tasks to be overwritten for a single execution.
   * If enabled, all calculations are performed even if cached results would be available, overwriting the stored
   * data once execution finishes successfully.
   *
   * @generated from field: bool overwrite_cache = 22;
   */
  overwriteCache = false;

  /**
   * Environment variables to be set for the execution.
   *
   * @generated from field: flyteidl.admin.Envs envs = 23;
   */
  envs?: Envs;

  /**
   * Tags to be set for the execution.
   *
   * @generated from field: repeated string tags = 24 [deprecated = true];
   * @deprecated
   */
  tags: string[] = [];

  /**
   * Execution cluster label to be set for the execution.
   *
   * @generated from field: flyteidl.admin.ExecutionClusterLabel execution_cluster_label = 25;
   */
  executionClusterLabel?: ExecutionClusterLabel;

  /**
   * Execution environment assignments to be set for the execution.
   *
   * @generated from field: repeated flyteidl.core.ExecutionEnvAssignment execution_env_assignments = 26;
   */
  executionEnvAssignments: ExecutionEnvAssignment[] = [];

  constructor(data?: PartialMessage<ExecutionSpec>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ExecutionSpec";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "launch_plan", kind: "message", T: Identifier },
    { no: 2, name: "inputs", kind: "message", T: LiteralMap },
    { no: 3, name: "metadata", kind: "message", T: ExecutionMetadata },
    { no: 5, name: "notifications", kind: "message", T: NotificationList, oneof: "notification_overrides" },
    { no: 6, name: "disable_all", kind: "scalar", T: 8 /* ScalarType.BOOL */, oneof: "notification_overrides" },
    { no: 7, name: "labels", kind: "message", T: Labels },
    { no: 8, name: "annotations", kind: "message", T: Annotations },
    { no: 10, name: "security_context", kind: "message", T: SecurityContext },
    { no: 16, name: "auth_role", kind: "message", T: AuthRole },
    { no: 17, name: "quality_of_service", kind: "message", T: QualityOfService },
    { no: 18, name: "max_parallelism", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
    { no: 19, name: "raw_output_data_config", kind: "message", T: RawOutputDataConfig },
    { no: 20, name: "cluster_assignment", kind: "message", T: ClusterAssignment },
    { no: 21, name: "interruptible", kind: "message", T: BoolValue },
    { no: 22, name: "overwrite_cache", kind: "scalar", T: 8 /* ScalarType.BOOL */ },
    { no: 23, name: "envs", kind: "message", T: Envs },
    { no: 24, name: "tags", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 25, name: "execution_cluster_label", kind: "message", T: ExecutionClusterLabel },
    { no: 26, name: "execution_env_assignments", kind: "message", T: ExecutionEnvAssignment, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExecutionSpec {
    return new ExecutionSpec().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExecutionSpec {
    return new ExecutionSpec().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExecutionSpec {
    return new ExecutionSpec().fromJsonString(jsonString, options);
  }

  static equals(a: ExecutionSpec | PlainMessage<ExecutionSpec> | undefined, b: ExecutionSpec | PlainMessage<ExecutionSpec> | undefined): boolean {
    return proto3.util.equals(ExecutionSpec, a, b);
  }
}

/**
 * Request to terminate an in-progress execution.  This action is irreversible.
 * If an execution is already terminated, this request will simply be a no-op.
 * This request will fail if it references a non-existent execution.
 * If the request succeeds the phase "ABORTED" will be recorded for the termination
 * with the optional cause added to the output_result.
 *
 * @generated from message flyteidl.admin.ExecutionTerminateRequest
 */
export class ExecutionTerminateRequest extends Message<ExecutionTerminateRequest> {
  /**
   * Uniquely identifies the individual workflow execution to be terminated.
   *
   * @generated from field: flyteidl.core.WorkflowExecutionIdentifier id = 1;
   */
  id?: WorkflowExecutionIdentifier;

  /**
   * Optional reason for aborting.
   *
   * @generated from field: string cause = 2;
   */
  cause = "";

  constructor(data?: PartialMessage<ExecutionTerminateRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ExecutionTerminateRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "message", T: WorkflowExecutionIdentifier },
    { no: 2, name: "cause", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExecutionTerminateRequest {
    return new ExecutionTerminateRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExecutionTerminateRequest {
    return new ExecutionTerminateRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExecutionTerminateRequest {
    return new ExecutionTerminateRequest().fromJsonString(jsonString, options);
  }

  static equals(a: ExecutionTerminateRequest | PlainMessage<ExecutionTerminateRequest> | undefined, b: ExecutionTerminateRequest | PlainMessage<ExecutionTerminateRequest> | undefined): boolean {
    return proto3.util.equals(ExecutionTerminateRequest, a, b);
  }
}

/**
 * Purposefully empty, may be populated in the future.
 *
 * @generated from message flyteidl.admin.ExecutionTerminateResponse
 */
export class ExecutionTerminateResponse extends Message<ExecutionTerminateResponse> {
  constructor(data?: PartialMessage<ExecutionTerminateResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ExecutionTerminateResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExecutionTerminateResponse {
    return new ExecutionTerminateResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExecutionTerminateResponse {
    return new ExecutionTerminateResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExecutionTerminateResponse {
    return new ExecutionTerminateResponse().fromJsonString(jsonString, options);
  }

  static equals(a: ExecutionTerminateResponse | PlainMessage<ExecutionTerminateResponse> | undefined, b: ExecutionTerminateResponse | PlainMessage<ExecutionTerminateResponse> | undefined): boolean {
    return proto3.util.equals(ExecutionTerminateResponse, a, b);
  }
}

/**
 * Request structure to fetch inputs, output and other data produced by an execution.
 * By default this data is not returned inline in :ref:`ref_flyteidl.admin.WorkflowExecutionGetRequest`
 *
 * @generated from message flyteidl.admin.WorkflowExecutionGetDataRequest
 */
export class WorkflowExecutionGetDataRequest extends Message<WorkflowExecutionGetDataRequest> {
  /**
   * The identifier of the execution for which to fetch inputs and outputs.
   *
   * @generated from field: flyteidl.core.WorkflowExecutionIdentifier id = 1;
   */
  id?: WorkflowExecutionIdentifier;

  constructor(data?: PartialMessage<WorkflowExecutionGetDataRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.WorkflowExecutionGetDataRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "message", T: WorkflowExecutionIdentifier },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): WorkflowExecutionGetDataRequest {
    return new WorkflowExecutionGetDataRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): WorkflowExecutionGetDataRequest {
    return new WorkflowExecutionGetDataRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): WorkflowExecutionGetDataRequest {
    return new WorkflowExecutionGetDataRequest().fromJsonString(jsonString, options);
  }

  static equals(a: WorkflowExecutionGetDataRequest | PlainMessage<WorkflowExecutionGetDataRequest> | undefined, b: WorkflowExecutionGetDataRequest | PlainMessage<WorkflowExecutionGetDataRequest> | undefined): boolean {
    return proto3.util.equals(WorkflowExecutionGetDataRequest, a, b);
  }
}

/**
 * Response structure for WorkflowExecutionGetDataRequest which contains inputs and outputs for an execution.
 *
 * @generated from message flyteidl.admin.WorkflowExecutionGetDataResponse
 */
export class WorkflowExecutionGetDataResponse extends Message<WorkflowExecutionGetDataResponse> {
  /**
   * Signed url to fetch a core.LiteralMap of execution outputs.
   * Deprecated: Please use full_outputs instead.
   *
   * @generated from field: flyteidl.admin.UrlBlob outputs = 1 [deprecated = true];
   * @deprecated
   */
  outputs?: UrlBlob;

  /**
   * Signed url to fetch a core.LiteralMap of execution inputs.
   * Deprecated: Please use full_inputs instead.
   *
   * @generated from field: flyteidl.admin.UrlBlob inputs = 2 [deprecated = true];
   * @deprecated
   */
  inputs?: UrlBlob;

  /**
   * Full_inputs will only be populated if they are under a configured size threshold.
   *
   * @generated from field: flyteidl.core.LiteralMap full_inputs = 3;
   */
  fullInputs?: LiteralMap;

  /**
   * Full_outputs will only be populated if they are under a configured size threshold.
   *
   * @generated from field: flyteidl.core.LiteralMap full_outputs = 4;
   */
  fullOutputs?: LiteralMap;

  constructor(data?: PartialMessage<WorkflowExecutionGetDataResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.WorkflowExecutionGetDataResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "outputs", kind: "message", T: UrlBlob },
    { no: 2, name: "inputs", kind: "message", T: UrlBlob },
    { no: 3, name: "full_inputs", kind: "message", T: LiteralMap },
    { no: 4, name: "full_outputs", kind: "message", T: LiteralMap },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): WorkflowExecutionGetDataResponse {
    return new WorkflowExecutionGetDataResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): WorkflowExecutionGetDataResponse {
    return new WorkflowExecutionGetDataResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): WorkflowExecutionGetDataResponse {
    return new WorkflowExecutionGetDataResponse().fromJsonString(jsonString, options);
  }

  static equals(a: WorkflowExecutionGetDataResponse | PlainMessage<WorkflowExecutionGetDataResponse> | undefined, b: WorkflowExecutionGetDataResponse | PlainMessage<WorkflowExecutionGetDataResponse> | undefined): boolean {
    return proto3.util.equals(WorkflowExecutionGetDataResponse, a, b);
  }
}

/**
 * @generated from message flyteidl.admin.ExecutionUpdateRequest
 */
export class ExecutionUpdateRequest extends Message<ExecutionUpdateRequest> {
  /**
   * Identifier of the execution to update
   *
   * @generated from field: flyteidl.core.WorkflowExecutionIdentifier id = 1;
   */
  id?: WorkflowExecutionIdentifier;

  /**
   * State to set as the new value active/archive
   *
   * @generated from field: flyteidl.admin.ExecutionState state = 2;
   */
  state = ExecutionState.EXECUTION_ACTIVE;

  constructor(data?: PartialMessage<ExecutionUpdateRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ExecutionUpdateRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "message", T: WorkflowExecutionIdentifier },
    { no: 2, name: "state", kind: "enum", T: proto3.getEnumType(ExecutionState) },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExecutionUpdateRequest {
    return new ExecutionUpdateRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExecutionUpdateRequest {
    return new ExecutionUpdateRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExecutionUpdateRequest {
    return new ExecutionUpdateRequest().fromJsonString(jsonString, options);
  }

  static equals(a: ExecutionUpdateRequest | PlainMessage<ExecutionUpdateRequest> | undefined, b: ExecutionUpdateRequest | PlainMessage<ExecutionUpdateRequest> | undefined): boolean {
    return proto3.util.equals(ExecutionUpdateRequest, a, b);
  }
}

/**
 * @generated from message flyteidl.admin.ExecutionStateChangeDetails
 */
export class ExecutionStateChangeDetails extends Message<ExecutionStateChangeDetails> {
  /**
   * The state of the execution is used to control its visibility in the UI/CLI.
   *
   * @generated from field: flyteidl.admin.ExecutionState state = 1;
   */
  state = ExecutionState.EXECUTION_ACTIVE;

  /**
   * This timestamp represents when the state changed.
   *
   * @generated from field: google.protobuf.Timestamp occurred_at = 2;
   */
  occurredAt?: Timestamp;

  /**
   * Identifies the entity (if any) responsible for causing the state change of the execution
   *
   * @generated from field: string principal = 3;
   */
  principal = "";

  constructor(data?: PartialMessage<ExecutionStateChangeDetails>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ExecutionStateChangeDetails";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "state", kind: "enum", T: proto3.getEnumType(ExecutionState) },
    { no: 2, name: "occurred_at", kind: "message", T: Timestamp },
    { no: 3, name: "principal", kind: "scalar", T: 9 /* ScalarType.STRING */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExecutionStateChangeDetails {
    return new ExecutionStateChangeDetails().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExecutionStateChangeDetails {
    return new ExecutionStateChangeDetails().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExecutionStateChangeDetails {
    return new ExecutionStateChangeDetails().fromJsonString(jsonString, options);
  }

  static equals(a: ExecutionStateChangeDetails | PlainMessage<ExecutionStateChangeDetails> | undefined, b: ExecutionStateChangeDetails | PlainMessage<ExecutionStateChangeDetails> | undefined): boolean {
    return proto3.util.equals(ExecutionStateChangeDetails, a, b);
  }
}

/**
 * @generated from message flyteidl.admin.ExecutionUpdateResponse
 */
export class ExecutionUpdateResponse extends Message<ExecutionUpdateResponse> {
  constructor(data?: PartialMessage<ExecutionUpdateResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.ExecutionUpdateResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExecutionUpdateResponse {
    return new ExecutionUpdateResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExecutionUpdateResponse {
    return new ExecutionUpdateResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExecutionUpdateResponse {
    return new ExecutionUpdateResponse().fromJsonString(jsonString, options);
  }

  static equals(a: ExecutionUpdateResponse | PlainMessage<ExecutionUpdateResponse> | undefined, b: ExecutionUpdateResponse | PlainMessage<ExecutionUpdateResponse> | undefined): boolean {
    return proto3.util.equals(ExecutionUpdateResponse, a, b);
  }
}

/**
 * WorkflowExecutionGetMetricsRequest represents a request to retrieve metrics for the specified workflow execution.
 *
 * @generated from message flyteidl.admin.WorkflowExecutionGetMetricsRequest
 */
export class WorkflowExecutionGetMetricsRequest extends Message<WorkflowExecutionGetMetricsRequest> {
  /**
   * id defines the workflow execution to query for.
   *
   * @generated from field: flyteidl.core.WorkflowExecutionIdentifier id = 1;
   */
  id?: WorkflowExecutionIdentifier;

  /**
   * depth defines the number of Flyte entity levels to traverse when breaking down execution details.
   *
   * @generated from field: int32 depth = 2;
   */
  depth = 0;

  constructor(data?: PartialMessage<WorkflowExecutionGetMetricsRequest>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.WorkflowExecutionGetMetricsRequest";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "id", kind: "message", T: WorkflowExecutionIdentifier },
    { no: 2, name: "depth", kind: "scalar", T: 5 /* ScalarType.INT32 */ },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): WorkflowExecutionGetMetricsRequest {
    return new WorkflowExecutionGetMetricsRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): WorkflowExecutionGetMetricsRequest {
    return new WorkflowExecutionGetMetricsRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): WorkflowExecutionGetMetricsRequest {
    return new WorkflowExecutionGetMetricsRequest().fromJsonString(jsonString, options);
  }

  static equals(a: WorkflowExecutionGetMetricsRequest | PlainMessage<WorkflowExecutionGetMetricsRequest> | undefined, b: WorkflowExecutionGetMetricsRequest | PlainMessage<WorkflowExecutionGetMetricsRequest> | undefined): boolean {
    return proto3.util.equals(WorkflowExecutionGetMetricsRequest, a, b);
  }
}

/**
 * WorkflowExecutionGetMetricsResponse represents the response containing metrics for the specified workflow execution.
 *
 * @generated from message flyteidl.admin.WorkflowExecutionGetMetricsResponse
 */
export class WorkflowExecutionGetMetricsResponse extends Message<WorkflowExecutionGetMetricsResponse> {
  /**
   * Span defines the top-level breakdown of the workflows execution. More precise information is nested in a
   * hierarchical structure using Flyte entity references.
   *
   * @generated from field: flyteidl.core.Span span = 1;
   */
  span?: Span;

  constructor(data?: PartialMessage<WorkflowExecutionGetMetricsResponse>) {
    super();
    proto3.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto3 = proto3;
  static readonly typeName = "flyteidl.admin.WorkflowExecutionGetMetricsResponse";
  static readonly fields: FieldList = proto3.util.newFieldList(() => [
    { no: 1, name: "span", kind: "message", T: Span },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): WorkflowExecutionGetMetricsResponse {
    return new WorkflowExecutionGetMetricsResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): WorkflowExecutionGetMetricsResponse {
    return new WorkflowExecutionGetMetricsResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): WorkflowExecutionGetMetricsResponse {
    return new WorkflowExecutionGetMetricsResponse().fromJsonString(jsonString, options);
  }

  static equals(a: WorkflowExecutionGetMetricsResponse | PlainMessage<WorkflowExecutionGetMetricsResponse> | undefined, b: WorkflowExecutionGetMetricsResponse | PlainMessage<WorkflowExecutionGetMetricsResponse> | undefined): boolean {
    return proto3.util.equals(WorkflowExecutionGetMetricsResponse, a, b);
  }
}

